--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

fn DYNFUNdnListViewStyle FUNdnList FUNcheckBoxes FUNgridLines =
(
  FUNdnList.View           = (dotNetClass "System.Windows.Forms.View").Details
  FUNdnList.fullRowSelect  = true
  FUNdnList.checkboxes     = FUNcheckBoxes
  FUNdnList.hotTracking    = false
  FUNdnList.gridLines      = false
  FUNdnList.HoverSelection = false
  FUNdnList.hideSelection  = false
  FUNdnList.multiSelect    = true
  FUNdnList.backColor      = DYNFUNdnColor (((colorMan.getColor #window) as color) * 255)
  FUNdnList.foreColor      = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
)

fn DYNFUNdnStatusBarStyle FUNdnStatusBar =
(
  FUNdnStatusBar.backcolor = DYNFUNdnColor (((colorMan.getColor #background) as color) * 255)
  FUNdnStatusBar.foreColor = DYNFUNdnColor (((colorMan.getColor #text) as color) * 255)
)


fn DYNFUNformatValueToString FUNstringTemplate FUNvalue =
(
  /*
  FUNstringTemplate must contain one "%" symbol, which will be substituted with FUNvalue and output as the return value.
  */
  local LOCoutputString = FUNstringTemplate
  local LOCcheckArray   = filterString FUNstringTemplate "%" splitEmptyTokens:true

  if LOCcheckArray.count == 2 then
  (
    local LOCstringStream = stringStream ""
    format FUNstringTemplate (FUNvalue as string) to:LOCstringStream
    LOCoutputString = LOCstringStream as string
  )

  return LOCoutputString
)


fn DYNFUNshowTextureMap FUNmat FUNmatID FUNincludeOpacity FUNonOff =
(
  if FUNincludeOpacity then
  (
    if ClassOf FUNmat.materialList[FUNmatID] == Arch___Design__mi then (showTextureMap FUNmat FUNmat.materialList[FUNmatID] FUNonOff)
    if ClassOf FUNmat.materialList[FUNmatID] == StandardMaterial  then (showTextureMap FUNmat FUNmat.materialList[FUNmatID] FUNonOff)
    if ClassOf FUNmat.materialList[FUNmatID] == DoubleSided       then
    (
      if classOf FUNmat.materialList[FUNmatID].material1 == Arch___Design__mi then (showTextureMap FUNmat.materialList[FUNmatID] FUNmat.materialList[FUNmatID].material1 FUNonOff)
      if ClassOf FUNmat.materialList[FUNmatID].material1 == StandardMaterial  then (showTextureMap FUNmat.materialList[FUNmatID] FUNmat.materialList[FUNmatID].material1 FUNonOff)
    )
  )
  else
  (
    if ClassOf FUNmat.materialList[FUNmatID] == Arch___Design__mi then if FUNmat.materialList[FUNmatID].diff_color_map != undefined then (showTextureMap FUNmat.materialList[FUNmatID] FUNmat.materialList[FUNmatID].diff_color_map FUNonOff)
    if ClassOf FUNmat.materialList[FUNmatID] == StandardMaterial  then if FUNmat.materialList[FUNmatID].diffuseMap     != undefined then (showTextureMap FUNmat.materialList[FUNmatID] FUNmat.materialList[FUNmatID].diffuseMap FUNonOff)
    if ClassOf FUNmat.materialList[FUNmatID] == DoubleSided       then
    (
      if classOf FUNmat.materialList[FUNmatID].material1 == Arch___Design__mi then if FUNmat.materialList[FUNmatID].material1.diff_color_map != undefined then (showTextureMap FUNmat.materialList[FUNmatID] FUNmat.materialList[FUNmatID].material1.diff_color_map FUNonOff)
      if ClassOf FUNmat.materialList[FUNmatID].material1 == StandardMaterial  then if FUNmat.materialList[FUNmatID].material1.diffuseMap     != undefined then (showTextureMap FUNmat.materialList[FUNmatID] FUNmat.materialList[FUNmatID].material1.diffuseMap FUNonOff)
    )
  )

  FUNmat
)

fn DYNFUNsetINIpath FUNobjectSwitch FUNmode =
(
  local LOCiniPath = ""
  local LOCrootObjectPath = ""
  if FUNmode == 1 then LOCrootObjectPath = DYNcountryPath
  if FUNmode == 2 then LOCrootObjectPath = rootNode.DYNrootNodeStore.string02
  if FUNmode == 3 then LOCrootObjectPath = DYNINIprivateKitPath

  if FUNobjectSwitch == 1 then LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameVehicles + "\\"
  if FUNobjectSwitch == 2 then LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameFurniture + "\\"
  if FUNobjectSwitch == 3 then LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameTrees + "\\"
  if FUNobjectSwitch == 4 then LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameSigns + "\\"
  if FUNobjectSwitch == 5 then LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameCameras + "\\"
  if FUNobjectSwitch == 6 then LOCiniPath = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNamePrimitives + "\\"

  LOCiniPath -- return value
)

fn DYNFUNiniGetbySectionPair FUNobjectSwitch FUNsection FUNparam FUNvalue FUNmode =
(
  local LOCresult
  local LOCiniPath = DYNFUNsetINIpath FUNobjectSwitch FUNmode
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCresult = DYNdotNetCountryINIbase.GetBySectionPair LOCiniPath FUNsection FUNparam FUNvalue
  )
  else
  (
    if FUNmode == 2 then LOCresult = DYNdotNetProjectINIbase.GetBySectionPair LOCiniPath FUNsection FUNparam FUNvalue
    if FUNmode == 3 then LOCresult = DYNdotNetPrivateINIbase.GetBySectionPair LOCiniPath FUNsection FUNparam FUNvalue
  )
  LOCresult
)

fn DYNFUNiniGetMissingValues FUNobjectSwitch FUNsection FUNparam FUNmode =
(
  local LOCresult
  local LOCiniPath = DYNFUNsetINIpath FUNobjectSwitch FUNmode
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCresult = DYNdotNetCountryINIbase.GetMissingValues LOCiniPath FUNsection FUNparam
  )
  else
  (
    if FUNmode == 2 then LOCresult = DYNdotNetProjectINIbase.GetMissingValues LOCiniPath FUNsection FUNparam
    if FUNmode == 3 then LOCresult = DYNdotNetPrivateINIbase.GetMissingValues LOCiniPath FUNsection FUNparam
  )
  LOCresult
)

fn DYNFUNiniGetBases FUNobjectSwitch FUNmode =
(
  local LOCresult
  local LOCiniPath = DYNFUNsetINIpath FUNobjectSwitch FUNmode
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCresult = DYNdotNetCountryINIbase.getBases LOCiniPath
  )
  else
  (
    if FUNmode == 2 then LOCresult = DYNdotNetProjectINIbase.getBases LOCiniPath
    if FUNmode == 3 then LOCresult = DYNdotNetPrivateINIbase.getBases LOCiniPath
  )
  LOCresult
)

fn DYNFUNiniGetUniqueValues FUNobjectSwitch FUNsection FUNparam FUNmode =
(
  local LOCresult
  local LOCiniPath = DYNFUNsetINIpath FUNobjectSwitch FUNmode
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCresult = DYNdotNetCountryINIbase.GetUniqueValues LOCiniPath FUNsection FUNparam
  )
  else
  (
    if FUNmode == 2 then LOCresult = DYNdotNetProjectINIbase.GetUniqueValues LOCiniPath FUNsection FUNparam
    if FUNmode == 3 then LOCresult = DYNdotNetPrivateINIbase.GetUniqueValues LOCiniPath FUNsection FUNparam
  )
  LOCresult
)

fn DYNFUNiniGetValue FUNfilePath FUNsection FUNparam FUNmode =
(
  local LOCresult

  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCresult = DYNdotNetCountryINIbase.GetValue FUNfilePath FUNsection FUNparam
  )
  else
  (
    if FUNmode == 2 then LOCresult = DYNdotNetProjectINIbase.GetValue FUNfilePath FUNsection FUNparam
    if FUNmode == 3 then LOCresult = DYNdotNetPrivateINIbase.GetValue FUNfilePath FUNsection FUNparam
  )

  /*
  Next line fixes a problem which would occur in DYNFUNobjectINIparams if undefined is
  fed into values which are then converted to floats. Undefined cannot be converted to float in maxscript.
  Forcing this into a null string at this stages forces the value to be converted to 0.0 in the float
  conversion stage. The New dotNet method will return undefined if the parameter was not found.
  */
  if LOCresult == undefined then LOCresult = ""

  LOCresult -- return value
)

fn DYNFUNiniSetValue FUNfilePath FUNsection FUNparam FUNvalue FUNmode =
(
  local LOCrtnVal = false
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCrtnVal = DYNdotNetCountryINIbase.SetValue FUNfilePath FUNsection FUNparam (FUNvalue as string)
  )
  else
  (
    if FUNmode == 2 then LOCrtnVal = DYNdotNetProjectINIbase.SetValue FUNfilePath FUNsection FUNparam (FUNvalue as string)
    if FUNmode == 3 then LOCrtnVal = DYNdotNetPrivateINIbase.SetValue FUNfilePath FUNsection FUNparam (FUNvalue as string)
  )

  if not LOCrtnVal then
  (
    messageBox (DYNuiResourcesErrorsWarnings[109]) title:DYNuiResourcesTitlebars[1]
  )
  else
  (
    setINIsetting FUNfilePath FUNsection FUNparam (FUNvalue as string) -- If buffer update was successful update file itself
  )
)

fn DYNFUNiniRemoveFile FUNfile FUNmode =
(
  if FUNmode != 2 and FUNmode != 3 then
  (
    DYNdotNetCountryINIbase.Remove FUNfile
  )
  else
  (
    if FUNmode == 2 then DYNdotNetProjectINIbase.Remove FUNfile
    if FUNmode == 3 then DYNdotNetPrivateINIbase.Remove FUNfile
  )
)

fn DYNFUNiniRenameFile FUNoldFile FUNnewFile FUNmode =
(
  local LOCrtnParam = false
  local LOCrtnVal   = false
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCrtnVal   = DYNdotNetCountryINIbase.Rename FUNoldFile FUNnewFile -- Set Value in buffers (doesn't update file itself)
  )
  else
  (
    if FUNmode == 2 then LOCrtnVal   = DYNdotNetProjectINIbase.Rename FUNoldFile FUNnewFile -- Set Value in buffers (doesn't update file itself)
    if FUNmode == 3 then LOCrtnVal   = DYNdotNetPrivateINIbase.Rename FUNoldFile FUNnewFile -- Set Value in buffers (doesn't update file itself)
  )

  if not LOCrtnVal then
  (
    messageBox (DYNuiResourcesErrorsWarnings[110]) title:DYNuiResourcesTitlebars[1]
  )
  else (LOCrtnParam = renameFile FUNoldFile FUNnewFile) -- returns true if file was deleted
  LOCrtnParam -- return value
)

fn DYNFUNiniCopyFile FUNoldFile FUNnewFile FUNmode =
(
  local LOCrtnParam = false
  local LOCrtnVal = false
  if FUNmode != 2 and FUNmode != 3 then
  (
    LOCrtnVal = DYNdotNetCountryINIbase.Copy FUNoldFile FUNnewFile
  )
  else
  (
    if FUNmode == 2 then LOCrtnVal = DYNdotNetProjectINIbase.Copy FUNoldFile FUNnewFile
    if FUNmode == 3 then LOCrtnVal = DYNdotNetPrivateINIbase.Copy FUNoldFile FUNnewFile
  )

  if not LOCrtnVal then
  (
    messageBox (DYNuiResourcesErrorsWarnings[111]) title:DYNuiResourcesTitlebars[1]
  )
  else (LOCrtnParam = copyFile FUNoldFile FUNnewFile) -- returns true if file was deleted
  LOCrtnParam -- return value
)

fn DYNFUNgetFileCreationTime FUNfile FUNtype =
(
  /*
    GetTime() - returns time in local time
    GetTime(true) - returns time in DTS
    GetTime(false) - same as GetTime()
  */
  local dts = DYNdotNetFileBase.GetFileCreationTime FUNfile FUNtype

  if dts == undefined do dts = ""
  dts -- return
)

fn DYNFUNgetFileModifyTime FUNfile FUNtype =
(
  /*
    GetTime() - returns time in local time
    GetTime(true) - returns time in DTS
    GetTime(false) - same as GetTime()

    IMPORTANT NOTE: There is a bug in FileUtils.cs relating to "GetFileLastWriteTime"
    which means that the effect of asUtc is inverted.  This means that although
    true is supposed to return time in UTC, it is actually inversed and false returns
    time in UTC.

    Therefore, FUNtype has been inverted here, to correct the error.

    This bug does not affect GetFileCreationTime above.
  */
  local dts = DYNdotNetFileBase.GetFileLastWriteTime FUNfile (not FUNtype)

  if dts == undefined do dts = ""
  dts -- return
)

fn DYNFUNmxTimeToDelimitedTime FUNmxTimeStamp =
(
  local LOCmxTimeStamp       = (if FUNmxTimeStamp < 0 then -FUNmxTimeStamp else FUNmxTimeStamp) as string -- Invert timestamp if value is negative
  local LOCmonthsSince1988   = (subString LOCmxTimeStamp 1 3) as integer
  local LOCtimeOfDayTicks    = (subString LOCmxTimeStamp 6 4) as integer

  --- Get Day Of Month
  local LOCdayOfCurrentMonth = (subString LOCmxTimeStamp 4 2) as integer

  --- Get Months
  local LOCdtsMonths = LOCmonthsSince1988
  while true do (if LOCdtsMonths < 12 then exit else LOCdtsMonths -= 12)

  --- Get Year
  local LOCdtsYear = 1988 + (LOCmonthsSince1988 / 12) + 1

  --- Get Hours
  local LOCdtsHour = LOCtimeOfDayTicks / 360

  --- Get Minutes
  local LOCdtsMinuteOfHour = LOCtimeOfDayTicks
  while true do (if LOCdtsMinuteOfHour < 360 then exit else LOCdtsMinuteOfHour -= 360)

  local LOCdtsMinutes = LOCdtsMinuteOfHour / 6
  while true do (if LOCdtsMinuteOfHour < 6 then exit else LOCdtsMinuteOfHour -= 6)

  --- Get Seconds
  local LOCdtsSeconds = LOCdtsMinuteOfHour * 10

  --- Write to standard Civil View Delimited Date String
  (LOCdayOfCurrentMonth as string) + "$" + (LOCdtsMonths as string) + "$" + (LOCdtsYear as string) + "$" + (LOCdtsHour as string) + "$" + (LOCdtsMinutes as string) + "$" + (LOCdtsSeconds as string) + "$0$0$0"
)

fn DYNFUNgetMxModelFileModelModifyTime FUNfile FUNmodelName =
(
  local LOCdts          = false -- will be returned if date stamp was not found.

  if doesFileExist FUNfile then
  (
    local LOCstream       = fopen FUNfile "rb"

    local LOCchunkChain   = #()
    local LOCcurrentChunk = 1
    local LOCnextChunk    = 0

    while true do
    (
      local LOCoffset = 2000 + (2016 * (LOCcurrentChunk - 1)) -- This offset increases to the right offset with every iteration of the loop
      fseek LOCstream LOCoffset #seek_set                     -- Position the file pointer to the offset we just created
      LOCnextChunk = readlong LOCstream #signed               -- Read a four byte value and return as an Integer [#signed | #unsigned]
      LOCnextChunk = LOCnextChunk
      append LOCchunkChain LOCnextChunk                       -- Append or Add this nextChunk integer value to the growing array
      if LOCnextChunk == 1 then exit                          -- If the nextChunk value is 1, break the infinite loop
      LOCcurrentChunk = LOCnextChunk                          -- The current chunk is now the next chunk
      LOCnextChunk = 0                                        -- next chunk value is reset to 0 (the reset is to avoid a potential issue with the break above).
    )

    for i = 1 to LOCchunkChain.count do
    (
      local LOCoffset     = (2016 * (LOCchunkChain[i] - 1))
      local LOCitemNumber = 0

      while true do
      (
        if LOCitemNumber >= 50 then exit
        fseek LOCstream LOCoffset #seek_set                   -- Position the file pointer to the offset we just created

        local LOCmodelName = ""

        --- Read Bytes and Write To Array
        local LOCbyteArray = #(); LOCbyteArray.count = 32
        for ii = 1 to 32 do
        (
          LOCbyteArray[ii] = readByte LOCstream #signed
        )

        if LOCbyteArray[1] != 0 then
        (
          --- COnvert 32 bytes to 32 length string
          for ii = 1 to LOCbyteArray.count do
          (
            LOCmodelName += bit.IntAsChar LOCbyteArray[ii]
          )

          --- Limit ModelName To 28 Chars
          LOCmodelName = subString LOCmodelName 1 28

          --- If Model Name Matches Requested Model Name Get DTS
          if (striCmp FUNmodelName LOCmodelName) == 0 then
          (
            fseek LOCstream 4 #seek_cur
            local LOCtimeStampInt = readLong LOCstream #signed
            LOCdts = DYNFUNmxTimeToDelimitedTime LOCtimeStampInt
          )
        )

        LOCoffset += 40
        LOCitemNumber += 1
      )
    )

    fclose LOCstream
  )

  LOCdts -- return value
)


--- Function used for calculating traffic based driving direction bearings
fn DYNFUNpickVPbearing =
(
  local LOCangle
  if (querybox (DYNuiResourcesQueries[87]) title:DYNuiResourcesTitlebars[3]) then
  (
    local p1 = pickPoint prompt:(DYNuiResourcesLabels[506] + "\n") snap:#3D
    if p1 != #rightClick and p1 != #escape then
    (
      local p2 = pickPoint prompt:(DYNuiResourcesLabels[507] + "\n") rubberBand:p1 snap:#3D
      if p2 != #rightClick and p2 != #escape then
      (
        LOCangle = acos(dot [0.0,1.0,0.0] (normalize (p2-p1)))
        LOCangle = if (p2 - p1).x < 0.0 then (360.0 - LOCangle) else LOCangle -- return value
      )
    )
    messagebox (DYNuiResourcesErrorsWarnings[112] + " " + (LOCangle as string) + " " + DYNuiResourcesUnitsDistance[14]) title:DYNuiResourcesTitlebars[3] beep:false
  )

  LOCangle -- return value
)

--- Convert angle from ACAD (where East is 0.0 and angles are expressed counterclockwise) to
--- Whole Circle Bearing [WCB] (where North is 0.0 and angles are expressed clockwise)
fn DYNFUNacadBearingToWCB FUNangle =
(
  local LOCwcb = 450.0 - FUNangle
  while LOCwcb > 360.0 do LOCwcb -= 360.0
  LOCwcb -- retun value
)

---Function to split string into Array using FUNdelimitor character such as ","
fn DYNFUNmxOption2array FUNorigString FUNdelimitor =
(
  local TempArray1 = #(0)
  local TempArray2 = #()
  local TempArrayMask = #()
  local TempArray3 = #()
  local MXminorOption

  --- Free Format
  for i = 1 to FUNorigString.count do
  (
    if (substring FUNorigString i 1) == FUNdelimitor then append TempArray1 i
  )
  append TempArray1 (FUNorigString.count + 1)
  for i = 1 to (TempArray1.count - 1) do
  (
    append TempArray2 (substring FUNorigString (TempArray1[i] + 1) ((TempArray1[i + 1] - 1) - TempArray1[i]))
  )
  MXminorOption = TempArray2[1]

  --- Delete Minor Option Reference to leave only variables
  deleteItem TempArray2 1

  --- Check for = signs anywhere in original string and make an array of array items which contain "="
  for i = 1 to TempArray2.count do
  (
    if (findstring TempArray2[i] "=") != undefined then append TempArrayMask i
  )

  for i = 1 to TempArray2.count do
  (
    if (finditem TempArrayMask i) == 0 then
    (
      TempArray3[TempArray3.count + 1] = TempArray2[i]
    )
    else
    (
      local CorrectPosition = (substring TempArray2[i] 1 ((findstring TempArray2[i] "=") - 1)) as integer
      TempArray3[CorrectPosition] = TempArray2[i]
    )
  )
  for i = 1 to TempArray3.count do
  (
    if TempArray3[i] == undefined then TempArray3[i] = "" -- Remove undfined values
    if (findString TempArray3[i] "=") != undefined then
    (
      TempArray3[i] = substring TempArray3[i] ((findString TempArray3[i] "=") + 1) -1
    )
  )
  #(MXminorOption, TempArray3)
)

---Function to strip preceeding and trailing space characters from any string
fn DYNFUNstripStringSpaces FUNstring =
(
  while (substring FUNstring FUNstring.count 1) == " " do                      -- While the last character in the string is a space...
  (
    FUNstring = substring FUNstring 1 (FUNstring.count - 1)                    -- Strip trailing space characters from given STRING
  )
  while (substring FUNstring 1 1) == " " do                                    -- While the first character in the string is a space...
  (
    FUNstring = substring FUNstring 2 -1                                       -- Strip preceeding space characters from given STRING
  )
  FUNstring -- Return NEW value of String
)

fn DYNFUNpickChainage FUNshape FUNspline FUNstartStation =
(
  local LOCstationValue
  if superclassof FUNshape == shape then
  (
    local LOCpoint = pickPoint snap:#3d
    if (classOf LOCpoint == Point3) then -- user entered a point
    (
      local LOCpathParam = nearestPathParam FUNshape FUNspline LOCpoint
      LOCstationValue = (curveLength FUNshape FUNspline) * (pathToLengthParam FUNshape FUNspline LOCpathParam)
      LOCstationValue += FUNstartStation
    )
  )
  LOCstationValue -- return value
)

--- Function to read IO.cfg file which holds info relating to wirecolors and matIDs to be applied to imported shapes and surfaces
fn DYNFUNreadImportColorAndMatIdConfigFile =
(
  local LOCoutArray    = #(#(),#(),#(),#(),#(),#(),#(),#(),#(), #())
  local LOCsearchArray = #("---12dWireExp", "---12dAttExp", "---12dMatExp", "---xmlWireExp", "---xmlAttExp", "---xmlMatExp", "---mxModelWireExp", "---mxModelAttExp", "---mxModelMatExp", "---civil3dWireExp")
  local LOCelemsArray  = #(       4       ,        4      ,        2      ,        4       ,        4      ,        2      ,          4         ,          4        ,          2        ,          4         )

  local LOCuserCfgFile = ""
  local LOCplugCfgDir  = try (getDir #plugCfg) catch (); if LOCplugCfgDir != undefined then (LOCuserCfgFile = LOCplugCfgDir + "\\CivilView.cfg")

  if doesFileExist LOCuserCfgFile then
  (
    local LOCfileStream = openfile LOCuserCfgFile

    for i = 1 to LOCsearchArray.count do
    (
      local LOCpartArray = #()
      local q = skipToString LOCfileStream LOCsearchArray[i] -- find section header. If it does not exist, sub-array returned will be empty


      if q != undefined then -- ensure that header line was found, if not move on to next section header
      (
        if not (eof LOCfileStream) then skipToNextLine LOCfileStream
        if not (eof LOCfileStream) then
        (
          local LOCcurrentLine = readline LOCfileStream -- read line from file

          while (subString LOCcurrentLine 1 3) != "---" do -- if this line is not a section header
          (
            if LOCcurrentLine != "" then
            (
              local LOCfilteredString = filterString LOCcurrentLine "," -- divide the string into an array using a comma delimiter
              if LOCfilteredString.count == LOCelemsArray[i] then -- check that filtered info from line contains correct number of elements
              (
                LOCfilteredString[1] = DYNFUNstripStringSpaces LOCfilteredString[1]
                if LOCelemsArray[i] >= 2 then (LOCfilteredString[2] = DYNFUNstripStringSpaces LOCfilteredString[2]; LOCfilteredString[2] = LOCfilteredString[2] as integer; if (LOCfilteredString[2] == undefined or LOCfilteredString[2] == 0) and LOCfilteredString.count == 2 then LOCfilteredString[2] = DYNINIungpMatChan)
                if LOCelemsArray[i] >= 3 then (LOCfilteredString[3] = DYNFUNstripStringSpaces LOCfilteredString[3]; LOCfilteredString[3] = LOCfilteredString[3] as integer)
                if LOCelemsArray[i] >= 4 then (LOCfilteredString[4] = DYNFUNstripStringSpaces LOCfilteredString[4]; LOCfilteredString[4] = LOCfilteredString[4] as integer)
                LOCpartArray += LOCfilteredString
              )
            )

            if eof LOCfileStream then exit          -- break out of "while" loop if end of file is reached
            LOCcurrentLine = readline LOCfileStream -- read the next line

          )
          LOCoutArray[i] = LOCpartArray -- apply read values to main array
        )
      )
      seek LOCfileStream 0 -- return to start of file before looking for next category
    )
    close LOCfileStream
  )
  else
  (
    --- 12d Defaults if no config file is found
    LOCoutArray[1] = #() -- DYN12dWireExp (not used)
    LOCoutArray[2] = #("\bdark\b.*\bred\b", 134, 6, 6, "\bdark\b.*\bgreen\b", 6, 134, 6, "\bdark\b.*\bblue\b", 8, 61, 138, "\bdark\b.*\bcyan\b", 6, 134, 113, -- DYN12dAttExp
              "\bdark\b.*\bmagenta\b", 177, 26, 88, "\bdark\b.*\byellow\b", 134, 110, 8, "\bdark\b.*\bpurple\b", 85, 28, 177, "\bdark\b.*\b(orange|brown)\b", 177, 88, 26,
              "\bdark\b.*\bgr[ae]y\b", 55, 55, 55, "\b(light|off)\b.*\bred\b", 227, 152, 152, "\b(light|off)\b.*\bgreen\b", 153, 228, 153, "\b(light|off)\b.*\bblue\b", 154, 185, 229,
              "\b(light|off)\b.*\bcyan\b", 153, 228, 214, "\b(light|off)\b.*\bmagenta\b", 229, 154, 215, "\b(light|off)\b.*\byellow\b", 228, 214, 153, "\b(light|off)\b.*\bpurple\b", 184, 155, 229,
              "\b(light|off)\b.*\borange\b", 228, 184, 153, "\b(light|off)\b.*\bbrown\b", 85, 28, 177, "\b(light|off)\b.*\bbgr[ae]y\b", 190, 190, 190, "\bred\b", 224, 86, 86,
              "\bgreen\b", 87, 224, 87, "\bblue\b", 88, 143, 225, "\bcyan\b", 87, 224, 198, "\bmagenta\b", 224, 87, 143, "\byellow\b", 224, 198, 87, "\bpurple\b", 140, 88, 225,
              "\borange\b", 85, 28, 177, "\bbrown\b", 224, 143, 87, "\bwhite\b", 230, 230, 230, "\bgr[ae]y\b", 65, 65, 65, ".*", 200, 200, 100)
    LOCoutArray[3] = #("\bred\b"     , 19 , "\bgreen\b"    , 27, "\bblue\b"     , 20, "\bcyan\b"   , 21, "\bmagenta\b", 23,
                       "\byellow\b"  , 31 , "\bpurple\b"   , 24, "\borange\b"   , 26, "\bbrown\b"  , 28, "\bwhite\b"  , 25,
                       "\bgr[ae]y\b" , 22 , "\bconcrete1\b", 22, "\bconcrete2\b", 22, "\basphalt\b", 18, "\bbitumen\b", 18,
                       "\bShoulder\b", 7  , "\bPaving\b"   , 23, "\bgrass1\b"   , 26, "\bgrass2\b" , 27, "\bgrass3\b" , 28,
                       "\bgrass4\b"  , 31 , "\bgrass5\b"   , 34, "\bwater1\b"   , 20, "\bwater2\b" , 21, "\bsand1\b"  , 28,
                       "\bsand2\b"   , 28 , "\bdirt1\b"    , 27, "\bdirt2\b"    , 27, "\brock1\b"  , 34, "\brock2\b"  , 34,
                       "\bstone1\b"  , 32 , "\bstone2\b"   , 32, ".*", DYNINIungpMatChan)  -- DYN12dMatExp

    --- XML Defaults if no config file is found
    LOCoutArray[4] = #("^[Aa].*", 255, 255, 0, "^[Bb].*", 0, 255, 0, "^[Mm].*", 255, 0, 0, "^[Tt].*", 50, 135, 50, ".*", 230, 80, 130) -- DYNxmlWireExp
    LOCoutArray[5] = #() -- DYNxmlAttExp (not used)
    LOCoutArray[6] = #( "\w{2}01", 01, "\w{2}02", 02, "\w{2}03", 03, "\w{2}04", 04, "\w{2}05", 05, "\w{2}06", 06, "\w{2}07", 07, "\w{2}08", 08, "\w{2}09", 09, "\w{2}10", 10, -- DYNxmlMatExp
                        "\w{2}11", 11, "\w{2}12", 12, "\w{2}13", 13, "\w{2}14", 14, "\w{2}15", 15, "\w{2}16", 16, "\w{2}17", 17, "\w{2}18", 18,
                        "\w{2}19", 19, "\w{2}20", 20, "\w{2}21", 21, "\w{2}22", 22, "\w{2}23", 23, "\w{2}24", 24, "\w{2}25", 25, "\w{2}26", 26,
                        "\w{2}27", 27, "\w{2}28", 28, "\w{2}29", 29, "\w{2}30", 30, "\w{2}31", 31, "\w{2}32", 32, "\w{2}33", 33, "\w{2}34", 34,
                        "\w{2}35", 35, "\w{2}36", 36, "\w{2}37", 37, "\w{2}38", 38, "\w{2}39", 39, "\w{2}40", 40, "\w{2}41", 41, "\w{2}42", 42,
                        "\w{2}43", 43, "\w{2}44", 44, "\w{2}45", 45, "\w{2}46", 46, "\w{2}47", 47, "\w{2}48", 48, "\w{2}49", 49, "\w{2}50", 50,
                        "\w{2}51", 51, "\w{2}52", 52, "\w{2}53", 53, "\w{2}54", 54, "\w{2}55", 55, "\w{2}56", 56, "\w{2}57", 57, "\w{2}58", 58,
                        "\w{2}59", 59, "\w{2}60", 60, "\w{2}61", 61, "\w{2}62", 62, "\w{2}63", 63, "\w{2}64", 64, "\w{2}65", 65, "\w{2}66", 66,
                        "\w{2}67", 67, "\w{2}68", 68, "\w{2}69", 69, "\w{2}70", 70, "\w{2}71", 71, "\w{2}72", 72, "\w{2}73", 73, "\w{2}74", 74,
                        "\w{2}75", 75, "\w{2}76", 76, "\w{2}77", 77, "\w{2}78", 78, "\w{2}79", 79, "\w{2}80", 80, "\w{2}81", 81, "\w{2}82", 82,
                        "\w{2}83", 83, "\w{2}84", 84, "\w{2}85", 85, "\w{2}86", 86, "\w{2}87", 87, "\w{2}88", 88, "\w{2}89", 89, "\w{2}90", 90,
                        "\w{2}91", 91, "\w{2}92", 92, "\w{2}93", 93, "\w{2}94", 94, "\w{2}95", 95, "\w{2}96", 96, "\w{2}97", 97, "\w{2}98", 98,
                        "\w{2}99", 99, ".*", DYNINIungpMatChan)

    --- MX Defaults if no config file is found
    LOCoutArray[7] = #("^[Aa].*", 255, 255, 0, "^[Bb].*", 0, 255, 0, "^[Mm].*", 255, 0, 0, "^[Tt].*", 50, 135, 50, ".*", 230, 80, 130) -- DYNmxModelWireExp
    LOCoutArray[8] = #() -- DYNmxModelAttExp (not used)
    LOCoutArray[9] = #("\w{2}01", 01, "\w{2}02", 02, "\w{2}03", 03, "\w{2}04", 04, "\w{2}05", 05, "\w{2}06", 06, "\w{2}07", 07, "\w{2}08", 08, "\w{2}09", 09, "\w{2}10", 10, -- DYNmxModelMatExp
        "\w{2}11", 11, "\w{2}12", 12, "\w{2}13", 13, "\w{2}14", 14, "\w{2}15", 15, "\w{2}16", 16, "\w{2}17", 17, "\w{2}18", 18, "\w{2}19", 19,
        "\w{2}20", 20, "\w{2}21", 21, "\w{2}22", 22, "\w{2}23", 23, "\w{2}24", 24, "\w{2}25", 25, "\w{2}26", 26, "\w{2}27", 27, "\w{2}28", 28,
        "\w{2}29", 29, "\w{2}30", 30, "\w{2}31", 31, "\w{2}32", 32, "\w{2}33", 33, "\w{2}34", 34, "\w{2}35", 35, "\w{2}36", 36, "\w{2}37", 37,
        "\w{2}38", 38, "\w{2}39", 39, "\w{2}40", 40, "\w{2}41", 41, "\w{2}42", 42, "\w{2}43", 43, "\w{2}44", 44, "\w{2}45", 45, "\w{2}46", 46,
        "\w{2}47", 47, "\w{2}48", 48, "\w{2}49", 49, "\w{2}50", 50, "\w{2}51", 51, "\w{2}52", 52, "\w{2}53", 53, "\w{2}54", 54, "\w{2}55", 55,
        "\w{2}56", 56, "\w{2}57", 57, "\w{2}58", 58, "\w{2}59", 59, "\w{2}60", 60, "\w{2}61", 61, "\w{2}62", 62, "\w{2}63", 63, "\w{2}64", 64,
        "\w{2}65", 65, "\w{2}66", 66, "\w{2}67", 67, "\w{2}68", 68, "\w{2}69", 69, "\w{2}70", 70, "\w{2}71", 71, "\w{2}72", 72, "\w{2}73", 73,
        "\w{2}74", 74, "\w{2}75", 75, "\w{2}76", 76, "\w{2}77", 77, "\w{2}78", 78, "\w{2}79", 79, "\w{2}80", 80, "\w{2}81", 81, "\w{2}82", 82,
        "\w{2}83", 83, "\w{2}84", 84, "\w{2}85", 85, "\w{2}86", 86, "\w{2}87", 87, "\w{2}88", 88, "\w{2}89", 89, "\w{2}90", 90, "\w{2}91", 91,
        "\w{2}92", 92, "\w{2}93", 93, "\w{2}94", 94, "\w{2}95", 95, "\w{2}96", 96, "\w{2}97", 97, "\w{2}98", 98, "\w{2}99", 99, ".*", DYNINIungpMatChan)
    LOCoutArray[10] = #("\bditch\b", 175, 150,  25, "\bdaylight\b", 145, 225,  90, "\bcurb\b", 255, 250,  50, "\bkerb\b", 255, 250,  50, "\bpave\b", 155, 155, 230, "\bcycle\b", 225,  85, 145, "\bsidew\b", 90, 200, 225, ".*", 230, 80, 130) -- DYNcivil3dWireExp
  )

  DYN12dWireExp     = LOCoutArray[1]
  DYN12dAttExp      = LOCoutArray[2]
  DYN12dMatExp      = LOCoutArray[3]
  DYNxmlWireExp     = LOCoutArray[4]
  DYNxmlAttExp      = LOCoutArray[5]
  DYNxmlMatExp      = LOCoutArray[6]
  DYNmxModelWireExp = LOCoutArray[7]
  DYNmxModelAttExp  = LOCoutArray[8]
  DYNmxModelMatExp  = LOCoutArray[9]
  DYNcivil3dWireExp = LOCoutArray[10]

  LOCoutArray -- return value
)

--- Function to Apply/Modify Vertical Shift to Road Markings
fn DYNFUNapplyShift FUNobj FUNoldShift FUNnewShift =
(
  if (CVGetMod FUNobj Civil_View_Road_Marking) == undefined then
  (
    if (CVGetMod FUNobj Civil_View_Spline_to_Mesh) == undefined then
    (
      --- Old Road Marking Type Detected ------------------------------------
      local LOCmarkVchange     = FUNnewShift - FUNoldShift
      FUNobj.objectOffsetPos.z = FUNobj.objectOffsetPos.z + LOCmarkVchange
    )
    else
    (
      --- Chevron Road Marking Type Detected ------------------------------------
      (CVGetMod FUNobj Civil_View_Spline_to_Mesh).offsetz = FUNnewShift
    )
  )
  else
  (
    --- New Road Marking Type Detected ------------------------------------
    (CVGetMod FUNobj Civil_View_Road_Marking).offsetz = FUNnewShift
  )
)

fn DYNFUNobjectINIparams FUNiniFileBaseName FUNobjectSwitch FUNmode =
(
  local LOCoutArray = #()

  local LOCiniPath = DYNFUNsetINIpath FUNobjectSwitch FUNmode
  local LOCiniFile = LOCiniPath + FUNiniFileBaseName + ".ini"

  local LOCrootObjectPath = ""
  if FUNmode == 1 then LOCrootObjectPath = DYNcountryPath       -- Using Country Resource Kit
  if FUNmode == 2 then LOCrootObjectPath = rootNode.DYNrootNodeStore.string02 -- Using Project Resource Kit
  if FUNmode == 3 then LOCrootObjectPath = DYNINIprivateKitPath -- Using Private Resource Kit

  --- Vehicles
  if FUNobjectSwitch == 1 then
  (
    LOCoutArray   = #("",0.0,0.0,0.0,"","","","","","")
    local LOClength  = DYNFUNiniGetValue LOCiniFile "Parameters" "Length" FUNmode; LOCoutArray[2]  = if LOClength as float != undefined then (LOClength as float)
    local LOCwidth   = DYNFUNiniGetValue LOCiniFile "Parameters" "Width" FUNmode ; LOCoutArray[3]  = if LOCwidth  as float != undefined then (LOCwidth  as float)
    local LOCheight  = DYNFUNiniGetValue LOCiniFile "Parameters" "Height" FUNmode; LOCoutArray[4]  = if LOCheight as float != undefined then (LOCheight as float)
    local LOCsource  = DYNFUNiniGetValue LOCiniFile "Object" "Source" FUNmode
    local LOCproxy   = DYNFUNiniGetValue LOCiniFile "Object" "Proxy" FUNmode
    local LOCvpoint  = DYNFUNiniGetValue LOCiniFile "Object" "Preview" FUNmode
    if LOCsource != "" then
    (
      LOCsource = LOCiniPath + LOCsource
      if (stricmp (substring LOCsource (LOCsource.count - 3) -1) ".max") != 0 and (stricmp (substring LOCsource (LOCsource.count - 3) -1) ".mib") != 0 and (stricmp (substring LOCsource (LOCsource.count - 3) -1) ".rpc") != 0 then LOCsource = LOCsource + ".max"
    )
    if LOCproxy != "" then
    (
      LOCproxy = LOCiniPath + LOCproxy
      if (stricmp (substring LOCproxy  (LOCproxy.count - 3) -1) ".mib") != 0 then LOCproxy  = LOCproxy  + ".mib"
    )
    if LOCvpoint != "" then
    (
      LOCvpoint = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNamePreviews + "\\" + LOCvpoint
    )
    if (doesFileExist LOCsource) then (LOCoutArray[5] = LOCsource) else (LOCoutArray[5] = "") -- Return Empty string if file does not exist
    if (doesFileExist LOCproxy)  then (LOCoutArray[6] = LOCproxy)  else (LOCoutArray[6] = "") -- Return Empty string if file does not exist
    if (doesFileExist LOCvpoint) then (LOCoutArray[7] = LOCvpoint) else (LOCoutArray[7] = "") -- Return Empty string if file does not exist
    LOCoutArray[9]   = DYNFUNiniGetValue LOCiniFile "Group" "Name" FUNmode
    LOCoutArray[10]  = LOCiniFile
  )

  --- Furniture
  if FUNobjectSwitch == 2 then
  (
    LOCoutArray   = #(20,0.0,0.0,0.0,"","","","","","")
    local LOCspacing = DYNFUNiniGetValue LOCiniFile "Placement" "DefaultInterval" FUNmode; LOCoutArray[1] = if LOCspacing as integer != undefined then (LOCspacing as integer); if LOCoutArray[1] == 0 then LOCoutArray[1] = 20
    local LOClength  = DYNFUNiniGetValue LOCiniFile "Parameters" "Length" FUNmode        ; LOCoutArray[2] = if LOClength as float    != undefined then (LOClength as float)
    local LOCwidth   = DYNFUNiniGetValue LOCiniFile "Parameters" "Width" FUNmode         ; LOCoutArray[3] = if LOCwidth  as float    != undefined then (LOCwidth  as float)
    local LOCheight  = DYNFUNiniGetValue LOCiniFile "Parameters" "Height" FUNmode        ; LOCoutArray[4] = if LOCheight as float    != undefined then (LOCheight as float)
    local LOCsource  = DYNFUNiniGetValue LOCiniFile "Object" "Source" FUNmode
    local LOCproxy   = DYNFUNiniGetValue LOCiniFile "Object" "Proxy" FUNmode
    local LOCvpoint  = DYNFUNiniGetValue LOCiniFile "Object" "Preview" FUNmode
    if LOCsource != "" and (substring LOCsource (LOCsource.count - 1) -1) != "()" then
    (
      LOCsource = LOCiniPath + LOCsource
      if (stricmp (substring LOCsource (LOCsource.count - 3) -1) ".max") != 0 and (stricmp (substring LOCsource (LOCsource.count - 3) -1) ".mib") != 0 and (stricmp (substring LOCsource (LOCsource.count - 3) -1) ".rpc") != 0 then LOCsource = LOCsource + ".max"
      if (doesFileExist LOCsource) then (LOCoutArray[5] = LOCsource) else (LOCoutArray[5] = "") -- Return Empty string if file does not exist
    )
    if LOCproxy != "" then
    (
      LOCproxy = LOCiniPath + LOCproxy
      if (stricmp (substring LOCproxy  (LOCproxy.count - 3) -1)  ".mib") != 0  then LOCproxy  = LOCproxy  + ".mib"
    )
    if LOCvpoint != "" then
    (
      LOCvpoint = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNamePreviews + "\\" + LOCvpoint
    )
    -- Check whether specified plugin class exists
    if (substring LOCsource (LOCsource.count - 1) -1) == "()" then
    (
      LOCoutArray[5] = if (try (execute ((substring LOCsource 1 (LOCsource.count - 2)) + ".category")) catch()) == undefined then "" else LOCsource
    )
    if (doesFileExist LOCproxy)  then (LOCoutArray[6] = LOCproxy)  else (LOCoutArray[6] = "") -- Return Empty string if file does not exist
    if (doesFileExist LOCvpoint) then (LOCoutArray[7] = LOCvpoint) else (LOCoutArray[7] = "") -- Return Empty string if file does not exist
    LOCoutArray[9]   = DYNFUNiniGetValue LOCiniFile "Group" "Name" FUNmode
    LOCoutArray[10]  = LOCiniFile
  )

  --- Trees
  if FUNobjectSwitch == 3 then
  (
    LOCoutArray   = #(1,0.0,6.0,10.0,"","","","","","")
    local LOCstyle   = DYNFUNiniGetValue LOCiniFile "Tree Defaults" "Style" FUNmode         ; LOCoutArray[1] = if LOCstyle as integer != undefined then (LOCstyle as integer); if LOCoutArray[1] == 0   then LOCoutArray[1] = 1
    local LOCwidth   = DYNFUNiniGetValue LOCiniFile "Parameters" "Width" FUNmode ; LOCoutArray[3] = if LOCwidth  as float != undefined then (LOCwidth  as float); if LOCoutArray[3] == 0.0 then LOCoutArray[3] = 6.0
    local LOCheight  = DYNFUNiniGetValue LOCiniFile "Parameters" "Height" FUNmode ; LOCoutArray[4] = if LOCheight as float != undefined then (LOCheight as float); if LOCoutArray[4] == 0.0 then LOCoutArray[4] = 10.0
    LOCoutArray[5]   = LOCiniFile
    local LOCdiffuseMap = DYNFUNiniGetValue LOCiniFile "Maps" "Diffuse" FUNmode; if LOCdiffuseMap != "" then LOCdiffuseMap = LOCrootObjectPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameTreeMaps + "\\" + LOCdiffuseMap
    local LOCopacityMap = DYNFUNiniGetValue LOCiniFile "Maps" "Opacity" FUNmode; if LOCopacityMap != "" then LOCopacityMap = LOCrootObjectPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameTreeMaps + "\\" + LOCopacityMap
    if (doesFileExist LOCdiffuseMap) then (LOCoutArray[7] = LOCdiffuseMap) else (LOCoutArray[7] = "") -- Return Empty string if file does not exist
    if (doesFileExist LOCopacityMap) then (LOCoutArray[8] = LOCopacityMap) else (LOCoutArray[8] = "") -- Return Empty string if file does not exist
    LOCoutArray[9]   = DYNFUNiniGetValue LOCiniFile "Group" "Name" FUNmode
    LOCoutArray[10]  = LOCiniFile
  )

  ---Signs
  if FUNobjectSwitch == 4 then
  (
    LOCoutArray   = #(1,0.0,1.0,1.0,1,2.0,"","","","")
    local LOCstyle   = DYNFUNiniGetValue LOCiniFile "Sign Defaults" "Style" FUNmode         ; LOCoutArray[1] = if LOCstyle as integer != undefined then (LOCstyle as integer); if LOCoutArray[1] == 0   then LOCoutArray[1] = 1
    local LOCwidth   = DYNFUNiniGetValue LOCiniFile "Parameters" "Width" FUNmode            ; LOCoutArray[3] = if LOCwidth  as float  != undefined then (LOCwidth  as float) ; if LOCoutArray[3] == 0.0 then LOCoutArray[3] = 1.0
    local LOCheight  = DYNFUNiniGetValue LOCiniFile "Parameters" "Height" FUNmode           ; LOCoutArray[4] = if LOCheight as float  != undefined then (LOCheight as float) ; if LOCoutArray[4] == 0.0 then LOCoutArray[4] = 1.0
    local LOCposts   = DYNFUNiniGetValue LOCiniFile "Sign Defaults" "Posts" FUNmode         ; LOCoutArray[5] = if LOCposts as integer != undefined then (LOCposts as integer)
    local LOCclear   = DYNFUNiniGetValue LOCiniFile "Sign Defaults" "GroundClearance" FUNmode; LOCoutArray[6] = if LOCclear as float   != undefined then (LOCclear as float)
    local LOCdiffuseMap = DYNFUNiniGetValue LOCiniFile "Maps" "Diffuse" FUNmode; if LOCdiffuseMap != "" then LOCdiffuseMap = LOCrootObjectPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameSignMaps + "\\" + LOCdiffuseMap
    local LOCopacityMap = DYNFUNiniGetValue LOCiniFile "Maps" "Opacity" FUNmode; if LOCopacityMap != "" then LOCopacityMap = LOCrootObjectPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameSignMaps + "\\" + LOCopacityMap
    if (doesFileExist LOCdiffuseMap) then (LOCoutArray[7] = LOCdiffuseMap) else (LOCoutArray[7] = "") -- Return Empty string if file does not exist
    if (doesFileExist LOCopacityMap) then (LOCoutArray[8] = LOCopacityMap) else (LOCoutArray[8] = "") -- Return Empty string if file does not exist
    LOCoutArray[9]   = DYNFUNiniGetValue LOCiniFile "Group" "Name" FUNmode
    LOCoutArray[10]  = LOCiniFile
  )

  --- Cameras
  if FUNobjectSwitch == 5 then
  (
    LOCoutArray   = #(6,0.0,0.0,0.0,249.0,1249.0,"",49,"","")
    local LOCstyle  = DYNFUNiniGetValue LOCiniFile "Parameters" "Lens" FUNmode           ; LOCoutArray[1] = if LOCstyle as integer != undefined then (LOCstyle as integer); if LOCoutArray[1] == 0   then LOCoutArray[1] = 6
    local LOCnear   = DYNFUNiniGetValue LOCiniFile "Parameters" "EnvironmentNear" FUNmode; LOCoutArray[5] = if LOCnear  as float   != undefined then (LOCnear  as float)  ; if LOCoutArray[5] == 0.0 then LOCoutArray[5] = 249.0
    local LOCfar    = DYNFUNiniGetValue LOCiniFile "Parameters" "EnvironmentFar" FUNmode ; LOCoutArray[6] = if LOCfar   as float   != undefined then (LOCfar   as float)  ; if LOCoutArray[6] == 0.0 then LOCoutArray[6] = 1249.0
    local LOCtarg   = DYNFUNiniGetValue LOCiniFile "Parameters" "TargetLength" FUNmode   ; LOCoutArray[8] = if LOCtarg  as integer != undefined then (LOCtarg  as integer); if LOCoutArray[8] == 0   then LOCoutArray[8] = 49
    LOCoutArray[9]  = DYNFUNiniGetValue LOCiniFile "Group" "Name" FUNmode
    LOCoutArray[10] = LOCiniFile
  )

  --- Primitives
  if FUNobjectSwitch == 6 then
  (
    LOCoutArray   = #("",0.0,0.0,0.0,10,"","","Cylinder","","")
    local LOClength  = DYNFUNiniGetValue LOCiniFile "Parameters" "Length" FUNmode      ; LOCoutArray[2] = if LOClength as float   != undefined then (LOClength as float)
    local LOCwidth   = DYNFUNiniGetValue LOCiniFile "Parameters" "Width" FUNmode       ; LOCoutArray[3] = if LOCwidth  as float   != undefined then (LOCwidth  as float)
    local LOCheight  = DYNFUNiniGetValue LOCiniFile "Parameters" "Height" FUNmode      ; LOCoutArray[4] = if LOCheight as float   != undefined then (LOCheight as float)
    local LOCmatCh   = DYNFUNiniGetValue LOCiniFile "Object" "MaterialChannel" FUNmode ; LOCoutArray[5] = if LOCmatCh  as integer != undefined then (LOCmatCh  as integer); if LOCoutArray[5] == 0 then LOCoutArray[5] = 10
    local LOCvpoint  = DYNFUNiniGetValue LOCiniFile "Object" "Preview" FUNmode
    if LOCvpoint != "" then
    (
      LOCvpoint = LOCrootObjectPath + DYNfolderNameObjLibs + "\\" + DYNfolderNamePreviews + "\\" + LOCvpoint
    )
    if (doesFileExist LOCvpoint) then (LOCoutArray[7] = LOCvpoint) else (LOCoutArray[7] = "") -- Return Empty string if file does not exist
    LOCoutArray[8]   = DYNFUNiniGetValue LOCiniFile "Object" "Primitive" FUNmode; if LOCoutArray[8] == "" then LOCoutArray[7] = "Cylinder"
    LOCoutArray[9]   = DYNFUNiniGetValue LOCiniFile "Group" "Name" FUNmode
    LOCoutArray[10]  = LOCiniFile
  )

  LOCoutArray -- return value
)

fn DYNFUNbuildStdMat FUNmatName FUNambientColor FUNdiffuseColor FUNspecularColor FUNshaderType \
                     FUNdiffuseMap FUNbumpMap FUNcutOutMap FUNdiffuseMapPercent FUNbumpMapPercent FUNmapBlur FUNuseRealWorldScale \
                     FUNspecularPercent FUNglossPercent FUNsoften FUNselfIllumPercent FUNopacityPercent FUNtwoSided FUNwAngle FUNoverrideCutoutMapWithDiffuseAlpha \
                     FUNuTiling FUNvTiling FUNuOffset FUNvOffset FUNdiffuseMixMap FUNdiffuseMixAmount =
(
  local LOCmat           = StandardMaterial()

  LOCmat.name            = FUNmatName
  LOCmat.twoSided        = FUNtwoSided         -- (Two_sided) : boolean
  LOCmat.shaderType      = FUNshaderType       -- (Shader_Type) : integer   -- (0:Anisotropic 1:Blinn, 2:Metal, 3:MultiLayer, 4:Oren-Nayer-Blinn, 5:Phong, 6:Strauss)

  if LOCmat.shaderType != 6 then LOCmat.ambient         = FUNambientColor     -- (Ambient_Color) : RGB color
  LOCmat.diffuse         = FUNdiffuseColor     -- (Diffuse_Color) : RGB color
  if LOCmat.shaderType != 6 then LOCmat.specular        = FUNspecularColor    -- (Specular_Color) : RGB color
  if LOCmat.shaderType != 6 then LOCmat.adLock          = false               -- (Ambient_Diffuse_Lock) : boolean
  if LOCmat.shaderType != 6 then LOCmat.adTextureLock   = true                -- (Ambient_Diffuse_Texture_Lock) : boolean

  if LOCmat.shaderType != 6 then LOCmat.specularLevel   = FUNspecularPercent  -- (Specular_Level) : percent
  LOCmat.glossiness      = FUNglossPercent     -- : percent
  if LOCmat.shaderType != 0 and LOCmat.shaderType != 3 and LOCmat.shaderType != 6 and LOCmat.shaderType != 7 then LOCmat.soften = FUNsoften           -- : float
  if LOCmat.shaderType != 6 then LOCmat.selfIllumAmount = FUNselfIllumPercent -- (Self_Illumination) : percent

  LOCmat.opacity         = FUNopacityPercent   -- : percent

  --- Diffuse Parameters ------------------------------
  if FUNdiffuseMap != undefined and FUNdiffuseMap != "" then
  (
    if FUNdiffuseMixMap == undefined then
    (
      LOCmat.diffuseMap                       = bitmapTexture()
      LOCmat.diffuseMapEnable                 = true
      LOCmat.diffuseMapAmount                 = FUNdiffuseMapPercent -- (alias for mapAmounts[1])
      LOCmat.diffuseMap.fileName              = FUNdiffuseMap
      LOCmat.diffuseMap.name                  = DYNuiResourcesMaterialMaps[10] + (getFileNameFile FUNdiffuseMap)
      LOCmat.diffuseMap.coords.blur           = FUNmapBlur
      LOCmat.diffuseMap.coords.realWorldScale = FUNuseRealWorldScale
      LOCmat.diffuseMap.coords.W_angle        = FUNwAngle
      LOCmat.diffuseMap.coords.U_tiling       = FUNuTiling
      LOCmat.diffuseMap.coords.V_tiling       = FUNvTiling
      LOCmat.diffuseMap.coords.U_Offset       = FUNuOffset
      LOCmat.diffuseMap.coords.V_Offset       = FUNvOffset

      if FUNoverrideCutoutMapWithDiffuseAlpha and LOCmat.diffuseMap.bitmap.hasAlpha then (FUNcutOutMap = FUNdiffuseMap)
    )
    else
    (
      LOCmat.diffuseMap                            = mix()
      LOCmat.diffuseMapEnable                      = true
      LOCmat.diffuseMapAmount                      = FUNdiffuseMapPercent -- (alias for mapAmounts[1])

      LOCmat.diffuseMap.map1                       = bitmapTexture()
      LOCmat.diffuseMap.map1.fileName              = FUNdiffuseMap
      LOCmat.diffuseMap.map1.name                  = DYNuiResourcesMaterialMaps[10] + (getFileNameFile FUNdiffuseMap)
      LOCmat.diffuseMap.map1.coords.blur           = FUNmapBlur
      LOCmat.diffuseMap.map1.coords.realWorldScale = FUNuseRealWorldScale
      LOCmat.diffuseMap.map1.coords.W_angle        = FUNwAngle
      LOCmat.diffuseMap.map1.coords.U_tiling       = FUNuTiling
      LOCmat.diffuseMap.map1.coords.V_tiling       = FUNvTiling
      LOCmat.diffuseMap.map1.coords.U_Offset       = FUNuOffset
      LOCmat.diffuseMap.map1.coords.V_Offset       = FUNvOffset

      LOCmat.diffuseMap.mixAmount                  = FUNdiffuseMixAmount
      LOCmat.diffuseMap.map2                       = FUNdiffuseMixMap

      if FUNoverrideCutoutMapWithDiffuseAlpha and LOCmat.diffuseMap.map1.bitmap.hasAlpha then (FUNcutOutMap = FUNdiffuseMap)
    )
  )

  --- Reflection Parameters ---------------------------
  /*
  LOCmat.reflectionMap (alias for maps[9])
  LOCmat.reflectionMapAmount (alias for mapAmounts[9])
  LOCmat.reflectionMapEnable (alias for mapEnables[9])
  */

  --- Refraction Parameters ---------------------------
  /*
  LOCmat.ior (Index_of_Refraction) : float
  LOCmat.refractionMap (alias for maps[10])
  LOCmat.refractionMapAmount (alias for mapAmounts[10])
  LOCmat.refractionMapEnable (alias for mapEnables[10])
  */

  --- Self Illumination Parameters --------------------
  /*
  LOCmat.useSelfIllumColor (Use_Self_Illum_Color) : boolean
  LOCmat.selfIllumColor (Self_Illum_Color) : RGB color
  LOCmat.selfIllumMap (alias for maps[5])
  LOCmat.selfIllumMapAmount (alias for mapAmounts[5])
  LOCmat.selfIllumMapEnable (alias for mapEnables[5])
  */

  --- Bump Map Parameters -----------------------------
  if FUNbumpMap != undefined and FUNbumpMap != "" then
  (
    LOCmat.bumpMap                       = bitmapTexture()
    LOCmat.bumpMapAmount                 = FUNbumpMapPercent
    LOCmat.bumpMapEnable                 = true
    LOCmat.bumpMap.fileName              = FUNbumpMap
    LOCmat.bumpMap.name                  = DYNuiResourcesMaterialMaps[11] + (getFileNameFile FUNbumpMap)
    LOCmat.bumpMap.coords.blur           = FUNmapBlur
    LOCmat.bumpMap.coords.realWorldScale = FUNuseRealWorldScale
    LOCmat.bumpMap.coords.W_angle        = FUNwAngle
    LOCmat.bumpMap.coords.U_tiling       = FUNuTiling
    LOCmat.bumpMap.coords.V_tiling       = FUNvTiling
    LOCmat.bumpMap.coords.U_Offset       = FUNuOffset
    LOCmat.bumpMap.coords.V_Offset       = FUNvOffset
  )

  --- CutOut Map Parameters ---------------------------
  if FUNcutOutMap != undefined and FUNcutOutMap != "" then
  (
    LOCmat.opacityMap                       = bitmapTexture()
    LOCmat.opacityMapEnable                 = true
    LOCmat.opacityMap.fileName              = FUNcutOutMap
    LOCmat.opacityMap.name                  = DYNuiResourcesMaterialMaps[12] + (getFileNameFile FUNcutOutMap)
    LOCmat.opacityMap.coords.blur           = FUNmapBlur
    LOCmat.opacityMap.coords.realWorldScale = FUNuseRealWorldScale
    LOCmat.opacityMap.coords.W_angle        = FUNwAngle
    LOCmat.opacityMap.coords.U_tiling       = FUNuTiling
    LOCmat.opacityMap.coords.V_tiling       = FUNvTiling
    LOCmat.opacityMap.coords.U_Offset       = FUNuOffset
    LOCmat.opacityMap.coords.V_Offset       = FUNvOffset

    --- If Opacity Map Has Alpha Channel, use that to define opacity, otherwise use RGB
    if LOCmat.opacityMap.bitmap.hasAlpha and (stricmp (getfilenametype LOCmat.opacityMap.bitmap.filename) ".gif") != 0 then
    (
      LOCmat.opacityMap.monoOutput = 1 -- alpha (use intensity of the alpha channel to define opacity)
      LOCmat.opacityMap.RGBoutput  = 1 -- alpha as grey (use alpha channel to display map in viewport)
    )
    else
    (
      LOCmat.opacityMap.monoOutput = 0 -- alpha (use intensity of the alpha channel to define opacity)
      LOCmat.opacityMap.RGBoutput  = 0 -- alpha as grey (use alpha channel to display map in viewport)
    )

    /*
    LOCmat.opacityType (Opacity_Type) : integer
    LOCmat.opacityFallOffType (Falloff_Type) : integer
    LOCmat.opacityFallOff (Falloff) : percent
    */
  )

  --- Other Parameters (Not Used)
  /*
  LOCmat.faceMap       = false              -- (Face_Map) : boolean

  LOCmat.wireSize (Wire_Size) : float
  LOCmat.wireUnits (Wire_Units) : integer
  LOCmat.applyReflectionDimming (Apply_Reflection_Dimming) : boolean
  LOCmat.dimLevel (Dim_Level) : float

  LOCmat.reflectionLevel (Reflection_Level) : float

  LOCmat.ambientMap (alias for maps[0])
  LOCmat.ambientMapAmount (alias for mapAmounts[0])
  LOCmat.ambientMapEnable (alias for mapEnables[0])

  LOCmat.specularLevelMap (alias for maps[3])
  LOCmat.specularLevelMapAmount (alias for mapAmounts[3])
  LOCmat.specularLevelMapEnable (alias for mapEnables[3])
  LOCmat.specularMap (alias for maps[2])
  LOCmat.specularMapAmount (alias for mapAmounts[2])
  LOCmat.specularMapEnable (alias for mapEnables[2])
  LOCmat.bounce (Bounce_Coefficient) : float

  LOCmat.displacementMap (alias for maps[11])
  LOCmat.displacementMapAmount (alias for mapAmounts[11])
  LOCmat.displacementMapEnable (alias for mapEnables[11])

  LOCmat.filterColor (Filter_Color) : RGB color
  LOCmat.filterMap (Filter_Map) : texturemap
  LOCmat.filterMap (alias for maps[7])
  LOCmat.filterMapAmount (alias for mapAmounts[7])
  LOCmat.filterMapEnable (alias for mapEnables[7])

  LOCmat.glossinessMap (alias for maps[4])
  LOCmat.glossinessMapAmount (alias for mapAmounts[4])
  LOCmat.glossinessMapEnable (alias for mapEnables[4])

  LOCmat.staticFriction (Static_Friction) : float
  LOCmat.slidingFriction (Sliding_Friction) : float

  LOCmat.noExposureControl : boolean
  LOCmat.exposureControlInvertSelfIllum : boolean
  LOCmat.exposureControlInvertReflection : boolean
  LOCmat.exposureControlInvertRefraction : boolean

  LOCmat.wire : boolean
  LOCmat.faceted : boolean
  */

  LOCmat -- return value
)

--- Generic Function to Create a Arch&Design Material Based on a few simple maps
fn DYNFUNbuildArchDesignMat FUNmatName FUNdiffuseColor FUNdiffuseMap FUNbumpMap FUNcutOutMap FUNmapBlur FUNuseRealWorldScale \
   FUNdiffuseRough FUNdiffuseWeight FUNreflWeight FUNreflGloss FUNreflSamples FUNmetalReflectSwitch  FUNbumpMapPercent \
   FUNanisoAmount FUNanisoAngle FUNselfIllumSwitch FUNselfIllimAmount FUNselfIllumVisibleInScene FUNselfIllumVisibleInReflections \
   FUNbdrfDeg00 FUNbdrfDeg90 FUNbdrfCurveShape FUNtwoSided FUNwAngle FUNoverrideCutoutMapWithDiffuseAlpha \
   FUNuTiling FUNvTiling FUNuOffset FUNvOffset FUNdiffuseMixMap FUNdiffuseMixAmount =
(
  local LOCmat              = Arch___Design__mi()
  LOCmat.name               = FUNmatName

  LOCmat.opts_backface_cull = not FUNtwoSided        -- (Back_Face_Culling) : boolean

  LOCmat.diff_color         = FUNdiffuseColor        -- (Diffuse) : fRGBA color
  LOCmat.diff_rough         = FUNdiffuseRough        -- (Diffuse_Roughness) : float
  LOCmat.diff_weight        = FUNdiffuseWeight       -- (Diffuse_Weight) : float

  --- Diffuse Map -------------------------------------
  if FUNdiffuseMap != undefined and FUNdiffuseMap != "" then
  (
    if FUNdiffuseMixMap == undefined then
    (
      LOCmat.diff_color_map                            = bitmapTexture()
      LOCmat.diff_color_map_on                         = true

      LOCmat.diff_color_map.fileName                   = FUNdiffuseMap
      LOCmat.diff_color_map.coords.blur                = FUNmapBlur
      LOCmat.diff_color_map.coords.realWorldScale      = FUNuseRealWorldScale
      LOCmat.diff_color_map.coords.W_angle             = FUNwAngle
      LOCmat.diff_color_map.coords.U_tiling            = FUNuTiling
      LOCmat.diff_color_map.coords.V_tiling            = FUNvTiling
      LOCmat.diff_color_map.coords.U_Offset            = FUNuOffset
      LOCmat.diff_color_map.coords.V_Offset            = FUNvOffset
      if FUNoverrideCutoutMapWithDiffuseAlpha and LOCmat.diff_color_map.bitmap.hasAlpha then (FUNcutOutMap = FUNdiffuseMap)
    )
    else
    (
      LOCmat.diff_color_map                            = mix()
      LOCmat.diff_color_map_on                         = true

      LOCmat.diff_color_map.map1                       = bitmapTexture()
      LOCmat.diff_color_map.map1.fileName              = FUNdiffuseMap
      LOCmat.diff_color_map.map1.coords.blur           = FUNmapBlur
      LOCmat.diff_color_map.map1.coords.realWorldScale = FUNuseRealWorldScale
      LOCmat.diff_color_map.map1.coords.W_angle        = FUNwAngle
      LOCmat.diff_color_map.map1.coords.U_tiling       = FUNuTiling
      LOCmat.diff_color_map.map1.coords.V_tiling       = FUNvTiling
      LOCmat.diff_color_map.map1.coords.U_Offset       = FUNuOffset
      LOCmat.diff_color_map.map1.coords.V_Offset       = FUNvOffset
      if FUNoverrideCutoutMapWithDiffuseAlpha and LOCmat.diff_color_map.map1.bitmap.hasAlpha then (FUNcutOutMap = FUNdiffuseMap)

      LOCmat.diff_color_map.mixAmount                  = FUNdiffuseMixAmount
      LOCmat.diff_color_map.map2                       = FUNdiffuseMixMap
    )

    /*
    LOCmat.diff_rough_map (Roughness_Map) : texturemap
    LOCmat.diff_rough_map_on (Roughness_Map_On) : boolean
    */

    /*
    --- General Bitmap Texture Parameters -------------
    .clipu (Clip_U_Offset) : float
    .clipv (Clip_V_Offset) : float
    .clipw (Clip_U_Width) : float
    .cliph (Clip_V_Width) : float
    .jitter (Jitter_Placement) : float
    .useJitter : boolean
    .apply : boolean
    .cropPlace : integer
    .filtering : integer
    .monoOutput : integer
    .rgbOutput : integer
    .alphaSource : integer
    .preMultAlpha : boolean
    .bitmap : bitmap
    .coords (Coordinates) : maxObject
    .output : maxObject
    .fileName (File_Name) : filename
    .startTime : time
    .playBackRate : float
    .endCondition : integer
    .tieTimeToMatIDs (Tie_Time_to_Mat_IDs) : boolean
    */

  )

  --- Reflection Parameters ---------------------------
  LOCmat.refl_weight     = FUNreflWeight         -- (Reflectivity) : float
  LOCmat.refl_gloss      = FUNreflGloss          -- (Reflection_Glossiness) : float
  LOCmat.refl_samples    = FUNreflSamples        -- (Reflection_Samples) : integer
  LOCmat.refl_metal      = FUNmetalReflectSwitch -- (Metallic_Reflections) : boolean

  LOCmat.refl_func_low   = FUNbdrfDeg00          -- (Angular_Function_Low) : float
  LOCmat.refl_func_high  = FUNbdrfDeg90          -- (Angular_Function_High) : float
  LOCmat.refl_func_curve = FUNbdrfCurveShape     -- (Angular_Function_Curve) : float

  /*  (Other Unused Reflection Parameters)
  LOCmat.refl_color (Reflection_Color) : fRGBA color
  LOCmat.refl_interp (Reflection_Interpolation) : boolean
  LOCmat.refl_hlonly (Highlights_Only) : boolean
  LOCmat.refl_falloff_color_map (Reflection_Fade_Color_Map) : texturemap
  LOCmat.refl_color_map (Reflection_Color_Map) : texturemap
  LOCmat.refl_gloss_map (Reflection_Glossiness_Map) : texturemap
  LOCmat.refl_func_fresnel (Angular_Function_Fresnel) : boolean
  LOCmat.refl_falloff_on (Reflection_Max_Dist_On) : boolean
  LOCmat.refl_falloff_dist (Reflection_Max_Dist) : float
  LOCmat.refl_falloff_color_on (Reflection_Max_Dist_Color_On) : boolean
  LOCmat.refl_falloff_color (Reflection_Max_Dist_Color) : fRGBA color
  LOCmat.opts_refl_depth (Reflection_Max_Depth) : integer
  LOCmat.refl_cutoff (Reflection_Cutoff_Threshold) : float
  LOCmat.intr_refl_samples (Reflection__Interpolation_points_to_look_up) : integer
  LOCmat.intr_refl_ddist_on (Use_detail_distance) : boolean
  LOCmat.intr_refl_ddist (Detail_distance) : float
  LOCmat.refl_color_map_on (Reflection_Color_Map_On) : boolean
  LOCmat.refl_gloss_map_on (Reflection_Glossiness_Map_On) : boolean
  LOCmat.refl_falloff_color_map_on (Reflection_Fade_Color_Map_On) : boolean
  */

  --- Refraction Parameters ---------------------------
  /*
  LOCmat.refr_color (Refraction_Color) : fRGBA color
  LOCmat.refr_interp (Refraction_Interpolation) : boolean
  LOCmat.refr_ior (Refraction_IOR) : float
  LOCmat.refr_trans_on (Translucency_On) : boolean
  LOCmat.refr_transc (Translucency_Color) : fRGBA color
  LOCmat.refr_transw (Translulcency_Weight) : float
  LOCmat.refr_color_map (Refraction_Color_Map) : texturemap
  LOCmat.refr_gloss_map (Refraction_Glossiness_Map) : texturemap
  LOCmat.refr_ior_map (IOR_Map) : texturemap
  LOCmat.refr_transc_map (Translucency_Color_Map) : texturemap
  LOCmat.refr_transw_map (Translucency_Weight_Map) : texturemap
  LOCmat.refr_falloff_color_map (Refraction_Fade_Color_Map) : texturemap
  LOCmat.refr_color_map_on (Refraction_Color_Map_On) : boolean
  LOCmat.refr_gloss_map_on (Refraction_Glossiness_Map_On) : boolean
  LOCmat.refr_ior_map_on (IOR_Map_On) : boolean
  LOCmat.refr_transc_map_on (Translucency_Color_Map_On) : boolean
  LOCmat.refr_transw_map_on (Translucency_Weight_Map_On) : boolean
  LOCmat.refr_falloff_color_map_on (Refraction_Fade_Color_Map_On) : boolean
  LOCmat.refr_falloff_on (Refraction_Max_Dist_On) : boolean
  LOCmat.refr_falloff_dist (Refraction_Max_Dist) : float
  LOCmat.refr_falloff_color_on (Refraction_Max_Dist_Color_On) : boolean
  LOCmat.refr_falloff_color (Refraction_Max_Dist_Color) : fRGBA color
  LOCmat.refr_cutoff (Refraction_Cutoff_Threshold) : float
  LOCmat.opts_refr_depth (Refraction_Max_Depth) : integer
  LOCmat.intr_refr_samples (Refraction__Interpolation_points_to_look_up) : integer
  */

  --- Self Illumination Parameters --------------------
  LOCmat.self_illum_on             = FUNselfIllumSwitch               -- (Self_Illumination_On) : boolean
  LOCmat.self_illum_int_arbitrary  = FUNselfIllimAmount               -- (Self_Illumination_Arbitrary_Intensity) : float
  LOCmat.self_illum_in_fg          = FUNselfIllumVisibleInScene       -- (Self_Illumination___visible_to_FG) : boolean
  LOCmat.self_illum_in_reflections = FUNselfIllumVisibleInReflections -- (Self_Illumination___visible_in_Reflections) : boolean
  /*
  LOCmat.self_illum_color_mode (Self_Illumination_Color_Mode) : boolean
  LOCmat.self_illum_int_mode (Self_Illumination_Intensity_Mode) : boolean
  LOCmat.self_illum_color_filter (Filter_Color) : fRGBA color
  LOCmat.self_illum_color_kelvin (Self_Illumination_Color_Kelvin) : float
  LOCmat.self_illum_int_physical (Self_Illumination_Physical_Intensity) : float
  LOCmat.self_illum_map_on : boolean
  LOCmat.self_illum_map (Self_Illumination_Map) : texturemap
  */

  --- Bump Map Parameters -----------------------------
  if FUNbumpMap != undefined and FUNbumpMap != "" then
  (
    LOCmat.bump_map                       = bitmapTexture()
    LOCmat.bump_map_on                    = true
    LOCmat.bump_map_amt                   = FUNbumpMapPercent / 10.0
    LOCmat.bump_map.fileName              = FUNbumpMap
    LOCmat.bump_map.coords.blur           = FUNmapBlur
    LOCmat.bump_map.coords.realWorldScale = FUNuseRealWorldScale
    LOCmat.bump_map.coords.W_angle        = FUNwAngle
    LOCmat.bump_map.coords.U_tiling       = FUNuTiling
    LOCmat.bump_map.coords.V_tiling       = FUNvTiling
    LOCmat.bump_map.coords.U_Offset       = FUNuOffset
    LOCmat.bump_map.coords.V_Offset       = FUNvOffset
  )


  --- CutOut Map Parameters ---------------------------
  if FUNcutOutMap != undefined and FUNcutOutMap != "" then
  (
    LOCmat.cutOut_map                       = bitmapTexture()
    LOCmat.cutout_map_on                    = true
    LOCmat.cutOut_map.fileName              = FUNcutOutMap
    LOCmat.cutOut_map.coords.blur           = FUNmapBlur
    LOCmat.cutOut_map.coords.realWorldScale = FUNuseRealWorldScale
    LOCmat.cutOut_map.coords.W_angle        = FUNwAngle
    LOCmat.cutOut_map.coords.U_tiling       = FUNuTiling
    LOCmat.cutOut_map.coords.V_tiling       = FUNvTiling
    LOCmat.cutOut_map.coords.U_Offset       = FUNuOffset
    LOCmat.cutOut_map.coords.V_Offset       = FUNvOffset

    --- If Opacity Map Has Alpha Channel, use that to define opacity, otherwise use RGB
    if LOCmat.cutOut_map.bitmap.hasAlpha and (stricmp (getfilenametype LOCmat.cutOut_map.bitmap.filename) ".gif") != 0 then
    (
      LOCmat.cutOut_map.monoOutput = 1 -- alpha (use intensity of the alpha channel to define opacity)
      LOCmat.cutOut_map.RGBoutput  = 1 -- alpha as grey (use alpha channel to display map in viewport)
    )
    else
    (
      LOCmat.cutOut_map.monoOutput = 0 -- alpha (use intensity of the alpha channel to define opacity)
      LOCmat.cutOut_map.RGBoutput  = 0 -- alpha as grey (use alpha channel to display map in viewport)
    )
  )

  --- Anisotropy --------------------------------------
  LOCmat.anisotropy  = FUNanisoAmount--  : float
  LOCmat.anisoangle  = FUNanisoAngle -- (Anisotropy_Angle) : float
  /*
  LOCmat.anisotropy_map_on : boolean
  LOCmat.anisoangle_map_on (Anisotropy_Angle_Map_On) : boolean
  LOCmat.aniso_mode (Anisotropy_Mode) : integer
  LOCmat.aniso_channel (Anisotropy_Channel) : integer
  LOCmat.anisotropy_map : texturemap
  LOCmat.anisoangle_map (Anisotropy_Angle_Map) : texturemap
  */


  /*  (Other Unused Map Types)
  LOCmat.displacement_map : texturemap
  LOCmat.environment_map : texturemap
  LOCmat.add_color_map (Additional_Color_Map) : texturemap
  LOCmat.radius_map : texturemap
  LOCmat.indirect_multiplier_map (FG_Multiplier_Map) : texturemap
  LOCmat.fg_quality_map : texturemap
  LOCmat.ao_dark_map (AO_Shadow_Color_Map) : texturemap
  LOCmat.ao_ambient_map (AO_Ambient_Light_Color_Map) : texturemap

  LOCmat.indirect_multiplier_map_on (FG_Multiplier_Map_On) : boolean
  LOCmat.fg_quality_map_on : boolean
  LOCmat.ao_dark_map_on (AO_Shadow_Color_Map_On) : boolean
  LOCmat.ao_ambient_map_on (AO_Ambient_Light_Color_Map_On) : boolean
  LOCmat.displacement_map_on : boolean
  LOCmat.environment_map_on : boolean
  LOCmat.add_color_map_on (Additional_Color_Map_On) : boolean
  LOCmat.radius_map_on : boolean
  LOCmat.fg_quality_map_amt (FG_Quality_Map_Amount) : float
  LOCmat.displacement_map_amt (Displacement_Map_Amount) : float
  */

  /*  (Other Unused Parameters)
  LOCmat.opts_indirect_multiplier (Indirect_Multiplier) : float
  LOCmat.opts_fg_quality (FG_Quality) : float
  LOCmat.inter_density (Interpolation_Density) : integer
  LOCmat.single_env_sample (Single_Environment_Sample) : boolean
  LOCmat.opts_round_corners_on (Round_Corners_On) : boolean
  LOCmat.opts_round_corners_radius (Round_Corners_Radius) : float
  LOCmat.opts_round_corners_any_mtl (Fillet_against_Any_Material) : boolean
  LOCmat.opts_ao_on (AO_Enabled) : boolean
  LOCmat.opts_ao_exact (AO_picks_up_colors_from_other_materials__Exact_AO) : boolean
  LOCmat.opts_ao_use_global_ambient (Use_Global_Ambient_Light) : boolean
  LOCmat.opts_ao_samples (AO_Samples) : integer
  LOCmat.opts_ao_distance (AO_Distance) : float
  LOCmat.opts_ao_dark (AO_Shadow_Color) : fRGBA color
  LOCmat.opts_ao_ambient (AO_Ambient_Light_Color) : fRGBA color
  LOCmat.opts_ao_do_details (AO_for_GI_FG_detail_enhancement) : boolean
  LOCmat.opts_no_area_hl (Supress_Highlights_for_visible_area_lights) : boolean
  LOCmat.opts_1sided (Single_sided_glass___translucency) : boolean
  LOCmat.opts_do_refractive_caustics (Do_refractive_caustics) : boolean
  LOCmat.opts_skip_inside (Skip_internal_reflections_in_glass__except_TIR) : boolean
  LOCmat.opts_hl_to_refl_balance (Highlight_vs__Reflection_Balance) : float
  LOCmat.opts_propagate_alpha (Propagate_Alpha) : boolean
  LOCmat.no_diffuse_bump (No_bumps_on_diffuse_shading) : boolean
  */

  LOCmat -- return value
)

---Function to add a tree material channel to CivilViewTrees Material
fn DYNFUNaddTreeMatChannel FUNmat FUNiniArray FUNnewMatSwitch =
(
  local LOCcnt = if FUNnewMatSwitch then 1 else FUNmat.count += 1 -- always add an extra channel if this is not a new material definition, otherwise always operate on channel 1 (which MUST exist)

  --- Detect Which Renderer Is Currently In Use for Production
  local LOCnewMat
  if (DYNFUNisMentalRayProductionRenderer()) then
  (
    LOCnewMat = DYNFUNbuildArchDesignMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) FUNiniArray[7] undefined FUNiniArray[8] 1.0 false \
     0.2 1.0 0.0 1.0 8 false 0 \
     1.0 0.0 false 1.0 false false \
     0.2 1.0 5.0 true 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )
  else
  (
    LOCnewMat = DYNFUNbuildStdMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) (color 128 128 128) (color 128 128 128) 1 \
    FUNiniArray[7] undefined FUNiniArray[8] 100 0 1.0 false \
    0 0 0 0 100 true 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )

  --- Insert Material into Multi/Sub-Object Material
  FUNmat.materiallist[LOCcnt] = LOCnewMat
  FUNmat.names[LOCcnt]        = LOCnewMat.name

  DYNFUNshowTextureMap FUNmat LOCcnt true on

  LOCcnt -- Return Index of last added channel
)

--- Function to Make VSP Trees Material
fn DYNFUNmakeCivilViewTrees FUNpath =
(
  local LOCmat    = multiMaterial()
  LOCmat.count    = 1 -- Default is 10, so reduce here to one. Next line will modify first channel
  LOCmat.name     = DYNmatNameTrees

  DYNFUNaddTreeMatChannel LOCmat (DYNFUNobjectINIparams (getFileNameFile (getFiles (DYNcountryPath + DYNfolderNameObjLibs + "\\" + DYNfolderNameTrees + "\\" + "*.ini"))[1]) 3 1) true

  LOCmat -- return value
)

--- Function to add Sign Channel to CivilViewObjects material
fn DYNFUNaddSignMatChannel FUNmat FUNiniArray FUNmarkSymbolSwitch =
(
  local LOCnewMat
  --- Add a New Material Channel
  local LOCcnt                                    = FUNmat.count + 1
  FUNmat.count                                    = LOCcnt

  --- Set Up New Sign Channel
  if FUNmarkSymbolSwitch then
  (
    --- Detect Which Renderer Is Currently In Use for Production
    if (DYNFUNisMentalRayProductionRenderer()) then
    (
      LOCnewMat = DYNFUNbuildArchDesignMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) FUNiniArray[7] undefined FUNiniArray[8] 1.0 false 0.2 1.0 0.4 0.6 4 true 0 1.0 0.0 true 1.0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    )
    else
    (
      LOCnewMat = DYNFUNbuildStdMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) (color 128 128 128) (color 229 229 229) 1 FUNiniArray[7] undefined FUNiniArray[8] 100 0 1.0 false 0 0 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    )
  )
  else
  (
    --- Detect Which Renderer Is Currently In Use for Production
    local LOCmatFront, LOCmatBack
    if (DYNFUNisMentalRayProductionRenderer()) then
    (
      LOCmatFront = DYNFUNbuildArchDesignMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) FUNiniArray[7] undefined FUNiniArray[8] 1.0 false 0.2 1.0 0.0 1.0 8 true 0 1.0 0.0 true 1.0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmatBack  = DYNFUNbuildArchDesignMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) undefined undefined FUNiniArray[8] 1.0 false 0.2 1.0 0.0 1.0 8 true 0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    )
    else
    (
      LOCmatFront = DYNFUNbuildStdMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) (color 128 128 128) (color 229 229 229) 1 FUNiniArray[7] undefined FUNiniArray[8] 100 0 1.0 false 0 0 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCmatBack  = DYNFUNbuildStdMat (getfilenamefile FUNiniArray[10]) (color 128 128 128) (color 128 128 128) (color 229 229 229) 1 undefined undefined FUNiniArray[8] 100 0 1.0 false 0 0 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    )

    LOCnewMat           = doubleSided()
    LOCnewMat.name      = LOCmatFront.name
    LOCnewMat.material1 = LOCmatFront
    LOCnewMat.material2 = LOCmatBack
  )

  --- Insert Material into Multi/Sub-Object Material
  FUNmat.materiallist[LOCcnt] = LOCnewMat
  FUNmat.names[LOCcnt]        = LOCnewMat.name

  DYNFUNshowTextureMap FUNmat LOCcnt true on

  LOCcnt -- Return Index of last added channel
)

--- Function to Make VSP Objects Material
fn DYNFUNmakeCivilViewObjects FUNpath =
(
  local LOCconcDiff = FUNpath + "Concrete.Cast-In-Place.Exposed Aggregate.Medium.jpg"
  local LOCmat      = multiMaterial()
  LOCmat.name       = DYNmatNameObjects
  LOCmat.count      = 10

  --- Define Noise Map for Concrete
  local LOCconcNoise         = Noise()
  LOCconcNoise.name          = DYNuiResourcesMaterialMaps[2]
  LOCconcNoise.type          = 1 -- (0:Regular; 1:Fractal; 2:Turbulance)
  LOCconcNoise.size          = 0.5
  LOCconcNoise.color1        = color 115 110 110
  LOCconcNoise.color2        = color 255 255 255
  LOCconcNoise.phase         = 0.0
  LOCconcNoise.levels        = 1.0
  LOCconcNoise.thresholdLow  = 0.0
  LOCconcNoise.thresholdHigh = 1.0
  LOCconcNoise.coords.blur   = 1.0

  --- Set Up Initial Ten Channels
  local LOCnewMats = #()
  if (DYNFUNisMentalRayProductionRenderer()) then
  (
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[1]  (color 211 211 211) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Galvanised Steel
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[2]  (color 240 240 240) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- White Paint
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[3]  (color  25  25  25) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Black Paint
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[4]  (color 215 215 219) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 true 100  true  true 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Lamp On
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[5]  (color 111 111 111) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Grey  Paint
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[6]  (color 178 210 178) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Beige Paint
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[7]  (color 215 215 219) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Lamp Off (not yet used?)
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[8]  (color 210 230 100) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Yellow Paint
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[9]  (color  30  30 180) undefined   undefined undefined 1.0 false 0.2 1.0 0.7 0.5 4 true   0 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Blue Paint
    append LOCnewMats (DYNFUNbuildArchDesignMat DYNuiResourcesObjectMaterial[10] (color 105 105 105) LOCconcDiff undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 false 35 1.0 0.0 false  0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 LOCconcNoise 40.0) -- Concrete
  )
  else
  (
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[1]  (color 211 211 211) (color 211 211 211) (color 249 249 249) 2 undefined   undefined undefined 100  0 1.0 false 50 20 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Galvanised Steel
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[2]  (color 240 240 240) (color 240 240 240) (color 249 249 249) 5 undefined   undefined undefined 100  0 1.0 false 50 20 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- White Paint
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[3]  (color  25  25  25) (color  25  25  25) (color 249 249 249) 5 undefined   undefined undefined 100  0 1.0 false 50 20 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Black Paint
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[4]  (color 215 215 219) (color 215 215 219) (color 249 249 249) 0 undefined   undefined undefined 100  0 1.0 false 50 65 0.00 100 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Lamp On
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[5]  (color 111 111 111) (color 111 111 111) (color 249 249 249) 5 undefined   undefined undefined 100  0 1.0 false 50 20 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Grey  Paint
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[6]  (color 178 210 178) (color 178 210 178) (color 249 249 249) 5 undefined   undefined undefined 100  0 1.0 false 50 20 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Beige Paint
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[7]  (color 215 215 219) (color 215 215 219) (color 249 249 249) 0 undefined   undefined undefined 100  0 1.0 false 50 65 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Lamp Off (not yet used?)
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[8]  (color 210 230 100) (color 210 230 100) (color 249 249 249) 5 undefined   undefined undefined 100  0 1.0 false 50 20 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Yellow Paint
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[9]  (color  30  30 180) (color  30  30 180) (color 249 249 249) 5 undefined   undefined undefined 100  0 1.0 false 50 20 0.00   0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0) -- Blue Paint
    append LOCnewMats (DYNFUNbuildStdMat DYNuiResourcesObjectMaterial[10] (color 105 105 105) (color 105 105 105) (color 229 229 229) 1 LOCconcDiff undefined undefined 100 35 1.0 false 15 35 0.25   0 100 false 0.0 false 8.0 8.0 0.0 0.0 LOCconcNoise 15.0) -- Concrete
  )
  for i = 1 to LOCnewMats.count do
  (
    LOCmat.materiallist[i] = LOCnewMats[i]
    LOCmat.names[i]        = LOCnewMats[i].name
  )

  --- Show Texture Maps In Viewport
  if classOf LOCmat == Multimaterial then (for i = 1 to LOCmat.count do (DYNFUNshowTextureMap LOCmat i false on))

  LOCmat -- return value
)

--- Make VSP Road Markings Material
fn DYNFUNmakeCivilViewMarkings FUNmat FUNpos FUNcolor FUNpath FUNcentrelineGap =
(
  local LOCmatName = DYNmatNameMarkings

  local LOCmarkBump         = Noise()
  LOCmarkBump.name          = DYNuiResourcesMaterialMaps[13]
  LOCmarkBump.type          = 0 -- (0:Regular; 1:Fractal; 2:Turbulance)
  LOCmarkBump.size          = 0.025
  LOCmarkBump.color1        = color  0 0 0
  LOCmarkBump.color2        = color 255 255 255
  LOCmarkBump.phase         = 0.0
  LOCmarkBump.levels        = 3.0
  LOCmarkBump.thresholdLow  = 0.0
  LOCmarkBump.thresholdHigh = 1.0
  LOCmarkBump.coords.blur   = 1.0

  if FUNmat == undefined then
  (
    FUNmat          = multiMaterial()
    FUNmat.name     = LOCmatName
    FUNmat.count    = 1

    --- Basic Road Marking (MatID:1)
    local LOCnewMat
    if (DYNFUNisMentalRayProductionRenderer()) then
    (
      LOCnewMat = DYNFUNbuildArchDesignMat (DYNuiResourcesMaterialMaps[14] + DYNuiResourcesMaterialMaps[15]) FUNcolor undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 false 0.3 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
      LOCnewMat.bump_map_on                = true
      LOCnewMat.bump_map_amt               = 0.3
      LOCnewMat.bump_map                   = LOCmarkBump
    )
    else
    (
      LOCnewMat = DYNFUNbuildStdMat (DYNuiResourcesMaterialMaps[14] + DYNuiResourcesMaterialMaps[15]) FUNcolor FUNcolor FUNcolor 1 undefined undefined undefined 100 0 1.0 false 5 25 0.2 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    )
    FUNmat.materiallist[1] = LOCnewMat
    FUNmat.names[1]        = LOCnewMat.name
  )
  else
  (
    if FUNmat.name == LOCmatName and (classof FUNmat == Multimaterial) then
    (
      --- Add a New Material Channel
      local LOCcnt = FUNmat.count + 1
      FUNmat.count = LOCcnt

      local LOCnewMat
      if (DYNFUNisMentalRayProductionRenderer()) then
      (
        LOCnewMat = DYNFUNbuildArchDesignMat (DYNuiResourcesMaterialMaps[14] + (LOCcnt as string)) FUNcolor undefined undefined (FUNpath + "marking.gif") rootNode.DYNrootNodeStore.markBlur false 0.2 1.0 0.0 1.0 8 false 0.3 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 90.0 false 1.0 1.0 0.0 0.0 undefined 0.0
        LOCnewMat.bump_map_on                = true
        LOCnewMat.bump_map_amt               = 0.3
        LOCnewMat.bump_map                   = LOCmarkBump

        --- Mark/Gap Opacity Map Settings
        LOCnewMat.cutOut_map.clipw           = FUNpos
        LOCnewMat.cutOut_map.cliph           = 1.0
        LOCnewMat.cutOut_map.apply           = true
        LOCnewMat.cutOut_map.cropPlace       = 1

        --- Centreline Gap Opacity Map Settings
        LOCnewMat.cutOut_map.coords.v_mirror = true
        LOCnewMat.cutOut_map.clipv           = FUNcentrelineGap
        LOCnewMat.cutOut_map.cliph           = 1.0 - FUNcentrelineGap
      )
      else
      (
        LOCnewMat = DYNFUNbuildStdMat (DYNuiResourcesMaterialMaps[14] + (LOCcnt as string)) FUNcolor FUNcolor FUNcolor 1 undefined undefined (FUNpath + "marking.gif") 100 0 rootNode.DYNrootNodeStore.markBlur false 0 0 0.0 0 100 false 90.0 false 1.0 1.0 0.0 0.0 undefined 0.0

        --- Mark/Gap Opacity Map Settings
        LOCnewMat.opacityMap.clipw           = FUNpos
        LOCnewMat.opacityMap.cliph           = 1.0
        LOCnewMat.opacityMap.apply           = true
        LOCnewMat.opacityMap.cropPlace       = 1

        --- Centreline Gap Opacity Map Settings
        LOCnewMat.opacityMap.coords.v_mirror = true
        LOCnewMat.opacityMap.clipv           = FUNcentrelineGap
        LOCnewMat.opacityMap.cliph           = 1.0 - FUNcentrelineGap
      )

      FUNmat.materiallist[LOCcnt] = LOCnewMat
      FUNmat.names[LOCcnt]        = LOCnewMat.name

      DYNFUNshowTextureMap FUNmat LOCcnt true on
    )
  )
  return FUNmat
)

--- This Function Used For CivilViewSurfaces, CivilViewVehicles, CivilViewBuildings
fn DYNFUNgeneralAddMatChannel FUNmat FUNdiffuseMap FUNnewMatSwitch =
(
  local LOCcnt = if FUNnewMatSwitch then 1 else FUNmat.count += 1 -- always add an extra channel if this is not a new material definition, otherwise always operate on channel 1 (which MUST exist)

  local LOCnewMat
  if (DYNFUNisMentalRayProductionRenderer()) then
  (
    LOCnewMat = DYNFUNbuildArchDesignMat (getFilenameFile FUNdiffuseMap) (color 210 210 210) FUNdiffuseMap undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 false 0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )
  else
  (
    LOCnewMat = DYNFUNbuildStdMat (getFilenameFile FUNdiffuseMap) (color 210 210 210) (color 210 210 210) (color 210 210 210) 5 FUNdiffuseMap undefined undefined 100 0 1.0 false 22 49 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )
  LOCmat.materiallist[LOCcnt] = LOCnewMat
  LOCmat.names[LOCcnt]        = LOCnewMat.name

  DYNFUNshowTextureMap FUNmat LOCcnt false on

  LOCcnt -- Return Index of last added channel
)

fn DYNFUNaddRailMatChannel FUNmat FUNdiffuseMap FUNnewMatSwitch =
(
  local LOCcnt = if FUNnewMatSwitch then 1 else FUNmat.count += 1 -- always add an extra channel if this is not a new material definition, otherwise always operate on channel 1 (which MUST exist)

  local LOCmatFront, LOCmatBack
  if (DYNFUNisMentalRayProductionRenderer()) then
  (
    LOCmatFront = DYNFUNbuildArchDesignMat ((getFilenameFile FUNdiffuseMap) + " " + DYNuiResourcesMaterialMaps[16]) (color 210 210 210) FUNdiffuseMap undefined undefined 1.0 false 0.2 1.0 0.3 0.5 8 true 0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    LOCmatBack  = DYNFUNbuildArchDesignMat ((getFilenameFile FUNdiffuseMap) + " " + DYNuiResourcesMaterialMaps[17]) (color 210 210 210) FUNdiffuseMap undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true 0 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 180.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )
  else
  (
    LOCmatFront = DYNFUNbuildStdMat ((getFilenameFile FUNdiffuseMap) + " " + DYNuiResourcesMaterialMaps[16]) (color 210 210 210) (color 210 210 210) (color 210 210 210) 5 FUNdiffuseMap undefined undefined 100 0 1.0 false 22 49 0 0 100 false 0.0   false 1.0 1.0 0.0 0.0 undefined 0.0
    LOCmatBack  = DYNFUNbuildStdMat ((getFilenameFile FUNdiffuseMap) + " " + DYNuiResourcesMaterialMaps[17]) (color 210 210 210) (color 210 210 210) (color 210 210 210) 5 FUNdiffuseMap undefined undefined 100 0 1.0 false 22 49 0 0 100 false 180.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )

  FUNmat.materiallist[LOCcnt]           = doubleSided()
  FUNmat.materiallist[LOCcnt].name      = FUNmat.names[LOCcnt] = getFilenameFile FUNdiffuseMap
  FUNmat.materiallist[LOCcnt].material1 = LOCmatFront
  FUNmat.materiallist[LOCcnt].material2 = LOCmatBack

  DYNFUNshowTextureMap FUNmat LOCcnt false on

  LOCcnt -- Return Index of last added channel
)

--- Function to Make Civil View Rail Object Material
fn DYNFUNmakeCivilViewRails FUNpath =
(
  local LOCmat         = multiMaterial()
  LOCmat.count         = 1 -- Default is 10, so reduce here to one. Next lines will modify first channel
  LOCmat.name          = DYNmatNameRails
  local LOCdiffuseMaps = DYNFUNlistLibraryMaps FUNpath

  if LOCdiffuseMaps.count == 0 then
  (
    LOCmat.count    = 1

    --- Add First MatID: Steel
    local LOCnewMat
    if (DYNFUNisMentalRayProductionRenderer()) then
    (
      LOCnewMat = DYNFUNbuildArchDesignMat DYNuiResourcesMaterialMaps[18] (color 211 211 211) undefined undefined undefined 1.0 false 0.2 1.0 0.3 0.5 8 true 100 1.0 0.0 false 0 false false 0.2 1.0 5.0 true 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    )
    else
    (
      LOCnewMat = DYNFUNbuildStdMat DYNuiResourcesMaterialMaps[18] (color 50 50 50) (color 211 211 211) (color 249 249 249) 2 undefined undefined undefined 100 100 1.0 false 50 20 0 0 100 true 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
    )
    LOCmat.materiallist[1] = LOCnewMat
    LOCmat.names[1]        = LOCnewMat.name
  )
  else
  (
    DYNFUNaddRailMatChannel LOCmat (FUNpath + LOCdiffuseMaps[1]) true
    if LOCdiffuseMaps.count > 1 then
    (
      for i = 2 to LOCdiffuseMaps.count do (DYNFUNaddRailMatChannel LOCmat (FUNpath + LOCdiffuseMaps[i]) false)
    )
  )

  LOCmat -- return value (Mat Definition)
)

--- This New Function Used For CivilViewBuildings Only
fn DYNFUNaddBuildingMatChannel FUNmat FUNdiffuseMap FUNnewMatSwitch =
(
  local LOCcnt = if FUNnewMatSwitch then 1 else FUNmat.count += 1 -- always add an extra channel if this is not a new material definition, otherwise always operate on channel 1 (which MUST exist)

  local LOCmat
  if (DYNFUNisMentalRayProductionRenderer()) then
  (
    LOCmat = DYNFUNbuildArchDesignMat (getFilenameFile FUNdiffuseMap) (color 210 210 210) FUNdiffuseMap FUNdiffuseMap undefined 1.0 false 0.2 1.0 0.0 1.0 8 false 100 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )
  else
  (
    LOCmat = DYNFUNbuildStdMat (getFilenameFile FUNdiffuseMap) (color 210 210 210) (color 210 210 210) (color 210 210 210) 5 FUNdiffuseMap FUNdiffuseMap undefined 100 100 1.0 false 22 49 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )

  FUNmat.materiallist[LOCcnt] = LOCmat
  FUNmat.names[LOCcnt]        = LOCmat.name

  DYNFUNshowTextureMap FUNmat LOCcnt false on

  LOCcnt -- Return Index of last added channel
)

--- Function to Make VSP Surfaces Material
fn DYNFUNmakeCivilViewBuildings FUNpath =
(
  local LOCmat    = multiMaterial()
  LOCmat.name     = DYNmatNameBuildings
  LOCmat.count    = 1

  --- Add First MatID: Roof Texture
  local LOCnewMat
  if (DYNFUNisMentalRayProductionRenderer()) then
  (
    LOCnewMat = DYNFUNbuildArchDesignMat DYNuiResourcesMaterialMaps[19] (color 210 210 210) undefined undefined undefined 1.0 false 0.2 1.0 0.0 1.0 8 true 100 1.0 0.0 false 0 false false 0.2 1.0 5.0 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )
  else
  (
    LOCnewMat = DYNFUNbuildStdMat DYNuiResourcesMaterialMaps[19] (color 50 50 50) (color 210 210 210) (color 249 249 249) 2 undefined undefined undefined 100 100 1.0 false 50 20 0 0 100 false 0.0 false 1.0 1.0 0.0 0.0 undefined 0.0
  )
  LOCmat.materiallist[1] = LOCnewMat
  LOCmat.names[1]        = LOCnewMat.name

  --- Add All Building Maps Found In Dedicated Folder
  local LOCdiffuseMaps = DYNFUNlistLibraryMaps FUNpath -- will not fail if path does not exist, just returns empty array
  if LOCdiffuseMaps.count > 0 then
  (
    for i = 1 to LOCdiffuseMaps.count do (DYNFUNaddBuildingMatChannel LOCmat (FUNpath + LOCdiffuseMaps[i]) false)
  )

  --- Return Mat Definition
  LOCmat -- return value
)

--- Function for removing ALL space characters from a string (used in Authorisation Code checking)
fn DYNFUNstripAllSpaces FUNstring =
(
  for i = FUNstring.count to 1 by -1 do
  (
    if FUNstring[i] == " " then FUNstring = replace FUNstring i 1 ""
  )
  FUNstring
)

---Function to convert strings from upper to lower case
fn DYNFUNlowerCase FUNinString =
(
  local LOCoutString
  local LOCupper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ_"
  local LOClower = "abcdefghijklmnopqrstuvwxyz "
  LOCoutString = copy FUNinString
  for i = 1 to LOCoutString.count do
  (
    local LOCchar = findString LOCupper LOCoutString[i]
    if (LOCchar != undefined) do LOCoutString[i] = LOClower[LOCchar]
  )
  LOCoutString -- return value as result of function
)

fn DYNFUNdisplayINIobjFileArrays FUNobjectSwitch FUNro FUNmode =
(
  local LOCiniPath = DYNFUNsetINIpath FUNobjectSwitch FUNmode
  FUNro.DNDYNiniFileTree.nodes.clear()                                              -- Clear object INI file Tree
  FUNro.DNDYNiniFileTree.sorted = false
  FUNro.LOCiniTreeKeyItem = undefined                        -- Reset Default INI File Item IMPORTANT (See Below)

  --- Check Whether Resource List panel is open. Update it now if it is
  if DYNresourceList != undefined then
  (
    if DYNresourceList.open then
    (
      DYNresourceList.DYNFUNpopulateResourceList DYNresourceList.LOCobjectSwitch undefined DYNresourceList.LOCresourceType DYNresourceList.LOCresourceKitMode
    )
  )

  --- Make New DN Root Node ---
  local LOCdnRootNode     = FUNro.DNDYNiniFileTree.Nodes.add "[]" DYNuiResourcesObjClasses[FUNobjectSwitch] 37 37
  LOCdnRootNode.tag       = FUNobjectSwitch as string
  FUNro.LOCiniTreeKeyItem = LOCdnRootNode.name

  ------------------- UNGROUPED FILES --------------------------------------------------------------------------------------------------------------------------------

  --- Extract Ungrouped INI Files from current folder
  local LOCexFileBaseArray = DYNFUNiniGetMissingValues FUNobjectSwitch "Group" "Name" FUNmode
  --- If there are ungrouped files, display them in panel
  if LOCexFileBaseArray.count > 0 then
  (
    --- Create DN Ungrouped Node
    local LOCdnUngroupedNode  = LOCdnRootNode.nodes.add ("[" + "ungrouped" + "]") DYNuiResourcesLabels[523] 37 37
    --- Display Ungrouped Files
    for ii = 1 to LOCexFileBaseArray.count do
    (
      local LOCdnIniNode  = LOCdnUngroupedNode.nodes.add ("!" + (DYNFUNlowerCase LOCexFileBaseArray[ii]) + ".ini") LOCexFileBaseArray[ii] FUNobjectSwitch FUNobjectSwitch
      LOCdnIniNode.tag    = (FUNobjectSwitch as string) + "|" + (i as string) + "|" + (ii as string) + "|" + (LOCiniPath + LOCexFileBaseArray[ii] + ".ini")
      if FUNro.LOCiniTreeKeyItem == LOCdnRootNode.name then FUNro.LOCiniTreeKeyItem = LOCdnIniNode.name -- If LOCiniTreeKeyItem is undefined, this is the first INI file node in the tree.
    )
  )

  --------------------- GROUPED FILES --------------------------------------------------------------------------------------------------------------------------------

  --- Extract Range of Group Names for Current INI File Type
  local LOCgroupNamesArray = DYNFUNiniGetUniqueValues FUNobjectSwitch "Group" "Name" FUNmode
  --- Display and process files in each group found
  for i = 1 to LOCgroupNamesArray.count do
  (
    --- Display each DN Group Name Node in Panel
    local LOCdnGroupNode   = LOCdnRootNode.nodes.add ("[" + (DYNFUNlowerCase LOCgroupNamesArray[i]) + "]") LOCgroupNamesArray[i] 37 37
    --- Get Files for Each Group Listed
    local LOCfileBaseArray = DYNFUNiniGetbySectionPair FUNobjectSwitch "Group" "Name" LOCgroupNamesArray[i] FUNmode
    --- Display files for each group listed
    for ii = 1 to LOCfileBaseArray.count do
    (
      --- DOTNET Version
      local LOCdnIniNode  = LOCdnGroupNode.nodes.add ("!" + (DYNFUNlowerCase LOCfileBaseArray[ii]) + ".ini") LOCfileBaseArray[ii] FUNobjectSwitch FUNobjectSwitch
      LOCdnIniNode.tag    = (FUNobjectSwitch as string) + "|" + (i as string) + "|" + (ii as string) + "|" + (LOCiniPath + LOCfileBaseArray[ii] + ".ini")
      --- Ensure that at least one tag exists as the first "key item" which will be selected by default when category is first selected
      if FUNro.LOCiniTreeKeyItem == LOCdnRootNode.name then FUNro.LOCiniTreeKeyItem = LOCdnIniNode.name -- If LOCiniTreeKeyItem is undefined, this is the first INI file node in the tree.
    )
  )
  FUNro.DNDYNiniFileTree.sorted = true
  LOCdnRootNode.expand()
)

--- Function to take a selected bitmap and copy it to the correct folder in the current kit if it does not already reside there
fn DYNFUNcopyFileToResourceKitPath FUNsourceFile FUNcaption FUNimageTypes FUNmode =
(
---  local LOCrootObjectPath = ""
---  if FUNmode == 1 then LOCrootObjectPath = DYNcountryPath       -- Using Country Resource Kit
---  if FUNmode == 2 then LOCrootObjectPath = rootNode.DYNrootNodeStore.string02 -- Using Project Resource Kit
---  if FUNmode == 3 then LOCrootObjectPath = DYNINIprivateKitPath -- Using Private Resource Kit

  local LOCnewMap = getOpenFileName caption:FUNcaption filename:FUNsourceFile types:FUNimageTypes
  if LOCnewMap != undefined then
  (
    local LOCtargetPath = getFilenamePath FUNsourceFile
    if DYNFUNdoesFolderExist LOCtargetPath and (DYNFUNupperCase (getFileNamePath LOCnewMap) 0) != (DYNFUNupperCase LOCtargetPath 0) then
    (
      --- If you get here, the selected file was in a different folder, so ask if the user wants to copy the selected file to the correct folder
      if (querybox (DYNuiResourcesQueries[88]) title:DYNuiResourcesTitlebars[3]) then
      (
        if doesFileExist (LOCtargetPath + (FileNamefromPath LOCnewMap)) then
        (
          if (querybox (DYNuiResourcesQueries[89] + "\n\n" + LOCtargetPath + (FileNamefromPath LOCnewMap)) title:DYNuiResourcesTitlebars[3]) then
          (
            deleteFile (LOCtargetPath + (FileNamefromPath LOCnewMap))
          )
        )
        local LOCsuccess = copyFile LOCnewMap (LOCtargetPath + (FileNamefromPath LOCnewMap))
        if LOCsuccess then
        (
          LOCnewMap = LOCtargetPath + (FileNamefromPath LOCnewMap)
          messagebox (DYNuiResourcesErrorsWarnings[113] + "\n\n" + LOCnewMap + "\n\n" + DYNuiResourcesErrorsWarnings[114]) title:DYNuiResourcesTitlebars[3]
        )
        else
        (
          messagebox (DYNuiResourcesErrorsWarnings[115] + "\n\n" + LOCnewMap) title:DYNuiResourcesTitlebars[2]
          LOCnewMap = undefined
        )
      )
    )
  )
  LOCnewMap -- return original or updated path for map file
)

--- Function to apply position custom attributes and trnasform script
fn DYNFUNapplyMaxTransform FUNobj FUNshape FUNpercent FUNrotate FUNhorOff FUNverOff FUNfoll FUNorient FUNsurface FUNdist FUNbake FUNsplineIndex =
(
  FUNobj.transform.controller               = DYNXFCCM3()
  FUNobj.transform.controller.percent       = FUNpercent / 100.0
  FUNobj.transform.controller.rotation      = FUNrotate
  FUNobj.transform.controller.hOffset       = FUNhorOff
  FUNobj.transform.controller.vOffset       = FUNverOff
  FUNobj.transform.controller.path          = FUNshape
  FUNobj.transform.controller.surface       = FUNsurface
  FUNobj.transform.controller.followPath    = FUNfoll
  FUNobj.transform.controller.followSurface = FUNorient
  FUNobj.transform.controller.distance      = FUNdist
  FUNobj.transform.controller.spline        = FUNsplineIndex

  /* This line commented out at Civil View 2012, because logic is now inside controller itself
  FUNobj.transform.controller.row1.controller = point3_script()
  */

  DYNFUNmaxBakingControl #(FUNobj) true                                                     -- Update script to suit new parent path
  if FUNbake == false then DYNFUNmaxBakingControl #(FUNobj) false                           -- If object linking is optimised, optimise script
  FUNobj.transform.controller -- return value
)

---Functions to Pick Screen Objects Filtered by Type
fn DYNFUNshapeFilter         FUNobj = (superclassof FUNobj == shape and classOf FUNobj != NURBSCurveShape /*and classof FUNobj.baseObject != LinkLeafshape*/)
fn DYNFUNsplineShapeFilter   FUNobj = (classof FUNobj == splineShape /*and classof FUNobj.baseObject != LinkLeafshape*/)
fn DYNFUNlightFilter         FUNobj = (superclassof FUNobj == light)
fn DYNFUNgeometryFilter      FUNobj = (superclassof FUNobj == GeometryClass)
fn DYNFUNgeometryLightFilter FUNobj = (superclassof FUNobj == GeometryClass or superclassOf FUNobj == light)
fn DYNFUNdynMarksFilter      FUNobj = (classOf (CVGetMod FUNobj Civil_View_Road_Marking)   == Civil_View_Road_Marking)
fn DYNFUNdynSmeshFilter      FUNobj = (classOf (CVGetMod FUNobj Civil_View_Spline_to_Mesh) == Civil_View_Spline_to_Mesh)
fn DYNFUNdynGRailFilter      FUNobj = (classOf (CVGetMod FUNobj Civil_View_Guard_Rail)     == Civil_View_Guard_Rail)
fn DYNFUNdynSosFilter        FUNobj = (classOf (CVGetMod FUNobj Civil_View_Swept_Object)   == Civil_View_Swept_Object)
fn DYNFUNdynBuildingFilter   FUNobj = (classOf (CVGetMod FUNobj DynBuilding) == DynBuilding)
fn DYNFUNclosedShapeFilter   FUNobj =
(
  local LOCmultiSpline = false
  classOf FUNobj == Circle or classOf FUNobj == Ellipse or classOf FUNobj == NGon or classOf FUNobj == Rectangle or classOf FUNobj == Star \
  or (if (classOf FUNobj == splineShape) or (classOf FUNobj == line) then (for i = 1 to (numSplines FUNobj) do (if (isClosed FUNobj i) then LOCmultiSpline = true)); LOCmultiSpline) -- if *any* spline in a splineShape is closed....
)

--- Function to resize a given texture map (returns a bitmap value)
fn DYNFUNrenderMatMap FUNwidth FUNheight FUNmat FUNchan =
(
  local LOCmatDiffuse
  local LOCopacitySwitch = false
  local LOCmatChan    = if FUNmat.name != DYNmatNameEnvironment then FUNmat[FUNchan]
  local LOCfinalSize  = [(FUNwidth as float),(FUNheight as float)]
  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.diffuseMap) catch ()
  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.diffuseMap.mask) catch ()
  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.diffuseMap.map1) catch ()
  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.material1.diffuseMap) catch ()

  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.diff_color_map) catch ()
  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.diff_color_map.mask) catch ()
  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.diff_color_map.map1) catch ()
  if LOCmatDiffuse == undefined then LOCmatDiffuse = try (LOCmatChan.material1.diff_color_map) catch ()

  local LOCoutBMP = bitmap LOCfinalSize.x LOCfinalSize.y color:(try (LOCmatChan.diffuse) catch (color 255 255 255))
  if LOCmatDiffuse == undefined and (try (if (classof LOCmatChan) == DoubleSided then (LOCmatChan.material1.opacityMap) else (LOCmatChan.opacityMap)) catch ()) != undefined then
  (
    LOCmatDiffuse = LOCmatChan.opacitymap
    LOCopacitySwitch = true
  )
  if LOCmatDiffuse == undefined and FUNmat.name == DYNmatNameEnvironment then LOCmatDiffuse = FUNmat.map1

  --- IF RENDERING A BITMAP, CHECK AND CORRECT THE BITMAP SIZE TO SUIT THE PANEL
  if (try (LOCmatDiffuse.bitmap) catch ()) != undefined then
  (
    local LOCmapWidth  = LOCmatDiffuse.bitmap.width  as float
    local LOCmapHeight = LOCmatDiffuse.bitmap.height as float
    local LOCmapAspect = LOCmapWidth / LOCmapHeight
    local LOCpanAspect = LOCfinalSize.x / LOCfinalSize.y
    local LOCuTiling   = LOCmatDiffuse.coords.u_tiling
    local LOCvTiling   = LOCmatDiffuse.coords.v_tiling

    --- Road Marking Materials Always Need Long Narrow Bitmap Representations
    if FUNmat.name == DYNmatNameMarkings then LOCmapAspect = 0.1

    if LOCmapWidth < LOCfinalSize.x and LOCmapHeight < LOCfinalSize.y then
    (
      LOCfinalSize = [LOCmapWidth,LOCmapHeight]
    )
    else
    (
      if LOCmapAspect < LOCpanAspect then (LOCfinalSize = [(LOCfinalSize.y*LOCmapAspect),LOCfinalSize.y])
      if LOCmapAspect > LOCpanAspect then (LOCfinalSize = [LOCfinalSize.x,(LOCfinalSize.x/LOCmapAspect)])
    )
    LOCoutBMP = renderMap LOCmatDiffuse display:false size:LOCfinalSize -- filter:false

    --- Insert Diffuse Colour of Road Marking onto Opacity Maps
    if LOCopacitySwitch and FUNmat.name == DYNmatNameMarkings then
    (
      local LOCnewPixArray = #()
      LOCnewPixArray[LOCoutBMP.width] = undefined
      for i = 1 to LOCnewPixArray.count do LOCnewPixArray[i] = LOCmatChan.diffuse
      for i = 0 to LOCoutBMP.height do
      (
        local LOColdPixArray = getPixels LOCoutBMP [0,i] LOCoutBMP.width
        if LOColdPixArray[1] == (color 255 255 255) then (try (setPixels LOCoutBMP [0,i] LOCnewPixArray) catch ())
      )
    )
    --- Add Grey Border around Bitmap
    local LOCcolArray = #()
    LOCcolArray[LOCfinalSize.x] = undefined
    for i = 1 to LOCcolArray.count do (LOCcolArray[i] = (color 100 100 100))
    setPixels LOCoutBMP [0,0] LOCcolArray
    setPixels LOCoutBMP [0,(LOCfinalSize.y - 1)] LOCcolArray
    for i = 0 to LOCfinalSize.y do
    (
      setPixels LOCoutBMP [0,i] #((color 100 100 100))
      setPixels LOCoutBMP [(LOCfinalSize.x),i] #((color 100 100 100))
    )
  )
  else
  (
    if LOCmatDiffuse != undefined then (LOCoutBMP = renderMap LOCmatDiffuse display:false size:LOCfinalSize)
  )

  --- First channel of CivilViewMarkings material is always a continuous line
  if FUNmat.name == DYNmatNameMarkings and FUNchan == 1 then
  (
    LOCoutBMP = bitmap (LOCfinalSize.y / 10) LOCfinalSize.y color:DYNINImarkingColor
    for i = 0 to LOCfinalSize.y do
    (
      setPixels LOCoutBMP [0,i] #((color 100 100 100))
      setPixels LOCoutBMP [(LOCfinalSize.x),i] #((color 100 100 100))
    )
  )

  LOCoutBMP -- return value
)

--- Function to resize a given bitmap (returns a bitmap value)
fn DYNFUNrenderBitMap FUNwidth FUNheight FUNmapFile =
(
  FUNwidth  = FUNwidth  as float
  FUNheight = FUNheight as float

  local LOCmatDiffuse = try (openBitmap FUNmapFile) catch ()
  local LOCoutBMP = bitmap FUNwidth FUNheight color:(((colorMan.getColor #window) as color) * 255)

  if LOCmatDiffuse != undefined then
  (
    local LOCmapWidth  = LOCmatDiffuse.width  as float
    local LOCmapHeight = LOCmatDiffuse.height as float
    local LOCfinalSize = [LOCmapWidth,LOCmapHeight]

    if LOCmapHeight > FUNheight and LOCmapWidth < FUNwidth then LOCfinalSize = LOCfinalSize * (FUNheight / LOCmapHeight)
    if LOCmapHeight < FUNheight and LOCmapWidth > FUNwidth then LOCfinalSize = LOCfinalSize * (FUNwidth / LOCmapWidth)
    if LOCmapHeight > FUNheight and LOCmapWidth > FUNwidth then
    (
      local LOCw = FUNheight / LOCmapHeight
      local LOCh = FUNwidth  / LOCmapWidth
      if LOCw <= LOCh then LOCfinalSize = (LOCfinalSize * LOCw) else LOCfinalSize = (LOCfinalSize * LOCh)
    )
    LOCfinalSize = [(LOCfinalSize.x as integer), (LOCfinalSize.y as integer)]
    LOCoutBMP = bitmap LOCfinalSize.x LOCfinalSize.y color:(((colorMan.getColor #window) as color) * 255)
    /*
      Next line copies the source bitmap to the destination bitmap. If the size of the two bitmaps is
      different, the image will be scaled to fit the destination bitmap.
    */
    copy LOCmatDiffuse LOCoutBMP
    close LOCmatDiffuse
  )
  LOCoutBMP -- return value
)

fn DYNFUNformatDateforDisplay FUNday FUNmonth FUNyear FUNhour FUNmin FUNsec =
(
  local LOCdateString    = ""

  --- Check whether Windows uses M/D/Y or D/M/Y format
  if DYNdateLocale == 2 then -- Month/Day/Year
  (
    LOCdateString += if (FUNmonth as string).count == 1 then ("0" + (FUNmonth as string)) else (FUNmonth as string)
    LOCdateString += "/"
    LOCdateString += if (FUNday as string).count   == 1 then ("0" + (FUNday as string))   else (FUNday as string)
    LOCdateString += "/"
    LOCdateString += if (FUNyear as string).count  == 1 then ("0" + (FUNyear as string))  else (FUNyear as string)
    LOCdateString += " "
  )
  if DYNdateLocale == 3 then -- Year/Month/Day
  (
    LOCdateString += if (FUNyear as string).count  == 1 then ("0" + (FUNyear as string))  else (FUNyear as string)
    LOCdateString += "/"
    LOCdateString += if (FUNmonth as string).count == 1 then ("0" + (FUNmonth as string)) else (FUNmonth as string)
    LOCdateString += "/"
    LOCdateString += if (FUNday as string).count   == 1 then ("0" + (FUNday as string))   else (FUNday as string)
    LOCdateString += " "
  )
  if DYNdateLocale != 2 and DYNdateLocale != 3 then -- Day/Month/Year
  (
    LOCdateString += if (FUNday as string).count   == 1 then ("0" + (FUNday as string))   else (FUNday as string)
    LOCdateString += "/"
    LOCdateString += if (FUNmonth as string).count == 1 then ("0" + (FUNmonth as string)) else (FUNmonth as string)
    LOCdateString += "/"
    LOCdateString += if (FUNyear as string).count  == 1 then ("0" + (FUNyear as string))  else (FUNyear as string)
    LOCdateString += " "
  )

  LOCdateString += if (FUNhour as string).count    == 1 then ("0" + (FUNhour as string))  else (FUNhour as string)
  LOCdateString += ":"
  LOCdateString += if (FUNmin as string).count     == 1 then ("0" + (FUNmin as string))   else (FUNmin as string)
  LOCdateString += ":"
  LOCdateString += if (FUNsec as string).count     == 1 then ("0" + (FUNsec as string))   else (FUNsec as string)

  LOCdateString -- return value
)

--- Function to convert the date returned by GUP variables to a readable state
fn DYNFUNconvertGUPdate FUNdateString =
(
  local LOCdateArray = DYNFUNmxOption2Array FUNdateString "$"
  local LOCday   = LOCdateArray[1]    --; if LOCday.count   == 1 then LOCday   = "0" + LOCday
  local LOCmonth = LOCdateArray[2][1] --; if LOCmonth.count == 1 then LOCmonth = "0" + LOCmonth
  local LOCyear  = LOCdateArray[2][2]
  local LOChour  = LOCdateArray[2][3] --; if LOChour.count  == 1 then LOChour  = "0" + LOChour
  local LOCmin   = LOCdateArray[2][4] --; if LOCmin.count   == 1 then LOCmin   = "0" + LOCmin
  local LOCsec   = LOCdateArray[2][5] --; if LOCsec.count   == 1 then LOCsec   = "0" + LOCsec
  DYNFUNformatDateforDisplay LOCday LOCmonth LOCyear LOChour LOCmin LOCsec -- return date in readable format
)

---Function to retrieve names of material channels in a single material editor slot
fn DYNFUNgetMatChannelNames FUNmat FUNdispChanSwitch FUNfillSwitch FUNmatIDlimit =
(
  /*
     If FUNdispChanSwitch is true, matChannel names will be suffixed with channel number in brackets

     If FUNfillSwitch is true, total number of channels returned will always be equal to DYNINImatIDlimit regardless of number of
     channels in material (only works if FUNdispChanSwitch is true)
  */

  local LOCmatChannels = #()
  if classof FUNmat == MultiMaterial then
  (
    /* -- LOCtmp must be made first then copied to an array because LOCtmp is a "ArrayParameter" and retains links to original material! */
    local LOCtemp = FUNmat.names
    for i = 1 to LOCtemp.count do if LOCtemp[i] == undefined then LOCtemp[i] = ""
    if FUNdispChanSwitch then
    (
      for i = 1 to LOCtemp.count do append LOCmatChannels ("[" + (i as string) + "] " + LOCtemp[i])
      if FUNfillSwitch then
      (
        for i = (LOCtemp.count + 1) to FUNmatIDlimit do append LOCmatChannels ("[" + (i as string) + "]")
      )
    )
    else
    (
      for i = 1 to LOCtemp.count do append LOCmatChannels LOCtemp[i]
    )
  )
  LOCmatChannels -- return value
)

---Function to retrieve filenames of material diffuse channel bitmaps
fn DYNFUNgetMatDiffuseMaps FUNmat =
(
  local LOCmatMaps = #()
  if classof FUNmat == MultiMaterial then
  (
    for i = 1 to FUNmat.count do
    (
      if FUNmat[i] != undefined then
      (
        local LOCmap
        if (classOf FUNmat[i]) == Arch___Design__mi then LOCmap = FUNmat[i].diff_color_map         -- A&D Material
        if (classOf FUNmat[i]) == StandardMaterial  then LOCmap = FUNmat[i].diffuseMap
        if (classOf FUNmat[i]) == DoubleSided       then (if (classOf FUNmat[i].material1) == Arch___Design__mi then LOCmap = FUNmat[i].material1.diff_color_map)
        if (classOf FUNmat[i]) == DoubleSided       then (if (classOf FUNmat[i].material1) == StandardMaterial  then LOCmap = FUNmat[i].material1.diffuseMap)

        if classof LOCmap == Bitmaptexture then (append LOCmatMaps (DYNFUNlowerCase (filenameFromPath LOCmap.fileName))) else (append LOCmatMaps "")
      )
    )
  )
  LOCmatMaps -- return value
)

fn DYNFUNdisplayCivilViewSurfacesListBox FUNcaption1 FUNcaption2 FUNmaterial FUNpreSel =
(
  ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCcurSel = " + (FUNpreSel as string) + "\n")
  ExeStr+=("  local LOCresult = undefined\n")

  ExeStr+=(" listBox DDDYNlist \"" + FUNcaption2 + "\" height:14 width:175 align:#left across:2\n")
  ExeStr+=(" bitmap  BMDYNmap width:175 height:187 pos:[202,22]\n")

  ExeStr+=(" button BUDYNokok DYNuiResourcesButtons[1] width:85 pos:[203,215]\n")
  ExeStr+=(" button BUDYNcanc DYNuiResourcesButtons[3] width:85 pos:[292,215]\n")
  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+="  (\n"
  ExeStr+=("   DDDYNlist.items = ")

  local LOCmatIDnames = DYNFUNgetMatChannelNames FUNmaterial true true DYNINImatIDlimit
  if LOCmatIDnames.count > 0 then
  (
    ExeStr+=("#(\"")
    for i = 1 to (LOCmatIDnames.count - 1) do
    (
      ExeStr+=((LOCmatIDnames[i] as string) + "\",\"")
    )
    ExeStr+=((LOCmatIDnames[LOCmatIDnames.count] as string) + "\")")
    ExeStr+=("\n")
  )
  else
  (
    ExeStr+=("#()\n")
    ExeStr+=("LOCcurSel = 0\n")
    ExeStr+=("messagebox (DYNuiResourcesErrorsWarnings[133]) title:DYNuiResourcesTitlebars[3]\n")
  )
  ExeStr+=("   DDDYNlist.selection = LOCcurSel\n")

  ExeStr+="    if DDDYNlist.selection >= 1 then\n"
  ExeStr+="    (\n"
  ExeStr+="      if sceneMaterials[\"" + FUNmaterial.name + "\"] != undefined then\n"
  ExeStr+="      (\n"
  ExeStr+="        BMDYNmap.bitmap = DYNFUNrenderMatMap 175 187 sceneMaterials[\"" + FUNmaterial.name + "\"] LOCcurSel\n"
  ExeStr+="      )\n"
  ExeStr+="      else\n"
  ExeStr+="      (\n"
  ExeStr+="        BMDYNmap.bitmap = bitmap 175 187 color:(color 190 190 190)\n"
  ExeStr+="      )\n"
  ExeStr+="    )\n"

  ExeStr+=("   setFocus DYNrollout.DDDYNlist\n")
  ExeStr+="  )\n"

  ExeStr+="  on DDDYNlist selected arg do\n"
  ExeStr+="  (\n"
  ExeStr+="   LOCcurSel = arg\n"

  ExeStr+="   if arg >= 1 then\n"
  ExeStr+="   (\n"
  ExeStr+="     if sceneMaterials[\"" + FUNmaterial.name + "\"] != undefined then\n"
  ExeStr+="     (\n"
  ExeStr+="       BMDYNmap.bitmap = DYNFUNrenderMatMap 175 187 sceneMaterials[\"" + FUNmaterial.name + "\"] arg\n"
  ExeStr+="     )\n"
  ExeStr+="     else\n"
  ExeStr+="     (\n"
  ExeStr+="       BMDYNmap.bitmap = bitmap 175 187 color:(color 190 190 190)\n"
  ExeStr+="     )\n"
  ExeStr+="   )\n"
  ExeStr+="  )\n"

  ExeStr+="  on BUDYNokok pressed do (LOCresult = LOCcurSel; destroyDialog DYNrollout)\n"
  ExeStr+="  on BUDYNcanc pressed do (LOCresult = " + (undefined as string) + "; destroyDialog DYNrollout)\n"
  ExeStr+=")\n"

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:392 height:245 modal:true -- needs to be true in order to halt function here and wait for a response from the panel
  return DYNrollout.LOCresult
)

--- FUNCTION TO SET OBJECT BYLAYER SETTINGS
fn DYNFUNapplyByLayerSettings FUNobjArray =
(
  -- These properties correspnd with those accessible from the standard MAX object properties panel
  -- BYLAYER params introduced in MAX5
  for i in FUNobjArray do
  (
    i.displayByLayer            = false -- Whether object DISPLAY PROPERTIES are controlled by the Layer. [default:true]
    i.motionByLayer             = false -- Whether object MOTION BLUR is controlled by the Layer. [default:true]
    i.renderByLayer             = false -- Whether object RENDER CONTROL is controlled by the Layer. [default:true]
    i.colorByLayer              = false -- Whether the object uses the Layer's color. When false, the object's color will be used instead. [default:true]
    i.globalIlluminationByLayer = false -- Whether object ADVANCED LIGHTING inclusion/exclusion is controlled by the layer. [default:true]
  )
)

---Function to apply temporary object to reference path to indicate current start or end chainage of reference spline
fn DYNFUNapplyDYNmarker FUNshape FUNmarker FUNmarkerColour FUNpercent FUNsize FUNsplineIndex =
(
  local LOCbakeSwitch = true                                                 -- Marker Objects should never be baked...
  if FUNmarker != undefined then (delete FUNmarker; FUNmarker = undefined)   -- Delete MARKER object if it already exists
  if FUNshape != undefined then                                              -- Check that Parent Object Exists...
  (
    if classof FUNshape == SplineShape then                                  -- Check that the specified SPLINE is a SplineShape
    (
      FUNmarker = point size:(FUNsize * 2.5) pos:FUNshape.pos
      FUNmarker.centermarker       = true                                    -- a small X marker is displayed at the center of the point helper object.
      FUNmarker.axistripod         = false                                   -- When this is turned on, an axis tripod with 'x', 'y', and 'z' labels is displayed.
      FUNmarker.cross              = false                                   -- When this is turned on, an axis aligned cross is displayed. -- Seems to affect performance.
      FUNmarker.box                = true                                    -- a square box is displayed centered at the center of the point helper object.
      FUNmarker.constantscreensize = true                                    -- remains the same size in screen space regardless of how much the user zooms in or out.
      FUNmarker.drawontop          = true                                    -- draws lines with the Z buffer turned off (which usually causes it to appear in front of other objects).
      FUNmarker.name               = uniquename DYNmarkerName                -- Set Object Name for Marker Object
      FUNmarker.wirecolor          = FUNmarkerColour                         -- Set Wire Colour for Marker Object
      FUNmarker.renderable         = false                                   -- Ensure that MARKER object is not rendered
      FUNmarker.showFrozenInGray   = false                                   -- Ensure that MARKER object is always shown in colour
      FUNmarker.isFrozen           = true                                    -- Ensure that MARKER cannot be selected by user

      ---Method Two (Custom Attributes)
      DYNFUNapplyMaxTransform FUNmarker FUNshape FUNpercent 0.0 0.0 0.0 true false undefined 0.1 LOCbakeSwitch FUNsplineIndex

      --- Apply AppData which will ensure that it is excluded from lists in Civil View Explorer
      setAppData FUNmarker 420 "DYNmarker"
      DYNFUNapplyByLayerSettings #(FUNmarker)                                 -- Apply DVSP Standard "ByLayer" related settings
      flagforeground FUNmarker true                                           -- Bring MARKER object to the foreground true give quicker screen updates

      --- Added in Version 3.2 to solve unresponsive markers in 3ds Max 8 and 3ds Max 2008
      DYNFUNmaxBakingControl #(FUNmarker) true                                -- Update script to suit new parent path
    )
  )
  FUNmarker -- return value
)

--- Function to measure file content size in kilobytes for filepos (offest) purposes
fn DYNFUNfileSize FUNfile =
(
  /* Civil View 2012 Mod
   The following line can return undefined if the file size is very large. This can cause problems elsewhere.
   Therefore, the try/catch was inserted to ensure that an int is always returned. The catch number
   needs to be large, otherwise file parsing results in rollouts could fail.
  */

  /*
  local LOCstream = fopen FUNfile "rb"
  fseek LOCstream 0 #seek_end

  local LOCsize = try ((ftell LOCstream) as integer) catch (1000000000)

  LOCsize = (ceil (LOCsize / 1000.0)) as integer
  fclose LOCstream
  */

  local LOCsize = getFileSize FUNfile -- returns Integer64 in Max 2012 onwards
  if classOf LOCsize == integer64 then
  (
    if LOCsize > 2147483647 then
    (
      -- Integer64 is too large to be converted to an integer
      local LOCsizeString = LOCsize as string
      LOCsize = (subString LOCsizeString 1 (LOCsizeString.count - 4)) as integer
    )
    else
    (
      -- Integer64 can be converted to an integer
      LOCsize = (ceil ((LOCsize as integer) / 1000.0)) as integer
    )
  )
  else LOCsize = 0


  LOCsize -- return value
)

--- Function for optimising shape and dividing into equal segments between start and end percentage.
fn DYNFUNdivideSpline FUNshape FUNsteps FUNstartPercent FUNendPercent =
(
  FUNstartPercent = FUNstartPercent as float
  FUNendPercent   = FUNendPercent   as float
  if (classof FUNsteps) == integer and FUNendPercent <= 1.0 and FUNshape != undefined then
  (
    in coordsys world
    (
      if superClassof FUNshape == shape then
      (
        LOCtmp = copy FUNshape
        LOCobj = convertToSplineShape LOCtmp

        if (FUNstartPercent > FUNendPercent) then
        (
          for i = 1 to (NumSplines LOCobj) do reverse LOCobj i
          FUNstartPercent = 1.0 - FUNstartPercent
          FUNendPercent   = 1.0 - FUNendPercent
        )

        local LOCnewShape = splineshape name:(FUNshape.name + "_TempDivided") wirecolor:FUNshape.wirecolor pivot:FUNshape.pivot realWorldMapSize:false

        for i in 1 to (numsplines LOCobj) do
        (
          addnewspline LOCnewShape
          for ii in 1 to FUNsteps do
          (
            pt = lengthinterp LOCobj i (FUNstartPercent + (((FUNendPercent - FUNstartPercent) / FUNsteps) * (ii - 1)))
            addknot LOCnewShape i #smooth #curve pt
          )

          if (isclosed LOCobj i) and FUNstartPercent == 0.0 and FUNendPercent == 1.0 then
          (
            close LOCnewShape i
          )
          else addknot LOCnewShape i #smooth #curve (lengthInterp LOCobj i FUNendPercent)

          updateshape LOCnewShape
        )
        if isValidNode LOCtmp then delete LOCtmp
        return LOCnewShape                   -- Returns New Shape Definition if it was created
      )
      else return undefined                  -- Returns undefined if shape was not created
    )
  )
  else return undefined                    -- Returns undefined if shape was not created
)

---Function to open HELP utilities for each Module (returns true if opens HELP file correctly, or false if there was an error)
fn DYNFUNopenHelp FUNcontextID =
(
  HelpSystem.ShowProductHelp FUNcontextID
)

---Function to open TUTORIALS (returns true if opens correctly, or false if there was an error)
fn DYNFUNopenTutorials FUNcontextID =
(
  HelpSystem.ShowProductHelp FUNcontextID
)

--- Get Array of AppData for a given Civil View object
fn DYNFUNgetObjAppData FUNobj FUNreplaceSpaceWith =
(
  -- Use FUNreplaceSpaceWith = "" to leave blank or undefined fields as ""
  local LOCarray = #("","","","","","","","")
  LOCarray[1] = getAppData FUNobj 421-- Registration as Civil View Object
  LOCarray[2] = getAppData FUNobj 422-- Civil View Object Class
  LOCarray[3] = getAppData FUNobj 423-- Material ID applied
  LOCarray[4] = getAppData FUNobj 424-- i.e. Original File Location
  LOCarray[5] = getAppData FUNobj 425-- i.e. Original File creation date
  LOCarray[6] = getAppData FUNobj 426-- i.e. Draping coords on imported surfaces or override mapping on sos objects
  LOCarray[7] = getAppData FUNobj 427-- i.e. Feature Label
  LOCarray[8] = getAppData FUNobj 428-- i.e. Parent Name

  for i = 1 to 8 do if LOCarray[i] == undefined then LOCarray[i] = FUNreplaceSpaceWith
  for i = 1 to 8 do if LOCarray[i] == "" then LOCarray[i] = FUNreplaceSpaceWith
  LOCarray -- return value
)


---Function to apply AppData to an object in order to register it as a Dynamite Object
fn DYNFUNgenObjAppData FUNobj FUNobjectSwitch FUNmatChannel FUNsourceFile FUNappData05 FUNappData06 FUNappData07 FUNappData08 =
(
  setAppData FUNobj 421 "Dynamite"                  -- Register as Civil View Object
  setAppData FUNobj 422 (FUNobjectSwitch as string) -- Civil View Object Class
  setAppData FUNobj 423 (FUNmatChannel as string)   -- Material ID applied
  setAppData FUNobj 424 FUNsourceFile               -- i.e. Original File Location
  setAppData FUNobj 425 FUNappData05                -- i.e. Original File creation date
  setAppData FUNobj 426 FUNappData06                -- i.e. Draping coords on imported surfaces or override mapping on sos objects or alignment start station/chainage
  setAppData FUNobj 427 FUNappData07                -- i.e. Feature Label
  setAppData FUNobj 428 FUNappData08                -- i.e. Parent Name

  --- Set ByLayer options - these need to be applied to every newly created object
  DYNFUNapplyByLayerSettings #(FUNobj)
)


fn DYNFUNfindListViewItemByTag FUNdnLV FUNtag =
(
  local LOCitem = undefined
  for i = 1 to FUNdnLV.Items.count do
  (
    if FUNdnLV.Items.item[i-1].tag == FUNtag then
    (
      LOCitem = FUNdnLV.Items.item[i-1]
    )
  )
  LOCitem
)


fn DYNFUNgetlocalTime =
(
  local LOCfileCl = dotNetClass  "ThreeAm.Core.Extensions.Utils"
  local LOCresult = LOCfileCl.getTime true
  LOCresult -- return value [delimited string]
)

--- Function for calculating number of frames covered by object at a pre-defined speed
fn DYNFUNspeedKeys FUNdist FUNspeed FUNobject =
(
  /*
    In new method, the end key will always be placed at the end of an animation, regardless of the percent value. It could even be
    a percentage of 5.1 for instance. Also, the start key will always be placed at the beginning of the animation.

    This ensures that if chainage values are manually changed up or down, the object will still keep moving until the
    end of the animation is reched, ie. it won't suddenly stop in the middle of an animation even if there is still more
    length left on the parent string.

    To think about this, consider a graph with the start and end key shown. If the chainage is adjusted at any stage, the result
    will be the line on the graph moving vertically up or down. It does not move horizontally! So if the start and end markers are always
    at the start or end of an animation, the object can never suddenly stop in the middle of an animation.

    This assumes that the length of the naimation is not subsuently changed, it is thereofre advisable to increase the animationLength
    prior to animating any objects.

    This technique also facilitates chainage looping!
  */
  --- Convert all given values to floats
  local LOCspeed     = FUNspeed  as float           -- Speed of object moving in units specified by DYNINIspeedValue {Point2}
  local LOCframeRate = frameRate as float           -- Current 3dsmax rate of frames per second
  local LOCdist      = FUNdist   as float           -- Distance covered by object (i.e. length of parent shape {always in metres})
  /*
  print ("SpeedKeysIn: Distance=" + (LOCdist as string) + " ReqdSpeed=" + (LOCspeed as string))
  */
  if LOCspeed  < 0.0 then LOCspeed = LOCspeed * -1
  if LOCspeed != 0.0 then
  (
    --- Convert speed to metres (units) per frame

    --- Convert Distance Units
    case DYNINIspeedValue.x of
    (
      1: LOCspeed = LOCspeed                          -- if speed distance unit was in units
      2: LOCspeed = LOCspeed                          -- if speed distance unit was in metres
      3: LOCspeed = LOCspeed * 1000.0                 -- if speed distance unit was in km
      4: LOCspeed = LOCspeed / 100.0                  -- if speed distance unit was in cm
      5: LOCspeed = LOCspeed / 1000.0                 -- if speed distance unit was in mm
      6: LOCspeed = LOCspeed * 1609.0                 -- if speed distance unit was in miles
      7: LOCspeed = LOCspeed * 0.305                  -- if speed distance unit was in feet
      8: LOCspeed = LOCspeed * 0.0254                 -- if speed distance unit was in inches
    )

    --- Added in v3.6 - Take System Units Into Account
    case units.SystemType of
    (
      #Inches      : LOCspeed = LOCspeed * 39.3700787
      #Feet        : LOCspeed = LOCspeed * 3.2808399
      #Miles       : LOCspeed = LOCspeed * 0.000621371192
      #Millimeters : LOCspeed = LOCspeed * 1000.0
      #Centimeters : LOCspeed = LOCspeed * 100.0
      #Meters      : LOCspeed = LOCspeed * 1.0
      #Kilometers  : LOCspeed = LOCspeed * 0.001
    )

    --- Convert Time Units
    case DYNINIspeedValue.y of
    (
      1: LOCspeed = LOCspeed                          -- if speed time unit was measured in frames
      2: LOCspeed = LOCspeed / LOCframeRate           -- if speed time unit was measured in seconds
      3: LOCspeed = LOCspeed / LOCframeRate / 60.0    -- if speed time unit was measured in minutes
      4: LOCspeed = LOCspeed / LOCframeRate / 3600.0  -- if speed time unit was measured in hours
    )

    --- LOCspeed now equals number of metres travelled in one frame
    --- so now, how many frames can be travelled over distance specified?
    local LOCframesRequired        = (LOCdist / LOCspeed)
    local LOCframesAvailableFrames = (animationRange.end - animationRange.start)
    local LOCframesAvailableFloat  = (LOCframesAvailableFrames as string)
    LOCframesAvailableFloat = substring LOCframesAvailableFloat 1 (LOCframesAvailableFloat.count - 1)
    LOCframesAvailableFloat = LOCframesAvailableFloat as float
    LOCdist = if (LOCframesRequired as time) <= LOCframesAvailableFrames then (LOCframesAvailableFloat * LOCspeed) else (LOCdist * (LOCframesAvailableFrames / LOCframesRequired))


    return #(LOCdist, (animationRange.start + LOCframesAvailableFrames))
  )
  else (return #(0.0, animationRange.start)) -- no animation applied
)

---Function to be carried out when all main dialogs are closed
--- MUST NOT BE USED ON CSP ROLLOUTS!!!!!!!!!!! -- gc() causes crash when called in DYNFUNremoveCSProllouts()
fn DYNFUNonDialogClose =
(
  gc()
)

--- Function to convert an array to a delimited string, and force all entries to become a string first
fn DYNFUNarray2DelimitedString FUNarray FUNlimitor =
(
   local LOCstring = ""
   for i = 1 to FUNarray.count do
   (
     LOCstring += if (FUNarray[i] as string) == "" then "." else (FUNarray[i] as string)
     if i < FUNarray.count then LOCstring += FUNlimitor
   )
   LOCstring -- return value
)

fn DYNFUNdisplayMessage FUNcaption1 FUNcaption2 =
(
  ExeStr=("rollout DYNmessageRollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=(" label LBDYNblank\n")
  ExeStr+=("  on DYNmessageRollout open do\n")
  ExeStr+="  (\n"
  ExeStr+=("   LBDYNblank.text  = \"" + FUNcaption2 + "\"\n")
  ExeStr+=("   LBDYNblank.pos.y = 15\n")
  ExeStr+="  )\n"
  ExeStr+=")\n"
  DYNmessageRollout = Execute ExeStr
  createDialog DYNmessageRollout width:400 height:45 modal:false
)

fn DYNFUNdisplayDistQuery FUNcaption1 FUNcaption2 =
(
  local ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCresult = false\n")

  ExeStr+=("  label LBDYNdistWarning pos:[17,13] align:#left width:380 height:150\n")
  ExeStr+=("  button BUDYNokok pos:[127,170] width:72 align:#left\n")
  ExeStr+=("  button BUDYNcanc pos:[202,170] width:72 align:#left\n")
  ExeStr+=("  checkbox CKDYNsuppressWarning checked:true pos:[17,200] align:#left width:380\n")

  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+=("  (\n")
  ExeStr+=("    LBDYNdistWarning.text     = \"" + FUNcaption2 + "\"\n")
  ExeStr+=("    BUDYNokok.text            = DYNuiResourcesLabels[149]\n")
  ExeStr+=("    BUDYNcanc.text            = DYNuiResourcesLabels[150]\n")
  ExeStr+=("    CKDYNsuppressWarning.text = DYNuiResourcesLabels[508]\n")
  ExeStr+=("  )\n")

  ExeStr+=("  on BUDYNokok pressed do\n")
  ExeStr+=("  (\n")
  ExeStr+=("    rootNode.DYNrootNodeStore.bool01 = CKDYNsuppressWarning.checked\n")
  ExeStr+=("    LOCresult = true\n")
  ExeStr+=("    destroyDialog DYNrollout\n")
  ExeStr+=("  )\n")

  ExeStr+=("  on BUDYNcanc pressed do destroyDialog DYNrollout\n")
  ExeStr+=(")\n")

  local DYNrollout = Execute ExeStr
  createDialog DYNrollout width:400 height:223 modal:true
  return DYNrollout.LOCresult
)

fn DYNFUNdisplayDropDown FUNcaption1 FUNcaption2 FUNarray FUNpreSel =
(
  ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCresult = " + (FUNpreSel as string) + "\n")
  ExeStr+=(" dropdownlist DDDYNdropper \"" + FUNcaption2 + "\"\n")
  ExeStr+=(" label LBDYNblank\n")
  ExeStr+=(" button BUDYNokok DYNuiResourcesButtons[1] width:84 across:2\n")
  ExeStr+=(" button BUDYNcanc DYNuiResourcesButtons[3] width:84 \n")
  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+="  (\n"
  ExeStr+=("   DDDYNdropper.items = ")

  if FUNarray.count > 0 then
  (
    ExeStr+=("#(\"")
    for i = 1 to (FUNarray.count - 1) do
    (
      ExeStr+=((FUNarray[i] as string) + "\",\"")
    )
    ExeStr+=((FUNarray[FUNarray.count] as string) + "\")")
  )

  ExeStr+=("   \n")
  ExeStr+=("   DDDYNdropper.selection = LOCresult\n")
  ExeStr+=("   setFocus DYNrollout.DDDYNdropper\n")
  ExeStr+="  )\n"
  ExeStr+="  on DDDYNdropper selected arg do\n"
  ExeStr+="  (\n"
  ExeStr+="   LOCresult = arg\n"
  ExeStr+="  )\n"
  ExeStr+="  on BUDYNokok pressed do destroyDialog DYNrollout\n"
  ExeStr+="  on BUDYNcanc pressed do (LOCresult = " + (FUNpreSel as string) + "; destroyDialog DYNrollout)\n"
  ExeStr+=")\n"

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:200 height:95 modal:true
  return DYNrollout.LOCresult
)


fn DYNFUNdisplayListBox FUNcaption1 FUNcaption2 FUNarray FUNpreSel =
(
  ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCresult = " + (FUNpreSel as string) + "\n")
  ExeStr+=(" listBox DDDYNlist \"" + FUNcaption2 + "\" height:8\n")
  ExeStr+=(" button BUDYNokok DYNuiResourcesButtons[1] width:84 across:2\n")
  ExeStr+=(" button BUDYNcanc DYNuiResourcesButtons[3] width:84 \n")
  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+="  (\n"
  ExeStr+=("   DDDYNlist.items = ")

  if FUNarray.count > 0 then
  (
    ExeStr+=("#(\"")
    for i = 1 to (FUNarray.count - 1) do
    (
      ExeStr+=((FUNarray[i] as string) + "\",\"")
    )
    ExeStr+=((FUNarray[FUNarray.count] as string) + "\")")
  )

  ExeStr+=("   \n")
  ExeStr+=("   DDDYNlist.selection = LOCresult\n")
  ExeStr+=("   setFocus DYNrollout.DDDYNlist\n")
  ExeStr+="  )\n"
  ExeStr+="  on DDDYNlist selected arg do\n"
  ExeStr+="  (\n"
  ExeStr+="   LOCresult = arg\n"
  ExeStr+="  )\n"
  ExeStr+="  on BUDYNokok pressed do destroyDialog DYNrollout\n"
  ExeStr+="  on BUDYNcanc pressed do (LOCresult = " + (FUNpreSel as string) + "; destroyDialog DYNrollout)\n"
  ExeStr+=")\n"

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:200 height:165 modal:true pos:((getDialogPos DYNobjectPlacer) + [100,100])
  return DYNrollout.LOCresult
)

fn DYNFUNdisplaySpinner FUNcaption1 FUNcaption2 FUNpt3 FUNtype =
(
  ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCresult = " + (FUNpt3.z as string) + "\n")
  ExeStr+=("  label LBDYNblank1 \"" + FUNcaption2 + "\"\n")
  ExeStr+=("  spinner SPDYNspinner \"\" fieldwidth:160 type:#" + FUNtype + "\n")
  ExeStr+=("  button BUDYNokok DYNuiResourcesButtons[1] width:84 across:2\n")
  ExeStr+=("  button BUDYNcanc DYNuiResourcesButtons[3] width:84 \n")
  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+="   (\n"
  ExeStr+=("    SPDYNspinner.range = " + (FUNpt3 as string) + "\n")
  ExeStr+=("    setFocus DYNrollout.SPDYNspinner\n")
  ExeStr+="   )\n"
  ExeStr+="   on SPDYNspinner changed arg do\n"
  ExeStr+="   (\n"
  ExeStr+="    LOCresult = arg\n"
  ExeStr+="   )\n"
  ExeStr+="   on BUDYNokok pressed do destroyDialog DYNrollout\n"
  ExeStr+="   on BUDYNcanc pressed do (LOCresult = " + (undefined as string) + "; destroyDialog DYNrollout)\n"
  ExeStr+=")\n"

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:200 height:75 modal:true
  return DYNrollout.LOCresult
)

fn DYNFUNdisplayMinMaxSpinners FUNcaption1 FUNcaption2 FUNcaption3 FUNpt2minRange FUNpt2maxRange =
(
  ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCresult = #(" + (FUNpt2minRange.z as string) + "," + (FUNpt2maxRange.z as string) + ")\n")
  ExeStr+=("  label LBDYNblank1 \"" + FUNcaption2 + "\" across:2 align:#left\n")
  ExeStr+=("  spinner SPDYNspinner1 \"\" fieldwidth:50 scale:0.01\n")
  ExeStr+=("  label LBDYNblank2 \"" + FUNcaption3 + "\" across:2 align:#left\n")
  ExeStr+=("  spinner SPDYNspinner2 \"\" fieldwidth:50 scale:0.01\n")
  ExeStr+=("  button BUDYNokok DYNuiResourcesButtons[1] width:84 across:2\n")
  ExeStr+=("  button BUDYNcanc DYNuiResourcesButtons[3] width:84 \n")
  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+="   (\n"
  ExeStr+=("    SPDYNspinner1.range = " + (FUNpt2minRange as string) + "\n")
  ExeStr+=("    SPDYNspinner2.range = " + (FUNpt2maxRange as string) + "\n")
  ExeStr+=("    setFocus DYNrollout.SPDYNspinner1\n")
  ExeStr+="   )\n"
  ExeStr+="   on SPDYNspinner1 changed arg do\n"
  ExeStr+="   (\n"
  ExeStr+="     LOCresult[1] = arg\n"
  ExeStr+="   )\n"
  ExeStr+="   on SPDYNspinner2 changed arg do\n"
  ExeStr+="   (\n"
  ExeStr+="     LOCresult[2] = arg\n"
  ExeStr+="   )\n"
  ExeStr+="   on BUDYNokok pressed do destroyDialog DYNrollout\n"
  ExeStr+="   on BUDYNcanc pressed do (LOCresult = " + (undefined as string) + "; destroyDialog DYNrollout)\n"
  ExeStr+=")\n"

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:200 height:75 modal:true
  return DYNrollout.LOCresult
)


--- Function to derive the dislpay name of the current screen units - area units
fn DYNFUNareaUnitsName =
(
  if units.systemType == #inches      then return DYNuiResourcesUnitsDistance[15]
  if units.systemType == #feet        then return DYNuiResourcesUnitsDistance[16]
  if units.systemType == #miles       then return DYNuiResourcesUnitsDistance[17]
  if units.systemType == #millimeters then return DYNuiResourcesUnitsDistance[18]
  if units.systemType == #centimeters then return DYNuiResourcesUnitsDistance[19]
  if units.systemType == #meters      then return DYNuiResourcesUnitsDistance[20]
  if units.systemType == #kilometers  then return DYNuiResourcesUnitsDistance[21]
)

--- Function to derive the name of the current system unit setting - linear units
fn DYNFUNlinearUnitsName =
(
  if units.systemType == #inches      then return DYNuiResourcesUnitsDistance[8]
  if units.systemType == #feet        then return DYNuiResourcesUnitsDistance[7]
  if units.systemType == #miles       then return DYNuiResourcesUnitsDistance[6]
  if units.systemType == #millimeters then return DYNuiResourcesUnitsDistance[5]
  if units.systemType == #centimeters then return DYNuiResourcesUnitsDistance[4]
  if units.systemType == #meters      then return DYNuiResourcesUnitsDistance[2]
  if units.systemType == #kilometers  then return DYNuiResourcesUnitsDistance[3]
)

--- Function to read contents of any VSP Command Language Related File
fn DYNFUNparsePARAMfile FUNfile FUNminorOpt =
(
  local LOCresultArray = #()
  local LOCcurrentLine
  if FUNfile != undefined and (classOf FUNminorOpt) == string then
  (
    local LOCfileStream = openfile FUNfile
    while eof LOCfileStream != true do  -- Start reading Lines from File
    (
      LOCcurrentLine = readline LOCfileStream
      ---Read Minor Option Details
      if (substring LOCcurrentLine 1 4) == FUNminorOpt then
      (
        if (substring LOCcurrentLine 5 1) == "," then -- Free format found
        (
          local LOCoptArray = (DYNFUNmxOption2array LOCcurrentLine ",")[2]

          --- For Road Marking Styles, also read 3002
          if FUNminorOpt == "3001" then
          (
            -- Store current filepos
            local LOCcurFilePos = filePos LOCfileStream
            local LOCline3002   = ""

            -- Read additional road marking lines
            local LOCproceedSwitch = false
            if not (eof LOCfileStream) then
            (
              LOCline3002 = readline LOCfileStream; if (substring LOCline3002 1 4) == "3002" then LOCproceedSwitch = true
            )

            -- If All Lines Were Found, Comtinue to Add To Array
            if LOCproceedSwitch then
            (
              LOCoptArray.count = 10 -- ensure that array count is always 10 up to this point.
              LOCoptArray += (DYNFUNmxOption2array LOCline3002 ",")[2]
            )
            else
            (
              LOCoptArray.count = 10 -- ensure that array count is always 10 up to this point.
              LOCoptArray += #("0.0", "0.0")
            )

            LOCoptArray.count = 12

            -- Return to position after initial 3001 line
            seek LOCfileStream LOCcurFilePos
          )

          --- For Rail Object Styles, also read 5001, 5002, and 5003
          if FUNminorOpt == "5000" then
          (
            -- Store current filepos
            local LOCcurFilePos = filePos LOCfileStream

            -- Read additional guard rail lines
            local LOCproceedSwitch = true
            local LOCline5001 = readline LOCfileStream; if (substring LOCline5001 1 4) != "5001" then LOCproceedSwitch = false
            local LOCline5002 = readline LOCfileStream; if (substring LOCline5002 1 4) != "5002" then LOCproceedSwitch = false
            local LOCline5003 = readline LOCfileStream; if (substring LOCline5003 1 4) != "5003" then LOCproceedSwitch = false

            -- If All Lines Were Found, Comtinue to Add To Array
            if LOCproceedSwitch then
            (
              LOCoptArray.count = 10 -- ensure that array count is always 10 up to this point.
              LOCoptArray += (DYNFUNmxOption2array LOCline5001 ",")[2]
              LOCoptArray.count = 20 -- ensure that array count is always 20 up to this point.
              LOCoptArray += (DYNFUNmxOption2array LOCline5002 ",")[2]
              LOCoptArray.count = 30 -- ensure that array count is always 30 up to this point.
              LOCoptArray += (DYNFUNmxOption2array LOCline5003 ",")[2]
              LOCoptArray.count = 40 -- ensure that array count is always 40 up to this point.
            )

            -- Return to position after initial 5000 line
            seek LOCfileStream LOCcurFilePos
          )

          append LOCresultArray LOCoptArray
        )
        else -- Fixed format Found
        (
          messagebox DYNuiResourcesErrorsWarnings[3] title:(DYNuiResourcesTitlebars[1] + " (DYN20)")
        )
      )
    )
    close LOCfileStream
  )

  --- For SOS Styles 2000
  if FUNminorOpt == "2000" then
  (
    if LOCresultArray.count > 0 then
    (
      LOCresultArray[1][1]  = try (LOCresultArray[1][1]  as integer) catch ()
      LOCresultArray[1][2]  = try (LOCresultArray[1][2]  as integer) catch ()
      LOCresultArray[1][3]  = try (LOCresultArray[1][3]  as float  ) catch ()
      LOCresultArray[1][4]  = try (LOCresultArray[1][4]  as float  ) catch ()
      LOCresultArray[1][5]  = try (LOCresultArray[1][5]  as float  ) catch ()
      LOCresultArray[1][6]  = try (LOCresultArray[1][6]  as float  ) catch ()
      LOCresultArray[1][7]  = try (LOCresultArray[1][7]  as integer) catch ()
      LOCresultArray[1][8]  = try (LOCresultArray[1][8]  as integer) catch ()
      LOCresultArray[1][9]  = try (LOCresultArray[1][9]  as integer) catch ()
      LOCresultArray[1][10] = try (LOCresultArray[1][10] as integer) catch (0)

      --- Side(1) and Invert Horiz Offsets(2)
      if LOCresultArray[1][1]  == undefined                                then LOCresultArray[1][1]  = 0
      LOCresultArray[1][2] = if LOCresultArray[1][2]  == -1                then true else false
      if LOCresultArray[1][3]  == undefined or LOCresultArray[1][3] == 0.0 then LOCresultArray[1][3]  = DYNsosVtileDefault

      --- Mapping Rotation(4) and Multispline Mode(5) Special Treatment
      if LOCresultArray[1][4]  == undefined                                then LOCresultArray[1][4]  = 0.0
      if LOCresultArray[1][5]  == undefined                                then LOCresultArray[1][5]  = -1.0
      if LOCresultArray[1][4] >= 0.0 and LOCresultArray[1][4] < 1.0 and LOCresultArray[1][5] > LOCresultArray[1][4] and LOCresultArray[1][5] <= 1.0 then
      (
        -- If this loop is entered, it indicates that this SOS style was saved prior to release of V3 when field 4 represented start percent and field 5 represented end percent
        -- If this is the case, force mapping rotation to be zero (wasn't supported before V3), and force Spanning Spline Geometry Mode to be selected because this was the only option
        -- prior to release of V3.
        LOCresultArray[1][4] = 0.0
        LOCresultArray[1][5] = 0.0
      )
      if LOCresultArray[1][5]  == undefined or LOCresultArray[1][5] > 0.0   then LOCresultArray[1][5]  = -1.0 -- Values of greater than zero are allowed but not used. -1 applies to all splines, 0 spans across splines
      LOCresultArray[1][5] = LOCresultArray[1][5] as integer -- must be float prior to this line to allow testing for old 2000 options

      --- Tiling Width (6), Spanning(7), Closing(8) and Capping(9) modes, and number of segments(10)
      if LOCresultArray[1][6]  == undefined or LOCresultArray[1][6] == 0.0 then LOCresultArray[1][6]  = DYNsosUtileDefault
      if LOCresultArray[1][7]  == undefined                                then LOCresultArray[1][7]  = 18
      if LOCresultArray[1][8]  == undefined                                then LOCresultArray[1][8]  = 22
      if LOCresultArray[1][9]  == undefined                                then LOCresultArray[1][9]  = 22
      if LOCresultArray[1][10] > -1 and LOCresultArray[1][10] < 2          then LOCresultArray[1][10] = 25 -- smallest segment when specified by length is 1.0m
    )
    else LOCresultArray = #(#(0,  false,  DYNsosVtileDefault,  0.0, 0, DYNsosUtileDefault, 18,  22,  22,  25)) -- Field 5 set to span by default if not found in file because that was default in V2
  )

  --- For SOS Styles 2001
  if FUNminorOpt == "2001" then
  (
    for i = 1 to LOCresultArray.count do
    (
      LOCresultArray[i][1]  = try (LOCresultArray[i][1]  as float  ) catch ()
      LOCresultArray[i][2]  = try (LOCresultArray[i][2]  as float  ) catch ()
      LOCresultArray[i][3]  = try (LOCresultArray[i][3]  as float  ) catch ()
      LOCresultArray[i][4]  = try (LOCresultArray[i][4]  as float  ) catch ()
      LOCresultArray[i][5]  = try (LOCresultArray[i][5]  as float  ) catch ()
      LOCresultArray[i][6]  = if LOCresultArray[i][6] == "" then i else (try (LOCresultArray[i][6]  as integer) catch ()) --picks up pre-v3 blank fields which should be same as element index by default
      LOCresultArray[i][7]  = try (LOCresultArray[i][7]  as float  ) catch ()
      LOCresultArray[i][8]  = try (LOCresultArray[i][8]  as float  ) catch ()
      LOCresultArray[i][9]  = try (LOCresultArray[i][9]  as integer) catch ()
      LOCresultArray[i][10] = try (LOCresultArray[i][10] as integer) catch ()

      if LOCresultArray[i][1]  == undefined or LOCresultArray[i][1] == 0.0 then LOCresultArray[i][1] = DYNsosVtileDefault
      if LOCresultArray[i][2]  == undefined or LOCresultArray[i][2] == 0.0 then LOCresultArray[i][2] = DYNsosUtileDefault
      if LOCresultArray[i][3]  == undefined then LOCresultArray[i][3]  = 0.0
      if LOCresultArray[i][4]  == undefined then LOCresultArray[i][4]  = 3.0
      if LOCresultArray[i][5]  == undefined then LOCresultArray[i][5]  = 0.0
      if LOCresultArray[i][6]  == undefined then LOCresultArray[i][6]  = i -- smoothing group (should be same as element index by default)
      if LOCresultArray[i][7]  == undefined then LOCresultArray[i][7]  = 3.0
      if LOCresultArray[i][8]  == undefined then LOCresultArray[i][8]  = 0.0
      if LOCresultArray[i][9]  == undefined then LOCresultArray[i][9]  = 0 -- material inheritance
      if LOCresultArray[i][10] == undefined then LOCresultArray[i][10] = 22 -- material channel
    )
  )

  --- For SOS Styles 2010
  if FUNminorOpt == "2010" then
  (
    if LOCresultArray.count > 0 then
    (
      LOCresultArray[1][1] = try (LOCresultArray[1][1] as float) catch ()
      if LOCresultArray[1][1] == undefined then LOCresultArray[1][1] = 0.0
    )
    else LOCresultArray = #(#(0.0))
  )

  --- For RMS Styles 3001
  if FUNminorOpt == "3001" then
  (
    for i = 1 to LOCresultArray.count do
    (
      if LOCresultArray[i][1] == "undefined" or LOCresultArray[i][1] == "" then LOCresultArray[i][1] = DYNuiResourcesNodeNames[6]
      if (try (LOCresultArray[i][2]  as float)    catch ()) == undefined then LOCresultArray[i][2]  = "10.0" -- Mark Length (float)
      if (try (LOCresultArray[i][3]  as float)    catch ()) == undefined then LOCresultArray[i][3]  = "0.0"  -- Gap Length (float)
      if (try (LOCresultArray[i][4]  as float)    catch ()) == undefined then LOCresultArray[i][4]  = "1.0"  -- Mark Width (float)
      if (try (LOCresultArray[i][5]  as integer)  catch ()) == undefined then LOCresultArray[i][5]  = "0"    -- Instancing? (Int 0/1)
      if (try (LOCresultArray[i][6]  as integer)  catch ()) == undefined then LOCresultArray[i][6]  = "255"  -- Mark Color (Red Component) (Integer)
      if (try (LOCresultArray[i][7]  as integer)  catch ()) == undefined then LOCresultArray[i][7]  = "255"  -- Mark Color (Green Component) (Integer)
      if (try (LOCresultArray[i][8]  as integer)  catch ()) == undefined then LOCresultArray[i][8]  = "255"  -- Mark Color (Blue Component) (Integer)
      if (try (LOCresultArray[i][9]  as integer)  catch ()) == undefined then LOCresultArray[i][9]  = "0"    -- Fill Closed Shapes? (Int 0/1)
      if (try (LOCresultArray[i][10] as float)    catch ()) == undefined then LOCresultArray[i][10] = "0.0"  -- Fill Angle For Closed Shapes (Float)
      if (try (LOCresultArray[i][11] as float)    catch ()) == undefined then LOCresultArray[i][11] = "0.0"  -- Centreline Gap
      if (try (LOCresultArray[i][12] as float)    catch ()) == undefined then LOCresultArray[i][12] = "0.0"  -- Horizontal Offset
      if LOCresultArray[i][11] == "" then LOCresultArray[i][11] = "0.0"
      if LOCresultArray[i][12] == "" then LOCresultArray[i][12] = "0.0"
    )
  )

  --- For FIS Styles 4001
  if FUNminorOpt == "4001" then
  (
    for i = 1 to LOCresultArray.count do
    (
      if LOCresultArray[i][1] == "" then LOCresultArray[i][1]  = "*"
      if LOCresultArray[i][2] == "" then LOCresultArray[i][2]  = "*"
      if (try (LOCresultArray[i][4]  as integer)  catch ()) == undefined then LOCresultArray[i][4]  = "0"
      if (try (LOCresultArray[i][5]  as integer)  catch ()) == undefined then LOCresultArray[i][5]  = ""
      if (try (LOCresultArray[i][6]  as integer)  catch ()) == undefined then LOCresultArray[i][6]  = ""
      if (try (LOCresultArray[i][7]  as integer)  catch ()) == undefined then LOCresultArray[i][7]  = ""
      if (try (LOCresultArray[i][8]  as integer)  catch ()) == undefined then LOCresultArray[i][8]  = ""
      if (try (LOCresultArray[i][9]  as float)    catch ()) == undefined then LOCresultArray[i][9]  = ""
      if (try (LOCresultArray[i][10]  as integer) catch ()) == undefined then LOCresultArray[i][10] = ""
    )
  )

  --- For Guard Rail Styles 5000
  if FUNminorOpt == "5000" then
  (
    for i = 1 to LOCresultArray.count do
    (
      --- General Params - 5000
      /*
        0.6,    0.4, 0.4,    "", false, 0.0, 0.0,   "",    "", DYNuiResourcesNodeNames[6], \ -- Opyion 5000

        q.height        = 0.6          -- : float
        q.widthLeft     = 0.4          -- : float
        q.widthRight    = 0.4          -- : float
        q.offsetz       = 0.0          -- (Vertical Offset from shape)  : float
        q.offsetx       = 0.0          -- (Horiontal Offset from shape) : float

        if LOCglobalRosOptions[1][1] != "" then q.height     = LOCglobalRosOptions[1][1] as float
        if LOCglobalRosOptions[1][2] != "" then q.widthLeft  = LOCglobalRosOptions[1][2] as float
        if LOCglobalRosOptions[1][3] != "" then q.widthRight = LOCglobalRosOptions[1][3] as float
        if LOCglobalRosOptions[1][6] != "" then q.offSetz    = LOCglobalRosOptions[1][6] as float
        if LOCglobalRosOptions[1][7] != "" then q.offSetx    = LOCglobalRosOptions[1][7] as float
      */

      LOCresultArray[i][1]  = if (try (LOCresultArray[i][1]  as float)   catch ()) != undefined then (LOCresultArray[i][1]  as float)   else 0.6 -- Height
      LOCresultArray[i][2]  = if (try (LOCresultArray[i][2]  as float)   catch ()) != undefined then (LOCresultArray[i][2]  as float)   else 0.4 -- Left Width
      LOCresultArray[i][3]  = if (try (LOCresultArray[i][3]  as float)   catch ()) != undefined then (LOCresultArray[i][3]  as float)   else 0.4 -- Right Width
      LOCresultArray[i][5]  = if (try (LOCresultArray[i][5]  as integer) catch ()) != undefined then (LOCresultArray[i][5]  as integer) else 0  ; LOCresultArray[i][5] = if LOCresultArray[i][5] == 1 then true else false-- Use Instancing
      LOCresultArray[i][6]  = if (try (LOCresultArray[i][6]  as float)   catch ()) != undefined then (LOCresultArray[i][6]  as float)   else 0.0 -- Vertical Offset
      LOCresultArray[i][7]  = if (try (LOCresultArray[i][7]  as float)   catch ()) != undefined then (LOCresultArray[i][7]  as float)   else 0.0 -- Horiz Offset
      LOCresultArray[i][10] = if (try (LOCresultArray[i][10] as string)  catch ()) != undefined then (LOCresultArray[i][10] as string)  else DYNuiResourcesNodeNames[6]  -- Shape Mask
      if LOCresultArray[i][10] == "undefined" then LOCresultArray[i][10] = DYNuiResourcesNodeNames[6]

      --- Post Params - 5001
      /*
        true, false,   0, false,   3.0, 0.1, 0.1, 0.25, false,        1 , \ -- Opyion 5001

        q.poston        = true         --  (Post_On) : boolean
        q.postflip      = false        --  (Post_Flip) : boolean
        q.postCapTop    = false        --  (Post_Cap_Top) : boolean
        q.postCapBottom = false        --  (Post_Cap_Bottom) : boolean
        q.posttype      = 0            --  (Post_Type) : integer
        q.spacing       = 3.0          -- : float
        q.postwidth     = 0.1          --  (Post_Width) : float
        q.postdepth     = 0.1          --  (Post_Depth) : float
        q.grounddepth   = 0.25         --  (Ground_Depth) : float
        q.postmatid     = 1            --  (Post_Type) : integer

        q.poston        = if LOCpostRosOptions[1][1]  == "0" then false else true
        q.postflip      = if LOCpostRosOptions[1][2]  == "0" then false else true
        if LOCpostRosOptions[1][3]  != "" then q.posttype    = LOCpostRosOptions[1][3]  as integer
        q.postCapTop    = if LOCpostRosOptions[1][4]  == "1" then true  else false
        if LOCpostRosOptions[1][5]  != "" then q.spacing     = LOCpostRosOptions[1][5]  as float
        if LOCpostRosOptions[1][6]  != "" then q.postWidth   = LOCpostRosOptions[1][6]  as float
        if LOCpostRosOptions[1][7]  != "" then q.postDepth   = LOCpostRosOptions[1][7]  as float
        if LOCpostRosOptions[1][8]  != "" then q.groundDepth = LOCpostRosOptions[1][8]  as float
        q.postCapBottom = if LOCpostRosOptions[1][9]  == "1" then true  else false
        if LOCpostRosOptions[1][10] != "" then q.postMatID   = LOCpostRosOptions[1][10] as integer
      */
      LOCresultArray[i][11] = if (try (LOCresultArray[i][11] as integer) catch ()) != undefined then (LOCresultArray[i][11] as integer) else 1  ; LOCresultArray[i][11] = if LOCresultArray[i][11] == 0 then false else true  -- Post On (0/1)
      LOCresultArray[i][12] = if (try (LOCresultArray[i][12] as integer) catch ()) != undefined then (LOCresultArray[i][12] as integer) else 0  ; LOCresultArray[i][12] = if LOCresultArray[i][12] == 1 then true else false  -- Post Flip (0/1)
      LOCresultArray[i][13] = if (try (LOCresultArray[i][13] as integer) catch ()) != undefined then (LOCresultArray[i][13] as integer) else 0    -- Post Style (0/1)
      LOCresultArray[i][14] = if (try (LOCresultArray[i][14] as integer) catch ()) != undefined then (LOCresultArray[i][14] as integer) else 0  ; LOCresultArray[i][14] = if LOCresultArray[i][14] == 1 then true else false  -- Post Top Cap
      LOCresultArray[i][15] = if (try (LOCresultArray[i][15] as float)   catch ()) != undefined then (LOCresultArray[i][15] as float)   else 3.0  -- Post Spacing
      LOCresultArray[i][16] = if (try (LOCresultArray[i][16] as float)   catch ()) != undefined then (LOCresultArray[i][16] as float)   else 0.1  -- Width
      LOCresultArray[i][17] = if (try (LOCresultArray[i][17] as float)   catch ()) != undefined then (LOCresultArray[i][17] as float)   else 0.1  -- Depth
      LOCresultArray[i][18] = if (try (LOCresultArray[i][18] as float)   catch ()) != undefined then (LOCresultArray[i][18] as float)   else 0.25 -- Ground Depth
      LOCresultArray[i][19] = if (try (LOCresultArray[i][19] as integer) catch ()) != undefined then (LOCresultArray[i][19] as integer) else 0  ; LOCresultArray[i][19] = if LOCresultArray[i][19] == 1 then true else false  -- Post Bottom Cap
      LOCresultArray[i][20] = if (try (LOCresultArray[i][20] as integer) catch ()) != undefined then (LOCresultArray[i][20] as integer) else 1    -- Post Mat ID

      --- Brace Params - 5002
      /*
        true,    "",   1,    "",  0.01, 0.2, 0.1,   "",    "",        1 , \ -- Option 5002

        q.braceon       = true         --  (Brace_On) : boolean
        q.bracetype     = 0            --  (Brace_Type) : integer
        q.bracegap      = 0.01         --  (Brace Gap to Rail) : float
        q.braceheight   = 0.2          --  (Brace_Height) : float
        q.bracedepth    = 0.1          --  (Brace_Depth) : float
        q.bracematid    = 1            --  (Brace_Material_ID) : integer

        q.braceon        = if LOCbraceRosOptions[1][1]  == "0" then false else true
        if LOCbraceRosOptions[1][3]  != "" then q.braceType   = LOCbraceRosOptions[1][3]  as integer
        if LOCbraceRosOptions[1][5]  != "" then q.braceGap    = LOCbraceRosOptions[1][5]  as float
        if LOCbraceRosOptions[1][6]  != "" then q.braceHeight = LOCbraceRosOptions[1][6]  as float
        if LOCbraceRosOptions[1][7]  != "" then q.braceDepth  = LOCbraceRosOptions[1][7]  as float
        if LOCbraceRosOptions[1][10] != "" then q.braceMatID  = LOCbraceRosOptions[1][10] as integer
      */
      LOCresultArray[i][21] = if (try (LOCresultArray[i][21] as integer) catch ()) != undefined then (LOCresultArray[i][21] as integer) else 1   ; LOCresultArray[i][21] = if LOCresultArray[i][21] == 0 then false else true -- Brace On (0/1)
      LOCresultArray[i][23] = if (try (LOCresultArray[i][23] as integer) catch ()) != undefined then (LOCresultArray[i][23] as integer) else 0   -- Brace Style (0/1)
      LOCresultArray[i][25] = if (try (LOCresultArray[i][25] as float)   catch ()) != undefined then (LOCresultArray[i][25] as float)   else 0.01-- Gap
      LOCresultArray[i][26] = if (try (LOCresultArray[i][26] as float)   catch ()) != undefined then (LOCresultArray[i][26] as float)   else 0.2 -- Height
      LOCresultArray[i][27] = if (try (LOCresultArray[i][27] as float)   catch ()) != undefined then (LOCresultArray[i][27] as float)   else 0.1 -- Depth
      LOCresultArray[i][30] = if (try (LOCresultArray[i][30] as integer) catch ()) != undefined then (LOCresultArray[i][30] as integer) else 1   -- Brace Mat ID

      --- Rail Params - 5003
      /*
        true,  true,   1,    "",   0.3, 0.3, 0.1,   "",   1.0,        2   \ -- Option 5003

        q.raillefton    = true         --  (Rail_Left_On) : boolean
        q.railrighton   = true         --  (Rail_Right_On) : boolean
        q.railtype      = 4            --  (Rail_Type) : integer
        q.railvertical  = 0.25         --  (Rail_Vertical_Height) : float
        q.railheight    = 0.05         --  (Rail_Height) : float
        q.railwidth     = 0.1          --  (Rail_Width) : float
        q.railmatid     = 2            --  (Rail_Material_ID) : integer
        q.uvrepeat      = 1.0          --  (UV_Repeat) : float

        q.raillefton        = if LOCrailRosOptions[1][1]  == "0" then false else true
        q.railrighton       = if LOCrailRosOptions[1][2]  == "0" then false else true
        if LOCrailRosOptions[1][3]  != "" then q.railType     = LOCrailRosOptions[1][3]  as integer
        if LOCrailRosOptions[1][5]  != "" then q.railVertical = LOCrailRosOptions[1][5]  as float
        if LOCrailRosOptions[1][6]  != "" then q.railHeight   = ((LOCrailRosOptions[1][6]  as float) * 2) + q.railVertical
        if LOCrailRosOptions[1][7]  != "" then q.railWidth    = LOCrailRosOptions[1][7]  as float
        if LOCrailRosOptions[1][9]  != "" then q.UVRepeat     = LOCrailRosOptions[1][9] as float
        if LOCrailRosOptions[1][10] != "" then q.railMatID    = LOCrailRosOptions[1][10] as integer
      */
      LOCresultArray[i][31] = if (try (LOCresultArray[i][31] as integer) catch ()) != undefined then (LOCresultArray[i][31] as integer) else 1   ; LOCresultArray[i][31] = if LOCresultArray[i][31] == 0 then false else true -- Rail Left On (0/1)
      LOCresultArray[i][32] = if (try (LOCresultArray[i][32] as integer) catch ()) != undefined then (LOCresultArray[i][32] as integer) else 1   ; LOCresultArray[i][32] = if LOCresultArray[i][32] == 0 then false else true -- Rail Right On (0/1)
      LOCresultArray[i][33] = if (try (LOCresultArray[i][33] as integer) catch ()) != undefined then (LOCresultArray[i][33] as integer) else 4    -- Rail Style (0/1)
      LOCresultArray[i][35] = if (try (LOCresultArray[i][35] as float)   catch ()) != undefined then (LOCresultArray[i][35] as float)   else 0.25 -- Basic Rail Depth
      LOCresultArray[i][36] = if (try (LOCresultArray[i][36] as float)   catch ()) != undefined then (LOCresultArray[i][36] as float)   else 0.05 -- Flange Offset
      LOCresultArray[i][37] = if (try (LOCresultArray[i][37] as float)   catch ()) != undefined then (LOCresultArray[i][37] as float)   else 0.1  -- Flange Depth
      LOCresultArray[i][39] = if (try (LOCresultArray[i][39] as float)   catch ()) != undefined then (LOCresultArray[i][39] as float)   else 1.0  -- UV Mat Repeat
      LOCresultArray[i][40] = if (try (LOCresultArray[i][40] as integer) catch ()) != undefined then (LOCresultArray[i][40] as integer) else 2    -- Rail Mat ID
    )
  )

  --- For BOS Styles 6001
  if FUNminorOpt == "6001" then
  (
    for i = 1 to LOCresultArray.count do
    (
      LOCresultArray[i][1]  = try (LOCresultArray[i][1]  as string ) catch (); if LOCresultArray[i][1] == "undefined" or LOCresultArray[i][1] == "" then LOCresultArray[i][1] = DYNuiResourcesNodeNames[6]
      LOCresultArray[i][2]  = try (LOCresultArray[i][2]  as float  ) catch ()
      LOCresultArray[i][3]  = try (LOCresultArray[i][3]  as integer) catch (1)
      LOCresultArray[i][4]  = try (LOCresultArray[i][4]  as integer) catch (1)
      LOCresultArray[i][5]  = try (LOCresultArray[i][5]  as integer) catch (0)
      LOCresultArray[i][6]  = try (LOCresultArray[i][6]  as float  ) catch ()
      LOCresultArray[i][10] = try (LOCresultArray[i][10] as integer) catch (2)

      if LOCresultArray[i][1]  == undefined                   then LOCresultArray[i][1]  = DYNuiResourcesNodeNames[6] -- Shape Label Mask (String)
      if LOCresultArray[i][2]  == undefined                   then LOCresultArray[i][2]  = 2.5  -- Building Height (Float)
      if LOCresultArray[i][3] < 1                             then LOCresultArray[i][3]  = 1    -- Number of Floors [must be integer 1 or higher]
      if LOCresultArray[i][4] < 1 or LOCresultArray[i][4] > 4 then LOCresultArray[i][4]  = 1    -- Walls Mapping Style [must be integer between 1 and 4]
      if LOCresultArray[i][5] < 0 or LOCresultArray[i][5] > 1 then LOCresultArray[i][5]  = 0    -- Instancing [must be integer 0/1]
      if LOCresultArray[i][6]  == undefined                   then LOCresultArray[i][6]  = 10.0 -- Mapping Width (Float)
      if LOCresultArray[i][10] < 1                            then LOCresultArray[i][10] = 2    -- Material ID [must be integer 1 or higher]
    )
  )

  LOCresultArray -- return value
)


--- Function for shortening file pathnames to fit into a screen panel area
fn DYNFUNtrimPathName FUNpath FUNwidth =
(
  local LOCoutPath = FUNpath

  if FUNpath != undefined and findString FUNpath "\\" != undefined then
  (
    local LOCcnt       = 0
    local LOCextent    = GetTextExtent FUNpath     -- Check extent of input path
    local LOCfilterStr = filterString FUNpath "\\" -- Split pathname into array
    local LOCdriveStr  = LOCfilterStr[1] + "\\"    -- Extract Drive Letter
    local LOCfileName  = fileNamefromPath FUNpath  -- Extract file name
    local LOCproceedSwitch = true                  --

    if LOCextent.x > FUNwidth then                   -- Only enter this section if input string is too wide.
    (
      deleteItem LOCfilterStr LOCfilterStr.count     -- Remove filename from path array
      if LOCfilterStr.count > 0 then
      (
        if substring FUNpath 1 2 != "\\\\" then deleteItem LOCfilterStr 1 else LOCdriveStr = "\\\\" -- Remove drive letter from path array if not UNC path

        for i = 1 to LOCfilterStr.count do
        (
          if LOCproceedSwitch then
          (
            LOCoutPath = ""
            for ii = 1 to (LOCfilterStr.count - i) do LOCoutPath += LOCfilterStr[ii] + "\\"
            LOCoutPath = LOCdriveStr + LOCoutPath + "...\\" + LOCfileName
            if (getTextExtent LOCoutPath).x < FUNwidth then LOCproceedSwitch = false
          )
        )
      )
    )
  )
  if classOf LOCoutPath != string then "" else LOCoutPath-- return value
)


--- Function To Set Parameters in Civil_View_Spline_to_Mesh Modifier (must be before DYNFUNapplyPlanarMap)
fn DYNFUNmodifySmesh FUNobjMod FUNmatID FUNmin FUNmax FUNrot =
(
  if classOf FUNobjMod == Civil_View_Spline_to_Mesh then
  (
    FUNobjMod.singleshape  = false                         -- (Treat_as_Single_Shape) : boolean
    /* This flag is a byproduct of debugging and development that has been left in as an added feature.
    By default this flag is forced internally if the input shape to the modifier only has a single spline.
    A single-spline shape can be processed much faster than a multi-spline shape. The modifier will first
    remove any open splines from the shape before determining whether the resulting shape is a single-spline
    shape. If that is the case this flag is forced to "on" internally and causes the modifier to move through
    the faster routine. However, in a multi-spline shape, this flag will take into account concentric shapes
    and will produce a resulting triangle mesh that matches the internal shape to mesh conversion. This allows
    the creation of mesh surfaces that have the appearance of having 'holes' cut into them by closed splines
    that fit inside other closed splines. While removal of this byproduct is easy, leaving it in with the
    default state of the flag turned "off" is preferable. */

    FUNobjMod.showedges    = true                             -- (Show_All_Edges) : boolean
    FUNobjMod.matid        = FUNmatID                         -- (Material_ID) : integer
    FUNobjMod.smg          = 0                                -- (Smoothing_Group) : integer
    FUNobjMod.width        = FUNmax.x - FUNmin.x              -- (Map_Width) : float (X AXIS)
    FUNobjMod.length       = FUNmax.y - FUNmin.y              -- (Map_Length) : float (Y AXIS)
    FUNobjMod.offsetx      = FUNmin.x + (FUNobjMod.width / 2) -- (Offset_X) : float
    FUNobjMod.offsety      = FUNmin.y + (FUNobjMod.length / 2)-- (Offset_Y) : float
    FUNobjMod.urepeat      = 1.0                              -- (U_Repeat) : float
    FUNobjMod.vrepeat      = 1.0                              -- (V_Repeat) : float
    FUNobjMod.rotation     = FUNrot                           -- : float
    FUNobjMod.flipx        = false                            -- (Flip_X) : boolean
    FUNobjMod.flipy        = false                            -- (Flip_Y) : boolean
    FUNobjMod.sizeoverride = true                             -- (Override_Map_Size) : boolean
    FUNobjMod.individual   = false                            -- (Individual_Directions) : boolean
    FUNobjMod.reverse      = false                            -- (Reverse_Splines) : boolean
    FUNobjMod.north        = true                             -- (North_Direction_Alignment) : boolean
  )
  FUNobjMod -- Return New Road Marking
)


--- Function to update pre-v3.5 draping coord appData to new standard
fn DYNFUNupdateDrapingCoords FUNobj =
(
  local LOCresult           = false -- changes to true if old coords were detected, and updated

  --- Read existing coordinate draping data from object AppData
  local LOCexistCoordString = getAppData FUNobj 426
  if LOCexistCoordString == undefined then LOCexistCoordString = ""
  local LOCexistCoordArray  = filterString LOCexistCoordString "|"

  --- If OLD Pre-v3.5 Coordinate Array detected. Convert to new style coordinate array. -------------------
  if LOCexistCoordArray[1] != "@" and LOCexistCoordString != "" then
  (
    local LOColdCoordArray = execute LOCexistCoordArray[1]
    if (try (classof LOColdCoordArray) catch ()) == array then
    (
      if LOColdCoordArray.count == 4 then (append LOColdCoordArray 31)
      setAppData FUNobj 426 ("@|" + (DYNFUNarray2DelimitedString LOColdCoordArray "$"))
      LOCresult = true
    )
  )
  LOCresult -- return value
)


fn DYNFUNsaveFaceSelectionSets FUNobj =
(
  local LOCoutArray = #()

  for i in FUNobj.faces.selSetNames do
  (
    append LOCoutArray #(i, (FUNobj.faces[i] as bitarray))
  )

  LOCoutArray -- return value
)

fn DYNFUNretreiveFaceSelectionSets FUNobj FUNsets =
(
  for i in FUNsets do
  (
    FUNobj.faces[i[1]] = i[2]
  )
)


--- function to apply planar mapping to an object
fn DYNFUNapplyPlanarMap FUNobj FUNmin FUNmax FUNmatID =
(
  local LOCsucceedSwitch = false

  with undo off
  (
    local LOCnormPos
    local LOCsmeshMod = (CVGetMod FUNobj Civil_View_Spline_to_Mesh)

    if LOCsmeshMod != undefined then
    (
      ---- Method For Shapes With Smesh Modifier (conversion to mesh from boundary shape)
      DYNFUNmodifySmesh LOCsmeshMod LOCsmeshMod.matid FUNmin FUNmax 0.0
      LOCsucceedSwitch = true
    )
    else
    (
      ---- Method For Editable Mesh Objects - Check If Modifier Stack Exists and Collapse If Necessary ----------------------------------
      local LOCsafetoProceed = (FUNobj.modifiers.count == 0)
      if not LOCsafetoProceed then
      (
        if (querybox (DYNuiResourcesQueries[11]) title:DYNuiResourcesTitlebars[2]) then
        (
          local LOCsets = DYNFUNsaveFaceSelectionSets FUNobj
          convertToMesh FUNobj
          DYNFUNretreiveFaceSelectionSets FUNobj LOCsets
          LOCsafetoProceed = true
        )
      )

      --- Check Whether Mesh Contains ANy Faces -----------------------------------------------------------------------------------------
      if FUNobj.numfaces == 0 then
      (
        messagebox (DYNuiResourcesErrorsWarnings[116]) title:DYNuiResourcesTitlebars[1]
        LOCsafetoProceed = false
      )

      --- START DOING SOMETHING ---------------------------------------------------------------------------------------------------------

      if LOCsafetoProceed then
      (
        --- Select Only Faces with specified Material ID --------------------------------------------------------------------------------
        local LOCbitArray = FUNobj.Faces as bitArray                                                           -- create bitArray of all faces
        local LOCselectionChanged = false                                                                      -- Need to record whether selectionSet is changed during following commands
        for i = 1 to LOCbitArray.count do (if (getFaceMatID FUNobj i) != FUNmatID then LOCbitArray[i] = false) -- filter bitArray to only faces which match current matID selection

        --- Ensure object is selected! Object MUST be selected for following subObjectLevel to work. If not selected, select now --------
        if not FUNobj.isSelected then (selectMore FUNobj; LOCselectionChanged = true)

        --- Apply MESH SELECT MODIFIER --------------------------------------------------------------------------------------------------
        FUNobj.selectedFaces = LOCbitArray                                                                     -- select filtered faces
        addmodifier FUNobj (meshSelect())
        max Modify Mode                                                                                        -- open the modify panel
        modPanel.setCurrentObject FUNobj.modifiers[1]
        subObjectLevel = 3
        setFaceSelection FUNobj FUNobj.modifiers[1] LOCbitArray                                                -- Select faces in Mesh Select Modifier

        --- Apply UVW Mapping MODIFIER --------------------------------------------------------------------------------------------------
        /*
          In MAXScript, the values of modifier sub-object transform properties, such as centers and gizmo position,
          rotation and scale, are not given in the current working coordinate system, but rather are typically in
          the coordinate system of the object to which it is applied. This is in contrast to scene node transform
          properties. The values given are exactly as would be seen in the sub-objects corresponding track view
          or as might be referenced in an Expression controller track variable for that sub-object property. To
          convert from local to world coordinates, you multiply the local coordinates by the nodes objecttransform
          matrix. To convert from world to local coordinates, you multiple the world coordinates by the inverse of
          the nodes objecttransform matrix.

          For example:

          obj=box pos:[10,20,30]
          addModifier obj (affect_region())
          objTM=obj.objecttransform
          modTM=getModContextTM obj obj.affect_region

          -- calculate world coordinates of end point
          obj.affect_region.end_point * (inverse modTM) * objTM

          -- set end point at world coordinates [20,20,0]
          obj.affect_region.end_point = [20,20,0] * modTM * (inverse objTM)
        */

        modPanel.addModToSelection (UVWmap length:(FUNmax.y-FUNmin.y) width:(FUNmax.x-FUNmin.x) mapType:0 realWorldMapSize:false)
		FUNobj.modifiers[#UVW_Map].realWorldMapSize = off
        local LOCobjTM = FUNobj.objecttransform                                                        -- the nodes objecttransform matrix
        local LOCmodTM = getModContextTM FUNobj (CVGetMod FUNobj Uvwmap)                         -- the modifier's local coordinates
        local LOCworld = [(FUNmin.x+((FUNmax.x-FUNmin.x)/2.0)),(FUNmin.y+((FUNmax.y-FUNmin.y)/2.0)),0] -- the new world coords of the uvwmap gizmo (center of bitmap)
        (CVGetMod FUNobj Uvwmap).gizmo.position = LOCworld * LOCmodTM * (inverse LOCobjTM)

        --- If Object Wasn't Originally Selected when this function started, deselect it again now --------------------------------------
        if LOCselectionChanged then deselect FUNobj

        --- Remove Modifiers and Deselect Faces -----------------------------------------------------------------------------------------
        local LOCsets = DYNFUNsaveFaceSelectionSets FUNobj
        convertToMesh FUNobj
        DYNFUNretreiveFaceSelectionSets FUNobj LOCsets

        deselect FUNobj.selectedFaces -- Deselect Faces Again
        actionMan.executeAction 0 "300" -- Ensure that MAX modify panel is NOT open
        LOCsucceedSwitch = true
      )
    )


    --- READ AND MODIFY APPDATA ---------------------------------------------------------------------------------------------------------


    if LOCsucceedSwitch then
    (
      --- Read existing coordinate draping data from object AppData
      local LOCexistCoordString = getAppData FUNobj 426; if LOCexistCoordString == undefined then LOCexistCoordString = ""
      local LOCexistCoordArray  = filterString LOCexistCoordString "|"

      --- OLD Pre-v3.5 Coordinate Array detected. Convert to new style coordinate array. -------------------
      if LOCexistCoordArray[1] != "@" and LOCexistCoordString != "" then
      (
        local LOColdCoordArray = execute LOCexistCoordArray[1]
        if (try (classof LOColdCoordArray) catch ()) == array then
        (
          if LOColdCoordArray.count == 4 then (append LOColdCoordArray 31)
          setAppData FUNobj 426 ("@|" + (DYNFUNarray2DelimitedString LOColdCoordArray "$"))
          LOCexistCoordString = getAppData FUNobj 426; if LOCexistCoordString == undefined then LOCexistCoordString = ""
          LOCexistCoordArray  = filterString LOCexistCoordString "|"
        )
      )

      ---Check to see whether this MatID has been used for draping before, and if so update that array entry
      local LOCexistmatIDarray  = #()
      local LOCmatchmatIDarray  = #()
      if LOCexistCoordArray.count >= 2 then
      (
        for i = 2 to LOCexistCoordArray.count do
        (
          local LOCarray = filterString LOCexistCoordArray[i] "$"
          if LOCarray.count == 5 then
          (
            append LOCexistmatIDarray (LOCarray[5] as integer)
            append LOCmatchmatIDarray LOCexistCoordArray[i]
          )
        )
      )

      local LOCid = findItem LOCexistmatIDarray FUNmatID
      if LOCid > 0 then
      (
        if (findItem LOCexistCoordArray LOCmatchmatIDarray[LOCid]) > 0 then
        (
          LOCexistCoordArray[findItem LOCexistCoordArray LOCmatchmatIDarray[LOCid]] = DYNFUNarray2DelimitedString (#(FUNmin.x,FUNmin.y,FUNmax.x,FUNmax.y, FUNmatID)) "$"
        )
      )

      --- UPDATE 426 APPDATA -------------------------------------------------------------------------------
      local LOCnewCoordString = "@"
      if LOCid > 0 then
      (
        --- If Updating existing coords for this matID
        for i = 2 to LOCexistCoordArray.count do LOCnewCoordString += ("|" + LOCexistCoordArray[i])
      )
      else
      (
        if LOCexistCoordArray.count > 0 then
        (
          --- If coord array existed, but this matID consitutes a new entry
          for i = 2 to LOCexistCoordArray.count do LOCnewCoordString += ("|" + LOCexistCoordArray[i])
          LOCnewCoordString += "|" + (DYNFUNarray2DelimitedString #(FUNmin.x,FUNmin.y,FUNmax.x,FUNmax.y, FUNmatID) "$")
        )
        else
        (
          ---- If No DRAPE ARRAY Currently EXISTED at all ---
          LOCnewCoordString += "|" + (DYNFUNarray2DelimitedString #(FUNmin.x,FUNmin.y,FUNmax.x,FUNmax.y, FUNmatID) "$")
        )
      )
      setAppData FUNobj 426 LOCnewCoordString
    )
  )

  --- Return Success Value
  LOCsucceedSwitch -- return value
)


fn DYNFUNfeatureInterpQuery =
(
  local LOCmessage = DYNuiResourcesQueries[81] + "\n\n" + DYNuiResourcesQueries[84]

  local ExeStr=("rollout DYNrollout \"" + DYNuiResourcesTitlebars[3] + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCresult = false\n")

  ExeStr+=("  label LBDYNdistWarning pos:[22,13] align:#left width:460 height:108\n")
  ExeStr+=("  button BUDYNokok pos:[177,123] width:72 align:#left\n")
  ExeStr+=("  button BUDYNcanc pos:[252,123] width:72 align:#left\n")
  ExeStr+=("  checkbox CKDYNsuppressWarning checked:false pos:[22,151] align:#left width:380\n")

  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+=("  (\n")
  ExeStr+=("    LBDYNdistWarning.text     = \"" + LOCmessage + "\"\n")
  ExeStr+=("    BUDYNokok.text            = DYNuiResourcesLabels[149]\n")
  ExeStr+=("    BUDYNcanc.text            = DYNuiResourcesLabels[150]\n")
  ExeStr+=("    CKDYNsuppressWarning.text = DYNuiResourcesLabels[508]\n")
  ExeStr+=("  )\n")

  ExeStr+=("  on BUDYNokok pressed do\n")
  ExeStr+=("  (\n")
  ExeStr+=("    rootNode.DYNrootNodeStore.bool02 = CKDYNsuppressWarning.checked\n")
  ExeStr+=("    LOCresult = true\n")
  ExeStr+=("    destroyDialog DYNrollout\n")
  ExeStr+=("  )\n")

  ExeStr+=("  on BUDYNcanc pressed do destroyDialog DYNrollout\n")
  ExeStr+=(")\n")

  local DYNrollout = Execute ExeStr
  createDialog DYNrollout width:500 height:175 modal:true -- needs to be true in order to halt function here and wait for a response from the panel
  return DYNrollout.LOCresult
)


--- Function to display a rollout with an EditText control in it
fn DYNFUNdisplaySaveAsInputFilePanel FUNmodel FUNstring FUNchar =
(
  ExeStr=("rollout DYNrollout \"\"\n")
  ExeStr+=("(\n")
  ExeStr+=(" local LOCresult")
  ExeStr+=(" label    LBDYNmodel  pos:[30,20] width:232\n")
  ExeStr+=(" editText EDDYNmodel  pos:[26,38] width:236\n")
  ExeStr+=(" label    LBDYNstring pos:[30,70] width:232\n")
  ExeStr+=(" editText EDDYNstring pos:[26,88] width:236\n")
  ExeStr+=(" label    LBDYNchar   pos:[30,120] width:232\n")
  ExeStr+=(" editText EDDYNchar   pos:[26,138] width:236\n")
  ExeStr+=(" checkbox CKDYNxfall  pos:[30,168] width:236\n")
  ExeStr+=(" button BUDYNokok width:84 across:2\n")
  ExeStr+=(" button BUDYNcanc width:84 \n")
  ExeStr+=(" on DYNrollout open do\n")
  ExeStr+="  (\n"
  ExeStr=("    DYNrollout.title = DYNuiRolloutNames[64]\n")
  ExeStr+=("   BUDYNokok.text   = DYNuiResourcesButtons[1]\n")
  ExeStr+=("   BUDYNcanc.text   = DYNuiResourcesButtons[3]\n")
  ExeStr+=("   LBDYNmodel.text  = DYNuiResourcesLabels[509]\n")
  ExeStr+=("   LBDYNstring.text = DYNuiResourcesLabels[510]\n")
  ExeStr+=("   LBDYNchar.text   = DYNuiResourcesLabels[511]\n")
  ExeStr+=("   CKDYNxfall.text  = DYNuiResourcesLabels[512]\n")
  ExeStr+=("   EDDYNmodel.text  = \"" + FUNmodel + "\"\n")
  ExeStr+=("   EDDYNstring.text = \"" + FUNstring + "\"\n")
  ExeStr+=("   EDDYNchar.text   = \"" + FUNchar + "\"\n")
  ExeStr+=("   BUDYNokok.pos.y  = 200\n")
  ExeStr+=("   BUDYNcanc.pos.y  = 200\n")
  ExeStr+=("   setFocus DYNrollout.EDDYNmodel\n")
  ExeStr+="  )\n"
  ExeStr+="  on BUDYNokok pressed do\n"
  ExeStr+="  (\n"
  ExeStr+="    if EDDYNmodel.text.count > 0 and EDDYNstring.text.count == 4 and EDDYNchar.text.count == 1 then\n"
  ExeStr+="    (\n"
  ExeStr+="      LOCresult = #(EDDYNmodel.text, EDDYNstring.text, EDDYNchar.text, CKDYNxfall.checked) ; destroyDialog DYNrollout\n"
  ExeStr+="    )\n"
  ExeStr+="    else\n"
  ExeStr+="    (\n"
  ExeStr+="      messagebox (DYNuiResourcesErrorsWarnings[117]) title:DYNuiResourcesTitlebars[3]\n"
  ExeStr+="    )\n"
  ExeStr+="  )\n"
  ExeStr+="  on BUDYNcanc pressed do (LOCresult = undefined; destroyDialog DYNrollout)\n"
  ExeStr+=")\n"

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:294 height:230 modal:true
  return DYNrollout.LOCresult
)

--- Function to build list of stations at a regular interval based on what could be a non-zero start station value
fn DYNFUNbuildSplineStationListFromIntervalAndStartStation FUNstartStation FUNendStation FUNstationInterval FUNaddEndStationToList =
(
  --- Initialize Station List Array
  local LOCstationList = #()

  if FUNendStation > FUNstartStation then
  (
    --- Calculate First Major Station Value (for instance, if start station is 345.7 and interval is 10.0, first major station would be 350.0)
    local LOCfirstMajorStation = Ceil (FUNstartStation / (FUNstationInterval as float)) * (FUNstationInterval as float)

    --- Add StartStation to Station List
    append LOCstationList FUNstartStation

    --- Add Intermediate Station Values to Station List
    local LOCsplineLength   = FUNendStation - FUNstartStation
    local LOCcurrentStation = LOCfirstMajorStation
    while (LOCcurrentStation - FUNstartStation) < LOCsplineLength do
    (
      if LOCcurrentStation != LOCstationList[LOCstationList.count] then append LOCstationList LOCcurrentStation
      LOCcurrentStation += FUNstationInterval
    )
  )
  else
  (
    --- Calculate First Major Station Value (for instance, if start station is 345.7 and interval is 10.0, first major station would be 350.0)
    local LOCfirstMajorStation = Floor (FUNstartStation / (FUNstationInterval as float)) * (FUNstationInterval as float)

    --- Add StartStation to Station List
    append LOCstationList FUNstartStation

    --- Add Intermediate Station Values to Station List
    local LOCsplineLength   = FUNendStation - FUNstartStation
    local LOCcurrentStation = LOCfirstMajorStation
    while (LOCcurrentStation - FUNstartStation) > LOCsplineLength do
    (
      if LOCcurrentStation != LOCstationList[LOCstationList.count] then append LOCstationList LOCcurrentStation
      LOCcurrentStation -= FUNstationInterval
    )
  )

  --- Optionally, add End Station to the list
  if FUNaddEndStationToList then append LOCstationList FUNendStation

  --- Return Value
  LOCstationList
)

--- Function to extract object positions from OPS style into pre-process array
fn DYNFUNpreProcessOPStyle FUNopsFileContents FUNparentShapeLength FUNparentShapeStartStation =
(
  local LOCpositionArray = #()
  LOCpositionArray[FUNopsFileContents.count] = undefined
  for i = 1 to LOCpositionArray.count do LOCpositionArray[i] = #()

  local LOCunitMult = 1.0
  case units.SystemType of
  (
    #Inches      : LOCunitMult = 39.3700787
    #Feet        : LOCunitMult = 3.2808399
    #Miles       : LOCunitMult = 0.000621371192
    #Millimeters : LOCunitMult = 1000.0
    #Centimeters : LOCunitMult = 100.0
    #Meters      : LOCunitMult = 1.0
    #Kilometers  : LOCunitMult = 0.001
  )

  /* Get All Object Insert Positions from Parameter File Contents */
  for i = 1 to FUNopsFileContents.count do
  (
    local LOCstartPos        = ((FUNopsFileContents[i][4] as float) * FUNparentShapeLength / 100.0) + FUNparentShapeStartStation     -- Calculate Chainage Pos from Percent
    local LOCendPos          = ((FUNopsFileContents[i][5] as float) * FUNparentShapeLength / 100.0) + FUNparentShapeStartStation      -- Calculate Chainage Pos from Percent
    local LOCobjectInterval  =  FUNopsFileContents[i][3] as float
    local LOCkeyMode         =  FUNopsFileContents[i][8] as float -- Calculate Speed of Object

    --- Random Spacing -------------------------------------------------------------------------------
    if LOCobjectInterval < 0 then
    (
      local LOCreqdNumber = (LOCobjectInterval as integer) * -1
      local LOCtempArray  = #()

      -- Build Exclusion Zones
      local LOCexZone     = 0.4 * LOCunitMult-- Default Value

      if (FUNopsFileContents[i][10] == "1") then
      (
        LOCexZone = try ((DYNFUNobjectINIparams FUNopsFileContents[i][9] 1 1)[2] / 2.0) catch (15 / 2.0)
        if LOCexZone == 0.0 then LOCexZone = 10.0 * LOCunitMult
      )

      if (FUNopsFileContents[i][10] == "3") then
      (
        LOCexZone = try ((DYNFUNobjectINIparams FUNopsFileContents[i][9] 3 1)[3] / 3.0) catch (3 / 3.0)
        if LOCexZone == 0.0 then LOCexZone = 1.0 * LOCunitMult
      )

      if ((LOCexZone * LOCreqdNumber * 2) + LOCreqdNumber) < (LOCendPos - FUNparentShapeStartStation) then
      (
        while LOCtempArray.count < LOCreqdNumber do
        (
          local LOCexSwitch    = true
          local LOCrandomPlace = random (LOCstartPos - FUNparentShapeStartStation) (LOCendPos - FUNparentShapeStartStation)
          for iiii in LOCtempArray do
          (
            if (LOCrandomPlace - iiii) < LOCexZone and (LOCrandomPlace - iiii) > (LOCexZone * -1) then LOCexSwitch = false
          )
          if LOCexSwitch then (append LOCtempArray LOCrandomPlace)
        )
        LOCpositionArray[i] = LOCtempArray
      )
      else (DYNobjectPlacer.LOCspaceCheckProceedSwitch = false)
    )

    --- Regular Interval -----------------------------------------------------------------------------
    if LOCobjectInterval > 0 then
    (
      -- Set Default for Exclusion Zone (minimum station spacing between objects)  If not required, leave set to zero
      local LOCexZone = 0.0

      -- Set Per Vehicle Station Based Exlcusion Zone for Vehicles (to avoid vehicle placement overlap)
      if FUNopsFileContents[i][10] == "1" then
      (
        LOCexZone = try ((DYNFUNobjectINIparams FUNopsFileContents[i][9] 1 1)[2] / 2.0) catch (15 / 2.0)
        if LOCexZone == 0.0 then LOCexZone = 10.0 * LOCunitMult-- put something here for Max Units.......  7.5m
      )

      -- Set Per Vehicle Station Based Exlcusion Zone for Trees (to avoid tree placement overlap)
      if FUNopsFileContents[i][10] == "3" then
        (
        LOCexZone = try ((DYNFUNobjectINIparams FUNopsFileContents[i][9] 3 1)[3] / 3.0) catch (3 / 3.0)
        if LOCexZone == 0.0 then LOCexZone = 1.0 * LOCunitMult -- put something here for Max Units.......  7.5m
        )

      if LOCobjectInterval >= LOCexZone then
      (
        if LOCkeyMode >= 0.0 then
        (
          local LOCstationList = DYNFUNbuildSplineStationListFromIntervalAndStartStation LOCstartPos LOCendPos LOCobjectInterval false
          for iiii = 1 to LOCstationList.count do LOCstationList[iiii] -= FUNparentShapeStartStation -- Object Placement Requires Stations To Be Based on zero start station from this point on
          LOCpositionArray[i]  = LOCstationList
        )
        if LOCkeyMode <  0.0 then
        (
          local LOCstationList = DYNFUNbuildSplineStationListFromIntervalAndStartStation LOCendPos LOCstartPos LOCobjectInterval false
          for iiii = 1 to LOCstationList.count do LOCstationList[iiii] -= FUNparentShapeStartStation -- Object Placement Requires Stations To Be Based on zero start station from this point on
          LOCpositionArray[i]  = LOCstationList
      )
      )
    )

    --- Single Object
    if LOCobjectInterval == 0 then
    (
      if LOCkeyMode >= 0.0 then LOCpositionArray[i] = #(LOCstartPos - FUNparentShapeStartStation)
      if LOCkeyMode <  0.0 then LOCpositionArray[i] = #(LOCendPos - FUNparentShapeStartStation)
    )
  )

  LOCpositionArray -- return object position array
)

--- Function for extracting georeferencing coordinates from World Files
fn DYNFUNreadWorldFile FUNdiffuseMap =
(
  local LOCgeoReferenceFile       -- Default value is undefined
  local LOCgeoRefCoordArray       -- Default value is undefined (this is used as function return value)

  if classOf FUNdiffuseMap == Bitmap then
  (
    --- Define World File Name And Path Based On Type Of Bitmap Specified
    local LOCwFileExtn = ".tfw" -- Default Value of filename extension of the world file
    if ((getFilenameType FUNdiffuseMap.filename) == ".gif")  then LOCwFileExtn = ".gfw"
    if ((getFilenameType FUNdiffuseMap.filename) == ".tga")  then LOCwFileExtn = ".taw"
    if ((getFilenameType FUNdiffuseMap.filename) == ".cals") then LOCwFileExtn = ".clw"
    if ((getFilenameType FUNdiffuseMap.filename) == ".png")  then LOCwFileExtn = ".pgw"
    if ((getFilenameType FUNdiffuseMap.filename) == ".bmp")  then LOCwFileExtn = ".bpw"
    if ((getFilenameType FUNdiffuseMap.filename) == ".jpg")  then LOCwFileExtn = ".jgw"
    if ((getFilenameType FUNdiffuseMap.filename) == ".jpeg") then LOCwFileExtn = ".jgw"
    LOCgeoReferenceFile = (getFilenamePath FUNdiffuseMap.filename) + (getFilenameFile FUNdiffuseMap.filename) + LOCwFileExtn -- Construct full path of World File

    --- If required World File Exists, open file and read contents
    if doesFileExist LOCgeoReferenceFile then
    (
      /*
        Information returned from these files is as follows:
        This function reads six lines, with one float value expected on each line
        If six flaots are not found, function will return {undefined}
        -- First line   - Resolution of image in metres (size of each pixel) (X Dimension of a Pixel)
        -- Second line  - Not used (usually "0")                             (X Rotation Factor)
        -- Third  line  - Not used (usually "0")                             (Y Rotation Factor)
        -- Fourth line  - Resolution of image in metres (size of each pixel) (Y Dimension of a Pixel)
        -- Fifth line   - True coordinate of Top left corner of image (X-parameter)
        -- Sixth line   - True coordinate of Top left corner of image (Y-parameter)
        -- Seventh line - Not usually present, and not referenced by this function, but sometimes shows date picture was taken
        -- Eigth line   - Not usually present, and not referenced by this function, but sometimes shows "hoogtedata voor het maken van de orthofotomozaiken"
      */

      --- IF WORLD FILE IS FOUND, READ FILE CONTENTS
      local LOCfloatArray = #()
      local LOCfileStream = openfile LOCgeoReferenceFile
      for i = 1 to 6 do
      (
        if not (eof LOCfileStream) then
        (
          local LOCcurrentLine = trimLeft (trimRight (readline LOCfileStream))
          local LOCcurrentFloat = try ((LOCcurrentLine) as float) catch ()
          if LOCcurrentFloat != undefined then append LOCfloatArray LOCcurrentFloat
        )
      )
      close LOCfileStream

      --- If all items in World File were found and none were undefined, construct return array
      if ((findItem LOCfloatArray undefined) == 0) and (LOCfloatArray.count == 6) then
      (
        local LOCrealWidth  = FUNdiffuseMap.width  * LOCfloatArray[1] -- Calculate true width of ground map in metres
        local LOCrealHeight = FUNdiffuseMap.height * LOCfloatArray[4] -- Calculate true height of ground map in metres
        LOCgeoRefCoordArray = #((LOCfloatArray[5] + rootNode.DYNrootNodeStore.shiftX),((LOCfloatArray[6] + rootNode.DYNrootNodeStore.shiftY) + LOCrealHeight),((LOCfloatArray[5] + rootNode.DYNrootNodeStore.shiftX) + LOCrealWidth),(LOCfloatArray[6] + rootNode.DYNrootNodeStore.shiftY))
      )
    )
  )
  LOCgeoRefCoordArray -- return value - undefined if invalid map specified, or world file is invalid or could not be found
)


--- Function which sets up the Explorer panel for docking
fn DYNFUNdockExplorer FUNwidth =
(
  cui.RegisterDialogBar DYNmainFloater style:#(#cui_dock_left,#cui_floatable,#cui_handles) minSize:[(FUNwidth+6),600] maxSize:[(FUNwidth+6),(systemTools.GetScreenHeight())]-- new Version 3.0
  if DYNINIdockExplorer == "1" then (cui.DockDialogBar DYNmainFloater #cui_dock_left)
)

fn DYNFUNresourceKitListViewStyleAndContent FUNiconPath FUNresourceKitMode FUNlockSelection FUNdn =
(
  /*
    FUNresourceKitMode = Current Resource Kit Selection
    1 = Country
    2 = Project
    3 = Private
  */
  --- Resource Kit List Control
  FUNdn.backcolor           = DYNFUNdnColor (color 128 128 128)
  FUNdn.forecolor           = DYNFUNdnColor (color 255 255 255)
  FUNdn.hideSelection       = false
  FUNdn.largeImageList      = DYNdnLgImageList

  local LOChideCountryResourceKit = FUNlockSelection and FUNresourceKitMode != 1
  local LOChideProjectResourceKit = FUNlockSelection and FUNresourceKitMode != 2
  local LOChidePrivateResourceKit = FUNlockSelection and FUNresourceKitMode != 3

  --- Display Node for Country Resource Kit
  local LOClistItemRange = #()

  if not LOChideCountryResourceKit then
  (
    local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesCvExplorer[29])
    LOClistItem.imageIndex = 1
    LOClistItem.tag        = if (subString DYNcountryPath DYNcountryPath.count -1) == "\\" then subString DYNcountryPath 1 (DYNcountryPath.count - 1) else DYNcountryPath
    FUNdn.Items.Add LOClistItem
    LOClistItem.selected   = if FUNresourceKitMode == 1 then true else false
  )

  --- Display Node for Project Resource Kit
  if not LOChideProjectResourceKit then
  (
    if DYNINIprojectKit != "0" and (DYNFUNdoesFolderExist rootNode.DYNrootNodeStore.string02) then
    (
      local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesCvExplorer[30])
      LOClistItem.imageIndex = 2
      LOClistItem.tag        = if (subString rootNode.DYNrootNodeStore.string02 rootNode.DYNrootNodeStore.string02.count -1) == "\\" then subString rootNode.DYNrootNodeStore.string02 1 (rootNode.DYNrootNodeStore.string02.count - 1) else rootNode.DYNrootNodeStore.string02
      FUNdn.Items.Add LOClistItem
      LOClistItem.selected   = if FUNresourceKitMode == 2 then true else false
    )
  )

  --- Display Node for Private Resource Kit
  if not LOChidePrivateResourceKit then
  (
    if DYNINIprivateKit == "1" and (DYNFUNdoesFolderExist DYNINIprivateKitPath) then
    (
      local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" (DYNuiResourcesCvExplorer[31])
      LOClistItem.imageIndex = 3
      LOClistItem.tag        = if (subString DYNINIprivateKitPath DYNINIprivateKitPath.count -1) == "\\" then subString DYNINIprivateKitPath 1 (DYNINIprivateKitPath.count - 1) else DYNINIprivateKitPath
      FUNdn.Items.Add LOClistItem
      LOClistItem.selected   = if FUNresourceKitMode == 3 then true else false
    )
  )
)


fn DYNFUNmakeNewFileNameUnique FUNoldFileNameAndPath FUNfileExtension =
(
  local LOCnewFileNameAndPath = ""

  --- Get Core Filename without path or file extension
  local LOCfileCoreName = getFilenameFile FUNoldFileNameAndPath

  --- Remove any existing " (n)" suffix in the file name
  if LOCfileCoreName.count >= 4 then
  (
    if (subString LOCfileCoreName (LOCfileCoreName.count - 3) 2) == " (" and (subString LOCfileCoreName LOCfileCoreName.count 1) == ")" then
    (
      LOCfileCoreName = subString LOCfileCoreName 1 (LOCfileCoreName.count - 4)
    )
  )

  --- Keep incrementing file name until unique
  if doesFileExist ((getFilenamePath FUNoldFileNameAndPath) + LOCfileCoreName + FUNfileExtension) then
  (
    local LOCcnt = 2
    while doesFileExist ((getFilenamePath FUNoldFileNameAndPath) + LOCfileCoreName + " (" + (LOCcnt as string) + ")" + FUNfileExtension) do (LOCcnt += 1)
    LOCnewFileNameAndPath = (getFilenamePath FUNoldFileNameAndPath) + LOCfileCoreName + " (" + (LOCcnt as string) + ")" + FUNfileExtension
  )
  else
  (
    LOCnewFileNameAndPath = (getFilenamePath FUNoldFileNameAndPath) + LOCfileCoreName + FUNfileExtension
  )

  LOCnewFileNameAndPath  -- Return Value
)

fn DYNFUNdisplayListBoxWithMapPreview FUNrollout FUNcaption1 FUNcaption2 FUNobjSwitch FUNmode FUNfilterSection FUNfilterParam FUNfilterValue =
(
  ExeStr=("rollout DYNrollout \"" + FUNcaption1 + "\"\n")
  ExeStr+=("(\n")
  ExeStr+=("  local LOCcurSel = \"\"\n")
  ExeStr+=("  local LOCresourceKitMode = " + (FUNmode as string) + "\n")
  ExeStr+=("  local LOCfilterSection   = \"" + FUNfilterSection + "\"\n")
  ExeStr+=("  local LOCfilterParam     = \"" + FUNfilterParam + "\"\n")
  ExeStr+=("  local LOCfilterValue     = \"" + FUNfilterValue + "\"\n")
  ExeStr+=("  local LOCallowDnSelection = true\n")
  ExeStr+=("  local LOCiniTreeKeyItem \n")
  ExeStr+=("  local LOCfileArray = #()\n")

  ExeStr+=("  fn DYNFUNupdateBitmap FUNdnSelectedNode FUNcategorySwitch =\n")
  ExeStr+=("  (\n")
  ExeStr+=("    if subString FUNdnSelectedNode.name 1 1 == \"!\" then\n")
  ExeStr+=("    (\n")
  ExeStr+=("      local LOCdiffuseMapFile = (DYNFUNobjectINIparams FUNdnSelectedNode.text FUNcategorySwitch DYNrollout.LOCresourceKitMode)[7]\n")
  ExeStr+=("      if doesFileExist LOCdiffuseMapFile then\n")
  ExeStr+=("      (\n")
  ExeStr+=("        DYNrollout.BMDYNmap.bitmap = DYNFUNrenderBitMap 195 277 LOCdiffuseMapFile\n")
  ExeStr+=("        DYNrollout.LOCcurSel = FUNdnSelectedNode.text\n")
  ExeStr+=("      )\n")
  ExeStr+=("      else\n")
  ExeStr+=("      (\n")
  ExeStr+=("        DYNrollout.BMDYNmap.bitmap = bitmap 195 277 color:(color 190 190 190)\n")
  ExeStr+=("        DYNrollout.LOCcurSel = \"\"\n")
  ExeStr+=("      )\n")
  ExeStr+=("    )\n")
  ExeStr+=("    else\n")
  ExeStr+=("    (\n")
  ExeStr+=("      DYNrollout.BMDYNmap.bitmap = bitmap 195 277 color:(color 190 190 190)\n")
  ExeStr+=("      DYNrollout.LOCcurSel = \"\"\n")
  ExeStr+=("    )\n")
  ExeStr+=("  )\n")

  ExeStr+=("  fn DYNFUNautoSelectINIfile FUNdnTree FUNpreSel FUNfileArray =\n")
  ExeStr+=("  (\n")

  ExeStr+=("    for i = FUNdnTree.nodes.item[0].nodes.count to 1 by -1 do\n")
  ExeStr+=("    (\n")
  ExeStr+=("      local LOCitem1 = FUNdnTree.nodes.item[0].nodes.item[i-1]\n")
  ExeStr+=("      for i = LOCitem1.nodes.count to 1 by -1 do\n")
  ExeStr+=("      (\n")
  ExeStr+=("        local LOCitem2 = LOCitem1.nodes.item[i-1]\n")
  ExeStr+=("        if (subString LOCitem2.name 1 1) == \"!\" then\n")
  ExeStr+=("        (\n")
  ExeStr+=("          if (findItem FUNfileArray LOCitem2.text) == 0 then LOCitem1.nodes.removeAt LOCitem2.index\n")
  ExeStr+=("        )\n")
  ExeStr+=("      )\n")
  ExeStr+=("    )\n")

  ExeStr+=("    for i = FUNdnTree.nodes.item[0].nodes.count to 1 by -1 do\n")
  ExeStr+=("    (\n")
  ExeStr+=("      local LOCitem = FUNdnTree.nodes.item[0].nodes.item[i-1]\n")
  ExeStr+=("      if (subString LOCitem.name 1 1) != \"!\" then\n")
  ExeStr+=("      (\n")
  ExeStr+=("        if LOCitem.nodes.count == 0 then FUNdnTree.nodes.item[0].nodes.removeAt LOCitem.index\n")
  ExeStr+=("      )\n")
  ExeStr+=("    )\n")

  ExeStr+=("    FUNdnTree.selectedNode = FUNdnTree.nodes.item[0]\n")
  ExeStr+=("    LOCcurSel = \"\"\n")
  ExeStr+=("    if FUNfileArray.count >= FUNpreSel then\n")
  ExeStr+=("    (\n")
  ExeStr+=("      local LOCitem = FUNdnTree.nodes.find (\"!\" + (DYNFUNlowerCase FUNfileArray[FUNpreSel]) + \".ini\") true\n")
  ExeStr+=("      if LOCitem.count > 0 then\n")
  ExeStr+=("      (\n")
  ExeStr+=("        FUNdnTree.selectedNode = LOCitem[1]\n")
  ExeStr+=("        LOCcurSel = FUNfileArray[FUNpreSel]\n")
  ExeStr+=("      )\n")
  ExeStr+=("    )\n")
  ExeStr+=("  )\n")

  ExeStr+=("  dotNetControl  dnResourceKitList \"System.Windows.Forms.ListView\" height:277 width:80  pos:[12,22]\n")
  ExeStr+=("  dotNetControl  DNDYNiniFileTree  \"System.Windows.Forms.TreeView\" height:277 width:175 pos:[103,22]\n")
  ExeStr+=("  bitmap BMDYNmap width:195 height:277 pos:[292,22]\n")
  ExeStr+=("  button BUDYNokok DYNuiResourcesButtons[1] width:84 pos:[317,305]\n")
  ExeStr+=("  button BUDYNcanc DYNuiResourcesButtons[3] width:84 pos:[405,305]\n")

  ExeStr+=("  on DYNrollout open do\n")
  ExeStr+=("  (\n")
  ExeStr+=("    DYNFUNdnTreeViewStyle DNDYNiniFileTree\n")
  ExeStr+=("    DNDYNiniFileTree.imageList = DYNdnSmImageList\n")
  ExeStr+=("    DYNFUNresourceKitListViewStyleAndContent DYNiconsPath LOCresourceKitMode false dnResourceKitList \n")
  ExeStr+=("    if LOCfilterSection == \"\" or LOCfilterParam == \"\" then\n")
  ExeStr+=("    (\n")
  ExeStr+=("      LOCfileArray = DYNFUNiniGetBases " + (FUNobjSwitch as string) + " LOCresourceKitMode\n")
  ExeStr+=("    )\n")
  ExeStr+=("    else\n")
  ExeStr+=("    (\n")
  ExeStr+=("      LOCfileArray = DYNFUNiniGetbySectionPair  " + (FUNobjSwitch as string) + " LOCfilterSection LOCfilterParam LOCfilterValue LOCresourceKitMode\n")
  ExeStr+=("    )\n")
  ExeStr+=("    DYNFUNdisplayINIobjFileArrays " + (FUNobjSwitch as string) + " DYNrollout LOCresourceKitMode\n")
  ExeStr+=("    DYNFUNautoSelectINIfile DNDYNiniFileTree 1 LOCfileArray\n")
  ExeStr+=("    DYNFUNupdateBitmap DNDYNiniFileTree.selectedNode " + (FUNobjSwitch as string) + "\n")
  ExeStr+=("    setFocus DNDYNiniFileTree\n")
  ExeStr+=("  )\n")

  ExeStr+=("  on dnResourceKitList ItemSelectionChanged arg do\n")
  ExeStr+=("  (\n")
  ExeStr+=("  if arg.isSelected and LOCallowDnSelection then\n")
  ExeStr+=("    (\n")
  ExeStr+=("      LOCresourceKitMode = arg.item.index + 1\n")
  ExeStr+=("      if LOCfilterSection == \"\" or LOCfilterParam == \"\" then\n")
  ExeStr+=("      (\n")
  ExeStr+=("        LOCfileArray = DYNFUNiniGetBases " + (FUNobjSwitch as string) + " LOCresourceKitMode\n")
  ExeStr+=("      )\n")
  ExeStr+=("      else\n")
  ExeStr+=("      (\n")
  ExeStr+=("        LOCfileArray = DYNFUNiniGetbySectionPair  " + (FUNobjSwitch as string) + " LOCfilterSection LOCfilterParam LOCfilterValue LOCresourceKitMode\n")
  ExeStr+=("      )\n")
  ExeStr+=("      DYNFUNdisplayINIobjFileArrays " + (FUNobjSwitch as string) + " DYNrollout LOCresourceKitMode\n")
  ExeStr+=("      DYNFUNautoSelectINIfile DNDYNiniFileTree 1 LOCfileArray\n")
  ExeStr+=("      DYNFUNupdateBitmap DNDYNiniFileTree.selectedNode " + (FUNobjSwitch as string) + "\n")
  ExeStr+=("    )\n")
  ExeStr+=("  )\n")

    ExeStr+=("  on DNDYNiniFileTree MouseDown arg do\n")
    ExeStr+=("  (\n")
    ExeStr+=("    local LOCnode = DNDYNiniFileTree.getNodeAt arg.x arg.y\n")
    ExeStr+=("    if LOCnode != undefined then (DYNFUNupdateBitmap LOCnode " + (FUNobjSwitch as string) + ")\n")
    ExeStr+=("  )\n")

  ExeStr+=("  on DNDYNiniFileTree KeyUp arg do\n")
  ExeStr+=("  (\n")
  ExeStr+=("    if DNDYNiniFileTree.selectedNode != undefined then (DYNFUNupdateBitmap DNDYNiniFileTree.selectedNode " + (FUNobjSwitch as string) + ")\n")
  ExeStr+=("  )\n")

  ExeStr+=("  on BUDYNokok pressed do (destroyDialog DYNrollout)\n")
  ExeStr+=("  on BUDYNcanc pressed do (LOCcurSel = \"\"; destroyDialog DYNrollout)\n")
  ExeStr+=(")\n")

  local DYNrollout = Execute ExeStr

  createDialog DYNrollout width:502 height:335 modal:true
  if FUNrollout.LOCresourceKitMode != undefined then FUNrollout.LOCresourceKitMode = DYNrollout.LOCresourceKitMode
  return DYNrollout.LOCcurSel
)


--- Function to check whether the contents of a given OPS file are valid and can be used further in Civil View.
fn DYNFUNvalidateOPSstyle FUNopsFile FUNshowErrors FUNmode =
(
  /* Note - ensure that DYNobjectPlacer.DYNFUNmakeINIobjFileArrays() is run before using thias function to build the array of object INI files */
  local LOCerrMessage       = DYNuiResourcesErrorsWarnings[118]
  local LOCproceedSwitch    = true
  local LOCopsStyleContents = #()

  if (doesFileExist FUNopsFile) != true then LOCproceedSwitch = false

  if LOCproceedSwitch then (LOCopsStyleContents = DYNFUNparsePARAMfile FUNopsFile "1001")

  --- If no elements exist in the style at all
  if LOCopsStyleContents.count == 0 then
  (
    LOCproceedSwitch = false
    LOCerrMessage = DYNuiResourcesErrorsWarnings[119]
  )
  else
  (
    --- Build Object Library Array if ObjectPlacer paenl isn't open
    if not DYNobjectPlacer.open then (DYNobjectPlacer.DYNFUNmakeINIobjFileArrays())

    --- Cycle through each elenebt in the style
    for i = 1 to LOCopsStyleContents.count do
    (
      local LOCcategory = try (LOCopsStyleContents[i][10] as integer) catch (0)
      local LOCiniPath  = DYNFUNsetINIpath LOCcategory FUNmode

      if (subString LOCopsStyleContents[i][9] 1 1) != "[" then
      (
        --- For INI File Definitions
        local LOCiniFile  = LOCopsStyleContents[i][9]

        --- Checking procedure for each of the six object categories - check that object INI files exist
        local LOCfileExists = false

        if LOCcategory != 0 then
        (
          local LOCfileArray = DYNFUNiniGetBases LOCcategory FUNmode
          for ii = 1 to LOCfileArray.count do LOCfileArray[ii] = DYNFUNlowerCase LOCfileArray[ii]
          if (findItem LOCfileArray (DYNFUNlowerCase LOCiniFile)) > 0 then LOCfileExists = true
          if LOCfileExists == false then
          (
            LOCproceedSwitch = false
            LOCerrMessage = DYNuiResourcesErrorsWarnings[120]
            LOCerrMessage += "\n\n" + (LOCiniPath + LOCiniFile + ".ini")
          )
        )

        --- Check that an invalid object category has not been specified
        if LOCcategory != 1 and LOCcategory != 2 and LOCcategory != 3 and LOCcategory != 4 and LOCcategory != 5 and LOCcategory != 6 then
        (
          LOCproceedSwitch = false
          LOCerrMessage = DYNuiResourcesErrorsWarnings[121]
        )
      )
      else
      (
        --- Check whether referenced groups exist in INI file collection for current object category
        if LOCopsStyleContents[i][9] != "[]" then
        (
          local LOCgroupArray = DYNFUNiniGetUniqueValues LOCcategory "Group" "Name" FUNmode
          for ii = 1 to LOCgroupArray.count do LOCgroupArray[ii] = DYNFUNlowerCase LOCgroupArray[ii]
          append LOCgroupArray "ungrouped"
          local LOCiniGroup   = subString LOCopsStyleContents[i][9] 2 (LOCopsStyleContents[i][9].count - 2)
          if (findItem LOCgroupArray (DYNFUNlowerCase LOCiniGroup)) == 0 then
          (
            LOCproceedSwitch = false
            LOCerrMessage = DYNuiResourcesErrorsWarnings[122]
          )
        )
      )
    )
  )
  if LOCproceedSwitch == false and FUNshowErrors then (messagebox LOCerrMessage title:DYNuiResourcesTitlebars[1])
  LOCproceedSwitch -- return success value
)

--- Function to change the body colour of a vehicle
fn DYNFUNchangeVehicleBody FUNobj FUNid =
(
  local LOColdCol = (getAppData FUNobj 423) as integer
  setAppData FUNobj 423 (FUNid as string)

  --- For Vehicles Constructed of Editable Meshes
  if classOf FUNobj == editable_Mesh then
  (
    for i = 1 to FUNobj.numfaces do
    (
      if (getfacematid FUNobj i) == LOColdCol then (setfacematid FUNobj i FUNid)
    )
  )

  --- For Vehicles Constructed of Editable Polys
  if classOf FUNobj == editable_Poly then
  (
    local LOCbitArray = #{}; LOCbitArray.count = FUNobj.numfaces
    for i = 1 to FUNobj.numfaces do (if (polyOp.getFaceMatID FUNobj i) == LOColdCol do LOCbitArray[i] = true)
    PolyOp.setFaceMatID FUNobj LOCbitArray FUNid
  )
  update FUNobj

  --- Update AppData for this object and other instances of this object
  setAppData FUNobj 423 (FUNid as string)

  local LOCinstances = #()
  Instancemgr.getInstances FUNobj &LOCinstances

  for i in LOCinstances do (if isValidNode i then (setAppData i 423 (FUNid as string)))

  --- Finish Off
  DYNproperties.DYNFUNupdPropertiesPanel()
  if try (DYNvehicleParams.open) catch (false) then DYNvehicleParams.DDVISobjectParam.selection = FUNid
)


--- Function to Attach an object to an already placed object
fn DYNFUNattachObject FUNparentObj FUNattachObj FUNobjOffsetPt3 FUNzRotation =
(
  local LOCswitch = (isValidNode FUNparentObj and isValidNode FUNattachObj) -- required in seperate line to get return value below
  if LOCswitch then
  (
    --- here set positon, rotation and scale controllers back to default
    FUNattachObj.Transform.controller = transform_script() -- necessary to remove references to DYNXFCC/DYNXFCCV3/DYNXFCCM3
    FUNattachObj.Transform.controller = prs()

    --- Set parent object and retrieve position and rotation information
    FUNattachObj.parent   = FUNparentObj
    in coordsys parent FUNattachObj.pos      = [0,0,0]
    in coordsys parent FUNattachObj.rotation = (EulerAngles 0 0 0)

    FUNattachObj.objectOffsetPos     = [FUNobjOffsetPt3.x * -1, FUNobjOffsetPt3.y, FUNobjOffsetPt3.z]
    in coordsys parent (FUNattachObj.rotation.z_rotation = FUNzRotation)
  )
  LOCswitch -- return true or false to indicate whether was applied
)


--- Function tocalculate the basic draping coordinates for the extents of a given editable mesh
fn DYNFUNgetObjDrapingCoords FUNmesh FUNgivenCoords FUNmaterial FUNdispMessage FUNmatID =
(
  local LOCdiffuseMap
  local LOCcoordArray = #() ; LOCcoordArray[5] = undefined

  --- Calculate Basic Coords Based On Extent of Geometry of current object
  LOCcoordArray[1] = FUNmesh.min.x
  LOCcoordArray[2] = FUNmesh.min.y
  LOCcoordArray[3] = FUNmesh.max.x
  LOCcoordArray[4] = FUNmesh.max.y
  LOCcoordArray[5] = FUNmatID

  if classOf FUNmaterial.materialList[FUNmatID] == StandardMaterial  then LOCdiffuseMap = FUNmaterial.materialList[FUNmatID].diffuseMap
  if classOf FUNmaterial.materialList[FUNmatID] == Arch___Design__mi then LOCdiffuseMap = FUNmaterial.materialList[FUNmatID].diff_color_map

  if classOf LOCdiffuseMap == BitmapTexture then
  (
    if doesFileExist LOCdiffuseMap.fileName then -- catches problem if bitmap file does not exist
    (
      --- Make Attempt to Read Corresponding World File (If One Exists)
      --- catch error caused if bitmap is too large to be read!
      local LOCbitmap = try (LOCdiffuseMap.bitmap) catch (false)
      if LOCbitmap != false then
      (
        local LOCgeoRefCoordArray = DYNFUNreadWorldFile LOCdiffuseMap.bitmap -- automatically returns undefined if map not valid, or world file is invalid or does not exist
        if LOCgeoRefCoordArray != undefined then
        (
          LOCcoordArray = LOCgeoRefCoordArray
          if FUNdispMessage and FUNgivenCoords == #() then
          (
            messagebox (DYNuiResourcesErrorsWarnings[124]) title:DYNuiResourcesTitlebars[3]
          )
        )
      )
      else
      (
        messagebox (DYNuiResourcesErrorsWarnings[123]) title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  --- Calculate coords based on those provided in given function argument (overrides previous calculation if exists)
  if classof FUNgivenCoords == array and FUNgivenCoords != #() then
  (
    if FUNgivenCoords.count >= 4 then
    (
      LOCcoordArray[1] = FUNgivenCoords[1]
      LOCcoordArray[2] = FUNgivenCoords[2]
      LOCcoordArray[3] = FUNgivenCoords[3]
      LOCcoordArray[4] = FUNgivenCoords[4]
    )
  )

  --- Return Coordinate Array
  LOCcoordArray -- return value
)


--- Function to use SMesh modifier on a selected closed shape to produce a triangulated surface
fn DYNFUNtriangulateClosedSpline FUNshape FUNmaterial FUNmatID =
(
  local LOCnewNode
  if (DYNFUNclosedShapeFilter FUNshape) or classOf FUNshape == PolymorphicGeomShape then
  (
    LOCnewNode               = FUNshape
    LOCnewNode.name          = uniqueName (DYNuiResourcesNodeNames[25] + FUNshape.name)

    --- Set Up Object (must be prior to placing modifier in stack)
    LOCnewNode.pivot         = LOCnewNode.center
    LOCnewNode.material      = FUNmaterial
    LOCnewNode.wirecolor     = color 50 135 50
    local LOCcoordArray      = DYNFUNgetObjDrapingCoords LOCnewNode #() FUNmaterial false 31

    --- Apply Smesh Modifier
    addmodifier LOCnewNode (Civil_View_Spline_to_Mesh())
    local LOCsmeshMod = (CVGetMod LOCnewNode Civil_View_Spline_to_Mesh)

    --- Set Up Smesh Modifier Params (all listed here)
    DYNFUNmodifySmesh LOCsmeshMod FUNmatID [LOCcoordArray[1],LOCcoordArray[2]] [LOCcoordArray[3],LOCcoordArray[4]] 0.0

    local LOCfind1 = findItem DYNobjHandles[7]  LOCnewNode.inode.handle
    if LOCfind1 > 0 then
    (
      deleteItem DYNobjHandles[7] LOCfind1
      DYNFUNgenObjAppData LOCnewNode 8 FUNmatID (getAppData FUNshape 424) (getAppData FUNshape 425) (LOCcoordArray as string) (getAppData FUNshape 427) (getAppData FUNshape 428)
      if isValidNode LOCnewNode then (append DYNobjHandles[8] LOCnewNode.inode.handle)
    )
    else
    (
      local LOCfind2 = findItem DYNobjHandles[17] LOCnewNode.inode.handle
      if LOCfind2 > 0 then
      (
        deleteItem DYNobjHandles[17] LOCfind2
        if isValidNode LOCnewNode then (append DYNobjHandles[18] LOCnewNode.inode.handle)
      )
    )
  )
)



--- Function to change a facelist on an editable mesh from one matid to a new matid, taking into consideration primary mat id where appropriate
fn DYNFUNchangeMatIDforSubObj FUNsurface FUNoldMatID FUNnewMatID FUNfaceSelectionSet =
(
  local LOCresult = false                            -- Initialise Function Return Value
  if FUNoldMatID != FUNnewMatID then                 -- Ensure that a new matID selection is waiting to be applied
  (
    --- Initialise General Variables
    local MessageString       = DYNuiResourcesErrorsWarnings[9] + "\n\n" + DYNuiResourcesErrorsWarnings[10]
    local QuestionSwitch      = false                 -- Whether it is necessary to warn of other faces already containing selected matID
    local ProceedSwitch       = true                  -- Initialise variable to decide whether to proceed with final part of function
    local LOCdrapeCoords      = #()                   -- If changing to MatID 31, this variable will hold draping coordinates

    --- Get Primary Material Channel and see if Primary Channel Reference is negative (denotes that ungrouped tris were ignored on import from GENIO)
    local LOCungroupedIgnoreSwitch = false                 -- initialise switch
    local LOColdPrimaryID          = try ((getAppData FUNsurface 423) as integer) catch (0); if LOColdPrimaryID == undefined then LOColdPrimaryID = 0
    if LOColdPrimaryID < 0 then
    (
      LOCungroupedIgnoreSwitch = true                      -- Set flag to indicate that primary ID was negative
      LOColdPrimaryID    = LOColdPrimaryID * -1      -- Force old Primary ID to be positive value from here onwards
    )

    --- Get Existing Drape Coordinates from AppData
    local LOCexistCoordString = getAppData FUNsurface 426; if LOCexistCoordString == undefined then LOCexistCoordString = ""
    local LOCexistCoordArray  = filterString LOCexistCoordString "|"

    --- Detect whether any other faces on the surface already have new matID applied. If so, differential between these material types will be lost. Warn the User!
    if FUNfaceSelectionSet == undefined then
    (
      if classof FUNsurface == Editable_Mesh then
      (
        for ii = 1 to FUNsurface.numfaces do (if (getfacematid FUNsurface ii) == FUNnewMatID then QuestionSwitch = true)
      )
      if classof FUNsurface == Editable_Poly then
      (
        for ii = 1 to FUNsurface.numfaces do (if (polyOp.getFaceMatID FUNsurface ii) == FUNnewMatID then QuestionSwitch = true)
      )

      if QuestionSwitch then ProceedSwitch = querybox (FUNsurface.name + "\n\n" + MessageString) title:DYNuiResourcesTitlebars[3]
    )

    --- Only Proceed if User Answered "YES" to "Are you sure?" or if the question was not even asked
    if ProceedSwitch then
    (
      --- Modify Material Channel for all faces which contain old MatID
      if FUNfaceSelectionSet == undefined then
      (
        if classof FUNsurface == Editable_Mesh then
        (
          for ii = 1 to FUNsurface.numfaces do if (getfacematid FUNsurface ii) == FUNoldMatID then (setfacematid FUNsurface ii FUNnewMatID)
        )
        if classof FUNsurface == Editable_Poly then
        (
          local LOCbitArray = #{}
          LOCbitArray.count = FUNsurface.numfaces
          for ii = 1 to FUNsurface.numfaces do (if (polyOp.getFaceMatID FUNsurface ii) == FUNoldMatID do LOCbitArray[ii] = true)
          PolyOp.setFaceMatID FUNsurface LOCbitArray FUNnewMatID
        )
      )
      else
      (
        if classof FUNsurface == Editable_Mesh then
        (
          for ii in FUNsurface.faces[FUNfaceSelectionSet] do (setfacematid FUNsurface ii.index FUNnewMatID)
        )
        if classof FUNsurface == Editable_Poly then
        (
          PolyOp.setFaceMatID FUNsurface FUNfaceSelectionSet FUNnewMatID
        )
      )

      --- If Primary Material Channel was changed, update AppData accordingly
      if LOColdPrimaryID == FUNoldMatID then
      (
        setAppData FUNsurface 423 (if LOCungroupedIgnoreSwitch then ((FUNnewMatID * -1) as string) else (FUNnewMatID as string))
      )

      --- Re-apply draping settings to any faces using draped materials
      if FUNsurface.material == sceneMaterials[DYNmatNameSurfaces] then
      (
        if LOCexistCoordArray[1] == "@" then
        (
          for i = 2 to LOCexistCoordArray.count do
          (
            local LOCcoordArray = filterString LOCexistCoordArray[i] "$"
            if LOCcoordArray.count == 5 then
            (
              LOCdrapeCoords = #(LOCcoordArray[1] as float, LOCcoordArray[2] as float, LOCcoordArray[3] as float, LOCcoordArray[4] as float, LOCcoordArray[5] as integer)
              if (LOCcoordArray[5] as integer) == FUNnewMatID then
              (
                local LOCcoordArray = DYNFUNgetObjDrapingCoords FUNsurface LOCdrapeCoords FUNsurface.material false FUNnewMatID
                DYNFUNapplyPlanarMap FUNsurface [LOCdrapeCoords[1],LOCdrapeCoords[2]] [LOCdrapeCoords[3],LOCdrapeCoords[4]] FUNnewMatID
              )
            )
          )
        )
      )

      --- Finish Off
      update FUNsurface
      FUNsurface.material = FUNsurface.material      -- Ensure material is updated by reapplying it to the selected object
      LOCresult = true                               -- Ensure function returns true to indicate success

      clearUndoBuffer()
    )
  )
  LOCresult
)

fn DYNFUNcheckIsSplineShape FUNobj =
(
  if classOf FUNobj != PolymorphicGeomshape and classOf FUNobj != CV_Curveshape and classOf FUNobj != LinkBlockInstanceshape and classOf FUNobj != Arcshape then -- filter out DWG File Linked Shape Objects
  (
    if (classof FUNobj.baseObject == line) and ((CVGetMod FUNobj Edit_Spline) != undefined) and (classof FUNobj == splineshape) then
    (
      collapseStack FUNobj
    )
    if (classof FUNobj != splineshape) and (superClassOf FUNobj == shape) then
    (
      addmodifier FUNobj (edit_spline())
      collapseStack FUNobj
    )
  )
  FUNobj -- return value
)

fn DYNFUNconvertMetresToSystemUnit FUNfloat =
(
  local LOCunitMult = 1.0
  case units.SystemType of
  (
    #Inches      : LOCunitMult = 39.3700787
    #Feet        : LOCunitMult = 3.2808399
    #Miles       : LOCunitMult = 0.000621371192
    #Millimeters : LOCunitMult = 1000.0
    #Centimeters : LOCunitMult = 100.0
    #Meters      : LOCunitMult = 1.0
    #Kilometers  : LOCunitMult = 0.001
  )
  FUNfloat * LOCunitMult
)

--- Function to make a new forest object
fn DYNFUNmakeForest =
(
  local LOCforest
  local LOCproceedSwitch = true
  local LOCmessage = ""

  --- Check if correct conditions are met to create a new forest
  if DYNpluginStatus == 2 then LOCproceedSwitch = true else (LOCproceedSwitch = false; LOCmessage = DYNuiResourcesErrorsWarnings[2])

  if LOCproceedSwitch and selection.count != 1 then
  (
    LOCproceedSwitch = false
    LOCmessage       = DYNuiResourcesErrorsWarnings[4]
  )
  if LOCproceedSwitch and (superclassof selection[1]) != shape then
  (
    LOCproceedSwitch = false
    LOCmessage       = DYNuiResourcesErrorsWarnings[125]
  )
  if LOCproceedSwitch and (not (DYNFUNclosedShapeFilter selection[1])) then
  (
    LOCproceedSwitch = false
    LOCmessage       = DYNuiResourcesErrorsWarnings[126]
  )

  if LOCproceedSwitch then
  (
    if not DYNobjectPlacer.open then (DYNobjectPlacer.DYNFUNmakeINIobjFileArrays())

    local LOCsceneMats     = sceneMaterials
    local LOCmaterial      = if LOCsceneMats[DYNmatNameTrees] != undefined then LOCsceneMats[DYNmatNameTrees] else (DYNFUNmakeCivilViewTrees (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameTreeMaps + "\\"))
    local LOCparentShape   = selection[1]

    local LOCheight        = DYNFUNconvertMetresToSystemUnit 10.0
    local LOCwidth         = DYNFUNconvertMetresToSystemUnit 6.0

    --- Modify Panel Must Be Open for the following to work
    max Modify Mode

    --- Create Forest Object
    local LOCForestPackProRegistryKey
    local LOCForestPackLiteRegistryKey

    if (try forest_pro_3.category catch()) != undefined then
    (
      local LOCforestMapPath
      if (not maxops.IsSecureMode()) do
		registry.openKey HKEY_LOCAL_MACHINE "SOFTWARE\Itoo Software\Forest Pack Pro" accessRights:#readOnly key:&LOCForestPackProRegistryKey
      if classOf LOCForestPackProRegistryKey == HKey then
      (
        registry.queryValue LOCForestPackProRegistryKey  "MainDir" value:&LOCforestMapPath expand:true
      )
      if LOCforestMapPath == undefined then LOCforestMapPath = ""
      LOCforest = Forest_Pro_3 mapname:(LOCforestMapPath + "\\distmaps\\images\\spread1.bmp") mode:0 width:LOCwidth height:LOCheight pos:LOCparentShape.pos isSelected:on splineInc:LOCparentShape units_X:100 units_Y:100 applyscale:true
      LOCforest.update()
    )
    else
    (
      local LOCforestMapPath
      if (not maxops.IsSecureMode()) do
		registry.openKey HKEY_LOCAL_MACHINE "SOFTWARE\Itoo Software\Forest Pack Lite" accessRights:#readOnly key:&LOCForestPackLiteRegistryKey
      if classOf LOCForestPackLiteRegistryKey == HKey then
      (
        registry.queryValue LOCForestPackLiteRegistryKey "MainDir" value:&LOCforestMapPath expand:true
      )
      if LOCforestMapPath == undefined then LOCforestMapPath = ""
      LOCforest = Forest_Lite_3 mapname:(LOCforestMapPath + "\\distmaps\\images\\spread1.bmp") mode:0 width:LOCwidth height:LOCheight pos:LOCparentShape.pos isSelected:on splineInc:LOCparentShape units_X:100 units_Y:100 applyscale:true
      LOCforest.update()
    )
    if classOf LOCForestPackProRegistryKey  == HKey then (registry.closeKey LOCForestPackProRegistryKey;  LOCForestPackProRegistryKey  = undefined)
    if classOf LOCForestPackLiteRegistryKey == HKey then (registry.closeKey LOCForestPackLiteRegistryKey; LOCForestPackLiteRegistryKey = undefined)

    --- Redraw Views
    max views redraw

    --- Default Forest Parameters
    LOCforest.tempidlist   = #(1)
    LOCforest.tempnamelist = #(DYNuiResourcesNodeNames[26])
    LOCforest.applyscale
    LOCforest.scalezmin    = 100 - DYNINItreeVariation -- Set MIN scaling of trees on Z axis
    LOCforest.scalezmax    = 100 + DYNINItreeVariation -- Set MAX scaling of trees on Z axis
    LOCforest.scalexmin    = 100 - DYNINItreeVariation -- Set MIN scaling of trees on X axis
    LOCforest.scalexmax    = 100 + DYNINItreeVariation -- Set MAX scaling of trees on X axis
    LOCforest.lock_ratio   = true                      -- Lock distribution map ratio
    LOCforest.wireColor    = (color 150 175 25)        -- Set standard wirecolor for trees
    LOCforest.camlook      = false                     -- Set to DO NOT LOOK at camera
    LOCforest.camlimit     = false                     -- Do not limit visability to camera
    LOCforest.backfaceCull = false                     -- Turn Off BackFace cull
    LOCforest.enabled      = true
    LOCforest.update()
    /*
    LOCforest.material     = LOCmaterial
    LOCforest.matID        = 1                         -- Set default Material Channel ID
    */

    /*
        .iconsize (Icon_Size) : float
        .seed : integer
        .seedtype (Seed_Type) : integer
        .threads : integer
        .cobjlist : node array
        .matlist (Material_List) : material array
        .namelist : string array
        .geomlist : int array
        .tempidlist : int array
        .tempnamelist : string array
        .widthlist : float array
        .heightlist : float array
        .zoffsetlist : float array
        .centerlist : int array
        .usemeshdimlist : boolean array
        .problist : int array
        .libsize (Get_Size_from_Library) : boolean
        .globsize (Use_Global_Size) : boolean
        .width : float
        .height : float
        .globscale (Global_Scale) : float
        .consmat (Consolidate_Materials) : boolean
        .splineinc (Spline_Inc) : node
        .splineexc (Spline_Exc) : node
        .splinef (Spline_Following) : node
        .spfwidth (Spline_Following_Width) : float
        .algpick (Realign_when_Picking) : boolean
        .spdenscurve (Area_Fallof_Curve) : maxObject
        .spdensact (Area_Fallof_Active) : boolean
        .spincrange (Include_Area_Fallof_Range) : float
        .spexcrange (Area_Exclude_Fallof_Range) : float
        .mapname (Distribution_Map) : string
        .units_x : float
        .units_y : float
        .lock_ratio : boolean
        .collision (Detect_Collisions) : boolean
        .separation (Tree_Separation) : integer
        .offset_x : float
        .offset_y : float
        .drotation (Map_Rotation) : float
        .threshold : integer
        .sdgizmo (Draw_Gizmo_Corners) : boolean
        .maxdensity (Max__Density) : integer
        .mode : integer
        .consgeom (Consolidate_Geometry) : boolean
        .crpath : node
        .crptype (Path_Distribution) : integer
        .crspacing (Path_Spacing) : float
        .crdelete (Delete_Trees) : boolean
        .camera : node
        .camauto (Camera_Auto) : boolean
        .camonlyrend (Auto_Camera_only_in_Render) : boolean
        .camlimit (Cam_Limit) : boolean
        .camlook (Cam_Look) : boolean
        .custcamlook (Custom_Objecs_Facing_Camera) : boolean
        .camwidth (Cam_Width) : integer
        .camnear (Cam_Near) : float
        .camfar (Cam_Far) : float
        .cambho (Cam_Back_Offset) : float
        .camdenscurve (Camera_Fallof_Curve) : maxObject
        .camdensact (Camera_Fallof_Active) : boolean
        .camdensnear (Camera_Fallof_Min) : float
        .camdensfar (Camera_Fallof_Max) : float
        .usefakeshadows (Use_Fake_Shadows) : boolean
        .light : node
        .hshadow (Horizontal_Shadow) : boolean
        .vshadow (Vertical_shadow) : boolean
        .hsplanes (Hide_Shadow_Planes) : boolean
        .custshadow (Shadow_on_Custom_Objects) : boolean
        .hsoffset (Horizontal_Shadow_Offset) : integer
        .hsscale (Horizontal_Shadow_Scale) : integer
        .selfshadow (Prevent_Self_Shadow) : boolean
        .ssitself (SS_every_tree_itself) : boolean
        .surface : node
        .altlimited (Alt_Limited) : boolean
        .altmax (Alt_Max) : float
        .altmin (Alt_Min) : float
        .slopelimited (Slope_Limited) : boolean
        .slopemax (Slope_Max) : float
        .slopemin (Slope_Min) : float
        .surfanim (Follow_Animation) : boolean
        .surfanir (Only_in_Render) : boolean
        .linkeditsurf (Link_to_Surface) : boolean
        .applytranslation (Apply_Translation) : boolean
        .translationx (Translation_X) : integer
        .translationy (Translation_Y) : integer
        .applyrotation (Apply_Rotation) : boolean
        .rotmax (Rotation_Max) : integer
        .rotmin (Rotation_Min) : integer
        .applyscale (Apply_Scale) : boolean
        .scalexmax (Scale_X_Max) : integer
        .scalexmin (Scale_X_Min) : integer
        .scalezmax (Scale_Z_Max) : integer
        .scalezmin (Scale_Z_Min) : integer
        .scalelock (Scale_Lock) : boolean
        .mirror (Random_Mirror) : boolean
        .custmirror (Mirror_on_Custom_Objects) : boolean
        .tintcolor1 (Tint_Color_1) : RGB color
        .tintcolor2 (Tint_Color_2) : RGB color
        .tintmin (Tint_Min) : integer
        .tintmax (Tint_Max) : integer
        .custint (Tint_Custom_Objects) : boolean
        .fastopac (Fast_Opacity) : boolean
        .tracedepth (Trace_Depth) : integer
        .opaclevel (Opacity_Level) : float
        .selfillum (Self_illum_Factor) : integer
        .irradiance (Irradiance_Color) : RGB color
        .animation : integer
        .animsoffset (Animation_Start) : time
        .animsamples (Animation_Samples) : integer
        .animonlyrend (Animate_only_at_Render_Time) : boolean
        .vmesh (Viewport_Mesh) : integer
        .vskip (Viewport_Simplification) : integer
        .adaptfaces (Adaptative_Faces) : integer
        .rmesh (Render_Mesh) : integer
        .rskip (Render_Simplification) : integer
        .maxtrees (Maximum_number_of_Trees) : integer
        .maxfaces (Maximum_number_of_Faces) : integer
        .disableall (Disable_ALL_Forest_objects) : boolean
    */

    DYNFUNgenObjAppData LOCforest "11" "1" "" (execute "(DYNFUNgetLocalTime())") "" "" "" -- Default values - 3 > mostly overwritten in section below
    if isValidNode LOCforest then (append DYNobjHandles[11] LOCforest.inode.handle)

    DYNFUNnodeCreatedCallback() -- will check arrays for invalid node handles, then update Explorer Tree
    max views redraw
    if isValidNode LOCforest then select LOCforest
  )
  else
  (
    messagebox LOCmessage title:DYNuiResourcesTitlebars[1]
  )
  LOCforest -- return value
)

--- Function to open Preferences Panel
fn DYNFUNopenPreferencesPanel FUNtab =
(
  if DYNpreferences == undefined then fileIn (DYNscriptsPath + "Preferences.ms")
  createDialog DYNpreferences width:503 height:337 modal:false
  DYNpreferences.DYNFUNmoveControls FUNtab
)

--- Function to check which MX strings have already been imported into Civil View
fn DYNFUNcheckForImportedObjects =
(
  local LOCpreviouslyImportedObjectsByAppData = #()

  for cat = 1 to DYNimportCatsArray.count do
  (
    for i in DYNimportSuperClassArray[cat] do
    (
      if (getAppData i 422) == (DYNimportCatsArray[cat] as string) then
      (
        --- Add String Label and Model Name to the Array
        append LOCpreviouslyImportedObjectsByAppData (((getAppData i 427) as string) + "|" + ((getAppData i 428) as string) + "|" + (DYNimportCatsArray[cat] as string))
      )
    )
  )

  LOCpreviouslyImportedObjectsByAppData -- return value
)

fn DYNFUNdisplayAppDataInUI FUNinputString =
(
  if FUNinputString == "" then FUNinputString else ((filterString FUNinputString "$!!$")[1])
)

--- Function to select strings from an array of objects which match a string mask and model name
fn DYNFUNgetStringsByMask FUNobjectArray FUNmodelMask FUNstringMask FUNselectShapesOrSurfaces =
(
  /* FUNselectShapesOrSurfaces is true for shapes and false for surfaces */
  local LOCselectionArray = #()
  for i in FUNobjectArray do
  (
    if isValidNode i then
    (
      local LOCstringLabel = try ((filterString (getAppData i 427) "$!!$")[1]) catch ()
      local LOCmodelLabel  = try ((filterString (getAppData i 428) "$!!$")[1]) catch ()
      local LOCselectCriteria = if FUNselectShapesOrSurfaces then ((SuperClassOf i) == Shape) else ((SuperClassOf i) == GeometryClass)
      --- See if string mask and model name matches this object
      if classof LOCstringLabel == string and classof LOCmodelLabel == string then
      (
        if (matchPattern LOCstringLabel pattern:FUNstringMask ignoreCase:true) and (matchPattern LOCmodelLabel pattern:FUNmodelMask ignoreCase:true) and LOCselectCriteria then append LOCselectionArray i
      )
    )
  )
  LOCselectionArray -- return value
)

fn DYNFUNgetAllResourceKitStyles FUNpath =
(
  local LOCoutputStyles = #()

  --- Grab Country Resource Kit FIS styles
  if (DYNFUNdoesFolderExist (DYNcountryPath + (getfilenamepath FUNpath))) then
  (
    local LOCfeatureStyles1      = DYNFUNgetfiles (getFilenamePath (DYNcountryPath + FUNpath)) 0 (filenameFromPath FUNpath)
    for i = 1 to LOCfeatureStyles1.count do LOCfeatureStyles1[i] = DYNcountryPrefix + LOCfeatureStyles1[i]
    LOCoutputStyles = LOCfeatureStyles1 + LOCoutputStyles
  )

  --- Grab Project Resource Kit Feature Interpretation Styles
  if DYNINIprojectKit != "0" and (DYNFUNdoesFolderExist (rootNode.DYNrootNodeStore.string02 + (getfilenamepath FUNpath))) then
  (
    local LOCfeatureStyles2      = DYNFUNgetfiles (getFilenamePath (rootNode.DYNrootNodeStore.string02 + FUNpath)) 0 (filenameFromPath FUNpath)
    for i = 1 to LOCfeatureStyles2.count do LOCfeatureStyles2[i] = DYNprojectPrefix + LOCfeatureStyles2[i]
    LOCoutputStyles = LOCfeatureStyles2 + LOCoutputStyles
  )

  --- Grab Private Resource Kit FIS styles
  if DYNINIprivateKit == "1" and (DYNFUNdoesFolderExist (DYNINIprivateKitPath + (getfilenamepath FUNpath))) then
  (
    local LOCfeatureStyles3      = DYNFUNgetfiles (getFilenamePath (DYNINIprivateKitPath + FUNpath)) 0 (filenameFromPath FUNpath)
    for i = 1 to LOCfeatureStyles3.count do LOCfeatureStyles3[i] = DYNprivatePrefix + LOCfeatureStyles3[i]
    LOCoutputStyles = LOCfeatureStyles3 + LOCoutputStyles
  )

  LOCoutputStyles -- Output Array
)

--- Function To Set Up and Populate FIS controls in all Import Panels
fn DYNFUNsetUpFeatureInterpControls FUNrollout =
(
  local LOCfeatureStyles            = DYNFUNgetAllResourceKitStyles DYNlocalFisPath
  FUNrollout.DDDYNfeatureList.items = LOCfeatureStyles
  FUNrollout.BUDYNfeatureEdit.text  = DYNuiResourcesButtons[9]
  FUNrollout.BUDYNfeatureNew.text   = DYNuiResourcesButtons[10]
  FUNrollout.CKDYNfeatureOn.text    = DYNuiResourcesLabels[513]

  if LOCfeatureStyles.count > 0 then
  (
    FUNrollout.DDDYNfeatureList.enabled = if FUNrollout.CKDYNfeatureOn.checked then true else false
    FUNrollout.CKDYNfeatureOn.enabled   = true
  )
  else
  (
    FUNrollout.DDDYNfeatureList.enabled = false
    FUNrollout.CKDYNfeatureOn.enabled   = false
    FUNrollout.CKDYNfeatureOn.checked   = false
  )

  LOCfeatureStyles -- return value
)

--- Function to check whether a FIS style is valid and references styles which actually exist in the current country kit
fn DYNFUNfisPreFlight FUNfisStyle =
(
  local LOCproceedSwitch = false
  if doesFileExist FUNfisStyle then
  (
    LOCproceedSwitch = true
    local LOCfisArray      = DYNFUNparsePARAMfile FUNfisStyle "4001"
    local LOCproblemFile   = ""
    for i = 1 to LOCfisArray.count do
    (
      --- Check Style Reference
      if LOCfisArray[i][3] != "" then
      (
        local LOCfileExt = DYNFUNlowerCase (getFilenameType LOCfisArray[i][3])
        if LOCfileExt != ".ros" and LOCfileExt != ".sos" and LOCfileExt != ".rms" and LOCfileExt != ".ops" and LOCfileExt != ".bos" then
        (
          LOCproceedSwitch = false
          LOCproblemFile = LOCfisArray[i][3]
        )
        else
        (
          if LOCfileExt == ".rms" then
          (
            local LOCfileFoundSwitch = false
            if DYNINIprivateKit == "1" and (doesFileExist (DYNINIprivateKitPath + DYNstringRMSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if DYNINIprojectKit != "0" and (doesFileExist (rootNode.DYNrootNodeStore.string02 + DYNstringRMSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if (doesFileExist (DYNcountryPath + DYNstringRMSfolderName + "\\" + LOCfisArray[i][3]))                                   then LOCfileFoundSwitch = true
            if not LOCfileFoundSwitch then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3])
          )

          if LOCfileExt == ".bos" then
          (
            local LOCfileFoundSwitch = false
            if DYNINIprivateKit == "1" and (doesFileExist (DYNINIprivateKitPath + DYNstringBOSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if DYNINIprojectKit != "0" and (doesFileExist (rootNode.DYNrootNodeStore.string02 + DYNstringBOSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if (doesFileExist (DYNcountryPath + DYNstringBOSfolderName + "\\" + LOCfisArray[i][3]))                                   then LOCfileFoundSwitch = true
            if not LOCfileFoundSwitch then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3])
          )

          if LOCfileExt == ".sos" then
          (
            local LOCfileFoundSwitch = false
            if DYNINIprivateKit == "1" and (doesFileExist (DYNINIprivateKitPath + DYNstringSOSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if DYNINIprojectKit != "0" and (doesFileExist (rootNode.DYNrootNodeStore.string02 + DYNstringSOSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if (doesFileExist (DYNcountryPath + DYNstringSOSfolderName + "\\" + LOCfisArray[i][3]))                                   then LOCfileFoundSwitch = true
            if not LOCfileFoundSwitch then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3])
          )

          if LOCfileExt == ".ros" then
          (
            local LOCfileFoundSwitch = false
            if DYNINIprivateKit == "1" and (doesFileExist (DYNINIprivateKitPath + DYNstringROSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if DYNINIprojectKit != "0" and (doesFileExist (rootNode.DYNrootNodeStore.string02 + DYNstringROSfolderName + "\\" + LOCfisArray[i][3])) then LOCfileFoundSwitch = true
            if (doesFileExist (DYNcountryPath + DYNstringROSfolderName + "\\" + LOCfisArray[i][3]))                                   then LOCfileFoundSwitch = true
            if not LOCfileFoundSwitch then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3])
          )

          if LOCfileExt == ".ops" then
          (
            local LOCfileFoundSwitch = false
            if DYNINIprivateKit == "1" and (doesFileExist (DYNINIprivateKitPath + DYNstringOPSfolderName + "\\" + LOCfisArray[i][3])) then (LOCfileFoundSwitch = true; if not (DYNFUNvalidateOPSstyle (DYNINIprivateKitPath + DYNstringOPSfolderName + "\\" + LOCfisArray[i][3]) false 3) then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3]))
            if DYNINIprojectKit != "0" and (doesFileExist (rootNode.DYNrootNodeStore.string02 + DYNstringOPSfolderName + "\\" + LOCfisArray[i][3])) then (LOCfileFoundSwitch = true; if not (DYNFUNvalidateOPSstyle (rootNode.DYNrootNodeStore.string02 + DYNstringOPSfolderName + "\\" + LOCfisArray[i][3]) false 2) then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3]))
            if (doesFileExist (DYNcountryPath + DYNstringOPSfolderName + "\\" + LOCfisArray[i][3]))                                   then (LOCfileFoundSwitch = true; if not (DYNFUNvalidateOPSstyle (DYNcountryPath + DYNstringOPSfolderName + "\\" + LOCfisArray[i][3]) false 1) then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3]))
            if not LOCfileFoundSwitch then (LOCproceedSwitch = false; LOCproblemFile = LOCfisArray[i][3])
          )
        )
      )
    )
    if not LOCproceedSwitch then
    (
      local LOCmessage = if LOCproblemFile == "" then (DYNuiResourcesErrorsWarnings[128]) else (DYNuiResourcesErrorsWarnings[129] + "\n\n" + LOCproblemFile)
      messagebox LOCmessage title:DYNuiResourcesTitlebars[2]
    )
  )
  else
  (
    messageBox (DYNuiResourcesErrorsWarnings[127]) title:DYNuiResourcesTitlebars[1]
  )
  LOCproceedSwitch -- return success value
)

--- Function to check whether an SOS style is valid
fn DYNFUNsosPreFlight FUNsosFile =
(
  local LOCproceedSwitch = true
  if FUNsosFile != undefined then
  (
    local LOCmatCnt = DYNINImatIDlimit
    local LOCstyleContents = DYNFUNparsePARAMfile FUNsosFile "2000"        -- Extract style info from File

    --- Check Span, Close, and Cap Material ID Specified in Style
    for i = 1 to LOCstyleContents.count do
    (
      local LOCmat1 = try (LOCstyleContents[i][7] as integer) catch (1000) -- Spanning
      local LOCmat2 = try (LOCstyleContents[i][8] as integer) catch (1000) -- Closing
      local LOCmat3 = try (LOCstyleContents[i][9] as integer) catch (1000) -- Capping
      if LOCmat1 < -LOCmatCnt or LOCmat1 > LOCmatCnt then LOCproceedSwitch = false
      if LOCmat2 < -LOCmatCnt or LOCmat2 > LOCmatCnt then LOCproceedSwitch = false
      if LOCmat3 < -LOCmatCnt or LOCmat3 > LOCmatCnt then LOCproceedSwitch = false
    )

    --- Checl MatID used on each style element
    local LOCstyleContents = DYNFUNparsePARAMfile FUNsosFile "2001"           -- Extract style info from File
    for i = 1 to LOCstyleContents.count do
    (
      local LOCmat = try (LOCstyleContents[i][10] as integer) catch (1000)
      if LOCmat < -LOCmatCnt or LOCmat > LOCmatCnt then LOCproceedSwitch = false
    )
  )
  LOCproceedSwitch -- return value
)

--- Following two functions used in Swept Object Panel - must be specified here becasue also used in FIS styles.
fn DYNFUNsideSettings FUNparamFileSettings =
(
  local LOCddSel = 1 -- Drop Down List Item Selection
  local LOCside  = try (FUNparamFileSettings[1] as integer) catch (0) -- FIle Setting (-1,0,1)
  if LOCside < 0 then LOCddSel = 2 -- Left Side Onlt
  if LOCside > 0 then LOCddSel = 3 -- Right Side Only
  LOCddSel
)

--- Function to make the properties of one object or modifier match the properties of another
fn DYNFUNmatchProperties FUNsource FUNtarget =
(
  --- If source and target are modifiers or anything else (including nodes), get property names from one and apply to the other
  if FUNsource != undefined and FUNtarget != undefined then
  (
    local LOCprops = getPropNames FUNsource
    for i in LOCprops do (try (setProperty FUNtarget i (getProperty FUNsource i)) catch ())
  )

  --- If objects are specifically NODES (as opposed to modifiers), additionally copy all standard universal node properties which are not picked up by above code
  if isValidNode FUNsource and isValidNode FUNtarget then
  (
    --- Basic Properties
    if isProperty FUNtarget #name                      then FUNtarget.name                      = FUNsource.name
    if isProperty FUNtarget #material                  then FUNtarget.material                  = FUNsource.material

    --- This Section Mainly Viewport Related Properties
    if isProperty FUNtarget #renderable                then FUNtarget.renderable                = FUNsource.renderable
    if isProperty FUNtarget #boxmode                   then FUNtarget.boxmode                   = FUNsource.boxmode
    if isProperty FUNtarget #alledges                  then FUNtarget.alledges                  = FUNsource.alledges
    if isProperty FUNtarget #backfacecull              then FUNtarget.backfacecull              = FUNsource.backfacecull
    if isProperty FUNtarget #castShadows               then FUNtarget.castShadows               = FUNsource.castShadows
    if isProperty FUNtarget #receiveshadows            then FUNtarget.receiveshadows            = FUNsource.receiveshadows
    if isProperty FUNtarget #wirecolor                 then FUNtarget.wirecolor                 = FUNsource.wirecolor
    if isProperty FUNtarget #gbufferchannel            then FUNtarget.gbufferchannel            = FUNsource.gbufferchannel
    if isProperty FUNtarget #visibility                then FUNtarget.visibility                = FUNsource.visibility
    if isProperty FUNtarget #motionblur                then FUNtarget.motionblur                = FUNsource.motionblur
    if isProperty FUNtarget #imageMotionBlurMultiplier then FUNtarget.imageMotionBlurMultiplier = FUNsource.imageMotionBlurMultiplier
    if isProperty FUNtarget #showLinks                 then FUNtarget.showLinks                 = FUNsource.showLinks
    if isProperty FUNtarget #showLinksOnly             then FUNtarget.showLinksOnly             = FUNsource.showLinksOnly
    if isProperty FUNtarget #isfrozen                  then FUNtarget.isfrozen                  = FUNsource.isfrozen
    if isProperty FUNtarget #isnodefrozen              then FUNtarget.isnodefrozen              = FUNsource.isnodefrozen
    if isProperty FUNtarget #ishidden                  then FUNtarget.ishidden                  = FUNsource.ishidden
    if isProperty FUNtarget #isnodehidden              then FUNtarget.isnodehidden              = FUNsource.isnodehidden
    if isProperty FUNtarget #showFrozenInGray          then FUNtarget.showFrozenInGray          = FUNsource.showFrozenInGray
    if isProperty FUNtarget #showTrajectory            then FUNtarget.showTrajectory            = FUNsource.showTrajectory
    if isProperty FUNtarget #vertexColorsShaded        then FUNtarget.vertexColorsShaded        = FUNsource.vertexColorsShaded
    if isProperty FUNtarget #inheritVisibility         then FUNtarget.inheritVisibility         = FUNsource.inheritVisibility
    if isProperty FUNtarget #xray                      then FUNtarget.xray                      = FUNsource.xray
    if isProperty FUNtarget #ignoreExtents             then FUNtarget.ignoreExtents             = FUNsource.ignoreExtents
    if isProperty FUNtarget #renderOccluded            then FUNtarget.renderOccluded            = FUNsource.renderOccluded
    if isProperty FUNtarget #motionBlurOn              then FUNtarget.motionBlurOn              = FUNsource.motionBlurOn
    if isProperty FUNtarget #rcvCaustics               then FUNtarget.rcvCaustics               = FUNsource.rcvCaustics
    if isProperty FUNtarget #generateCaustics          then FUNtarget.generateCaustics          = FUNsource.generateCaustics
    if isProperty FUNtarget #rcvGlobalIllum            then FUNtarget.rcvGlobalIllum            = FUNsource.rcvGlobalIllum
    if isProperty FUNtarget #generateGlobalIllum       then FUNtarget.generateGlobalIllum       = FUNsource.generateGlobalIllum
    if isProperty FUNtarget #vertexTicks               then FUNtarget.vertexTicks               = FUNsource.vertexTicks

    --- INodeGIProperties: The following properties correspond to the UI controls found in the Adv. Lighting tab of the Object Properties dialog in 3ds max 5 and higher.
    if isProperty FUNtarget #isGIExcluded              then FUNtarget.isGIExcluded              = FUNsource.isGIExcluded              -- Corresponds to the Exclude from Radiosity Processing checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #isGIOccluder              then FUNtarget.isGIOccluder              = FUNsource.isGIOccluder              -- Corresponds to the Cast Shadows checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #isGIReceiver              then FUNtarget.isGIReceiver              = FUNsource.isGIReceiver              -- Corresponds to the Receive Illumination checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #isGIDiffuse               then FUNtarget.isGIDiffuse               = FUNsource.isGIDiffuse               -- Corresponds to the Diffuse (reflective & translucent) checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #isGISpecular              then FUNtarget.isGISpecular              = FUNsource.isGISpecular              -- Corresponds to the Specular (reflective & translucent) checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #GIUseGlobalMeshing        then FUNtarget.GIUseGlobalMeshing        = FUNsource.GIUseGlobalMeshing        -- Corresponds to the Use Global Subdivision Settings checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #GIMeshingEnabled          then FUNtarget.GIMeshingEnabled          = FUNsource.GIMeshingEnabled          -- Corresponds to the Subdivide checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #nbGIRefineSteps           then FUNtarget.nbGIRefineSteps           = FUNsource.nbGIRefineSteps           -- Corresponds to the Refine Iterations value in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #nbGIRefineStepsDone       then FUNtarget.nbGIRefineStepsDone       = FUNsource.nbGIRefineStepsDone       -- Corresponds to the Iterations Done value in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #GIMeshSize                then FUNtarget.GIMeshSize                = FUNsource.GIMeshSize                -- Corresponds to the Meshing Size value in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #isGIExcludedFromRegather  then FUNtarget.isGIExcludedFromRegather  = FUNsource.isGIExcludedFromRegather  -- Corresponds to the Exclude from Regathering checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #storeIllumToMesh          then FUNtarget.storeIllumToMesh          = FUNsource.storeIllumToMesh          -- Corresponds to the Store Direct Illumination in Mesh checkbox in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #GIByLayer                 then FUNtarget.GIByLayer                 = FUNsource.GIByLayer                 -- Corresponds to the By Layer / By Object checkbutton in the Object Properties > Adv. Lighting tab
    if isProperty FUNtarget #GIRayMult                 then FUNtarget.GIRayMult                 = FUNsource.GIRayMult                 -- Corresponds to the Num. Regathering Rays Multiplier value in the Object Properties > Adv. Lighting tab= FUNsource.

    --- INodeLayerProperties : Layer Properties
    if isProperty FUNtarget #displayByLayer            then FUNtarget.displayByLayer            = FUNsource.displayByLayer
    if isProperty FUNtarget #motionByLayer             then FUNtarget.motionByLayer             = FUNsource.motionByLayer
    if isProperty FUNtarget #renderByLayer             then FUNtarget.renderByLayer             = FUNsource.renderByLayer
    if isProperty FUNtarget #colorByLayer              then FUNtarget.colorByLayer              = FUNsource.colorByLayer
    if isProperty FUNtarget #globalIlluminationByLayer then FUNtarget.globalIlluminationByLayer = FUNsource.globalIlluminationByLayer

    --- INode : This represents a Node Interface providing access to some properties and methods available in all nodes.
    if isProperty FUNtarget #primaryVisibility         then FUNtarget.primaryVisibility         = FUNsource.primaryVisibility         -- Gets/Sets the nodes Visible to Camera option.
    if isProperty FUNtarget #secondaryVisibility       then FUNtarget.secondaryVisibility       = FUNsource.secondaryVisibility       -- Gets/Sets the nodes Visible to Reflection/Refraction option.
    if isProperty FUNtarget #applyAtmospherics         then FUNtarget.applyAtmospherics         = FUNsource.applyAtmospherics         -- Gets/Sets the nodes Apply Atmospherics option.
    if isProperty FUNtarget #showVertexColors          then FUNtarget.showVertexColors          = FUNsource.showVertexColors

    --- Other Node Properties Which We Do Not Touch (mostly for obvious reasons)
    --if isProperty FUNtarget #position                  then FUNtarget.position                  = FUNsource.position
    --if isProperty FUNtarget #rotation                  then FUNtarget.rotation                  = FUNsource.rotation
    --if isProperty FUNtarget #scale                     then FUNtarget.scale                     = FUNsource.scale
    --if isProperty FUNtarget #pivot                     then FUNtarget.pivot                     = FUNsource.pivot
    --if isProperty FUNtarget #parent                    then FUNtarget.parent                    = FUNsource.parent
    --if isProperty FUNtarget #children                  then FUNtarget.children                  = FUNsource.children
    --if isProperty FUNtarget #min                       then FUNtarget.min                       = FUNsource.min
    --if isProperty FUNtarget #max                       then FUNtarget.max                       = FUNsource.max
    --if isProperty FUNtarget #center                    then FUNtarget.center                    = FUNsource.center
    --if isProperty FUNtarget #dir                       then FUNtarget.dir                       = FUNsource.dir
    --if isProperty FUNtarget #objectoffsetpos           then FUNtarget.objectoffsetpos           = FUNsource.objectoffsetpos
    --if isProperty FUNtarget #objectoffsetrot           then FUNtarget.objectoffsetrot           = FUNsource.objectoffsetrot
    --if isProperty FUNtarget #objectoffsetscale         then FUNtarget.objectoffsetscale         = FUNsource.objectoffsetscale
    --if isProperty FUNtarget #objecttransform           then FUNtarget.objecttransform           = FUNsource.objecttransform
    --if isProperty FUNtarget #modifiers                 then FUNtarget.modifiers                 = FUNsource.modifiers
    --if isProperty FUNtarget #custAttributes            then FUNtarget.custAttributes            = FUNsource.custAttributes
    --if isProperty FUNtarget #transform                 then FUNtarget.transform                 = FUNsource.transform
    --if isProperty FUNtarget #baseObject                then FUNtarget.baseObject                = FUNsource.baseObject

    --- Target / Look At Related Properties
    --if isProperty FUNtarget #istarget                  then FUNtarget.istarget                  = FUNsource.istarget
    --if isProperty FUNtarget #target                    then FUNtarget.target                    = FUNsource.target
    --if isProperty FUNtarget #lookat                    then FUNtarget.lookat                    = FUNsource.lookat
    --if isProperty FUNtarget #targetDistance            then FUNtarget.targetDistance            = FUNsource.targetDistance

    --- Read Only Properties
    --if isProperty FUNtarget #ishiddenInVpt             then FUNtarget.ishiddenInVpt             = FUNsource.ishiddenInVpt
    --if isProperty FUNtarget #motionBlurOnController    then FUNtarget.motionBlurOnController    = FUNsource.motionBlurOnController
    --if isProperty FUNtarget #isdependent               then FUNtarget.isdependent               = FUNsource.isdependent
    --if isProperty FUNtarget #isDeleted                 then FUNtarget.isDeleted                 = FUNsource.isDeleted
    --if isProperty FUNtarget #isSelected                then FUNtarget.isSelected                = FUNsource.isSelected
  )
)

--- Function to....
fn DYNFUNunlinkNodeInstance FUNrollout FUNobj FUNobjectSwitch FUNproceed =
(
  undo off
  (
    if not FUNproceed then (FUNproceed = queryBox (DYNuiResourcesQueries[10]) title:DYNuiResourcesTitlebars[2])
    if FUNproceed then
    (
      try (removeRollout DYNpositionControl DYNmainFloater) catch ()
      DYNFUNloadVSPnodeCallBacks false
      (
        local LOColdObject    = FUNobj
        FUNobj                = copy FUNobj
        if (getAppData LOColdObject 422) != undefined and (getAppData LOColdObject 423) != undefined and (getAppData LOColdObject 424) != undefined and (getAppData LOColdObject 425) != undefined and (getAppData LOColdObject 426) != undefined and (getAppData LOColdObject 427) != undefined and (getAppData LOColdObject 428) != undefined then
        (
          DYNFUNgenObjAppData FUNobj (getAppData LOColdObject 422) (getAppData LOColdObject 423) (getAppData LOColdObject 424) (getAppData LOColdObject 425) (getAppData LOColdObject 426) (getAppData LOColdObject 427) (getAppData LOColdObject 428)
        )
        FUNobj.name           = LOColdObject.name
        FUNobj.wirecolor      = LOColdObject.wirecolor
        if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl #(FUNobj) false

        --- What about child objects?
        if LOColdObject.children.count > 0 then
        (
          for i = LOColdObject.children.count to 1 by -1 do
          (
            LOColdObject.children[i].parent = FUNobj
          )
        )

        --- Delete Old Object and Add New One to DynobjHandle Arrays
        if isValidNode LOColdObject then delete LOColdObject
        if isValidNode FUNobj then append DYNobjHandles[FUNobjectSwitch] FUNobj.inode.handle
      )
      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback() -- will check arrays for invalid node handles, then update Explorer Tree
    )
    else FUNrollout.CBDYNlinked.checked = true
  )
  FUNobj -- return value
)

--- Function to...
fn DYNFUNgatherInstancesOfNode FUNrollout FUNobject =
(
  --- Show whether linked or not (instanced)
  local LOCinstances = Instancemgr.getInstances FUNobject &LOCinstanceNodes

  --- Never include DaylightAssemblyHeads in Instance Collection
  for i = 1 to LOCinstanceNodes.count do
  (
    if classof LOCinstanceNodes[i] == DaylightAssemblyHead then deleteItem LOCinstanceNodes i
  )
  LOCinstances = LOCinstanceNodes.count

  --- Update Rollout
  if LOCinstances > 1 then
  (
    FUNrollout.CBDYNlinked.checked = true
    FUNrollout.CBDYNlinked.enabled = true
    FUNrollout.CBDYNlinked.text    = DYNuiResourcesButtons[25] + " (" + ((LOCinstances) as string) + " " + DYNuiResourcesButtons[27] + ")"
  )
  else
  (
    FUNrollout.CBDYNlinked.checked = false
    FUNrollout.CBDYNlinked.enabled = false
    FUNrollout.CBDYNlinked.text    = DYNuiResourcesButtons[37]
  )
  LOCinstances -- return value
)

--- Function to get a list of instances of a particular modifier (used with Civil_View_Swept_Object, Civil_View_Guard_Rail, and Civil_View_Road_Marking
fn DYNFUNgatherNodesWithModInstances FUNrollout FUNobjMod =
(
  local LOCinstances = for i in (refs.dependents FUNobjMod) where isvalidnode i collect i

  if LOCinstances.count > 0 then
  (
    for i = LOCinstances.count to 1 by -1 do
    (
      if (CVGetMod LOCinstances[i] (classOf FUNobjMod)) == undefined then deleteItem LOCinstances i
    )
  )

  if LOCinstances.count > 1 then
  (
    FUNrollout.CBDYNlinked.checked   = true
    FUNrollout.CBDYNlinked.enabled   = true
    FUNrollout.CBDYNlinked.text      = DYNuiResourcesButtons[25] + " (" + ((LOCinstances.count) as string) + " " + DYNuiResourcesButtons[27] + ")"
  )
  else
  (
    FUNrollout.CBDYNlinked.checked   = false
    FUNrollout.CBDYNlinked.enabled   = false
    FUNrollout.CBDYNlinked.text      = DYNuiResourcesButtons[37]
  )
  LOCinstances -- return value
)

fn DYNFUNnodesWithInstancesOfModifier FUNobjMod =
(
  local LOCinstances = for i in (refs.dependents FUNobjMod) where isvalidnode i collect i

  if LOCinstances.count > 0 then
  (
    for i = LOCinstances.count to 1 by -1 do
    (
      if (CVGetMod LOCinstances[i] (classOf FUNobjMod)) == undefined then deleteItem LOCinstances i
    )
  )

  LOCinstances -- return value
)

--- Function To Update UVWMap modifier on Building Objects
fn DYNFUNupdateBuildingUVW FUNobjMod FUNobj FUNbuildHeight FUNnumFloors FUNwidthMapping FUNmappingStyle =
(
  if FUNobjMod != undefined then
  (
    FUNobjMod.vFlip = if FUNbuildHeight < 0.0 then true else false

    --- 1=Box-per-floor  ; 2=face-mapping, 3=wrap-mapping
    if FUNmappingStyle == 1 then -- box mapping per floor
    (
      FUNobjMod.enabled     = true
      FUNobjMod.mapType     = 4
      FUNobjMod.height      = FUNbuildHeight
      FUNobjMod.uTile       = 1.0
      FUNobjMod.vTile       = FUNnumFloors
      FUNobjMod.length      = FUNwidthMapping
      FUNobjMod.width       = FUNwidthMapping
    )
    if FUNmappingStyle == 2 then -- box mapping per building
    (
      FUNobjMod.enabled     = true
      FUNobjMod.mapType     = 4
      FUNobjMod.height      = FUNbuildHeight
      FUNobjMod.uTile       = 1.0
      FUNobjMod.vTile       = 1.0
      FUNobjMod.length      = FUNwidthMapping
      FUNobjMod.width       = FUNwidthMapping
    )

    if FUNmappingStyle == 3 then -- face mapping
    (
      FUNobjMod.enabled     = true
      FUNobjMod.mapType     = 5
      FUNobjMod.uTile       = 1.0
      FUNobjMod.vTile       = 1.0
    )
    if FUNmappingStyle == 4 then -- wrap mapping
    (
      FUNobjMod.enabled     = false
    )

    --- Update UVWmap Gizmo
    if FUNobj != undefined then -- can only be undefined if called from DYNFUNcreateBuild.
    (
      classOf FUNobj -- required, because otherwise a gizmo cannot be edited (gizmo is not available in maxscript until applied to an object which can only normally happen after viewport is updated)
      FUNobjMod.gizmo.pos.z = FUNbuildHeight / 2
    )
  )
  FUNobjMod -- return value
)

fn DYNFUNmodifyDivider FUNobjMod FUNdivisions FUNnormalize =
(
  if classOf FUNobjMod == Civil_View_Divide_Spline then     -- checks if modifier actually exists
  (
    FUNobjMod.type        = 0            -- (Divison_Type) : integer (This is the simplest interpolation process that will result in a fixed number of points on the path.)
    FUNobjMod.kType       = 0            -- (Knot_Type) : integer [0 = Automatic (The system will use the automatic knot type.); 1 = Corner (A typical corner type knot); 2 = Bezier (A curved bezier type knot); 3 = Bezier Corner (A curved bezier corner type knot)]
    FUNobjMod.divisions   = FUNdivisions -- : float
    FUNobjMod.threshold   = 2.0          -- ((null)) : float (not used when type = 0)
    FUNobjMod.maxDist     = 10.0         -- ((null)) : float (not used when type = 0)
    FUNobjMod.splineIndex = 0            -- (Knot_Type) : integer (0 = use all splines)
    FUNobjMod.normalize   = FUNnormalize -- MUST be set to TRUE, otherwise differing tension in adjacent splines will result in skewed geometry. TRUE ensures that segments are all of equal length
  )
  FUNobjMod -- return value
)

fn DYNFUNapplyModifierInstance FUNmodType FUNobj FUNoldObj FUNcallBackCtrlSwitch =
(
  local LOCsuccessSwitch = false
  if FUNobj != FUNoldObj and (CVGetMod FUNobj FUNmodType) != undefined and (CVGetMod FUNoldObj FUNmodType) != undefined then  -- only proceed if a different object was selected
  (
    --- Temporarily Halt Callbacks according to modifier type specified
    if FUNcallBackCtrlSwitch then
    (
      if FUNmodType == DynBuilding then (callbacks.removescripts id:#DYNbuildingParams)
      if FUNmodType == Civil_View_Guard_Rail then (callbacks.removescripts id:#DYNgRailParams)
      if FUNmodType == Civil_View_Spline_to_Mesh then (callbacks.removescripts id:#DYNmarkingParams)
      if FUNmodType == Civil_View_Road_Marking then (callbacks.removescripts id:#DYNmarkingParams)
      if FUNmodType == Civil_View_Swept_Object then (callbacks.removescripts id:#DYNsosParams)
    )

    --- If Secondary Building Modifiers Are Used On Old Object, ensure that these modifiers exist
    if FUNmodType == DynBuilding then
    (
      if (CVGetMod FUNoldObj Uvwmap) == undefined then addModifier FUNoldObj (uvwmap realWorldMapSize:false)
      DYNFUNupdateBuildingUVW (CVGetMod FUNoldObj Uvwmap) FUNoldObj (CVGetMod FUNoldObj FUNmodType).Xamount (CVGetMod FUNoldObj FUNmodType).Xfloors (CVGetMod FUNoldObj FUNmodType).XmapWidth (CVGetMod FUNoldObj FUNmodType).XmapType
    )

    --- If Secondary SOS Modifiers Are Used On Old Object, ensure that these modifiers exist (only if SplineIndex = 0)
    if FUNmodType == Civil_View_Swept_Object then
    (
      if (CVGetMod FUNoldObj FUNmodType).splineIndex == 0 then
      (
        if (CVGetMod FUNoldObj Civil_View_Divide_Spline) == undefined then addModifier FUNoldObj (Civil_View_Divide_Spline ui:On)
        DYNFUNmodifyDivider (CVGetMod FUNoldObj Civil_View_Divide_Spline) (CVGetMod FUNoldObj FUNmodType).spacing (CVGetMod FUNoldObj FUNmodType).normalize
      )
    )

    --- Add Temporary Modifier to prevent object resorting back to an instance of imported parent shape!
    addModifier FUNobj (xform())

    --- Delete Modifiers From New Object
    deleteModifier FUNobj (CVGetMod FUNoldObj FUNmodType)
    if FUNmodType == DynBuilding   then (if (CVGetMod FUNoldObj Uvwmap) != undefined then deleteModifier FUNobj (CVGetMod FUNoldObj Uvwmap))
    if FUNmodType == Civil_View_Swept_Object       then (if (CVGetMod FUNobj Civil_View_Divide_Spline) != undefined then deleteModifier FUNobj (CVGetMod FUNobj Civil_View_Divide_Spline))

    --- Apply Instance Of Modifier From Old Object To New Object
    addModifier FUNobj (CVGetMod FUNoldObj FUNmodType)
    if FUNmodType == DynBuilding   then (addModifier FUNobj (CVGetMod FUNoldObj Uvwmap))
    if FUNmodType == Civil_View_Swept_Object then (if (CVGetMod FUNoldObj FUNmodType).splineIndex == 0 then (addModifier FUNobj (CVGetMod FUNoldObj Civil_View_Divide_Spline)))-- Civil_View_Divide_Spline Modifier Only Required If SplineIndex = 0

    --- Remove Temorary Modifier
    deleteModifier FUNobj (CVGetMod FUNoldObj XForm) -- Remove temporary modifier

    --- restart Callbacks according to modifier type specified
    if FUNcallBackCtrlSwitch then
    (
      if FUNmodType == DynBuilding then (callbacks.addscript #postModifierDeleted "DYNbuildingParams.DYNFUNbuildingParamsCallback()" id:#DYNbuildingParams)
      if FUNmodType == Civil_View_Guard_Rail       then (callbacks.addscript #postModifierDeleted "DYNgRailParams.DYNFUNgRailParamsCallback()"       id:#DYNgRailParams)
      if FUNmodType == Civil_View_Spline_to_Mesh   then (callbacks.addscript #postModifierDeleted "DYNmarkingParams.DYNFUNmarkingParamsCallback()"   id:#DYNmarkingParams)
      if FUNmodType == Civil_View_Road_Marking     then (callbacks.addscript #postModifierDeleted "DYNmarkingParams.DYNFUNmarkingParamsCallback()"   id:#DYNmarkingParams)
      if FUNmodType == Civil_View_Swept_Object     then (callbacks.addscript #postModifierDeleted "DYNsosParams.DYNFUNsosParamsCallback()"           id:#DYNsosParams)
    )

    --- Apply AppData Changes to all instances of this modifier
    for i = 421 to 428 do
    (
      if i != 425 and (getAppData FUNoldObj i) != undefined then  -- Update all AppData except "Date Created"
      (
        setAppData FUNobj i (getAppData FUNoldObj i)
      )
    )
    if FUNmodType == Civil_View_Spline_to_Mesh     then (if (getAppData FUNoldObj 429) != undefined then (setAppData FUNobj 429 (getAppData FUNoldObj 429))) -- Update additional marking only AppData
    if FUNmodType == Civil_View_Road_Marking       then (if (getAppData FUNoldObj 429) != undefined then (setAppData FUNobj 429 (getAppData FUNoldObj 429))) -- Update additional marking only AppData
    if FUNmodType == Civil_View_Road_Marking       then (if (getAppData FUNoldObj 430) != undefined then (setAppData FUNobj 430 (getAppData FUNoldObj 430))) -- Update additional marking only AppData
    LOCsuccessSwitch = true
  )
  LOCsuccessSwitch -- return value
)

--- Set Spline MatIDs to Match Current MatID Selected in DynBuilding Modifier
fn DYNFUNsetBuildingSplineMatID FUNobj FUNarg =
(
  for i = 1 to numSplines FUNobj do
  (
    for ii = 1 to (numSegments FUNobj i) do
    (
      setMaterialID FUNobj i ii FUNarg
    )
  )
  updateShape FUNobj
)

--- Function To Modify Parameters Associated With A Building Object
fn DYNFUNmodifyBuild FUNobjMod1 FUNobjMod2 FUNheight FUNfloors FUNmatID FUNmapWidth FUNmapType =
(
  if classOf FUNobjMod1 == DynBuilding and classOf FUNobjMod2 == UvwMap then
  (
    --- Main General Parameter Defaults
    FUNobjMod1.Xamount      = FUNheight   -- height of building
    FUNobjMod1.Xfloors      = FUNfloors   -- number of Floors
    FUNobjMod1.XwallMatIDs  = FUNmatID    -- Material ID for walls
    FUNobjMod1.XmapWidth    = FUNmapWidth -- horizontal length of map
    FUNobjMod1.XmapType     = FUNmapType  -- 1=Boxmapping-per-floor  ; 2=Boxmapping-per-building  ;3=face-mapping, 4=wrap-mapping

    --- Default Parameters Which Are Not Exposed To Users
    FUNobjMod1.XcapEnd      = true -- top of building
    FUNobjMod1.XcapStart    = false-- bottom of building
    FUNobjMod1.XcapType     = 0    -- morph
    FUNobjMod1.Xoutput      = 1    -- mesh
    FUNobjMod1.XmatIDs      = true -- Forces top cap to use MatID of 1
    FUNobjMod1.XuseShapeIDs = true -- use Mat IDs from shape segments
    FUNobjMod1.Xsmooth      = false-- Smoothing to geometry
    FUNobjMod1.XmapCoords   = true -- generate map coords
    FUNobjMod1.Xsegs        = 1    -- segments

    --- Update UVWMap Mapping Modifier Params
    DYNFUNupdateBuildingUVW FUNobjMod2 undefined FUNheight FUNfloors FUNmapWidth FUNmapType -- will not work here because no reference possible to base object. Must therefore be placed in DYNFUNcreateBuild after callign this function!!
  )
  #(FUNobjMod1, FUNobjMod2) -- return value
)

fn DYNFUNmakeReferenceWithoutMatPropogation FUNsrcObj FUNmaterial =
(
  /*
    This function is used when generating parent shapes for guard rails, road markings, swept objects, and buildings

    It prevents the same material being shared between (for example) a swept object and road marking applied to the same parent shape.

    That problem is caused by the following setting in the Market-Specific Defaults option in 3ds Max (from the 3ds Max docs):

    AutoMtlPropagation (integer):
      Determines whether the instance manager propagates material assignments to instances.
      This default is used only the first time 3ds Max is run. Thereafter you can adjust the value in the preference dialog.
      This value is stored in 3dsmax.ini: [InstanceMgr] AutoMtlPropagation=n
  */

  --- Store Current Status of autoMtlPropagation
  local LOCorigStatus = InstanceMgr.autoMtlPropagation

  --- Always make "Parent Shape" as "a Reference" to "Source Shape" with autoMtlPropagation turned OFF
  InstanceMgr.autoMtlPropagation = false
  local LOCnewObj   = reference FUNsrcObj
  LOCnewObj.parent   = FUNsrcObj
  LOCnewObj.material = FUNmaterial

  --- Return Original Status of autoMtlPropagation
  InstanceMgr.autoMtlPropagation = LOCorigStatus

  LOCnewObj -- return value
)



--- Function to create a BUILDING Object
fn DYNFUNcreateBuild FUNshapeArray FUNbosStyle FUNlocalTime FUNsceneMats FUNheight FUNfloors FUNmatID FUNmapWidth FUNmapType FUNdelOldSwitch FUNexistingModifier1 FUNexistingModifier2 FUNinstanceSwitch =
(
  clearUndoBuffer()
  local LOCnewObjArray = #()
  undo off
  (
    local LOCproceedSwitch = true
    for i in FUNshapeArray do
    (
      --- Check whether any building objects are already applied to these parent shapes and
      --- delete them if they are. Only one building object allowed per shape. Only do this if Switch is set to true
      if FUNdelOldSwitch and i.children.count > 0 then
      (
        for ii = i.children.count to 1 by -1 do (local LOCchild = getAppData i.children[ii] 422; if LOCchild == "13" then delete i.children[ii])
      )

      --- Ensure that parent shape is an editable spline
      DYNFUNcheckIsSplineShape i

      --- Check that specified parent is a shape and that no guardrail modifier already exists, then check that style is valid
      if (ClassOf i.baseObject) != splineshape or (CVGetMod i DynBuilding) != undefined then LOCproceedSwitch = false
    )

    --- Check Style Reference Is Valid
    if (classOf FUNbosStyle) != string then LOCproceedSwitch = false

    --- Check If OK To Proceed, create references of parent shape objects
    if LOCproceedSwitch then
    (
      local LOCmaterial = if FUNsceneMats[DYNmatNameBuildings] != undefined then FUNsceneMats[DYNmatNameBuildings] else (DYNFUNmakeCivilViewBuildings (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameBuildingMaps + "\\"))
      for i in FUNshapeArray do
      (
        --- Create a referenced clone of the parent shape for each spline in the object (Remember that the "New Parent Shape" routine in DYNbuildingParams doesn't use this section, so if it changes update that too....)
        local LOCnamePart        = getAppData i 427 ; if LOCnamePart == undefined then LOCnamePart = i.name
        local LOCbuilding        = DYNFUNmakeReferenceWithoutMatPropogation i LOCmaterial
        LOCbuilding.name         = uniqueName (DYNuiResourcesNodeNames[27] + LOCnamePart + "-0")
        LOCbuilding.backFaceCull = false
        LOCbuilding.wireColor    = color 200 0 80
        if isValidNode LOCbuilding then (append DYNobjHandles[13] LOCbuilding.inode.handle)
        /* New BUILDING will have been automatically added to DYNobjHandles[17] when shape was first created, but it is now also in DYNobjHandles[13]. Delete it from DYNobjHandles[17] */
        local LOCfind = findItem DYNobjHandles[17] LOCbuilding.inode.handle; if LOCfind > 0 then deleteItem DYNobjHandles[17] LOCfind
        /* append to array to receive Civil_View_Road_Marking modifier */
        append LOCnewObjArray LOCbuilding
      )

      --- Create New or reference existing Modifier
      local LOCobjMod1 = if classOf FUNexistingModifier1 == DynBuilding then FUNexistingModifier1 else (DynBuilding ui:On)
      local LOCobjMod2 = if classOf FUNexistingModifier2 == UvwMap      then FUNexistingModifier2 else (UVWmap realWorldMapSize:false) -- Secondary Modifier
      if FUNexistingModifier1 == undefined or FUNexistingModifier2 == undefined then
      (
        DYNFUNmodifyBuild LOCobjMod1 LOCobjMod2 FUNheight FUNfloors FUNmatID FUNmapWidth FUNmapType
      )

      --- Apply Modifier to Array of New Objects (Instance or Copy) - then update AppData
      if FUNinstanceSwitch and LOCnewObjArray.count > 0 then
      (
        addModifier LOCnewObjArray LOCobjMod1
        addModifier LOCnewObjArray LOCobjMod2
      )
      else
      (
        for i in LOCnewObjArray do
        (
          addmodifier i (copy LOCobjMod1)
          addmodifier i (copy LOCobjMod2)
        )
      )

      --- Update MaterialID for baseShape segments
      for i in LOCnewObjArray do
      (
        DYNFUNsetBuildingSplineMatID i FUNmatID

        --- Followign lines should ideally be called within DYNFUNmodifyBuild but can't because function contains no reference to BaseObject (duplicate of what is in DYNFUNupdateBuildingUVW
        classOf i -- required, because otherwise a gizmo cannot be edited (gizmo is not available in maxscript until applied to an object which can only normally happen after viewport is updated)
        (CVGetMod i Uvwmap).gizmo.pos.z = FUNheight / 2
      )

      --- Apply AppData to all new Building Objects
      for i in LOCnewObjArray do
      (
        DYNFUNgenObjAppData i "13" "0" FUNbosStyle FUNlocalTime "" "" "" -- Update AppData
      )
    )
  )
  LOCnewObjArray -- return value
)

--- Function to update a Rail Object based on a Saved Rail Object Style
fn DYNFUNmodifyRail FUNobjMod FUNparamArray =
(
  if classOf FUNobjMod == Civil_View_Guard_Rail then
  (
    if FUNparamArray.count == 40 then
    (
      --- Main General Parameters ------------------------------------------------
      FUNobjMod.height        = FUNparamArray[1]
      FUNobjMod.widthLeft     = FUNparamArray[2]
      FUNobjMod.widthRight    = FUNparamArray[3]
      FUNobjMod.offSetz       = FUNparamArray[6]
      FUNobjMod.offSetx       = FUNparamArray[7]

      --- Post Parameters  -------------------------------------------------------
      FUNobjMod.poston        = FUNparamArray[11]
      FUNobjMod.postflip      = FUNparamArray[12]
      FUNobjMod.posttype      = FUNparamArray[13]
      FUNobjMod.postCapTop    = FUNparamArray[14]
      FUNobjMod.spacing       = FUNparamArray[15]
      FUNobjMod.postWidth     = FUNparamArray[16]
      FUNobjMod.postDepth     = FUNparamArray[17]
      FUNobjMod.groundDepth   = FUNparamArray[18]
      FUNobjMod.postCapBottom = FUNparamArray[19]
      FUNobjMod.postMatID     = FUNparamArray[20]

      --- Brace Parameters ------------------------------------------------------
      FUNobjMod.braceon       = FUNparamArray[21]
      FUNobjMod.braceType     = FUNparamArray[23]
      FUNobjMod.braceGap      = FUNparamArray[25]
      FUNobjMod.braceHeight   = FUNparamArray[26]
      FUNobjMod.braceDepth    = FUNparamArray[27]
      FUNobjMod.braceMatID    = FUNparamArray[30]

      --- Rail Parameters -------------------------------------------------------
      FUNobjMod.raillefton    = FUNparamArray[31]
      FUNobjMod.railrighton   = FUNparamArray[32]
      FUNobjMod.railType      = FUNparamArray[33]
      FUNobjMod.railVertical  = FUNparamArray[35]
      FUNobjMod.railHeight    = FUNobjMod.railVertical + (FUNparamArray[36] * 2)
      FUNobjMod.railWidth     = FUNparamArray[37]
      FUNobjMod.UVRepeat      = FUNparamArray[39]
      FUNobjMod.railMatID     = FUNparamArray[40]
    )
    else
    (
      --- Main General Parameters ------------------------------------------------
      FUNobjMod.height        = 0.6          -- : float
      FUNobjMod.widthLeft     = 0.4          -- : float
      FUNobjMod.widthRight    = 0.4          -- : float
      FUNobjMod.offsetz       = 0.0          -- (Vertical Offset from shape)  : float
      FUNobjMod.offsetx       = 0.0          -- (Horiontal Offset from shape) : float

      --- Post Parameters  -------------------------------------------------------
      FUNobjMod.poston        = true         --  (Post_On) : boolean
      FUNobjMod.postflip      = false        --  (Post_Flip) : boolean
      FUNobjMod.postCapTop    = false        --  (Post_Cap_Top) : boolean
      FUNobjMod.postCapBottom = false        --  (Post_Cap_Bottom) : boolean
      FUNobjMod.posttype      = 0            --  (Post_Type) : integer
      FUNobjMod.spacing       = 3.0          -- : float
      FUNobjMod.postwidth     = 0.1          --  (Post_Width) : float
      FUNobjMod.postdepth     = 0.1          --  (Post_Depth) : float
      FUNobjMod.grounddepth   = 0.25         --  (Ground_Depth) : float
      FUNobjMod.postmatid     = 1            --  (Post_Type) : integer

      --- Brace Parameters ------------------------------------------------------
      FUNobjMod.braceon       = true         --  (Brace_On) : boolean
      FUNobjMod.bracetype     = 0            --  (Brace_Type) : integer
      FUNobjMod.bracegap      = 0.01         --  (Brace Gap to Rail) : float
      FUNobjMod.braceheight   = 0.2          --  (Brace_Height) : float
      FUNobjMod.bracedepth    = 0.1          --  (Brace_Depth) : float
      FUNobjMod.bracematid    = 1            --  (Brace_Material_ID) : integer

      --- Rail Parameters -------------------------------------------------------
      FUNobjMod.raillefton    = true         --  (Rail_Left_On) : boolean
      FUNobjMod.railrighton   = true         --  (Rail_Right_On) : boolean
      FUNobjMod.railtype      = 4            --  (Rail_Type) : integer
      FUNobjMod.railvertical  = 0.25         --  (Rail_Vertical_Height) : float
      FUNobjMod.railheight    = 0.35         --  (Rail_Height) : float
      FUNobjMod.railwidth     = 0.1          --  (Rail_Width) : float
      FUNobjMod.railmatid     = 2            --  (Rail_Material_ID) : integer
      FUNobjMod.uvrepeat      = 1.0          --  (UV_Repeat) : float
    )
  )
  FUNobjMod -- return value
)


--- Function to create a Rail Object
fn DYNFUNcreateRails FUNshapeArray FUNrosStyle FUNlocalTime FUNdelOldSwitch FUNsceneMats FUNstyleContentArray FUNexistingModifier FUNinstanceSwitch =
(
  local LOCnewObjArray = #()
  clearUndoBuffer()
  undo off
  (
    local LOCproceedSwitch = true
    for i in FUNshapeArray do
    (
      --- Check whether any road marking objects are already applied to these parent shapes and
      --- delete them if they are. Only one road marking object allowed per shape. Only do this if Switch is set to true
      if FUNdelOldSwitch and i.children.count > 0 then
      (
        for ii = i.children.count to 1 by -1 do (local LOCchild = getAppData i.children[ii] 422; if LOCchild == "12" then delete i.children[ii])
      )

      --- Ensure that parent shape is an editable spline
      DYNFUNcheckIsSplineShape i

      --- Check that specified parents are shapes and that no Civil_View_Road_Marking modifier already exists
      if ((ClassOf i.baseObject) != splineshape and (ClassOf i) != PolymorphicGeomshape) or (CVGetMod i Civil_View_Guard_Rail) != undefined then LOCproceedSwitch = false
    )

    --- Check Style Reference Is Valid
    if (classOf FUNrosStyle) != string then LOCproceedSwitch = false

    --- Check If OK To Proceed, create references of parent shape objects
    if LOCproceedSwitch then
    (
      local LOCmaterial = if FUNsceneMats[DYNmatNameRails] != undefined then FUNsceneMats[DYNmatNameRails] else (DYNFUNmakeCivilViewRails (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\"))
      for i in FUNshapeArray do
      (
        --- Create a referenced clone of the parent shape for each spline in the object (Remember that the "New Parent Shape" routine in DYNgRailParams doesn't use this section, so if it changes update that too....)
        local LOCnamePart     = getAppData i 427 ; if LOCnamePart == undefined then LOCnamePart = i.name
        local LOCgRail        = DYNFUNmakeReferenceWithoutMatPropogation i LOCmaterial
        LOCgRail.name         = uniqueName (DYNuiResourcesNodeNames[28] + LOCnamePart + "-0")
        LOCgRail.backFaceCull = false
        LOCgRail.wireColor    = color 155 175 225
        if isValidNode LOCgRail then (append DYNobjHandles[12] LOCgRail.inode.handle)

        ---  New GRail will have been automatically added to DYNobjHandles[17] when shape was first created, but it is now also in DYNobjHandles[12]. Delete it from DYNobjHandles[17]
        local LOCfind = findItem DYNobjHandles[17] LOCgRail.inode.handle; if LOCfind > 0 then deleteItem DYNobjHandles[17] LOCfind
        -- append to array to receive Civil_View_Guard_Rail modifier
        append LOCnewObjArray LOCgRail
      )

      --- Create New or reference existing Modifier
      local LOCobjMod = if classOf FUNexistingModifier == Civil_View_Guard_Rail then FUNexistingModifier else (Civil_View_Guard_Rail ui:On splineIndex:0)
      if FUNexistingModifier == undefined then
      (
        DYNFUNmodifyRail LOCobjMod FUNstyleContentArray -- Set parameters to gRail modifier based on ROS style if one was specified
      )

      --- Apply Modifier to Array of New Objects (Instance or Copy) - then update AppData
      if FUNinstanceSwitch and LOCnewObjArray.count > 0 then (addModifier LOCnewObjArray LOCobjMod) else (for i in LOCnewObjArray do (addmodifier i (copy LOCobjMod)))

      --- Apply AppData to all new Rail Objects
      for i in LOCnewObjArray do (DYNFUNgenObjAppData i "12" "0" FUNrosStyle FUNlocalTime "" "" "")
    )
  )
  LOCnewObjArray -- return value
)

--- Function to update a Road Marking Object based on a Saved Road Marking Style
fn DYNFUNmodifyChevrons FUNobjMod FUNmaterial FUNdims FUNcolor FUNshift FUNhorizParams FUNoptimiseParams FUNangle =
(
  if classOf FUNobjMod == Civil_View_Spline_to_Mesh then
  (
    local LOCmatID    = 1
    local LOCscale    = (FUNdims.x + FUNdims.y) as float

    --- Decide which material channel to use
    if FUNmaterial.name == DYNmatNameMarkings and (classof FUNmaterial == Multimaterial) then
    (
      /* In the follwing section, colours are converted to strings for comparison because a comparisons between two colour values in an "IF" statement doesn't seem to work in Maxscript.... */
      if FUNdims.y != 0.0 or (FUNcolor as string) != (DYNINImarkingColor as string) then -- If gap is 0.0 and default color is used, mat channel 1 is always used (set above)
      (
        local LOCposArray = #()
        local LOCposition = FUNdims.x / LOCscale -- between 0.0 and 1.0 - extent of white repeat
        for i = 1 to FUNmaterial.count do
        (
          if classOf FUNmaterial[i] == StandardMaterial then
          (
            local LOCtempPos = try (FUNmaterial[i].opacityMap.clipw) catch (1.0)
            local LOCtempCol = try (FUNmaterial[i].diffuse) catch (color 0 0 0)
            if (LOCtempPos == LOCposition) and ((LOCtempCol as string) == (FUNcolor as string)) then (append LOCposArray i)
          )
          if classOf FUNmaterial[i] == Arch___Design__mi then
          (
            local LOCtempPos = try (FUNmaterial[i].cutOut_map.clipw) catch (1.0)
            local LOCtempCol = try (FUNmaterial[i].diff_color) catch (color 0 0 0)
            if (LOCtempPos == LOCposition) and ((LOCtempCol as string) == (FUNcolor as string)) then (append LOCposArray i)
          )
          if classOf FUNmaterial[i] != Arch___Design__mi and classOf FUNmaterial[i] != StandardMaterial then
          (
            local LOCtempPos = 1.0
            local LOCtempCol = color 0 0 0
            if (LOCtempPos == LOCposition) and ((LOCtempCol as string) == (FUNcolor as string)) then (append LOCposArray i)
          )
        )
        LOCmatID = if LOCposArray.count == 0 then (try ((DYNFUNmakeCivilViewMarkings FUNmaterial LOCposition FUNcolor (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameMarkingMaps + "\\") 0.0).count) catch (1)) else LOCposArray[1]
      )
    )

    --- Modify Smesh Parameters
    DYNFUNmodifySmesh FUNobjMod LOCmatID [0,0] [LOCscale, LOCscale] FUNangle

    --- Override Some Smesh Parameters Specifically For Chevrons
    FUNobjMod.offsetx      = FUNhorizParams.x
    FUNobjMod.offsety      = FUNhorizParams.y
    FUNobjMod.offsetz      = FUNshift
    FUNobjMod.individual   = true        -- (Individual_Directions) : boolean
    FUNobjMod.reverse      = false       -- (Reverse_Splines) : boolean
    FUNobjMod.north        = false       -- (North_Direction_Alignment) : boolean
  )
  FUNobjMod -- Return New Road Marking
)

fn DYNFUNcreateChevrons FUNshapeArray FUNrmsStyle FUNshift FUNshow FUNlocalTime FUNcolor FUNdims FUNoverrideShift FUNdelOldSwitch FUNsceneMats FUNexistingModifier FUNinstanceSwitch FUNangle =
(
  local LOCnewObjArray = #()
  clearUndoBuffer()

  undo off
  (
    local LOCproceedSwitch = true
    for i in FUNshapeArray do
    (
      --- Check whether any road marking objects are already applied to these parent shapes and
      --- delete them if they are. Only one road marking object allowed per shape. Only do this if Switch is set to true
      if FUNdelOldSwitch and i.children.count > 0 then
      (
        for ii = i.children.count to 1 by -1 do (local LOCchild = getAppData i.children[ii] 422; if LOCchild == "10" then delete i.children[ii])
      )

      --- Ensure that parent shape is an editable spline
      DYNFUNcheckIsSplineShape i

      --- Check that specified parents are shapes and that no Civil_View_Road_Marking modifier already exists
      if ((ClassOf i.baseObject) != splineshape and (ClassOf i) != PolymorphicGeomshape) or (CVGetMod i Civil_View_Road_Marking) != undefined then LOCproceedSwitch = false
    )

    --- Check Style Reference Is Valid
    if (classOf FUNrmsStyle) != string then LOCproceedSwitch = false

    --- Check If OK To Proceed, create references of parent shape objects
    if LOCproceedSwitch then
    (
      local LOCmaterial = if FUNsceneMats[DYNmatNameMarkings] != undefined then FUNsceneMats[DYNmatNameMarkings] else (DYNFUNmakeCivilViewMarkings undefined 0 DYNINImarkingColor (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameMarkingMaps + "\\") 0.0)
      for i in FUNshapeArray do
      (
        --- Create a referenced clone of the parent shape for each spline in the object (Remember that the "New Parent Shape" routine in DYNgRailParams doesn't use this section, so if it changes update that too....)
        local LOCnamePart          = getAppData i 427 ; if LOCnamePart == undefined then LOCnamePart = i.name
        local LOCrMark             = DYNFUNmakeReferenceWithoutMatPropogation i LOCmaterial
        LOCrMark.name              = uniqueName (DYNuiResourcesNodeNames[29] + LOCnamePart + "-0")
        LOCrMark.castShadows       = false
        try (LOCnewMark.isGIoccluder = false) catch ()
        LOCrMark.isFrozen          = FUNshow
        LOCrMark.showFrozeninGray  = false -- must be false for opacity map to be displayed in shaded viewports.
        LOCrMark.wireColor         = color 100 100 225
        if isValidNode LOCrMark then (append DYNobjHandles[10] LOCrMark.inode.handle)
        /* New Mark will have been automatically added to DYNobjHandles[17] when shape was first created, but it is now also in DYNobjHandles[10]. Delete it from DYNobjHandles[17] */
        local LOCfind = findItem DYNobjHandles[17] LOCrMark.inode.handle; if LOCfind > 0 then deleteItem DYNobjHandles[17] LOCfind
        /* append to array to receive Civil_View_Road_Marking modifier */
        append LOCnewObjArray LOCrMark

        /* z offset for Prototype Chevron Modifiers */
        DYNFUNapplyShift LOCrMark 0.0 rootNode.DYNrootNodeStore.markVshift
      )

      --- Create New or reference existing Modifier
      local LOCobjMod = if classOf FUNexistingModifier == Civil_View_Spline_to_Mesh then FUNexistingModifier else (Civil_View_Spline_to_Mesh())
      if FUNexistingModifier == undefined then
      (
        DYNFUNmodifyChevrons LOCobjMod LOCmaterial FUNdims FUNcolor FUNshift [0.0,0.0] [DYNINImarkingSpacing, DYNINImarkingThreshold, DYNINImarkingMaxDistance] FUNangle
      )

      --- Apply Modifier to Array of New Objects (Instance or Copy) - then update AppData
      if FUNinstanceSwitch and LOCnewObjArray.count > 0 then (addModifier LOCnewObjArray LOCobjMod) else (for i in LOCnewObjArray do (addmodifier i (copy LOCobjMod)))

      --- Apply AppData to all new Marking Objects
      for i in LOCnewObjArray do
      (
        DYNFUNgenObjAppData i "10" (CVGetMod i Civil_View_Spline_to_Mesh).matID FUNrmsStyle FUNlocalTime (FUNdims.x as string) (FUNdims.y as string) ((if FUNoverrideShift then (-FUNdims.z) else (FUNdims.z)) as string)
      )
    )
  )
  LOCnewObjArray -- return value
)

--- Function to update a Road Marking Object based on a Saved Road Marking Style
fn DYNFUNmodifyMarks FUNobjMod FUNmaterial FUNdims FUNcolor FUNshift FUNhorizParams FUNoptimiseParams FUNcentrelineGap =
(
  if classOf FUNobjMod == Civil_View_Road_Marking then
  (
    local LOCmatID    = 1
    local LOCscale    = (FUNdims.x + FUNdims.y) as float

    --- Decide which material channel to use
    if FUNmaterial.name == DYNmatNameMarkings and (classof FUNmaterial == Multimaterial) then
    (
      /* In the follwing section, colours are converted to strings for comparison because a comparisons between two colour values in an "IF" statement doesn't seem to work in Maxscript.... */
      if FUNcentrelineGap != 0.0 or FUNdims.y != 0.0 or (FUNcolor as string) != (DYNINImarkingColor as string) then -- If both gaps are 0.0 and default color is used, mat channel 1 is always used (set above)
      (
        local LOCposArray = #()
        local LOCposition = FUNdims.x / LOCscale -- between 0.0 and 1.0 - extent of white repeat
        for i = 1 to FUNmaterial.count do
        (
          if classOf FUNmaterial[i] == StandardMaterial then
          (
            local LOCtempPos = try (FUNmaterial[i].opacityMap.clipw) catch (1.0)
            local LOCtempCLG = try (FUNmaterial[i].opacityMap.clipv) catch (1.0) -- centreline gap
            local LOCtempCol = try (FUNmaterial[i].diffuse) catch (color 0 0 0)
            if (LOCtempPos == LOCposition) and ((LOCtempCol as string) == (FUNcolor as string)) and (LOCtempCLG == (FUNcentrelineGap / FUNdims.z)) then (append LOCposArray i)
          )
          if classOf FUNmaterial[i] == Arch___Design__mi then
          (
            local LOCtempPos = try (FUNmaterial[i].cutOut_map.clipw) catch (1.0)
            local LOCtempCLG = try (FUNmaterial[i].cutOut_map.clipv) catch (1.0) -- centreline gap
            local LOCtempCol = try (FUNmaterial[i].diff_color) catch (color 0 0 0)
            if (LOCtempPos == LOCposition) and ((LOCtempCol as string) == (FUNcolor as string)) and (LOCtempCLG == (FUNcentrelineGap / FUNdims.z)) then (append LOCposArray i)
          )
          if classOf FUNmaterial[i] != Arch___Design__mi and classOf FUNmaterial[i] != StandardMaterial then
          (
            local LOCtempPos = 1.0
            local LOCtempCLG = 1.0 -- centreline gap
            local LOCtempCol = color 0 0 0
            if (LOCtempPos == LOCposition) and ((LOCtempCol as string) == (FUNcolor as string)) and (LOCtempCLG == (FUNcentrelineGap / FUNdims.z)) then (append LOCposArray i)
          )
        )
        LOCmatID = if LOCposArray.count == 0 then (try ((DYNFUNmakeCivilViewMarkings FUNmaterial LOCposition FUNcolor (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameMarkingMaps + "\\") (FUNcentrelineGap / FUNdims.z)).count) catch (1)) else LOCposArray[1]
      )
    )

    --- Set Marking Parameters - Dimension and Position Related
    FUNobjMod.offsetX   = FUNhorizParams.x    -- (Horizontal Offset From Spline) : float
    FUNobjMod.offsetZ   = FUNshift            -- (Vertical Offset From Spline) : float
    FUNobjMod.width     = FUNdims.z           -- (Width of Mark): float
    FUNobjMod.cf        = FUNhorizParams.y    -- (Crossfall of Mark) : float

    --- Set Marking Parameters - Material Mapping Related
    FUNobjMod.uvRepeat  = LOCscale as float   -- (UV_Repeat) : float
    FUNobjMod.matID     = LOCmatID            -- (Material_ID) : integer
    FUNobjMod.faceMap   = false               -- (Face_Mapping) : boolean

    --- Set Type of Marking -- this is always the same
    FUNobjMod.type      = 1                   -- (Mark_Type) : integer
    FUNobjMod.normalize = true                -- : boolean

    --- Set Marking Parameters - Optimisation Related - should be sourced from standard main INI file settings
    FUNobjMod.spacing   = FUNoptimiseParams.x -- (Length of Mark + Gap) : float
    FUNobjMod.threshold = FUNoptimiseParams.y -- : float
    FUNobjMod.maxDist   = FUNoptimiseParams.z -- : float
  )
  FUNobjMod -- Return New Road Marking
)


fn DYNFUNcreateMarks FUNshapeArray FUNrmsStyle FUNshift FUNshow FUNlocalTime FUNcolor FUNdims FUNoverrideShift FUNdelOldSwitch FUNsceneMats FUNexistingModifier FUNinstanceSwitch FUNcentrelineGap FUNhOffset FUNcrossfall =
(
  local LOCnewObjArray = #()
  clearUndoBuffer()
  undo off
  (
    local LOCproceedSwitch = true
    for i in FUNshapeArray do
    (
      --- Check whether any road marking objects are already applied to these parent shapes and
      --- delete them if they are. Only one road marking object allowed per shape. Only do this if Switch is set to true
      if FUNdelOldSwitch and i.children.count > 0 then
      (
        for ii = i.children.count to 1 by -1 do (local LOCchild = getAppData i.children[ii] 422; if LOCchild == "10" then delete i.children[ii])
      )

      --- Ensure that parent shape is an editable spline
      DYNFUNcheckIsSplineShape i

      --- Check that specified parents are shapes and that no Civil_View_Road_Marking modifier already exists
      if ((ClassOf i.baseObject) != splineshape and (ClassOf i) != PolymorphicGeomshape) or (CVGetMod i Civil_View_Road_Marking) != undefined then LOCproceedSwitch = false
    )

    --- Check Style Reference Is Valid
    if (classOf FUNrmsStyle) != string then LOCproceedSwitch = false

    --- Check If OK To Proceed, create references of parent shape objects
    if LOCproceedSwitch then
    (
      local LOCmaterial = if FUNsceneMats[DYNmatNameMarkings] != undefined then FUNsceneMats[DYNmatNameMarkings] else (DYNFUNmakeCivilViewMarkings undefined 0 DYNINImarkingColor (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameMarkingMaps + "\\") 0.0)
      for i in FUNshapeArray do
      (
        --- Create a referenced clone of the parent shape for each spline in the object (Remember that the "New Parent Shape" routine in DYNgRailParams doesn't use this section, so if it changes update that too....)
        local LOCnamePart          = getAppData i 427 ; if LOCnamePart == undefined then LOCnamePart = i.name
        local LOCrMark             = DYNFUNmakeReferenceWithoutMatPropogation i LOCmaterial
        LOCrMark.name              = uniqueName (DYNuiResourcesNodeNames[30] + LOCnamePart + "-0")
        LOCrMark.castShadows       = false
        try (LOCnewMark.isGIoccluder = false) catch ()
        LOCrMark.isFrozen          = FUNshow
        LOCrMark.showFrozeninGray  = false -- must be false for opacity map to be displayed in shaded viewports.
        LOCrMark.wireColor         = color 100 100 225
        if isValidNode LOCrMark then (append DYNobjHandles[10] LOCrMark.inode.handle)
        /* New Mark will have been automatically added to DYNobjHandles[17] when shape was first created, but it is now also in DYNobjHandles[10]. Delete it from DYNobjHandles[17] */
        local LOCfind = findItem DYNobjHandles[17] LOCrMark.inode.handle; if LOCfind > 0 then deleteItem DYNobjHandles[17] LOCfind
        /* append to array to receive Civil_View_Road_Marking modifier */
        append LOCnewObjArray LOCrMark
      )

      --- Create New or reference existing Modifier
      local LOCobjMod = if classOf FUNexistingModifier == Civil_View_Road_Marking then FUNexistingModifier else (Civil_View_Road_Marking ui:On splineIndex:0)
      if FUNexistingModifier == undefined then
      (
        DYNFUNmodifyMarks LOCobjMod LOCmaterial FUNdims FUNcolor FUNshift [FUNhOffset, FUNcrossfall] [DYNINImarkingSpacing, DYNINImarkingThreshold, DYNINImarkingMaxDistance] FUNcentrelineGap
      )

      --- Apply Modifier to Array of New Objects (Instance or Copy) - then update AppData
      if FUNinstanceSwitch and LOCnewObjArray.count > 0 then (addModifier LOCnewObjArray LOCobjMod) else (for i in LOCnewObjArray do (addmodifier i (copy LOCobjMod)))

      --- Apply AppData to all new Marking Objects
      for i in LOCnewObjArray do
      (
        DYNFUNgenObjAppData i "10" LOCobjMod.matID FUNrmsStyle FUNlocalTime (FUNdims.x as string) (FUNdims.y as string) ((if FUNoverrideShift then (-FUNdims.z) else (FUNdims.z)) as string)
        setAppData i 430 (FUNcentrelineGap as string)
      )
    )
  )
  LOCnewObjArray -- return value
)

fn DYNFUNcreatePointSystemBirthAction FUNparticleArray =
(
  local LOCbirthScript = ""

  --- Point System: Create Birth Script (Script All Particles)
  LOCbirthScript += "-- Point System Birth Script --\n"
  LOCbirthScript += "on ChannelsUsed pCont do\n"
  LOCbirthScript += "(\n"
  LOCbirthScript += "   pCont.usePosition = true\n"
  LOCbirthScript += "   pCont.useOrientation = true\n"
  LOCbirthScript += ")\n"
  LOCbirthScript += "on Init pCont do ()\n"
  LOCbirthScript += "on Proceed pCont do\n"
  LOCbirthScript += "(\n"
  LOCbirthScript += "  if pCont.numParticles() == 0 then\n"
  LOCbirthScript += "  (\n"

  for i in FUNparticleArray do
  (
    LOCbirthScript += "    pCont.AddParticle()\n"
    LOCbirthScript += "    pCont.particleIndex         = pCont.NumParticles()\n"
    LOCbirthScript += "    pCont.particlePosition      = " + (i[1] as string) + "\n"
    LOCbirthScript += "    pCont.particleOrientation.z = " + (i[2] as string) + "\n"
    LOCbirthScript += "    pCont.particleID            = " + (i[3] as string) + "\n"
  )

  LOCbirthScript += "  )\n"
  LOCbirthScript += ")\n"
  LOCbirthScript += "on Release pCont do ()\n"
  LOCbirthScript += "\n"

  particleFlow.beginEdit()
  local LOCbirthAction             = Birth_Script()
  LOCbirthAction.Emit_Start        = 0 -- Integer Get/Set the time in ticks at which the operator begins emitting particles. default: 0
  LOCbirthAction.Random_Seed       = 12345 -- Integer default: 12345 -- integer Specifies the randomization value.
  LOCbirthAction.Proceed_Script    = LOCbirthScript
  particleFlow.endEdit()

  LOCbirthAction -- return value
)

fn DYNFUNcreatePointSystem FUNparticleArray FUNwireColor FUNnode =
(
  local LOCptSysNode

  with undo label:DYNuiResourcesUndoLabels[19] on
  (
    LOCptSysNode = PF_Source Show_Logo:off Quantity_Viewport:100 pos:FUNparticleArray[1][1] Show_Emitter:on Emitter_Width:5.0 Emitter_Length:5.0 Emitter_Type:0

    --- Point System: Add Render Action
    particleFlow.beginEdit()
    local LOCrenderAction      = RenderParticles()
    LOCrenderAction.Type       = 2 -- Controls the state of the Type drop-down list. Possible values are: (0: None, 1: BoundingBox, 2: Geometry)
    LOCrenderAction.Visible    = 100.0 -- Get/Set the percentage of particles that render (Float default:100.0 --percentage)
    LOCrenderAction.Split_Type = 0 -- Controls the state of the Render Result group radio buttons. (0: Single Mesh, 1: Multiple Meshes, 2: Mesh Per Particle)
    LOCptSysNode.appendAction LOCrenderAction
    particleFlow.endEdit()

    --- Point System:  Set ParticleView Location
    local x=y=1
    LOCptSysNode.GetPViewLocation &x &y

    --- Point System: Create Birth Script (Script All Particles)
    local LOCbirthAction             = DYNFUNcreatePointSystemBirthAction FUNparticleArray

    --- Start Editing Point System
    particleFlow.beginEdit()

    --- Add Shape Instance
    local LOCinstanceAction          = shape_instance()
    if FUNnode != undefined then
    (
      LOCinstanceAction.Shape_Object = FUNnode
    )

    --- Add Display Action
    local LOCdisplayAction1          = displayParticles()
    LOCdisplayAction1.Type           = 6            -- Integer Controls how particles appear in the viewports.  default:2 0: None, 1: Dots, 2: Ticks, 3: Circles, 4: Lines, 5: BoundingBox, 6: Geometry, 7: Diamonds, 8: Boxes, 9: Asterisks, 10: Triangles
    LOCdisplayAction1.Visible        = 100.0        -- Float default:100.0 -- Specifies the percentage of particles visible in the viewports. This option lets you speed up viewport redrawing by reducing the number of visible particles --percentage
    LOCdisplayAction1.Color          = FUNwireColor -- RGB color -- Get/Set the color used to draw particles in the viewport.
    LOCdisplayAction1.Show_Numbering = true         -- Boolean -- When set to true, each particle's unique index number is visible in the viewports. Particles are numbered in the order of their birth, starting with 1 for the first particle borndefault:false
    LOCdisplayAction1.Selected_Type  = 6            -- Integer -- Controls how selected particles appear in the viewports. The options are the same as in .Type. default:2

    --- Point System: Add Event 01
    local LOCevent01 = event()
    LOCevent01.appendAction LOCbirthAction
    LOCevent01.appendAction LOCinstanceAction ; LOCevent01.activateAction 2 0
    LOCevent01.appendAction LOCdisplayAction1

    --- Point System: Add Event 01
    particleFlow.endEdit()

    --- Append the event as the Initial Action List to the PF_Source. This will connect the Event to the PF_Source.
    LOCptSysNode.appendInitialActionList LOCevent01
    LOCevent01.SetPViewLocation x (y+100) -- Position the Event inside the Particle View
  )
  LOCptSysNode -- return value
)

--- Function to clone any object in DVSP object categories 1 to 6 and include AppData, and DVSP Position Controller
fn DYNFUNcloneObject FUNsourceObj FUNobjNewName FUNobjNewChainage FUNobjNewOffsets FUNcloneType FUNsourceController FUNlocalTime FUNcloneChildren FUNobjectSwitch =
(
  local LOCnewObject
  local LOCnewObjCtrlr

  if isValidNode FUNsourceObj and classOf FUNobjNewName == string and classOf FUNobjNewChainage == float and (classOf FUNsourceController == DynXFCC or classOf FUNsourceController == DynXFCCM3 or classOf FUNsourceController == DynXFCCV3) then
  (
    DYNFUNloadVSPnodeCallBacks false
    (
      --- Basic Cloning Parameters
      LOCnewObject              = if FUNcloneType == 1 then instance FUNsourceObj else copy FUNsourceObj
      LOCnewObject.name         = FUNobjNewName
      LOCnewObject.wireColor    = FUNsourceObj.wireColor
      LOCnewObject.parent       = FUNsourceObj.parent -- Doesn't matter if this is undefined
      LOCnewObject.castShadows  = FUNsourceObj.castShadows
      try (LOCnewObject.isGIoccluder = FUNsourceObj.isGIoccluder) catch ()

      --- Apply Transform Controller and Position Object
      LOCnewObjCtrlr = LOCnewObject.transform.controller = copy FUNsourceController
      DYNFUNmaxBakingControl #(LOCnewObject) true

      LOCnewObjCtrlr.percent  = try (FUNobjNewChainage / (curveLength LOCnewObjCtrlr.path LOCnewObjCtrlr.spline)) catch (0.0)
      LOCnewObjCtrlr.hOffset  = try (FUNobjNewOffsets.x) catch (0.0)
      LOCnewObjCtrlr.vOffset  = try (FUNobjNewOffsets.y) catch (0.0)
      LOCnewObjCtrlr.rotation = try (FUNobjNewOffsets.z) catch (0.0)

      --- Apply AppData
      DYNFUNgenObjAppData LOCnewObject (getAppData FUNsourceObj 422) (getAppData FUNsourceObj 423) (getAppData FUNsourceObj 424) FUNlocalTime (getAppData FUNsourceObj 426) (getAppData FUNsourceObj 427) (getAppData FUNsourceObj 428)     -- Apply AppData to new object

      --- Add to Main DVSP Object Arrays
      append DYNobjHandles[FUNobjectSwitch] LOCnewObject.inode.handle

      --- Clone Children (Dependent Objects such as signs etc)
      if FUNcloneChildren then
      (
        for i = 1 to FUNsourceObj.children.count do
        (
          local LOColdChild       = FUNsourceObj.children[i]
          local LOCnewChild       = if FUNcloneType == 1 then instance LOColdChild else copy LOColdChild
          LOCnewChild.name        = uniqueName LOColdChild.name
          LOCnewChild.wireColor   = LOColdChild.wireColor
          LOCnewChild.castShadows = LOColdChild.castShadows
          try (LOCnewChild.isGIoccluder = LOColdChild.isGIoccluder) catch ()

          --- Apply Attach PRS Transform Controller
          DYNFUNattachObject LOCnewObject LOCnewChild [LOColdChild.objectOffsetPos.x * -1, LOColdChild.objectOffsetPos.y, LOColdChild.objectOffsetPos.z] (in coordSys parent (LOColdChild.rotation.z_rotation))

          --- Apply AppData
          local LOCchildObjSwitch = (getAppData LOColdChild 422) as integer
          DYNFUNgenObjAppData LOCnewChild (LOCchildObjSwitch as string) (getAppData LOColdChild 423) (getAppData LOColdChild 424) FUNlocalTime (getAppData LOColdChild 426) (getAppData LOColdChild 427) (getAppData LOColdChild 428)     -- Apply AppData to new object

          --- Add to Main DVSP Object Arrays
          append DYNobjHandles[LOCchildObjSwitch] LOCnewChild.inode.handle
        )
      )
    )
    DYNFUNloadVSPnodeCallBacks true
    DYNFUNnodeCreatedCallback() -- will check arrays for invalid node handles, then update Explorer Tree
    select LOCnewObject
  )
  LOCnewObject -- return value
)

--- Function to clone DVSP objects in Cats 1 - 6 which have previously been attached to other DVSP path controlled objects
fn DYNFUNcloneAttachedObject FUNsourceObj FUNobjNewName FUNobjNewOffsets FUNcloneType FUNlocalTime FUNobjectSwitch =
(
  local LOCnewObject
  local LOCnewObjCtrlr

  if isValidNode FUNsourceObj and classOf FUNobjNewName == string and classOf FUNobjNewOffsets == Point3 then
  (
    DYNFUNloadVSPnodeCallBacks false
    (
      --- Basic Cloning Parameters
      LOCnewObject              = if FUNcloneType == 1 then instance FUNsourceObj else copy FUNsourceObj
      LOCnewObject.name         = FUNobjNewName
      LOCnewObject.wireColor    = FUNsourceObj.wireColor
      LOCnewObject.parent       = FUNsourceObj.parent -- Doesn't matter if this is undefined
      LOCnewObject.castShadows  = FUNsourceObj.castShadows
      try (LOCnewObject.isGIoccluder = FUNsourceObj.isGIoccluder) catch ()

      LOCnewObject.objectOffsetPos = FUNobjNewOffsets

      --- Apply AppData
      DYNFUNgenObjAppData LOCnewObject (getAppData FUNsourceObj 422) (getAppData FUNsourceObj 423) (getAppData FUNsourceObj 424) FUNlocalTime (getAppData FUNsourceObj 426) (getAppData FUNsourceObj 427) (getAppData FUNsourceObj 428)     -- Apply AppData to new object

      --- Add to Main DVSP Object Arrays
      append DYNobjHandles[FUNobjectSwitch] LOCnewObject.inode.handle
    )
    DYNFUNloadVSPnodeCallBacks true
    DYNFUNnodeCreatedCallback() -- will check arrays for invalid node handles, then update Explorer Tree
    select LOCnewObject
  )
  LOCnewObject -- return value
)

--- Associated Panel for Cloning Function - this panel is called from PathObjectList rollout
fn DYNFUNcloneObjectPanel FUNobj FUNchildSwitch FUNobjectSwitch =
(
  ExeStr=("rollout DYNcloneRollout \"\"\n")
  ExeStr+=("(\n")
  ExeStr+=(" local LOCnewObj\n")
  ExeStr+=(" local LOColdObj\n")
  ExeStr+=(" local LOCobjectController\n")
  ExeStr+=(" local LOCobjLen\n")
  ExeStr+=(" local LOCstartMarker\n")
  ExeStr+=(" local LOCstartMarkerController\n")

  ExeStr+=(" groupbox GBDYN01 height:198 width:292 pos:[10,8]\n")
  ExeStr+=(" label LBDYNattachedTo1 align:#left    pos:[19,30]\n")
  ExeStr+=(" label LBDYNattachedTo2 align:#left    pos:[137,30]\n")
  ExeStr+=(" label LBDYNoldName1    align:#left    pos:[19,51]\n")
  ExeStr+=(" label LBDYNoldName2    align:#left    pos:[137,51]\n")
  ExeStr+=(" editText EDDYNname     align:#right   pos:[130,72] fieldwidth:160\n")
  ExeStr+=(" label LBDYNname        align:#left    pos:[19,72]\n")
  ExeStr+=(" label LBDYNchainage    align:#left    pos:[19,100]\n")
  ExeStr+=(" label LBDYNhOff        align:#left    pos:[19,121]\n")
  ExeStr+=(" label LBDYNvOff        align:#left    pos:[19,142]\n")
  ExeStr+=(" label LBDYNrot         align:#left    pos:[19,163]\n")

  ExeStr+=(" spinner SPDYNchainage type:#worldunits range:[0.0,99999.0,0.0]  scale:0.1 align:#right fieldwidth:74 pos:[208,100]\n")
  ExeStr+=(" spinner SPDYNhOff     type:#worldunits range:[-999.0,999.0,0.0] scale:0.1 align:#right fieldwidth:74 pos:[208,121]\n")
  ExeStr+=(" spinner SPDYNvOff     type:#worldunits range:[-999.0,999.0,0.0] scale:0.1 align:#right fieldwidth:74 pos:[208,142]\n")
  ExeStr+=(" spinner SPDYNrot      type:#float      range:[-360.0,360.0,0.0] scale:0.1 align:#right fieldwidth:74 pos:[208,163]\n")
  ExeStr+=(" checkbox CKDYNchildren align:#left pos:[19,184]\n")
  ExeStr+=(" groupbox GBDYN02 height:55 width:292 pos:[10,216]\n")
  ExeStr+=(" radiobuttons RBDYNcloneType columns:1 labels:#(DYNuiResourcesLabels[354],DYNuiResourcesLabels[355]) align:#left pos:[19,233]\n")

  ExeStr+=(" button BUDYNokok DYNuiResourcesButtons[1] width:84 pos:[40,281]\n")
  ExeStr+=(" button BUDYNcanc DYNuiResourcesButtons[3] width:84 pos:[190,281]\n")

  ExeStr+=(" on DYNcloneRollout open do\n")
  ExeStr+=(" (\n")
  ExeStr+=("   DYNcloneRollout.title    = DYNuiRolloutNames[66]\n")
  ExeStr+=("   GBDYN02.text             = DYNuiResourcesGroups[105]\n")
  ExeStr+=("   GBDYN01.text             = DYNuiResourcesGroups[106]\n")
  ExeStr+=("   LBDYNoldName1.text       = DYNuiResourcesLabels[357]\n")
  ExeStr+=("   LBDYNattachedTo1.text    = DYNuiResourcesLabels[519]\n")
  ExeStr+=("   LBDYNname.text           = DYNuiResourcesLabels[515]\n")
  ExeStr+=("   LBDYNhOff.text           = DYNuiResourcesLabels[516]\n")
  ExeStr+=("   LBDYNvOff.text           = DYNuiResourcesLabels[517]\n")
  ExeStr+=("   LBDYNchainage.text       = DYNuiResourcesLabels[518]\n")
  ExeStr+=("   LBDYNrot.text            = DYNuiResourcesLabels[472]\n")
  ExeStr+=("   CKDYNchildren.text       = DYNuiResourcesLabels[363]\n")

  ExeStr+=("   LOColdObj                = maxOps.getNodeByHandle " + (FUNobj.inode.handle as string) + "\n")
  ExeStr+=("   EDDYNname.text           = uniqueName LOColdObj.name\n")
  ExeStr+=("   LBDYNoldName2.text       = LOColdObj.name\n")
  ExeStr+=("   setFocus EDDYNname\n")
  ExeStr+=("   CKDYNchildren.enabled    = (if LOColdObj.children.count > 0 then true else false)\n")
  ExeStr+=("   CKDYNchildren.checked    = (if LOColdObj.children.count > 0 then true else false)\n")
  ExeStr+=("   LOCobjectController      = LOColdObj.transform.controller\n")
  ExeStr+=("   LOCobjLen                = curveLength LOCobjectController.path LOCobjectController.spline\n")
  ExeStr+=("   LBDYNattachedTo2.text    = if isValidNode LOCobjectController.path then LOCobjectController.path.name else \"\"\n")
  ExeStr+=("   LOCstartMarker           = DYNFUNapplyDYNmarker LOCobjectController.path LOCstartMarker DYNINIstartMarkerColor 0 DYNINImarkerSize LOCobjectController.spline\n")
  ExeStr+=("   SPDYNchainage.range.y    = LOCobjLen\n")
  ExeStr+=("   SPDYNchainage.value      = LOCobjLen * LOCobjectController.percent\n")
  ExeStr+=("   SPDYNhOff.value          = LOCobjectController.hOffset\n")
  ExeStr+=("   SPDYNvOff.value          = LOCobjectController.vOffset\n")
  ExeStr+=("   SPDYNrot.value           = LOCobjectController.rotation\n")
  ExeStr+=("   if LOCstartMarker != undefined then\n")
  ExeStr+=("   (\n")
  ExeStr+=("     LOCstartMarkerController = LOCstartMarker.transform.controller\n")
  ExeStr+=("     LOCstartMarkerController.percent = LOCobjectController.percent\n")
  ExeStr+=("   )\n")
  ExeStr+=("   else\n")
  ExeStr+=("   (\n")
  ExeStr+=("     for i in DYNcloneRollout.controls do i.enabled = false\n")
  ExeStr+=("     BUDYNcanc.enabled = true\n")
  ExeStr+=("   )\n")
  ExeStr+=(" )\n")
  ExeStr+=(" on DYNcloneRollout close do\n")
  ExeStr+=(" (\n")
  ExeStr+=("   if isValidNode LOCstartMarker then (delete LOCstartMarker; LOCstartMarker = undefined; LOCstartMarkerController = undefined)\n")
  ExeStr+=(" )\n")
  ExeStr+=(" on SPDYNchainage changed arg do\n")
  ExeStr+=(" (\n")
  ExeStr+=("   LOCstartMarkerController.percent = SPDYNchainage.value / LOCobjLen\n")
  ExeStr+=(" )\n")
  ExeStr+=(" on BUDYNokok pressed do\n")
  ExeStr+=(" (\n")
  ExeStr+=("   destroyDialog DYNcloneRollout\n")
  ExeStr+=("   LOCnewObj = DYNFUNcloneObject LOColdObj EDDYNname.text SPDYNchainage.value [SPDYNhOff.value, SPDYNvOff.value, SPDYNrot.value] RBDYNcloneType.state LOCobjectController (DYNFUNgetLocalTime()) CKDYNchildren.checked " + (FUNobjectSwitch as string) + "\n")
  ExeStr+=(" )\n")
  ExeStr+="  on BUDYNcanc pressed do (LOCnewObj = undefined; destroyDialog DYNcloneRollout)\n"
  ExeStr+=")\n"

  local DYNcloneRollout = Execute ExeStr

  createDialog DYNcloneRollout width:312 height:311 modal:true
  return DYNcloneRollout.LOCnewObj
)

fn DYNFUNcloneAttachedObjectPanel FUNobj FUNobjectSwitch =
(
  ExeStr=("rollout DYNcloneRollout \"\"\n")
  ExeStr+=("(\n")
  ExeStr+=(" local LOCnewObj\n")
  ExeStr+=(" local LOColdObj\n")
  ExeStr+=(" groupbox GBDYN01       height:159 width:292 pos:[10,8]\n")
  ExeStr+=(" label LBDYNattachedTo1 align:#left pos:[19,30]\n")
  ExeStr+=(" label LBDYNattachedTo2 align:#left pos:[137,30]\n")
  ExeStr+=(" label LBDYNoldName1    align:#left pos:[19,51]\n")
  ExeStr+=(" label LBDYNoldName2    align:#left pos:[137,51]\n")
  ExeStr+=(" editText EDDYNname     align:#right pos:[130,72] fieldwidth:160\n")
  ExeStr+=(" spinner SPDYNhOff      type:#worldunits range:[-999.0,999.0,0.0] scale:0.1 align:#right fieldwidth:64 pos:[218,100]\n")
  ExeStr+=(" spinner SPDYNvOff      type:#worldunits range:[-999.0,999.0,0.0] scale:0.1 align:#right fieldwidth:64 pos:[218,121]\n")
  ExeStr+=(" spinner SPDYNchn       type:#worldunits range:[-100.0,100.0,0.0] scale:0.1 align:#right fieldwidth:64 pos:[218,142]\n")
  ExeStr+=(" label LBDYNname        align:#left pos:[19,72]\n")
  ExeStr+=(" label LBDYNhOff        align:#left pos:[19,100]\n")
  ExeStr+=(" label LBDYNvOff        align:#left pos:[19,121]\n")
  ExeStr+=(" label LBDYNchn         align:#left pos:[19,142]\n")
  ExeStr+=(" groupbox GBDYN02       height:55 width:292 pos:[10,173]\n")
  ExeStr+=(" radiobuttons RBDYNcloneType columns:1 labels:#(DYNuiResourcesLabels[354],DYNuiResourcesLabels[355]) align:#left pos:[19,190]\n")
  ExeStr+=(" button BUDYNokok DYNuiResourcesButtons[1] width:84 pos:[40,238]\n")
  ExeStr+=(" button BUDYNcanc DYNuiResourcesButtons[3] width:84 pos:[190,238]\n")
  ExeStr+=(" on DYNcloneRollout open do\n")
  ExeStr+=(" (\n")
  ExeStr+=("   DYNcloneRollout.title = DYNuiRolloutNames[65]\n")
  ExeStr+=("   GBDYN02.text          = DYNuiResourcesGroups[105]\n")
  ExeStr+=("   GBDYN01.text          = DYNuiResourcesGroups[106]\n")
  ExeStr+=("   LBDYNoldName1.text    = DYNuiResourcesLabels[357]\n")
  ExeStr+=("   LBDYNattachedTo1.text = DYNuiResourcesLabels[514]\n")
  ExeStr+=("   LBDYNname.text        = DYNuiResourcesLabels[515]\n")
  ExeStr+=("   LBDYNhOff.text        = DYNuiResourcesLabels[516]\n")
  ExeStr+=("   LBDYNvOff.text        = DYNuiResourcesLabels[517]\n")
  ExeStr+=("   LBDYNchn.text         = DYNuiResourcesLabels[518]\n")
  ExeStr+=("   LOColdObj             = maxOps.getNodeByHandle " + (FUNobj.inode.handle as string) + "\n")
  ExeStr+=("   EDDYNname.text        = uniqueName LOColdObj.name\n")
  ExeStr+=("   LBDYNoldName2.text    = LOColdObj.name\n")
  ExeStr+=("   LBDYNattachedTo2.text = if isValidNode LOColdObj.parent then LOColdObj.parent.name else \"\"\n")
  ExeStr+=("   setFocus EDDYNname\n")
  ExeStr+=("   SPDYNhOff.value = LOColdObj.objectOffsetPos.x\n")
  ExeStr+=("   SPDYNvOff.value = LOColdObj.objectOffsetPos.z\n")
  ExeStr+=("   SPDYNchn.value  = LOColdObj.objectOffsetPos.y\n")
  ExeStr+=(" )\n")

  ExeStr+=(" on DYNcloneRollout close do\n")
  ExeStr+=(" (\n")
  ExeStr+=(" )\n")

  ExeStr+=(" on BUDYNokok pressed do\n")
  ExeStr+=(" (\n")
  ExeStr+=("   destroyDialog DYNcloneRollout\n")
  ExeStr+=("   LOCnewObj = DYNFUNcloneAttachedObject LOColdObj EDDYNname.text [SPDYNhOff.value, SPDYNchn.value, SPDYNvOff.value] RBDYNcloneType.state (DYNFUNgetLocalTime()) " + (FUNobjectSwitch as string) + "\n")
  ExeStr+=(" )\n")

  ExeStr+="  on BUDYNcanc pressed do (LOCnewObj = undefined; destroyDialog DYNcloneRollout)\n"
  ExeStr+=")\n"

  local DYNcloneRollout = Execute ExeStr

  createDialog DYNcloneRollout width:312 height:268 modal:true
  return DYNcloneRollout.LOCnewObj
)

fn DYNFUNsaveDnLvtoTextFile FUNdnLV FUNdelimitor =
(
  local LOCtempFile
  if FUNdnLV.selectedItems.count > 0 then
  (
    LOCtempFile = getSaveFileName caption:(DYNuiResourcesTitlebars[56]) filename:((getdir #export) + "\\*.txt") types:DYNuiResourcesFileTypes[8]
    if LOCtempFile != undefined then
    (
      local LOCcurrentFileStream = try (createFile LOCtempFile) catch ()
      if LOCcurrentFileStream != undefined then
      (
        for i = 1 to FUNdnLV.selectedItems.count do
        (
          local LOCarray = #()
          for ii = 1 to FUNdnLV.selectedItems.item[i-1].subItems.count do
          (
            append LOCarray (FUNdnLV.selectedItems.item[i-1].subItems.item[ii-1].text)
          )

          local LOCarrayString = DYNFUNarray2DelimitedString LOCarray FUNdelimitor
          format "%\n" LOCarrayString to:LOCcurrentFileStream
        )
        close LOCcurrentFileStream
      )
      else
      (
        messagebox DYNuiResourcesErrorsWarnings[16] title:DYNuiResourcesTitlebars[1]
        LOCtempFile = undefined
      )
    )
  )
  else
  (
    messagebox (DYNuiResourcesErrorsWarnings[59]) title:DYNuiResourcesTitlebars[1]
  )

  LOCtempFile -- return value (undefined if file not created)
)

fn DYNFUNpostEnable FUNarg FUNObj FUNrollout =
(
  FUNrollout.CBDYNpostflip.enabled    = FUNarg
  FUNrollout.CBDYNpostCapT.enabled    = FUNarg
  FUNrollout.CBDYNpostCapB.enabled    = FUNarg
  --FUNrollout.LBDYNspacing.enabled     = FUNarg
  --FUNrollout.SPDYNspacing.enabled     = FUNarg
  FUNrollout.LBDYNpostWidth.enabled   = FUNarg
  FUNrollout.SPDYNpostWidth.enabled   = FUNarg
  FUNrollout.SPDYNpostDepth.enabled   = FUNarg
  FUNrollout.LBDYNgroundDepth.enabled = FUNarg
  FUNrollout.SPDYNgroundDepth.enabled = FUNarg
  FUNrollout.LBDYNpostType.enabled    = FUNarg
  FUNrollout.DDDYNpostType.enabled    = FUNarg
  if isValidNode FUNobj then
  (
    FUNrollout.LBDYNpostMat.enabled   = if classOf FUNobj.material == Multimaterial then FUNarg else false
    FUNrollout.DDDYNpostMat.enabled   = if classOf FUNobj.material == Multimaterial then FUNarg else false
  )
  else
  (
    FUNrollout.LBDYNpostMat.enabled   = FUNarg
    FUNrollout.DDDYNpostMat.enabled   = FUNarg
  )
)

fn DYNFUNbraceEnable FUNarg FUNobj FUNrollout =
(
  FUNrollout.LBDYNbraceDepth.enabled  = FUNarg
  FUNrollout.SPDYNbraceDepth.enabled  = FUNarg
  FUNrollout.LBDYNbraceHeight.enabled = FUNarg
  FUNrollout.SPDYNbraceHeight.enabled = FUNarg
  FUNrollout.LBDYNbraceGap.enabled    = FUNarg
  FUNrollout.SPDYNbraceGap.enabled    = FUNarg
  FUNrollout.LBDYNbraceType.enabled   = FUNarg
  FUNrollout.DDDYNbraceType.enabled   = FUNarg
  if isValidNode FUNobj then
  (
    FUNrollout.LBDYNbraceMat.enabled  = if classOf FUNobj.material == Multimaterial then FUNarg else false
    FUNrollout.DDDYNbraceMat.enabled  = if classOf FUNobj.material == Multimaterial then FUNarg else false
  )
  else
  (
    FUNrollout.LBDYNbraceMat.enabled  = FUNarg
    FUNrollout.DDDYNbraceMat.enabled  = FUNarg
  )
)

fn DYNFUNrailEnable FUNargL FUNargR FUNobj FUNrollout =
(
  local LOCarg = if FUNargL == false and FUNargR == false then false else true
  FUNrollout.LBDYNrailVertical.enabled = LOCarg
  FUNrollout.SPDYNrailVertical.enabled = LOCarg
  FUNrollout.LBDYNrailHeight.enabled   = LOCarg
  FUNrollout.SPDYNrailHeight.enabled   = LOCarg
  FUNrollout.LBDYNrailWidth.enabled    = LOCarg
  FUNrollout.SPDYNrailWidth.enabled    = LOCarg
  FUNrollout.LBDYNrailType.enabled     = LOCarg
  FUNrollout.DDDYNrailType.enabled     = LOCarg
  if isValidNode FUNobj then
  (
    FUNrollout.LBDYNrailMat.enabled    = if classOf FUNobj.material == Multimaterial then LOCarg else false
    FUNrollout.DDDYNrailMat.enabled    = if classOf FUNobj.material == Multimaterial then LOCarg else false
  )
  else
  (
    FUNrollout.LBDYNrailMat.enabled    = LOCarg
    FUNrollout.DDDYNrailMat.enabled    = LOCarg
  )
  FUNrollout.LBDYNgUVrepeat.enabled    = LOCarg
  FUNrollout.SPDYNgUVrepeat.enabled    = LOCarg
)

fn DYNFUNrenameFile FUNsourceFile FUNtargetFile FUNfileSelectorFileType FUNreportErrors =
(
  local LOCrtnParam = false-- returns true if file was moved/renamed
  if doesFileExist FUNsourceFile then
  (
    if not (getFileAttribute FUNsourceFile #readOnly) then
    (
      --- Check whether target file contains an filename extension. If not, add source filename extension to target filename
      if not (striCmp (subString FUNtargetFile (FUNtargetFile.count - 3) -1) ("." + FUNfileSelectorFileType) == 0) then
      (
        FUNtargetFile += getFileNameType FUNsourceFile
      )

      --- Check if target file exists. If not, rename or move source file to target file.
      if FUNsourceFile != FUNtargetFile then
      (
        if (DoesfileExist FUNtargetFile) == false then
        (
          LOCrtnParam  = renameFile FUNsourceFile FUNtargetFile -- returns true if file was deleted
          if not LOCrtnParam then
          (
            if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[130]) title:DYNuiResourcesTitlebars[2])
          )
        )
        else (if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[89]) title:DYNuiResourcesTitlebars[2]))
      )
    )
    else (if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[39]) title:DYNuiResourcesTitlebars[2]))
  )
  else (if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[95]) title:DYNuiResourcesTitlebars[2]))
  LOCrtnParam -- return value
)

fn DYNFUNcopyFile FUNsourceFile FUNtargetFile FUNfileSelectorFileType FUNreportErrors =
(
  local LOCrtnParam = false-- returns true if file was moved/renamed
  if doesFileExist FUNsourceFile then
  (
    --- Check whether target file contains an filename extension. If not, add source filename extension to target filename
    if not (striCmp (subString FUNtargetFile (FUNtargetFile.count - 3) -1) ("." + FUNfileSelectorFileType) == 0) then
    (
      FUNtargetFile += getFileNameType FUNsourceFile
    )

    --- Check if target file exists. If not, rename or move source file to target file.
    if FUNsourceFile != FUNtargetFile then
    (
      if (DoesfileExist FUNtargetFile) == false then
      (
        LOCrtnParam  = copyFile FUNsourceFile FUNtargetFile -- returns true if file was copied
        if not LOCrtnParam then (if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[131]) title:DYNuiResourcesTitlebars[2]))
      )
      else (if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[89]) title:DYNuiResourcesTitlebars[2]))
    )
    else (if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[132]) title:DYNuiResourcesTitlebars[2]))
  )
  else (if FUNreportErrors then (messagebox (DYNuiResourcesErrorsWarnings[95]) title:DYNuiResourcesTitlebars[2]))
  LOCrtnParam -- return value
)

fn DYNFUNformatDecPlaces FUNfloat FUNdecPlaces FUNshift =
(
  /* Turns a float into a string, formatted to a specific number of decimal places */

  local LOCoutString = ""

  if 0.0 < FUNfloat then
  (
    local LOCmainInt  = (floor FUNfloat) as integer
    local LOCdecFloat = FUNfloat - LOCmainInt
    local LOCdecStr   = subString (LOCdecFloat as string) 3 -1
    while LOCdecStr.count < FUNdecPlaces do LOCdecStr = LOCdecStr + "0"
    if LOCdecStr.count > FUNdecPlaces then LOCdecStr = subString LOCdecStr 1 FUNdecPlaces
    LOCoutString      = ((LOCmainInt - FUNshift) as string) + "." + LOCdecStr
  )
  else
  (
    local LOCmainInt  = (ceil FUNfloat) as integer -- If negative number, ceil should be used
    local LOCdecFloat = FUNfloat - LOCmainInt
    local LOCdecStr   = subString (LOCdecFloat as string) 4 -1
    while LOCdecStr.count < FUNdecPlaces do LOCdecStr = LOCdecStr + "0"
    if LOCdecStr.count > FUNdecPlaces then LOCdecStr = subString LOCdecStr 1 FUNdecPlaces
    LOCoutString      = ((LOCmainInt - FUNshift) as string) + "." + LOCdecStr
  )
  LOCoutString -- return value
)

fn DYNFUNmakeAlignmentReport FUNalign FUNretainSwitch FUNdisplaySwitch =
(
  local LOCreportFile       = DYNtempPath + "ShapeReport.htm"
  local LOCreportFileStream = createFile LOCreportFile

  if (LOCreportFileStream != undefined) and (ClassOf FUNalign == CivilView_Alignment) then
  (
    --- Print HTML Header Information -----------------------------------
    format "<HTML>\n" to:LOCreportFileStream
    format "<HEAD>\n" to:LOCreportFileStream
    format " <TITLE>%</TITLE>\n" DYNuiResourcesTitlebars[57] to:LOCreportFileStream
    format " <META http-equiv=content-type content=\"text/html; charset=iso-8859-1\">\n" to:LOCreportFileStream
    format " <STYLE type=text/css>HR {font-family: courier; COLOR: #004f9d}\n" to:LOCreportFileStream
    format "  TD#1 {font-size: 80%; text-align:  right; font-family:    courier; VERTICAL-ALIGN: top; WIDTH: 20%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#2 {font-size: 80%; text-align:  right; font-family:    courier; VERTICAL-ALIGN: top; WIDTH: 30%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#3 {font-size: 80%; text-align:  right; font-family:    courier; VERTICAL-ALIGN: top; WIDTH:  8%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#4 {font-size: 80%; text-align:   left; font-family:    courier; VERTICAL-ALIGN: top; WIDTH: 60%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#5 {font-size: 60%; text-align:   left; font-family: sans-serif; VERTICAL-ALIGN: top; WIDTH: 60%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#6 {font-size: 80%; text-align:  right; font-family:    courier; VERTICAL-ALIGN: top; WIDTH:  4%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#7 {font-size: 80%; text-align: center; font-family:    courier; VERTICAL-ALIGN: top; WIDTH:  8%}\n" "%" "%" to:LOCreportFileStream
    format " </STYLE>\n" to:LOCreportFileStream

    format " <style type=\"text/css\" media=\"print\"> \n" to:LOCreportFileStream
    format "   <!--\n" to:LOCreportFileStream
    format "     #noprintbuttonDIV { display:'none';}\n" to:LOCreportFileStream
    format "   // -->\n" to:LOCreportFileStream
    format " </style>\n" to:LOCreportFileStream

    format "</HEAD>\n" to:LOCreportFileStream
    format "\n" to:LOCreportFileStream

    format "<BODY>\n" to:LOCreportFileStream
    format "<CENTER>\n" to:LOCreportFileStream
    format "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"1100\">\n" to:LOCreportFileStream
    format "<tr><td align=right><span id=\"noprintbuttonDIV\" ><input type=\"button\" value=% name=\"print\" onclick=\"window.print()\"></span></td></tr>\n" DYNuiResourcesLabels[520] to:LOCreportFileStream
    format "<tr><td>\n" to:LOCreportFileStream

    format " <H2 align=center><B>%</B></H2>\n" FUNalign.name to:LOCreportFileStream

    --- Print Dynamite Related AppData Heading --------------------------
    if (getAppData FUNalign 421) == "Dynamite" then
    (
      format " <TABLE cellSpacing=0 cellPadding=0 width=\"100%\">\n" "%" to:LOCreportFileStream
      format "  <TBODY>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[9] to:LOCreportFileStream

      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" (DYNFUNformatDecPlaces FUNalign.startStation 3 0) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[10] to:LOCreportFileStream

      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" (DYNFUNformatDecPlaces FUNalign.endStation 3 0) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[461] to:LOCreportFileStream

      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" (getAppData FUNalign 427) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[462] to:LOCreportFileStream

      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" ((filterString (getAppData FUNalign 428) "$!!$")[1]) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[40] to:LOCreportFileStream

      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" (DYNFUNconvertGUPdate (getAppData FUNalign 425)) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[463] to:LOCreportFileStream

      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=5><i>%</i></TD>\n" (getAppData FUNalign 424) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "  </TBODY>\n" to:LOCreportFileStream
      format " </TABLE>\n" to:LOCreportFileStream
    )
    format "\n" to:LOCreportFileStream

    --- Print Alignment Chunk of Information ----------------------------
    local LOCstartID = 0
    local LOCrecSizeCnt = 0
    for cnt in FUNalign.DatasetSizeArray do
    (
      LOCrecSizeCnt += 1
      --- Header
      if LOCrecSizeCnt == 1 then
      (
        format "  <P><HR>%<HR>\n" DYNuiResourcesLabels[521] to:LOCreportFileStream
      )
      else
      (
        format "  <P><HR>% : %<HR>\n" DYNuiResourcesLabels[522] FUNalign.DatasetNameArray[LOCrecSizeCnt] to:LOCreportFileStream
      )
      format " <TABLE cellSpacing=0 cellPadding=0 width=\"100%\">\n" "%" to:LOCreportFileStream
      format "  <TBODY>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=7>%</TD>\n" DYNuiResourcesLabels[195] to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[1]  to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[2]  to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[3]  to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[4]  to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[5]  to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[6]  to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[7]  to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesReportColumns[8]  to:LOCreportFileStream
      format "    <TD id=7>%</TD>\n" DYNuiResourcesReportColumns[9]  to:LOCreportFileStream
      format "    <TD id=7>%</TD>\n" DYNuiResourcesReportColumns[10] to:LOCreportFileStream
      format "    <TD id=7>%</TD>\n" DYNuiResourcesReportColumns[11] to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream

      --- Point Data
      for i = (1 + LOCstartID) to (cnt + LOCstartID) do
      (
        local LOCpointID   = i - LOCstartID
        local LOCpointX    = DYNFUNformatDecPlaces FUNalign.XYZStationArray[i].x 3 rootNode.DYNrootNodeStore.shiftX
        local LOCpointY    = DYNFUNformatDecPlaces FUNalign.XYZStationArray[i].y 3 rootNode.DYNrootNodeStore.shiftY
        local LOCpointZ    = DYNFUNformatDecPlaces FUNalign.XYZStationArray[i].z 3 0
        local LOCstation   = DYNFUNformatDecPlaces FUNalign.XYZStationArray[i].w 3 0
        local LOChBearing  = DYNFUNformatDecPlaces (radToDeg FUNalign.radBearGradeArray[i].y) 6 0                  -- convert to degrees with (rad * 57.2958)
        local LOChRadius   = if bit.IsFinite FUNalign.radBearGradeArray[i].x then (DYNFUNformatDecPlaces FUNalign.radBearGradeArray[i].x 3 0) else (DYNuiResourcesLabels[197])
        local LOCvRadius   = if bit.IsFinite FUNalign.radBearGradeArray[i].z then (DYNFUNformatDecPlaces FUNalign.radBearGradeArray[i].z 3 0) else (DYNuiResourcesLabels[197])
        local LOCgrade     = DYNFUNformatDecPlaces FUNalign.radBearGradeArray[i].w 6 0
        local LOChTangText = if FUNalign.isAlignEntStartEnd[i]   then "HTP "  else ""
        local LOCvTangText = if FUNalign.isProfileEntStartEnd[i] then "VTP"  else ""
        local LOCboldStart = if FUNalign.isAlignEntStartEnd[i] or FUNalign.isProfileEntStartEnd[i] then "<B>"  else ""
        local LOCboldEnd   = if FUNalign.isAlignEntStartEnd[i] or FUNalign.isProfileEntStartEnd[i] then "</B>" else ""

        local LOChCodeText = ""                                                                                     -- (arc:1, line:2, spiral:3)
        if FUNalign.alignEntTypeArray[i]   == 1 then LOChCodeText = "Curve"
        if FUNalign.alignEntTypeArray[i]   == 2 then LOChCodeText = "Line"
        if FUNalign.alignEntTypeArray[i]   == 3 then LOChCodeText = "Spiral"

        local LOCvCodeText = ""                                                                                     -- (Circular:1, Tangent:2, PAsym:3, PSym:4)
        if FUNalign.profileEntTypeArray[i] == 1 then LOCvCodeText = "Circular"
        if FUNalign.profileEntTypeArray[i] == 2 then LOCvCodeText = "Grade"
        if FUNalign.profileEntTypeArray[i] == 3 then LOCvCodeText = "PAsym"
        if FUNalign.profileEntTypeArray[i] == 4 then LOCvCodeText = "Psym"

        format "   <TR>\n" to:LOCreportFileStream
        format "    <TD id=7>%%%</TD>\n"  LOCboldStart LOCpointID   LOCboldEnd to:LOCreportFileStream               -- POINT
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOCpointX    LOCboldEnd to:LOCreportFileStream               -- -----X-----
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOCpointY    LOCboldEnd to:LOCreportFileStream               -- -----Y-----
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOCpointZ    LOCboldEnd to:LOCreportFileStream               -- -----Z-----
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOCstation   LOCboldEnd to:LOCreportFileStream               -- --STATION--
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOChBearing  LOCboldEnd to:LOCreportFileStream               -- --BEARING--
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOChRadius   LOCboldEnd to:LOCreportFileStream               -- --HRADIUS--
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOCvRadius   LOCboldEnd to:LOCreportFileStream               -- --VRADIUS--
        format "    <TD id=3>%%%</TD>\n"  LOCboldStart LOCgrade     LOCboldEnd to:LOCreportFileStream               -- ---GRADE---
        format "    <TD id=7>%%%</TD>\n"  LOCboldStart LOChCodeText LOCboldEnd to:LOCreportFileStream               -- ---HCODE---
        format "    <TD id=7>%%%</TD>\n"  LOCboldStart LOCvCodeText LOCboldEnd to:LOCreportFileStream               -- ---VCODE---
        format "    <TD id=7>%%%%</TD>\n" LOCboldStart LOChTangText LOCvTangText LOCboldEnd to:LOCreportFileStream  -- --TANGPT--
        format "   </TR>\n" to:LOCreportFileStream
      )
      LOCstartID += cnt

      format "  </TBODY>\n" to:LOCreportFileStream
      format " </TABLE>\n" to:LOCreportFileStream
    )

    format " </td></tr>\n" to:LOCreportFileStream
    format " </TABLE>\n" to:LOCreportFileStream

    format "<HR>\n" to:LOCreportFileStream
    format "</CENTER>\n" to:LOCreportFileStream
    format "</BODY>\n" to:LOCreportFileStream

    format "\n" to:LOCreportFileStream
    format "</HTML>\n" to:LOCreportFileStream
    close LOCreportFileStream

    --- Create and Display Rollout ------------------------------------------------------------------------------
    if FUNdisplaySwitch then
    (
      local ExeStr=("rollout DYNreport DYNuiResourcesTitlebars[57]\n")
      ExeStr+=("(\n")
      ExeStr+=("dotNetControl dnShell \"System.Windows.Forms.WebBrowser\" height:800 width:1150 pos:[0,0]\n")
      ExeStr+=("on DYNreport open do\n")
      ExeStr+=("(\n")
      ExeStr+=("  dnShell.url = dotNetObject \"System.Uri\" \"" + LOCreportFile + "\"\n")
      ExeStr+=(")\n")
      ExeStr+=(")\n")
      local DYNreport = Execute ExeStr
      createDialog DYNreport width:1150 height:800 modal:false
    )
  )
  else
  (
    messageBox (DYNuiResourcesErrorsWarnings[102]) title:DYNuiResourcesTitlebars[1]
  )

  --- Decide whether report should be retained and saved to a unique filename
  if FUNretainSwitch then
  (
    deleteFile ((getdir #export) + "\\" + (getAppData FUNalign 427) + ".htm")
    copyFile LOCreportFile ((getdir #export) + "\\" + (getAppData FUNalign 427) + ".htm")
  )
)

--- Function to report the points found in a shape object
fn DYNFUNmakeShapeReport FUNshape =
(
  local LOCreportFile = DYNtempPath + "ShapeReport.htm"
  local LOCreportFileStream = createFile LOCreportFile

  if (LOCreportFileStream != undefined) and (superClassOf FUNshape == shape) then
  (
    format "<HTML>\n" to:LOCreportFileStream
    format "<HEAD>\n" to:LOCreportFileStream
    format " <TITLE>%</TITLE>\n" DYNuiResourcesTitlebars[58] to:LOCreportFileStream
    format " <META http-equiv=content-type content=\"text/html; charset=iso-8859-1\">\n" to:LOCreportFileStream
    format " <STYLE type=text/css>HR {font-family: courier; COLOR: #004f9d}\n" to:LOCreportFileStream
    format "  TD#1 {font-size: 80%; text-align: right; font-family: courier; VERTICAL-ALIGN: top; WIDTH: 20%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#2 {font-size: 80%; text-align: right; font-family: courier; VERTICAL-ALIGN: top; WIDTH: 30%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#3 {font-size: 80%; text-align: right; font-family: courier; VERTICAL-ALIGN: top; WIDTH: 10%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#4 {font-size: 80%; text-align: left;  font-family: courier; VERTICAL-ALIGN: top; WIDTH: 60%}\n" "%" "%" to:LOCreportFileStream
    format "  TD#5 {font-size: 60%; text-align: left;  font-family: sans-serif; VERTICAL-ALIGN: top; WIDTH: 60%}\n" "%" "%" to:LOCreportFileStream
    format " </STYLE>\n" to:LOCreportFileStream

    format " <style type=\"text/css\" media=\"print\"> \n" to:LOCreportFileStream
    format "   <!--\n" to:LOCreportFileStream
    format "     #noprintbuttonDIV { display:'none';}\n" to:LOCreportFileStream
    format "   // -->\n" to:LOCreportFileStream
    format " </style>\n" to:LOCreportFileStream

    format "</HEAD>\n" to:LOCreportFileStream
    format "\n" to:LOCreportFileStream

    format "<BODY>\n" to:LOCreportFileStream
    format "<CENTER>\n" to:LOCreportFileStream
    format "<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" width=\"480\">\n" to:LOCreportFileStream
    format "<tr><td align=right><span id=\"noprintbuttonDIV\" ><input type=\"button\" value=% name=\"print\" onclick=\"window.print()\"></span></td></tr>\n" DYNuiResourcesLabels[520] to:LOCreportFileStream
    format "<tr><td>\n" to:LOCreportFileStream

    format " <H2 align=center><B>%</B></H2>\n" FUNshape.name to:LOCreportFileStream

    if (getAppData FUNshape 421) == "Dynamite" then
    (
      local LOCobjectName = DYNFUNdisplayAppDataInUI (getAppData FUNshape 427)
      local LOCparentName = DYNFUNdisplayAppDataInUI (getAppData FUNshape 428)
      format " <TABLE cellSpacing=0 cellPadding=0 width=\"100%\">\n" "%" to:LOCreportFileStream
      format "  <TBODY>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[196] to:LOCreportFileStream
      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" ((numSplines FUNshape) as string) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[461] to:LOCreportFileStream
      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" (LOCobjectName) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[462] to:LOCreportFileStream
      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" (LOCparentName) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[40] to:LOCreportFileStream
      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=4>%</TD>\n" (DYNFUNconvertGUPdate (getAppData FUNshape 425)) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesLabels[463] to:LOCreportFileStream
      format "    <TD id=3></TD>\n" to:LOCreportFileStream
      format "    <TD id=5><i>%</i></TD>\n" (getAppData FUNshape 424) to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream
      format "  </TBODY>\n" to:LOCreportFileStream
      format " </TABLE>\n" to:LOCreportFileStream
    )

    format "\n" to:LOCreportFileStream

    for a = 1 to (numSplines FUNshape) do
    (
      format " <P><HR>% % (% %)<HR>\n" DYNuiResourcesLabels[192] (a as string) DYNuiResourcesLabels[358] (numKnots FUNshape a) to:LOCreportFileStream
      format " <TABLE cellSpacing=0 cellPadding=0 width=\"100%\">\n" "%" to:LOCreportFileStream
      format "  <TBODY>\n" to:LOCreportFileStream
      format "   <TR>\n" to:LOCreportFileStream
      format "    <TD id=3>%</TD>\n" DYNuiResourcesLabels[195] to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesReportColumns[1] to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesReportColumns[2] to:LOCreportFileStream
      format "    <TD id=2>%</TD>\n" DYNuiResourcesReportColumns[3] to:LOCreportFileStream
      format "   </TR>\n" to:LOCreportFileStream

      for i = 1 to (numKnots FUNshape a) do
      (
        local LOCknot = getKnotPoint FUNshape a i
        LOCknotArray = #(LOCknot.x, LOCknot.y, LOCknot.z)
        LOCknotArray[1] = DYNFUNformatDecPlaces LOCknotArray[1] 3 rootNode.DYNrootNodeStore.shiftX
        LOCknotArray[2] = DYNFUNformatDecPlaces LOCknotArray[2] 3 rootNode.DYNrootNodeStore.shiftY
        LOCknotArray[3] = DYNFUNformatDecPlaces LOCknotArray[3] 3 0

        format "   <TR>\n" to:LOCreportFileStream
        format "    <TD id=3>%</TD>\n" (i as string)   to:LOCreportFileStream
        format "    <TD id=2>%</TD>\n" LOCknotArray[1] to:LOCreportFileStream
        format "    <TD id=2>%</TD>\n" LOCknotArray[2] to:LOCreportFileStream
        format "    <TD id=2>%</TD>\n" LOCknotArray[3] to:LOCreportFileStream
        format "   </TR>\n" to:LOCreportFileStream
      )
      format "  </TBODY>\n" to:LOCreportFileStream
      format " </TABLE>\n" to:LOCreportFileStream
    )

    format " </td></tr>\n" to:LOCreportFileStream
    format " </TABLE>\n" to:LOCreportFileStream

    format "<HR>\n" to:LOCreportFileStream
    format "</CENTER>\n" to:LOCreportFileStream
    format "</BODY>\n" to:LOCreportFileStream

    format "\n" to:LOCreportFileStream
    format "</HTML>\n" to:LOCreportFileStream
    close LOCreportFileStream

    local ExeStr=("rollout DYNreport DYNuiResourcesTitlebars[58]\n")
    ExeStr+=("(\n")
    ExeStr+=("dotNetControl dnShell \"System.Windows.Forms.WebBrowser\" height:600 width:530 pos:[0,0]\n")
    ExeStr+=("on DYNreport open do\n")
    ExeStr+=("(\n")
    ExeStr+=("  dnShell.url = dotNetObject \"System.Uri\" \"" + LOCreportFile + "\"\n")
    ExeStr+=(")\n")
    ExeStr+=(")\n")
    local DYNreport = Execute ExeStr
    createDialog DYNreport width:530 height:600 modal:false
  )
  else
  (
    messageBox (DYNuiResourcesErrorsWarnings[102]) title:DYNuiResourcesTitlebars[1]
  )
)

-------------------------------------------------------------------------------------------------
--- Functions for Wheel Rotation on Vehicles ----------------------------------------------------
-------------------------------------------------------------------------------------------------

fn DYNFUNdetachPolyFacesByMatID FUNpoly FUNmatID FUNnameOfdetachedNode FUNdeleteFlag =
(
  local LOCdetachedPolyNode

  if classOf FUNpoly == Editable_Poly then
  (
    local LOCfaceBitArray = FUNpoly.faces as bitArray
    for i = 1 to LOCfaceBitArray.count do
    (
      if (polyOp.getFaceMatid FUNpoly i) != FUNmatID then LOCfaceBitArray[i] = false
    )
    local LOCsuccessSwitch = polyOp.detachFaces FUNpoly LOCfaceBitArray delete:FUNdeleteFlag asNode:true name:FUNnameOfdetachedNode

    if LOCsuccessSwitch then (LOCdetachedPolyNode = GetNodeByName FUNnameOfdetachedNode exact:true ignoreCase:false)
  )

  LOCdetachedPolyNode -- return value
)

fn DYNFUNdividePolyIntoNodesByElement FUNpoly FUNfeederNameOfdetachedNodes =
(
  local LOCoutputNodes = #()

  if classOf FUNpoly == Editable_Poly then
  (
    local LOCcnt = 0
    while FUNpoly.numFaces > 0 do
    (
      LOCcnt += 1
      local LOCfaceList = polyOp.getElementsUsingFace FUNpoly #{1}
      local LOCsuccessSwitch = polyOp.detachFaces FUNpoly LOCfaceList delete:true asNode:true name:(FUNfeederNameOfdetachedNodes + (LOCcnt as string))
      if LOCsuccessSwitch then
      (
        local LOCnewNode  = GetNodeByName (FUNfeederNameOfdetachedNodes + (LOCcnt as string)) exact:true ignoreCase:false
        if isValidNode LOCnewNode then append LOCoutputNodes LOCnewNode
      )
    )
    if FUNpoly.numFaces == 0 then delete FUNpoly
  )
  LOCoutputNodes
)

fn DYNFUNgetObjectMinExtentsInCoordSysLocal FUNobj =
(
  -- This function needed because .min and .max properties for polys has been found to be unreliable
  -- under certain conditions (see BrokenWheels.max in Civil View 2012 Dev Notes folder)
  -- Therefore, this function provides our own method to get the extents of a poly in the local coordsys
  -- of the object by comparing the XYZ coordinates of every vertex in the poly, and by looking only

  local LOCminXYZ
  local LOCnumVerts = FUNobj.numVerts

  in coordsys FUNobj
  (
    LOCminXYZ = polyOp.getVert FUNobj 1 -- Initialize result of this function

    for i = 2 to LOCnumVerts do
    (
      local LOCthisVert = polyOp.getVert FUNobj i
      if LOCthisVert.x < LOCminXYZ.x then LOCminXYZ.x = LOCthisVert.x
      if LOCthisVert.y < LOCminXYZ.y then LOCminXYZ.y = LOCthisVert.y
      if LOCthisVert.z < LOCminXYZ.z then LOCminXYZ.z = LOCthisVert.z
    )
  )

  LOCminXYZ -- return value
)

fn DYNFUNgetObjectMaxExtentsInCoordSysLocal FUNobj =
(
  -- This function needed because .min and .max properties for polys has been found to be unreliable
  -- under certain conditions (see BrokenWheels.max in Civil View 2012 Dev Notes folder)
  -- Therefore, this function provides our own method to get the extents of a poly in the local coordsys
  -- of the object by comparing the XYZ coordinates of every vertex in the poly, and by looking only

  local LOCmaxXYZ
  local LOCnumVerts = FUNobj.numVerts

  in coordsys FUNobj
  (
    LOCmaxXYZ = polyOp.getVert FUNobj 1 -- Initialize result of this function

    for i = 2 to LOCnumVerts do
    (
      local LOCthisVert = polyOp.getVert FUNobj i
      if LOCthisVert.x > LOCmaxXYZ.x then LOCmaxXYZ.x = LOCthisVert.x
      if LOCthisVert.y > LOCmaxXYZ.y then LOCmaxXYZ.y = LOCthisVert.y
      if LOCthisVert.z > LOCmaxXYZ.z then LOCmaxXYZ.z = LOCthisVert.z
    )
  )

  LOCmaxXYZ -- return value
)


fn DYNFUNmergeConcentricPolysByExtents FUNpolyArray =
(
  local LOCpolyOutArray = #()

  for i = 1 to FUNpolyArray.count do
  (
    for ii = 1 to FUNpolyArray.count do
    (
      if i != ii then
      (
        if isValidNode FUNpolyArray[i] and isValidNode FUNpolyArray[ii] then -- This section will be skipped if either poly node has already been attached and therefore deleted from scene
        (
          local LOCveh1Min = DYNFUNgetObjectMinExtentsInCoordSysLocal FUNpolyArray[i]
          local LOCveh1Max = DYNFUNgetObjectMaxExtentsInCoordSysLocal FUNpolyArray[i]
          local LOCveh2Min = DYNFUNgetObjectMinExtentsInCoordSysLocal FUNpolyArray[ii]
          local LOCveh2Max = DYNFUNgetObjectMaxExtentsInCoordSysLocal FUNpolyArray[ii]

          local LOCyArray = #(LOCveh1Min.y, LOCveh1Max.y); sort LOCyArray
          local LOCzArray = #(LOCveh1Min.z, LOCveh1Max.z); sort LOCzArray

          local LOCveh2Mid = ((LOCveh2Max - LOCveh2Min) / 2.0) + LOCveh2Min

          if LOCveh2Mid.z > LOCzArray[1] and LOCveh2Mid.z < LOCzArray[2] and LOCveh2Mid.y > LOCyArray[1] and LOCveh2Mid.y < LOCyArray[2] then
          (
            polyOp.attach FUNpolyArray[i] FUNpolyArray[ii] -- The source node <FUNpolyArray[ii]> is deleted after the attach is performed.
          )
        )
      )
    )
  )
  for i in FUNpolyArray do
  (
    if isValidNode i then append LOCpolyOutArray i
  )

  LOCpolyOutArray
)

fn DYNFUNapplyWheelrotationScriptController FUNobject =
(
  --- Create and Apply Rotation Controller
  local LOCrotCtrl  = rotation_script()
  custAttributes.add LOCrotCtrl DYNwheelRotationControllerAttributes -- Add Custom Attribute Definition To Axle#

  --- Apply Rotation Controller (and custAtt definition) to Current Axle
  FUNobject.rotation.controller = LOCrotCtrl

  --- Set Constant Values
  LOCrotCtrl.AddConstant "WheelDiameter" (FUNobject.max.z - FUNobject.min.z)
  LOCrotCtrl.addTarget   "ParentXForm"   (FUNobject.parent.transform.controller)

  LOCrotCtrl.setExpression ("LOCpositionA=this.LastPosition; LOCpositionB=ParentXForm.position; this.LastDistance += (distance LOCpositionA LOCpositionB) * (360 / (pi * WheelDiameter)) * (dot ParentXForm.row2 (normalize (LOCpositionB-LOCpositionA))); this.LastPosition = LOCpositionB; EulerAngles -this.LastDistance 0 0")

  LOCrotCtrl -- return value
)

fn DYNFUNdetachWheelsFromVehiclePolyAndRotate FUNobject FUNmatIDwheels FUNmatIDtyres =
(
  local LOCaxleArray       = #()

  if classOf FUNobject == Editable_Poly then
  (
    local LOCinstances = #()
    instanceMgr.getInstances FUNobject &LOCinstances

    --- Detach All Wheel and Tyre Geometry from Donor Vehicle Poly
    local LOCrandomNoString  = (random 10001 99999) as string
    local LOCuniqueTyreName  = FUNobject.name + "_DetachedTyres" + LOCrandomNoString
    local LOCuniqueWheelName = FUNobject.name + "_DetachedWheels" + LOCrandomNoString
    local LOCtyresNode       = DYNFUNdetachPolyFacesByMatID FUNobject FUNmatIDtyres  LOCuniqueTyreName  true
    local LOCwheelsNode      = DYNFUNdetachPolyFacesByMatID FUNobject FUNmatIDwheels LOCuniqueWheelName true

    --- Divide TyreNode and Wheels Node into Separate Objects By Poly Element
    local LOCtyreNodeArray   = DYNFUNdividePolyIntoNodesByElement LOCtyresNode  LOCuniqueTyreName
    local LOCwheelNodeArray  = DYNFUNdividePolyIntoNodesByElement LOCwheelsNode LOCuniqueWheelName

    --- Merge Tyre Nodes Which Are Entirely Within The Extents of Other Tyre Nodes on Z/Y axis
    LOCtyreNodeArray         = DYNFUNmergeConcentricPolysByExtents LOCtyreNodeArray

    --- Merge Wheel Nodes Which Are Entirely Within The Extents of Other Wheel Nodes on Z/Y axis
    LOCwheelNodeArray        = DYNFUNmergeConcentricPolysByExtents LOCwheelNodeArray

    --- Merge All Remaining Nodes Which Are Entirely Within The Extents of Other Wheel and Tyre Nodes on Z/Y axis
    LOCaxleArray             = DYNFUNmergeConcentricPolysByExtents (LOCtyreNodeArray + LOCwheelNodeArray)

    --- Instance Axles to Other Instances of This Vehicle
    for i = 1 to LOCinstances.count do
    (
      local LOCobject = LOCinstances[i]
      if LOCobject != FUNobject then
      (
        local LOCcnt = 1
        for ii in LOCaxleArray do
        (
          local LOCaxleCopy     = instance ii
          LOCaxleCopy.transform = LOCobject.transform.controller.value

          LOCaxleCopy.pivot     = LOCaxleCopy.center
          LOCaxleCopy.name      = LOCobject.name + "_" + DYNuiResourcesNodeNames[35] + "_" + (LOCcnt as string)
          LOCaxleCopy.parent    = LOCobject

          --- Apply Rotation Controller (and custAtt definition) to Current Axle
          DYNFUNapplyWheelrotationScriptController LOCaxleCopy

          --- ByLayer Settings
          DYNFUNapplyByLayerSettings #(LOCaxleCopy)

          --- Increase Axle Count
          LOCcnt += 1
        )
      )
    )

    --- Process Remaining Requirements for Each Master Axle
    for i = 1 to LOCaxleArray.count do
    (
      local LOCaxle     = LOCaxleArray[i]
      LOCaxle.pivot     = LOCaxle.center
      LOCaxle.name      = FUNobject.name + "_" + DYNuiResourcesNodeNames[35] + "_" + (i as string)
      LOCaxle.parent    = FUNobject

      --- Apply Rotation Controller (and custAtt definition) to Current Axle
      DYNFUNapplyWheelrotationScriptController LOCaxle

      --- ByLayer Settings
      DYNFUNapplyByLayerSettings #(LOCaxle)
    )
  )
  LOCaxleArray -- return value
)

-------------------------------------------------------------------------------------------------
--- Functions for opening floating dialog panels ------------------------------------------------
-------------------------------------------------------------------------------------------------

--- Function to open Imported Object Manager panel (including recall of last used panel position)
fn DYNFUNopenImportManDialog =
(
  if DYNimportMan == undefined then fileIn (DYNscriptsPath + "ImportMan.ms")
  local LOCuseCoords = true
  if DYNimpLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNimpLUP.y or systemTools.GetScreenWidth() < DYNimpLUP.x then LOCuseCoords = false)

  if LOCuseCoords       then
  (
    createDialog DYNimportMan pos:DYNimpLUP \
 width:DYNdefRLsizeIMP.x height:DYNdefRLsizeIMP.y menu:(DYNimportMan.DYNFUNbuildMenuImportMan()) \
      style:#(#style_minimizebox, #style_maximizebox, #style_resizing, #style_titlebar, #style_border, #style_sysmenu) \
  )
  else
  (
    createDialog DYNimportMan \
 width:DYNdefRLsizeIMP.x height:DYNdefRLsizeIMP.y menu:(DYNimportMan.DYNFUNbuildMenuImportMan()) \
      style:#(#style_minimizebox, #style_maximizebox, #style_resizing, #style_titlebar, #style_border, #style_sysmenu) \
  )
)

--- Function to open Placed Object Manager panel (including recall of last used panel position)
fn DYNFUNopenPlacedManDialog =
(
  if DYNplacedMan == undefined then fileIn (DYNscriptsPath + "PlacedMan.ms")

  local LOCuseCoords = true
  if DYNplaLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNplaLUP.y or systemTools.GetScreenWidth() < DYNplaLUP.x then LOCuseCoords = false)

  if LOCuseCoords       then
  (
    createDialog DYNplacedMan pos:DYNplaLUP \
 width:DYNdefRLsizePLA.x height:DYNdefRLsizePLA.y menu:(DYNplacedMan.DYNFUNbuildMenuPlacedMan()) \
      style:#(#style_minimizebox, #style_maximizebox, #style_resizing, #style_titlebar, #style_border, #style_sysmenu) \
  )
  else
  (
    createDialog DYNplacedMan \
 width:DYNdefRLsizePLA.x height:DYNdefRLsizePLA.y menu:(DYNplacedMan.DYNFUNbuildMenuPlacedMan()) \
      style:#(#style_minimizebox, #style_maximizebox, #style_resizing, #style_titlebar, #style_border, #style_sysmenu) \
  )
)

--- Function to open Resource Kit Manager Panel -- to replace current item in DYNfunctions.ms
fn DYNFUNopenResourceManager FUNcat FUNselectedINIfile =
(
  if DYNresourceMan == undefined then fileIn (DYNscriptsPath + "ResourceMan.ms")

  local LOCuseCoords = true
  if DYNresLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNresLUP.y or systemTools.GetScreenWidth() < DYNresLUP.x then LOCuseCoords = false)

  if LOCuseCoords       then
  (
    createDialog DYNresourceMan width:939 height:650 modal:false pos:DYNresLUP
  )
  else
  (
    createDialog DYNresourceMan width:939 height:650 modal:false
  )

  DYNresourceMan.DYNFUNopenPanel FUNcat FUNselectedINIfile
)

--- Function which opens DVSP Explorer Panel
fn DYNFUNopenExplorer =
(
  --- Load Required Rollout Files On Demand
  if not DYNexplorerLoaded then
  (
    --- CSP Rollouts: Load with Civil View Explorer First Use
    fileIn (DYNscriptsPath + "SkyDome.ms")
    fileIn (DYNscriptsPath + "MrPhysicalSky.ms")
    fileIn (DYNscriptsPath + "WorldStatistics.ms")
    fileIn (DYNscriptsPath + "MrFinalGather.ms")
    fileIn (DYNscriptsPath + "PathObjectList.ms")
    fileIn (DYNscriptsPath + "LightList.ms")
    fileIn (DYNscriptsPath + "MrSkyLight.ms")
    fileIn (DYNscriptsPath + "MrSunLight.ms")
    fileIn (DYNscriptsPath + "SunLight.ms")
    fileIn (DYNscriptsPath + "StdLight.ms")
    fileIn (DYNscriptsPath + "ResourceList.ms")
    fileIn (DYNscriptsPath + "Atmosphere.ms")
    fileIn (DYNscriptsPath + "Exposure.ms")
    fileIn (DYNscriptsPath + "ForestParams.ms")
    fileIn (DYNscriptsPath + "UserInterface.ms")
    fileIn (DYNscriptsPath + "PositionControl.ms")
    fileIn (DYNscriptsPath + "AttachParams.ms")
    fileIn (DYNscriptsPath + "CamParams.ms")
    fileIn (DYNscriptsPath + "GRailParams.ms")
    fileIn (DYNscriptsPath + "BuildingParams.ms")
    fileIn (DYNscriptsPath + "AlignmentParams.ms")
    fileIn (DYNscriptsPath + "ShapeParams.ms")
    fileIn (DYNscriptsPath + "SurfaceParams.ms")
    fileIn (DYNscriptsPath + "SignParams.ms")
    fileIn (DYNscriptsPath + "SignalParams.ms")
    fileIn (DYNscriptsPath + "VehicleParams.ms")
    fileIn (DYNscriptsPath + "MarkingParams.ms")
    fileIn (DYNscriptsPath + "GantryParams.ms")
    fileIn (DYNscriptsPath + "LampParams.ms")
    fileIn (DYNscriptsPath + "pSystemParams.ms")
    fileIn (DYNscriptsPath + "pNetworkParams.ms")
    fileIn (DYNscriptsPath + "PrimitiveParams.ms")
    fileIn (DYNscriptsPath + "TreeParams.ms")
    fileIn (DYNscriptsPath + "MatEditor.ms")

    DYNexplorerLoaded = true
  )

  --- Display Rollout Floater
  local LOCscrHeight = systemTools.GetScreenHeight()
  local LOCfltHeight = 870
  local LOCwidth     = if classOf DYNINIexplorerWidth != integer then 208 else (if DYNINIexplorerWidth < 208 then 208 else DYNINIexplorerWidth)
  LOCfltHeight = if LOCscrHeight < LOCfltHeight then (LOCscrHeight - 50) else (LOCscrHeight - 200)

  local LOCuseCoords = true
  if DYNexpLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNexpLUP.y or systemTools.GetScreenWidth() < DYNexpLUP.x then LOCuseCoords = false)

  DYNmainFloater = newRolloutFloater (DYNcivilViewProductName) (LOCwidth as integer) LOCfltHeight (LOCscrHeight - 10) 10
  if LOCuseCoords then DYNmainFloater.pos = DYNexpLUP
  addrollout dynamite DYNmainFloater rolledup:false
  DYNFUNdockExplorer LOCwidth
)

fn DYNFUNopenPropertiesPanel =
(
  local LOCuseCoords = true
  if DYNprpLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNprpLUP.y or systemTools.GetScreenWidth() < DYNprpLUP.x then LOCuseCoords = false)

  if selection[1] != undefined and (getAppData selection[1] 421) == "Dynamite" then
  (
    DYNobjectSwitch = (getAppData selection[1] 422) as integer
  )
  else DYNobjectSwitch = 1

  if LOCuseCoords       then
  (
    createDialog DYNproperties width:515 height:314 modal:false pos:DYNprpLUP
  )
  else
  (
    createDialog DYNproperties width:515 height:314 modal:false
  )
)

fn DYNFUNopenSightToolPanel    =
(
  if DYNsightTool == undefined then fileIn (DYNscriptsPath + "SightTool.ms")
  createDialog DYNsightTool width:373 height:725 modal:false
)

fn DYNFUNopenChainageTextTool  =
(
  if DYNchainageText == undefined then fileIn (DYNscriptsPath + "ChainageText.ms")
  createDialog DYNchainageText width:645 height:370 modal:false
)

fn DYNFUNopenpointBasedPlaceTool =
(
  if DYNpointBasedPlace == undefined then fileIn (DYNscriptsPath + "PointBasedPlace.ms")
  createDialog DYNpointBasedPlace width:330 height:445 modal:false
)

fn DYNFUNopenDrapeSplineTool =
(
  if DYNdrapeSpline == undefined then fileIn (DYNscriptsPath + "DrapeSpline.ms")
  createDialog DYNdrapeSpline width:280 height:400 modal:false
)

fn DYNFUNopenSplineMapperTool =
(
  if DYNsplineMapper == undefined then fileIn (DYNscriptsPath + "SplineMapper.ms")
  createDialog DYNsplineMapper width:280 height:600 modal:false
  DYNsplineMapper.DYNFUNinitialiseSplineMapper undefined false
)

fn DYNFUNopengRailObjectsPanel =
(
  local LOCuseCoords = true
  if DYNrosLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNrosLUP.y or systemTools.GetScreenWidth() < DYNrosLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNgRailObjects width:DYNdefRLsizeROS.x height:DYNdefRLsizeROS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu) pos:DYNrosLUP

  )
  else
  (
    createDialog DYNgRailObjects width:DYNdefRLsizeROS.x height:DYNdefRLsizeROS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
)

fn DYNFUNopenRoadMarkingsPanel =
(
  local LOCuseCoords = true
  if DYNrmsLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNrmsLUP.y or systemTools.GetScreenWidth() < DYNrmsLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNroadMarkings width:DYNdefRLsizeRMS.x height:DYNdefRLsizeRMS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu) pos:DYNrmsLUP
  )
  else
  (
    createDialog DYNroadMarkings width:DYNdefRLsizeRMS.x height:DYNdefRLsizeRMS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
)

fn DYNFUNopenSweptObjectsPanel =
(
  local LOCuseCoords = true
  if DYNsosLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNsosLUP.y or systemTools.GetScreenWidth() < DYNsosLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNsweptObjects width:DYNdefRLsizeSOS.x height:DYNdefRLsizeSOS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu) pos:DYNsosLUP
  )
  else
  (
    createDialog DYNsweptObjects width:DYNdefRLsizeSOS.x height:DYNdefRLsizeSOS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu) pos:DYNsosLUP
  )
)

fn DYNFUNopenBuildingObjectsPanel =
(
  local LOCuseCoords = true
  if DYNbosLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNbosLUP.y or systemTools.GetScreenWidth() < DYNbosLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNbuildingObjects width:DYNdefRLsizeBOS.x height:DYNdefRLsizeBOS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu) pos:DYNbosLUP
  )
  else
  (
    createDialog DYNbuildingObjects width:DYNdefRLsizeBOS.x height:DYNdefRLsizeBOS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
)

fn DYNFUNopenFeatureInterpPanel =
(
  local LOCuseCoords = true
  if DYNfisLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNfisLUP.y or systemTools.GetScreenWidth() < DYNfisLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNfeatureInterp width:DYNdefRLsizeFIS.x height:DYNdefRLsizeFIS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu) pos:DYNfisLUP
  )
  else
  (
    createDialog DYNfeatureInterp width:DYNdefRLsizeFIS.x height:DYNdefRLsizeFIS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
)

fn DYNFUNopenObjectPlacerPanel =
(
  local LOCuseCoords = true
  if DYNopsLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNopsLUP.y or systemTools.GetScreenWidth() < DYNopsLUP.x then LOCuseCoords = false)
  if LOCuseCoords then
  (
    createDialog DYNobjectPlacer width:DYNdefRLsizeOPS.x height:DYNdefRLsizeOPS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu) pos:DYNopsLUP
  )
  else
  (
    createDialog DYNobjectPlacer width:DYNdefRLsizeOPS.x height:DYNdefRLsizeOPS.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
)

fn DYNFUNopenDxfImportPanel =
(
  destroyDialog DYNproperties

  if DYNdxfImport == undefined then fileIn (DYNscriptsPath + "DxfImport.ms")

  local LOCuseCoords = true
  if DYNdxfLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNdxfLUP.y or systemTools.GetScreenWidth() < DYNdxfLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNdxfImport width:587 height:539 modal:false pos:DYNdxfLUP
  )
  else
  (
    createDialog DYNdxfImport width:587 height:539 modal:false
  )
)

fn DYNFUNopenCveImportPanel FUNmode =
(
  local LOCcveLUP = [0,0]
  local LOCdefRLsizeCVE = [995,497]
  /*
    FUNmode = 1 : Genio File Format
    FUNmode = 2 : MX Model File Format
    FUNmode = 3 : 12D Ascii File Format
  */
  DYNcveImportMode = FUNmode
  if DYNcveImportMode == 1 then (LOCcveLUP = DYNgenLUP; LOCdefRLsizeCVE = DYNdefRLsizeGEN)
  if DYNcveImportMode == 2 then (LOCcveLUP = DYNmxfLUP; LOCdefRLsizeCVE = DYNdefRLsizeMXM)
  if DYNcveImportMode == 3 then (LOCcveLUP = DYN12dLUP; LOCdefRLsizeCVE = DYNdefRLsize12D)
  if DYNcveImportMode == 4 then (LOCcveLUP = DYNxmlLUP; LOCdefRLsizeCVE = DYNdefRLsizeXML)

  DYNdefRLsizeCVE = LOCdefRLsizeCVE

  destroyDialog DYNproperties

  if DYNcveImport == undefined then fileIn (DYNscriptsPath + "CveImport.ms")

  local LOCuseCoords = true
  if LOCcveLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < LOCcveLUP.y or systemTools.GetScreenWidth() < LOCcveLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNcveImport width:LOCdefRLsizeCVE.x height:LOCdefRLsizeCVE.y modal:false pos:LOCcveLUP style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
  else
  (
    createDialog DYNcveImport width:LOCdefRLsizeCVE.x height:LOCdefRLsizeCVE.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
)

fn DYNFUNopenC3dImportPanel =
(
  destroyDialog DYNproperties

  if DYNc3dImport == undefined then fileIn (DYNscriptsPath + "C3dImport.ms")

  LOCuseCoords = true
  if DYNc3dLUP == [0,0] then (LOCuseCoords = false)
  if LOCuseCoords       then (if systemTools.GetScreenHeight() < DYNc3dLUP.y or systemTools.GetScreenWidth() < DYNc3dLUP.x then LOCuseCoords = false)
  if LOCuseCoords       then
  (
    createDialog DYNc3dImport width:DYNdefRLsizeC3D.x height:DYNdefRLsizeC3D.y modal:false pos:DYNc3dLUP style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
  else
  (
    createDialog DYNc3dImport width:DYNdefRLsizeC3D.x height:DYNdefRLsizeC3D.y modal:false style:#(#style_resizing, #style_titlebar, #style_sysmenu)
  )
)

fn DYNFUNopenDsimImportPanel =
(
  if DYNdotNetDSIM == undefined then
  (
    DYNdotNetDSIM               = dotNet.loadAssembly (DYNbinPath + "3am.DSim.dll")
    dnImportClass               = dotNetClass "ThreeAm.DSim.Import"
    dnImportObject              = dotNetObject dnImportClass
  )
  if DYNdsimImport == undefined then fileIn (DYNscriptsPath + "dsimImport.ms")

  createDialog DYNdsimImport width:645 height:489 modal:false
)

fn DYNFUNopenDsimSurfacePanel =
(
  if DYNdsimSurface == undefined then fileIn (DYNscriptsPath + "dsimSurface.ms")
  createDialog DYNdsimSurface width:530 height:730 modal:false
)

fn DYNFUNopenDsimSubstitutePanel =
(
  if DYNdsimSubstitute == undefined then fileIn (DYNscriptsPath + "dsimSubstitute.ms")
  createDialog DYNdsimSubstitute width:786 height:546 modal:false
)

fn DYNFUNopenQparImportPanel =
(
  if DYNqparImport == undefined then fileIn (DYNscriptsPath + "qParImport.ms")
  createDialog DYNqparImport width:845 height:505 modal:false
)


fn DYNFUNgetOpenFileName FUNfileType FUNfileSeedName FUNresourceKitMode FUNresourceKitLock =
(
  if DYNfileSelector == undefined then fileIn (DYNscriptsPath + "FileSelector.ms")
  DYNfileSelectorFileName = FilenameFromPath FUNfileSeedName
  DYNfileSelectorFileType = FUNfileType
  DYNfileSelectorSaveMode = false
  DYNfileSelectorKitMode  = FUNresourceKitMode
  DYNfileSelectorKitLock  = FUNresourceKitLock
  createDialog DYNfileSelector width:DYNdefRLsizeFSE.x height:DYNdefRLsizeFSE.y style:#(#style_resizing, #style_titlebar, #style_border, #style_sysmenu) modal:true
  DYNfileSelector.LOCcurrentFile -- return value
)

fn DYNFUNgetSaveFileName FUNfileType FUNfileSeedName FUNresourceKitMode FUNresourceKitLock =
(
  if DYNfileSelector == undefined then fileIn (DYNscriptsPath + "FileSelector.ms")
  DYNfileSelectorFileName = FilenameFromPath FUNfileSeedName
  DYNfileSelectorFileType = FUNfileType
  DYNfileSelectorSaveMode = true
  DYNfileSelectorKitMode  = FUNresourceKitMode
  DYNfileSelectorKitLock  = FUNresourceKitLock
  createDialog DYNfileSelector width:DYNdefRLsizeFSE.x height:DYNdefRLsizeFSE.y style:#(#style_resizing, #style_titlebar, #style_border, #style_sysmenu) modal:true
  DYNfileSelector.LOCcurrentFile -- return value
)
fn DYNFUNreadBinString FUNfileStream =
(
  fseek FUNfileStream 4 #seek_cur                                  -- required before reading a string
  readString FUNfileStream                                         -- return value
)

fn DYNFUNreadElemInfoMxSource FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCfileName    = DYNFUNreadBinString FUNfileStream         --
  local LOCfilePath    = DYNFUNreadBinString FUNfileStream         --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set                        --

  #(LOCfileName, LOCfilePath)                                      -- Return Value
)

fn DYNFUNreadElemInfoXmlSource FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  /*
  string FileName (the name of the source LandXML file, including the filename extension)
  string FilePath (the path of the source LandXML file)
  string ProjectName (derived from the Project element in LandXML)
  string ProjectDescription (derived from the Project element in LandXML)
  string ApplicationName (derived from the Application element in LandXML)
  string ApplicationManufacturer (derived from the Application element in LandXML)
  string ApplicationVersion (derived from the Application element in LandXML)
  int LinearUnit (derived from the Units element in LandXML)
  */

  local LOCfileName    = DYNFUNreadBinString FUNfileStream
  local LOCfilePath    = DYNFUNreadBinString FUNfileStream
  local LOCprojectName = DYNFUNreadBinString FUNfileStream
  local LOCprojectDesc = DYNFUNreadBinString FUNfileStream
  local LOCappName     = DYNFUNreadBinString FUNfileStream
  local LOCappManufact = DYNFUNreadBinString FUNfileStream
  local LOCappVersion  = DYNFUNreadBinString FUNfileStream
  local LOClinearUnit  = readLong FUNfileStream

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCfileName, LOCfilePath, LOCprojectName, LOCprojectDesc, LOCappName, LOCappManufact, LOCappVersion, LOClinearUnit)  -- Return Value
)

fn DYNFUNreadElemInfoCivil3DSource FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCdwgName    = DYNFUNreadBinString FUNfileStream          --
  local LOCdwgPath    = DYNFUNreadBinString FUNfileStream          --
  local LOCdwgVersion = DYNFUNreadBinString FUNfileStream          --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set                        --

  #(LOCdwgName, LOCdwgPath, LOCdwgVersion)                         -- Return Value
)

fn DYNFUNreadElemInfoSceneShift FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCshiftX = readLong FUNfileStream                         --
  local LOCshiftY = readLong FUNfileStream                         --
  local LOCshiftZ = readLong FUNfileStream                         --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCshiftX, LOCshiftY, LOCshiftZ)                               -- Return Value
)

fn DYNFUNreadElementHeader FUNfileStream =
(
  local LOCelemType       = DYNFUNreadBinString FUNfileStream      --
  local LOCdataVersion    = readLong FUNfileStream                 --
  local LOCfileOffset     = readLong FUNfileStream                 --
  local LOCnumSubElements = readLong FUNfileStream                 --
  local LOCfileStop       = ftell FUNfileStream                    --

  #(LOCelemType, \
    LOCdataVersion, \
    LOCfileOffset, \
    LOCnumSubElements, \
    LOCfileStop \
  )
)

fn DYNFUNreadElemShape FUNfileStream FUNfileOffset FUNfileStop =
(
  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCshapeName = DYNFUNreadBinString FUNfileStream           --
  local LOCsplines   = readLong FUNfileStream                      --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCshapeName, LOCsplines)                                      -- Return Value
)

fn DYNFUNreadElemCivil3DPointGroup FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  Civil3DPointGroup
  --------------------------------------------------------------------
  string Name
  string Handle
  string Description
  int numPoints
  [points]

  - where [points] is [point records (n) times]
  The repeated point records consist of:
  --------------------------------------------------------------------
    Int PointNumber
    Float X
    Float Y
    Float Z
    Float Rotation
    String Name
    String RawDescription
  --------------------------------------------------------------------
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCpgName              = DYNFUNreadBinString FUNfileStream -- Point Group Name
  local LOCpgHandle            = DYNFUNreadBinString FUNfileStream -- Point Group Name
  local LOCpgDescription       = DYNFUNreadBinString FUNfileStream -- Point Group Description
  local LOCpgNumPoints         = readLong FUNfileStream            -- Number of Points in Point Group

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCpgName, LOCpgHandle, LOCpgDescription, LOCpgNumPoints)                   -- return value
)


fn DYNFUNreadElemTriangleMesh FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TriangleMesh
  ------------
  string name
  int vertexCount
  int faceCount
  int textureVertexCount
  int textureFaceCount
  [verts]
  [faces]
  [tVerts]
  [tFaces]

  Where [verts] is:
    double X
    double Y
    double Z
    ...repeated...

  and [faces] is:
    int indexA
    int indexB
    int indexC
    int materialId
    ...repeated...
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname      = DYNFUNreadBinString FUNfileStream           -- The name of the mesh (derived from the surface object name in C3D)
  local LOCpoints    = readLong FUNfileStream                      -- number of vertices in surface
  local LOCfaces     = readLong FUNfileStream                      -- number of faces in surface
  local LOCtVerts    = readLong FUNfileStream                      -- number of texture vertices in surface
  local LOCtFaces    = readLong FUNfileStream                      -- number of texture faces in surface

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname, LOCpoints, LOCfaces, LOCtVerts, LOCtFaces)            -- Return Value
)

fn DYNFUNreadTagCivil3DSurface FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DSurface
  -----------------
  string handle;
  string description;
  string layerName;
  string materialName;
  int materialId;
  double mappingURepeat;
  double mappingVRepeat;
  int pointCount;
  int faceCount;

  - material ID will be 0 if no matID was set. This field is not actually used
  to build geometry because we have per-face MatID information in the TriangleMesh
  object type. This field is only used for generating AppData.

  - UVrepeat will be xx,xx if no per-surface UV mapping was applied.
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOChandle    = DYNFUNreadBinString FUNfileStream           -- object handle
  local LOCdesc      = DYNFUNreadBinString FUNfileStream           -- object description
  local LOClayer     = DYNFUNreadBinString FUNfileStream           -- object layer
  local LOCmaterial  = DYNFUNreadBinString FUNfileStream           -- object material
  local LOCmatID     = readLong  FUNfileStream                     -- material ID
  local LOCu         = readFloat FUNfileStream                     -- u-repeat (float)
  local LOCv         = readFloat FUNfileStream                     -- v-repeat (float)
  local LOCorigVerts = readLong  FUNfileStream                     -- number of original vertices in surface prior to optimisation
  local LOCorigFaces = readLong  FUNfileStream                     -- number of original faces in surface prior to optimisation

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOChandle, \
    LOCdesc, \
    LOClayer, \
    LOCmaterial, \
    LOCmatID, \
    LOCu, \
    LOCv, \
    LOCorigVerts, \
    LOCorigFaces \
  )
)

fn DYNFUNreadTagCivil3DCorridorFeatureLine FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DCorridorFeatureLine
  -----------------------------
  int knotCount
  string pointCode
  int baseLineType
  int baseLineIndex
  int offsetBaseLineIndex
  int regionIndex
  string assemblyName
  string corridorHandle
  string corridorName
  string layerName
  private string userLinkCode
  string spare
  double regionStartStation
  double regionEndStation

  - the baseLineType is 0 or 1 for baseLine or offsetBaseLine.
  - the offsetBaseLineIndex is -1 if baseLineType is 0
  - there is one TagCivil3DCorridorFeatureLine for each shape
    that represents a featurelines shape
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCknotCount           = readLong FUNfileStream            --
  local LOCpointCode           = DYNFUNreadBinString FUNfileStream -- C3D Point Code (used to construct shape name)
  local LOCbaseLineType        = readLong FUNfileStream            -- Baseline Type (0=Baseline; 1=OffsetBaseline)
  local LOCbaseLineIndex       = readLong FUNfileStream            -- Baseline Index
  local LOCoffsetbaseLineIndex = readLong FUNfileStream            -- OffsetBaseline Index (is -1 if baseLineType is 0)
  local LOCregionIndex         = readLong FUNfileStream            -- The Index of the Region that this featureline belongs to.
  local LOCassemblyName        = DYNFUNreadBinString FUNfileStream --
  local LOCcorridorHandle      = DYNFUNreadBinString FUNfileStream --
  local LOCcorridorName        = DYNFUNreadBinString FUNfileStream --
  local LOClayerName           = DYNFUNreadBinString FUNfileStream --
  local LOCuserLinkCode        = DYNFUNreadBinString FUNfileStream --
  local LOCspare               = DYNFUNreadBinString FUNfileStream --
  local LOCregionStartStation  = readFloat FUNfileStream           --
  local LOCregionEndStation    = readFloat FUNfileStream           --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCknotCount, \
    LOCpointCode, \
    LOCbaseLineType, \
    LOCbaseLineIndex, \
    LOCoffsetbaseLineIndex, \
    LOCregionIndex, \
    LOCassemblyName, \
    LOCcorridorHandle, \
    LOCcorridorName, \
    LOClayerName, \
    LOCuserLinkCode, \
    LOCspare, \
    LOCregionStartStation, \
    LOCregionEndStation \
  )
)



fn DYNFUNreadTagCivil3DCorridorBaseLine FUNfileStream FUNfileOffset FUNfileStop =
(
    /*
    TagCivil3DCorridorBaseLine
    --------------------------
    int knotCount
    int baseLineType;
    int baseLineIndex;
    int offsetBaseLineIndex;
    int RegionId;
    int uniqueId;
    string name; (not used - see below)
    string description; (not used - see below)
    string alignmentName;
    string profileName;
    string corridorHandle;
    string corridorName;
    string layerName;
    string userTopCode;
    string spare;
    int regionCount;
    double startStation;
    double endStation;

    - the baseLineType is 0 or 1 for baseLine or offsetBaseLine.
    - the offsetBaseLineIndex is -1 if baseLineType is 0
    - the regionIndex is -1 if baseLineType is 0
    - uniqueID was "our" uniqueness value for each item that is a baseline
      of any kind (base, baseBase, offset). However, this was no longer possible
      to generate from DEX5 onwards (C3D 2013), so at that stage it was dropped from
      the file spec and hard-coded to zero. Up to this point, this value had
      not been utilized in Civil View.
    - the name and description is empty for baseLines because it's not in the COM or .NET API
    - the region count is the total region count but of course the
      region count will be 0 if baseLineType is 1 because offset
      baselines do not have regions.
    - there is one TagCivil3DCorridorBaseLine for each shape that
      represents a baseLine or offsetBaseLine. The hardcodedOffsetBaseLine
      will not carry this because we still don't know what to to with
      those because we have NO samples showing this offsetBaseLine type
    - there are one or more TagCivil3DCorridorRegion's for each
      TagCivil3DCorridorBaseLine (indicated by regionCount) as child
      elements.
    - ProfileName was populated from DVSP V4 onwards. Could be an empty string if alignment does not have a profile.
    */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCknotCount           = readLong FUNfileStream            --
  local LOCbaseLineType        = readLong FUNfileStream            -- Baseline Type (0=Baseline; 1=OffsetBaseline)
  local LOCbaseLineIndex       = readLong FUNfileStream            -- Baseline Index
  local LOCoffsetbaseLineIndex = readLong FUNfileStream            -- OffsetBaseline Index (is -1 if baseLineType is 0)
  local LOCregionID            = readLong FUNfileStream            --
  local LOCuniqueID            = readLong FUNfileStream            --
  local LOCbaseLineName        = DYNFUNreadBinString FUNfileStream --
  local LOCbaseLineDesc        = DYNFUNreadBinString FUNfileStream --
  local LOCalignmentName       = DYNFUNreadBinString FUNfileStream --
  local LOCprofileName         = DYNFUNreadBinString FUNfileStream --
  local LOCcorridorHandle      = DYNFUNreadBinString FUNfileStream --
  local LOCcorridorName        = DYNFUNreadBinString FUNfileStream --
  local LOClayerName           = DYNFUNreadBinString FUNfileStream --
  local LOCuserLinkCode        = DYNFUNreadBinString FUNfileStream --
  local LOCspare               = DYNFUNreadBinString FUNfileStream --
  local LOCregionCount         = readLong  FUNfileStream           --
  local LOCstartStation        = readFloat FUNfileStream           --
  local LOCendStation          = readFloat FUNfileStream           --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCknotCount, \
    LOCbaseLineType, \
    LOCbaseLineIndex, \
    LOCoffsetbaseLineIndex, \
    LOCregionID, \
    LOCuniqueID, \
    LOCbaseLineName, \
    LOCbaseLineDesc, \
    LOCalignmentName, \
    LOCprofileName, \
    LOCcorridorHandle, \
    LOCcorridorName, \
    LOClayerName, \
    LOCuserLinkCode, \
    LOCspare, \
    LOCregionCount, \
    LOCstartStation, \
    LOCendStation \
  )
)

fn DYNFUNreadContainerCivil3DSite FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  ContainerCivil3DSite
  --------------------
  string siteHandle
  string siteDesc
  string siteLayer
  string siteName
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCsiteHandle = DYNFUNreadBinString FUNfileStream
  local LOCsiteDesc   = DYNFUNreadBinString FUNfileStream
  local LOCsiteLayer  = DYNFUNreadBinString FUNfileStream
  local LOCsiteName   = DYNFUNreadBinString FUNfileStream

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCsiteHandle, LOCsiteDesc, LOCsiteLayer, LOCsiteName)
)

fn DYNFUNreadTagCivil3DLandFeatureLine FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DLandFeatureLine
  -------------------------
  String Handle
  String description
  String layerName
  String name
  String siteName
  String siteHandle
  int elevationPointCount
  int piPointCount
  double length2D
  double length3D
  double maximumElevation
  double minimumElevation
  double maximumGrade
  double minimumGrade
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCfLineHandle     = DYNFUNreadBinString FUNfileStream
  local LOCfLineDesc       = DYNFUNreadBinString FUNfileStream
  local LOCfLineLayer      = DYNFUNreadBinString FUNfileStream
  local LOCfLineName       = DYNFUNreadBinString FUNfileStream       -- if LOCfLineName == "" then LOCfLineName = "{undefined}"
  local LOCfLineSiteName   = DYNFUNreadBinString FUNfileStream
  local LOCfLineSiteHandle = DYNFUNreadBinString FUNfileStream
  local LOCelevPointCount  = readLong FUNfileStream
  local LOCpiPointCount    = readLong FUNfileStream
  local LOClength2D        = readFloat FUNfileStream
  local LOClength3D        = readFloat FUNfileStream
  local LOCmaxElevation    = readFloat FUNfileStream
  local LOCminElevation    = readFloat FUNfileStream
  local LOCmaxGrade        = readFloat FUNfileStream
  local LOCminGrade        = readFloat FUNfileStream

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCfLineHandle, \
    LOCfLineDesc, \
    LOCfLineLayer, \
    LOCfLineName, \
    LOCfLineSiteName, \
    LOCfLineSiteHandle, \
    LOCelevPointCount, \
    LOCpiPointCount, \
    LOClength2D, \
    LOClength3D, \
    LOCmaxElevation, \
    LOCminElevation, \
    LOCmaxGrade, \
    LOCminGrade \
  )
)


fn DYNFUNreadTagCivil3DCorridorRegion FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DCorridorRegion
  ------------------------
  int regionIndex;
  int appliedAssemblyCount;
  string name;  (Not yet exposed in C3D API)
  string description; (Not Used)
  string assemblyName;
  double startStation;
  double endStation;

  - if the appliedAssemblyCount is 0, it signals this region is empty
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCregionIndex         = readLong FUNfileStream            --
  local LOCappliedAsmCount     = readLong FUNfileStream            -- if the appliedAssemblyCount is 0, it signals this region is empty
  local LOCname                = DYNFUNreadBinString FUNfileStream --
  local LOCdescription         = DYNFUNreadBinString FUNfileStream --
  local LOCassemblyName        = DYNFUNreadBinString FUNfileStream --
  local LOCregionStartStation  = readFloat FUNfileStream           --
  local LOCregionEndStation    = readFloat FUNfileStream           --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCregionIndex, \
    LOCappliedAsmCount, \
    LOCname, \
    LOCdescription, \
    LOCassemblyName, \
    LOCregionStartStation, \
    LOCregionEndStation \
  )
)

fn DYNFUNreadTagCivil3DCorridorSurface FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DCorridorSurface
  ------------------------
  int stationCount
  int regionCount (actually STRIP count !!)
  int regionIndex
  int baseLineType
  int baseLineIndex
  int offsetBaseLineIndex
  int UniqueId
  string corridorHandle
  string corridorname
  string description
  string alignmentName
  string profileName
  string layerName
  string userTopCode
  string spare
  float startStation
  float endStation

    - the baseLineType is 0 or 1 for baseLine or offsetBaseLine.
    - the offsetBaseLineIndex is -1 if baseLineType is 0
    - the regionIndex is -1 if baseLineType is 0
    - uniqueID was "our" uniqueness value for each item that is a baseline
      of any kind (base, baseBase, offset). However, this was no longer possible
      to generate from DEX5 onwards (C3D 2013), so at that stage it was dropped from
      the file spec and hard-coded to zero. Up to this point, this value had
      not been utilized in Civil View.

  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCstationCount        = readLong FUNfileStream            --
  local LOCregionCount         = readLong FUNfileStream            --
  local LOCregionIndex         = readLong FUNfileStream            --
  local LOCbaseLineType        = readLong FUNfileStream            --
  local LOCbaseLineIndex       = readLong FUNfileStream            --
  local LOCoffsetBaseLineIndex = readLong FUNfileStream            --
  local LOCbaselineUniqueId    = readLong FUNfileStream            --
  local LOChandle              = DYNFUNreadBinString FUNfileStream --
  local LOCname                = DYNFUNreadBinString FUNfileStream --
  local LOCdescription         = DYNFUNreadBinString FUNfileStream --
  local LOCalignmentName       = DYNFUNreadBinString FUNfileStream --
  local LOCprofileName         = DYNFUNreadBinString FUNfileStream --
  local LOClayerName           = DYNFUNreadBinString FUNfileStream --
  local LOCuserLinkCode        = DYNFUNreadBinString FUNfileStream --
  local LOCspare               = DYNFUNreadBinString FUNfileStream --
  local LOCstartStation        = readFloat FUNfileStream           --
  local LOCendStation          = readFloat FUNfileStream           --

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCstationCount, \
    LOCregionCount, \
    LOCregionIndex, \
    LOCbaseLineType, \
    LOCbaseLineIndex, \
    LOCoffsetBaseLineIndex, \
    LOCbaselineUniqueId, \
    LOChandle, \
    LOCname, \
    LOCdescription, \
    LOCalignmentName, \
    LOCprofileName, \
    LOClayerName, \
    LOCuserLinkCode, \
    LOCspare, \
    LOCstartStation, \
    LOCendStation \
  )
)

fn DYNFUNreadTagCivil3DCorridorSurfaceVertexStationsOffsetsElevations FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DCorridorSurfaceVertexStationsOffsetsElevations
  ---------------------------------------------------------
  int count (should be same as vertex count in mesh parent) float S, O, E (repeated count times)

    - This matches every vertex with SOE, so vertex 20 in the
      mesh would correspond to item 20 in this chunk.

    - Remember that MXS indexes are one based and Stefan's are zero based.
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCsoeArray            = #()
  local LOCvertexCount         = readLong FUNfileStream            --
  LOCsoeArray[LOCvertexCount]  = undefined
  for i = 1 to LOCvertexCount do (LOCsoeArray[i] = [readFloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream])

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  LOCsoeArray                                                      -- return value
)

fn DYNFUNreadTagCivil3DCorridorSurfaceVertexPointCodes FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DCorridorSurfaceVertexPointCodes
  -----------------------------------
  int count (should be same as vertex count in mesh parent) string codes (repeated count times)

    - This matches every vertex with a comma delimited string containing
      the point codes of that point, so vertex 20 in the mesh would
      correspond to item 20 in this chunk.

    - All tag data provided after conversion to lower case

    - Delimitor character is a comma (point codes are created in C3D from a comma delimited list in the UI, so comma should work fine here)

      Could contain empty strings if point contains no point codes.
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCpCodeArray           = #()
  local LOCvertexCount          = readLong FUNfileStream           --
  LOCpCodeArray[LOCvertexCount] = undefined
  for i = 1 to LOCvertexCount do (LOCpCodeArray[i] = DYNFUNreadBinString FUNfileStream)

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  LOCpCodeArray                                                    -- return value
)

fn DYNFUNreadTagCivil3DCorridorSurfaceFaceStatus FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DCorridorSurfaceFaceStatus
  -----------------------------------
  int count (should be same as face count in mesh parent) int status (repeated count times)

  - This matches every face with a face status integer.
    Face 20 in the mesh would correspond to item 20 in this chunk.

    Status values are:
    0 - not used
    1 - face is a regular link face           (means that face is generated from a link to a link, always generating two triangles)
    2 - face is a filler link face            (means that filler face is generated from a link to a link, always generating two triangles)
    3 - face is a filler triangle face        (means that filler face is generated from a link to a point or point to a link)
    4 - face is a region filler link face
    5 - face is a region filler triangle face (not yet used, reserved for possible future use dependign on future enhancement of region filler routines)

  - IF THE STATUS IS NEGATIVE (but also any of the above values) it means the face is OVERSHADOWED.
    This will help in determining overshadow status for any of the other 5 status flavors since any of those types of faces
    could technically be constructed from an overshadowed face.
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCfStatusArray         = #()
  local LOCfaceCount            = readLong FUNfileStream           --
  LOCfStatusArray[LOCfaceCount] = undefined
  for i = 1 to LOCfaceCount do (LOCfStatusArray[i] = readLong FUNfileStream)

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  LOCfStatusArray                                                  -- return value
)

fn DYNFUNreadTagCivil3DCorridorSurfaceFaceData FUNfileStream FUNfileOffset FUNfileStop FUNfaceIndex =
(
  /*
  FUNfaceIndex is the index of the face whose data should be retreived. Specify 0 to retrieve all faces.

  TagCivil3DCorridorSurfaceFaceData
  ----------------------------------------
  The first item is an int representing the "item count" which should be the same as the face
  count on the surface but just to be safe, use this int from the tag for looping purposes.

  Next is a sequence of int's representing ABSOLUTE offsets. I went with absolute because after
  checking in the details it really doesn't matter whether it's absolute or relative so I went
  with the option that was most straightforward. This sequence contains "item count" number of
  ints that give you absolute offset to where individual face data resides.

  If you wish to read everything and ignore the index completely you can skip ahead 4 * "item
  count" times because each int is 4 bytes and that'll get you to the position of the first
  item. You can also use the first offset in the index (might be safer too).

  For each individual face in the sequence after the index you will find:

    string LinkCodes
    string SubAsmUniqueName
    string SubAsmFullClassName
    int    AppliedMaterialID          -- (either + or -)
    bool   IsSpanMapped               -- (whether the applied map is the result of spanning)
    float  Station                    -- (the station value)
    float  U-Tile
    float  V-Tile

    - AppliedMaterialID is the material ID from the file, so will be negative if user wanted face
       to be flipped. Will be zero if no match was made in the file.

    - Span map flag tells us whether span mapping was applied to this face, which needs to be
      taken into account
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCoffsetArray        = #()
  local LOCfDataArray         = #()
  local LOCfaceCount          = readLong FUNfileStream             --

  LOCoffsetArray[LOCfaceCount] = undefined
  for i = 1 to LOCfaceCount do (LOCoffsetArray[i] = readLong FUNfileStream)

  if FUNfaceIndex == 0 then
  (
    LOCfDataArray[LOCfaceCount] = undefined
    for i = 1 to LOCfaceCount do
    (
      local LOClinkCodes    = DYNFUNreadBinString FUNfileStream
      local LOCsubAsmName   = DYNFUNreadBinString FUNfileStream
      local LOCsubAsmClass  = DYNFUNreadBinString FUNfileStream
      local LOCappliedMatID = readLong            FUNfileStream
      local LOCisSpanMapped = readByte            FUNfileStream
      local LOCstation      = readFloat           FUNfileStream
      local LOCuTile        = readFloat           FUNfileStream
      local LOCvTile        = readFloat           FUNfileStream

      LOCfDataArray[i]      = #(LOClinkCodes, LOCsubAsmName, LOCsubAsmClass, LOCappliedMatID, LOCisSpanMapped, LOCstation, LOCuTile, LOCvTile)
    )
  )
  else
  (
    fseek FUNfileStream LOCoffsetArray[FUNfaceIndex] #seek_set                      -- move to position in file to pick up element content
    local LOClinkCodes    = DYNFUNreadBinString FUNfileStream
    local LOCsubAsmName   = DYNFUNreadBinString FUNfileStream
    local LOCsubAsmClass  = DYNFUNreadBinString FUNfileStream
    local LOCappliedMatID = readLong            FUNfileStream
    local LOCisSpanMapped = readByte            FUNfileStream
    local LOCstation      = readFloat           FUNfileStream
    local LOCuTile        = readFloat           FUNfileStream
    local LOCvTile        = readFloat           FUNfileStream
    LOCfDataArray = #(LOClinkCodes, LOCsubAsmName, LOCsubAsmClass, LOCappliedMatID, LOCisSpanMapped, LOCstation, LOCuTile, LOCvTile)
  )

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  LOCfDataArray                                                    -- return value
)

fn DYNFUNreadTagXmlElementInfo FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagXmlElementInfo
  -------------------------------------------------------
  string Name (see below)
  string Description (description field from CgPoints or Surface LandXML element)
  string ContextCode (see below)
  string LastModified (simply derived from the LandXML file timestamp)
  int XmlElementType (see below)
  int WireColorRed (see "wirecolors" below)
  int WireColorGreen (see "wirecolors" below)
  int WireColorBlue (see "wirecolors" below)
  int FeatureCount
    string FeatureName (from the relevant LandXML "Feature" element, where applicable)
    string FeatureCode (from the relevant LandXML "Feature" element, where applicable)
    ...repeated FeatureCount times...


  - where, "Name" is:
      + the breakline name for surface breaklines
      + the surface name for surface contours
      + the surface name for surface boundaries
      + the surface name for surface meshes
      + the CgPoints name for CgPoints

  - where "ContextCode" is:
      + The CgPoints "code" field for CgPoints elements.
      + The surface name for all surface related elements.

  - where, "XmlElementType" is:
      + 0 : XmlCgPoints
      + 1 : XmlSurfaceBoundaries
      + 2 : XmlSurfaceBreakline
      + 3 : XmlSurfaceContours
      + 4 : XmlSurfaceMesh
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname           = DYNFUNreadBinString FUNfileStream
  local LOCdescription    = DYNFUNreadBinString FUNfileStream
  local LOCcontextCode    = DYNFUNreadBinString FUNfileStream
  local LOClastModified   = DYNFUNreadBinString FUNfileStream
  local LOCxmlElementType = readLong FUNfileStream
  local LOCwireColorRed   = readLong FUNfileStream
  local LOCwireColorGreen = readLong FUNfileStream
  local LOCwireColorBlue  = readLong FUNfileStream
  local LOCfeatureCount   = readLong FUNfileStream

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname, \
    LOCdescription, \
    LOCcontextCode, \
    LOClastModified, \
    LOCxmlElementType, \
    LOCwireColorRed, \
    LOCwireColorGreen, \
    LOCwireColorBlue, \
    LOCfeatureCount \
  )
)

fn DYNFUNreadTagMxElementInfo FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagMxElementInfo
  -------------------------------------------------------
  string Name
  string SubReference
  string MxElementType
  string ModelName
  string LastModified
  int WireColorRed
  int WireColorGreen
  int WireColorBlue
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname           = DYNFUNreadBinString FUNfileStream
  local LOCsubReference   = DYNFUNreadBinString FUNfileStream
  local LOCmxElementType  = DYNFUNreadBinString FUNfileStream
  local LOCmodelName      = DYNFUNreadBinString FUNfileStream
  local LOClastModified   = DYNFUNreadBinString FUNfileStream
  local LOCwireColorRed   = readLong FUNfileStream
  local LOCwireColorGreen = readLong FUNfileStream
  local LOCwireColorBlue  = readLong FUNfileStream

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname, \
    LOCsubReference, \
    LOCmxElementType, \
    LOCmodelName, \
    LOClastModified, \
    LOCwireColorRed, \
    LOCwireColorGreen, \
    LOCwireColorBlue \
  )
)

fn DYNFUNreadTagTwelveDElementInfo FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagTwelveDElementInfo
  -------------------------------------------------------
  string Name
  string 12dElementType
  string ModelName
  string LastModified
  int WireColorRed
  int WireColorGreen
  int WireColorBlue
  */
  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname           = DYNFUNreadBinString FUNfileStream
  local LOC12dElementType = DYNFUNreadBinString FUNfileStream
  local LOCmodelName      = DYNFUNreadBinString FUNfileStream
  local LOClastModified   = DYNFUNreadBinString FUNfileStream
  local LOCwireColorRed   = readLong FUNfileStream
  local LOCwireColorGreen = readLong FUNfileStream
  local LOCwireColorBlue  = readLong FUNfileStream

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname, \
    LOC12dElementType, \
    LOCmodelName, \
    LOClastModified, \
    LOCwireColorRed, \
    LOCwireColorGreen, \
    LOCwireColorBlue \
  )
)

fn DYNFUNreadElemPoints3D FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  Points3D
  --------------------------------------------------------------------
  int numPoints
  [points]

  - where [points] is [point records (n) times]
  The repeated point records consist of:
  --------------------------------------------------------------------
    Float X
    Float Y
    Float Z
  --------------------------------------------------------------------
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCpgNumPoints         = readLong FUNfileStream            -- Number of Points in Point Group

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCpgNumPoints)                   -- return value
)

fn DYNFUNreadElemCivil3DPipeNetwork FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  Civil3DPipeNetwork
  --------------------------------------------------------------------
  string Name
  string Handle
  string Description
  int numPipes
  int numStructures

  - where [numPipes] is [pipe records (n) times]
  The repeated pipe records consist of:
  --------------------------------------------------------------------
    string Name
    string DisplayName
    string Description
    string PartDescription
    string PartSizeName
    string PartSubType
    string StartStructureHandle
    string EndStructureHandle
    int HORType                 - (Centerline = 0; Crown = 1; Invert = 2)
    int PSEType                 - (Curved = 0; Flex = 1; Segmented = 2; Straight = 3)
    int FlowDirection           - (Bidirectional = 0; EndToStart = 1; StartToEnd = 2;
    int FlowDirectionMethod     - (Bidirectional = 0; BySlope = 1; EndToStart = 2; StartToEnd = 3)
    int CrossSectionalShape     - (Undefined = 0; Arched = 1; Circular = 2; CustomShape = 3; EggShaped = 4; Elliptical = 5; HorizontalElliptical = 6; Rectangular = 7)
    float StartPointX
    float StartPointY
    float StartPointZ
    float EndPointX
    float EndPointY
    float EndPointZ
    float Bearing
    float Radius
    float Slope
    float InnerDiameterOrWidth
    float InnerHeight
    float OuterDiameterOrWidth
    float OuterHeight
    float MinimumCover
    float MaximumCover
    float Length2DCenterToCenter
    float Length3DCenterToCenter
    float Length2DToInsideEdge
    float Length3DToInsideEdge
  --------------------------------------------------------------------

  - where [numStructures] is [structure records (n) times]
  The repeated structure records consist of:
  --------------------------------------------------------------------
    string Name
    string DisplayName
    string NetworkName
    string NetworkId
    string Cover
    string Frame
    string Grate
    string Material
    string PartDefId
    string PartDescription
    string PartSizeName
    string PartSubType
    int BoundingShape        - (Undefined = 0; Box = 1; Cylinder = 2; Sphere = 3)
    int ConnectedPartCount
    int ConnectedPipesCount
    int PartType             - (UndefinedPartType = 0; Channel = 1; Conduit = 2; Pipe = 3; StructEquipment = 4; StructGeneral = 5; StructInletOutlet = 6; StructJunction = 7; StructNull = 8; Wire = 9)
    float PositionX
    float PositionY
    float PositionZ
    float Rotation
    float Height
    float FrameHeight
    float FrameDiameter
    float WallThickness
    float FloorThickness
    float ConeHeight
    float RimElevation
    float RimToSumpHeight
    float SumpDepth
    float SumpElevation
    float BarrelPipeClearance
    float DiameterOrWidth
    float InnerDiameterOrWidth
    float Length
    float InnerLength
  --------------------------------------------------------------------
  */

  fseek FUNfileStream FUNfileOffset #seek_set                          -- move to position in file to pick up element content
  readLong FUNfileStream                                               -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname              = DYNFUNreadBinString FUNfileStream       -- Pipe Network Name
  local LOChandle            = DYNFUNreadBinString FUNfileStream       -- Pipe Network Handle
  local LOCdescription       = DYNFUNreadBinString FUNfileStream       -- Pipe Network Description
  local LOCnumPipes          = readLong FUNfileStream                  -- Number of Pipes in Pipe Network
  local LOCnumStructures     = readLong FUNfileStream                  -- Number of Structures in Pipe Network

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname, LOChandle, LOCdescription, LOCnumPipes, LOCnumStructures) -- return value
)


fn DYNFUNreadElemAlignment FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  Alignment
  --------------------------------------------------------------------
  string Name
  int NumEntities
  float StartStation
  float EndStation
  int NumPoints
  [points]

  - where [points] is [point records (numPoints) times]
  The repeated point records consist of:
  --------------------------------------------------------------------
    float X
    float Y
    float Z (DefaultZ only)
    float Station/Chainage
    float Alignment Radius
    float Bearing
    int SubEntType (arc:1, line:2, spiral:3)
    bool IsSubEntStartOrEnd
  --------------------------------------------------------------------
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname           = DYNFUNreadBinString FUNfileStream      -- The name of the mesh (derived from the surface object name in C3D)
  local LOCentities       = readLong FUNfileStream                 -- number of entities in the alignment
  local LOCstartChain     = readFloat FUNfileStream                -- alignment start chainage/station
  local LOCendChain       = readFloat FUNfileStream                -- alignment end chainage/station
  local LOCnumPoints      = readLong FUNfileStream                 -- number of station based points in the alignment

  /*
  local LOCpointData      = #(); LOCpointData.count = LOCnumPoints
  for i = 1 to LOCnumPoints do
  (
    local LOCx            = readFloat FUNfileStream                -- float X
    local LOCy            = readFloat FUNfileStream                -- float Y
    local LOCz            = readFloat FUNfileStream                -- float Z
    local LOCstation      = readFloat FUNfileStream                -- float Station
    local LOCalignRadius  = readFloat FUNfileStream                -- float Alignment Radius
    local LOCalignBearing = readFloat FUNfileStream                -- float AlignmentBearing
    local LOCalignEntType = readLong FUNfileStream                 -- int AlignmentSubEntType (arc:1, line:2, spiral:3)
    local LOCIsAlignTang  = readByte FUNfileStream                 -- bool IsAlignmentSubEntStartOrEnd

    LOCpointData[i] = #(LOCx, LOCy, LOCz, LOCstation, LOCalignRadius, LOCalignBearing, LOCalignEntType, LOCIsAlignTang)
  )
  */

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname, LOCentities, LOCstartChain, LOCendChain, LOCnumPoints)-- Return Value
)


fn DYNFUNreadTagCivil3DAlignment FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DAlignment
  ---------------------------------------
  string Name
  string Description
  string Handle
  string LayerName
  string SiteName
  string SiteHandle
  int NumEntities
  int AlignmentType (centerline:1, curbreturn:2, offset:3, utility:4)
  bool IsOffsetAlignment
  bool UseDesignSpeed
  float StartStation
  float EndStation
  float Length
  float TangentInterval
  float CurveInterval
  float SpiralInterval
  int NumDesignSpeeds
  [Design Speeds]

  - where [Design Speeds] is [design speed records (NumDesignSpeeds) times]
  The repeated design speed records consist of:
  --------------------------------------------------------------------
    long/int64 SpeedNumber
    float Station
    float Value
    string Comment
  --------------------------------------------------------------------

    - If everything is fine TagCivil3DAlignment would likely be the first tag
      for an <Alignment> element.
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname           = DYNFUNreadBinString FUNfileStream      -- string Name
  local LOCdescription    = DYNFUNreadBinString FUNfileStream      -- string Description
  local LOChandle         = DYNFUNreadBinString FUNfileStream      -- string Handle
  local LOClayerName      = DYNFUNreadBinString FUNfileStream      -- string LayerName
  local LOCsiteName       = DYNFUNreadBinString FUNfileStream      -- string SiteName
  local LOCsiteHandle     = DYNFUNreadBinString FUNfileStream      -- string SiteHandle
  local LOCnumEntities    = readLong FUNfileStream                 -- int NumEntities
  local LOCalignmentType  = readLong FUNfileStream                 -- int AlignmentType (centerline:1, curbreturn:2, offset:3, utility:4)
  local LOCisOffsetAlign  = readByte FUNfileStream                 -- bool IsOffsetAlignment
  local LOCuseDesSpeed    = readByte FUNfileStream                 -- bool UseDesignSpeed
  local LOCstartStation   = readFloat FUNfileStream                -- float StartStation
  local LOCendStation     = readFloat FUNfileStream                -- float EndStation
  local LOClength         = readFloat FUNfileStream                -- float Length
  local LOCintTangents    = readFloat FUNfileStream                -- float TangentInterval
  local LOCintCurves      = readFloat FUNfileStream                -- float CurveInterval
  local LOCintSpirals     = readFloat FUNfileStream                -- float SpiralInterval
  local LOCnumDesSpeeds   = readLong FUNfileStream                 -- int NumDesignSpeeds
  local LOCdesSpeedData   = #(); LOCdesSpeedData.count = LOCnumDesSpeeds

  for i = 1 to LOCnumDesSpeeds do
  (
    local LOCspeedNumber  = readLong FUNfileStream                 -- int SpeedNumber
    local LOCstation      = readFloat FUNfileStream                -- float Start Station
    local LOCvalue        = readFloat FUNfileStream                -- float Value
    local LOCcomment      = DYNFUNreadBinString FUNfileStream      -- string Comment

    LOCdesSpeedData[i] = #(LOCspeedNumber, LOCstation, LOCvalue, LOCcomment)
  )


  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname         , \
    LOCdescription  , \
    LOChandle       , \
    LOClayerName    , \
    LOCsiteName     , \
    LOCsiteHandle   , \
    LOCnumEntities  , \
    LOCalignmentType, \
    LOCisOffsetAlign, \
    LOCuseDesSpeed  , \
    LOCstartStation , \
    LOCendStation   , \
    LOClength       , \
    LOCintTangents  , \
    LOCintCurves    , \
    LOCintSpirals   , \
    LOCnumDesSpeeds , \
    LOCdesSpeedData  \
  )
)

fn DYNFUNreadTagCivil3DProfile FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagCivil3DProfile
  ---------------------------------------
  string Name
  int NumEntities
  float StartStation
  float EndStation
  float Length
  float Offset
  int NumPoints
  [Profile Points]

  - where [Profile Points] is [point records (NumPoints) times]
  The repeated point records consist of:
  --------------------------------------------------------------------
    float X
    float Y
    float Z
    float Station
    float AlignmentRadius
    float AlignmentBearing
    int AlignmentSubEntityType
    bool IsAlignmentSubEntityStartOrEnd
    float ProfileRadius
    float ProfileGrade
    int ProfileEntType (Circular:1, Tangent:2, PAsym:3, PSym:4)
    bool IsProfileEntStartOrEnd
  --------------------------------------------------------------------

    - A Civil 3D Alignment can contain multiple TagCivil3DProfile tags.
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCname           = DYNFUNreadBinString FUNfileStream      -- string Name
  local LOCnumEntities    = readLong FUNfileStream                 -- int NumEntities
  local LOCstartStation   = readFloat FUNfileStream                -- float StartStation
  local LOCendStation     = readFloat FUNfileStream                -- float EndStation
  local LOClength         = readFloat FUNfileStream                -- float Length
  local LOCoffset         = readFloat FUNfileStream                -- float Offset
  local LOCnumPoints      = readLong FUNfileStream                 -- int NumPoints

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  #(LOCname, \
    LOCnumEntities, \
    LOCstartStation, \
    LOCendStation, \
    LOClength, \
    LOCoffset, \
    LOCnumPoints \
  )
)

fn DYNFUNreadTagMxEdgeReferences FUNfileStream FUNfileOffset FUNfileStop =
(
  /*
  TagMxEdgeReferences
  ---------------------------------------

  int numRefs
  string ref
  [...repeat until numRefs...]

  You will find this as tags on meshes and the references are in order as they are handled.
  So if ABC is CBA, the references are also rotated to match what is in the actal faces
  data of the mesh. It's one item per edge so you will have 3 of these per face and they
  are in that order; face ABC, ref1 = AB, ref2 = BC, ref3 = CA

  The tag itself is just a huge list of strings, basically.
  */

  fseek FUNfileStream FUNfileOffset #seek_set                      -- move to position in file to pick up element content
  readLong FUNfileStream                                           -- NOTE: EVERY element starts with an int (or long for "D") that holds the chunk size (of the element and all its sub-elements combined). You don't need this value unless you start sequentially stream-reading which would defeat the purpose of the index at this point). I decided to keep the field in there because it might be useful in the future. So you can skip over the first INT (or LONG) after jumping to the data position for an element.

  local LOCedgeRefArray         = #()
  local LOCrefCount            = readLong FUNfileStream           --
  LOCedgeRefArray[LOCrefCount] = undefined
  for i = 1 to LOCrefCount do (LOCedgeRefArray[i] = DYNFUNreadBinString FUNfileStream)

  if FUNfileStop != 0 then fseek FUNfileStream FUNfileStop #seek_set

  LOCedgeRefArray                                                  -- return value
)

fn DYNFUNgenerateC3DrelatedAppData FUNobjectType FUNdata =
(
  local LOCnullName = " "

  /*
    LOCnullName is essential to ensure that wherever a "$!!$" delimited string is used, that
    empty strings in the first index of the delimited string are not blank. If they were
    blank the indexes would be messed up when using filterString

    splitEmptyTokens:<boolean> flag cannot be used with filterString because it does not
    work where delimitor is more than a single character.
  */

  /*
    The object handle MUST be the *third* item in all the following delimited appData strings, AND in all
    future tags and c3d object types added to Civil View.
  */

  local LOCappDataArray = #("", "") -- 427, 428

  if FUNobjectType == "TagXmlElementInfo" then
  (
    /*
    TagXmlElementInfo
    -------------------------------------------------------
    string Name
    string Description
    string ContextCode (CgPoints code or Surface Name)
    string LastModified
    int XmlElementType (0:XmlCgPoints, 1:XmlSurfaceBoundaries, 2:XmlSurfaceBreakline, 3:XmlSurfaceContours, 4:XmlSurfaceMesh)
    int WireColorRed
    int WireColorGreen
    int WireColorBlue
    int FeatureCount
      string FeatureName (from the relevant LandXML "Feature" element, where applicable)
      string FeatureCode (from the relevant LandXML "Feature" element, where applicable)
      ...repeated FeatureCount times...

    */

    if FUNdata[1] == "" then FUNdata[1] = LOCnullName
    if FUNdata[3] == "" then FUNdata[3] = LOCnullName

    LOCappDataArray[1] = FUNdata[1] + "$!!$" + (FUNdata[5] as string)
    LOCappDataArray[2] = FUNdata[3]
  )

  if FUNobjectType == "TagTwelveDElementInfo" then
  (
    /*
    TagTwelveDElementInfo
    -------------------------------------------------------
    string Name
    string 12dElementType
    string ModelName
    string LastModified
    int WireColorRed
    int WireColorGreen
    int WireColorBlue
    */

    if FUNdata[1] == "" then FUNdata[1] = LOCnullName
    if FUNdata[2] == "" then FUNdata[2] = LOCnullName

    LOCappDataArray[1] = FUNdata[1] + "$!!$" + FUNdata[2]
    LOCappDataArray[2] = FUNdata[3]
  )

  if FUNobjectType == "TagMxElementInfo" then
  (
    /*
    TagMxElementInfo
    -------------------------------------------------------
    string Name
    string SubReference
    string MxElementType
    string ModelName
    string LastModified
    int WireColorRed
    int WireColorGreen
    int WireColorBlue
    */
    LOCappDataArray[1] = FUNdata[1]
    LOCappDataArray[2] = FUNdata[4]
  )

  if FUNobjectType == "Civil3DPipeNetwork" then
  (
    /*
    Civil3DPipeNetwork
    -------------------------
    string Name
    string Handle
    string Description
    int numPipes
    int numStructures
    [pipes]
    [structures]
    */

    LOCappDataArray[1] = FUNdata[1]
    LOCappDataArray[2] = LOCnullName + "$!!$" + "17$!!$HANDLE$!!$" + FUNdata[1]-- third item is point group handle
  )

  if FUNobjectType == "Civil3DPipeNetworkPipe" then
  (
    /*
    FUNdata[10] = Pipe Name
    FUNdata[13] = Pipe Network Name
    */
    LOCappDataArray[1] = FUNdata[10]
    LOCappDataArray[2] = FUNdata[13] + "$!!$17$!!$HANDLE$!!$1"
  )

  if FUNobjectType == "Civil3DPipeNetworkStructure" then
  (
    /*
    FUNdata[5] = Structure Name
    FUNdata[9] = Pipe Network Name
    */
    LOCappDataArray[1] = FUNdata[5]
    LOCappDataArray[2] = FUNdata[9] + "$!!$17$!!$HANDLE$!!$2"
  )

  if FUNobjectType == "TagCivil3DAlignment" then
  (
    /*
    TagCivil3DAlignment
    ---------------------------------------
    string Name
    string Description
    string Handle
    string LayerName
    string SiteName
    string SiteHandle
    int NumEntities
    int AlignmentType (centerline:1, curbreturn:2, offset:3, utility:4)
    bool IsOffsetAlignment
    bool UseDesignSpeed
    float StartStation
    float EndStation
    float Length
    float TangentInterval
    float CurveInterval
    float SpiralInterval
    int NumDesignSpeeds
    [Design Speeds]
    */

    if FUNdata[5] == "" then FUNdata[5] = LOCnullName

    LOCappDataArray[1] = FUNdata[1]
    LOCappDataArray[2] = FUNdata[5] + "$!!$" + "16$!!$HANDLE$!!$" + FUNdata[1]   -- third item is point group handle
  )

  if FUNobjectType == "Civil3DPointGroup" then
  (
    /*
    Civil3DPointGroup
    -------------------------
    string Name
    string Handle
    string Description
    int numPoints
    [points]
    */
    LOCappDataArray[1] = FUNdata[1]
    LOCappDataArray[2] = LOCnullName + "$!!$" + "15$!!$HANDLE$!!$" + FUNdata[1]  -- third item is point group handle
  )

  if FUNobjectType == "TagCivil3DLandFeatureLine" then
  (
    /*
    TagCivil3DLandFeatureLine
    -------------------------
    String Handle
    String description
    String layerName
    String name
    String siteName
    String siteHandle
    int elevationPointCount
    int piPointCount
    double length2D
    double length3D
    double maximumElevation
    double minimumElevation
    double maximumGrade
    double minimumGrade
    */
    if FUNdata[4] == "" then FUNdata[4] = LOCnullName -- Force something to be entered into this field for both 427 and 428. VERY IMPORTANT!
    if FUNdata[5] == "" then FUNdata[5] = LOCnullName

    LOCappDataArray[1] = FUNdata[4]
    LOCappDataArray[2] = FUNdata[5] + "$!!$" + "14$!!$HANDLE$!!$" + FUNdata[5] + "$!!$" + FUNdata[4] + "$!!$" + "-1" -- third item is site handle
  )

  if FUNobjectType == "TagCivil3DCorridorFeatureLine" then
  (
    /*
    TagCivil3DCorridorFeatureLine
    -----------------------------
    int knotCount
    string pointCode (feature line name)
    int baseLineType
    int baseLineIndex
    int offsetBaseLineIndex
    int regionIndex
    string assemblyName
    string corridorHandle
    string corridorName
    string layerName
    private string userLinkCode
    string spare
    double regionStartStation
    double regionEndStation
    */

    if FUNdata[2] == "" then FUNdata[2] = LOCnullName
    if FUNdata[9] == "" then FUNdata[9] = LOCnullName

    LOCappDataArray[1] = FUNdata[2] + " - " + DYNuiResourcesC3dObjectTypes[16] + " (" + ((FUNdata[6] + 1) as string) + ")"
    LOCappDataArray[2] = FUNdata[9] + "$!!$" + "13$!!$HANDLE$!!$" + (FUNdata[6] as string) + "$!!$" + (FUNdata[4] as string) + "$!!$" + (FUNdata[5] as string) + "$!!$" + FUNdata[2]  -- third item is corridor handle
  )

  if FUNobjectType == "TagCivil3DCorridorBaseLine" then
  (
    /*
    TagCivil3DCorridorBaseLine
    --------------------------
    int knotCount
    int baseLineType;
    int baseLineIndex;
    int offsetBaseLineIndex;
    int RegionId;
    int uniqueId;
    string name; (not used)
    string description; (not used)
    string alignmentName;
    string profileName; (not used)
    string corridorHandle;
    string corridorName;
    string layerName;
    string userTopCode;
    string spare;
    int regionCount;
    double startStation;
    double endStation;
    */

    if FUNdata[12] == "" then FUNdata[12] = LOCnullName

    LOCappDataArray[1] = FUNdata[9]
    LOCappDataArray[2] = FUNdata[12] + "$!!$" + "12$!!$HANDLE$!!$" + (FUNdata[5] as string) + "$!!$" + (FUNdata[3] as string) + "$!!$" + (FUNdata[4] as string) -- third item is corridor handle
  )

  if FUNobjectType == "TagCivil3DCorridorSurface" then
  (
    /*
    TagCivil3DCorridorSurface
    ------------------------
    int stationCount
    int regionCount (actually STRIP count !!)
    int regionIndex
    int baseLineType
    int baseLineIndex
    int offsetBaseLineIndex
    int UniqueId
    string corridorHandle
    string corridorname
    string description
    string alignmentName
    string profileName
    string layerName
    string userTopCode
    string spare
    float startStation
    float endStation
    */

    if FUNdata[9] == "" then FUNdata[9] = LOCnullName

    LOCappDataArray[1] = DYNuiResourcesC3dObjectTypes[16] + " (" + ((FUNdata[3] + 1) as string) + ")"
    LOCappDataArray[2] = FUNdata[9] + "$!!$" + "11$!!$HANDLE$!!$" + (FUNdata[3] as string) + "$!!$" + (FUNdata[5] as string) + "$!!$" + (FUNdata[6] as string) -- third item is corridor handle
  )

  if FUNobjectType == "TagCivil3DSurface" then
  (
    /*
    TagCivil3DSurface
    -----------------
    string handle;
    string description;
    string layerName;
    string materialName;
    int materialId;
    double mappingURepeat;
    double mappingVRepeat;
    int pointCount;
    int faceCount;
    (string name);       -- manually added MXS field
    (boolean selected);  -- manually added MXS field (11)
    */

    if FUNdata[3]  == "" then FUNdata[3]  = LOCnullName
    if FUNdata[10] == "" then FUNdata[10] = LOCnullName

    LOCappDataArray[1] = FUNdata[10]
    LOCappDataArray[2] = FUNdata[3] + "$!!$" + "10$!!$HANDLE$!!$" + FUNdata[10] + "-1" + "$!!$" + "-1" -- third item is surface handle
  )

  LOCappDataArray -- return value
)

fn DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems =
(
  --- Define ListItem
  local LOCdnListItem       = dotNetObject "System.Windows.Forms.ListViewItem" (FUNtext as string)
  LOCdnListItem.tag         = FUNtag
  LOCdnListItem.tooltipText = FUNtoolTip
  LOCdnListItem.imageIndex  = FUNimageIndex
  LOCdnListItem.checked     = FUNchecked

  --- Define ListItem SubItems
  LOCdnListItem.SubItems.add (FUNsubItems[1]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[2]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[3]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[4]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[5]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[6]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[7]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[8]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[9]  as string)
  LOCdnListItem.SubItems.add (FUNsubItems[10] as string)
  LOCdnListItem.SubItems.add (FUNsubItems[11] as string)

  --- Is ListItem "Enabled" or "Greyed-Out"
  if FUNcolorSwitch then (LOCdnListItem.tag = ""; LOCdnListItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor)

  LOCdnListItem -- return value
)

fn DYNFUNreadVesperFile FUNc3dVspFile =
(
  --- Set Up Function Result Parameters
  local LOCsrcName                     = ""
  local LOCsrcPath                     = ""
  local LOCsrcVersion                  = ""
  local LOCshiftX                      = 0
  local LOCshiftY                      = 0
  local LOCshiftZ                      = 0

  if FUNc3dVspFile != undefined then
  (
    local LOCfileFormatFound = false

    ---Start reading Lines from File
    local LOCfileStream = fOpen FUNc3dVspFile "rbS"

    --- Check File Header/Identifier (i.e. DVSP1000, DVSP2000, etc)
    local LOCheader = ""
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string
    local LOCbyte = readByte LOCfileStream; LOCheader += LOCbyte as string

    if LOCheader == "6886838049484848" then -- check header
    (
      LOCfileFormatFound            = true
      messagebox (DYNuiResourcesErrorsWarnings[106]) title:DYNuiResourcesTitlebars[1]
      FUNc3dVspFile = undefined
    )

    if LOCheader == "6886838050484848" then -- IS HEADER "DVSP2000" ?
    (
      LOCfileFormatFound            = true

      --- Reset Global Arrays for VSP3D File Content from Civil 3D
      DYNc3dAlignments              = #()
      DYNc3dCorridorBaselines       = #()
      DYNc3dCorridorRegions         = #()
      DYNc3dCorridorFeatureLines    = #()
      DYNc3dNamedLandFeatureLines   = #()
      DYNc3dUnnamedLandFeatureLines = #()
      DYNc3dSurfaces                = #()
      DYNc3dCorridorSurfaces        = #()
      DYNc3dPointGroups             = #()
      DYNc3dPipeNetworks            = #()
      DYNc3dSites                   = #()

      --- Reset Global Arrays for VSP3D File Content from MX
      DYNmxPointStrings             = #()
      DYNmxShapeStrings             = #()
      DYNmxSurfaceStrings           = #()

      --- Reset Global Arrays for VSP3D File Content from 12d
      DYN12dPointStrings            = #()
      DYN12dShapeStrings            = #()
      DYN12dSurfaceStrings          = #()

      --- Reset Global Arrays for VSP3D File Content from LandXML
      DYNxmlPointStrings            = #()
      DYNxmlShapeStrings            = #()
      DYNxmlSurfaceStrings          = #()

      ---------- READ FILE HEADER --------------
      local LOCversion     = readLong LOCfileStream
      local LOCprecision   = readLong LOCfileStream                       -- The precision flag. 0 = single, anything not 0 is double.
      local LOCabsOffset   = readLong LOCfileStream                       -- The absolute offset to the index. Seek from file-start to this position to end up at the index of the file.
      fseek LOCfileStream LOCabsOffset #seek_set                          -- move to file index at end of file

      --- Cycle Through Elements In File
      local LOCnumElements = readLong LOCfileStream                       -- The number of elements in the root of the 'scene' or 'DB'.
      for i = 1 to LOCnumElements do
      (
        local LOCrootElementData = DYNFUNreadElementHeader LOCfileStream  -- Read Standard Index Data For Every Root Element

        --- If Element Was a Information Element about Civil 3D  ----------------------------------------
        if LOCrootElementData[1] == "InfoCivil3DSource" then
        (
          local LOCelemArray = DYNFUNreadElemInfoCivil3DSource LOCfileStream LOCrootElementData[3] LOCrootElementData[5]
          LOCsrcName    = LOCelemArray[1]
          LOCsrcPath    = LOCelemArray[2]
          LOCsrcVersion = LOCelemArray[3]
        )

        --- If Element Was a Information Element about LandXML  -----------------------------------------
        if LOCrootElementData[1] == "InfoXmlSource" then
        (
          local LOCelemArray = DYNFUNreadElemInfoXmlSource LOCfileStream LOCrootElementData[3] LOCrootElementData[5]
          LOCsrcName    = LOCelemArray[1]
          LOCsrcPath    = LOCelemArray[2]
        )

        --- If Element Was a Information Element about MX        ----------------------------------------
        if LOCrootElementData[1] == "InfoMxSource" then
        (
          local LOCelemArray = DYNFUNreadElemInfoMxSource LOCfileStream LOCrootElementData[3] LOCrootElementData[5]
          LOCsrcName    = LOCelemArray[1]
          LOCsrcPath    = LOCelemArray[2]
        )

        --- If Element Was a Scene Shift Element  -------------------------------------------------------
        if LOCrootElementData[1] == "InfoSceneShift" then
        (
          local LOCelemArray = DYNFUNreadElemInfoSceneShift LOCfileStream LOCrootElementData[3] LOCrootElementData[5]
          LOCshiftX = LOCelemArray[1]
          LOCshiftY = LOCelemArray[2]
          LOCshiftZ = LOCelemArray[3]
        )

        --- If Element Was A Site Container
        if LOCrootElementData[1] == "ContainerCivil3DSite" then
        (
          local LOCsiteData = DYNFUNreadContainerCivil3DSite LOCfileStream LOCrootElementData[3] LOCrootElementData[5]
          append DYNc3dSites LOCsiteData

          for ii = 1 to LOCrootElementData[4] do
          (
            local LOCtagElementData = DYNFUNreadElementHeader LOCfileStream

            if LOCtagElementData[1] == "Alignment" then
            (
              local LOCelemArray = DYNFUNreadElemAlignment LOCfileStream LOCtagElementData[3] LOCtagElementData[5]

              for ii = 1 to LOCtagElementData[4] do
              (
                local LOCsubTagElementData = DYNFUNreadElementHeader LOCfileStream

                if LOCsubTagElementData[1] == "TagCivil3DAlignment" then
                (
                  local LOCalignmentData = DYNFUNreadTagCivil3DAlignment LOCfileStream LOCsubTagElementData[3] LOCsubTagElementData[5]
                  append LOCalignmentData false -- selected for import? (19)
                  append LOCalignmentData LOCtagElementData[3]
                  append LOCalignmentData false -- Already Exists In Scene? (21)
                  append LOCalignmentData LOCelemArray[5] -- Number of Points (22)

                  local LOCprofileFileOffsetArray = #()
                  local LOCprofilePointCountArray = #()

                  for iii = 1 to LOCsubTagElementData[4] do
                  (
                    local LOCsubsubTagElementData = DYNFUNreadElementHeader LOCfileStream

                    if LOCsubsubTagElementData[1] == "TagCivil3DProfile" then
                    (
                      local LOCprofileData = DYNFUNreadTagCivil3DProfile LOCfileStream LOCsubsubTagElementData[3] LOCsubsubTagElementData[5]
                      append LOCprofileFileOffsetArray LOCsubsubTagElementData[3]
                      append LOCprofilePointCountArray LOCprofileData[7]
                    )
                  )

                  append LOCalignmentData LOCprofileFileOffsetArray -- Array of FileOffsets to Profile Data (23)
                  append LOCalignmentData LOCprofilePointCountArray -- Array of Point Counts for Profile Data (24)
                  append DYNc3dAlignments LOCalignmentData
                )
              )
            )

            if LOCtagElementData[1] == "Shape" then
            (
              local LOCelemArray = DYNFUNreadElemShape LOCfileStream LOCtagElementData[3] LOCtagElementData[5]

              for ii = 1 to LOCtagElementData[4] do
              (
                local LOCsubTagElementData = DYNFUNreadElementHeader LOCfileStream

                if LOCsubTagElementData[1] == "TagCivil3DLandFeatureLine" then
                (
                  local LOClflData = DYNFUNreadTagCivil3DLandFeatureLine LOCfileStream LOCsubTagElementData[3] LOCsubTagElementData[5]
                  append LOClflData false -- selected for import? (15)
                  append LOClflData LOCtagElementData[3]
                  append LOClflData false -- Already Exists In Scene? (17)

                  if LOClflData[4] != "" then
                  (
                    append DYNc3dNamedLandFeatureLines LOClflData
                  )
                  else
                  (
                    append DYNc3dUnnamedLandFeatureLines LOClflData
                  )
                )
              )
            )
          )
        )

        --- If Element Was an Alignment -----------------------------------------------------------------
        if LOCrootElementData[1] == "Alignment" then
        (
          local LOCelemArray = DYNFUNreadElemAlignment LOCfileStream LOCrootElementData[3] LOCrootElementData[5]

          for ii = 1 to LOCrootElementData[4] do
          (
            local LOCtagElementData = DYNFUNreadElementHeader LOCfileStream

            if LOCtagElementData[1] == "TagCivil3DAlignment" then
            (
              local LOCalignmentData = DYNFUNreadTagCivil3DAlignment LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCalignmentData false -- selected for import? (19)
              append LOCalignmentData LOCrootElementData[3]
              append LOCalignmentData false -- Already Exists In Scene? (21)
              append LOCalignmentData LOCelemArray[5] -- Number of Points (22)

              local LOCprofileFileOffsetArray = #()
              local LOCprofilePointCountArray = #()

              for iii = 1 to LOCtagElementData[4] do
              (
                local LOCsubTagElementData = DYNFUNreadElementHeader LOCfileStream

                if LOCsubTagElementData[1] == "TagCivil3DProfile" then
                (
                  local LOCprofileData = DYNFUNreadTagCivil3DProfile LOCfileStream LOCsubTagElementData[3] LOCsubTagElementData[5]
                  append LOCprofileFileOffsetArray LOCsubTagElementData[3]
                  append LOCprofilePointCountArray LOCprofileData[7]
                )
              )

              append LOCalignmentData LOCprofileFileOffsetArray -- Array of FileOffsets to Profile Data (23)
              append LOCalignmentData LOCprofilePointCountArray -- Array of Point Counts for Profile Data (24)
              append DYNc3dAlignments LOCalignmentData
            )
          )
        )

        --- If Element Was A Point Group ----------------------------------------------------------------
        if LOCrootElementData[1] == "Civil3DPointGroup" then
        (
          local LOCelemArray = DYNFUNreadElemCivil3DPointGroup LOCfileStream LOCrootElementData[3] LOCrootElementData[5]

          append LOCelemArray false -- selected for import? (5)
          append LOCelemArray LOCrootElementData[3]
          append LOCelemArray false -- Already Exists In Scene? (7)
          append DYNc3dPointGroups LOCelemArray
        )

        --- If Element Was A Pipe Network
        if LOCrootElementData[1] == "Civil3DPipeNetwork" then
        (
          local LOCelemArray = DYNFUNreadElemCivil3DPipeNetwork LOCfileStream LOCrootElementData[3] LOCrootElementData[5]
          append LOCelemArray false -- selected for import? (6)
          append LOCelemArray LOCrootElementData[3]
          append LOCelemArray false -- Already Exists In Scene? (8)
          append DYNc3dPipeNetworks LOCelemArray
        )

        --- If Element Was a Points3D              -------------------------------------------------------
        if LOCrootElementData[1] == "Points3D" then
        (
          local LOCelemArray = DYNFUNreadElemPoints3D LOCfileStream LOCrootElementData[3] LOCrootElementData[5]

          for ii = 1 to LOCrootElementData[4] do
          (
            local LOCtagElementData = DYNFUNreadElementHeader LOCfileStream

            if LOCtagElementData[1] == "TagXmlElementInfo" then
            (
              local LOCxmlStringData = DYNFUNreadTagXmlElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCxmlStringData false -- selected for import? (10)
              append LOCxmlStringData LOCrootElementData[3]
              append LOCxmlStringData false -- Already Exists In Scene? (12)
              append DYNxmlPointStrings LOCxmlStringData
            )
            if LOCtagElementData[1] == "TagMxElementInfo" then
            (
              local LOCmxStringData = DYNFUNreadTagMxElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCmxStringData false -- selected for import? (9)
              append LOCmxStringData LOCrootElementData[3]
              append LOCmxStringData false -- Already Exists In Scene? (11)
              append DYNmxPointStrings LOCmxStringData
            )
            if LOCtagElementData[1] == "TagTwelveDElementInfo" then
            (
              local LOC12dStringData = DYNFUNreadTagTwelveDElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOC12dStringData false -- selected for import? (8)
              append LOC12dStringData LOCrootElementData[3]
              append LOC12dStringData false -- Already Exists In Scene? (10)
              append DYN12dPointStrings LOC12dStringData
            )
          )
        )


        --- If Element Was a Shape                -------------------------------------------------------
        if LOCrootElementData[1] == "Shape" then
        (
          local LOCelemArray = DYNFUNreadElemShape LOCfileStream LOCrootElementData[3] LOCrootElementData[5]

          for ii = 1 to LOCrootElementData[4] do
          (
            local LOCtagElementData = DYNFUNreadElementHeader LOCfileStream

            if LOCtagElementData[1] == "TagXmlElementInfo" then
            (
              local LOCxmlStringData = DYNFUNreadTagXmlElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCxmlStringData false -- selected for import? (10)
              append LOCxmlStringData LOCrootElementData[3]
              append LOCxmlStringData false -- Already Exists In Scene? (12)
              append DYNxmlShapeStrings LOCxmlStringData
            )
            if LOCtagElementData[1] == "TagMxElementInfo" then
            (
              local LOCmxStringData = DYNFUNreadTagMxElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCmxStringData false -- selected for import? (9)
              append LOCmxStringData LOCrootElementData[3]
              append LOCmxStringData false -- Already Exists In Scene? (11)
              append DYNmxShapeStrings LOCmxStringData
            )
            if LOCtagElementData[1] == "TagTwelveDElementInfo" then
            (
              local LOC12dStringData = DYNFUNreadTagTwelveDElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOC12dStringData false -- selected for import? (8)
              append LOC12dStringData LOCrootElementData[3]
              append LOC12dStringData false -- Already Exists In Scene? (10)
              append DYN12dShapeStrings LOC12dStringData
            )


            if LOCtagElementData[1] == "TagCivil3DCorridorFeatureLine" then
            (
              local LOCcflData = DYNFUNreadTagCivil3DCorridorFeatureLine LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCcflData LOCelemArray[2]
              append LOCcflData false -- selected for import? (16)
              append LOCcflData LOCrootElementData[3]
              append LOCcflData false -- Already Exists In Scene? (18)
              append DYNc3dCorridorFeatureLines LOCcflData
            )

            if LOCtagElementData[1] == "TagCivil3DCorridorBaseLine" then
            (
              local LOCbaselineData = DYNFUNreadTagCivil3DCorridorBaseLine LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCbaselineData false -- selected for import? (19)
              append LOCbaselineData LOCrootElementData[3]
              append LOCbaselineData false -- Already Exists In Scene? (21)
              append DYNc3dCorridorBaselines LOCbaselineData

              for iii = 1 to LOCbaselineData[16] do
              (
                local LOCsubTagElementData = DYNFUNreadElementHeader LOCfileStream

                if LOCsubTagElementData[1] == "TagCivil3DCorridorRegion" then
                (
                  local LOCregionData = DYNFUNreadTagCivil3DCorridorRegion LOCfileStream LOCsubTagElementData[3] LOCsubTagElementData[5]
                  append LOCregionData LOCbaselineData[11] -- Add Corridor Handle to Region Definition
                  append LOCregionData LOCbaselineData[3] -- Add BaselineIndex to Region Definition
                  append DYNc3dCorridorRegions LOCregionData
                )
              )
            )
          )
        )

        --- If Element Was a TriMesh Element Type --------------------------------------------------------
        if LOCrootElementData[1] == "TriangleMesh" then
        (
          local LOCelemArray = DYNFUNreadElemTriangleMesh LOCfileStream LOCrootElementData[3] LOCrootElementData[5]

          for ii = 1 to LOCrootElementData[4] do
          (
            local LOCtagElementData = DYNFUNreadElementHeader LOCfileStream

            if LOCtagElementData[1] == "TagMxElementInfo" then
            (
              local LOCmxStringData = DYNFUNreadTagMxElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCmxStringData false -- selected for import? (9)
              append LOCmxStringData LOCrootElementData[3]
              append LOCmxStringData false -- Already Exists In Scene? (11)
              append LOCmxStringData LOCrootElementData[4] -- number of tags (12)
              append LOCmxStringData LOCrootElementData[5] -- stop (13)
              append DYNmxSurfaceStrings LOCmxStringData
            )
            if LOCtagElementData[1] == "TagTwelveDElementInfo" then
            (
              local LOC12dStringData = DYNFUNreadTagTwelveDElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOC12dStringData false -- selected for import? (8)
              append LOC12dStringData LOCrootElementData[3]
              append LOC12dStringData false -- Already Exists In Scene? (10)
              append LOC12dStringData LOCrootElementData[4] -- number of tags (11)
              append LOC12dStringData LOCrootElementData[5] -- stop (12)
              append DYN12dSurfaceStrings LOC12dStringData
            )
            if LOCtagElementData[1] == "TagXmlElementInfo" then
            (
              local LOCxmlStringData = DYNFUNreadTagXmlElementInfo LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCxmlStringData false -- selected for import? (10)
              append LOCxmlStringData LOCrootElementData[3]
              append LOCxmlStringData false -- Already Exists In Scene? (12)
              append LOCxmlStringData LOCrootElementData[4] -- number of tags (13)
              append LOCxmlStringData LOCrootElementData[5] -- stop (14)
              append DYNxmlSurfaceStrings LOCxmlStringData
            )

            if LOCtagElementData[1] == "TagCivil3DSurface" then
            (
              local LOCsurfData = DYNFUNreadTagCivil3DSurface LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCsurfData LOCelemArray[1]
              append LOCsurfData LOCrootElementData[4]
              append LOCsurfData false -- selected for import? (12)
              append LOCsurfData LOCrootElementData[3]
              append LOCsurfData LOCrootElementData[5]
              append LOCsurfData false -- Already Exists In Scene? (15)
              append DYNc3dSurfaces LOCsurfData
            )

            if LOCtagElementData[1] == "TagCivil3DCorridorSurface" then
            (
              local LOCsurfData = DYNFUNreadTagCivil3DCorridorSurface LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              append LOCsurfData LOCelemArray[2]
              append LOCsurfData LOCelemArray[3]
              append LOCsurfData LOCrootElementData[4]
              append LOCsurfData false -- selected for import? (21)
              append LOCsurfData LOCrootElementData[3]
              append LOCsurfData LOCrootElementData[5]
              append LOCsurfData false -- Already Exists In Scene? (24)
              append DYNc3dCorridorSurfaces LOCsurfData
            )

            if LOCtagElementData[1] == "TagCivil3DCorridorSurfaceVertexStationsOffsetsElevations" then
            (
              /*
              local LOCcorridorSOEdata    = DYNFUNreadTagCivil3DCorridorSurfaceVertexStationsOffsetsElevations LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              */
            )

            if LOCtagElementData[1] == "TagCivil3DCorridorSurfaceVertexPointCodes" then
            (
              /*
              local LOCcorridorPCODEdata  = DYNFUNreadTagCivil3DCorridorSurfaceVertexPointCodes LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              */
            )

            if LOCtagElementData[1] == "TagMxEdgeReferences" then
            (
              /*
              local LOCmxEdgeReferences = DYNFUNreadTagMxEdgeReferences LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              */
            )

            if LOCtagElementData[1] == "TagCivil3DCorridorSurfaceFaceStatus" then
            (
              /*
              local LOCcorridorFaceStatus = DYNFUNreadTagCivil3DCorridorSurfaceFaceStatus LOCfileStream LOCtagElementData[3] LOCtagElementData[5]
              */
            )

            if LOCtagElementData[1] == "TagCivil3DCorridorSurfaceFaceData" then
            (
              /*
              local LOCcorridorFaceData   = DYNFUNreadTagCivil3DCorridorSurfaceFaceData LOCfileStream LOCtagElementData[3] LOCtagElementData[5] 0
              */
            )
          )
        )
      )
    )

    if not LOCfileFormatFound then
    (
      messagebox (DYNuiResourcesErrorsWarnings[106]) title:DYNuiResourcesTitlebars[1]
      FUNc3dVspFile = undefined
    )

    fClose LOCfileStream                                                                -- CLOSE filestream (c3dVsp File)
  )
  #(FUNc3dVspFile, LOCsrcName, LOCsrcPath, LOCsrcVersion, LOCshiftX, LOCshiftY, LOCshiftZ)  -- return value
)

fn DYNFUNdefineSurfaceSelectionSets FUNsourceCodeArray FUNsubArrayIndex =
(
  /* If FUNsubArrayIndex equals zero, FUNsourceCodeArray entries are assumed not to be nested arrays */
  local LOCarrayOfBitArrays    = #()
  local LOCuniqueCodeArray     = #()

  --- For Each Face or Vertex in Source Info Array, Divide Into Array of Unique Point or Link Codes
  for iii = 1 to FUNsourceCodeArray.count do
  (
    local LOCcurrentItem       = if FUNsubArrayIndex > 0 then FUNsourceCodeArray[iii][FUNsubArrayIndex] else FUNsourceCodeArray[iii]
    local LOCfilteredCodeArray = filterString LOCcurrentItem ","                    -- Convert per face/vertex Delimited String of Codes to Array
    for iiii in LOCfilteredCodeArray do
    (
      if findItem LOCuniqueCodeArray iiii == 0 then append LOCuniqueCodeArray iiii  -- For eaxh code in per face/vertex array, check whether it exists in unique code array. If not, add the code.
    )
  )

  --- For Each Unique Code Found, Create an empty BitArray containing the same number of elements as surface face/vertex count
  for iii in LOCuniqueCodeArray do
  (
    local LOCbitArray          = #{}                                                -- Create Empty BitArray
    LOCbitArray.count          = FUNsourceCodeArray.count                           -- Set the number of items in the empty BitArray to match the number of faces/vertices in surface
    append LOCarrayOfBitArrays LOCbitArray                                          -- Append the empty BitArray to the Array of BitArrays
  )

  --- For Each Face/Vertex, Set flags for each "Unique Code BitArray"
  for iii = 1 to FUNsourceCodeArray.count do
  (
    local LOCcurrentItem       = if FUNsubArrayIndex > 0 then FUNsourceCodeArray[iii][FUNsubArrayIndex] else FUNsourceCodeArray[iii]
    for iiii = 1 to LOCarrayOfBitArrays.count do
    (
      local LOCfilteredCodeArray = filterString LOCcurrentItem ","
      for iiiii in LOCfilteredCodeArray do
      (
        if (stricmp iiiii LOCuniqueCodeArray[iiii]) == 0 then LOCarrayOfBitArrays[iiii][iii] = true
      )
    )
  )

  #(LOCuniqueCodeArray, LOCarrayOfBitArrays) -- return value
)

fn DYNFUNcreateVesperShape FUNfileStream FUNfileOffset FUNshiftXY FUNdataType FUNdataArray FUNvsp3DFile =
(
  local LOCnewShape      = splineshape realWorldMapSize:false
  local LOCshapeData     = DYNFUNreadElemShape FUNfileStream FUNfileOffset 0
  local LOCappDataArray  = DYNFUNgenerateC3DrelatedAppData FUNdataType FUNdataArray
  local LOCstartStation  = 0.0

  local LOCactualShiftX  = rootNode.DYNrootNodeStore.shiftX - FUNshiftXY.x
  local LOCactualShiftY  = rootNode.DYNrootNodeStore.shiftY - FUNshiftXY.y

  --- For Corridor Baselines, set actual Station Station
  if FUNdataType == "TagCivil3DCorridorBaseLine" then
  (
    LOCstartStation = FUNdataArray[17]
  )

  --- Choose Segment and Vertex Type for splines (use smooth curves for 12d Arc and Circle strings)
  local LOCsegmentType   = #line
  local LOCvertexType    = #corner
  if FUNdataType == "TagTwelveDElementInfo" and ((striCmp FUNdataArray[2] "Circle") == 0 or (striCmp FUNdataArray[2] "Arc") == 0) then
  (
    LOCsegmentType   = #curve
    LOCvertexType    = #smooth
  )

  --- Build Shape
  local LOCsplineCnt  = 0
  for i = 1 to LOCshapeData[2] do
  (
    addNewSpline LOCnewShape
    LOCsplineCnt += 1
    local LOCnumVerts = readLong FUNfileStream
    local LOCisClosed = ReadByte FUNfileStream
    for iiii = 1 to LOCnumVerts do
    (
      readLong FUNfileStream                                                      -- int knotType (0 for the moment, not used)
      readLong FUNfileStream                                                      -- int lineType (0 for the moment, not used)
      local LOCpoint = [LOCactualShiftX, LOCactualShiftY, 0.0] + [readFloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream]
      in coordsys world (addknot LOCnewShape LOCsplineCnt LOCvertexType LOCsegmentType LOCpoint) -- Add current Point to correct Spline Index in Current Shape Object
      [readFloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream] -- float invec x, y, z (0,0,0, not used)
      [readFloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream] -- float outvec x, y, z (0,0,0, not used)
    )
    if LOCisClosed == 1 then (close LOCnewShape LOCsplineCnt)
  )

  --- Check that no single point splines exist (should not actually be necessary but added at Civil View 2012)
  for i = (numSplines LOCnewShape) to 1 by -1 do
  (
    if (numKnots LOCnewShape i) == 1 then
    (
      if numSplines LOCnewShape > 1 then
      (
        deleteSpline LOCnewShape i
      )
      else
      (
        addKnot LOCnewShape i LOCvertexType LOCsegmentType [0,0,0]
      )
    )
  )

  --- Set Various Parameters
  LOCnewShape.pivot                 = LOCnewShape.center
  LOCnewShape.baseObject.renderable = false         -- must use .baseObject due to script naming conflict with general renderable property for all objects
  LOCnewShape.displayRenderMesh     = false

  updateShape LOCnewShape

  --- For Shape Geometry derived from MX
  if FUNdataType == "TagMxElementInfo" then
  (
    LOCnewShape.name      = uniqueName (DYNuiResourcesNodeNames[12] + LOCappDataArray[1] + "-")
    LOCnewShape.wirecolor = color FUNdataArray[6] FUNdataArray[7] FUNdataArray[8]
  )

  --- For Shape Geometry derived from MX
  if FUNdataType == "TagTwelveDElementInfo" then
  (
    LOCnewShape.name      = uniqueName (DYNuiResourcesNodeNames[13] + FUNdataArray[1] + "-")
    LOCnewShape.wirecolor = color FUNdataArray[5] FUNdataArray[6] FUNdataArray[7]
  )

  --- For Shape Geometry derived from LandXML
  if FUNdataType == "TagXmlElementInfo" then
  (
    LOCnewShape.name      = uniqueName (DYNuiResourcesNodeNames[32] + (filterString LOCappDataArray[1] "$!!$")[1] + "-")
    LOCnewShape.wirecolor = color FUNdataArray[6] FUNdataArray[7] FUNdataArray[8]
  )

  --- For Shape Geometry derived from Civil 3D
  if FUNdataType != "TagMxElementInfo" and FUNdataType != "TagTwelveDElementInfo" and FUNdataType != "TagXmlElementInfo" then
  (
    if (filterString LOCappDataArray[2] "$!!$")[2] == "12" then
    (
      LOCnewShape.name  = DYNuiResourcesNodeNames[14] + (filterString LOCappDataArray[2] "$!!$")[1] + "-" + LOCappDataArray[1]
      LOCnewShape.wirecolor = color 255 0 0 -- all baselines should be shown in red
    )
    else
    (
      LOCnewShape.name  = DYNuiResourcesNodeNames[15] + (filterString LOCappDataArray[2] "$!!$")[1] + "-" + LOCappDataArray[1]

      /* The following is a temproary arrangement. We need to ultimately use the DYNcivil3dWireExp array, but need a way to compare regex values first */
      local LOCcolor = (color 230 80 130)
      if (matchpattern LOCappDataArray[1] pattern:"ditch*" ignorecase:true) then LOCcolor = (color 175 150 25)
      if (matchpattern LOCappDataArray[1] pattern:"dayli*" ignorecase:true) then LOCcolor = (color 145 225 90)
      if (matchpattern LOCappDataArray[1] pattern:"*curb*" ignorecase:true) then LOCcolor = (color 255 250 50)
      if (matchpattern LOCappDataArray[1] pattern:"pave*"  ignorecase:true) then LOCcolor = (color 155 155 230)
      if (matchpattern LOCappDataArray[1] pattern:"cycle*" ignorecase:true) then LOCcolor = (color 225 85 145)
      if (matchpattern LOCappDataArray[1] pattern:"sidew*" ignorecase:true) then LOCcolor = (color 90 200 225)
      LOCnewShape.wirecolor = LOCcolor
    )
  )

  --- Add AppData
  DYNFUNgenObjAppData LOCnewShape 7 "1" FUNvsp3DFile (DYNFUNgetLocalTime()) (LOCstartStation as string) LOCappDataArray[1] LOCappDataArray[2]

  --- UpdateShape
  updateShape LOCnewShape
  LOCnewShape
)

fn DYNFUNcreateVesperAlignment FUNfileStream FUNshiftXY FUNdataType FUNdataArray FUNvsp3DFile =
(
  local LOCnewShape                  = CivilView_Alignment realWorldMapSize:false

  local LOCshapeData                 = DYNFUNreadElemAlignment FUNfileStream FUNdataArray[20] 0
  local LOCappDataArray              = DYNFUNgenerateC3DrelatedAppData FUNdataType FUNdataArray

  local LOCactualShiftX              = rootNode.DYNrootNodeStore.shiftX - FUNshiftXY.x
  local LOCactualShiftY              = rootNode.DYNrootNodeStore.shiftY - FUNshiftXY.y

  local LOCdesignSpeedArray          = FUNdataArray[18]

  local LOCnumAlignVerts             = LOCshapeData[5]
  local LOCnumProfileVerts           = 0; for i in FUNdataArray[24] do LOCnumProfileVerts += i

  local LOCsegmentType               = #line
  local LOCvertexType                = #corner

  local LOCXYZStationArray           = #(); LOCXYZStationArray.count           = LOCnumAlignVerts + LOCnumProfileVerts
  local LOCradBearGradeArray         = #(); LOCradBearGradeArray.count         = LOCnumAlignVerts + LOCnumProfileVerts
  local LOCalignEntTypeArray         = #(); LOCalignEntTypeArray.count         = LOCnumAlignVerts + LOCnumProfileVerts
  local LOCprofileEntTypeArray       = #(); LOCprofileEntTypeArray.count       = LOCnumAlignVerts + LOCnumProfileVerts
  local LOCisAlignEntStartEndArray   = #(); LOCisAlignEntStartEndArray.count   = LOCnumAlignVerts + LOCnumProfileVerts
  local LOCisProfileEntStartEndArray = #(); LOCisProfileEntStartEndArray.count = LOCnumAlignVerts + LOCnumProfileVerts

  /*
  DatasetNameArray and DatasetSizeArray sizes should be : (Alignment + Number Of Profiles)
  Alignment related data in first index of these arrays can be set now.
  */
  local LOCdatasetNameArray          = #()
  local LOCdatasetSizeArray          = #()
  LOCdatasetNameArray.count          = 1 + FUNdataArray[24].count; LOCdatasetNameArray[1] = LOCshapeData[1]
  LOCdatasetSizeArray.count          = 1 + FUNdataArray[24].count; LOCdatasetSizeArray[1] = LOCnumAlignVerts

  --- Build Shape
  for i = 1 to LOCnumAlignVerts do
  (
    /*
    The repeated point records consist of:
    --------------------------------------------------------------------
      float X
      float Y
      float Z (DefaultZ only)

      float Station/Chainage
      float Alignment Radius
      float Bearing
      int SubEntType (arc:1, line:2, spiral:3)
      bool IsSubEntStartOrEnd
    --------------------------------------------------------------------
    */
    local LOCpoint                  = [LOCactualShiftX, LOCactualShiftY, 0.0] + [readFloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream]

    LOCXYZStationArray[i]           = [LOCpoint.x, LOCpoint.y, LOCpoint.z, readFloat FUNfileStream] -- [x, y, z, station]
    LOCradBearGradeArray[i]         = [readFloat FUNfileStream, readFloat FUNfileStream, 0.0, 0.0]  -- [AlignRadius, AlignBearing, profileRadius, ProfileGrade]
    LOCalignEntTypeArray[i]         = readLong FUNfileStream                                        -- SubEntityType (arc:1, line:2, spiral:3)
    LOCprofileEntTypeArray[i]       = 0                                                             -- EntityType (Circular:1, Tangent:2, PAsym:3, PSym:4)
    LOCisAlignEntStartEndArray[i]   = if (readByte FUNfileStream) == 1 then true else false         -- IsSubEntityStartOrEnd
    LOCisProfileEntStartEndArray[i] = false
  )

  --- Read Profile Data (if any Profiles Exist)
  local LOCcnt = LOCnumAlignVerts
  for iii = 1 to FUNdataArray[23].count do
  (
    local LOCprofileData         = DYNFUNreadTagCivil3DProfile FUNfileStream FUNdataArray[23][iii] 0

    LOCdatasetNameArray[iii + 1] = LOCprofileData[1] -- Name of profile
    LOCdatasetSizeArray[iii + 1] = LOCprofileData[7] -- Number of points in profile

    for i = (LOCcnt + 1) to (LOCcnt + LOCprofileData[7]) do
    (
      local LOCpoint                  = [LOCactualShiftX, LOCactualShiftY, 0.0] + [readFloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream]
      local LOCstation                = readFloat FUNfileStream                -- float station
      local LOCalignRadius            = readFloat FUNfileStream                -- float Alignment Radius
      local LOCalignBearing           = readFloat FUNfileStream                -- float AlignmentBearing
      local LOCalignEntType           = readLong  FUNfileStream                -- int AlignmentSubEntType (arc:1, line:2, spiral:3)
      local LOCIsAlignTang            = readByte  FUNfileStream                -- bool IsAlignmentSubEntStartOrEnd
      local LOCvertRadius             = readFloat FUNfileStream                -- float Profile Radius
      local LOCvertGrade              = readFloat FUNfileStream                -- float Grade
      local LOCvertEntType            = readLong  FUNfileStream                -- int EntType (Circular:1, Tangent:2, PAsym:3, PSym:4)
      local LOCIsVertTang             = readByte  FUNfileStream                -- bool IsEntStartOrEnd

      LOCXYZStationArray[i]           = [LOCpoint.x, LOCpoint.y, LOCpoint.z, LOCstation] -- [x, y, z, station]
      LOCradBearGradeArray[i]         = [LOCalignRadius, LOCalignBearing, LOCvertRadius, LOCvertGrade]
      LOCalignEntTypeArray[i]         = LOCalignEntType
      LOCprofileEntTypeArray[i]       = LOCvertEntType
      LOCisAlignEntStartEndArray[i]   = if LOCIsAlignTang == 1 then true else false
      LOCisProfileEntStartEndArray[i] = if LOCIsVertTang  == 1 then true else false
    )
    LOCcnt += LOCprofileData[7]
  )

  --- Add Design Speed Data
  local LOCdesignSpeedStationArray   = #(); LOCdesignSpeedStationArray.count  = LOCdesignSpeedArray.count
  local LOCdesignSpeedValueArray     = #(); LOCdesignSpeedValueArray.count    = LOCdesignSpeedArray.count
  local LOCdesignSpeedCommentsArray  = #(); LOCdesignSpeedCommentsArray.count = LOCdesignSpeedArray.count
  for i = 1 to LOCdesignSpeedArray.count do
  (
    LOCdesignSpeedStationArray[i]  = LOCdesignSpeedArray[i][2]
    LOCdesignSpeedValueArray[i]    = LOCdesignSpeedArray[i][3]
    LOCdesignSpeedCommentsArray[i] = LOCdesignSpeedArray[i][4]
  )

  --- Add additional Alignment Data to Alignment Properties
  LOCnewShape.StartStation          = LOCshapeData[3]             -- : float
  LOCnewShape.EndStation            = LOCshapeData[4]             -- : float
  LOCnewShape.CurrentDataset        = if LOCdatasetSizeArray.count >= 2 then 2 else 1

  LOCnewShape.DatasetNameArray      = LOCdatasetNameArray         -- : string array
  LOCnewShape.DatasetSizeArray      = LOCdatasetSizeArray         -- : int array
  LOCnewShape.XYZStationArray       = LOCXYZStationArray          -- : point4 array
  LOCnewShape.RadBearGradeArray     = LOCradBearGradeArray        -- : point4 array
  LOCnewShape.AlignEntTypeArray     = LOCalignEntTypeArray        -- : int array
  LOCnewShape.ProfileEntTypeArray   = LOCprofileEntTypeArray      -- : int array
  LOCnewShape.isAlignEntStartEnd    = LOCisAlignEntStartEndArray  -- : boolean array
  LOCnewShape.isProfileEntStartEnd  = LOCisProfileEntStartEndArray-- : boolean array

  LOCnewShape.designSpeedStations   = LOCdesignSpeedStationArray  -- : float array
  LOCnewShape.designSpeedValues     = LOCdesignSpeedValueArray    -- : float array
  LOCnewShape.designSpeedComments   = LOCdesignSpeedCommentsArray -- : string array

  --- Add Points to Alignment
  addNewSpline LOCnewShape

  local LOCstartRecord = 1
  local LOCendRecord   = LOCnewShape.DatasetSizeArray[1]

  if LOCnewShape.CurrentDataset > 1 then
  (
    /* This means that profile data exists on the imported alignment */
    LOCstartRecord = LOCnewShape.DatasetSizeArray[LOCnewShape.CurrentDataset - 1] + 1
    LOCendRecord   = LOCnewShape.DatasetSizeArray[LOCnewShape.CurrentDataset - 1] + LOCnewShape.DatasetSizeArray[LOCnewShape.CurrentDataset]
  )

  for i = LOCstartRecord to LOCendRecord do
  (
    in coordsys world
    (
      LOCxyzw = LOCnewShape.XYZStationArray[i]
      addknot LOCnewShape 1 LOCvertexType LOCsegmentType [LOCxyzw.x, LOCxyzw.y, LOCxyzw.z]
    )
  )

  --- Check that no single point splines exist (should not actually be necessary but added at Civil View 2012)
  if (numKnots LOCnewShape 1) == 1 then
  (
    addKnot LOCnewShape 1 LOCvertexType LOCsegmentType [0,0,0]
  )

  --- Set Various Parameters
  LOCnewShape.pivot = LOCnewShape.center
  LOCnewShape.baseObject.delegate.renderable = false         -- must use .baseObject due to script naming conflict with general renderable property for all objects
  LOCnewShape.baseObject.delegate.displayRenderMesh = false

  updateShape LOCnewShape

  --- Set Name Of New SHape
  if FUNdataType == "TagMxElementInfo" then
  (
    /* Shape Geometry was derived from MX */
    LOCnewShape.name      = uniqueName (DYNuiResourcesNodeNames[12] + FUNdataArray[1] + "-")
    LOCnewShape.wirecolor = color FUNdataArray[6] FUNdataArray[7] FUNdataArray[8]
  )
  if FUNdataType == "TagTwelveDElementInfo" then
  (
    /* Shape Geometry was derived from MX */
    LOCnewShape.name      = uniqueName (DYNuiResourcesNodeNames[13] + FUNdataArray[1] + "-")
    LOCnewShape.wirecolor = color FUNdataArray[5] FUNdataArray[6] FUNdataArray[7]
  )
  if FUNdataType == "TagXmlElementInfo" then
  (
    LOCnewShape.name      = uniqueName (DYNuiResourcesNodeNames[32] + FUNdataArray[1] + "-")
    LOCnewShape.wirecolor = color FUNdataArray[6] FUNdataArray[7] FUNdataArray[8]
  )
  if FUNdataType != "TagMxElementInfo" and FUNdataType != "TagTwelveDElementInfo" and FUNdataType != "TagXmlElementInfo" then
  (
    /* Shape Geometry was derived from Civil 3D */
    LOCnewShape.name      = uniqueName (DYNuiResourcesNodeNames[16] + FUNdataArray[1] + "-")
    LOCnewShape.wirecolor = color 255 0 0 -- all alignments should be shown in red
  )

  --- Add AppData
  DYNFUNgenObjAppData LOCnewShape 16 "1" FUNvsp3DFile (DYNFUNgetLocalTime()) (LOCshapeData[3] as string) LOCappDataArray[1] LOCappDataArray[2]

  updateShape LOCnewShape
  LOCnewShape
)

fn DYNFUNcreateVesperPointGroup FUNfileStream FUNfileOffset FUNshiftXY FUNdataType FUNdataArray FUNvsp3DFile FUNupdateSwitch =
(
  local LOCptSys
  local LOCpgDataArray   = #()
  local LOCparticleArray = #()
  local LOCpgPointCount  = 0
  local LOCappDataArray  = DYNFUNgenerateC3DrelatedAppData FUNdataType FUNdataArray
  local LOCactualShiftX  = rootNode.DYNrootNodeStore.shiftX - FUNshiftXY.x
  local LOCactualShiftY  = rootNode.DYNrootNodeStore.shiftY - FUNshiftXY.y

  --- Extract Particle Information Into Array
  if FUNdataType == "TagMxElementInfo" or FUNdataType == "TagTwelveDElementInfo" or FUNdataType == "TagXmlElementInfo" then
  (
    LOCpgDataArray  = DYNFUNreadElemPoints3D FUNfileStream FUNfileOffset 0
    LOCpgPointCount = LOCpgDataArray[1]
    LOCparticleArray.count = LOCpgPointCount
    for i = 1 to LOCpgPointCount do
    (
      local LOCxyz        = [LOCactualShiftX, LOCactualShiftY, 0.0] + [readfloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream]
      LOCparticleArray[i] = #(LOCxyz, 0.0, i)
    )
  )
  else
  (
    LOCpgDataArray  = DYNFUNreadElemCivil3DPointGroup FUNfileStream FUNfileOffset 0
    LOCpgPointCount = LOCpgDataArray[4]
    LOCparticleArray.count = LOCpgPointCount
    for i = 1 to LOCpgPointCount do
    (
      local LOCxyz        = [LOCactualShiftX, LOCactualShiftY, 0.0] + [readfloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream]
      local LOCrot        = readFloat FUNfileStream -- Rotation
      local LOCptID       = readLong FUNfileStream  -- Point Number
      DYNFUNreadBinString FUNfileStream             -- Point Name
      DYNFUNreadBinString FUNfileStream             -- Point Desc
      LOCparticleArray[i] = #(LOCxyz, LOCrot, LOCptID)
    )
  )

  --- Create Particle System
  if FUNupdateSwitch then
  (
    LOCptSys = DYNFUNcreatePointSystemBirthAction LOCparticleArray  -- if this is an existing Point System which is being updated, only generate the Birth Action Helper
  )
  else
  (
    LOCptSys = DYNFUNcreatePointSystem LOCparticleArray (color 200 225 90) undefined -- if this is a new point system, generate the full particle system node
  )

  --- Add AppData To Surface
  DYNFUNgenObjAppData LOCptSys 14 LOCpgPointCount FUNvsp3DFile (DYNFUNgetLocalTime()) "" LOCappDataArray[1] LOCappDataArray[2]

  --- Create Point System Object -----------------------------------------------------------------------------
  if LOCpgPointCount > 0 then
  (
    if superClassOf LOCptSys == GeometryClass then -- don't call this if an existing point system is being updated
    (
      if FUNdataType == "TagMxElementInfo" then
      (
        LOCptSys.name = uniqueName (DYNuiResourcesNodeNames[17] + LOCappDataArray[1] + "-")
      )
      if FUNdataType == "TagTwelveDElementInfo" then
      (
        LOCptSys.name = uniqueName (DYNuiResourcesNodeNames[18] + LOCappDataArray[1] + "-")
      )
      if FUNdataType == "TagXmlElementInfo" then
      (
        LOCptSys.name = uniqueName (DYNuiResourcesNodeNames[33] + (filterString LOCappDataArray[1] "$!!$")[1] + "-")
      )
      if FUNdataType != "TagMxElementInfo" and FUNdataType != "TagTwelveDElementInfo" and FUNdataType != "TagXmlElementInfo" then
      (
        LOCptSys.name = DYNuiResourcesNodeNames[19] + (filterString LOCappDataArray[2] "$!!$")[1] + "-" + LOCappDataArray[1]
      )

      LOCptSys.pivot  = LOCparticleArray[1][1]
      LOCptSys.displayByLayer = false
    )
  )
  else
  (
    local LOCpgElemName
    if FUNdataType == "TagMxElementInfo" or FUNdataType == "TagTwelveDElementInfo" or FUNdataType == "TagXmlElementInfo" then
    (
      LOCpgElemName = LOCappDataArray[1]
    )
    else
    (
      LOCpgElemName = LOCpgDataArray[1]
    )
    messagebox (DYNuiResourcesErrorsWarnings[107] + "\n\n" + LOCpgElemName) title:DYNuiResourcesTitlebars[1] beep:false
  )

  --- Finish Off
  LOCptSys -- return value
)

fn DYNFUNcreateVesperPipeNetwork FUNfileStream FUNfileOffset FUNshiftXY FUNdataType FUNdataArray FUNvsp3DFile  =
(
  local LOCpipeNetPartArray = #()
  local LOCpgDataArray      = DYNFUNreadElemCivil3DPipeNetwork FUNfileStream FUNfileOffset 0
  local LOCpipeNetworkName  = LOCpgDataArray[1]
  local LOCappDataArray     = DYNFUNgenerateC3DrelatedAppData FUNdataType FUNdataArray
  local LOCactualShiftX     = rootNode.DYNrootNodeStore.shiftX - FUNshiftXY.x
  local LOCactualShiftY     = rootNode.DYNrootNodeStore.shiftY - FUNshiftXY.y
  local LOCpipeNetColor     = random (color 35 35 225) (color 225 225 35)

  --- Extract Pipes Into Array
  local LOCpipeArray = #(); LOCpipeArray.count = LOCpgDataArray[4]
  for i = 1 to LOCpgDataArray[4] do
  (
    local LOCpipeName        = DYNFUNreadBinString FUNfileStream -- string Name
    local LOCdisplayName     = DYNFUNreadBinString FUNfileStream -- string DisplayName
    local LOCdescription     = DYNFUNreadBinString FUNfileStream -- string Description
    local LOCpartDesc        = DYNFUNreadBinString FUNfileStream -- string PartDescription
    local LOCpartSizeName    = DYNFUNreadBinString FUNfileStream -- string PartSizeName
    local LOCpartSubType     = DYNFUNreadBinString FUNfileStream -- string PartSubType
    local LOCstartStructure  = DYNFUNreadBinString FUNfileStream -- string StartStructureHandle
    local LOCendStructure    = DYNFUNreadBinString FUNfileStream -- string EndStructureHandle
    local LOChorType         = readLong FUNfileStream  -- int HORType             - "Hold on resize" Type (Centerline = 0; Crown = 1; Invert = 2)  [irrelevant to Civil View]
    local LOCpseType         = readLong FUNfileStream  -- int PSEType             - (Curved = 0; Flex = 1; Segmented = 2; Straight = 3)
    local LOCflowDirection   = readLong FUNfileStream  -- int FlowDirection       - (Bidirectional = 0; EndToStart = 1; StartToEnd = 2;
    local LOCflowDirMethod   = readLong FUNfileStream  -- int FlowDirectionMethod - (Bidirectional = 0; BySlope = 1; EndToStart = 2; StartToEnd = 3)
    local LOCxShape          = readLong FUNfileStream  -- int CrossSectionalShape - (Undefined = 0; Arched = 1; Circular = 2; CustomShape = 3; EggShaped = 4; Elliptical = 5; HorizontalElliptical = 6; Rectangular = 7)
    local LOCxs              = readFloat FUNfileStream -- float StartPointX
    local LOCys              = readFloat FUNfileStream -- float StartPointY
    local LOCzs              = readFloat FUNfileStream -- float StartPointZ (always centre of pipe)
    local LOCxe              = readFloat FUNfileStream -- float EndPointX
    local LOCye              = readFloat FUNfileStream -- float EndPointY
    local LOCze              = readFloat FUNfileStream -- float EndPointZ   (always centre of pipe)
    local LOCpathBearing     = readFloat FUNfileStream -- float (straight line) bearing
    local LOCpathRadius      = readFloat FUNfileStream -- float Radius
    local LOCslope           = readFloat FUNfileStream -- float Slope
    local LOCinnerWidth      = readFloat FUNfileStream -- float InnerDiameterOrWidth
    local LOCinnerHeight     = readFloat FUNfileStream -- float InnerHeight
    local LOCouterWidth      = readFloat FUNfileStream -- float OuterDiameterOrWidth
    local LOCouterHeight     = readFloat FUNfileStream -- float OuterHeight
    local LOCminCover        = readFloat FUNfileStream -- float MinimumCover
    local LOCmaxCover        = readFloat FUNfileStream -- float MaximumCover
    local LOC2dCentre2Centre = readFloat FUNfileStream -- float Length2DCenterToCenter
    local LOC3dCentre2Centre = readFloat FUNfileStream -- float Length3DCenterToCenter
    local LOC2dToInsideEdge  = readFloat FUNfileStream -- float Length2DToInsideEdge
    local LOC3dToInsideEdge  = readFloat FUNfileStream -- float Length3DToInsideEdge

    local LOCxyz1            = [LOCactualShiftX, LOCactualShiftY, 0.0] + [LOCxs, LOCys, LOCzs]
    local LOCxyz2            = [LOCactualShiftX, LOCactualShiftY, 0.0] + [LOCxe, LOCye, LOCze]

    LOCpipeArray[i] = #(LOCxyz1, LOCxyz2, LOCouterWidth, LOCinnerWidth, LOChorType, \
                        LOCpseType, LOCxShape, LOCinnerHeight, LOCouterHeight, LOCpipeName, \
                        LOCpathBearing, LOCpathRadius, LOCpipeNetworkName, LOCdisplayName, LOCdescription, \
                        LOCpartDesc, LOCpartSizeName, LOCpartSubType, LOCstartStructure, LOCendStructure, LOCflowDirection, \
                        LOCflowDirMethod, LOCminCover, LOCmaxCover, LOC2dCentre2Centre, LOC3dCentre2Centre, LOC2dToInsideEdge, \
                        LOC3dToInsideEdge, LOCslope)
  )

  --- Create Pipes for Network
  if LOCpipeArray.count > 0 then
  (
    for i in LOCpipeArray do
    (
      --- Determine Pipe Shape: (Undefined = 0; Arched = 1; Circular = 2; CustomShape = 3; EggShaped = 4; Elliptical = 5; HorizontalElliptical = 6; Rectangular = 7) */
      local LOCpipeShape = undefined
      if i[7] == 0 then LOCpipeShape = undefined  -- Undefined               :
      if i[7] == 1 then LOCpipeShape = undefined  -- Arched                  :
      if i[7] == 2 then LOCpipeShape = 6          -- Circular                : pipe (circular)
      if i[7] == 3 then LOCpipeShape = undefined  -- Custom Shape            :
      if i[7] == 4 then LOCpipeShape = 11         -- Egg Shaped              : egg
      if i[7] == 5 then LOCpipeShape = 12         -- Elliptical              : ellipse
      if i[7] == 6 then LOCpipeShape = 12         -- Horizontal Elliptical   : ellipse
      if i[7] == 7 then LOCpipeShape = 9          -- Rectangular             : tube (rectangular)

      --- If LOCpipeShape is "0" then pipe shape is either undefined or not supported, in which case we do not build the pipe
      if LOCpipeShape != undefined then
      (
        --- Create Spline To Represent the Path of the Pipe
        -- Create SplineShape to represent pipe path
        local LOCnewShape    = CivilView_Pipe realWorldMapSize:false
        addNewSpline LOCnewShape

        -- Set Knot and Segment Types depending on whether Pipe Path is Straight or Curved
        local LOCknotType    = if i[6] == 0 then #smooth else #corner
        local LOCsegmentType = if i[6] == 0 then #curve  else #line

        -- Add Start Point of Pipe to Spline
        in coordsys world (addknot LOCnewShape 1 LOCknotType LOCsegmentType i[1])

        -- Add Mid Point to spline (for curved pipes only)
        if i[6] == 0 then /* PSEtype [Curved = 0; Flex = 1; Segmented = 2; Straight = 3] */
        (
          -- Calculate Straight Line Vector Between Start and End Point Of Curve
          local LOCcircleRadius    = i[12]
          local LOCchordXyStart    = [i[1].x, i[1].y]
          local LOCchordXyEnd      = [i[2].x, i[2].y]
          local LOCchordLength     = length (LOCchordXyEnd - LOCchordXyStart)
          local LOCchordXyMid      = [i[1].x, i[1].y] + ((LOCchordXyEnd - LOCchordXyStart) / 2.0)
          local LOCchordUnitVector = normalize (LOCchordXyEnd - LOCchordXyStart)

          -- Calculate Whether Curve Goes Left or Goes Right (Clockwise or Anticlockwise)
          local LOCbearingOfCurveAtStartPt   = DYNFUNacadBearingToWCB  (radtodeg i[11])
          local LOCbearingStraightToEndPt    = acos(dot [0.0,1.0,0.0] (normalize (i[2] - i[1])))
          LOCbearingStraightToEndPt          = if LOCchordUnitVector.x < 0.0 then (360.0 - LOCbearingStraightToEndPt) else LOCbearingStraightToEndPt
          local LOCcurveLeftOrRight          = if LOCbearingStraightToEndPt < LOCbearingOfCurveAtStartPt then 1.0 else -1.0

          -- Calculate 2D Mid-Point Of Curve
          local LOCchordOffsetToCircleCentre = sqrt ((pow LOCcircleRadius 2) - ((pow LOCchordLength 2) / 4))
          local LOCchordOffsetToCircleCircum = abs(LOCcircleRadius) - abs(LOCchordOffsetToCircleCentre)
          local LOCchordToCircumUnitVector   = [LOCchordUnitVector.y, -LOCchordUnitVector.x]
          local LOCchordToCircumActualVector = LOCchordToCircumUnitVector * LOCchordOffsetToCircleCircum
          local LOCmidPoint2d                = LOCchordXyMid + (LOCchordToCircumActualVector * LOCcurveLeftOrRight)

          -- Calculate Elevation (Z-axis) of Mid-Point of Curve
          local LOCmidPointZ  = ((i[2].z - i[1].z) / 2.0) + i[1].z

          -- Add Mid-Point of Curve to Spline
          in coordsys world (addknot LOCnewShape 1 LOCknotType LOCsegmentType [LOCmidPoint2d.x, LOCmidPoint2d.y, LOCmidPointZ])
        )

        -- Add End Point of Pipe to Spline
        in coordsys world (addknot LOCnewShape 1 LOCknotType LOCsegmentType i[2])
        updateShape LOCnewShape

        --- Add Parameters to Extended SplineShape
        LOCnewShape.DisplayName            = i[14]
        LOCnewShape.Description            = i[15]
        LOCnewShape.PartDescription        = i[16]
        LOCnewShape.PartSizeName           = i[17]
        LOCnewShape.PartSubType            = i[18]
        LOCnewShape.StartStructureHandle   = i[19]
        LOCnewShape.EndStructureHandle     = i[20]

        LOCnewShape.HORType                = i[5]
        LOCnewShape.PSEType                = i[6]
        LOCnewShape.FlowDirection          = i[21]
        LOCnewShape.FlowDirectionMethod    = i[22]
        LOCnewShape.CrossSectionalShape    = i[7]

        LOCnewShape.Bearing                = DYNFUNacadBearingToWCB (radtodeg i[11])
        LOCnewShape.Radius                 = i[12]
        LOCnewShape.Slope                  = i[29]
        LOCnewShape.InnerDiameterOrWidth   = i[4]
        LOCnewShape.InnerHeight            = i[8]
        LOCnewShape.OuterDiameterOrWidth   = i[3]
        LOCnewShape.OuterHeight            = i[9]
        LOCnewShape.MinimumCover           = i[23]
        LOCnewShape.MaximumCover           = i[24]
        LOCnewShape.Length2DCenterToCenter = i[25]
        LOCnewShape.Length3DCenterToCenter = i[26]
        LOCnewShape.Length2DToInsideEdge   = i[27]
        LOCnewShape.Length3DToInsideEdge   = i[28]

        --- Add Sweep Modifier to determine the shape or profile of the pipe
        addmodifier LOCnewShape (sweep currentBuiltInShape:LOCpipeShape)
        nodeinvalrect LOCnewShape

        /*
        ---------------- Sweep Modifier Parameters ---------------------
        .Shapes : maxObject array
        .UnionIntersections (Union_Intersections) : boolean
        .CustomShapeName (Custom_Shape_Name) : string
        .CurrentBuiltInShape (Current_Built_In_Shape) : index
        .CustomShape (Custom_Shape) : radiobtnIndex
        .MirrorXZPlane (Mirror_On_XZ_Plane) : boolean
        .MirrorXYPlane (Mirror_On_XY_Plane) : boolean
        .XOffset (X_Offset) : float
        .YOffset (Y_Offset) : float
        .Angle : angle
        .GenerateMappingCoords (Generate_Mapping_Coords) : boolean
        .realWorldMapSize (Real_World_Map_Size) : boolean
        .GenMatIDs (Generate_Material_IDs) : boolean
        .UseSectionIDs (Use_Shape_IDs) : boolean
        .UsePathIDs (Use_Path_IDs) : boolean
        .PivotAlignment (Pivot_Alignment) : integer
        .SmoothSection (Smooth_Section) : boolean
        .SmoothPath (Smooth_Path) : boolean
        .Banking : boolean
        .AssignCSType (AssignCustomSectionType) : radiobtnIndex

        ---------------- Sweep Modifier Built-In Sections --------------
        1  - Angle
        2  - Bar
        3  - Channel
        4  - Cylinder
        5  - Half Round
        6  - Pipe              .modifiers[#Sweep][#Pipe_Section]      .modifiers[#Sweep].shapes[7]
        7  - Quarter Round
        8  - Tee
        9  - Tube              .modifiers[#Sweep][#Tube_Section]      .modifiers[#Sweep].shapes[10]
        10 - Wide Flange
        11 - Egg               .modifiers[#Sweep][#Egg_Section]       .modifiers[#Sweep].shapes[12]
        12 - Ellipse           .modifiers[#Sweep][#Ellipse_Section]   .modifiers[#Sweep].shapes[13]
        ----------------------------------------------------------------
        */

        -- For Circular Pipes
        if LOCpipeShape == 6 then
        (
          (CVGetMod LOCnewShape sweep).shapes[7].radius           = i[3] * 0.5 -- outer radius
          (CVGetMod LOCnewShape sweep).shapes[7].pipe_thickness   = (i[3] - i[4]) * 0.5
        )

        -- For Rectangular Pipes
        if LOCpipeShape == 9 then
        (
          (CVGetMod LOCnewShape sweep).shapes[10].length           = i[9] -- outer length
          (CVGetMod LOCnewShape sweep).shapes[10].width            = i[3]
          (CVGetMod LOCnewShape sweep).shapes[10].wrect_thickness  = (i[3] - i[4]) * 0.5
          (CVGetMod LOCnewShape sweep).shapes[10].cornerRadius1    = 0.0
          (CVGetMod LOCnewShape sweep).shapes[10].cornerRadius2    = 0.0
        )

        -- For Egg-Shaped Pipes  (inner face of pipe is true egg shape using following solution)
        if LOCpipeShape == 11 then
        (
          (CVGetMod LOCnewShape sweep).shapes[12].egg_length        = i[8] -- inner length
          (CVGetMod LOCnewShape sweep).shapes[12].egg_width         = i[4]
          (CVGetMod LOCnewShape sweep).shapes[12].egg_angle         = 180.0
          (CVGetMod LOCnewShape sweep).shapes[12].egg_outline       = true
          (CVGetMod LOCnewShape sweep).shapes[12].egg_thickness     = (i[3] - i[4]) * 0.5
        )

        -- For Elliptical Pipes  (inner face of pipe is true ellipse shape using following solution)
        if LOCpipeShape == 12 then
        (
          (CVGetMod LOCnewShape sweep).shapes[13].length            = i[8] -- inner length
          (CVGetMod LOCnewShape sweep).shapes[13].width             = i[4]
          (CVGetMod LOCnewShape sweep).shapes[13].ellipse_thickness = (i[3] - i[4]) * 0.5
          (CVGetMod LOCnewShape sweep).shapes[13].ellipse_outline   = true
        )

        -- Set up names and wirecolors, etc
        LOCnewShape.name = DYNuiResourcesNodeNames[20] + LOCpipeNetworkName + "-" + i[10]
        LOCnewShape.wirecolor = LOCpipeNetColor

        --- Apply AppData to Pipe
        local LOCpipeAppDataArray = DYNFUNgenerateC3DrelatedAppData "Civil3DPipeNetworkPipe" i
        DYNFUNgenObjAppData LOCnewShape 15 LOCpgDataArray[4] FUNvsp3DFile (DYNFUNgetLocalTime()) "" LOCpipeAppDataArray[1] LOCpipeAppDataArray[2]

        --- Add Pipe to Pipe Network Parts Array
        append LOCpipeNetPartArray LOCnewShape
      )
    )
  )


  --- Extract Structures Into Array
  local LOCstructureArray = #(); LOCstructureArray.count = LOCpgDataArray[5]
  for i = 1 to LOCpgDataArray[5] do
  (
    local LOCname            = DYNFUNreadBinString FUNfileStream  -- string Name
    local LOCdisplayName     = DYNFUNreadBinString FUNfileStream  -- string DisplayName
    local LOCnetworkName     = DYNFUNreadBinString FUNfileStream  -- string NetworkName
    local LOCnetworkID       = DYNFUNreadBinString FUNfileStream  -- string NetworkId
    local LOCcover           = DYNFUNreadBinString FUNfileStream  -- string Cover
    local LOCframe           = DYNFUNreadBinString FUNfileStream  -- string Frame
    local LOCgrate           = DYNFUNreadBinString FUNfileStream  -- string Grate
    local LOCmaterialName    = DYNFUNreadBinString FUNfileStream  -- string Material
    local LOCpartDefId       = DYNFUNreadBinString FUNfileStream  -- string PartDefId
    local LOCpartDesc        = DYNFUNreadBinString FUNfileStream  -- string PartDescription
    local LOCpartSizeName    = DYNFUNreadBinString FUNfileStream  -- string PartSizeName
    local LOCpartSubType     = DYNFUNreadBinString FUNfileStream  -- string PartSubType
    local LOCboundingShape   = readLong FUNfileStream             -- int BoundingShape (Undefined = 0; Box = 1; Cylinder = 2; Sphere = 3)
    local LOCconnPartsCnt    = readLong FUNfileStream             -- int ConnectedPartCount
    local LOCconnPipesCnt    = readLong FUNfileStream             -- int ConnectedPipesCount
    local LOCpartType        = readLong FUNfileStream             -- int PartType (UndefinedPartType = 0; Channel = 1; Conduit = 2; Pipe = 3; StructEquipment = 4; StructGeneral = 5; StructInletOutlet = 6; StructJunction = 7; StructNull = 8; Wire = 9)
    local LOCx               = readFloat FUNfileStream            -- float PositionX
    local LOCy               = readFloat FUNfileStream            -- float PositionY
    local LOCz               = readFloat FUNfileStream            -- float PositionZ
    local LOCrotation        = readFloat FUNfileStream            -- float Rotation
    local LOCheight          = readFloat FUNfileStream            -- float Height
    local LOCframeHeight     = readFloat FUNfileStream            -- float FrameHeight
    local LOCframeDiameter   = readFloat FUNfileStream            -- float FrameDiameter
    local LOCwallThickness   = readFloat FUNfileStream            -- float WallThickness
    local LOCfloorThickness  = readFloat FUNfileStream            -- float FloorThickness
    local LOCconeHeight      = readFloat FUNfileStream            -- float ConeHeight
    local LOCrimElevation    = readFloat FUNfileStream            -- float RimElevation
    local LOCrimToSumpHeight = readFloat FUNfileStream            -- float RimToSumpHeight
    local LOCsumpDepth       = readFloat FUNfileStream            -- float SumpDepth
    local LOCsumpElevation   = readFloat FUNfileStream            -- float SumpElevation
    local LOCbarrelPipeClear = readFloat FUNfileStream            -- float BarrelPipeClearance
    local LOCouterDiaOrWidth = readFloat FUNfileStream            -- float DiameterOrWidth
    local LOCinnerDiaOrWidth = readFloat FUNfileStream            -- float InnerDiameterOrWidth
    local LOCouterLength     = readFloat FUNfileStream            -- float Length
    local LOCinnerLength     = readFloat FUNfileStream            -- float InnerLength

    local LOCxyz       = [LOCactualShiftX, LOCactualShiftY, 0.0] + [LOCx, LOCy, LOCz]
    LOCstructureArray[i] = #(LOCxyz, LOCouterLength, LOCouterDiaOrWidth, LOCheight, LOCname, LOCrotation, LOCboundingShape, LOCdisplayName, LOCnetworkName, LOCnetworkID, LOCcover, LOCframe, LOCgrate, LOCmaterialName, LOCpartDefId, LOCpartDesc, LOCpartSizeName, LOCpartSubType, LOCconnPartsCnt, LOCconnPipesCnt, LOCpartType, LOCframeHeight, LOCframeDiameter, LOCwallThickness, LOCfloorThickness, LOCconeHeight, LOCrimElevation, LOCrimToSumpHeight, LOCsumpDepth, LOCsumpElevation, LOCbarrelPipeClear, LOCinnerDiaOrWidth, LOCinnerLength)
  )

  --- Create Structures for Network
  if LOCstructureArray.count > 0 then
  (
    for i in LOCstructureArray do
    (
      /*
      i[1]  - xyz
      i[2]  - structure_length
      i[3]  - structure_DiaOrWidth
      i[4]  - structure_height
      i[5]  - name
      i[6]  - rotation
      i[7]  - boundingShape
      i[8]  - displayName
      i[9]  - networkName
      i[10] - networkID
      i[11] - cover
      i[12] - frame
      i[13] - grate
      i[14] - materialName
      i[15] - partDefId
      i[16] - partDesc
      i[17] - partSizeName
      i[18] - partSubType
      i[19] - connPartsCnt
      i[20] - connPipesCnt
      i[21] - partType
      i[22] - frameHeight
      i[23] - frameDiameter
      i[24] - wallThickness
      i[25] - floorThickness
      i[26] - coneHeight
      i[27] - rimElevation
      i[28] - rimToSumpHeight
      i[29] - sumpDepth
      i[30] - sumpElevation
      i[31] - barrelPipeClear
      i[32] - innerDiaOrWidth
      i[33] - innerLength
      */
      --- Get Structure Type
      local LOCstructureType = 2 /* Structure Bounding Shape = (Undefined = 0; Box = 1; Cylinder = 2; Sphere = 3) */
      if i[7] == 0 then LOCstructureType = 0 -- undefined
      if i[7] == 1 then LOCstructureType = 1 -- box
      if i[7] == 2 then LOCstructureType = 2 -- cylinder
      if i[7] == 3 then LOCstructureType = 3 -- sphere

      --- Create Structure Geometry
      local LOCstructure
      if LOCstructureType == 0 then ()                                                    -- undefined
      if LOCstructureType == 1 then (LOCstructure = Civil_Structure position:i[1] type:1) -- box
      if LOCstructureType == 2 then (LOCstructure = Civil_Structure position:i[1] type:2) -- cylinder
      if LOCstructureType == 3 then ()                                                    -- sphere (currently unsupported)

      --- Apply Structure Parameters
      if LOCstructure != undefined then
      (
        LOCstructure.name = DYNuiResourcesNodeNames[21] + LOCpipeNetworkName + "-" + i[5]

        --- Dimensional Parameters
        LOCstructure.structure_widthOrDia = i[3]
        LOCstructure.structure_length     = i[2]
        LOCstructure.structure_height     = i[4]
        LOCstructure.frame_widthOrDia     = i[23]
        LOCstructure.frame_length         = i[23]
        LOCstructure.frame_height         = i[22]
        LOCstructure.cone_widthOrDia      = if (i[23] + i[24]) > i[3] then i[3] else (i[23] + i[24]) -- cone cannot be bigger than structure
        LOCstructure.cone_length          = if (i[23] + i[24]) > i[2] then i[2] else (i[23] + i[24]) -- cone cannot be bigger than structure
        LOCstructure.cone_height          = i[26]
        LOCstructure.floor_thickness      = i[25]
        LOCstructure.wall_thickness       = i[24]
        LOCstructure.rim_thickness        = i[24] * 0.5
        LOCstructure.use_matid            = true
        LOCstructure.mapcoords            = true

        --- Check whether Structure Has Concentric or Eccentric Frame/Rim
        /* The only known way to do this is check whether
        PartSubType (string) is "Eccentric" */
        LOCstructure.concentric_offset_y  = 0.0
        if i[18] == "Eccentric" then
        (
          LOCstructure.concentric_offset_x= (LOCstructure.structure_widthOrDia - LOCstructure.cone_widthOrDia) / 2.0
        )
        else
        (
          LOCstructure.concentric_offset_x= 0.0
        )

        --- Attribute Parameters
        LOCstructure.displayName          = i[8]
        LOCstructure.networkName          = i[9]
        LOCstructure.networkID            = i[10]
        LOCstructure.cover                = i[11]
        LOCstructure.frame                = i[12]
        LOCstructure.grate                = i[13]
        LOCstructure.materialName         = i[14]
        LOCstructure.partDefId            = i[15]
        LOCstructure.partDesc             = i[16]
        LOCstructure.partSizeName         = i[17]
        LOCstructure.partSubType          = i[18]
        LOCstructure.connectedPartCount   = i[19]
        LOCstructure.connectedPipesCount  = i[20]
        LOCstructure.partType             = i[21]
        LOCstructure.barrelPipeClearance  = i[31]

        --- Finalize Things
        LOCstructure.rotation.z_rotation  = radtodeg i[6] -- (convert radians to degrees)
        LOCstructure.wirecolor            = LOCpipeNetColor

        --- Apply AppData to Structure
        local LOCstructureAppDataArray = DYNFUNgenerateC3DrelatedAppData "Civil3DPipeNetworkStructure" i
        DYNFUNgenObjAppData LOCstructure 15 LOCpgDataArray[4] FUNvsp3DFile (DYNFUNgetLocalTime()) "" LOCstructureAppDataArray[1] LOCstructureAppDataArray[2]

        --- Add Structure To Pipe Network Parts Array
        append LOCpipeNetPartArray LOCstructure
      )
    )
  )

  /*
  LOCpipeNetPartArray -- return value
  */

  --- Add Pipes and Structures to a group and apply AppData to the resulting Dummy Helper
  local LOCpipeNet = group LOCpipeNetPartArray
  setGroupOpen LOCpipeNet true

  --- The following line is required to ensure that "isGroupHead $.parent" and
  --- "isOpenGroupHead $.parent" both work regardless of whether the group is open or not.
  --- Therefore overcomes suspected bug in 3ds Max
  for i in LOCpipeNetPartArray do i.parent = LOCpipeNet

  DYNFUNgenObjAppData LOCpipeNet 15 LOCpgDataArray[4] FUNvsp3DFile (DYNFUNgetLocalTime()) "" LOCappDataArray[1] LOCappDataArray[2]
  LOCpipeNet.name = uniqueName (DYNuiResourcesNodeNames[34] + LOCappDataArray[1] + "-")
  LOCpipeNet.displayByLayer = false
  LOCpipeNet -- return value
)

fn DYNFUNcreateVesperSurface FUNfileStream FUNfileOffset FUNnumberTags FUNshiftXY FUNmatID FUNsmoothAngle FUNfileStop FUNhideDiagonalEdges FUNremoveOverShadowed FUNdataType FUNdataArray FUNvsp3DFile =
(
  /* REM: FUNmatID required only for AppData. */
  local LOCmesh
  local LOCcoordArray    = #()
  local LOCtriVertArray  = #()                                                         -- Create vertex array for this surface
  local LOCtriFaceArray  = #()                                                         -- Create faces array for this surface
  local LOCtriMatsArray  = #()                                                         -- Create material ID array for this surface
  local LOCtriTVertArray = #()                                                         -- Create vertex array for this surface
  local LOCtriTFaceArray = #()                                                         -- Create faces array for this surface
  local LOCmeshDataArray = DYNFUNreadElemTriangleMesh FUNfileStream FUNfileOffset 0
  local LOCappDataArray  = DYNFUNgenerateC3DrelatedAppData FUNdataType FUNdataArray
  local LOCactualShiftX  = rootNode.DYNrootNodeStore.shiftX - FUNshiftXY.x
  local LOCactualShiftY  = rootNode.DYNrootNodeStore.shiftY - FUNshiftXY.y

  --- Build Vertex Array
  LOCtriVertArray[LOCmeshDataArray[2]] = undefined                                     -- Create Array for Storing Vertices (i.e. [345.2,234.1,5.12])
  for ii = 1 to LOCmeshDataArray[2] do
  (
    LOCtriVertArray[ii] = [LOCactualShiftX, LOCactualShiftY, 0.0] + [readfloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream]
  )

  --- Build Face Array
  LOCtriFaceArray[LOCmeshDataArray[3]] = undefined                                     -- Create Array for storing faces (i.e. [3,6,2])
  LOCtriMatsArray[LOCmeshDataArray[3]] = undefined                                     -- Create Array for storing MAT IDs. (i.e. 22)
  for ii = 1 to LOCmeshDataArray[3] do
  (
    LOCtriFaceArray[ii] = [readLong FUNfileStream, readLong FUNfileStream, readLong FUNfileStream]
    LOCtriFaceArray[ii] = LOCtriFaceArray[ii] + 1
    local LOCmatID      = readLong FUNfileStream
    LOCtriMatsArray[ii] = if LOCmatID == 0 then DYNINIungpMatChan else LOCmatID
  )

  --- Build Vertex Array
  if LOCmeshDataArray[4] > 0 then
  (
    LOCtriTVertArray[LOCmeshDataArray[4]] = undefined                                     -- Create Array for Storing Vertices (i.e. [345.2,234.1,5.12])
    for ii = 1 to LOCmeshDataArray[4] do
    (
      LOCtriTVertArray[ii] = [readfloat FUNfileStream, readFloat FUNfileStream, readFloat FUNfileStream]
    )
  )

  --- Build TFace Array
  if LOCmeshDataArray[5] > 0 then
  (
    LOCtriTFaceArray[LOCmeshDataArray[5]] = undefined                                     -- Create Array for storing faces (i.e. [3,6,2])
    for ii = 1 to LOCmeshDataArray[5] do
    (
      LOCtriTFaceArray[ii] = [readLong FUNfileStream, readLong FUNfileStream, readLong FUNfileStream]
      LOCtriTFaceArray[ii] = LOCtriTFaceArray[ii] + 1
    )
  )

  --- Create Triangulation Objects -----------------------------------------------------------------------------
  if LOCtriFaceArray.count > 0 then
  (
    LOCmesh = mesh vertices:LOCtriVertArray faces:LOCtriFaceArray materialIDs:LOCtrimatsArray tverts:LOCtriTVertArray

    case of
    (
      (FUNdataType == "TagMxElementInfo") : LOCmesh.name = (uniqueName (DYNuiResourcesNodeNames[22] + LOCappDataArray[1] + "-"))      -- For MX and GENIO Import
      (FUNdataType == "TagTwelveDElementInfo") : LOCmesh.name = (uniqueName (DYNuiResourcesNodeNames[23] + FUNdataArray[1] + "-"))    -- For 12d Model Import
      (FUNdataType == "TagXmlElementInfo") : LOCmesh.name = (uniqueName (DYNuiResourcesNodeNames[31] + FUNdataArray[1] + "-"))    -- For 12d Model Import
      default : LOCmesh.name = (DYNuiResourcesNodeNames[24] + (filterString LOCappDataArray[2] "$!!$")[1] + "-" + LOCappDataArray[1]) -- for Civil 3D Import
    )

    LOCmesh.pivot        = LOCmesh.center
    LOCmesh.backFaceCull = true
    LOCmesh.wirecolor    = random (color 30 90 5) (color 60 175 45)
    LOCmesh.material     = if sceneMaterials[DYNmatNameSurfaces] != undefined then sceneMaterials[DYNmatNameSurfaces] else (DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))

    ---Only do the following for non-Civil 3D geometry
    if FUNdataType == "TagMxElementInfo" or FUNdataType == "TagTwelveDElementInfo" or FUNdataType == "TagXmlElementInfo" then
    (
      addmodifier LOCmesh (smoothModifier autoSmooth:false)                                  -- Apply Smooth Modifier to REMOVE smoothing
      addmodifier LOCmesh (UVWmap length:10 width:10 mapType:0 realWorldMapSize:false)       -- Map Type 0 applies PLANAR mapping
      convertToMesh LOCmesh                                                                  -- Collapse Modifier Stack And Ensure it is an Editable Mesh
    )

    ---Only do the following for C3D Surface Objects (not corridor surfaces) and non-C3D Surface Geometry
    if (filterString LOCappDataArray[2] "$!!$")[2] == "10" or FUNdataType == "TagMxElementInfo" or FUNdataType == "TagTwelveDElementInfo" or FUNdataType == "TagXmlElementInfo" then
    (
      LOCcoordArray = DYNFUNgetObjDrapingCoords LOCmesh #() LOCmesh.material false 31 -- Find Draping Coord Defaults
      DYNFUNapplyPlanarMap LOCmesh [LOCcoordArray[1],LOCcoordArray[2]] [LOCcoordArray[3],LOCcoordArray[4]] 31 -- Apply Texture Coordinates To Triangles Using MatID of 31
    )
    else
    (
      LOCcoordArray = undefined
    )

    --- Hide Diagonal Edges on Corridor Surfaces
    if FUNhideDiagonalEdges then
    (
      for ii = 1 to LOCmesh.numFaces do (setEdgeVis LOCmesh ii 3 false)
    )

    --- Apply Texture Verts and Faces AFTER UVW Map Modifier Has Been Applied
    /*
    The mesh class contains a list of texture vertices which are completely independent of the regular
    vertices in the mesh. There is no correlation between the number of vertices in a mesh and the
    number of texture vertices. In addition to the texture vertices there are also texture faces.
    There needs to be one texture face for every regular face in the mesh.

    Each texture face has three indices into the texture vertex array. The coordinates of a texture
    vertex are UVW coordinates, and are accessed as Point3 values. The 3 components are U, V, and W,
    and each component value is in the range of 0 to 1. An example script for creating planar texture
    mapping on an object is shown in Working with Editable Meshes.
    */
    if LOCtriTFaceArray.count > 0 then
    (
      local mmesh = LOCmesh.mesh
      buildTVFaces mmesh
      for i = 1 to LOCtriTFaceArray.count do (setTVFace mmesh i LOCtriTFaceArray[i])
      update LOCmesh
    )

    /*
      //         LEFT SIDE                RIGHT SIDE
      //
      //    1        M2        0      0        M2        1
      //   1,1                0,1    0,1                1,1
      //
      //    D--------L2--------C      D--------L2--------C
      //    |1                0|      |0                1|
      //    |   Quad = ABCD    |      |   Quad = ABDC    |
      //    |   Tri1 = ABC     |      |   Tri1 = ABC     |
      //    |   Tri2 = CDA     |      |   Tri2 = CDA     |
      //    |1                0|      |0                1|
      //    A--------L1--------B      A--------L1--------B
      //
      //   1,0                0,0    0,0                1,0
      //    1        M1        0      0        M1        1

      This should give you an idea how faces are constructed and how mapping is applied. The outer 0/1 with 0..1 space marks there are the UV space.

    */

    --- Apply UVW XForm Modifier to Rotate UV space (only for corridor surfaces)
    if (filterString LOCappDataArray[2] "$!!$")[2] != "10" then
    (
      addmodifier LOCmesh (uvw_xform rotation_Angle:90.0)
    )

    --- Apply/Remove Smoothing from Mesh (Method 2 is quicker)
    if FUNsmoothAngle > 0.0 then
    (
      addmodifier LOCmesh (smoothModifier autoSmooth:true threshold:FUNsmoothAngle)
    )

    --- Collapse Stack After Applying Modifiers
    collapseStack LOCmesh

    --- Add AppData To Surface
    DYNFUNgenObjAppData LOCmesh 8 LOCtriMatsArray[1] FUNvsp3DFile (DYNFUNgetLocalTime()) (LOCcoordArray as string) LOCappDataArray[1] LOCappDataArray[2]

    --- Set Up Mesh Selection BitArrays
    fseek FUNfileStream FUNfileStop #seek_set

    for ii = 1 to FUNnumberTags do
    (
      local LOCtagElementData = DYNFUNreadElementHeader FUNfileStream

      if LOCtagElementData[1] == "TagMxEdgeReferences" then
      (
        local LOCmxEdgeReferences = DYNFUNreadTagMxEdgeReferences FUNfileStream LOCtagElementData[3] LOCtagElementData[5]
        global LOCmxTagRefs = LOCmxEdgeReferences
      )

      if LOCtagElementData[1] == "TagCivil3DCorridorSurfaceFaceStatus" then
      (
        local LOCcorridorFaceStatus = DYNFUNreadTagCivil3DCorridorSurfaceFaceStatus FUNfileStream LOCtagElementData[3] LOCtagElementData[5]

        --- This section is probably only required for development purposes. It can be removed in final release
        local LOCfaceArrayOverShadowed = #{}; LOCfaceArrayOverShadowed.count = LOCcorridorFaceStatus.count
        local LOCfaceArrayRegular      = #{}; LOCfaceArrayRegular.count      = LOCcorridorFaceStatus.count
        local LOCfaceArrayFillerLink   = #{}; LOCfaceArrayFillerLink.count   = LOCcorridorFaceStatus.count
        local LOCfaceArrayFillerTri    = #{}; LOCfaceArrayFillerTri.count    = LOCcorridorFaceStatus.count
        local LOCfaceArrayRegionLink   = #{}; LOCfaceArrayRegionLink.count   = LOCcorridorFaceStatus.count
        local LOCfaceArrayRegionTri    = #{}; LOCfaceArrayRegionTri.count    = LOCcorridorFaceStatus.count

        for iii = 1 to LOCcorridorFaceStatus.count do
        (
          local LOCabsStatus = abs(LOCcorridorFaceStatus[iii])

          /*
            1 - face is a regular link face           (means that face is generated from a link to a link, always generating two triangles)
            2 - face is a filler link face            (means that filler face is generated from a link to a link, always generating two triangles)
            3 - face is a filler triangle face        (means that filler face is generated from a link to a point or point to a link)
            4 - face is a region filler link face
            5 - face is a region filler triangle face (not yet used, reserved for possible future use dependign on future enhancement of region filler routines)

            - IF THE STATUS IS NEGATIVE (but also any of the above values) it means the face is OVERSHADOWED.
          */

          if LOCcorridorFaceStatus[iii] < 0 then LOCfaceArrayOverShadowed[iii] = true

          if LOCabsStatus == 1 then LOCfaceArrayRegular[iii]    = true
          if LOCabsStatus == 2 then LOCfaceArrayFillerLink[iii] = true
          if LOCabsStatus == 3 then LOCfaceArrayFillerTri[iii]  = true
          if LOCabsStatus == 4 then LOCfaceArrayRegionLink[iii] = true
          if LOCabsStatus == 5 then LOCfaceArrayRegionTri[iii]  = true
        )

        if LOCfaceArrayRegular.numberSet      > 0 then LOCmesh.faces["CivilView.Status.RegularLinkFaces"]  = LOCfaceArrayRegular
        if LOCfaceArrayFillerLink.numberSet   > 0 then LOCmesh.faces["CivilView.Status.FillerLinkFaces"]   = LOCfaceArrayFillerLink
        if LOCfaceArrayFillerTri.numberSet    > 0 then LOCmesh.faces["CivilView.Status.FillerTriFaces"]    = LOCfaceArrayFillerTri
        if LOCfaceArrayRegionLink.numberSet   > 0 then LOCmesh.faces["CivilView.Status.RegionLinkFaces"]   = LOCfaceArrayRegionLink
        if LOCfaceArrayRegionTri.numberSet    > 0 then LOCmesh.faces["CivilView.Status.RegionTriFaces"]    = LOCfaceArrayRegionTri
        if LOCfaceArrayOverShadowed.numberSet > 0 then LOCmesh.faces["CivilView.Status.OvershadowedFaces"] = LOCfaceArrayOverShadowed
      )

      if LOCtagElementData[1] == "TagCivil3DCorridorSurfaceVertexPointCodes" then
      (
        local LOCcorridorPointCodes    = DYNFUNreadTagCivil3DCorridorSurfaceVertexPointCodes FUNfileStream LOCtagElementData[3] LOCtagElementData[5]

        --- Create Point Code Based Vertex Selection Sets
        local LOCsubAsmPointSelections = DYNFUNdefineSurfaceSelectionSets LOCcorridorPointCodes 0
        for iiii = 1 to LOCsubAsmPointSelections[2].count do
        (
          if LOCsubAsmPointSelections[2][iiii].numberSet > 0 then
          (
            LOCmesh.vertices["CivilView.SubAsmPoint." + LOCsubAsmPointSelections[1][iiii]] = LOCsubAsmPointSelections[2][iiii]
          )
        )
      )

      if LOCtagElementData[1] == "TagCivil3DCorridorSurfaceFaceData" then
      (
        local LOCcorridorFaceData      = DYNFUNreadTagCivil3DCorridorSurfaceFaceData FUNfileStream LOCtagElementData[3] LOCtagElementData[5] 0

        /*
          LOCcorridorFaceData Contents (each array entry)
          -----------------------------------------------
          string LinkCodes
          string SubAsmName
          string SubAsmFullClassName
          int    AppliedMaterialID          -- (either + or -)
          bool   IsSpanMapped               -- (whether the applied map is the result of spanning)
          float  Station                    -- (the station value)
          float  U-Tile
          float  V-Tile
        */

        --- Create Link Code Based Face Selection Sets
        local LOCsubAsmLinkSelections  = DYNFUNdefineSurfaceSelectionSets LOCcorridorFaceData 1
        for iiii = 1 to LOCsubAsmLinkSelections[2].count do
        (
          if LOCsubAsmLinkSelections[2][iiii].numberSet > 0 then
          (
            LOCmesh.faces["CivilView.SubAsmLink." + LOCsubAsmLinkSelections[1][iiii]] = LOCsubAsmLinkSelections[2][iiii]
          )
        )

        --- Create SubAsm Name Based Face Selection Sets
        local LOCsubAsmNameSelections  = DYNFUNdefineSurfaceSelectionSets LOCcorridorFaceData 2
        for iiii = 1 to LOCsubAsmNameSelections[2].count do
        (
          if LOCsubAsmNameSelections[2][iiii].numberSet > 0 then
          (
            LOCmesh.faces["CivilView.SubAsmName." + LOCsubAsmNameSelections[1][iiii]] = LOCsubAsmNameSelections[2][iiii]
          )
        )

        --- Create SubAsm Class Based Face Selection Sets
        local LOCsubAsmClassSelections  = DYNFUNdefineSurfaceSelectionSets LOCcorridorFaceData 3
        for iiii = 1 to LOCsubAsmClassSelections[2].count do
        (
          if LOCsubAsmClassSelections[2][iiii].numberSet > 0 then
          (
            LOCmesh.faces["CivilView.SubAsmClass." + LOCsubAsmClassSelections[1][iiii]] = LOCsubAsmClassSelections[2][iiii]
          )
        )

        --- Create Span Mapped SubAsm Based Face Selection Sets
        local LOCfaceArraySpanMapped   = #{}; LOCfaceArraySpanMapped.count   = LOCcorridorFaceData.count
        for iii = 1 to LOCcorridorFaceData.count do (if LOCcorridorFaceData[iii][5] == 1 then LOCfaceArraySpanMapped[iii]   = true)
        if LOCfaceArraySpanMapped.numberSet > 0 then
        (
          LOCmesh.faces["CivilView.Data.SpanMappedFaces"]   = LOCfaceArraySpanMapped
        )

        --- Create Flipped MatID Based Face Selection Sets
        local LOCfaceArrayMatIDflipped = #{}; LOCfaceArrayMatIDflipped.count = LOCcorridorFaceData.count
        for iii = 1 to LOCcorridorFaceData.count do (if LOCcorridorFaceData[iii][4]  < 0 then LOCfaceArrayMatIDflipped[iii] = true)
        if LOCfaceArrayMatIDflipped.numberSet > 0 then
        (
          LOCmesh.faces["CivilView.Data.FlippedMatIDfaces"] = LOCfaceArrayMatIDflipped
        )
      )
    )

    deselect LOCmesh.faces

    --- Remove Unwanted Faces
    update LOCmesh
    if FUNremoveOverShadowed then
    (
      if LOCmesh.faces["CivilView.Status.OvershadowedFaces"] != undefined then
      (
        delete LOCmesh.faces["CivilView.Status.OvershadowedFaces"]
      )
    )

  )
  else
  (
    messagebox (DYNuiResourcesErrorsWarnings[108] + "\n\n" + LOCmeshDataArray[1]) title:DYNuiResourcesTitlebars[1] beep:false
  )
  LOCmesh -- return value
)

fn DYNFUNdisplayCorridors FUNdnTree FUNcorridorBaselines FUNcorridorRegions FUNcorridorFeatureLines =
(
  /*
    TreeView Node Key Content Identifiers:
    @ = generic tree key
    ! = corridor surfaces only key
    # = corridor shapes only key
  */

  local LOCdnRootNode   = FUNdnTree.Nodes.item[0].nodes.add "@|Corridors" DYNuiResourcesC3dObjectTypes[27] 41 41

  --- Insert Base Placeholder Nodes For Each Corridor Object
  for i in FUNcorridorBaselines do
  (
    /*
    TagCivil3DCorridorBaseLine
    --------------------------
    int knotCount
    int baseLineType;
    int baseLineIndex;
    int offsetBaseLineIndex;
    int RegionId;
    int uniqueId;
    string name; (not used - see below)
    string description; (not used - see below)
    string alignmentName;
    string profileName; (not used - see below)
    string corridorHandle;
    string corridorName;
    string layerName;
    string userTopCode;
    string spare;
    int regionCount;
    double startStation;
    double endStation;

    - the baseLineType is 0 or 1 for baseLine or offsetBaseLine.
    - the offsetBaseLineIndex is -1 if baseLineType is 0
    - the regionIndex is -1 if baseLineType is 0
    - the unique ID is "our" uniqueness value for each item that is
      a baseline of any kind (base, baseBase, offset)
    - the name and description is empty for baseLines because it's not in the COM or .NET API
    - the region count is the total region count but of course the
      region count will be 0 if baseLineType is 1 because offset
      baselines do not have regions.
    - there is one TagCivil3DCorridorBaseLine for each shape that
      represents a baseLine or offsetBaseLine. The hardcodedOffsetBaseLine
      will not carry this because we still don't know what to to with
      those because we have NO samples showing this offsetBaseLine type
    - there are one or more TagCivil3DCorridorRegion's for each
      TagCivil3DCorridorBaseLine (indicated by regionCount) as child
      elements.
    - ProfileName was exported from the 2010 V3 version of the exporter
      but this property was not easily available from the .NET v4 version
      of the exporter. This property is therefore deprecated.
    */

    --- Define Parent Corridor Node If It Doesn't Already Exist
    local LOCtargetNodeKey      = "@|Corridor|" + i[11]

    local LOCdnCorridorNodes = (FUNdnTree.nodes.find LOCtargetNodeKey true)
    local LOCdnCorridorNode = if LOCdnCorridorNodes.count > 0 then LOCdnCorridorNodes[1] else undefined
    if LOCdnCorridorNode == undefined then
    (
      LOCdnCorridorNode = LOCdnRootNode.Nodes.add LOCtargetNodeKey i[12] 41 41
    )

    if i[2] == 0 then LOCdnCorridorNode.Nodes.add ("@|CorridorBaseline|" + i[11] + "|" + (i[3] as string)) (DYNuiResourcesC3dObjectTypes[15] + " (" + ((i[3] + 1) as string) + ")") 43 43
  )

  for i in FUNcorridorRegions do
  (
    /*
    TagCivil3DCorridorRegion
    ------------------------
    int regionIndex;
    int appliedAssemblyCount;
    string name;  (Not yet exposed in C3D API)
    string description; (Not Used)
    string assemblyName;
    double startStation;
    double endStation;
    (string corridorHandle); -- Manually added MXS field
    (int baseLineIndex);     -- Manually added MXS field

    - if the appliedAssemblyCount is 0, it signals this region is empty
    */

    local LOCtargetNodeKey = "@|CorridorBaseline|" + i[8] + "|" + (i[9] as string)
    local LOCtargetNode    = (FUNdnTree.Nodes.find LOCtargetNodeKey true)[1]
    local LOCdnRegionNode  = LOCtargetNode.Nodes.add ("@|CorridorRegion|" + i[8] + "|" + (i[9] as string) + "|" + (i[1] as string)) (DYNuiResourcesC3dObjectTypes[16] + " (" + ((i[1] + 1) as string) + ")") 42 42
  )

  --- Insert Base Placeholder Nodes For Each Corridor Object
  for i in FUNcorridorBaselines do
  (
    /*
    TagCivil3DCorridorBaseLine
    --------------------------
    int knotCount
    int baseLineType;
    int baseLineIndex;
    int offsetBaseLineIndex;
    int RegionId;
    int uniqueId;
    string name; (not used - see below)
    string description; (not used - see below)
    string alignmentName;
    string profileName; (not used - see below)
    string corridorHandle;
    string corridorName;
    string layerName;
    string userTopCode;
    string spare;
    int regionCount;
    double startStation;
    double endStation;

    - the baseLineType is 0 or 1 for baseLine or offsetBaseLine.
    - the offsetBaseLineIndex is -1 if baseLineType is 0
    - the regionIndex is -1 if baseLineType is 0
    - the unique ID is "our" uniqueness value for each item that is
      a baseline of any kind (base, baseBase, offset)
    - the name and description is empty for baseLines because it's not in the COM or .NET API
    - the region count is the total region count but of course the
      region count will be 0 if baseLineType is 1 because offset
      baselines do not have regions.
    - there is one TagCivil3DCorridorBaseLine for each shape that
      represents a baseLine or offsetBaseLine. The hardcodedOffsetBaseLine
      will not carry this because we still don't know what to to with
      those because we have NO samples showing this offsetBaseLine type
    - there are one or more TagCivil3DCorridorRegion's for each
      TagCivil3DCorridorBaseLine (indicated by regionCount) as child
      elements.
    - ProfileName was exported from the 2010 V3 version of the exporter
      but this property was not easily available from the .NET v4 version
      of the exporter. This property is therefore deprecated.
    */

    if i[2] != 0 then
    (
      local LOCtargetRegionKey  = "@|CorridorRegion|" + i[11] + "|" + (i[3] as string) + "|" + (i[5] as string)
      local LOCtargetNode       = (FUNdnTree.Nodes.find LOCtargetRegionKey true)[1]
      local LOCdnBaselineNode   = LOCtargetNode.Nodes.add ("@|CorridorRegionOffsetBaseline|" + i[11] + "|" + (i[3] as string) + "|" + (i[5] as string) + "|" + (i[4] as string)) i[7] 54 54
    )
  )

  LOCdnRootNode.text = DYNuiResourcesC3dObjectTypes[27] + " [" + (LOCdnRootNode.nodes.count as string) + "]"
)

fn DYNFUNdisplayAlignments FUNdnTree FUNalignments =
(
  local LOCalignTypes = #(0, 0, 0, 0)

  /* Alignment Type (i[8]) = (centerline:1, curbreturn:2, offset:3, utility:4) */
  for i in FUNalignments do
  (
    if i[8] == 1 then LOCalignTypes[1] = LOCalignTypes[1] + 1
    if i[8] == 2 then LOCalignTypes[2] = LOCalignTypes[2] + 1
    if i[8] == 3 then LOCalignTypes[3] = LOCalignTypes[3] + 1
    if i[8] == 4 then LOCalignTypes[4] = LOCalignTypes[4] + 1
  )

  local LOCdnAlignNode  = FUNdnTree.Nodes.item[0].nodes.add "@|Alignments" (DYNuiResourcesC3dObjectTypes[18] + " [" + (FUNalignments.count as string) + "]") 53 53
  LOCdnAlignNode.nodes.add "@|Alignments_Centreline"    (DYNuiResourcesC3dObjectTypes[19] + " [" + (LOCalignTypes[1] as string) + "]") 53 53
  LOCdnAlignNode.nodes.add "@|Alignments_Offset"        (DYNuiResourcesC3dObjectTypes[20] + " [" + (LOCalignTypes[3] as string) + "]") 58 58
  LOCdnAlignNode.nodes.add "@|Alignments_CornerRadius"  (DYNuiResourcesC3dObjectTypes[21] + " [" + (LOCalignTypes[2] as string) + "]") 57 57
  LOCdnAlignNode.nodes.add "@|Alignments_Miscellaneous" (DYNuiResourcesC3dObjectTypes[22] + " [" + (LOCalignTypes[4] as string) + "]") 59 59
)

fn DYNFUNdisplaySurfaces FUNdnTree FUNsurfaces =
(
  local LOCdnRootNode    = FUNdnTree.Nodes.item[0].nodes.add "@|Surfaces" (DYNuiResourcesC3dObjectTypes[23] + " [" + (FUNsurfaces.count as string) + "]") 8 8
)

fn DYNFUNdisplayPointGroups FUNdnTree FUNpointGroups =
(
  local LOCdnRootNode    = FUNdnTree.Nodes.item[0].nodes.add "@|PointGroups" (DYNuiResourcesC3dObjectTypes[24] + " [" + (FUNpointGroups.count as string) + "]") 14 14
)

fn DYNFUNdisplayPipeNetworks FUNdnTree FUNpipeNetworks =
(
  local LOCdnRootNode    = FUNdnTree.Nodes.item[0].nodes.add "@|PipeNetworks" (DYNuiResourcesC3dObjectTypes[25] + " [" + (FUNpipeNetworks.count as string) + "]") 15 15
)

fn DYNFUNdisplaySites FUNdnTree FUNsites =
(
  local LOCdnRootNode    = FUNdnTree.Nodes.item[0].nodes.add "@|Sites" (DYNuiResourcesC3dObjectTypes[26] + " [" + (FUNsites.count as string) + "]") 52 52

  for i in FUNsites do
  (
    /*
    ContainerCivil3DSite
    --------------------
    string siteHandle
    string siteDesc
    string siteLayer
    string siteName
    */

    local LOCdnSiteNode  = LOCdnRootNode.nodes.add ("@|Site|" + i[1]) (i[4]) 52 52
    LOCdnSiteNode.tag    = "0"
  )
)

fn DYNFUNselectVesperObjectForImport FUNbaselines FUNfeatureLines FUNsurfaces FUNnamedLandFeatureLines FUNunnamedLandFeatureLines FUNcorridorSurfaces FUNdnLVselectedKey FUNselectedSwitch FUNpointGroups FUNalignments FUNpipeNetworks =
(
  local LOCfilteredKey   = filterString FUNdnLVselectedKey "|"
  local LOCarrayIndex    = LOCfilteredKey[1] as integer

  if LOCfilteredKey[2] == "Alignment"                             then FUNalignments[LOCarrayIndex][19]              = FUNselectedSwitch
  if LOCfilteredKey[2] == "Surface"                               then FUNsurfaces[LOCarrayIndex][12]                = FUNselectedSwitch
  if LOCfilteredKey[2] == "PointGroup"                            then FUNpointGroups[LOCarrayIndex][5]              = FUNselectedSwitch
  if LOCfilteredKey[2] == "PipeNetwork"                           then FUNpipeNetworks[LOCarrayIndex][6]             = FUNselectedSwitch
  if LOCfilteredKey[2] == "CorridorBaselineAlignment"             then FUNbaselines[LOCarrayIndex][19]               = FUNselectedSwitch
  if LOCfilteredKey[2] == "CorridorRegionOffsetBaselineAlignment" then FUNbaselines[LOCarrayIndex][19]               = FUNselectedSwitch
  if LOCfilteredKey[2] == "CorridorRegionFeatureLine"             then FUNfeatureLines[LOCarrayIndex][16]            = FUNselectedSwitch
  if LOCfilteredKey[2] == "CorridorRegionOffsetFeatureLine"       then FUNfeatureLines[LOCarrayIndex][16]            = FUNselectedSwitch
  if LOCfilteredKey[2] == "NamedLandFeatureLine"                  then FUNnamedLandFeatureLines[LOCarrayIndex][15]   = FUNselectedSwitch
  if LOCfilteredKey[2] == "UnnamedLandFeatureLine"                then FUNunnamedLandFeatureLines[LOCarrayIndex][15] = FUNselectedSwitch
  if LOCfilteredKey[2] == "CorridorRegionSurface"                 then FUNcorridorSurfaces[LOCarrayIndex][21]        = FUNselectedSwitch
  if LOCfilteredKey[2] == "CorridorRegionOffsetSurface"           then FUNcorridorSurfaces[LOCarrayIndex][21]        = FUNselectedSwitch

  --- For unnamed feature lines, we need to force all other unnamed featurelines from the same site to be selected (they will automatically combined into one shape on import)
  if LOCfilteredKey[2] == "UnnamedLandFeatureLine" then
  (
    for i in FUNunnamedLandFeatureLines do
    (
      if i[6] == LOCfilteredKey[3] then i[15] = FUNselectedSwitch
    )
  )
)

fn DYNFUNflagPreviouslyImportedObjects FUNbaselines FUNfeatureLines FUNsurfaces FUNnamedLandFeatureLines FUNunnamedLandFeatureLines FUNcorridorSurfaces FUNpointGroups FUNalignments FUNpipeNetworks =
(
  for i in FUNalignments              do i[21] = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "TagCivil3DAlignment"           i)[2]) "nodes").count > 0 then true else false
  for i in FUNbaselines               do i[21] = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "TagCivil3DCorridorBaseLine"    i)[2]) "nodes").count > 0 then true else false
  for i in FUNfeatureLines            do i[18] = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "TagCivil3DCorridorFeatureLine" i)[2]) "nodes").count > 0 then true else false
  for i in FUNnamedLandFeatureLines   do i[17] = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "TagCivil3DLandFeatureLine"     i)[2]) "nodes").count > 0 then true else false
  for i in FUNunnamedLandFeatureLines do i[17] = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "TagCivil3DLandFeatureLine"     i)[2]) "nodes").count > 0 then true else false
  for i in FUNsurfaces                do i[15] = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "TagCivil3DSurface"             i)[2]) "nodes").count > 0 then true else false
  for i in FUNpointGroups             do i[7]  = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "Civil3DPointGroup"             i)[2]) "nodes").count > 0 then true else false
  for i in FUNpipeNetworks            do i[6]  = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "Civil3DPipeNetwork"            i)[2]) "nodes").count > 0 then true else false
  for i in FUNcorridorSurfaces        do i[24] = if (DynLXGetNodesByAppData #(428,(DYNFUNgenerateC3DrelatedAppData "TagCivil3DCorridorSurface"     i)[2]) "nodes").count > 0 then true else false
)

fn DYNFUNdisplayVesperListView FUNdnLv FUNdnTree FUNdnTreeItem FUNbaselines FUNfeatureLines FUNsurfaces FUNnamedLandFeatureLines FUNunnamedLandFeatureLines FUNcorridorSurfaces FUNpointGroups FUNalignments FUNpipeNetworks =
(
  FUNdnLv.beginUpdate()
  FUNdnLv.Items.clear()
  DYNc3dImport.LOCallowDnSelection = false

  local LOClistItemRange          = #() --array to collect the list items

  local LOCtreeKey       = try (FUNdnTreeItem.name) catch ("")
  local LOCfilteredKey   = filterString LOCtreeKey "|"
  local LOCdislayedTypes = #()

  if FUNalignments.count              > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[1]
  if FUNalignments.count              > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[2]
  if FUNalignments.count              > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[3]
  if FUNalignments.count              > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[4]
  if FUNbaselines.count               > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[5]
  if FUNbaselines.count               > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[6]
  if FUNfeatureLines.count            > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[7]
  if FUNfeatureLines.count            > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[8]
  if FUNcorridorSurfaces.count        > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[9]
  if FUNcorridorSurfaces.count        > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[10]
  if FUNpointGroups.count             > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[11]
  if FUNpipeNetworks.count            > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[12]
  if FUNsurfaces.count                > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[13]
  if FUNunnamedLandFeatureLines.count > 0 or FUNnamedLandFeatureLines.count > 0 then append LOCdislayedTypes DYNuiResourcesC3dObjectTypes[14]

  if (subString LOCtreeKey 1 6) == "@|Draw" or (subString LOCtreeKey 1 6) == "@|Surf" then
  (
    local LOCcnt = 0
    for i in FUNsurfaces do
    (
      LOCcnt += 1
      /*
        TagCivil3DSurface
        -----------------
        string handle;
        string description;
        string layerName;
        string materialName;
        int materialId;
        double mappingURepeat;
        double mappingVRepeat;
        int pointCount;
        int faceCount;
        (string name);       -- manually added MXS field
        (boolean selected);  -- manually added MXS field (11)
      */

      local LOCsubItemLabels = #(DYNuiResourcesC3dObjectTypes[13], i[8], i[9], "", "", "", "", "", "", "", i[3])
      /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
      local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[10] ((LOCcnt as string) + "|Surface|" + i[1]) i[2] 8 i[12] i[15] LOCsubItemLabels
      append LOClistItemRange LOCdnListItem
    )
  )

  if (subString LOCtreeKey 1 6) == "@|Draw" or (subString LOCtreeKey 1 6) == "@|Poin" then
  (
    local LOCcnt = 0
    for i in FUNpointGroups do
    (
      LOCcnt += 1
      /*
        Civil3DPointGroup
        -----------------
        string Name
        string Handle
        string Description
        int numPoints
        (boolean selected) -- selected for import - manually added MXS field (4)
        (int pointOffset)  --                     - manually added MXS field (5)
        (boolean exists)   -- already exists      - manually added MXS field (6)

        use DYNpSystemPointLimit below to check whether there are too many points in the point group for
        DVSP to currently handle. If more than allowed, ensure that UI item cannot be selected or imported.
      */

      local LOCsubItemLabels = #(DYNuiResourcesC3dObjectTypes[11], i[4], "", "", "", "", "", "", "", "", "")
      /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
      local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[1] ((LOCcnt as string) + "|PointGroup|" + i[1]) i[3] 14 i[5] (if i[4] > DYNpSystemPointLimit then true else i[7]) LOCsubItemLabels
      append LOClistItemRange LOCdnListItem
    )
  )

  if (subString LOCtreeKey 1 6) == "@|Draw" or (subString LOCtreeKey 1 6) == "@|Pipe" then
  (
    local LOCcnt = 0
    for i in FUNpipeNetworks do
    (
      LOCcnt += 1
      /*
        Civil3DPipeNetworks
        -----------------
        string Name
        string Handle
        string Description
        int numPipes
        int numStructures
        (boolean selected) -- selected for import - manually added MXS field (6)
        (int pipeOffset)  --                      - manually added MXS field (7)
        (boolean exists)   -- already exists      - manually added MXS field (8)
      */

      local LOCsubItemLabels = #(DYNuiResourcesC3dObjectTypes[12], i[4], i[5], "", "", "", "", "", "", "", "")
      /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
      local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[1] ((LOCcnt as string) + "|PipeNetwork|" + i[1]) i[3] 15 i[6] i[8] LOCsubItemLabels
      append LOClistItemRange LOCdnListItem
    )
  )

  if (subString LOCtreeKey 2 5) == "|Draw" or (subString LOCtreeKey 2 5) == "|Alig" or (subString LOCtreeKey 2 5) == "|Site" do
  (
    local LOCcnt = 0
    for i in FUNalignments do
    (
      LOCcnt += 1
      /*
        TagCivil3DAlignment
        ---------------------------------------
        string Name
        string Description
        string Handle
        string LayerName
        string SiteName
        string SiteHandle
        int NumEntities
        int AlignmentType (centerline:1, curbreturn:2, offset:3, utility:4)
        bool IsOffsetAlignment
        bool UseDesignSpeed
        float StartStation
        float EndStation
        float Length
        float TangentInterval
        float CurveInterval
        float SpiralInterval
        int NumDesignSpeeds
        [Design Speeds]
      */

      /*  Decide whether each alignment should be listed, depending on alignment type and which node is selected */
      local LOCdrawSwitch = false
      if LOCtreeKey == "@|Drawing"                                then LOCdrawSwitch = true
      if LOCtreeKey == "@|Alignments"                             then LOCdrawSwitch = true
      if LOCtreeKey == "@|Alignments_Centreline"    and i[8] == 1 then LOCdrawSwitch = true
      if LOCtreeKey == "@|Alignments_CornerRadius"  and i[8] == 2 then LOCdrawSwitch = true
      if LOCtreeKey == "@|Alignments_Offset"        and i[8] == 3 then LOCdrawSwitch = true
      if LOCtreeKey == "@|Alignments_Miscellaneous" and i[8] == 4 then LOCdrawSwitch = true
      if (subString LOCtreeKey 2 6) == "|Sites" and i[5] != ""    then LOCdrawSwitch = true
      if (subString LOCtreeKey 2 6) == "|Site|" and (subString LOCtreeKey 8 -1) == i[6] then LOCdrawSwitch = true

      if LOCdrawSwitch then
      (
        local LOCalignTypeString = DYNuiResourcesC3dObjectTypes[17]
        if i[8] == 1 then LOCalignTypeString = DYNuiResourcesC3dObjectTypes[1]
        if i[8] == 2 then LOCalignTypeString = DYNuiResourcesC3dObjectTypes[3]
        if i[8] == 3 then LOCalignTypeString = DYNuiResourcesC3dObjectTypes[2]
        if i[8] == 4 then LOCalignTypeString = DYNuiResourcesC3dObjectTypes[4]

        local LOCalignTypeImage = 53
        if i[8] == 1 then LOCalignTypeImage  = 53
        if i[8] == 2 then LOCalignTypeImage  = 57
        if i[8] == 3 then LOCalignTypeImage  = 58
        if i[8] == 4 then LOCalignTypeImage  = 59

        local LOCsubItemLabels = #(LOCalignTypeString, i[22], "1", "", i[5], "", "", "", i[11], i[12], i[4])
        /*  DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
        local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[1] ((LOCcnt as string) + "|Alignment|" + i[1]) i[2] LOCalignTypeImage i[19] i[21] LOCsubItemLabels
        append LOClistItemRange LOCdnListItem
      )
    )
  )

  if (subString LOCtreeKey 2 5) == "|Draw" or (subString LOCtreeKey 2 5) == "|Corr" then
  (
    local LOCtypeFilter     = if LOCfilteredKey.count >= 1 then LOCfilteredKey[1] else undefined -- (!=surface, #=shape, @=both)
    local LOCcorridorFilter = if LOCfilteredKey.count >= 3 then LOCfilteredKey[3] else undefined
    local LOCbaselineFilter = if LOCfilteredKey.count >= 4 then LOCfilteredKey[4] else undefined
    local LOCregionFilter   = if LOCfilteredKey.count >= 5 then LOCfilteredKey[5] else undefined
    local LOCoffsetFilter   = if LOCfilteredKey.count >= 6 then LOCfilteredKey[6] else undefined

    local LOCcnt = 0
    for i in FUNbaselines do
    (
      LOCcnt += 1
      /*
        TagCivil3DCorridorBaseLine
        --------------------------
        int knotCount
        int baseLineType;
        int baseLineIndex;
        int offsetBaseLineIndex;
        int RegionId;
        int uniqueId;
        string name; (not used)
        string description; (not used)
        string alignmentName;
        string profileName; (not used)
        string corridorHandle;
        string corridorName;
        string layerName;
        string userTopCode;
        string spare;
        int regionCount;
        double startStation;
        double endStation;
        (boolean selected);  -- manually added MXS field (19)
      */

      if LOCcorridorFilter == i[11] or LOCcorridorFilter == undefined then
      (
        if LOCbaselineFilter == (i[3] as string) or LOCbaselineFilter == undefined then
        (
          if LOCregionFilter == (i[5] as string) or LOCregionFilter == undefined then
          (
            if LOCoffsetFilter == (i[4] as string) or LOCoffsetFilter == undefined then
            (
              if LOCtypeFilter == "@" or LOCtypeFilter == "#" then
              (
                local LOCtag           = if i[2] == 0 then ((LOCcnt as string) + "|CorridorBaselineAlignment|" + i[11] + "|" + (i[3] as string)) else ((LOCcnt as string) + "|CorridorRegionOffsetBaselineAlignment|" + i[11] + "|" + (i[3] as string) + "|" + (i[5] as string) + "|" + (i[4] as string))
                local LOCsubItem1Text  = if i[2] == 0 then DYNuiResourcesC3dObjectTypes[5] else DYNuiResourcesC3dObjectTypes[6]
                local LOCsubItem7Text  = if i[2] == 0 then "" else (DYNuiResourcesC3dObjectTypes[16] + " (" + ((i[5] + 1 ) as string) + ")")
                local LOCsubItem6Text  = DYNuiResourcesC3dObjectTypes[15] + " (" + ((i[3] + 1 ) as string) + ")"
                local LOCsubItemLabels = #(LOCsubItem1Text, i[1], "1", "", i[12], LOCsubItem6Text, LOCsubItem7Text, "", i[17], i[18], i[13])
                /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
                local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[9] LOCtag i[8] 43 i[19] i[21] LOCsubItemLabels
                append LOClistItemRange LOCdnListItem
              )
            )
          )
        )
      )
    )

    local LOCcnt = 0
    for i in FUNcorridorSurfaces do
    (
      LOCcnt += 1
      /*
        TagCivil3DCorridorSurface
        ------------------------
        int stationCount
        int regionCount (actually STRIP count !!)
        int regionIndex
        int baseLineType
        int baseLineIndex
        int offsetBaseLineIndex
        int baselineUniqueId
        string corridorHandle
        string corridorname
        string description
        string alignmentName
        string profileName
        string layerName
        string userTopCode
        string assemblyName
        float startStation
        float endStation
        int vertexCount
        int faceCount
        (boolean selected);  -- manually added MXS field (18)
      */

      if LOCcorridorFilter == i[8] or LOCcorridorFilter == undefined then
      (
        if LOCbaselineFilter == (i[5] as string) or LOCbaselineFilter == undefined then
        (
          if LOCregionFilter == (i[3] as string) or LOCregionFilter == undefined then
          (
            if LOCoffsetFilter == (i[6] as string) or LOCoffsetFilter == undefined then
            (
              if LOCtypeFilter == "@" or LOCtypeFilter == "#" then
              (
                local LOClistItemText  = DYNuiResourcesC3dObjectTypes[16] + " (" + ((i[3] + 1 ) as string) + ")"
                local LOCtag           = if i[4] == 0 then ((LOCcnt as string) + "|CorridorRegionSurface|" + i[8] + "|" + (i[5] as string) + "|" + (i[3] as string)) else ((LOCcnt as string) + "|CorridorRegionOffsetSurface|" + i[8] + "|" + (i[5] as string) + "|" + (i[3] as string) + "|" + (i[6] as string))
                local LOCsubItem1Text  = if i[4] == 0 then (DYNuiResourcesC3dObjectTypes[9]) else (DYNuiResourcesC3dObjectTypes[10])
                local LOCsubItem6Text  = DYNuiResourcesC3dObjectTypes[15] + " (" + ((i[5] + 1 ) as string) + ")"
                local LOCsubItem7Text  = LOClistItemText
                local LOCsubItemLabels = #(LOCsubItem1Text, i[18], i[19], i[14], i[9], LOCsubItem6Text, LOCsubItem7Text, i[15], i[16], i[17], i[13])
                /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
                local LOCdnListItem    = DYNFUNdefineC3dDnLVitem LOClistItemText LOCtag LOClistItemText 8 i[21] i[24] LOCsubItemLabels
                append LOClistItemRange LOCdnListItem
              )
            )
          )
        )
      )
    )

    local LOCcnt = 0
    for i in FUNfeatureLines do
    (
      LOCcnt += 1
      /*
        TagCivil3DCorridorFeatureLine
        -----------------------------
        int knotCount
        string pointCode
        int baseLineType
        int baseLineIndex
        int offsetBaseLineIndex
        int regionIndex
        string assemblyName
        string corridorHandle
        string corridorName
        string layerName
        private string userTopCode
        string spare
        double regionStartStation
        double regionEndStation
        (int splines)        -- manually added MXS field
        (boolean selected);  -- manually added MXS field (16)

        - the baseLineType is 0 or 1 for baseLine or offsetBaseLine.
        - the offsetBaseLineIndex is -1 if baseLineType is 0
        - there is one TagCivil3DCorridorFeatureLine for each shape
          that represents a featurelines shape
      */

      if LOCcorridorFilter == i[8] or LOCcorridorFilter == undefined then
      (
        if LOCbaselineFilter == (i[4] as string) or LOCbaselineFilter == undefined then
        (
          if LOCregionFilter == (i[6] as string) or LOCregionFilter == undefined then
          (
            if LOCoffsetFilter == (i[5] as string) or LOCoffsetFilter == undefined then
            (
              if LOCtypeFilter == "@" or LOCtypeFilter == "#" then
              (
                local LOCtag           = if i[3] == 0 then ((LOCcnt as string) + "|CorridorRegionFeatureLine|" + i[8] + "|" + (i[4] as string) + "|" + (i[6] as string) + "|" + i[2]) else ((LOCcnt as string) + "|CorridorRegionOffsetFeatureLine|" + i[8] + "|" + (i[4] as string) + "|" + (i[6] as string) + "|" + (i[5] as string) + "|" + i[2])
                local LOCsubItem1Text  = if i[3] == 0 then (DYNuiResourcesC3dObjectTypes[7]) else (DYNuiResourcesC3dObjectTypes[8])
                local LOCsubItem6Text  = DYNuiResourcesC3dObjectTypes[15] + " (" + ((i[4] + 1 ) as string) + ")"
                local LOCsubItem7Text  = DYNuiResourcesC3dObjectTypes[16] + " (" + ((i[6] + 1 ) as string) + ")"
                local LOCsubItemLabels = #(LOCsubItem1Text, i[1], i[15], i[11], i[9], LOCsubItem6Text, LOCsubItem7Text, i[7], i[13], i[14], i[10])
                /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
                local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[2] LOCtag i[2] 7 i[16] i[18] LOCsubItemLabels
                append LOClistItemRange LOCdnListItem
              )
            )
          )
        )
      )
    )
  )

  if (subString LOCtreeKey 2 5) == "|Draw" or (subString LOCtreeKey 2 5) == "|Site" then
  (
    local LOCcnt = 0
    for i in FUNnamedLandFeatureLines do
    (
      LOCcnt += 1
      if (subString LOCtreeKey 2 5) == "|Draw" or (subString LOCtreeKey 2 6) == "|Sites" or (substring LOCtreeKey 8 -1) == i[6] then
      (
        /*
          TagCivil3DLandFeatureLine
          -------------------------
          String Handle
          String description
          String layerName
          String name
          String siteName
          String siteHandle
          int elevationPointCount
          int piPointCount
          double length2D
          double length3D
          double maximumElevation
          double minimumElevation
          double maximumGrade
          double minimumGrade
          (boolean selected);  -- manually added MXS field (15)
        */

        local LOCsubItemLabels = #(DYNuiResourcesC3dObjectTypes[14], (i[7] + i[8]), "1", "", i[5], "", "", "", "", "", i[3])
        /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
        local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[4] ((LOCcnt as string) + "|NamedLandFeatureLine|" + i[1] + "|" + i[6]) i[2] 7 i[15] i[17] LOCsubItemLabels
        append LOClistItemRange LOCdnListItem
      )
    )

    local LOCsiteHandles  = #()
    local LOCunnamedFLcnt = #()
    for i in FUNunnamedLandFeatureLines do
    (
      if (subString LOCtreeKey 2 5) == "|Draw" or (subString LOCtreeKey 2 6) == "|Sites" or (substring LOCtreeKey 8 -1) == i[6] then
      (
        /*
          TagCivil3DLandFeatureLine
          -------------------------
          String Handle
          String description
          String layerName
          String name
          String siteName
          String siteHandle
          int elevationPointCount
          int piPointCount
          double length2D
          double length3D
          double maximumElevation
          double minimumElevation
          double maximumGrade
          double minimumGrade
          (boolean selected);  -- manually added MXS field (15)
        */

        local LOClistItemKey  = "1|UnnamedLandFeatureLine|" + i[6] -- Check whether this listItem already exists. Only one unnamed land featureline per site should be listed

        /*
        -- Doesn't work because items have not been written to dnLV control yet
        local LOClistItem     = DYNFUNfindListViewItemByTag FUNdnLv LOClistItemKey
        */

        local LOClistItem
        for ii in LOClistItemRange do (if ii.tag == LOClistItemKey then LOClistItem = ii)

        if LOClistItem == Undefined then -- ("LOClistItem == undefined" does not work here)
        (
          local LOCsubItemLabels = #(DYNuiResourcesC3dObjectTypes[14], (i[7] + i[8]), "1", "", i[5], "", "", "", "", "", i[3])

          /* DYNFUNdefineC3dDnLVitem FUNtext FUNtag FUNtoolTip FUNimageIndex FUNchecked FUNcolorSwitch FUNsubItems */
          local LOCdnListItem    = DYNFUNdefineC3dDnLVitem i[4] LOClistItemKey i[2] 7 i[15] i[17] LOCsubItemLabels
          append LOClistItemRange LOCdnListItem
          append LOCsiteHandles LOClistItemKey
          append LOCunnamedFLcnt 1
        )
        else
        (
          LOCunnamedFLcnt[findItem LOCsiteHandles LOClistItemKey] += 1
        )
      )
    )

    --- Display number of unnamed feature lines in each site
    for i = 1 to LOCsiteHandles.count do
    (
      /*
      -- Doesn't work because items have not been written to dnLV control yet
      local LOClistItem = DYNFUNfindListViewItemByTag FUNdnLv LOCsiteHandles[i]
      */
      local LOClistItem
      for ii in LOClistItemRange do (if ii.tag == LOCsiteHandles[i] then LOClistItem = ii)

      if LOClistItem != undefined then
      (
        LOClistItem.subItems.item[3].text = LOCunnamedFLcnt[i] as string
      )
    )
  )

  FUNdnLv.Items.AddRange LOClistItemRange
  FUNdnLv.endUpdate()

  DYNc3dImport.LOCallowDnSelection = true

  --- Enable / Disable Panel Filter Controls
  local LOCenableFilters = FUNdnLv.Items.count > 0
  DYNc3dImport.DDDYNobjectType.items   = LOCdislayedTypes
  DYNc3dImport.DDDYNobjectType.enabled = LOCenableFilters
  DYNc3dImport.BUABOadd1.enabled       = LOCenableFilters
  DYNc3dImport.BUABOrem1.enabled       = LOCenableFilters
  DYNc3dImport.EDDYNobjectname.enabled = LOCenableFilters
  DYNc3dImport.BUABOadd2.enabled       = LOCenableFilters
  DYNc3dImport.BUABOrem2.enabled       = LOCenableFilters
  setFocus FUNdnLv
)

fn DYNFUNvsp3dProgress FUNcurrent FUNtotal FUNprogress FUNstatusText FUNstatusAlt =
(
  if FUNprogress   != undefined then FUNprogress.value = (FUNcurrent as float) / (FUNtotal as float) * 100.0
  if FUNstatusText != undefined then FUNstatusText.text = FUNstatusAlt
)

fn DYNFUNimportVesperFile FUNc3dVspFile FUNc3dSurfaces FUNc3dCorridorSurfaces FUNc3dCorridorBaselines FUNc3dCorridorFeatureLines FUNc3dNamedLandFeatureLines FUNc3dUnnamedLandFeatureLines FUNshiftXY FUNsmoothAngle FUNhideDiagonals FUNremoveOverShadowed FUNprogress FUNstatus FUNc3dPointGroups FUNupdateSwitch FUNmxPointStrings FUNmxShapeStrings FUNmxSurfaceStrings FUN12dPointStrings FUN12dShapeStrings FUN12dSurfaceStrings FUNc3dAlignments FUNc3dPipeNetworks FUNxmlSurfaceStrings FUNxmlShapeStrings FUNxmlPointStrings =
(
  /* FUNupdateSwitch is used for Point Groups only. If this is an updating operation, only a birth script action is created instead of the full PF_Source object */
  local LOCnewObjectArray = #()

  local LOCfileStream = fOpen FUNc3dVspFile "rbS" -- Open BinIO File for reading from

  --- Count total number of Selected Elements to import
  local LOCcurrentObject = 0
  local LOCtotalObjects  = 0
  for i in FUNc3dAlignments              do if i[19] then LOCtotalObjects += 1
  for i in FUNc3dSurfaces                do if i[12] then LOCtotalObjects += 1
  for i in FUNc3dPointGroups             do if i[5]  then LOCtotalObjects += 1
  for i in FUNc3dPipeNetworks            do if i[6]  then LOCtotalObjects += 1
  for i in FUNc3dCorridorSurfaces        do if i[21] then LOCtotalObjects += 1
  for i in FUNc3dCorridorBaselines       do if i[19] then LOCtotalObjects += 1
  for i in FUNc3dCorridorFeatureLines    do if i[16] then LOCtotalObjects += 1
  for i in FUNc3dNamedLandFeatureLines   do if i[15] then LOCtotalObjects += 1
  for i in FUNc3dUnnamedLandFeatureLines do if i[15] then LOCtotalObjects += 1
  for i in FUNmxPointStrings             do if i[9]  then LOCtotalObjects += 1
  for i in FUNmxShapeStrings             do if i[9]  then LOCtotalObjects += 1
  for i in FUNmxSurfaceStrings           do if i[9]  then LOCtotalObjects += 1
  for i in FUN12dPointStrings            do if i[8]  then LOCtotalObjects += 1
  for i in FUN12dShapeStrings            do if i[8]  then LOCtotalObjects += 1
  for i in FUN12dSurfaceStrings          do if i[8]  then LOCtotalObjects += 1
  for i in FUNxmlSurfaceStrings          do if i[10] then LOCtotalObjects += 1
  for i in FUNxmlShapeStrings            do if i[10] then LOCtotalObjects += 1
  for i in FUNxmlPointStrings            do if i[10] then LOCtotalObjects += 1

  --- Import Selected Elements - LandXML --------
  for i in FUNxmlPointStrings do
  (
    if i[10] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[81]
      local LOCnewObject = DYNFUNcreateVesperPointGroup LOCfileStream i[11] FUNshiftXY "TagXmlElementInfo" i FUNc3dVspFile FUNupdateSwitch
      i[10] = false; i[12] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNxmlShapeStrings do
  (
    if i[10] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[80]
      local LOCnewObject = DYNFUNcreateVesperShape LOCfileStream i[11] FUNshiftXY "TagXmlElementInfo" i FUNc3dVspFile
      i[10] = false ; i[12] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNxmlSurfaceStrings do
  (
    if i[10] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[79]
      local LOCnewObject = DYNFUNcreateVesperSurface LOCfileStream i[11] i[13] FUNshiftXY 1 FUNsmoothAngle i[14] false false "TagXmlElementInfo" i FUNc3dVspFile
      i[10] = false; i[12] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  --- Import Selected Elements - MX and GENIO ---
  for i in FUNmxShapeStrings do
  (
    if i[9] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[66]
      local LOCnewObject = DYNFUNcreateVesperShape LOCfileStream i[10] FUNshiftXY "TagMxElementInfo" i FUNc3dVspFile
      i[9] = false ; i[11] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNmxPointStrings do
  (
    if i[9] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[67]
      local LOCnewObject = DYNFUNcreateVesperPointGroup LOCfileStream i[10] FUNshiftXY "TagMxElementInfo" i FUNc3dVspFile FUNupdateSwitch
      i[9] = false; i[11] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNmxSurfaceStrings do
  (
    if i[9] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[68]
      local LOCnewObject = DYNFUNcreateVesperSurface LOCfileStream i[10] i[12] FUNshiftXY 1 FUNsmoothAngle i[13] false false "TagMxElementInfo" i FUNc3dVspFile
      i[9] = false; i[11] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  --- Import Selected Elements - 12d Model ------
  for i in FUN12dShapeStrings do
  (
    if i[8] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[69]
      local LOCnewObject = DYNFUNcreateVesperShape LOCfileStream i[9] FUNshiftXY "TagTwelveDElementInfo" i FUNc3dVspFile
      i[8] = false ; i[10] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUN12dPointStrings do
  (
    if i[8] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[70]
      local LOCnewObject = DYNFUNcreateVesperPointGroup LOCfileStream i[9] FUNshiftXY "TagTwelveDElementInfo" i FUNc3dVspFile FUNupdateSwitch
      i[8] = false; i[10] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUN12dSurfaceStrings do
  (
    if i[8] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[71]
      local LOCnewObject = DYNFUNcreateVesperSurface LOCfileStream i[9] i[11] FUNshiftXY 1 FUNsmoothAngle i[12] false false "TagTwelveDElementInfo" i FUNc3dVspFile
      i[8] = false; i[10] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  --- Import Selected Elements - Civil 3D
  for i in FUNc3dAlignments do
  (
    if i[19] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[72]
      local LOCnewObject = DYNFUNcreateVesperAlignment LOCfileStream FUNshiftXY "TagCivil3DAlignment" i FUNc3dVspFile
      i[19] = false ; i[21] = true
      append LOCnewObjectArray LOCnewObject
    )
  )



  for i in FUNc3dCorridorSurfaces do
  (
    if i[21] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[73]
      local LOCnewObject = DYNFUNcreateVesperSurface LOCfileStream i[22] i[20] FUNshiftXY 1 FUNsmoothAngle i[23] FUNhideDiagonals FUNremoveOverShadowed "TagCivil3DCorridorSurface" i FUNc3dVspFile
      i[21] = false ; i[24] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNc3dCorridorBaselines do
  (
    if i[19] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[72]
      local LOCnewObject = DYNFUNcreateVesperShape LOCfileStream i[20] FUNshiftXY "TagCivil3DCorridorBaseLine" i FUNc3dVspFile
      i[19] = false ; i[21] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNc3dCorridorFeatureLines do
  (
    if i[16] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[74]
      local LOCnewObject = DYNFUNcreateVesperShape LOCfileStream i[17] FUNshiftXY "TagCivil3DCorridorFeatureLine" i FUNc3dVspFile
      i[16] = false ; i[18] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNc3dSurfaces do
  (
    if i[12] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[75]
      local LOCnewObject = DYNFUNcreateVesperSurface LOCfileStream i[13] i[11] FUNshiftXY i[5] FUNsmoothAngle i[14] false false "TagCivil3DSurface" i FUNc3dVspFile
      i[12] = false; i[15] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNc3dPointGroups do
  (
    if i[5] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[76]
      local LOCnewObject = DYNFUNcreateVesperPointGroup LOCfileStream i[6] FUNshiftXY "Civil3DPointGroup" i FUNc3dVspFile FUNupdateSwitch
      i[5] = false; i[7] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNc3dPipeNetworks do
  (
    if i[6] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[77]
      local LOCnewObject = DYNFUNcreateVesperPipeNetwork LOCfileStream i[7] FUNshiftXY "Civil3DPipeNetwork" i FUNc3dVspFile
      i[6] = false; i[8] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  for i in FUNc3dNamedLandFeatureLines do
  (
    if i[15] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[78]
      local LOCnewObject = DYNFUNcreateVesperShape LOCfileStream i[16] FUNshiftXY "TagCivil3DLandFeatureLine" i FUNc3dVspFile
      i[15] = false ; i[17] = true
      append LOCnewObjectArray LOCnewObject
    )
  )

  --- FInally - Unnamed Land Feature Lines
  local LOCsiteHandles = #()
  local LOCsiteFLs     = #()
  for i in FUNc3dUnnamedLandFeatureLines do
  (
    if i[15] then
    (
      LOCcurrentObject += 1
      DYNFUNvsp3dProgress LOCcurrentObject LOCtotalObjects FUNprogress FUNstatus DYNuiResourcesStatusMessages[78]
      local LOCnewObject = DYNFUNcreateVesperShape LOCfileStream i[16] FUNshiftXY "TagCivil3DLandFeatureLine" i FUNc3dVspFile
      i[15] = false ; i[17] = true

      /* Collect Unnamed Feature Line into per-site arrays */
      local LOCappData = DYNFUNgenerateC3DrelatedAppData "TagCivil3DLandFeatureLine" i
      if findItem LOCsiteHandles (filterString LOCappData[2] "$!!$")[3] == 0 then
      (
        append LOCsiteHandles (filterString LOCappData[2] "$!!$")[3]; append LOCsiteFLs #(LOCnewObject)
      )
      else
      (
        append LOCsiteFLs[(findItem LOCsiteHandles (filterString LOCappData[2] "$!!$")[3])] LOCnewObject
      )
    )
  )

  --- Combine Unnamed Feature Lines into a Single Shape Object Per-Site
  for ii in LOCsiteFLs do
  (
    if ii.count > 1 then
    (
      for iii = 2 to ii.count do
      (
        addNewSpline ii[1]; local LOCsplineCount = numSplines ii[1]
        for iiii = 1 to (numKnots ii[iii] 1) do (addknot ii[1] LOCsplineCount #corner #line (getKnotPoint ii[iii] 1 iiii))
        delete ii[iii]
      )
    )
    updateShape ii[1]
    append LOCnewObjectArray ii[1]
  )

  --- Close Vesper File
  fClose LOCfileStream

  LOCnewObjectArray -- return array of objects imported
)

fn DYNFUNsetGlobalShiftCoords FUNshiftX FUNshiftY =
(
  local LOCshiftProceed  = true

  if rootNode.DYNrootNodeStore.shiftX == 0 and rootNode.DYNrootNodeStore.shiftY == 0 and objects.count == 0 then
  (
    local LOCmessage = DYNuiResourcesQueries[36]
    LOCmessage +=      "\n\n"
    LOCmessage +=      DYNuiResourcesQueries[86]
    LOCmessage +=      "\n\n"
    LOCmessage +=      "X : " + ((FUNshiftX + 100) as string)
    LOCmessage +=      "\n"
    LOCmessage +=      "Y : " + ((FUNshiftY + 100) as string)
    LOCmessage +=      "\n\n"
    LOCmessage +=      DYNuiResourcesQueries[85]
    LOCshiftProceed = YesNoCancelBox LOCmessage title:DYNuiResourcesTitlebars[3] beep:false
  )

  if LOCshiftProceed == #yes then
  (
    rootNode.DYNrootNodeStore.shiftX = FUNshiftX + 100
    rootNode.DYNrootNodeStore.shiftY = FUNshiftY + 100
  )

  LOCshiftProceed -- return value (true, #yes, #no, #cancel)
)

fn DYNFUNprepForImportingVesperFile FUNc3DVspFile FUNshiftX FUNshiftY FUNfeatureInterpSwitch FUNfeatureInterpStyle FUNdnProgress FUNdnStatus =
(
  local LOCshiftProceed  = DYNFUNsetGlobalShiftCoords FUNshiftX FUNshiftY

  local LOCimportProceed = false
  if LOCshiftProceed != #cancel then
  (
    local LOCfisStyle = DYNfeatureInterp.DYNFUNfisStringToFullPath (FUNfeatureInterpStyle as string) -- (just in case returns as undefined)
    if (if FUNfeatureInterpSwitch then (DYNFUNfisPreFlight LOCfisStyle) else true) then
    (
      local LOCyesSwitch = true
      if not FUNfeatureInterpSwitch then (if not rootNode.DYNrootNodeStore.bool02 then (if not DYNFUNfeatureInterpQuery() then LOCyesSwitch = false))
      if LOCyesSwitch then
      (
        actionMan.executeAction 0 "300"             -- Ensure that MAX modify panel is NOT open
        DYNFUNremoveCSProllouts()                   -- This must be carried first to prevent PositionControl rollout from having references to old objects.
        DYNFUNloadVSPnodeCallBacks false            -- Disable Auto-Update of Explorer for each element created

        DYNFUNreadImportColorAndMatIdConfigFile()

        local LOCstart        = timeStamp()
        local LOCobjectsExist = if objects.count == 0 then false else true
        local LOCnewObjArray  = DYNFUNimportVesperFile FUNc3DVspFile DYNc3dSurfaces DYNc3dCorridorSurfaces DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines [DYNc3dImport.LOCshiftX,DYNc3dImport.LOCshiftY]  DYNINIfaceSmoothing (if DYNINIhideDiagonals == "1" then true else false) (if DYNINIoverhangCorrect == "1" then true else false) FUNdnProgress FUNdnStatus DYNc3dPointGroups false DYNmxPointStrings DYNmxShapeStrings DYNmxSurfaceStrings DYN12dPointStrings DYN12dShapeStrings DYN12dSurfaceStrings DYNc3dAlignments DYNc3dPipeNetworks DYNxmlSurfaceStrings DYNxmlShapeStrings DYNxmlPointStrings
        local LOCend          = timeStamp()

        if FUNfeatureInterpSwitch then
        (
          FUNdnStatus.text    = DYNuiResourcesStatusMessages[17]
          DYNfeatureInterp.DYNFUNapplyFeatureInterpretationStyle LOCfisStyle LOCnewObjArray (DYNFUNgetLocalTime()) FUNdnProgress
        )

        DYNFUNloadVSPnodeCallBacks true             -- Enable auto update of Explorer
        DYNFUNnodeCreatedCallback()                 -- will check arrays for invalid node handles, then update Explorer Tree
        DYNproperties.DYNFUNscreenSelectionToList() -- required if no immediate selection is made. A selection would update Properties panel if open
        gc()

        if LOCobjectsExist == false then (max tool zoomextents all; max tool zoomextents all)
        FUNdnProgress.value = 0
        FUNdnStatus.text    = DYNuiResourcesStatusMessages[31] + " (" + (((LOCend - LOCstart) / 1000.0) as string) + DYNuiResourcesUnitsTime[2] + ")"
        LOCimportProceed    = true
      )
    )
  )
  LOCimportProceed -- return value
)
--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

--- CVE Related Initialization Functions
fn DYNFUNinitializeCVEconverter FUNsourceFile FUNconverter FUNclsElemType FUNclsWireColorString FUNclsMaterialString FUNungpMatChan FUNgreyedOutColor FUNcveImportMode =
(
  --- Set Local Variables ----------------------------------------------------------
  /*
  set return value for this function, which can become false in the case of LandXML files only (details below)
  */
  local LOCinitSuccess = true

  --- Initialize 12d Converter  ----------------------------------------------------
  /*
  --- For 12d Converter Only ---------------------------------------------
  When you setup/initialize/instantiate the 12d converter like you do with
  MX/GENIO there's a few differences in the setup process. After creating
  the converter object you should do the following in this order:

    _converter.Initialize();
    // change any properties you wish to change
    _converter.Initialize(filename);

  The first call takes care of setting up the internal defaults. Then
  you get to override those if needed. And then you initialize the actual
  parser that's two layers deeper than where the MX/GENIO "readers" are.
  */
  if FUNcveImportMode == 3 then (FUNconverter.Initialize())

  --- Apply General Settings -------------------------------------------------------
  FUNconverter.UseDoublePrecision       = false
  FUNconverter.DefaultZ                 = 0.0
  FUNconverter.DefaultMaterialId        = FUNungpMatChan

  if FUNcveImportMode != 4 then
  (
    FUNconverter.InvalidItemColor       = DYNFUNdnColor FUNgreyedOutColor
    FUNconverter.UnsupportedItemColor   = DYNFUNdnColor FUNgreyedOutColor
    FUNconverter.UnavailableItemColor   = DYNFUNdnColor FUNgreyedOutColor
  )

  --- Apply Additional Settings for 12d --------------------------------------------
  if FUNcveImportMode == 3 then
  (
    FUNconverter.DefaultNullValue       = 0.0
    FUNconverter.MaximumBadTokens       = 500
    FUNconverter.DefaultOrphanModelName = DYNnoName
    FUNconverter.DefaultStringName      = DYNnoName
  )

  --- Initialize Converter  --------------------------------------------------------
  case FUNcveImportMode of
  (
    1 : (FUNconverter.Initialize())
    2 : (FUNconverter.Initialize())
    3 : (FUNconverter.Initialize FUNsourceFile)
    4 : (LOCinitSuccess = FUNconverter.Initialize FUNsourceFile; if LOCinitSuccess then FUNconverter.Cleanup())
  )
  /*
  LandXML specific .Initilize() notes
  -------------------------------------
  After instancing the Converter object the first thing to do is
  to initialize it. This is a little different from 12D because
  there no longer is a basic initializer. You have to provide the
  name of the LXML file.

  Returns a bool.

  Should be true if all is well. When false one of two things have
  occurred that will prevent the system from dealing with the file
  (at all). Either a namespace could not be created (a serious
  internal error) or the attempt to create one failed with an
  exception. The latter is the case in malformed XML like those
  really ugly test files that are by all standards not even XML.

  When false, bail out of any further activity with the converter
  and the file, notify the user, pop an error.

  After calling Initialize and getting true returned, call the
  Cleanup() method (has no parameters). If you call this prior
  to Initialize() it'll just return false.

  The Cleanup() method will examine the file for nasty NS issues
  like those that exist in some Bentley files and will attempt to
  cleanup the file. A temp file called
  ns_nscln.xml will be created in the user TEMP folder.

  Note that this "redirection" happens transparently in the core
  so while the core knows whether to use the real or temp file, all
  interaction and access will always reflect the name and path
  of the original file (it's a feature, not a bug).

  If you want to have progress events for the Cleanup call you
  should subscribe to Converter.OnCleanup which carries an object
  of:

  Autodesk.CVE.Data.LandXml.LandXmlSimpleProgressEventArgs
  (that's in the core DLL, btw). It contains just two properties
  for its payload, int ProgressValue and string ProcessMessage.

  Immediately after Cleanup() completes (regardless of whether it
  had to do anything), unsubscribe from the event!

  There is no need to set your progress bar to 0 because after
  cleanup is done (and had to do something) the wrapper will fire
  the simple event args as (0, "").
  */

  if LOCinitSuccess then
  (
    --- Add String Types which should not be supported in DVSP -----------------------
    /*
    ---------------------------------------------------------
    List<MxElementType> AdditionalUnsupportedElementTypes
    ---------------------------------------------------------

      This property is exposed so you can add MxElementType's to it
      that should be on the *additional* unsupported "list".

      The main idea here is that certain things are unsupported
      by the core. In addition you want to exclude more than what
      is unsupported by the core. This list which starts off empty
      can be used to .Clear() or .Add(MxElementType) to.

      The trick I've come up with is as follows; this list
      needs to be filled (please avoid duplicate entries) with
      the MxElementType's you want to consider as unsupported
      and needs to be done prior to starting the scan of the
      file.

      After the scan is complete the converter wrapper will go
      through all the models and all elements to seek out the
      ones that match the list and explicitly flags them as
      INVALID!

      The reason for this is that I can control IsValid but
      I can't control IsSupported. The latter is defined by the
      code for each element type and can't be modified outside
      of the core (and even within the core that would lead to
      too many breaking changes, the flag is intended to flag
      core support, not client-code-side support).

      So instead of having second passes of filtering in the
      LV item creation and the not-so-nice ways of how that would
      start to look I went with a solution that allows you to
      extend the default unsupported types by adding your own.

      This means all the flags outlined in the above methods
      will affect your "additional exclusions" 100% the same as
      the by-core exclusions.

      This property and its effects need some testing since there
      are no real provisions in the WB to do this (and I don't
      think there's a good enough reason to add stuff to the WB
      for this since it's a lot of UI code that is easier to
      test from the side that'll be using it; MXS).

      The only thing to keep in mind is; what you consider to be
      "unsupported" for DVSP is actually considered "invalid" to
      the MX core and the converter. The end result should be
      the same effect, though.
    */
    if FUNcveImportMode == 1 or FUNcveImportMode == 2 then
    (
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.MXTextString
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.MXGeometryString
    )
    if FUNcveImportMode == 3 then
    (
      /*
       Supported String Types:
      .Arc : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Circle : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Face : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Feature : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Interface : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Pipe : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Polyline : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .String2D : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .String3D : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .String4D : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Super : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static
      .Tin : <Autodesk.CVE.Data.TwelveD.StringElementType>, read-only, static

        (Not Supported):
      */

      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.Alignment
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.Drainage
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.Pipeline
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.Plot
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.SuperAlignment
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.SuperTin
      FUNconverter.AdditionalUnsupportedElementTypes.add FUNclsElemType.Text
    )

    --- Define ImageList indexes for ListViewItems -----------------------------------
    if FUNcveImportMode != 4 then
    (
      FUNconverter.ModelImageIndex          = 37
      FUNconverter.DefaultElementImageIndex = 7
    )

    if FUNcveImportMode == 1 or FUNcveImportMode == 2 then
    (
      FUNconverter.ElementImageIndex.add FUNclsElemType.MXTriangleString 8
      FUNconverter.ElementImageIndex.add FUNclsElemType.MXPointString 14
      FUNconverter.ElementImageIndex.add FUNclsElemType.MXCadastreString 14
      FUNconverter.ElementImageIndex.add FUNclsElemType.MXSurveyStationString 14
      FUNconverter.ElementImageIndex.add FUNclsElemType.MXSurveyObjectString 14
      FUNconverter.ElementImageIndex.add FUNclsElemType.MXSurveyObservationString 14
      FUNconverter.ElementImageIndex.add FUNclsElemType.MXTextString 39
    )
    if FUNcveImportMode == 3 then
    (
      FUNconverter.ElementImageIndex.add FUNclsElemType.Feature 14
      FUNconverter.ElementImageIndex.add FUNclsElemType.Tin 8
    )

    --- Set Up Wirecolor Defaults based on string label ------------------------------
    /*
    -------------------------------------------------------
    Converter.WireColors
    -------------------------------------------------------
    This is a list of type WireColorExpressionPair.

    The pair class has the following properties:
    .ExpressionString (string, what you set the string to)
    .WireColor (Color, a System.Drawing.Color, .NET color, that is)
    .Expression (read-only, no need to deal with)

    To fill the list, just .Add() newly created objects of type WireColorExpressionPair to it. The .ctor
    args for it are (string, Color). The easiest way to create new System.Drawing.Color is to call the
    .FromArgb(r,g,b) on it (rgb being int's in 0..255).

    When a new WireColorExpressionPair object is created a Regex object is also created. This is what
    will be used in the actual conversion process.

    All items in this list will be processed sequentially so it's important to have the order correct.

    DYNmxModelWireExp Sample:
    #("^[Aa].*", 255, 255, 0, "^[Bb].*", 0, 255, 0, "^[Mm].*", 255, 0, 0, "^[Tt].*", 50, 135, 50, ".*", 230, 80, 130)
    */
    case FUNcveImportMode of
    (
      1 : for i = 1 to DYNmxModelWireExp.count by 4 do (FUNconverter.wirecolors.add (dotNetObject FUNclsWireColorString DYNmxModelWireExp[i] (DYNFUNdnColor (color DYNmxModelWireExp[i+1] DYNmxModelWireExp[i+2] DYNmxModelWireExp[i+3]))))
      2 : for i = 1 to DYNmxModelWireExp.count by 4 do (FUNconverter.wirecolors.add (dotNetObject FUNclsWireColorString DYNmxModelWireExp[i] (DYNFUNdnColor (color DYNmxModelWireExp[i+1] DYNmxModelWireExp[i+2] DYNmxModelWireExp[i+3]))))
      3 : for i = 1 to DYN12dWireExp.count     by 4 do (FUNconverter.wirecolors.add (dotNetObject FUNclsWireColorString DYN12dWireExp[i] (DYNFUNdnColor (color DYN12dWireExp[i+1] DYN12dWireExp[i+2] DYN12dWireExp[i+3]))))
      4 : for i = 1 to DYNxmlWireExp.count     by 4 do (FUNconverter.wirecolors.add (dotNetObject FUNclsWireColorString DYNxmlWireExp[i] (DYNFUNdnColor (color DYNxmlWireExp[i+1] DYNxmlWireExp[i+2] DYNxmlWireExp[i+3]))))
    )

    --- Set Up Material IDs to be Applied to each MX Group Code ---------------------------
    /*
    -------------------------------------------------------
    Converter.Materials
    -------------------------------------------------------
    This property is a List of MaterialExpressionPair.

    The pair class has the following properties:
    .ExpressionString (string, what you set the string to)
    .Material (int, the mat ID)
    .Expression (read-only, no need to deal with)

    To fill the list, just .Add() newly created objects of type MaterialExpressionPair to it. The .ctor
    args for it are (string, int) for the expression string and the material ID.

    When a new MaterialExpressionPair object is created a Regex object is also created. This is what will
    be used in the actual conversion process.

    All items in this list will be processed sequentially so it's important to have the order correct.

    DYNmxModelMatExp Sample:
    #("\w{2}01", 1, "\w{2}02", 2, "\w{2}03", 3, "\w{2}04", 4, "\w{2}05", 5, "\w{2}06", 6, "\w{2}07", 7, "\w{2}08", 8, "\w{2}09", 9, "\w{2}10", 10, ...)
    */

    case FUNcveImportMode of
    (
      1 : for i = 1 to DYNmxModelMatExp.count by 2 do (FUNconverter.materials.add (dotNetObject FUNclsMaterialString DYNmxModelMatExp[i] DYNmxModelMatExp[i+1]))
      2 : for i = 1 to DYNmxModelMatExp.count by 2 do (FUNconverter.materials.add (dotNetObject FUNclsMaterialString DYNmxModelMatExp[i] DYNmxModelMatExp[i+1]))
      3 : for i = 1 to DYN12dMatExp.count     by 2 do (FUNconverter.materials.add (dotNetObject FUNclsMaterialString DYN12dMatExp[i] DYN12dMatExp[i+1]))
      4 : for i = 1 to DYNxmlMatExp.count     by 2 do (FUNconverter.materials.add (dotNetObject FUNclsMaterialString DYNxmlMatExp[i] DYNxmlMatExp[i+1]))
    )

    --- Set up Material IDs to be applied to 12d TIN per-face Color Attributes ------------
    if FUNcveImportMode == 3 then
    (
      for i = 1 to DYN12dMatExp.count by 2 do
      (
        FUNconverter.TinColorMaterials.add (dotNetObject FUNclsMaterialString DYN12dMatExp[i] DYN12dMatExp[i+1])
      )
    )
  )
  LOCinitSuccess -- return value
)

fn DYNFUNloadCVEImportComponents FUNcvePath FUNungpMatChan FUNgreyedOutColor =
(
  --- Set Up GENIO Converter and Reader -------------------------------------------------
  if DYNdnGenioConverter == undefined then
  (
    local LOCasmGenioImporter  = dotNet.loadAssembly (FUNcvePath + "CVE.Import.Genio.v1.dll")
    local LOCclsGenioConverter = dotNetClass "Autodesk.CVE.Import.Genio.Converter"
    DYNdnGenioConverter        = dotNetObject LOCclsGenioConverter
    DYNdnGenioConverter.LastModifiedTimeUtc = true
  )

  --- Set Up MX Converter and Reader ----------------------------------------------------
  if DYNdnMxConverter == undefined then
  (
    local LOCasmMxImporter     = dotNet.loadAssembly (FUNcvePath + "CVE.Import.MX.v1.dll")
    local LOCclsMxConverter    = dotNetClass "Autodesk.CVE.Import.MX.Converter"
    DYNdnMxConverter           = dotNetObject LOCclsMxConverter
  )

  --- Set Up 12d Converter and Reader ---------------------------------------------------
  if DYNdn12dConverter == undefined then
  (
    local LOCasm12dImporter    = dotNet.loadAssembly (FUNcvePath + "CVE.Import.12d.v1.dll")
    local LOCcls12dConverter   = dotNetClass "Autodesk.CVE.Import.TwelveD.Converter"
    DYNdn12dConverter          = dotNetObject LOCcls12dConverter
  )

  --- Set Up LandXML Converter and Reader -----------------------------------------------
  if DYNdnXmlConverter == undefined then
  (
    local LOCasmXmlImporter    = dotNet.loadAssembly (FUNcvePath + "CVE.Import.LandXml.v1.dll")
    local LOCclsXmlConverter   = dotNetClass "Autodesk.CVE.Import.LandXml.Converter"
    DYNdnXmlConverter          = dotNetObject LOCclsXmlConverter
  )
)

fn DYNFUNreadCVEfile FUNconverter FUNsourceFile FUNpreLoadedStrings FUNonModelFoundEventHandler FUNonScanProgressEventHandler FUNonElementFoundEventHandler FUNungpMatChan FUNgreyedOutColor FUNcveImportMode =
(
  local LOCreadSuccess = true
  FUNconverter.Recycle() -- we need to recycle specifically for 12d abstraction layer only

  case FUNcveImportMode of
  (
    1 : DYNFUNinitializeCVEconverter FUNsourceFile DYNdnGenioConverter (dotNetClass "Autodesk.CVE.Data.Genio.GenioElementType") "Autodesk.CVE.Import.Genio.WireColorExpressionPair" "Autodesk.CVE.Import.Genio.MaterialExpressionPair" FUNungpMatChan FUNgreyedOutColor FUNcveImportMode
    2 : DYNFUNinitializeCVEconverter FUNsourceFile DYNdnMxConverter (dotNetClass "Autodesk.CVE.Data.Mx.MxElementType") "Autodesk.CVE.Import.Mx.WireColorExpressionPair" "Autodesk.CVE.Import.Mx.MaterialExpressionPair" FUNungpMatChan FUNgreyedOutColor FUNcveImportMode
    3 : DYNFUNinitializeCVEconverter FUNsourceFile DYNdn12dConverter (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType") "Autodesk.CVE.Import.TwelveD.WireColorExpressionPair" "Autodesk.CVE.Import.TwelveD.MaterialExpressionPair" FUNungpMatChan FUNgreyedOutColor FUNcveImportMode
    4 : LOCreadSuccess = DYNFUNinitializeCVEconverter FUNsourceFile DYNdnXmlConverter undefined "Autodesk.CVE.Import.LandXml.WireColorExpressionPair" "Autodesk.CVE.Import.LandXml.MaterialExpressionPair" FUNungpMatChan FUNgreyedOutColor FUNcveImportMode
  )

  if LOCreadSuccess then
  (
    --- Identify Previously Imported Strings (must occur before ReadContent,
    --- these methods are not supported in LandXML mode which means that .isUnAvailable flags
    --- are set manually below for LandXML elements)
    if FUNcveImportMode != 4 then -- exclude this block from landXML import mode
    (
    /*
      ClearUnavailableElements()
      --------------------------
      Will clear the list that the converter will retain and construct and
      manage internally. This will not clear any flags off any elements,
      though.
    */
    FUNconverter.ClearUnavailableElements()

    /*
     AddUnavailableElement(string modelName, string elementName)
     -----------------------------------------------------------
     Adds a model name and element name to the internal retained storage
     (which is a Dictionary<string, List<string>> actually).

     It returns a bool indicating whether it was successfully added or
     not. If you add something identical more than once it'll only retain
     the one that's already there (and return false).
    */
    for i in FUNpreLoadedStrings do
    (
      local LOCelementNamePair = filterString i "|" splitEmptyTokens:true
      if LOCelementNamePair[1] == "" then LOCelementNamePair[1] = DYNnoName -- this cannot happen with MX/Genio
      if LOCelementNamePair[2] == "" then LOCelementNamePair[2] = DYNnoName
      FUNconverter.AddUnavailableElement (DYNFUNdisplayAppDataInUI LOCelementNamePair[2]) (DYNFUNdisplayAppDataInUI LOCelementNamePair[1])
    )
    )

    --- Start OnScanProgress Event Handlers ------------------------------------
    case FUNcveImportMode of
    (
      1 : if FUNonScanProgressEventHandler != undefined then dotNet.addEventHandler FUNconverter.reader "OnScanProgress" FUNonScanProgressEventHandler
      2 : if FUNonScanProgressEventHandler != undefined then dotNet.addEventHandler FUNconverter.reader "OnScanProgress" FUNonScanProgressEventHandler
      3 : if FUNonScanProgressEventHandler != undefined then dotNet.addEventHandler FUNconverter        "OnScanProgress" FUNonScanProgressEventHandler
      4 : undefined
    )

    --- Start OnElementFound Event Handlers ------------------------------------
    case FUNcveImportMode of
    (
      1 : if FUNonModelFoundEventHandler   != undefined then dotNet.addEventHandler FUNconverter.reader "OnModelFound"   FUNonModelFoundEventHandler
      2 : if FUNonModelFoundEventHandler   != undefined then dotNet.addEventHandler FUNconverter.reader "OnModelFound"   FUNonModelFoundEventHandler
      3 : undefined
      4 : if FUNonElementFoundEventHandler != undefined then dotNet.addEventHandler FUNconverter "OnElementFound" FUNonElementFoundEventHandler
    )

    --- Set Some More Properties -----------------------------------------------
    if FUNcveImportMode == 1 or FUNcveImportMode == 2 then
    (
      FUNconverter.reader.Filename                  = FUNsourceFile
      FUNconverter.reader.IgnoreDuplicateStrings    = true
      FUNconverter.reader.SkipNullTriangles         = true
      FUNconverter.reader.SkipAdjoiningTriangleData = true
      FUNconverter.reader.SkipPointLabelReferences  = true
      FUNconverter.reader.OptimizedTriangleReading  = true
    )

    --- Scan the content of the file -------------------------------------------
    try
    (
      if FUNcveImportMode == 4 then
      (
        /*
          void Converter.Scan()

          Once the Converter has been initialized and Cleanup() called to do its thing (if it determined
          it had to do something) you can call the Scan() method. No returns, no parameters.


          Before calling Scan() you can subscribe to a few events and after it's done you need
          to unsubscribe from them. Whether you want to use the events is up to you.
          They provide info but not perhaps info that a user would be interested in.

          The events are:

          OnElementFound  - Autodesk.CVE.Data.LandXml.LandXmlScanItemEventArgs (core) Has just one string, Name.

          OnError         - Autodesk.CVE.Data.LandXml.LandXmlSimpleProgressEventArgs (core) Has int ProgressValue and string ProcessMessage. But the progress value will always be 0.

          OnPointBagError - Autodesk.CVE.Data.LandXml.LandXmlSimpleProgressEventArgs (core) Has int ProgressValue
                            and string ProcessMessage. But the progress value will always be 0.

          Because no progress events
        */
        if FUNonElementFoundEventHandler != undefined then DYNcveImport.dnProgress.value = 75
        FUNconverter.Scan()
        if FUNonElementFoundEventHandler != undefined then DYNcveImport.dnProgress.value = 100
      )
      else
      (
        /*
          .ReadContent()
          --------------
          This method can throw Exceptions of type Exception and MxException.

          It is not yet clear if the exceptions should be directly handled by MXS or wrapped
          by the import object and then processed into a more digestable form for MXS.
          If we go for wrapping the objReader.ReadContent() call would end up being replaced
          with a objMxConverter.ReadContent() call instead.

          During the ReadContent() process the events relating to scanning will be fired
          if subscribed to, this process has to run its course to completion now. After
          control is return to MXS the internal structure and hierarchy of the reader
          object will have been filled with the "content map" of the data present in the
          file that's been scanned. This data can be queried and examined (for that I
          would refer to the UI based test script).

          For GENIO, this method returns the number of lines read.
          For MX, this method returns the size of the file read.
          For 12D, this method returns void because there is nothing of value to return.
        */
        FUNconverter.ReadContent() -- Note: Exceptions could occur here, they would need to be handled
      )

      --- For LandXML, we must manually set .isUnAvailable flags for each element, because
      --- the LandXML core does not support .ClearUnavailableElements() and .AddUnavailableElement() methods
      if DYNcveImportMode == 4 then -- Specifically for LandXML files
      (
        --- Mark Unavailable cgPoints
        for i = 1 to FUNconverter.cgPoints.count do
        (
          local LOCcgPoints   = FUNconverter.cgPoints.item[i-1]
          local LOCparentName = if LOCcgPoints.parent != undefined then LOCcgPoints.parent.name else " "
          local LOCcgPntsName = if LOCcgPoints.name == "" then " " else LOCcgPoints.name
          local LOCsearchPattern = LOCcgPntsName + "$!!$0|" + LOCparentName + "|14"
          if findItem FUNpreLoadedStrings LOCsearchPattern > 0 then
          (
            LOCcgPoints.isUnavailable = true
          )
        )

        --- Mark Unavailable Surface Meshes
        for i = 1 to FUNconverter.surfaces.count do
        (
          local LOCsurface  = FUNconverter.surfaces.item[i-1]
          local LOCsurfName = if LOCsurface.name == "" then " " else LOCsurface.name
          local LOCsearchPattern = LOCsurfName + "$!!$4|" + LOCsurface.name + "|8"
          if findItem FUNpreLoadedStrings LOCsearchPattern > 0 then
          (
            LOCsurface.isUnavailable = true
          )

          --- Mark Unavailable Surface Breaklines
          for ii = 1 to LOCsurface.AllBreaklines.count do
          (
            local LOCbreakline     = LOCsurface.AllBreaklines.item[ii-1]
            local LOCparent        = LOCbreakline.parent.parent
            local LOCparentName    = if LOCparent.name == "" then " " else LOCparent.name
            local LOCbreaklineName = if LOCbreakline.name == "" then " " else LOCbreakline.name
            local LOCsearchPattern = LOCbreaklineName + "$!!$2|" + LOCparentName + "|7"
            if findItem FUNpreLoadedStrings LOCsearchPattern > 0 then
            (
              LOCbreakline.isUnavailable = true
            )
          )
        )
      )
    )
    catch
    (
      LOCreadSuccess = false
    )

    --- Remove all event handlers (not doing so will screw up garbage disposal)
    case FUNcveImportMode of
    (
      1 : dotNet.removeAllEventHandlers FUNconverter.reader
      2 : dotNet.removeAllEventHandlers FUNconverter.reader
      3 : dotNet.removeAllEventHandlers FUNconverter
      4 : dotNet.removeAllEventHandlers FUNconverter
    )
  )

  --- Return Success State
  LOCreadSuccess -- return value
)

fn DYNFUNreadSelectedData FUNconverter FUNsourceFile FUNprogressBar FUNstatusText FUNOnReadProgressEventHandlerForMx FUNOnReadProgressEventHandlerFor12d FUNOnReadProgressEventHandlerForXml FUNOnTriangleOptimizationEventHandler FUNcveImportMode =
(
  local LOCtotalElementsRead = 0

  --- Add OnReadProgress Event Handlers -------------------------------------
  case FUNcveImportMode of
  (
    1 : if FUNOnReadProgressEventHandlerForMx  != undefined then (dotNet.addEventHandler FUNconverter.reader "OnReadProgress" FUNOnReadProgressEventHandlerForMx)
    2 : if FUNOnReadProgressEventHandlerForMx  != undefined then (dotNet.addEventHandler FUNconverter.reader "OnReadProgress" FUNOnReadProgressEventHandlerForMx)
    3 : if FUNOnReadProgressEventHandlerFor12d != undefined then (dotNet.addEventHandler FUNconverter        "OnReadProgress" FUNOnReadProgressEventHandlerFor12d)
    4 : if FUNOnReadProgressEventHandlerForXml != undefined then (dotNet.addEventHandler FUNconverter        "OnReadProgress" FUNOnReadProgressEventHandlerForXml)
  )

  --- Add OnTriangleOptimization Event Handlers -----------------------------
  case FUNcveImportMode of
  (
    1 : if FUNOnTriangleOptimizationEventHandler != undefined then (dotNet.addEventHandler FUNconverter.reader "OnTriangleOptimization" FUNOnTriangleOptimizationEventHandler)
    2 : if FUNOnTriangleOptimizationEventHandler != undefined then (dotNet.addEventHandler FUNconverter.reader "OnTriangleOptimization" FUNOnTriangleOptimizationEventHandler)
    3 : undefined
    4 : undefined
  )

  --- Read Selected Elements From File --------------------------------------
  /*
    Assuming a selection has been made, the data reading process needs to be started
    NOTE: (!!!) This method can throw Exceptions of type Exception and MxException

    Events will fire during the reading process and upon completion of the reading
    process the data for the selected elements will be contained inside the Data
    hierarchy of the reader object.

    The number of selected elements and total elements read can be compared to
    determine if there were any elements that haven't been read.
  */

  /*
  LandXML Specific notes:

  Before calling read, subscribe to the events you wish to receive
  and unsubscribe after the Read() call ends. Two events should be
  familiar already from what you need for Scan(), those are

    Converter.OnError and Converter.OnPointBagError.
  */

  /*
  List<ModelElementPair> GetElementsWithErrors()  (does not apply to LandXML Import)

  You need to grab the return value from the core ReadData() method
  since it is the # of successfully read elements. TheN you need to get
  the property Converter.Reader.NumberOfSelectedElements.

  Subtract the return value from the # of selected and you get a
  value that should be 0 if all elements were read correctly. But
  if it's not there must have been reading errors! That's where the
  method above comes in.

  It gets you a generic list of type ModelElementPair. Each pAir
  has an MxModel and MxElement (or GenioModel and GenioElement for
  GENIO). The reason it's a pair is because elements don't know
  about their model parent in the MX and GENIO cores (a minor
  oversight in the design but not a huge problem) so you can
  get the Model.Name and other model related info from the model
  and element related info from the element.

  What you are going to be most interested in for the items in
  the pair list is the Element.ErrorCondition string. That's what
  captures a string description that might indicate what went
  wrong during the reading process.

  If it's one of our custom MxExceptions then the string will
  be:  gex.ErrorReason + ": " + gex.Message, otherwise it will
  be the full string of the system/application exception instead.

  How you want to display these or deal with them is up to you
  because the converter is just enabling the collection of the
  information and making it available.
  */

  DYNcveReadErrorArray   = #()
  case FUNcveImportMode of
  (
    1 : (LOCtotalElementsRead = try (FUNconverter.reader.ReadData()) catch (0);                            DYNcveReadErrorArray = FUNconverter.GetElementsWithErrors())
    2 : (LOCtotalElementsRead = try (FUNconverter.reader.ReadData FUNconverter.reader.filename) catch (0); DYNcveReadErrorArray = FUNconverter.GetElementsWithErrors())
    3 : (LOCtotalElementsRead = try (FUNconverter.Read()) catch (0);                                       DYNcveReadErrorArray = FUNconverter.GetElementsWithErrors())
    4 : (LOCtotalElementsRead = try (FUNconverter.Read()) catch (0);                                      /* LandXML flavour does not support .GetElementsWithErrors*/)
  )

  --- TODO: Temporary Line Used During Development, because .read() doesn't yet return number of elements read
  if FUNcveImportMode == 4 then
  (
    /*
    In LandXML, the number of selected Surface Breaklines is not included in the total returned from .read(). This is
    because .read() only reads surface meshes and cgPoints objects.  Breaklines are read in full during the earlier initial
    scan of the file.

    Because the user might only have selected breaklines, it's important to add any selected breaklines to the TotalElementsRead
    count, to ensure that this count does not return zero where no surface meshes or cgPoints have been selected for import.
    */

    local LOCallSurfaces = FUNconverter.Surfaces
    for i = 1 to LOCallSurfaces.count do (LOCtotalElementsRead += LOCallSurfaces.item[i-1].SelectedBreaklines.count)
  )

  --- Decide What XY Shift Should Be Applied To Incoming Geometry -----------
  local LOCshiftResult = FUNconverter.ComputeShift()
  /*
  .ComputeShift() should be called BEFORE .Convert()

  It calculates the XY extent of all selected elements and feeds the minXY exent into
  the ShiftX and ShiftY properties of the converter.

  This is not the same as the user specified global shifts. The purpose of ComputeShift
  is purely to ensure that floats in the file are written as the smallest possible values.

  ComputeShift() will return a boolean. True if a shift was computed and false if
  not (in case the boundary is a min/max default).

  After calling ComputeShift() you can get (or even set or change) the Shift properties.
  */

  --- Remove all event handlers (not doing so will screw up GC) -------------
  case FUNcveImportMode of
  (
    1 : dotNet.removeAllEventHandlers FUNconverter.reader
    2 : dotNet.removeAllEventHandlers FUNconverter.reader
    3 : dotNet.removeAllEventHandlers FUNconverter
    4 : dotNet.removeAllEventHandlers FUNconverter
  )

  LOCtotalElementsRead > 0 -- return true/false
)

fn DYNFUNimportCVEfile FUNconverter FUNsourceFile FUNprogressBar FUNstatusText FUNOnConversionProgressEventHandlerForMx FUNOnConversionProgressEventHandlerFor12d FUNOnWriteProgressEventhandler FUNOnWriteIndexProgressEvent FUNtempPath FUNcveImportMode =
(
  --- Set Variables ---------------------------------------------------------
  local LOCsuccessSwitch = true
  local LOCnewObjArray   = #()
  local LOCshiftX        = 0
  local LOCshiftY        = 0
  local LOCshiftZ        = 0
  local LOCtempVSP3Dfile = FUNtempPath + (getFilenameFile FUNsourceFile) + ".vsp3d"

  --- Load OnWriteProgress Event Handlers [ for .Write() ] ------------------
  case FUNcveImportMode of
  (
    1 : if FUNOnWriteProgressEventhandler != undefined then dotNet.addEventHandler FUNconverter "OnWriteProgress" FUNOnWriteProgressEventhandler
    2 : if FUNOnWriteProgressEventhandler != undefined then dotNet.addEventHandler FUNconverter "OnWriteProgress" FUNOnWriteProgressEventhandler
    3 : if FUNOnWriteProgressEventhandler != undefined then dotNet.addEventHandler FUNconverter "OnWriteProgress" FUNOnWriteProgressEventhandler
    4 : if FUNOnWriteProgressEventhandler != undefined then dotNet.addEventHandler FUNconverter "OnWriteProgress" FUNOnWriteProgressEventhandler
  )

  --- Load OnWriteIndexProgress Event Handlers [ for .Write() ] -------------
  case FUNcveImportMode of
  (
    1 : if FUNOnWriteIndexProgressEvent != undefined then dotNet.addEventHandler FUNconverter "OnWriteIndexProgress" FUNOnWriteIndexProgressEvent
    2 : if FUNOnWriteIndexProgressEvent != undefined then dotNet.addEventHandler FUNconverter "OnWriteIndexProgress" FUNOnWriteIndexProgressEvent
    3 : if FUNOnWriteIndexProgressEvent != undefined then dotNet.addEventHandler FUNconverter "OnWriteIndexProgress" FUNOnWriteIndexProgressEvent
    4 : if FUNOnWriteIndexProgressEvent != undefined then dotNet.addEventHandler FUNconverter "OnWriteIndexProgress" FUNOnWriteIndexProgressEvent
  )

  --- Load OnConversionProgress Event Handlers [ for .Convert() ] -----------
  case FUNcveImportMode of
  (
    1 : if FUNOnConversionProgressEventHandlerForMx  != undefined then dotNet.addEventHandler FUNconverter "OnConversionProgress" FUNOnConversionProgressEventHandlerForMx
    2 : if FUNOnConversionProgressEventHandlerForMx  != undefined then dotNet.addEventHandler FUNconverter "OnConversionProgress" FUNOnConversionProgressEventHandlerForMx
    3 : if FUNOnConversionProgressEventHandlerFor12d != undefined then dotNet.addEventHandler FUNconverter "OnConversionProgress" FUNOnConversionProgressEventHandlerFor12d
    4 : undefined
  )

  --- Convert raw data for selected strings into Vesper Data (VSP3D) --------
  DYNcveBuildErrorArray       = #() -- Reset Global Array
  /*
  Converter.Convert()
  -------------------
  This method should be called after reading the data and dealing with the
  GetElementsWithErrors() results (if you want to deal with those).

  Elements that will be converted are those that are explicitly coded into the dispatch process *and*
  they have to be IsSelected *and* IsValidRead. Elements that have been reported with
  GetElementsWithErrors() will not be converted and processed (because IsValidRead = false).

  This method return a List<ModelElementPair> which you can handle similarly to GetElementsWithErrors().
  Except there's a little more to do with the returned data. The pairs that are returned are elements
  that *could not be built* (that's the original terminology in the core but in this case the term
  *could not be converted* is more appropriate).

  There are *many* reasons that things can't be built/converted as you will remember from the C3D
  importers. However, we have already implemented the validation and handling of all this in the cores!
  The build targets C3D and Dynamite have always been part of it. So if there are any errors in the
  Dynamite specifics they have been there all along. Reasons for not building are things like strings
  with 1 point, discons in the wrong format, etc.

  When you grab the return value of this method you can use the Element.CannotBuildReason (string)
  property to get a string (like those in C3D's importers) that give you the details of why.

  Note that this method may return NULL if nothing could be converted or if there
  was nothing selected, etc. Should never happen if your side of the code
  prevents calling the read and conversion when there's nothing to do.

  It is also possible the returned collection has .Count = 0 which would be good since that implies
  there were no elements that could not be converted/built.
  */

  local LOCresults = FUNconverter.Convert()

  if FUNcveImportMode != 4 then -- Don't implement these checks for LandXML mode because they were never implemented
  (
    if LOCresults == undefined then
    (
      LOCsuccessSwitch = false -- Note that this method may return NULL if nothing could be converted or if there was nothing selected, etc.
    )
    else
    (
      if LOCresults.count > 0 then (DYNcveBuildErrorArray = LOCresults) -- This method return a List<ModelElementPair> which are elements which could *not* be built. Place this into a global array now.
    )
  )

  --- Write Converted Vesper Objects to VSP3D FIle --------------------------
  if LOCsuccessSwitch then
  (
    try
    (
      /*  This method can throw exceptions, so needs to be wrapped in try/catch (Given the file I/O nature
          of this method, a wide range of things can go wrong).
          This method does not delete the temporary VSP3D file afterwards
      */
      FUNconverter.write LOCtempVSP3Dfile
    )
    catch (LOCsuccessSwitch = false)
  )

  --- Read VSP3D File -------------------------------------------------------
  if LOCsuccessSwitch then
  (
    local LOCc3dVspInfo = DYNFUNreadVesperFile LOCtempVSP3Dfile

    --- Set Shift Values ----------------------------------------------------
    LOCshiftX = LOCc3dVspInfo[5]
    LOCshiftY = LOCc3dVspInfo[6]
    LOCshiftZ = LOCc3dVspInfo[7]

    --- Set IsSelected Flags for All VSP3D File Content to TRUE -------------
    for i = 1 to DYNmxShapeStrings.count    do DYNmxShapeStrings[i][9]     = true
    for i = 1 to DYNmxSurfaceStrings.count  do DYNmxSurfaceStrings[i][9]   = true
    for i = 1 to DYNmxPointStrings.count    do DYNmxPointStrings[i][9]     = true

    for i = 1 to DYN12dShapeStrings.count   do DYN12dShapeStrings[i][8]    = true
    for i = 1 to DYN12dSurfaceStrings.count do DYN12dSurfaceStrings[i][8]  = true
    for i = 1 to DYN12dPointStrings.count   do DYN12dPointStrings[i][8]    = true

    for i = 1 to DYNxmlShapeStrings.count   do DYNxmlShapeStrings[i][10]   = true
    for i = 1 to DYNxmlSurfaceStrings.count do DYNxmlSurfaceStrings[i][10] = true
    for i = 1 to DYNxmlPointStrings.count   do DYNxmlPointStrings[i][10]   = true

    if (DYNmxPointStrings.count + DYNmxSurfaceStrings.count + DYNmxShapeStrings.count + DYN12dPointStrings.count + DYN12dSurfaceStrings.count + DYN12dShapeStrings.count + DYNxmlShapeStrings.count + DYNxmlSurfaceStrings.count + DYNxmlPointStrings.count) == 0 then
    (
      LOCsuccessSwitch = false
    )
  )

  --- Import Temporary VSP3D File -------------------------------------------
  if LOCsuccessSwitch then
  (
    LOCnewObjArray = DYNFUNimportVesperFile LOCtempVSP3Dfile DYNc3dSurfaces DYNc3dCorridorSurfaces DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines [LOCshiftX,LOCshiftY] DYNINIfaceSmoothing (if DYNINIhideDiagonals == "1" then true else false) (if DYNINIoverhangCorrect == "1" then true else false) FUNprogressBar FUNstatusText DYNc3dPointGroups false DYNmxPointStrings DYNmxShapeStrings DYNmxSurfaceStrings DYN12dPointStrings DYN12dShapeStrings DYN12dSurfaceStrings DYNc3dAlignments DYNc3dPipeNetworks DYNxmlSurfaceStrings DYNxmlShapeStrings DYNxmlPointStrings
  )

  --- Delete Temporary VSP3D File -------------------------------------------
  deleteFile LOCtempVSP3Dfile

  --- Override VSP3D filename in AppData for All Created Vesper Objects -----
  for i in LOCnewObjArray do
  (
    if isvalidNode i then setAppData i 424 FUNsourceFile
  )

  --- Remove all event handlers (not doing so will screw up GC) -------------
  dotNet.removeAllEventHandlers FUNconverter

  --- Finish Up
  FUNprogressBar.value = 0

  --- Return true/false to indicate whether import process was successful ---
  LOCnewObjArray   -- return value
)

fn DYNFUNcompareVsp3DAppDataStrings FUNappDataMatch428 FUNtagType FUNdataArrayItem =
(
  local LOCAppDataStringA_IN  = FUNappDataMatch428
  local LOCAppDataStringB_IN  = (DYNFUNgenerateC3DrelatedAppData FUNtagType FUNdataArrayItem)[2]

  --- Remove Handle (3rd Item) from AppDataStringA
  local LOCAppDataArrayA      = filterString LOCAppDataStringA_IN "$!!$"
  LOCAppDataArrayA[3]         = "HANDLE"
  local LOCAppDataStringA_OUT = DYNFUNarray2DelimitedString LOCAppDataArrayA "$!!$"

  --- Remove Handle (3rd Item) from AppDataStringB
  local LOCAppDataArrayB      = filterString LOCAppDataStringB_IN "$!!$"
  LOCAppDataArrayB[3]         = "HANDLE"
  local LOCAppDataStringB_OUT = DYNFUNarray2DelimitedString LOCAppDataArrayB "$!!$"

  --- Compare Two Strings
  striCmp LOCAppDataStringA_OUT LOCAppDataStringB_OUT
)

fn APCFUNextractObjectDrapeCoordsToArrays FUNobjCategory FUNobj FUNindex1 FUNindex2 =
(
  local LOCresult -- return value is undefined by default
  if FUNobjCategory == 8 then
  (
    --- Ensure that Drape AppData is in V3.5 Form (converts array notation type to delimited string starting with "@")
    DYNFUNupdateDrapingCoords FUNobj

    --- Extract AppData from Object
    local LOCappData426  = getAppData FUNobj 426

    --- If AppData is in readable form, extract delimited string and convert to float/integer based output arrays
    if (subString LOCappData426 1 1) == "@" then
    (
      local LOCarrayByMatID = filterString LOCappData426 "|"

      --- array count must be at least two because first entry is always "@". Example - "@|1134.73$1345.37$2494.36$3629.62$31"
      if LOCarrayByMatID.count >= 2 then
      (
        --- Read Array of Stored Draping Coords for each MatID, and convert to floats/integers for temporary storage in new arrays
        local LOCarrayDrapeCoordsForOutput = #()
        for iii = 2 to LOCarrayByMatID.count do
        (
          local LOCcoordArray = filterString LOCarrayByMatID[iii] "$"
          if LOCcoordArray.count == 5 then
          (
            LOCcoordArray[1]  = LOCcoordArray[1] as float
            LOCcoordArray[2]  = LOCcoordArray[2] as float
            LOCcoordArray[3]  = LOCcoordArray[3] as float
            LOCcoordArray[4]  = LOCcoordArray[4] as float
            LOCcoordArray[5]  = LOCcoordArray[5] as integer-- needs to be a string...
            append LOCarrayDrapeCoordsForOutput LOCcoordArray
          )
        )

        ---- Output to various temporary storage arrays
        if LOCarrayDrapeCoordsForOutput.count > 0 then
        (
          LOCresult = LOCarrayDrapeCoordsForOutput
        )
      )
    )
  )
  LOCresult -- return value
)

fn APCFUNreOrderNewObjectArray FUNunOrderedNewObjInputArray FUNorderedOldObjInputArray FUNfileType =
(
  local LOCorderedNewObjOutputArray = #()
  LOCorderedNewObjOutputArray.count = FUNunOrderedNewObjInputArray.count

  for i = 1 to FUNunOrderedNewObjInputArray.count do
  (
    if isValidNode FUNunOrderedNewObjInputArray[i] then
    (
      for ii = 1 to FUNorderedOldObjInputArray.count do
      (
        local LOCappData427new   = getAppData FUNunOrderedNewObjInputArray[i] 427
        local LOCappData428new   = getAppData FUNunOrderedNewObjInputArray[i] 428

        local LOCappData427exist = getAppData FUNorderedOldObjInputArray[ii] 427
        local LOCappData428exist = getAppData FUNorderedOldObjInputArray[ii] 428

        if FUNfileType == ".VSP3D" then
        (
          --- Remove Handle (3rd Item) from AppDataStringA
          local LOCAppDataArrayA      = filterString LOCappData428exist "$!!$"
          LOCAppDataArrayA[3]         = "HANDLE"
          local LOCAppDataStringA_OUT = DYNFUNarray2DelimitedString LOCAppDataArrayA "$!!$"

          --- Remove Handle (3rd Item) from AppDataStringA
          local LOCAppDataArrayB      = filterString LOCappData428new "$!!$"
          LOCAppDataArrayB[3]         = "HANDLE"
          local LOCAppDataStringB_OUT = DYNFUNarray2DelimitedString LOCAppDataArrayB "$!!$"

          --- COMPARE MODIFIED STRINGS, AFTER HANDLE HAS BEEN SET TO HARD CODED VALUE (SEE NOTES IN DYNFUNcompareVsp3DAppDataStrings for details)
          if (striCmp LOCappData427exist LOCappData427new) == 0 and (striCmp LOCAppDataStringA_OUT LOCAppDataStringB_OUT) == 0 then
          (
            LOCorderedNewObjOutputArray[ii] = FUNunOrderedNewObjInputArray[i]
          )
        )
        else
        (
          if (striCmp LOCappData427exist LOCappData427new) == 0 and (striCmp LOCappData428exist LOCappData428new) == 0 then
          (
            LOCorderedNewObjOutputArray[ii] = FUNunOrderedNewObjInputArray[i]
          )
        )
      )
    )
  )
  LOCorderedNewObjOutputArray -- return value
)

fn APCFUNreOrderWrapper FUNtempUnorderedNewObjectArray FUNoldObjectArray FUNnewObjectArray FUNarrayIndex FUNfilteredObjSwitch FUNsourceFile =
(
  local LOCproceedSwitch = true

  --- Check Size of New Object Array then re-order New Object Array to Ensure Match with object order in Old Object Array
  if FUNtempUnorderedNewObjectArray.count == FUNoldObjectArray[FUNarrayIndex].count then
  (
    FUNnewObjectArray[FUNarrayIndex] = APCFUNreOrderNewObjectArray FUNtempUnorderedNewObjectArray FUNoldObjectArray[FUNarrayIndex] FUNsourceFile
  )
  else (LOCproceedSwitch = false)

  --- Sort Out AppData ----------------------------------
  for ii = 1 to FUNnewObjectArray[FUNarrayIndex].count do
  (
    if isValidNode FUNnewObjectArray[FUNarrayIndex][ii] then
    (
      if FUNfilteredObjSwitch[FUNarrayIndex][ii] == 8 then
      (
        append DYNobjHandles[8] FUNnewObjectArray[FUNarrayIndex][ii].inode.handle
        setAppData FUNnewObjectArray[FUNarrayIndex][ii] 422 "8"
      )
      else
      (
        append DYNobjHandles[7] FUNnewObjectArray[FUNarrayIndex][ii].inode.handle
      )
    )
  )
  LOCproceedSwitch -- return value
)

--- The following function is a general global one, but must be here as contains references to APC functions which are only loaded above
fn APCFUNupdateImportedObjects FUNobjArray FUNshowFoundSwitch FUNtempPath =
(
  --- Ensure that all Import panels are loaded before starting import operation
  if DYNdxfImport     == undefined then fileIn (DYNscriptsPath + "DxfImport.ms")
  if DYNcveImport     == undefined then fileIn (DYNscriptsPath + "CveImport.ms")
  if DYNc3dImport     == undefined then fileIn (DYNscriptsPath + "C3dImport.ms")

  ---------------------------------------------------------------------------------------------------------------------
  --- Initialise function and create local variables ------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  DYNFUNdisplayMessage DYNuiResourcesTitlebars[3] DYNuiResourcesStatusMessages[64]

  --- Manual Garbage Collection added at Civil View 2012
  gc()

  --- Read Color and Mat ID Config File for Import
  DYNFUNreadImportColorAndMatIdConfigFile() -- load colours from CivilView.cfg file

  --- Display Progress Bar Whilst Importing
  local LOCprogressPanel = DYNFUNdisplayProgressPanel()
  createDialog LOCprogressPanel width:619 height:70 modal:false
  LOCprogressPanel.LBDYNstatus1.text = DYNuiResourcesStatusMessages[65]

  local LOCprogressBar   = LOCprogressPanel.dnProgress
  local LOCprogressLabel = LOCprogressPanel.LBDYNstatus2

  --- Set Up Local Variables
  local LOCproceedSwitch        = true

  local LOCfileArray            = #() -- An array of filenames
  local LOCfileExtArray         = #() -- A two dimensional array of filename Extensions filtered by source file
  local LOCfileFilteredContents = #() -- A two dimensional array of file contents filtered by source file
  local LOCfilteredTempObjects  = #() -- A two dimensional array of existing objects filtered by source file
  local LOCfilteredNewObjects   = #() -- A two dimensional array of new objects filtered by source file
  local LOCfilteredObjSwitch    = #() -- A two dimensional array of object classes filtered by source file

  local LOCnewObjects           = #() -- The final FLAT array of new objects which is returned at the end of this function
  local LOCdependentObjCnt      = 0
  local LOCdrapeCrdsArray       = #()
  local LOCdrapeIndexArray      = #()
  local LOCsceneMats            = sceneMaterials -- Grab Reference to SceneMaterials -- quicker than repeated references to this global array
  local LOCfindDupsContinue     = true -- used to check whether duplicate strings from the same model and same source file have been selected for updating.
  local LOCacceptedALLFormats   = #(".TXT",".CRD",".MOS",".FIL",".12DA",".4DA",".XML",".VSP3D")
  local LOCacceptedCVEformats   = #(".TXT",".CRD",".MOS",".FIL",".12DA",".4DA",".XML")

  ---------------------------------------------------------------------------------------------------------------------
  --- Carry out initial checks and decide whether to proceed ----------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------

  LOCprogressLabel.text = DYNuiResourcesStatusMessages[64]

  --- If any selected objects are not created from an implemented file format, do not proceed (exclude DXF data for time being)
  LOCprogressBar.value = 10
  for i = FUNobjArray.count to 1 by -1 do
  (
    local LOCfileName = DYNFUNupperCase (try (getfilenametype (getappdata FUNobjArray[i] 424)) catch (".dump")) 0  -- If filename not found make a dummy file suffix, and ensure UPPERCASE
    if (findItem LOCacceptedALLFormats LOCfileName) == 0 then
    (
      destroyDialog DYNmessageRollout
      messagebox (DYNuiResourcesErrorsWarnings[105]) title:DYNuiResourcesTitlebars[1]
      LOCproceedSwitch = false
    )
  )

  --- Build Object Info Arrays
  LOCprogressBar.value = 20
  if LOCproceedSwitch then
  (
    for i = 1 to FUNobjArray.count do
    (
      local LOCfound = findItem LOCfileArray (getAppData FUNobjArray[i] 424)
      if LOCfound == 0 then
      (
        append LOCfileArray (getAppData FUNobjArray[i] 424)
        append LOCfileExtArray (DYNFUNupperCase (getFilenameType (getAppData FUNobjArray[i] 424)) 0)
        append LOCfileFilteredContents #()
        append LOCfilteredTempObjects #()
        append LOCfilteredNewObjects #()
        append LOCfilteredObjSwitch #()
        append LOCfilteredTempObjects[LOCfilteredTempObjects.count] FUNobjArray[i]
        append LOCfilteredObjSwitch[LOCfilteredObjSwitch.count] ((getAppData FUNobjArray[i] 422) as integer)
        LOCfilteredNewObjects[LOCfilteredNewObjects.count].count = LOCfilteredTempObjects[LOCfilteredTempObjects.count].count
      )
      else
      (
        append LOCfilteredTempObjects[LOCfound] FUNobjArray[i]
        append LOCfilteredObjSwitch[LOCfound] ((getAppData FUNobjArray[i] 422) as integer)
        LOCfilteredNewObjects[LOCfound].count = LOCfilteredTempObjects[LOCfound].count
      )
    )
  )

  --- Check whether all selected source files actually exist. If any don't exist, do not continue, display an error.
  LOCprogressBar.value = 30
  if LOCproceedSwitch then
  (
    local LOCmissingFile = ""
    for i in LOCfileArray do
    (
      if (getFiles i).count == 0 then (LOCmissingFile = FileNameFromPath i; LOCproceedSwitch = false)
    )
    if not LOCproceedSwitch then
    (
      destroyDialog DYNmessageRollout
      messagebox (LOCmissingFile + "\n\n" + DYNuiResourcesErrorsWarnings[95]) title:DYNuiResourcesTitlebars[1]
    )
  )


  --- Check that each object in the input array has both a model/layer source name and a object/string source name. Without this we cannot identify the correct object in the source file
  LOCprogressBar.value = 40
  if LOCproceedSwitch then
  (
    for i = 1 to FUNobjArray.count do
    (
      if LOCproceedSwitch then
      (
        local LOCobjAppData = DYNFUNgetObjAppData FUNobjArray[i] "-"

        --- If model name / layer or string name / object is blank, cannot proceed
        if LOCobjAppData[7] == "-" or LOCobjAppData[8] == "-" then (LOCproceedSwitch = false)

        --- Allow only string/object name to be enough if object derived from LandXML file only
        if LOCobjAppData[7] != "-" and (DYNFUNupperCase (getFilenameType LOCobjAppData[4]) 0) == ".XML" then LOCproceedSwitch = true
      )
    )
    if not LOCproceedSwitch then
    (
      destroyDialog DYNmessageRollout
      messagebox DYNuiResourcesErrorsWarnings[96] title:DYNuiResourcesTitlebars[1]
    )
  )


  ---------------------------------------------------------------------------------------------------------------------
  --- Check whether source data for the selected strings actually exists in source file -------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  if LOCproceedSwitch then
  (
    local LOCobjNamesNotFound = #()
    LOCprogressBar.value = 50
    for i = 1 to LOCfileExtArray.count do
    (
      LOCprogressBar.value = ((i as float) / (LOCfileExtArray.count as float) * 50.0) + 50.0

      --------------------------- 12DA, LANDXML, MX MODEL and GENIO SOURCE FILES (CVE) ------------------------------------------------------------------------------------------------------
      ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
      if ((findItem LOCacceptedCVEFormats LOCfileExtArray[i]) > 0) and LOCproceedSwitch then
      (
        LOCprogressLabel.text = DYNuiResourcesStatusMessages[64]

        DYNFUNloadCVEImportComponents DYNbinPath DYNINIungpMatChan DYNINIgreyedOutColor

        local LOCconverter     = DYNdnGenioConverter
        local LOCcveImportMode = 1

        if (LOCfileExtArray[i] == ".TXT" or LOCfileExtArray[i] == ".CRD" or LOCfileExtArray[i] == ".MOS") then
        (
          LOCconverter     = DYNdnGenioConverter
          LOCcveImportMode = 1
        )
        if (LOCfileExtArray[i] == ".FIL") then
        (
          LOCconverter     = DYNdnMxConverter
          LOCcveImportMode = 2
        )
        if (LOCfileExtArray[i] == ".12DA" or LOCfileExtArray[i] == ".4DA") then
        (
          LOCconverter     = DYNdn12dConverter
          LOCcveImportMode = 3
        )
        if (LOCfileExtArray[i] == ".XML") then
        (
          LOCconverter     = DYNdnXmlConverter
          LOCcveImportMode = 4
        )


        local LOCreadSuccess  = DYNFUNreadCVEfile LOCconverter LOCfileArray[i] #() undefined undefined undefined DYNINIungpMatChan DYNINIgreyedOutColor LOCcveImportMode

        if LOCreadSuccess then
        (
          for ii = 1 to LOCfilteredTempObjects[i].count do
          (
            local LOCstringsFound = false
            local LOCstringLabel
            local LOCmodelName

            --- For MX and GENIO based files specifically
            if LOCcveImportMode == 1 or LOCcveImportMode == 2 then
            (
              LOCstringLabel       = getAppData LOCfilteredTempObjects[i][ii] 427
              LOCmodelName         = getAppData LOCfilteredTempObjects[i][ii] 428
              local LOCelementType = LOCconverter.getElement LOCmodelName LOCstringLabel -- No conversion to Upper Case is required because method is case insensitive  (returns ElementType)

              if LOCelementType != undefined then LOCstringsFound = true
            )

            --- For 12da files specifically
            if LOCcveImportMode == 3 then
            (
              local LOCappData427 = filterString (getAppData LOCfilteredTempObjects[i][ii] 427) "$!!$"
              LOCstringLabel      = LOCappData427[1]
              local LOCstringType = LOCappData427[2] -- will be undefined if only one item in array, so this is a safe assumption
              if LOCstringType == undefined then LOCstringType = ""

              LOCmodelName        = getAppData LOCfilteredTempObjects[i][ii] 428

              local LOCelementType
              if (striCmp LOCstringType "Alignment"     ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Alignment
              if (striCmp LOCstringType "Arc"           ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Arc
              if (striCmp LOCstringType "Circle"        ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Circle
              if (striCmp LOCstringType "Drainage"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Drainage
              if (striCmp LOCstringType "Face"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Face
              if (striCmp LOCstringType "Feature"       ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Feature
              if (striCmp LOCstringType "Interface"     ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Interface
              if (striCmp LOCstringType "Pipe"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Pipe
              if (striCmp LOCstringType "Pipeline"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Pipeline
              if (striCmp LOCstringType "Plot"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Plot
              if (striCmp LOCstringType "Polyline"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Polyline
              if (striCmp LOCstringType "String2D"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").String2D
              if (striCmp LOCstringType "String3D"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").String3D
              if (striCmp LOCstringType "String4D"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").String4D
              if (striCmp LOCstringType "Super"         ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Super
              if (striCmp LOCstringType "SuperAlignment") == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").SuperAlignment
              if (striCmp LOCstringType "SuperTin"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").SuperTin
              if (striCmp LOCstringType "Text"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Text
              if (striCmp LOCstringType "Tin"           ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Tin

              if LOCelementType != undefined then
              (
                /*
                Available Methods:
                  StringModel GetModel(string name)
                  StringModelWrapper GetModelWrapper(string name)
                  List<StringElement> GetElementsByName(string modelName, string elementName)
                  List<StringElement> GetElementsByType(string modelName, StringElementType elementType)
                  List<StringElement> GetElementsByTypeAndName(string modelName, StringElementType elementType, string elementName)
                */
                local LOCelementList = LOCconverter.GetElementsByTypeAndName LOCmodelName LOCelementType LOCstringLabel
                if LOCelementList.count > 0 then LOCstringsFound = true
              )
            )

            --- For LandXML based files specifically
            if LOCcveImportMode == 4 then
            (
              local LOCappData427 = filterString (getAppData LOCfilteredTempObjects[i][ii] 427) "$!!$"
              LOCstringLabel      = LOCappData427[1]
              local LOCstringType = LOCappData427[2] -- will be undefined if only one item in array, so this is a safe assumption
              if LOCstringType == undefined then LOCstringType = ""

              LOCmodelName        = getAppData LOCfilteredTempObjects[i][ii] 428

              --- For CgPoints
              /*
              LOCstringType derived from vesper TagXmlElementInfo:
              int XmlElementType (0:XmlCgPoints, 1:XmlSurfaceBoundaries, 2:XmlSurfaceBreakline, 3:XmlSurfaceContours, 4:XmlSurfaceMesh)
                */
              if LOCstringType == "0" then
              (
                for iii = 1 to LOCconverter.cgPoints.count do
                (
                  local LOCcgPoints = LOCconverter.cgPoints.item[iii-1]
                  local LOCparentName = if LOCcgPoints.parent != undefined then LOCcgPoints.parent.name else " "
                  if (striCmp LOCcgPoints.name LOCstringLabel) == 0 and (striCmp LOCparentName LOCmodelName) == 0 then
                  (
                    if LOCcgPoints.expectedPointCount > 0 then LOCstringsFound = true
                  )
              )
            )

              --- For Surface Meshes
              if LOCstringType == "4" then
              (
                for iii = 1 to LOCconverter.surfaces.count do
                (
                  -- no need to check against appData 428 because parent name for LandXML surface meshes is duplicated to AppData parent name
                  local LOCsurface = LOCconverter.surfaces.item[iii-1]
                  if (striCmp LOCsurface.name LOCstringLabel) == 0 then
            (
                    if LOCsurface.expectedFaceCount > 0 then LOCstringsFound = true
                  )
                )
              )

              --- For Surface Breaklines
              /*
                Updating LandXML surface breaklines is not supported because the LandXML core does not support
                the merging of breaklines by name per surface. This means that imported breaklines might not
                have a unique name per parent surface, making it impossible to identify a surface breakline
                uniquely by name alone.
              */
            )

            --- FInish Up This Section
            if LOCstringsFound then
            (
              local LOCexistingDrapeCoords = APCFUNextractObjectDrapeCoordsToArrays LOCfilteredObjSwitch[i][ii] LOCfilteredTempObjects[i][ii] i ii
              if LOCexistingDrapeCoords != undefined then
              (
                append LOCdrapeCrdsArray LOCexistingDrapeCoords
                append LOCdrapeIndexArray [i,ii]
              )
            )
            else
            (
              LOCproceedSwitch = false
              append LOCobjNamesNotFound ("\"" + LOCstringLabel + "\" / \"" + LOCmodelName + "\" in \"" + (filenameFromPath LOCfileArray[i]) + "\"")
            )
          )
        )
        else (LOCproceedSwitch = false)

        if DYNdnGenioConverter != undefined then DYNdnGenioConverter.Recycle()
        if DYNdnMxConverter    != undefined then DYNdnMxConverter.Recycle()
        if DYNdn12dConverter   != undefined then DYNdn12dConverter.Recycle()
        if DYNdnXmlConverter   != undefined then DYNdnXmlConverter.Recycle()
      )


      --------------------------- CIVIL 3D VSP SOURCE FILES ---------------------------------------------------------------------------------------------------------------------------------
      ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
      if LOCfileExtArray[i] == ".VSP3D" and LOCproceedSwitch then
      (
        LOCprogressLabel.text = DYNuiResourcesStatusMessages[64]
        local LOCc3dVspInfo = DYNFUNreadVesperFile LOCfileArray[i]

        if LOCc3dVspInfo[1] != undefined then
        (
          for ii = 1 to LOCfilteredTempObjects[i].count do
          (
            local LOCstringFound     = false
            local LOCappDataMatch428 = getAppData LOCfilteredTempObjects[i][ii] 428 -- No conversion to Upper Case is required because we will do lower case comparison

            --- Check for Object Matches
            for iii in DYNc3dAlignments              do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DAlignment" iii)           == 0 then LOCstringFound = true)
            for iii in DYNc3dCorridorBaselines       do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DCorridorBaseLine" iii)    == 0 then LOCstringFound = true)
            for iii in DYNc3dCorridorFeatureLines    do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DCorridorFeatureLine" iii) == 0 then LOCstringFound = true)
            for iii in DYNc3dNamedLandFeatureLines   do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DLandFeatureLine" iii)     == 0 then LOCstringFound = true)
            for iii in DYNc3dUnnamedLandFeatureLines do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DLandFeatureLine" iii)     == 0 then LOCstringFound = true)
            for iii in DYNc3dSurfaces                do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DSurface" iii)             == 0 then LOCstringFound = true)
            for iii in DYNc3dPointGroups             do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "Civil3DPointGroup" iii)             == 0 then LOCstringFound = true)
            for iii in DYNc3dPipeNetworks            do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "Civil3DPipeNetwork" iii)            == 0 then LOCstringFound = true)
            for iii in DYNc3dCorridorSurfaces        do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DCorridorSurface" iii)     == 0 then LOCstringFound = true)

            if LOCstringFound then
            (
              --- If this is a surface, update then extract draping coordinates for this object, and save to temp array
              local LOCexistingDrapeCoords = APCFUNextractObjectDrapeCoordsToArrays LOCfilteredObjSwitch[i][ii] LOCfilteredTempObjects[i][ii] i ii
              if LOCexistingDrapeCoords != undefined then
              (
                append LOCdrapeCrdsArray LOCexistingDrapeCoords
                append LOCdrapeIndexArray [i,ii]
              )
            )
            else (LOCproceedSwitch = false; append LOCobjNamesNotFound ("\"" + (getAppData LOCfilteredTempObjects[i][ii] 427) + "\" / \"" + (filterString LOCappDataMatch428 "$!!$")[1] + "\" in \"" + (filenameFromPath LOCfileArray[i]) + "\""))
          )
        )
        else (LOCproceedSwitch = false)

        --- add array of content from this C3D VSP file to function-wide array of data (possibily from multiple files)
        LOCfileFilteredContents[i]   += #()

        DYNc3dAlignments              = #()
        DYNc3dCorridorBaselines       = #()
        DYNc3dCorridorRegions         = #()
        DYNc3dCorridorFeatureLines    = #()
        DYNc3dNamedLandFeatureLines   = #()
        DYNc3dUnnamedLandFeatureLines = #()
        DYNc3dSurfaces                = #()
        DYNc3dCorridorSurfaces        = #()
        DYNc3dPointGroups             = #()
        DYNc3dPipeNetworks            = #()
        DYNc3dSites                   = #()
        --The following arrays also get used by VSP3D files, but not in this import panel which
        --only supports Civil 3D content.
        --DYNmxPointStrings             = #()
        --DYNmxShapeStrings             = #()
        --DYNmxSurfaceStrings           = #()
        --DYN12dPointStrings            = #()
        --DYN12dShapeStrings            = #()
        --DYN12dSurfaceStrings          = #()
        -- DYNxmlPointStrings           = #()
        --DYNxmlShapeStrings            = #()
        --DYNxmlSurfaceStrings          = #()
      )
    )


    ------- Tell the user the result of the search ---------------------------------------------------------------------------------------------------------------------------
    LOCprogressBar.value = 100
    destroyDialog DYNmessageRollout

    if FUNshowFoundSwitch then
    (
      if LOCproceedSwitch then
      (
        if not (querybox (DYNuiResourcesErrorsWarnings[101] + "\n\n" + DYNuiResourcesQueries[45]) title:DYNuiResourcesTitlebars[3]) then LOCproceedSwitch = false
      )
      else
      (
        if LOCfindDupsContinue then
        (
          messagebox (DYNuiResourcesErrorsWarnings[103] + "\n\n" + DYNuiResourcesErrorsWarnings[104] + " " + LOCobjNamesNotFound[1]) title:DYNuiResourcesTitlebars[1]
        )
        else
        (
          messagebox (DYNuiResourcesErrorsWarnings[100]) title:(DYNuiResourcesTitlebars[1])
        )
      )
    )
  )

  ---------------------------------------------------------------------------------------------------------------------
  --- ACTUALLY START CREATING SOME OBJECTS ----------------------------------------------------------------------------
  ---------------------------------------------------------------------------------------------------------------------
  if LOCproceedSwitch then
  (
    LOCprogressBar.value = 0
    DYNFUNremoveCSProllouts()
    DYNFUNloadVSPnodeCallBacks false
    with redraw off
    (
      DYNproperties.LOCenableUpdatePropertiesPanel = false
      DYNproperties.LOCupdSelection = false

      if LOCprogressLabel != undefined then LOCprogressLabel.text = DYNuiResourcesStatusMessages[8]

      ---------------------------------------------------------------------------------------------------------------------
      --- Create new objects from CURRENT Source Data ---------------------------------------------------------------------
      ---------------------------------------------------------------------------------------------------------------------
      local LOCmajorCnt = 0
      local LOCminorCnt = 0
      for i in LOCfilteredTempObjects do LOCmajorCnt += i.count

      for i = 1 to LOCfileArray.count do
      (
        LOCprogressBar.value = ((LOCminorCnt as float) / (LOCmajorCnt as float) * 100.0)

        --- FOR CVE SOURCED OBJECTS (MX MODEL AND GENIO)
        if ((findItem LOCacceptedCVEFormats LOCfileExtArray[i]) > 0) then
        (
          DYNFUNloadCVEImportComponents DYNbinPath DYNINIungpMatChan DYNINIgreyedOutColor

          local LOCconverter     = DYNdnGenioConverter
          local LOCcveImportMode = 1

          if (LOCfileExtArray[i] == ".TXT" or LOCfileExtArray[i] == ".CRD" or LOCfileExtArray[i] == ".MOS") then
          (
            LOCconverter     = DYNdnGenioConverter
            LOCcveImportMode = 1
          )
          if (LOCfileExtArray[i] == ".FIL") then
          (
            LOCconverter     = DYNdnMxConverter
            LOCcveImportMode = 2
          )
          if (LOCfileExtArray[i] == ".12DA" or LOCfileExtArray[i] == ".4DA") then
          (
            LOCconverter     = DYNdn12dConverter
            LOCcveImportMode = 3
          )
          if (LOCfileExtArray[i] == ".XML") then
          (
            LOCconverter     = DYNdnXmlConverter
            LOCcveImportMode = 4
          )

          local LOCreadSuccess  = DYNFUNreadCVEfile LOCconverter LOCfileArray[i] #() undefined undefined undefined DYNINIungpMatChan DYNINIgreyedOutColor LOCcveImportMode

          if LOCreadSuccess then
          (
            --- Select Required Elements, Import Them, and Gather Into an Unordered Array
            for ii = 1 to LOCfilteredTempObjects[i].count do
            (
              --- For MX and GENIO files specifically
              if LOCcveImportMode == 1 or LOCcveImportMode == 2 then
              (
                local LOCstringLabel = getAppData LOCfilteredTempObjects[i][ii] 427
                local LOCmodelName   = getAppData LOCfilteredTempObjects[i][ii] 428
                LOCconverter.SelectElementsByName (LOCconverter.getModel LOCmodelName) (DYNFUNupperCase LOCstringLabel 0) false false false true -- returns 0/1
              )

              --- for 12da files specifically
              if LOCcveImportMode == 3 then
              (
                local LOCappData427  = filterString (getAppData LOCfilteredTempObjects[i][ii] 427) "$!!$"
                local LOCstringLabel = LOCappData427[1]
                local LOCstringType  = LOCappData427[2] -- will be undefined if only one item in array, so this is a safe assumption

                local LOCmodelName   = getAppData LOCfilteredTempObjects[i][ii] 428

                local LOCelementType
                if (striCmp LOCstringType "Alignment"     ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Alignment
                if (striCmp LOCstringType "Arc"           ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Arc
                if (striCmp LOCstringType "Circle"        ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Circle
                if (striCmp LOCstringType "Drainage"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Drainage
                if (striCmp LOCstringType "Face"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Face
                if (striCmp LOCstringType "Feature"       ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Feature
                if (striCmp LOCstringType "Interface"     ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Interface
                if (striCmp LOCstringType "Pipe"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Pipe
                if (striCmp LOCstringType "Pipeline"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Pipeline
                if (striCmp LOCstringType "Plot"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Plot
                if (striCmp LOCstringType "Polyline"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Polyline
                if (striCmp LOCstringType "String2D"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").String2D
                if (striCmp LOCstringType "String3D"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").String3D
                if (striCmp LOCstringType "String4D"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").String4D
                if (striCmp LOCstringType "Super"         ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Super
                if (striCmp LOCstringType "SuperAlignment") == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").SuperAlignment
                if (striCmp LOCstringType "SuperTin"      ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").SuperTin
                if (striCmp LOCstringType "Text"          ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Text
                if (striCmp LOCstringType "Tin"           ) == 0 then LOCelementType = (dotNetClass "Autodesk.CVE.Data.TwelveD.StringElementType").Tin

                if LOCelementType != undefined then
                (
                  LOCconverter.SelectElementsByType (LOCconverter.getModel LOCmodelName) LOCelementType LOCstringLabel false false false true -- returns 0/1
                )
              )

              --- For LandXML files specifically
              if LOCcveImportMode == 4 then
              (
                local LOCappData427  = filterString (getAppData LOCfilteredTempObjects[i][ii] 427) "$!!$"
                local LOCstringLabel = LOCappData427[1]
                local LOCstringType  = LOCappData427[2] -- will be undefined if only one item in array, so this is a safe assumption

                local LOCmodelName   = getAppData LOCfilteredTempObjects[i][ii] 428

                --- For CgPoints
                /*
                LOCstringType derived from vesper TagXmlElementInfo:
                int XmlElementType (0:XmlCgPoints, 1:XmlSurfaceBoundaries, 2:XmlSurfaceBreakline, 3:XmlSurfaceContours, 4:XmlSurfaceMesh)
                */
                if LOCstringType == "0" then
                (
                  local LOCnoMatchMadeYet = true
                  for iii = 1 to LOCconverter.cgPoints.count do
                  (
                    if LOCnoMatchMadeYet then
                    (
                      local LOCcgPoints = LOCconverter.cgPoints.item[iii-1]
                      local LOCparentName = if LOCcgPoints.parent != undefined then LOCcgPoints.parent.name else " "
                      if (striCmp LOCcgPoints.name LOCstringLabel) == 0 and (striCmp LOCparentName LOCmodelName) == 0 then
                      (
                        LOCcgPoints.isSelected = true
                        LOCnoMatchMadeYet = false
                      )
                    )
                  )
                )

                --- For Surface Meshes
                if LOCstringType == "4" then
                (
                  local LOCnoMatchMadeYet = true
                  for iii = 1 to LOCconverter.surfaces.count do
                  (
                    if LOCnoMatchMadeYet then
                    (
                      -- no need to check against appData 428 because parent name for LandXML surface meshes is duplicated to AppData parent name
                      local LOCsurface = LOCconverter.surfaces.item[iii-1]
                      if (striCmp LOCsurface.name LOCstringLabel) == 0 then
                      (
                        LOCsurface.isSelected = true
                        LOCnoMatchMadeYet = false
                      )
                    )
                  )
                )

                --- For Surface Breaklines
                /*
                  Importing LandXML surface breaklines is not supported because the LandXML core does not support
                  the merging of breaklines by name per surface. This means that imported breaklines might not
                  have a unique name per parent surface, making it impossible to identify a surface breakline
                  uniquely by name alone.
                */
              )
            )

            local LOCproceed                 = DYNFUNreadSelectedData LOCconverter LOCfileArray[i] LOCprogressBar LOCprogressLabel undefined undefined undefined undefined LOCcveImportMode-- returns true/false
            local LOCunOrderedNewObjectArray = DYNFUNimportCVEfile LOCconverter LOCfileArray[i] LOCprogressBar LOCprogressLabel undefined undefined undefined undefined FUNtempPath LOCcveImportMode -- returns object array

            --- Check Size of New Object Array then re-order New Object Array to Ensure Match with object order in Old Object Array
            LOCproceedSwitch = APCFUNreOrderWrapper LOCunOrderedNewObjectArray LOCfilteredTempObjects LOCfilteredNewObjects i LOCfilteredObjSwitch LOCfileExtArray[i]
          )
          else (LOCproceedSwitch = false)

          if DYNdnGenioConverter != undefined then DYNdnGenioConverter.Recycle()
          if DYNdnMxConverter    != undefined then DYNdnMxConverter.Recycle()
          if DYNdn12dConverter   != undefined then DYNdn12dConverter.Recycle()
          if DYNdnXmlConverter   != undefined then DYNdnXmlConverter.Recycle()

          DYNmxPointStrings       = #()
          DYNmxShapeStrings       = #()
          DYNmxSurfaceStrings     = #()
          DYN12dPointStrings      = #()
          DYN12dShapeStrings      = #()
          DYN12dSurfaceStrings    = #()
          DYNxmlPointStrings      = #()
          DYNxmlShapeStrings      = #()
          DYNxmlSurfaceStrings    = #()
        )



        ---- FOR C3D VSP FILE SOURCED OBJECTS ------------------------------------------------------------------------------------------------------
        if LOCfileExtArray[i] == ".VSP3D" then
        (
          local LOCc3dVspInfo = DYNFUNreadVesperFile LOCfileArray[i]

          if LOCc3dVspInfo[1] != undefined then
          (
            for ii = 1 to LOCfilteredTempObjects[i].count do
            (
              local LOCappDataMatch428 = getAppData LOCfilteredTempObjects[i][ii] 428 -- No conversion to Upper Case is required because we will do lower case comparison

              --- Check AppData From Current Object against AppData of every object found in file, then set matched objects to selected = true
              for iii in DYNc3dAlignments              do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DAlignment" iii)           == 0 then iii[19] = true)
              for iii in DYNc3dCorridorBaselines       do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DCorridorBaseLine" iii)    == 0 then iii[19] = true)
              for iii in DYNc3dCorridorFeatureLines    do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DCorridorFeatureLine" iii) == 0 then iii[16] = true)
              for iii in DYNc3dNamedLandFeatureLines   do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DLandFeatureLine" iii)     == 0 then iii[15] = true)
              for iii in DYNc3dUnnamedLandFeatureLines do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DLandFeatureLine" iii)     == 0 then iii[15] = true)
              for iii in DYNc3dSurfaces                do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DSurface" iii)             == 0 then iii[12] = true)
              for iii in DYNc3dPointGroups             do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "Civil3DPointGroup" iii)             == 0 then iii[5]  = true)
              for iii in DYNc3dPipeNetworks            do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "Civil3DPipeNetwork" iii)            == 0 then iii[6]  = true)
              for iii in DYNc3dCorridorSurfaces        do (if (DYNFUNcompareVsp3DAppDataStrings LOCappDataMatch428 "TagCivil3DCorridorSurface" iii)     == 0 then iii[21] = true)
            )

            --- Actually import new set of objects to replace existing selected objects
            local LOCunOrderedNewObjectArray = DYNFUNimportVesperFile LOCfileArray[i] DYNc3dSurfaces DYNc3dCorridorSurfaces DYNc3dCorridorBaselines DYNc3dCorridorFeatureLines DYNc3dNamedLandFeatureLines DYNc3dUnnamedLandFeatureLines [LOCc3dVspInfo[5],LOCc3dVspInfo[6]] DYNINIfaceSmoothing (if DYNINIhideDiagonals == "1" then true else false) (if DYNINIoverhangCorrect == "1" then true else false) LOCprogressBar LOCprogressLabel DYNc3dPointGroups true DYNmxPointStrings DYNmxShapeStrings DYNmxSurfaceStrings DYN12dPointStrings DYN12dShapeStrings DYN12dSurfaceStrings DYNc3dAlignments DYNc3dPipeNetworks DYNxmlSurfaceStrings DYNxmlShapeStrings DYNxmlPointStrings

            --- Check Size of New Object Array then re-order New Object Array to Ensure Match with object order in Old Object Array
            LOCproceedSwitch = APCFUNreOrderWrapper LOCunOrderedNewObjectArray LOCfilteredTempObjects LOCfilteredNewObjects i LOCfilteredObjSwitch LOCfileExtArray[i]
          )

          DYNc3dAlignments              = #()
          DYNc3dCorridorBaselines       = #()
          DYNc3dCorridorRegions         = #()
          DYNc3dCorridorFeatureLines    = #()
          DYNc3dNamedLandFeatureLines   = #()
          DYNc3dUnnamedLandFeatureLines = #()
          DYNc3dSurfaces                = #()
          DYNc3dCorridorSurfaces        = #()
          DYNc3dPointGroups             = #()
          DYNc3dPipeNetworks            = #()
          DYNc3dSites                   = #()
          -- The following arrays also get used by VSP3D files, but not in this import panel which
          -- only supports Civil 3D content.
          -- DYNmxPointStrings             = #()
          -- DYNmxShapeStrings             = #()
          -- DYNmxSurfaceStrings           = #()
          -- DYN12dPointStrings            = #()
          -- DYN12dShapeStrings            = #()
          -- DYN12dSurfaceStrings          = #()
          -- DYNxmlPointStrings            = #()
          -- DYNxmlShapeStrings            = #()
          -- DYNxmlSurfaceStrings          = #()
        )

        LOCminorCnt += LOCfilteredTempObjects[i].count
        if LOCprogressLabel != undefined then LOCprogressLabel.text = DYNuiResourcesStatusMessages[63] + " " + (filenameFromPath LOCfileArray[i])
      )

      ---------------------------------------------------------------------------------------------------------------------
      --- Check to see whether any objects being updated had stuff attached to them ---------------------------------------
      ---------------------------------------------------------------------------------------------------------------------
      if LOCproceedSwitch then
      (
        if LOCprogressLabel != undefined then LOCprogressLabel.text = DYNuiResourcesStatusMessages[8]

        --- Build Dependency Arrays For Updated Surfaces Only....
        local LOCdependentSurfCtrl       = #()
        local LOCdependentForestSurfCtrl = #()

        --- Build Dependency Arrays For Updated Shapes Only....
        local LOCdependParents           = #()
        local LOCdependMarkings          = #()
        local LOCdependChevrons          = #()
        local LOCdependSweptObjs         = #()
        local LOCdependRails             = #()
        local LOCdependBuildings         = #()
        local LOCdependForests           = #()

        for i = 1 to Objects.count do
        (
          local LOCcontroller = try (Objects[i].transform.controller) catch ()

          --- Surfaces
          if LOCcontroller != undefined then (if (try (LOCcontroller.surface) catch (undefined)) != undefined then append LOCdependentSurfCtrl objects[i])
          if (isKindOf objects[i] Forest_Pro_3) or (isKindOf objects[i] Forest_Lite_3) then (append LOCdependentForestSurfCtrl objects[i])

          --- Shapes
          local LOCcontroller = try (Objects[i].transform.controller) catch ()
          if LOCcontroller != undefined then (if (try (LOCcontroller.path) catch (undefined)) != undefined then append LOCdependParents  objects[i])
          if (try (Objects[i].parent) catch (undefined)) != undefined and (getAppData Objects[i] 422) == "9"  and (CVGetMod Objects[i] Civil_View_Swept_Object) != undefined then append LOCdependSweptObjs objects[i]
          if (try (Objects[i].parent) catch (undefined)) != undefined and (getAppData Objects[i] 422) == "10" and (CVGetMod Objects[i] Civil_View_Road_Marking) != undefined then append LOCdependMarkings objects[i]
          if (try (Objects[i].parent) catch (undefined)) != undefined and (getAppData Objects[i] 422) == "10" and (CVGetMod Objects[i] Civil_View_Spline_to_Mesh) != undefined then append LOCdependChevrons objects[i]
          if (try (Objects[i].parent) catch (undefined)) != undefined and (getAppData Objects[i] 422) == "12" then append LOCdependRails objects[i]
          if (try (Objects[i].parent) catch (undefined)) != undefined and (getAppData Objects[i] 422) == "13" then append LOCdependBuildings objects[i]
          if (isKindOf Objects[i] Forest_Pro_3) or (isKindOf Objects[i] Forest_Lite_3) then (append LOCdependForests objects[i])
        )

        ---------------------------------------------------------------------------------------------------------------------
        --- If any other objects were dependent in any way on the objects which have been updated, update them accordingly --
        ---------------------------------------------------------------------------------------------------------------------

        for i = 1 to LOCfilteredNewObjects.count do
        (
          for ii = 1 to LOCfilteredNewObjects[i].count do
          (
            --- Update Progress Bar ------------------------------------
            LOCprogressBar.value = ((ii as float) / (LOCfilteredNewObjects[i].count as float) * 100.0)

            --- Update Surface Dependent Placed Objects (VSPCAT1-6) ----
            for iii = 1 to LOCdependentSurfCtrl.count do
            (
              local LOCcontroller = LOCdependentSurfCtrl[iii].transform.controller
              if (try (LOCcontroller.surface) catch ()) == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] == 8 then
              (
                DYNFUNmaxBakingControl #(LOCdependentSurfCtrl[iii]) true

                LOCcontroller.surface = LOCfilteredNewObjects[i][ii]

                if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl #(LOCdependentSurfCtrl[iii]) false

                LOCdependentObjCnt += 1
              )
            )


            --- Update Surface Dependent Forest Objects ----------------
            for iii = 1 to LOCdependentForestSurfCtrl.count do
            (
              if (try (LOCdependentForestSurfCtrl[iii].surface) catch ()) == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] == 8 then
              (
                LOCdependentForestSurfCtrl[iii].surface = LOCfilteredNewObjects[i][ii]
                LOCdependentObjCnt += 1
              )
            )

            --- Update Point Systems ----------------
            if LOCfilteredObjSwitch[i][ii] == 14 then
            (
              particleFlow.beginEdit()

              if classOf LOCfilteredNewObjects[i][ii] == Birth_Script then
              (
                for iii = 1 to (LOCfilteredTempObjects[i][ii].getNumInitialActionLists()) do
                (
                  local LOCevent = LOCfilteredTempObjects[i][ii].getInitialActionList iii

                  for iiii = 1 to (LOCevent.numActions()) do
                  (
                    local LOCaction = LOCevent.getAction iiii
                    if classof LOCaction == Birth_Script then LOCaction.Proceed_Script = LOCfilteredNewObjects[i][ii].Proceed_Script
                  )
                )
                delete LOCfilteredNewObjects[i][ii]
                LOCfilteredNewObjects[i][ii]  = LOCfilteredTempObjects[i][ii]
                LOCfilteredTempObjects[i][ii] = undefined
              )

              particleFlow.endEdit()
            )

            --- Update Shape Dependent Placed Objects (VSPCAT1-6) ------
            for iii = 1 to LOCdependParents.count do
            (
              local LOCcontroller = LOCdependParents[iii].transform.controller
              if (try (LOCcontroller.path) catch ()) == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] != 8 and LOCfilteredObjSwitch[i][ii] != 14 then
              (
                DYNFUNmaxBakingControl #(LOCdependParents[iii]) true

                LOCcontroller.path = LOCfilteredNewObjects[i][ii]

                if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl #(LOCdependParents[iii]) false

                LOCdependentObjCnt += 1
              )
            )

            --- Update Shape Dependent Swept Objects ------------
            for iii = 1 to LOCdependSweptObjs.count do
            (
              ---  Check whether this original shape was the parent of the current DependentMarking object
              if isValidNode LOCdependSweptObjs[iii] and LOCdependSweptObjs[iii].parent == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] != 8 and LOCfilteredObjSwitch[i][ii] != 14 then
              (
                local LOCnewObj
                local LOColdObj      = LOCdependSweptObjs[iii]
                local LOCobjArray    = DYNsweptObjects.DYNFUNcreateSweptObjects #(LOCfilteredNewObjects[i][ii]) (getAppData LOColdObj 424) (CVGetMod LOColdObj Civil_View_Swept_Object) (CVGetMod LOColdObj Civil_View_Divide_Spline) DYNmatNameSurfaces (if (getAppData LOColdObj 426) == "1" then true else false)
                if LOCobjArray.count > 0 then LOCnewObj = LOCobjArray[1]
                DYNFUNapplyModifierInstance Civil_View_Swept_Object LOCnewObj LOColdObj false
                DYNFUNmatchProperties LOColdObj LOCnewObj
                if isValidNode LOColdObj then delete LOColdObj
                LOCdependentObjCnt += 1
              )
            )

            --- Update Shape Dependent Road Marking Objects ------------
            for iii = 1 to LOCdependMarkings.count do
            (
              --- Check whether this original shape was the parent of the current DependentMarking object
              if isValidNode LOCdependMarkings[iii] and LOCdependMarkings[iii].parent == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] != 8 and LOCfilteredObjSwitch[i][ii] != 14 then
              (
                local LOCnewObj
                local LOColdObj      = LOCdependMarkings[iii]
                local LOCobjArray    = DYNFUNcreateMarks #(LOCfilteredNewObjects[i][ii]) (getAppData LOColdObj 424) rootNode.DYNrootNodeStore.markVshift rootNode.DYNrootNodeStore.markFreeze (DYNFUNgetLocalTime()) DYNINImarkingColor (try ([(getAppData LOCdependMarkings[iii] 426 as float), (getAppData LOCdependMarkings[iii] 427 as float), (getAppData LOCdependMarkings[iii] 428 as float)]) catch ([10.0,0.0,0.1])) false false LOCsceneMats (CVGetMod LOColdObj Civil_View_Road_Marking) true (try (getAppData LOCdependMarkings[iii] 430 as float) catch (0.0)) (CVGetMod LOColdObj Civil_View_Road_Marking).offsetX (CVGetMod LOColdObj Civil_View_Road_Marking).cf
                if LOCobjArray.count > 0 then LOCnewObj = LOCobjArray[1]
                DYNFUNapplyModifierInstance Civil_View_Road_Marking LOCnewObj LOColdObj false
                DYNFUNmatchProperties LOColdObj LOCnewObj
                if (getAppData LOColdObj 429) != undefined then (setAppData LOCnewObj 429 (getAppData LOColdObj 429))
                if (getAppData LOColdObj 430) != undefined then (setAppData LOCnewObj 430 (getAppData LOColdObj 430))
                if isValidNode LOColdObj then delete LOColdObj
                LOCdependentObjCnt += 1
              )
            )

            --- Update Shape Dependent Chevron Marking Objects ------------
            for iii = 1 to LOCdependChevrons.count do
            (
              --- Check whether this original shape was the parent of the current DependentChevron object
              if isValidNode LOCdependChevrons[iii] and LOCdependChevrons[iii].parent == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] != 8 and LOCfilteredObjSwitch[i][ii] != 14 then-- IsValidNode required becasue LOCdependChevrons[ii] could have been deleted by previous loop through this section
              (
                local LOCnewObj
                local LOColdObj      = LOCdependChevrons[iii]
                local LOCobjArray    = DYNFUNcreateChevrons #(LOCfilteredNewObjects[i][ii]) (getAppData LOColdObj 424) rootNode.DYNrootNodeStore.markVshift rootNode.DYNrootNodeStore.markFreeze (DYNFUNgetLocalTime()) DYNINImarkingColor (try ([(getAppData LOCdependChevrons[iii] 426 as float), (getAppData LOCdependChevrons[iii] 427 as float), (getAppData LOCdependChevrons[iii] 428 as float)]) catch ([10.0,0.0,0.1])) false false LOCsceneMats (CVGetMod LOColdObj Civil_View_Spline_to_Mesh) true (CVGetMod LOColdObj Civil_View_Spline_to_Mesh).rotation
                if LOCobjArray.count > 0 then LOCnewObj = LOCobjArray[1]
                DYNFUNapplyModifierInstance Civil_View_Spline_to_Mesh LOCnewObj LOColdObj false
                DYNFUNmatchProperties LOColdObj LOCnewObj
                if (getAppData LOColdObj 429) != undefined then (setAppData LOCnewObj 429 (getAppData LOColdObj 429))
                if isValidNode LOColdObj then delete LOColdObj
                LOCdependentObjCnt += 1
              )
            )


            --- Update Shape Dependent Rail Objects --------------------
            for iii = 1 to LOCdependRails.count do
            (
              --- Check whether this original shape was the parent of the current DependentRail object
              if isValidNode LOCdependRails[iii] and LOCdependRails[iii].parent == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] != 8 and LOCfilteredObjSwitch[i][ii] != 14 then
              (
                local LOColdObj      = LOCdependRails[iii]                                            -- Store reference to old object
                local LOCobjArray    = DYNFUNcreateRails #(LOCfilteredNewObjects[i][ii]) (getAppData LOColdObj 424) (DYNFUNgetLocalTime()) false LOCsceneMats #() (CVGetMod LOColdObj Civil_View_Guard_Rail) true
                if LOCobjArray.count > 0 then LOCnewObj = LOCobjArray[1]
                DYNFUNapplyModifierInstance Civil_View_Guard_Rail LOCnewObj LOColdObj false
                DYNFUNmatchProperties LOColdObj LOCnewObj
                if isValidNode LOColdObj then delete LOColdObj
                LOCdependentObjCnt += 1
              )
            )


            --- Update Shape Dependent Building Objects ----------------
            for iii = 1 to LOCdependBuildings.count do
            (
              --- Check whether this original shape was the parent of the current DependentBuildings object
              if isValidNode LOCdependBuildings[iii] and LOCdependBuildings[iii].parent == LOCfilteredTempObjects[i][ii] and LOCfilteredObjSwitch[i][ii] != 8 and LOCfilteredObjSwitch[i][ii] != 14 then
              (
                local LOCnewObj
                local LOColdObj      = LOCdependBuildings[iii]
                local LOCobjMod1     = CVGetMod LOColdObj DynBuilding
                local LOCobjMod2     = (CVGetMod LOColdObj Uvwmap)
                local LOCobjArray    = DYNFUNcreateBuild #(LOCfilteredNewObjects[i][ii]) (getAppData LOColdObj 424) (DYNFUNgetLocalTime()) LOCsceneMats LOCobjMod1.Xamount LOCobjMod1.Xfloors LOCobjMod1.XwallMatIDs LOCobjMod1.XmapWidth LOCobjMod1.XmapType false LOCobjMod1 LOCobjMod2 true
                if LOCobjArray.count > 0 then LOCnewObj = LOCobjArray[1]
                DYNFUNapplyModifierInstance DynBuilding LOCnewObj LOColdObj false
                DYNFUNmatchProperties LOColdObj LOCnewObj
                if isValidNode LOColdObj then delete LOColdObj
                LOCdependentObjCnt += 1
              )
            )


            --- Update Shape Dependent Forest Objects ------------------
            for iii = 1 to LOCdependForests.count do
            (
              if isValidNode LOCdependForests[iii] and LOCfilteredObjSwitch[i][ii] != 8 and LOCfilteredObjSwitch[i][ii] != 14 then
              (
                if (try (LOCdependForests[iii].splineInc) catch ()) == LOCfilteredTempObjects[i][ii] then (LOCdependForests[iii].splineInc = LOCfilteredNewObjects[i][ii]) -- "Include" Boundary
                if (try (LOCdependForests[iii].splineExc) catch ()) == LOCfilteredTempObjects[i][ii] then (LOCdependForests[iii].splineExc = LOCfilteredNewObjects[i][ii]) -- "Exclude" Boundary
                if (try (LOCdependForests[iii].splineF) catch ())   == LOCfilteredTempObjects[i][ii] then (LOCdependForests[iii].splineF   = LOCfilteredNewObjects[i][ii]) -- "Follow" Boundary
                LOCdependentObjCnt += 1
              )
            )


            --- Update "Imported Shape Conversion" Smesh Modifier Based Surface Objects
            if LOCfilteredObjSwitch[i][ii] != 14 then
            (
              if (CVGetMod LOCfilteredTempObjects[i][ii] Civil_View_Spline_to_Mesh) != undefined then
              (
                addModifier LOCfilteredNewObjects[i][ii] (CVGetMod LOCfilteredTempObjects[i][ii] Civil_View_Spline_to_Mesh)

                --- If Civil_View_Spline_to_Mesh is being applied, this should now be classed as an imported surface
                setAppData LOCfilteredNewObjects[i][ii] 422 (getAppData LOCfilteredTempObjects[i][ii] 422)
              )
            )

            --- Ensure name, wirecolour, mterial and other generic properties match original name of object before Update
            if LOCfilteredObjSwitch[i][ii] != 14 then
            (
              DYNFUNmatchProperties LOCfilteredTempObjects[i][ii] LOCfilteredNewObjects[i][ii]
            )
          )
        )


        ---------------------------------------------------------------------------------------------------------------------
        --- Check whether draping coordinates were applied to surfaces that were updated in this session --------------------
        ---------------------------------------------------------------------------------------------------------------------
        for i = 1 to LOCdrapeIndexArray.count do
        (
          for ii in LOCdrapeCrdsArray[i] do
          (
            DYNFUNapplyPlanarMap (LOCfilteredNewObjects[LOCdrapeIndexArray[i].x][LOCdrapeIndexArray[i].y]) [ii[1],ii[2]] [ii[3],ii[4]] ii[5]
          )
        )


        ---------------------------------------------------------------------------------------------------------------------
        --- Closing tasks to end function -----------------------------------------------------------------------------------
        ---------------------------------------------------------------------------------------------------------------------
        for i in LOCfilteredTempObjects do
        (
          for ii in i do
          (
            if isValidNode ii then
            (
              if isOpenGroupHead ii then setGroupOpen ii false -- groups must be closed prior to deletion, otherwise group members are not removed
              delete ii
            )
          )
        )
        for i in LOCfilteredNewObjects  do (for ii in i do (if isValidNode ii then append LOCnewObjects ii))
        select LOCnewObjects
      )
      else
      (
        messagebox DYNuiResourcesErrorsWarnings[99] title:DYNuiResourcesTitlebars[1]
        for ii in LOCfilteredNewObjects do (if IsValidNode ii then delete ii)
      )
    )
    LOCprogressBar.value = 0
    redrawViews()
    DYNproperties.LOCenableUpdatePropertiesPanel = true
    DYNproperties.LOCupdSelection = true
    DYNFUNloadVSPnodeCallBacks true
    DYNFUNnodeCreatedCallback()

    if LOCprogressPanel != undefined then destroyDialog LOCprogressPanel

    select LOCnewObjects

    local LOCmessageString = DYNFUNformatValueToString DYNuiResourcesErrorsWarnings[97] LOCnewObjects.count
    if LOCdependentObjCnt > 0 then
    (
      LOCmessageString += "\n\n"
      LOCmessageString += DYNFUNformatValueToString DYNuiResourcesErrorsWarnings[98] LOCdependentObjCnt
    )
    messagebox LOCmessageString title:DYNuiResourcesTitlebars[3]
    clearUndoBuffer()
  )
  else
  (
    if LOCprogressPanel != undefined then destroyDialog LOCprogressPanel -- Close Progress Bar Dialog
  )

  LOCnewObjects -- return value
)

--- Next function always called ONLY after APCFUNupdateImportedObjects, so DYNFUNnodeCreatedCallback has already been called
fn APCFUNupdateAllPlacedObjectControllers =
(
  local LOCobjHandles = DYNobjHandles[1] + DYNobjHandles[2] + DYNobjHandles[3] + DYNobjHandles[4] + DYNobjHandles[5] + DYNobjHandles[6]
  local LOCobjects    = #(); for i in LOCobjHandles do append LOCobjects (maxOps.getNodeByHandle i)

  DYNFUNmaxBakingControl LOCobjects true
  if not rootNode.DYNrootNodeStore.bakeSwitch then DYNFUNmaxBakingControl LOCobjects false
)
--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNimportMan ""
(
  --- Local Variables ----------------------------------
  local LOCmsgMenu
  local rollout_dnLvMin    = [0,45]
  local LOCsourceFilePath  = true
  local LOCfilterSwitch    = false
  local LOCappData427array = #()
  local LOCappData428array = #()
  local LOCmaxObjectarray  = #()
  local LOCobjHandles      = #()

  --- Local Functions ----------------------------------
  fn DYNFUNbuildMenuImportMan =
  (
    local LOCexe = "RcMenu DYNimportManRCMenu\n"
    LOCexe += "(\n"
    LOCexe += "  local LOCmultiSelect = false\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[1] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNobjc4d\n"
    LOCexe += "    menuItem  MNDYNobjmod\n"
    LOCexe += "    menuItem  MNDYNobjgen\n"
    LOCexe += "    menuItem  MNDYNobj12d\n"
    LOCexe += "    menuItem  MNDYNobjxml\n"
    LOCexe += "    menuItem  MNDYNobjdxf\n"
    LOCexe += "    separator MNDYNseparator1\n"
    LOCexe += "    menuItem  MNDYNexpTxt\n"
    LOCexe += "  )\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[2] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNobjUpd\n"
    LOCexe += "    separator MNDYNseparator0\n"
    LOCexe += "    menuItem  MNDYNobjDel\n"
    LOCexe += "    separator MNDYNseparator2\n"
    LOCexe += "    menuItem  MNDYNSelAll\n"
    LOCexe += "    menuItem  MNDYNSelNone\n"
    LOCexe += "    menuItem  MNDYNSelInv\n"
    LOCexe += "    separator MNDYNseparator3\n"
    LOCexe += "    menuItem  MNDYNProps enabled:false\n"
    LOCexe += "  )\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[3] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem MNDYNrefresh\n"
    LOCexe += "    separator MNDYNseparator4\n"
    LOCexe += "    menuItem MNDYNpath\n"
    LOCexe += "    separator MNDYNseparator5\n"
    LOCexe += "    menuItem MNDYNunsorted\n"
    LOCexe += "  )\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[4] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem MNDYNhelp\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on DYNimportManRCMenu open do\n"
    LOCexe += "  (\n"
    LOCexe += "    MNDYNobjc4d.text   = DYNuiResourcesMenus[88]\n"
    LOCexe += "    MNDYNobjmod.text   = DYNuiResourcesMenus[89]\n"
    LOCexe += "    MNDYNobjgen.text   = DYNuiResourcesMenus[90]\n"
    LOCexe += "    MNDYNobj12d.text   = DYNuiResourcesMenus[91]\n"
    LOCexe += "    MNDYNobjxml.text   = DYNuiResourcesMenus[92]\n"
    LOCexe += "    MNDYNobjdxf.text   = DYNuiResourcesMenus[93]\n"
    LOCexe += "    MNDYNobjUpd.text   = DYNuiResourcesMenus[107]\n"
    LOCexe += "    MNDYNobjDel.text   = DYNuiResourcesMenus[10]\n"
    LOCexe += "    MNDYNSelAll.text   = DYNuiResourcesMenus[14]\n"
    LOCexe += "    MNDYNSelNone.text  = DYNuiResourcesMenus[15]\n"
    LOCexe += "    MNDYNProps.text    = DYNuiResourcesMenus[8]\n"
    LOCexe += "    MNDYNrefresh.text  = DYNuiResourcesMenus[2]\n"
    LOCexe += "    MNDYNhelp.text     = DYNuiResourcesMenus[5]\n"
    LOCexe += "    MNDYNexpTxt.text   = DYNuiResourcesMenus[110]\n"
    LOCexe += "    MNDYNSelInv.text   = DYNuiResourcesMenus[111]\n"
    LOCexe += "    MNDYNpath.text     = DYNuiResourcesMenus[112]\n"
    LOCexe += "    MNDYNunsorted.text = DYNuiResourcesMenus[113]\n"
    LOCexe += "\n"
    LOCexe += "    MNDYNpath.checked  = DYNimportMan.LOCsourceFilePath\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNexpTxt   picked do (DYNFUNsaveDnLvtoTextFile DYNimportMan.dnLv \";\")\n"
    LOCexe += "  on MNDYNobjmod   picked do (macros.run \"Civil View\" \"MCRmxImport\")\n"
    LOCexe += "  on MNDYNobjgen   picked do (macros.run \"Civil View\" \"MCRgenioImport\")\n"
    LOCexe += "  on MNDYNobjxml   picked do (macros.run \"Civil View\" \"MCRlandXMLimport\")\n"
    LOCexe += "  on MNDYNobjc4d   picked do (macros.run \"Civil View\" \"MCRc3dImport\")\n"
    LOCexe += "  on MNDYNobj12d   picked do (macros.run \"Civil View\" \"MCR12dImport\")\n"
    LOCexe += "  on MNDYNobjdxf   picked do (macros.run \"Civil View\" \"MCRdxfImport\")\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNobjUpd   picked do (DYNimportMan.DYNFUNmultiObjectUpdate())\n"
    LOCexe += "  on MNDYNobjDel   picked do (DYNimportMan.DYNFUNdeleteSelected())\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNSelAll   picked do (DYNimportMan.DYNFUNselectAll();    DYNimportMan.DYNFUNselectInVPandUpdateStatusBar())\n"
    LOCexe += "  on MNDYNSelNone  picked do (DYNimportMan.DYNFUNselectNone();   DYNimportMan.DYNFUNselectInVPandUpdateStatusBar())\n"
    LOCexe += "  on MNDYNSelInv   picked do (DYNimportMan.DYNFUNselectInvert(); DYNimportMan.DYNFUNselectInVPandUpdateStatusBar())\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNpath     picked do\n"
    LOCexe += "  (\n"
    LOCexe += "    DYNimportMan.LOCsourceFilePath = not MNDYNpath.checked\n"
    LOCexe += "    MNDYNpath.checked = DYNimportMan.LOCsourceFilePath\n"
    LOCexe += "    for i = 1 to DYNimportMan.dnLv.Items.count do\n"
    LOCexe += "    (\n"
    LOCexe += "      local LOCitem = DYNimportMan.dnLv.Items.item[i-1]\n"
    LOCexe += "      LOCitem.SubItems.item[5].text = if DYNimportMan.LOCsourceFilePath then (filterString LOCitem.tag \"|\")[6] else (filenamefrompath (filterString LOCitem.tag \"|\")[6])\n"
    LOCexe += "    )\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNrefresh  picked do DYNimportMan.DYNFUNregatherImportedObjects()\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNunsorted picked do (DYNimportMan.dnLv.sorting = DYNdnSortOrderClass.none; DYNimportMan.DYNFUNregatherImportedObjects())\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNhelp     picked do DYNFUNopenHelp 13206\n" -- id_cv_imported_object_manager
    LOCexe += "\n"
    LOCexe += "  on MNDYNProps    picked do max properties\n"
    LOCexe += ")\n"

    Execute LOCexe
  )

  fn DYNFUNresizeImportMan FUNsize =
  (
    DYNimportMan.dnProgress.pos.y = ((FUNsize).y - 34)
    DYNimportMan.dnProgress.width = ((FUNsize).x - DYNimportMan.rollout_dnLvMin.x)

    DYNimportMan.dnStatus.pos.y   = ((FUNsize).y - 20)
    DYNimportMan.dnStatus.width   = ((FUNsize).x - DYNimportMan.rollout_dnLvMin.x)

    DYNimportMan.dnLv.width       = ((FUNsize) - DYNimportMan.rollout_dnLvMin).x
    DYNimportMan.dnLv.height      = ((FUNsize) - DYNimportMan.rollout_dnLvMin).y - 14

    DYNdefRLsizeIMP = FUNsize
  )

  fn DYNFUNmultiObjectUpdate =
  (
    if DYNimportMan.dnLv.SelectedItems.count > 0 then
    (
      if querybox (DYNuiResourcesQueries[45]) title:DYNuiResourcesTitlebars[3] then
      (
        callbacks.removescripts id:#DYNimportMan

        local LOCnodeArray = #()
        if DYNimportMan.dnLv.SelectedItems.count > 10 then
        (
          for i = 1 to DYNimportMan.dnLv.Items.count do
          (
            local LOCitem    = DYNimportMan.dnLv.Items.item[i-1]
            if LOCitem.selected then (append LOCnodeArray (maxOps.getNodeByHandle ((filterString LOCitem.tag "|")[1] as integer)))
          )
        )
        else
        (
          for i = 1 to DYNimportMan.dnLv.SelectedItems.count do
          (
            local LOCitem    = DYNimportMan.dnLv.SelectedItems.item[i-1]
            append LOCnodeArray (maxOps.getNodeByHandle ((filterString LOCitem.tag "|")[1] as integer))
          )
        )
        if LOCnodeArray.count > 0 then
        (
          APCFUNupdateImportedObjects LOCnodeArray true DYNtempPath
          APCFUNupdateAllPlacedObjectControllers()
        )
        DYNimportMan.DYNFUNregatherImportedObjects()

        callbacks.addscript #selectedNodesPreDelete "DYNimportMan.DYNFUNpreObjectsDeleted()" id:#DYNimportMan
        callbacks.addscript #selectionSetChanged    "DYNimportMan.DYNFUNObjectsSelected()"   id:#DYNimportMan
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[84]) title:DYNuiResourcesTitlebars[3]
    )
  )

  fn DYNFUNdeleteSelected =
  (
    if DYNimportMan.dnLv.SelectedItems.count > 0 then
    (
      if (querybox (DYNuiResourcesQueries[1]) title:DYNuiResourcesTitlebars[2]) then
      (
        DYNFUNremoveCSProllouts()
        DYNFUNloadVSPnodeCallBacks false
        (
          callbacks.removescripts id:#DYNimportMan

          if DYNimportMan.dnLv.SelectedItems.count > 10 then
          (
            for i = 1 to DYNimportMan.dnLv.Items.count do
            (
              local LOCitem    = DYNimportMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[1] as integer)
                if isValidNode LOCcurObj then
                (
                  if isValidNode LOCcurObj then
                  (
                    if isOpenGroupHead LOCcurObj then setGroupOpen LOCcurObj false
                    delete LOCcurObj
                  )
                )
              )
            )
          )
          else
          (
            for i = 1 to DYNimportMan.dnLv.SelectedItems.count do
            (
              local LOCitem    = DYNimportMan.dnLv.SelectedItems.item[i-1]
              local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[1] as integer)
              if isValidNode LOCcurObj then
              (
                if isValidNode LOCcurObj then
                (
                  if isOpenGroupHead LOCcurObj then setGroupOpen LOCcurObj false
                  delete LOCcurObj
                )
              )
            )
          )

          callbacks.addscript #selectedNodesPreDelete "DYNimportMan.DYNFUNpreObjectsDeleted()" id:#DYNimportMan
          callbacks.addscript #selectionSetChanged    "DYNimportMan.DYNFUNObjectsSelected()"   id:#DYNimportMan
        )
        DYNFUNloadVSPnodeCallBacks true
        DYNFUNnodeCreatedCallback()
      )
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[85]) title:DYNuiResourcesTitlebars[3]
    )
  )

  fn DYNFUNmsgPopupMenu =
  (
    DYNimportMan.LOCmsgMenu = undefined

    if DYNimportMan.dnLv.selectedItems.count > 0 then
    (
      rcmenu LOCmsgMenu
      (
        local LOCmultiSelect = false
        local LOCselTag = ""

        menuItem  MNDYNupate      checked:false
        separator MNDYNseparate1
        menuItem  MNDYNchange     checked:false
        menuItem  MNDYNstrChange  checked:false
        separator MNDYNseparate2
        menuItem  MNDYNremove     checked:false
        menuItem  MNDYNrename     checked:false
        separator MNDYNseparate3
        menuItem  MNDYNproperties checked:false

        on LOCmsgMenu open do
        (
          MNDYNupate.text        = DYNuiResourcesMenus[107]
          MNDYNchange.text       = DYNuiResourcesMenus[108]
          MNDYNstrChange.text    = DYNuiResourcesMenus[109]
          MNDYNremove.text       = DYNuiResourcesMenus[10]
          MNDYNrename.text       = DYNuiResourcesMenus[7]
          MNDYNproperties.text   = DYNuiResourcesMenus[8]

          LOCselTag              = filterString DYNimportMan.dnLv.selectedItems.item[0].tag "|"
          MNDYNupate.enabled     = not DYNimportMan.dnLv.selectedItems.item[0].forecolor == DYNFUNdnColor DYNINIgreyedOutColor
          LOCmultiSelect         = if selection.count > 1 then true else false
          MNDYNstrChange.enabled = MNDYNrename.enabled = if (stricmp (getFilenameType LOCselTag[6]) ".vsp3d") == 0 then false else not LOCmultiSelect
        )

        on MNDYNupate  picked do (DYNimportMan.DYNFUNmultiObjectUpdate())
        on MNDYNremove picked do (DYNimportMan.DYNFUNdeleteSelected())
        on MNDYNrename picked do (DYNimportMan.dnlv.selectedItems.item[0].beginEdit())

        on MNDYNproperties picked do max properties

        on MNDYNchange picked do
        (
          local LOCbaseFileName  = ""
          local LOCbaseSceneNode = maxOps.getNodeByHandle (DYNimportMan.dnLv.SelectedItems.item[0].name as integer)
          if isValidNode LOCbaseSceneNode then
          (
            LOCbaseFileName  = getappData (maxOps.getNodeByHandle (DYNimportMan.dnLv.SelectedItems.item[0].name as integer)) 424
          )
          LOCbaseFileName = if doesFileExist LOCbaseFileName then ((getFilenamePath LOCbaseFileName) + "*" + (getFilenameType LOCbaseFileName)) else ""

          local LOCfile = getOpenFileName caption:DYNuiResourcesTitlebars[11] filename:LOCbaseFileName types:DYNuiResourcesFileTypes[11]
          if LOCfile != undefined then
          (
            if querybox (DYNFUNformatValueToString DYNuiResourcesQueries[47] LOCfile) title:DYNuiResourcesTitlebars[3] then
            (
              if DYNimportMan.dnLv.SelectedItems.count > 10 then
              (
                for i = 1 to DYNimportMan.dnLv.Items.count do
                (
                  local LOCitem    = DYNimportMan.dnLv.Items.item[i-1]
                  if LOCitem.selected then (setAppData (maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[1] as integer)) 424 LOCfile)
                )
              )
              else
              (
                for i = 1 to DYNimportMan.dnLv.SelectedItems.count do
                (
                  local LOCitem    = DYNimportMan.dnLv.SelectedItems.item[i-1]
                  setAppData (maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[1] as integer)) 424 LOCfile
                )
              )
              DYNimportMan.DYNFUNregatherImportedObjects()
            )
          )
        )

        on MNDYNstrChange picked do
        (
          if (queryBox (DYNuiResourcesQueries[46]) title:DYNuiResourcesTitlebars[2] beep:false) then
          (
            if (stricmp (getFilenameType LOCselTag[6]) ".vsp3d") == 0 then
            (
              local LOCexist427 = LOCselTag[3]
              local LOCnewName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[37] DYNuiResourcesLabels[468] LOCexist427
              if LOCnewName != undefined and LOCnewName != "" then
              (
                LOCselTag[3] = LOCnewName
                local LOCcurObj = maxOps.GetNodeByHandle ((filterString DYNimportMan.dnLv.selectedItems.item[0].tag "|")[1] as integer)
                setAppData LOCcurObj 427 LOCnewName
                DYNimportMan.dnLv.selectedItems.item[0].SubItems.item[2].text = getAppData LOCcurObj 427
                DYNimportMan.dnLv.selectedItems.item[0].tag = DYNFUNarray2DelimitedString LOCselTag "|"
              )
            )
            else
            (
              local LOCexist427 = LOCselTag[3]
              local LOCnewName = DYNFUNdisplayEditText DYNuiResourcesTitlebars[37] DYNuiResourcesLabels[468] LOCexist427
              if LOCnewName != undefined and LOCnewName != "" then
              (
                LOCnewName = DYNFUNupperCase LOCnewName 0
                LOCselTag[3] = LOCnewName
                local LOCcurObj = maxOps.GetNodeByHandle ((filterString DYNimportMan.dnLv.selectedItems.item[0].tag "|")[1] as integer)
                setAppData LOCcurObj 427 LOCnewName
                DYNimportMan.dnLv.selectedItems.item[0].SubItems.item[2].text = getAppData LOCcurObj 427
                DYNimportMan.dnLv.selectedItems.item[0].tag = DYNFUNarray2DelimitedString LOCselTag "|"
              )
            )
          )
        )
      )
      registerRightClickMenu DYNimportMan.LOCmsgMenu
    )
  )

  fn DYNFUNselectInVPandUpdateStatusBar =
  (
    callbacks.removescripts id:#DYNimportMan

    local LOCselArray = #()
    if DYNimportMan.dnLv.SelectedItems.count > 10 then
    (
      for i = 1 to DYNimportMan.dnLv.Items.count do
      (
        /* It is  MUCH quicker to cycle through ALL items rather than SELECTED items if selecting alot of objects */
        DYNimportMan.dnProgress.value = (i as float) / DYNimportMan.dnLv.Items.count * 100.0
        local LOCitem    = DYNimportMan.dnLv.Items.item[i-1]
        if LOCitem.selected then
        (
          local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[1] as integer)
          if isValidNode LOCcurObj then append LOCselArray LOCcurObj
        )
      )
    )
    else
    (
      for i = 1 to DYNimportMan.dnLv.SelectedItems.count do
      (
        /* It is  MUCH quicker to cycle through ALL items rather than SELECTED items if selecting alot of objects */
        DYNimportMan.dnProgress.value = (i as float) / DYNimportMan.dnLv.SelectedItems.count * 100.0
        local LOCitem    = DYNimportMan.dnLv.SelectedItems.item[i-1]
        local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[1] as integer)
        if isValidNode LOCcurObj then append LOCselArray LOCcurObj
      )
    )
    if LOCselArray.count > 0 then
    (
      select LOCselArray
      DYNimportMan.dnStatus.panels.item[0].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[9] LOCselArray.count
    )
    else
    (
      clearSelection()
      local LOCtotalObjects = 0
      for i in DYNimportCatsArray do LOCtotalObjects += DYNimportMan.LOCobjHandles[i].count
      DYNimportMan.dnStatus.panels.item[0].text = (DYNFUNformatValueToString DYNuiResourcesStatusMessages[53] LOCtotalObjects) + " / " + (DYNFUNformatValueToString DYNuiResourcesStatusMessages[35] DYNimportMan.dnLv.Items.count)
    )

    callbacks.addscript #selectedNodesPreDelete "DYNimportMan.DYNFUNpreObjectsDeleted()" id:#DYNimportMan
    callbacks.addscript #selectionSetChanged    "DYNimportMan.DYNFUNObjectsSelected()"   id:#DYNimportMan
    DYNimportMan.dnProgress.value = 0
  )


  fn DYNFUNregatherImportedObjects =
  (
    if DYNimportMan.open then
    (
      DYNimportMan.LOCobjHandles = DYNFUNgetCivilViewCategorizedNodeArrays "handles" true
      DYNimportMan.dnLv.Items.clear()
      DYNimportMan.dnLv.refresh()
      DYNimportMan.dnStatus.refresh()

      DYNimportMan.LOCappData427array = #()
      DYNimportMan.LOCappData428array = #()
      DYNimportMan.LOCmaxObjectarray  = #()

      local LOClistItemRange = #()
      DYNimportMan.dnLv.suspendLayout()
      DYNimportMan.dnLv.beginUpdate()

      local LOCtotalObjects    = 0; for i in DYNimportCatsArray do LOCtotalObjects += DYNimportMan.LOCobjHandles[i].count
      local LOCcnt             = 0

      for i in DYNimportCatsArray do
      (
        for ii in DYNimportMan.LOCobjHandles[i] do
        (
          LOCcnt += 1
          DYNimportMan.dnProgress.value = (LOCcnt as float) / LOCtotalObjects * 100.0

          local LOCobject       = maxOps.GetNodeByHandle ii
          local LOCobjAppData   = DYNFUNgetObjAppData LOCobject "-"

          --- Get File Last Modifier Date, or for MX Model Files - model last modified date
          local LOCfileModified = DYNFUNgetFileModifyTime LOCobjAppData[4] true
          if (getFilenameType LOCobjAppData[4]) == ".fil" and classOf LOCobjAppData[8] == string then
          (
            local LOCmodelName      = LOCobjAppData[8]; while LOCmodelName.count < 28 do LOCmodelName += " "
            local LOCmxModelmodDate = DYNFUNgetMxModelFileModelModifyTime LOCobjAppData[4] LOCmodelName
            if classOf LOCmxModelmodDate == string then LOCfileModified = LOCmxModelmodDate
          )

          if LOCfileModified == "" then LOCfileModified = "-"

          --- Filter
          local LOCfilterString = ""
          if DYNimportMan.DDDYNfilter.selection == 1 then LOCfilterString = LOCobject.name
          if DYNimportMan.DDDYNfilter.selection == 2 then LOCfilterString = DYNFUNdisplayAppDataInUI LOCobjAppData[7]
          if DYNimportMan.DDDYNfilter.selection == 3 then LOCfilterString = DYNFUNdisplayAppDataInUI LOCobjAppData[8]
          if DYNimportMan.DDDYNfilter.selection == 4 then LOCfilterString = LOCobjAppData[4]
          local LOCfilterProceed = if DYNimportMan.LOCfilterSwitch then (matchPattern LOCfilterString pattern:DYNimportMan.EDDYNfilter.text ignoreCase:true) else true

          --- Build Master Filter List
          if findItem DYNimportMan.LOCappData427array (DYNFUNdisplayAppDataInUI LOCobjAppData[7]) == 0 then append DYNimportMan.LOCappData427array (DYNFUNdisplayAppDataInUI LOCobjAppData[7])
          if findItem DYNimportMan.LOCappData428array (DYNFUNdisplayAppDataInUI LOCobjAppData[8]) == 0 then append DYNimportMan.LOCappData428array (DYNFUNdisplayAppDataInUI LOCobjAppData[8])
          if findItem DYNimportMan.LOCmaxObjectarray  LOCobject.name == 0 then append DYNimportMan.LOCmaxObjectarray  LOCobject.name

          --- Add To Display
          if isValidNode LOCobject and LOCfilterProceed then
          (
            --- Add DN ListItem
            local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" LOCobject.name
            LOClistItem.ImageIndex = i
            LOClistItem.name       = LOCobject.inode.handle as string
            LOClistItem.tag        = (ii as string) + "|" + (LOCobjAppData[8]) + "|" + (LOCobjAppData[7]) + "|" + (LOCobjAppData[5]) + "|" + LOCfileModified + "|" + LOCobjAppData[4] + "|" + "-" + "|" + "-"
            LOClistItem.UseItemStyleForSubItems = false

            --- Decide whether this object is updateable
            if LOCfileModified == "-" or LOCobjAppData[8] == "-" or LOCobjAppData[7] == "-" then (LOClistItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor)
            if (stricmp (getFilenameType LOCobjAppData[4]) ".XML") == 0 and LOClistItem.ImageIndex == 7 then
            (
              -- LandXML Surface Breaklines are not updateable
              LOClistItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
            )

            --- Add Attributes
            local LOCobjAttribs = filterString LOClistItem.tag "|"
            local LOCfileImported = if (findString (DYNFUNconvertGUPdate LOCobjAttribs[4]) "undefined") != undefined then "-" else (DYNFUNconvertGUPdate LOCobjAttribs[4])
            local LOCfileUpdated  = if (findString (DYNFUNconvertGUPdate LOCobjAttribs[5]) "undefined") != undefined then "-" else (DYNFUNconvertGUPdate LOCobjAttribs[5])

            local LOCsubItem
            LOCsubItem    = LOClistItem.SubItems.add (DYNFUNdisplayAppDataInUI LOCobjAttribs[2]); if LOClistItem.forecolor == DYNFUNdnColor DYNINIgreyedOutColor then LOCsubItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
            LOCsubItem    = LOClistItem.SubItems.add (DYNFUNdisplayAppDataInUI LOCobjAttribs[3]); if LOClistItem.forecolor == DYNFUNdnColor DYNINIgreyedOutColor then LOCsubItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
            LOCsubItem    = LOClistItem.SubItems.add LOCfileImported                            ; if LOClistItem.forecolor == DYNFUNdnColor DYNINIgreyedOutColor then LOCsubItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
            LOCsubItem    = LOClistItem.SubItems.add LOCfileUpdated                             ; if LOClistItem.forecolor == DYNFUNdnColor DYNINIgreyedOutColor then LOCsubItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
            LOCsubItem    = LOClistItem.SubItems.add LOCobjAttribs[6]                           ; if LOClistItem.forecolor == DYNFUNdnColor DYNINIgreyedOutColor then LOCsubItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
            append LOClistItemRange LOClistItem
          )
        )
      )

      --- Add Items to LV
      DYNimportMan.dnLv.Items.AddRange LOClistItemRange
      DYNimportMan.dnLv.endUpdate()
      DYNimportMan.dnLv.resumeLayout()

      --- Prepare Filtering Arrays
      sort DYNimportMan.LOCappData427array
      sort DYNimportMan.LOCappData428array
      sort DYNimportMan.LOCmaxObjectarray

      if not DYNimportMan.LOCsourceFilePath then
      (
        for i = 1 to DYNimportMan.dnLv.Items.count do
        (
          local LOCitem = DYNimportMan.dnLv.Items.item[i-1]
          LOCitem.SubItems.item[5].text = filenameFromPath LOCitem.SubItems.item[5].text
        )
      )

      --- Compare "Object Imported" and "Source File Last Modified" Dates - Highlight if Necessary
      for i = 1 to DYNimportMan.dnLv.Items.count do
      (
        local LOCitem = DYNimportMan.dnLv.Items.item[i-1]
        local LOCfilteredTag   = filterString LOCitem.tag "|"
        local LOColdDateString = LOCfilteredTag[4]
        local LOCnewDateString = LOCfilteredTag[5]

        if (DYNimportMan.DYNFUNcompareGUPdates LOColdDateString LOCnewDateString) and LOCnewDateString != "-" and LOColdDateString != "-" then
        (
          LOCitem.forecolor = DYNFUNdnColor (color 255 0 0)
          LOCitem.SubItems.item[4].forecolor = DYNFUNdnColor (color 255 0 0)
          LOCitem.SubItems.item[5].forecolor = DYNFUNdnColor (color 255 0 0)
        )
      )

      --- Kill Please Wait Message
      DYNimportMan.dnProgress.value = 0

      --- Select Viewport Objects in ListView
      DYNimportMan.DYNFUNobjectsSelected()

      --- Update Status Bar
      DYNimportMan.dnStatus.panels.item[0].text = (DYNFUNformatValueToString DYNuiResourcesStatusMessages[53] LOCtotalObjects) + " / " + (DYNFUNformatValueToString DYNuiResourcesStatusMessages[35] DYNimportMan.dnLv.Items.count)
    )
  )

  fn DYNFUNselectAll =
  (
    setFocus DYNimportMan.dnLv
    DYNimportMan.dnLv.beginUpdate()

    for i = 1 to DYNimportMan.dnLv.Items.count do
    (
      local LOCitem    = DYNimportMan.dnLv.Items.item[i-1]
      LOCitem.selected = true
    )
    DYNimportMan.dnLv.endUpdate()
  )

  fn DYNFUNselectNone =
  (
    setFocus DYNimportMan.dnLv
    DYNimportMan.dnLv.beginUpdate()

    for i = 1 to DYNimportMan.dnLv.Items.count do
    (
      local LOCitem    = DYNimportMan.dnLv.Items.item[i-1]
      LOCitem.selected = false
    )
    DYNimportMan.dnLv.endUpdate()
  )

  fn DYNFUNselectInvert =
  (
    setFocus DYNimportMan.dnLv
    DYNimportMan.dnLv.beginUpdate()
    for i = 1 to DYNimportMan.dnLv.Items.count do
    (
      local LOCitem    = DYNimportMan.dnLv.Items.item[i-1]
      LOCitem.selected = not LOCitem.selected
    )
    DYNimportMan.dnLv.endUpdate()
  )

  --- Function to see if Date A really is Older than Date B
  fn DYNFUNcompareGUPdates FUNoldDateString FUNnewDateString =
  (
    local LOCintArray1  = filterString FUNoldDateString "$"
    local LOCintArray2  = filterString FUNnewDateString "$"
    local LOCintString1 = "0"
    local LOCintString2 = "0"
    local LOCresult     = true

    if (findString FUNoldDateString "$" != undefined) and (findString FUNnewDateString "$" != undefined) then
    (
      if (LOCintArray1[3] as integer) == (LOCintArray2[3] as integer) then
      (
        --- Dates Are In Same Calendar Year (ignore seconds when comparing dates)
        append LOCintString1 (if LOCintArray1[2].count < 2 then ("0" + LOCintArray1[2]) else LOCintArray1[2])
        append LOCintString1 (if LOCintArray1[1].count < 2 then ("0" + LOCintArray1[1]) else LOCintArray1[1])
        append LOCintString1 (if LOCintArray1[4].count < 2 then ("0" + LOCintArray1[4]) else LOCintArray1[4])
        append LOCintString1 (if LOCintArray1[5].count < 2 then ("0" + LOCintArray1[5]) else LOCintArray1[5])

        append LOCintString2 (if LOCintArray2[2].count < 2 then ("0" + LOCintArray2[2]) else LOCintArray2[2])
        append LOCintString2 (if LOCintArray2[1].count < 2 then ("0" + LOCintArray2[1]) else LOCintArray2[1])
        append LOCintString2 (if LOCintArray2[4].count < 2 then ("0" + LOCintArray2[4]) else LOCintArray2[4])
        append LOCintString2 (if LOCintArray2[5].count < 2 then ("0" + LOCintArray2[5]) else LOCintArray2[5])

        if (LOCintString1 as integer) > (LOCintString2 as integer) then LOCresult = false
      )
      else
      (
        --- Dates are in different Calendar Year
        if (LOCintArray1[3] as integer) > (LOCintArray2[3] as integer) then LOCresult = false
      )
    )

    --- return TRUE if dateA is older than Date B, but false otherwise
    LOCresult
  )

  --- Callback related functions
  fn DYNFUNpreObjectsDeleted =
  (
    --- Get array of nodes about to be deleted, or undefined if callback broadcasted
    local LOCnotifyParam = callbacks.notificationParam()

    if LOCnotifyParam != undefined then
    (
      for i in LOCnotifyParam do
      (
        local LOClistItems = DYNimportMan.dnLv.items.find (i.inode.handle as string) false
        if LOClistItems.count >= 1 then DYNimportMan.dnLv.Items.Remove LOClistItems[1]

      )
    )
    local LOCtotalObjects = 0
    for i in DYNimportCatsArray do LOCtotalObjects += DYNimportMan.LOCobjHandles[i].count
    DYNimportMan.dnStatus.panels.item[0].text = (DYNFUNformatValueToString DYNuiResourcesStatusMessages[53] (LOCtotalObjects - LOCnotifyParam.count)) + " / " + (DYNFUNformatValueToString DYNuiResourcesStatusMessages[35] DYNimportMan.dnLv.Items.count)
    DYNimportMan.dnStatus.panels.item[1].text = ""
    DYNimportMan.dnStatus.panels.item[2].text = ""
  )

  fn DYNFUNobjectsSelected =
  (
    DYNimportMan.dnLv.suspendLayout()
    DYNimportMan.dnLv.beginUpdate()

    local LOCobjects    = getCurrentSelection()
    local LOCimpObjects = #()
    local LOCcnt        = 0
    DYNimportMan.dnLv.SelectedItems.clear()

    for i in LOCobjects do
    (
      LOCcnt += 1
      DYNimportMan.dnProgress.value = (LOCcnt as float) / LOCobjects.count * 100.0

      local LOClistItems = DYNimportMan.dnLv.items.find (i.inode.handle as string) false
      if LOClistItems.count >= 1 then LOClistItems[1].selected = true

      append LOCimpObjects i
    )

    if DYNimportMan.dnLv.selectedItems.count > 0 then DYNimportMan.dnLv.selectedItems.item[0].ensureVisible()

    DYNimportMan.dnLv.endUpdate()
    DYNimportMan.dnLv.resumeLayout()

    if LOCimpObjects.count > 0 then
    (
      DYNimportMan.dnStatus.panels.item[0].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[9] LOCimpObjects.count

      if DYNimportMan.dnLv.selectedItems.count > 0 then
      (
        local LOCsingleObject = maxOps.GetNodeByHandle ((filterString DYNimportMan.dnLv.selectedItems.item[0].tag "|")[1] as integer)

        --- Shapes
        if DYNimportMan.dnLv.selectedItems.item[0].imageIndex == 7 then
        (
          DYNimportMan.dnStatus.panels.item[1].text = ((try (numKnots LOCsingleObject) catch (0)) as string) + " " + DYNuiResourcesLabels[465]
          DYNimportMan.dnStatus.panels.item[2].text = DYNuiResourcesLabels[28] + " " + (try ((curveLength LOCsingleObject) as string) catch (""))
        )

        --- Surfaces
        if DYNimportMan.dnLv.selectedItems.item[0].imageIndex == 8 then
        (
          DYNimportMan.dnStatus.panels.item[1].text = ((try (getNumFaces LOCsingleObject) catch (0)) as string) + " " + DYNuiResourcesLabels[466]
          DYNimportMan.dnStatus.panels.item[2].text = ""
        )
      )
    )
    else
    (
      local LOCtotalObjects = 0
      for i in DYNimportCatsArray do LOCtotalObjects += DYNimportMan.LOCobjHandles[i].count
      DYNimportMan.dnStatus.panels.item[0].text = (DYNFUNformatValueToString DYNuiResourcesStatusMessages[53] LOCtotalObjects) + " / " + (DYNFUNformatValueToString DYNuiResourcesStatusMessages[35] DYNimportMan.dnLv.Items.count)
      DYNimportMan.dnStatus.panels.item[1].text = ""
      DYNimportMan.dnStatus.panels.item[2].text = ""
    )

    DYNimportMan.dnProgress.value = 0
  )


  --- Create Rollout Controls -------------------------------------------------------------------------------------------
  label LBDYNfilter        pos:[5,6] width:80
  dropdownlist DDDYNfilter pos:[90,3] width:160
  button BUDYNfilter1      pos:[252,3] width:20  height:20
  edittext EDDYNfilter     pos:[271,5] width:160
  button BUDYNfilter2      pos:[434,3] width:80  height:20
  button BUDYNfilter3      pos:[516,3] width:80  height:20

  dotNetControl  dnLv       "System.Windows.Forms.ListView" width:1000 height:1000 pos:[0,25]
  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar" width:1000 height:14   pos:[0,(DYNdefRLsizeIMP.y - 35)]
  dotNetControl  dnStatus   "System.Windows.Forms.StatusBar" width:1000 height:20   pos:[0,(DYNdefRLsizeIMP.y - 19)]

  on DYNimportMan open do
  (
    DYNimportMan.title = DYNuiRolloutNames[58]

    BUDYNfilter2.text  = DYNuiResourcesButtons[18]
    BUDYNfilter3.text  = DYNuiResourcesButtons[19]
    BUDYNfilter1.text  = "..."

    LBDYNfilter.text   = DYNuiResourcesLabels[397]
    EDDYNfilter.text   = "*"
    DDDYNfilter.items  = #(DYNuiResourcesLabels[460], DYNuiResourcesLabels[461], DYNuiResourcesLabels[462], DYNuiResourcesLabels[463])

    DYNFUNresizeImportMan DYNdefRLsizeIMP

    --- dotNet ListView Init
    DYNFUNdnListViewStyle dnLv false true
    dnLv.multiSelect        = true
    dnLv.AllowColumnReorder = true
    dnLv.sorting            = DYNdnSortOrderClass.none
    dnLv.smallImageList     = DYNdnSmImageList
    dnlv.labelEdit          = true

    local LOCcol1 = dnLv.Columns.add DYNuiResourcesLvColumns[74]  195; LOCcol1.textAlign = DYNdnHorAlignClass.left
    local LOCcol2 = dnLv.Columns.add DYNuiResourcesLvColumns[111] 160; LOCcol2.textAlign = DYNdnHorAlignClass.center
    local LOCcol3 = dnLv.Columns.add DYNuiResourcesLvColumns[112] 120; LOCcol3.textAlign = DYNdnHorAlignClass.center
    local LOCcol4 = dnLv.Columns.add DYNuiResourcesLvColumns[113] 120; LOCcol4.textAlign = DYNdnHorAlignClass.center
    local LOCcol5 = dnLv.Columns.add DYNuiResourcesLvColumns[114] 120; LOCcol5.textAlign = DYNdnHorAlignClass.center
    local LOCcol6 = dnLv.Columns.add DYNuiResourcesLvColumns[115] 950; LOCcol6.textAlign = DYNdnHorAlignClass.left

    --- Set Up DN Status Bar
    dnStatus.showPanels = true
    dnStatus.SizingGrip = true
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.item[0].width = 280
    dnStatus.panels.item[1].width = 140
    dnStatus.panels.item[2].width = 140
    dnStatus.panels.item[3].width = 100
    dnStatus.panels.item[4].width = 100
    dnStatus.panels.item[5].width = 60
    dnStatus.panels.item[0].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[1].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[2].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[3].alignment = DYNdnHorAlignClass.Left
    dnStatus.panels.item[4].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[5].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[3].autosize = (dotNetClass "System.Windows.Forms.StatusBarPanelAutoSize").spring

    --- Resize Panel Components

    --- Gather Imported Objects
    gc()
    DYNimportMan.DYNFUNregatherImportedObjects()

    --- Add DYNimportMan specific callbacks
    callbacks.removescripts id:#DYNimportMan
    callbacks.addscript #selectedNodesPreDelete "DYNimportMan.DYNFUNpreObjectsDeleted()" id:#DYNimportMan
    callbacks.addscript #selectionSetChanged    "DYNimportMan.DYNFUNObjectsSelected()"   id:#DYNimportMan
  )

  on DYNimportMan close do
  (
    callbacks.removescripts id:#DYNimportMan
    DYNimportMan.LOCobjHandles = #()
    DYNFUNonDialogClose()
  )

  on dnLv AfterLabelEdit arg do
  (
    if arg.label != undefined and arg.label != "" then
    (
      local LOCcurObj = maxOps.GetNodeByHandle ((filterString dnLv.items.item[arg.item].tag "|")[1] as integer)
      LOCcurObj.name  = arg.label
    )
  )

  on DYNimportMan resized argPt2 do
  (
    DYNFUNresizeImportMan argPt2
  )

  on DYNimportMan moved argPt2 do
  (
    DYNimpLUP = argPt2
  )

  on dnLv ColumnClick arg do
  (
    /* arg.column (to get to index of selected column) */
    if dnLv.sorting == DYNdnSortOrderClass.none       then
    (
      dnLv.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnLv.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnLv.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnLv.sorting == DYNdnSortOrderClass.descending then dnLv.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnLv.selectedItems.count > 0 then dnLv.selectedItems.item[0].ensureVisible()
  )

  on BUDYNfilter1 pressed do
  (
    local LOCfile
    local LOCselection = 1
    local LOCarray = #()

    --- Filter By Object name
    if DDDYNfilter.selection == 1 then
    (
      LOCarray = #(DYNuiResourcesLabels[392])
      for i in LOCmaxObjectarray do (append LOCarray i)
      LOCselection = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[32] DYNuiResourcesLabels[390] LOCarray LOCselection
    )

    --- Filter By Source String Label
    if DDDYNfilter.selection == 2 then
    (
      LOCarray = #(DYNuiResourcesLabels[464])
      for i in LOCappData427array do (append LOCarray i)
      LOCselection = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[32] DYNuiResourcesLabels[461] LOCarray LOCselection
    )

    --- Filter By Source Model Name
    if DDDYNfilter.selection == 3 then
    (
      LOCarray = #(DYNuiResourcesLabels[467])
      for i in LOCappData428array do (append LOCarray i)
      LOCselection = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[32] DYNuiResourcesLabels[462] LOCarray LOCselection
    )

    --- Filter By Source Data File
    if DDDYNfilter.selection == 4 then
    (
     local LOCfile = getOpenFileName caption:DYNuiResourcesTitlebars[11] filename:"" types:DYNuiResourcesFileTypes[11]
    )

    --- If Selection Is Still 1, no selection was made
    if LOCselection != 1 then
    (
      EDDYNfilter.text = LOCarray[LOCselection]
    )

    if LOCfile != undefined then
    (
      EDDYNfilter.text = "*" + (filenamefromPath LOCfile)
    )
  )

  on BUDYNfilter2 pressed do
  (
    LOCfilterSwitch = true
    DYNimportMan.DYNFUNregatherImportedObjects()
  )

  on DDDYNfilter selected arg do
  (
  )

  on EDDYNfilter changed arg do
  (
  )

  on BUDYNfilter3 pressed do
  (
    LOCfilterSwitch = false
    DYNimportMan.DYNFUNregatherImportedObjects()
  )

  on dnLv ItemSelectionChanged arg do
  (
    if arg.isSelected then
    (
      callbacks.removescripts id:#DYNimportMan

      if dnLv.selectedItems.count > 0 then
      (
        local LOCsingleObject = maxOps.GetNodeByHandle ((filterString dnLv.selectedItems.item[0].tag "|")[1] as integer)
        if isValidNode LOCsingleObject then
        (
          if dnLv.selectedItems.item[0].imageIndex == 7 then
          (
            dnStatus.panels.item[1].text = ((try (numKnots LOCsingleObject) catch (0)) as string) + " " + DYNuiResourcesLabels[465]
            dnStatus.panels.item[2].text = DYNuiResourcesLabels[28] + " " + (try ((curveLength LOCsingleObject) as string) catch (""))
          )
          if dnLv.selectedItems.item[0].imageIndex == 8 then
          (
            dnStatus.panels.item[1].text = ((try (getNumFaces LOCsingleObject) catch (0)) as string) + " " + DYNuiResourcesLabels[466]
            dnStatus.panels.item[2].text = ""
          )
        )
        else
        (
          clearSelection()
          dnStatus.panels.item[1].text = ""
          dnStatus.panels.item[2].text = ""
        )
      )
      else
      (
        clearSelection()
        dnStatus.panels.item[1].text = ""
        dnStatus.panels.item[2].text = ""
      )

      callbacks.addscript #selectedNodesPreDelete "DYNimportMan.DYNFUNpreObjectsDeleted()" id:#DYNimportMan
      callbacks.addscript #selectionSetChanged    "DYNimportMan.DYNFUNObjectsSelected()"   id:#DYNimportMan
    )
  )

  on dnLv MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.left then
    (
      DYNFUNselectInVPandUpdateStatusBar()
    )
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmsgPopupMenu()
      if LOCmsgMenu != undefined then popupMenu LOCmsgMenu
    )
  )
)

--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--

rollout DYNplacedMan ""
(
  --- Local Variables ----------------------------------
  local rollout_dnLvMin     = [0,45]
  local LOCsideRolloutWidth = 200

  local LOCmsgMenu
  local LOCfilterSwitch     = false

  local LOCfilterArray1    = #()
  local LOCfilterArray2    = #()
  local LOCfilterArray3    = #()

  --- Local Functions ----------------------------------
  fn DYNFUNbuildMenuPlacedMan =
  (
    local LOCexe = "RcMenu DYNplacedManRCMenu\n"
    LOCexe += "(\n"
    LOCexe += "  local LOCmultiSelect = false\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[1] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNexpOps\n"
    LOCexe += "    menuItem  MNDYNexpTxt\n"
    LOCexe += "  )\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[2] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNobjDel\n"
    LOCexe += "    separator MNDYNsep1\n"
    LOCexe += "    menuItem  MNDYNSelAll\n"
    LOCexe += "    menuItem  MNDYNSelNone\n"
    LOCexe += "    menuItem  MNDYNSelInv\n"
    LOCexe += "    separator MNDYNsep2\n"
    LOCexe += "    menuItem  MNDYNProps\n"
    LOCexe += "  )\n"
    LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[3] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem  MNDYNrefresh\n"
    LOCexe += "    separator MNDYNsep3\n"
    LOCexe += "    menuItem  MNDYNunsorted\n"
    LOCexe += "  )\n"
    LOCexe += "  SubMenu \"" + DYNuiResourcesSubMenus[4] + "\"\n"
    LOCexe += "  (\n"
    LOCexe += "    menuItem MNDYNhelp\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on DYNplacedManRCMenu open do\n"
    LOCexe += "  (\n"
    LOCexe += "    MNDYNexpOps.text   = DYNuiResourcesMenus[114]\n"
    LOCexe += "    MNDYNexpTxt.text   = DYNuiResourcesMenus[110]\n"
    LOCexe += "    MNDYNobjDel.text   = DYNuiResourcesMenus[10]\n"
    LOCexe += "    MNDYNSelAll.text   = DYNuiResourcesMenus[14]\n"
    LOCexe += "    MNDYNSelNone.text  = DYNuiResourcesMenus[15]\n"
    LOCexe += "    MNDYNSelInv.text   = DYNuiResourcesMenus[111]\n"
    LOCexe += "    MNDYNProps.text    = DYNuiResourcesMenus[8]\n"
    LOCexe += "    MNDYNrefresh.text  = DYNuiResourcesMenus[2]\n"
    LOCexe += "    MNDYNunsorted.text = DYNuiResourcesMenus[113]\n"
    LOCexe += "    MNDYNhelp.text     = DYNuiResourcesMenus[5]\n"
    LOCexe += "  )\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNexpOps   picked do (DYNplacedMan.DYNFUNexportToOPS())\n"
    LOCexe += "  on MNDYNexpTxt   picked do (DYNFUNsaveDnLvtoTextFile DYNplacedMan.dnLv \";\")\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNobjDel   picked do (DYNplacedMan.DYNFUNdeleteSelected())\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNSelAll   picked do (DYNplacedMan.DYNFUNselectAll();    DYNplacedMan.DYNFUNselectInVPandUpdateStatusBar())\n"
    LOCexe += "  on MNDYNSelNone  picked do (DYNplacedMan.DYNFUNselectNone();   DYNplacedMan.DYNFUNselectInVPandUpdateStatusBar())\n"
    LOCexe += "  on MNDYNSelInv   picked do (DYNplacedMan.DYNFUNselectInvert(); DYNplacedMan.DYNFUNselectInVPandUpdateStatusBar())\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNrefresh  picked do DYNplacedMan.DYNFUNregatherPlacedObjects()\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNunsorted picked do (DYNplacedMan.dnLv.sorting = DYNdnSortOrderClass.none; DYNplacedMan.DYNFUNregatherPlacedObjects())\n"
    LOCexe += "\n"
    LOCexe += "  on MNDYNhelp     picked do DYNFUNopenHelp 13207\n" -- id_cv_placed_object_manager
    LOCexe += "  on MNDYNProps    picked do max properties\n"
    LOCexe += ")\n"

    Execute LOCexe
  )

  fn DYNFUNresizePlacedMan FUNsize =
  (
    DYNplacedMan.dnProgress.pos.y = ((FUNsize).y - 34)
    DYNplacedMan.dnProgress.width = ((FUNsize).x - DYNplacedMan.rollout_dnLvMin.x)

    DYNplacedMan.dnStatus.pos.y   = ((FUNsize).y - 20)
    DYNplacedMan.dnStatus.width   = ((FUNsize).x - DYNplacedMan.rollout_dnLvMin.x)

    DYNplacedMan.dnLv.width       = ((FUNsize) - DYNplacedMan.rollout_dnLvMin - [DYNplacedMan.LOCsideRolloutWidth,0]).x
    DYNplacedMan.dnLv.height      = ((FUNsize) - DYNplacedMan.rollout_dnLvMin - [DYNplacedMan.LOCsideRolloutWidth,0]).y - 14

    DYNdefRLsizePLA = FUNsize
  )

  fn DYNFUNcalcActualChainage FUNpercent FUNcurveLength =
  (
    local LOCbasePercent = 0.0
    if FUNpercent > 0.0 then
    (
      LOCbasePercent = (FUNPercent - (floor FUNpercent)) * FUNcurveLength
    )
    if FUNpercent < 0.0 then
    (
      LOCbasePercent = (((floor FUNpercent) - FUNpercent) * -1) * FUNcurveLength
    )
    return LOCbasePercent
  )

  fn DYNFUNexportToOPS =
  (
    local LOCarray = #()

    if DYNplacedMan.dnLv.selectedItems.count > 0 then
    (
      for i = 1 to DYNplacedMan.dnLv.SelectedItems.count do
      (
        local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
        local LOCobj     = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)

        local LOCpercent = LOCobj.transform.controller.percent

        local LOCsrcINI  = getAppData LOCobj 424

        local LOCfield01 = LOCitem.SubItems.item[4].text                        -- horizontal offset
        local LOCfield02 = LOCitem.SubItems.item[5].text                        -- vertical offset
        local LOCfield03 = "0"                                                  -- chainage interval (always 0 for single objects)
        local LOCfield04 = (LOCpercent * 100.0) as string
        local LOCfield05 = "-1"                                                 -- end chainage
        local LOCfield06 = if LOCobj.boxMode then "1" else "0"                  -- box mode
        local LOCfield07 = (LOCitem.SubItems.item[6].text as integer) as string -- rotation
        local LOCfield08 = "0.0"                                                -- animation speed
        local LOCfield09 = if LOCsrcINI == "" then "[]" else getFilenameFile LOCsrcINI
        local LOCfield10 = LOCitem.ImageIndex as string
        append LOCarray #(LOCfield01, LOCfield02, LOCfield03, LOCfield04, LOCfield05, LOCfield06, LOCfield07, LOCfield08, LOCfield09, LOCfield10)
      )
      DYNobjectPlacer.DYNFUNsaveOPSfile LOCarray false (DYNcountryPath + DYNlocalOpsPath)
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[59]) title:DYNuiResourcesTitlebars[1]
    )
  )

  fn DYNFUNgetCommonColumnValue FUNcolumn =
  (
    local LOCvalue   = 0.0
    local LOCproceed = true

    if DYNplacedMan.dnLv.selectedItems.count > 0 then
    (
      LOCvalue = DYNplacedMan.dnLv.selectedItems.item[0].SubItems.item[FUNcolumn].text as float

      for i = 1 to DYNplacedMan.dnLv.SelectedItems.count do
      (
        if LOCproceed then
        (
          local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
          local LOCcurValue = LOCitem.SubItems.item[FUNcolumn].text as float
          if LOCcurValue != LOCvalue then (LOCproceed = false)                   -- if values differ, just use 0.0
        )
      )
    )

    if LOCproceed then LOCvalue else 0.0
  )

  fn DYNFUNdeleteSelected =
  (
    if (querybox (DYNuiResourcesQueries[1]) title:DYNuiResourcesTitlebars[2]) then
    (
      DYNFUNremoveCSProllouts()
      DYNFUNloadVSPnodeCallBacks false
      (
        callbacks.removescripts id:#DYNplacedMan

        if DYNplacedMan.dnLv.SelectedItems.count > 10 then
        (
          with undo on
          (
          for i = 1 to DYNplacedMan.dnLv.Items.count do
          (
            local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
            if LOCitem.selected then
            (
              local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                  if isValidNode LOCcurObj then
                  (
                    for ii in LOCcurObj.children do delete ii
                    if isValidNode LOCcurObj then delete LOCcurObj
                  )
              )
            )
          )
        )
        else
        (
          with undo on
          (
          for i = 1 to DYNplacedMan.dnLv.SelectedItems.count do
          (
            local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
            local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
              if isValidNode LOCcurObj then
              (
                for ii in LOCcurObj.children do delete ii
                if isValidNode LOCcurObj then delete LOCcurObj
              )
            )
          )
        )

        callbacks.addscript #selectedNodesPostDelete "DYNplacedMan.DYNFUNregatherPlacedObjects()" id:#DYNplacedMan
        callbacks.addscript #selectionSetChanged     "DYNplacedMan.DYNFUNObjectsSelected()"       id:#DYNplacedMan

      )
      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()
    )
  )

  fn DYNFUNcloneSelectedObs FUNobj =
  (
    local LOCnewObjs = #()
    with redraw off
    (
      callbacks.removescripts id:#DYNplacedMan

      DYNFUNremoveCSProllouts()
      DYNFUNloadVSPnodeCallBacks false
      (
        if DYNplacedMan.dnLv.selectedItems.count > 0 then
        (
          --- Clone To Parent Shape -----------------------------------------------------------
          if isValidNode FUNobj then
          (
            local LOCobjsToBeCloned = #()

            --- Gather Objects to be cloned
            if DYNplacedMan.dnLv.SelectedItems.count > 10 then
            (
              for i = 1 to DYNplacedMan.dnLv.Items.count do
              (
                DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
                local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
                if LOCitem.selected then
                (
                  local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                  if isValidNode LOCobj then (append LOCobjsToBeCloned LOCobj)
                )
              )
            )
            else
            (
              for i = 1 to DYNplacedMan.dnLv.SelectedItems.count do
              (
                DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.SelectedItems.count * 100.0
                local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                if isValidNode LOCobj then (append LOCobjsToBeCloned LOCobj)
              )
            )

            --- Clone Objects
            if LOCobjsToBeCloned.count > 0 then
            (
              for i in LOCobjsToBeCloned do
              (
                local LOCobj = copy i
                LOCobj.wireColor    = i.wireColor
                LOCobj.parent       = i.parent
                LOCobj.castShadows  = i.castShadows
                try (LOCobj.isGIoccluder = i.isGIoccluder) catch ()
                DYNFUNgenObjAppData LOCobj (getAppData i 422) (getAppData i 423) (getAppData i 424) (DYNFUNgetLocalTime()) (getAppData i 426) (getAppData i 427) (getAppData i 428)

                --- If Object Is A Vehicle, Check for Child Nodes Which Would Be Rotating Wheels
                if i.children.count > 0 and getAppData i 422 == "1" then
                (
                  local LOCcnt = 1
                  for ii in i.children do
                  (
                    local LOCaxleCopy     = copy ii
                    LOCaxleCopy.pivot     = i.transform.pos
                    LOCaxleCopy.transform = LOCobj.transform.controller.value
                    LOCaxleCopy.pivot     = LOCaxleCopy.center
                    LOCaxleCopy.name      = LOCobj.name + "_" + DYNuiResourcesNodeNames[35] + "_" + (LOCcnt as string)
                    LOCaxleCopy.parent    = LOCobj

                    --- Apply Rotation Controller (and custAtt definition) to Current Axle
                    DYNFUNapplyWheelrotationScriptController LOCaxleCopy

                    --- Increase Axle Count
                    LOCcnt += 1
                  )
                )

                --- Check Number Of Spline In New Shape
                local LOCobjSpl = numSplines FUNobj
                local LOCcontroller =LOCobj.transform.controller
                if LOCcontroller.spline > LOCobjSpl then LOCcontroller.spline = LOCobjSpl

                DYNFUNmaxBakingControl #(LOCobj) true
                LOCcontroller.path = FUNobj
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
                append LOCnewObjs LOCobj
              )
            )
          )
        )
      )
      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()

      callbacks.addscript #selectedNodesPostDelete "DYNplacedMan.DYNFUNregatherPlacedObjects()" id:#DYNplacedMan
      callbacks.addscript #selectionSetChanged     "DYNplacedMan.DYNFUNObjectsSelected()"       id:#DYNplacedMan

      select LOCnewObjs
    )
    DYNplacedMan.dnProgress.value = 0
  )

  fn DYNFUNquickAnimTools FUNmode FUNtype =
  (
    if DYNplacedMan.dnLv.selectedItems.count > 0 then
    (
      with redraw off
      (
        --- Reverse animation
        if FUNmode == 1 then
        (
          local LOCmessage = DYNuiResourcesQueries[59]
          if FUNtype == 1 then LOCmessage = DYNuiResourcesQueries[60]
          if FUNtype == 2 then LOCmessage = DYNuiResourcesQueries[61]
          if FUNtype == 3 then LOCmessage = DYNuiResourcesQueries[62]
          if FUNtype == 4 then LOCmessage = DYNuiResourcesQueries[63]
          local LOCanswer = queryBox (LOCmessage) title:DYNuiResourcesTitlebars[2] beep:false
          if LOCanswer then
          (
            undo label:(DYNuiResourcesUndoLabels[16]) on
            (
              for i = 1 to DYNplacedMan.dnLv.selectedItems.count do
              (
                local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
                DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.selectedItems.count * 100.0
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                DYNFUNmaxBakingControl #(LOCobj) true
                local LOCobjectController = LOCobj.transform.controller
                if FUNtype == 0 or FUNtype == 1 then (if LOCobjectController.percent.keys  != undefined then (reverseTime LOCobjectController.percent.controller (getTimeRange LOCobjectController.percent.controller) #incleft #incRight))
                if FUNtype == 0 or FUNtype == 2 then (if LOCobjectController.hOffset.keys  != undefined then (reverseTime LOCobjectController.hOffset.controller (getTimeRange LOCobjectController.hOffset.controller) #incleft #incRight))
                if FUNtype == 0 or FUNtype == 3 then (if LOCobjectController.vOffset.keys  != undefined then (reverseTime LOCobjectController.vOffset.controller (getTimeRange LOCobjectController.vOffset.controller) #incleft #incRight))
                if FUNtype == 0 or FUNtype == 4 then (if LOCobjectController.rotation.keys != undefined then (reverseTime LOCobjectController.rotation.controller (getTimeRange LOCobjectController.rotation.controller) #incleft #incRight))
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Scale animation
        if FUNmode == 2 then
        (
          local LOCmessage = DYNuiResourcesQueries[64]
          if FUNtype == 1 then LOCmessage = DYNuiResourcesQueries[65]
          if FUNtype == 2 then LOCmessage = DYNuiResourcesQueries[66]
          if FUNtype == 3 then LOCmessage = DYNuiResourcesQueries[67]
          if FUNtype == 4 then LOCmessage = DYNuiResourcesQueries[68]
          local LOCanswer = queryBox (LOCmessage) title:DYNuiResourcesTitlebars[2] beep:false
          if LOCanswer then
          (
            local LOCscale = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[38] DYNuiResourcesLabels[469] [0.01,999.99,1.0] "float"
            if LOCscale != undefined and LOCscale != 0.0 then
            (
              undo label:(DYNuiResourcesUndoLabels[17]) on
              (
                for i = 1 to DYNplacedMan.dnLv.selectedItems.count do
                (
                  local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
                  DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.selectedItems.count * 100.0
                  local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                  DYNFUNmaxBakingControl #(LOCobj) true
                  local LOCobjectController = LOCobj.transform.controller
                  if FUNtype == 0 or FUNtype == 1 then (if LOCobjectController.percent.keys  != undefined then (LOCobjectController.percent.keys.value  *= LOCscale))
                  if FUNtype == 0 or FUNtype == 2 then (if LOCobjectController.hOffset.keys  != undefined then (LOCobjectController.hOffset.keys.value  *= LOCscale))
                  if FUNtype == 0 or FUNtype == 3 then (if LOCobjectController.vOffset.keys  != undefined then (LOCobjectController.vOffset.keys.value  *= LOCscale))
                  if FUNtype == 0 or FUNtype == 4 then (if LOCobjectController.rotation.keys != undefined then (LOCobjectController.rotation.keys.value *= LOCscale))
                  if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
                )
              )
            )
          )
        )

        --- remove animation
        if FUNmode == 3 then
        (
          local LOCmessage = DYNuiResourcesQueries[69]
          if FUNtype == 1 then LOCmessage = DYNuiResourcesQueries[70]
          if FUNtype == 2 then LOCmessage = DYNuiResourcesQueries[71]
          if FUNtype == 3 then LOCmessage = DYNuiResourcesQueries[72]
          if FUNtype == 4 then LOCmessage = DYNuiResourcesQueries[73]
          local LOCanswer = queryBox (LOCmessage) title:DYNuiResourcesTitlebars[2] beep:false
          if LOCanswer then
          (
            undo label:(DYNuiResourcesUndoLabels[15]) on
            (
              for i = 1 to DYNplacedMan.dnLv.selectedItems.count do
              (
                local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
                DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.selectedItems.count * 100.0
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                DYNFUNmaxBakingControl #(LOCobj) true
                local LOCobjectController = LOCobj.transform.controller
                if FUNtype == 0 or FUNtype == 1 then (if LOCobjectController.percent.keys  != undefined then deleteKeys LOCobjectController.percent.keys)
                if FUNtype == 0 or FUNtype == 2 then (if LOCobjectController.hOffset.keys  != undefined then deleteKeys LOCobjectController.hOffset.keys)
                if FUNtype == 0 or FUNtype == 3 then (if LOCobjectController.vOffset.keys  != undefined then deleteKeys LOCobjectController.vOffset.keys)
                if FUNtype == 0 or FUNtype == 4 then (if LOCobjectController.rotation.keys != undefined then deleteKeys LOCobjectController.rotation.keys)
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false

                --- Remove Red Color From ListItem
                if FUNtype == 0 or FUNtype == 1 then (LOCitem.SubItems.item[3].forecolor = DYNFUNdnColor (color 0 0 0)) -- percent
                if FUNtype == 0 or FUNtype == 2 then (LOCitem.SubItems.item[4].forecolor = DYNFUNdnColor (color 0 0 0)) -- h Offset
                if FUNtype == 0 or FUNtype == 3 then (LOCitem.SubItems.item[5].forecolor = DYNFUNdnColor (color 0 0 0)) -- v Offset
                if FUNtype == 0 or FUNtype == 4 then (LOCitem.SubItems.item[6].forecolor = DYNFUNdnColor (color 0 0 0)) -- rotation
              )
            )
          )
        )

        --- add animation
        if FUNmode == 4 then
        (
          local LOCanswer = queryBox (DYNuiResourcesQueries[48]) title:DYNuiResourcesTitlebars[2] beep:false
          if LOCanswer then
          (
            local LOCspeed = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[22] (DYNuiResourcesLabels[269] + " (" + DYNuiResourcesUnitsDistance[DYNINIspeedValue.x] + "/" + DYNuiResourcesUnitsTime[DYNINIspeedValue.y] + ")") [-999.9,999.9,0.0] "float"
            if LOCspeed != undefined and LOCspeed != 0.0 then
            (
              undo label:(DYNuiResourcesUndoLabels[18]) on
              (
                for i = 1 to DYNplacedMan.dnLv.selectedItems.count do
                (
                  local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
                  DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.selectedItems.count * 100.0
                  local LOCobj              = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                  DYNFUNmaxBakingControl #(LOCobj) true
                  local LOCobjectController = LOCobj.transform.controller

                  --- ADD NEW ANIMATION KEYS
                  local LOCspeedParamArray = #(0.0,0f)
                  local LOCpathLen = curveLength LOCobjectController.path LOCobjectController.spline                         -- get length of spline
                  local LOCtempPos = LOCitem.SubItems.item[3].text as float                                                  -- get current chainage
                  if LOCspeed > 0.0 then (LOCspeedParamArray = DYNFUNspeedKeys (LOCpathLen - LOCtempPos) LOCspeed LOCobj)    --
                  if LOCspeed < 0.0 then (LOCspeedParamArray = DYNFUNspeedKeys LOCtempPos LOCspeed LOCobj)                   --
                  LOCobjectController.percent.controller = bezier_float()                                                    -- Create new percent controller

                  local LOCnewKey1 = addNewKey LOCobjectController.percent.controller animationRange.start                   -- Add New Key at current chainage at frame 0
                  LOCnewKey1.value          = LOCtempPos / LOCpathLen                                                        -- Set Value of New Start Anim Key

                  local LOCnewKey2 = addNewKey LOCobjectController.percent.controller LOCspeedParamArray[2]                  -- Add New Key at current chainage at frame 0
                  LOCnewKey2.value          = if LOCspeed > 0.0 then ((LOCtempPos + LOCspeedParamArray[1]) / LOCpathLen) else ((LOCtempPos - LOCspeedParamArray[1]) / LOCpathLen)

                  --- Set Anim Key Tangent Types
                  LOCnewKey1.inTangentType  = #smooth ; LOCnewKey1.outTangentType = #smooth
                  LOCnewKey2.inTangentType  = #smooth ; LOCnewKey2.outTangentType = #smooth

                  if rootNode.DYNrootNodeStore.bakeSwitch == false then
                  (
                    DYNFUNmaxBakingControl #(LOCobj) false
                  )

                  --- UPdate DNLV
                  LOCitem.SubItems.item[3].text = (DYNplacedMan.DYNFUNcalcActualChainage (if isController LOCobjectController.percent.controller then LOCobjectController.percent.controller.value else LOCobjectController.percent) LOCpathLen) as string
                  LOCitem.SubItems.item[3].forecolor = DYNFUNdnColor (color 255 0 0)
                )
              )
            )
          )
        )

        --- Finish Off
        gc()

        --- try/catch required since demand loading of explorer scripts was added
        if try (DYNpositionControl.open) catch (false) do DYNpositionControl.DYNFUNnewControlObj DYNpositionControl.LOCobject
        if try (DYNvehicleParams.open) catch (false) do DYNvehicleParams.DYNFUNvehicleParams   DYNvehicleParams.LOCobj
      )
      redrawViews()
      setFocus DYNplacedMan.dnLv
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[59]) title:DYNuiResourcesTitlebars[1]
    )
    DYNplacedMan.dnProgress.value = 0
  )


  fn DYNFUNeditSelectedObs FUNobj FUNmode =
  (
    if DYNplacedMan.dnLv.selectedItems.count > 0 then
    (
      with redraw off
      (
        --- Change Parent Shape -----------------------------------------------------------
        if FUNmode == 1 then
        (
          if isValidNode FUNobj then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[1].text = FUNobj.name
                LOCitem.SubItems.item[1].forecolor = DYNFUNdnColor (color 0 0 0)

                --- Check Number Of Spline In New Shape
                local LOCobjSpl = numSplines FUNobj
                local LOCcontroller = LOCobj.transform.controller
                if LOCcontroller.spline > LOCobjSpl then LOCcontroller.spline = LOCobjSpl

                DYNFUNmaxBakingControl #(LOCobj) true
                LOCcontroller.path = FUNobj
                LOCitem.SubItems.item[3].text = (DYNplacedMan.DYNFUNcalcActualChainage (if isController LOCcontroller.percent.controller then LOCcontroller.percent.controller.value else LOCcontroller.percent) (curveLength FUNobj LOCcontroller.spline)) as string
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Parent Surface ---------------------------------------------------------
        if FUNmode == 2 then
        (
          if isValidNode FUNobj or FUNobj == undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                --- This parameter is not available for camera objects
                if LOCitem.imageIndex != 5 then
                (
                  local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                  if FUNobj == undefined then
                  (
                    LOCitem.SubItems.item[2].text = DYNuiResourcesLabels[120]
                    LOCitem.SubItems.item[2].forecolor = DYNFUNdnColor DYNINIgreyedOutColor
                  )
                  else
                  (
                    LOCitem.SubItems.item[2].text = FUNobj.name
                    LOCitem.SubItems.item[2].forecolor = DYNFUNdnColor (color 0 0 0)
                  )
                  DYNFUNmaxBakingControl #(LOCobj) true
                  LOCobj.transform.controller.surface = FUNobj
                  if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
                )
              )
            )
          )
        )

        --- Change Horizontal Offset ------------------------------------------------------
        if FUNmode == 3 then
        (
          local LOCoffset = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[39] DYNuiResourcesLabels[470] [-999.9,999.9,(DYNFUNgetCommonColumnValue 4)] "float"
          if LOCoffset != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[4].text = LOCoffset as string
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.hOffset = LOCoffset
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Vertical Offset --------------------------------------------------------
        if FUNmode == 4 then
        (
          local LOCoffset = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[39] DYNuiResourcesLabels[471] [-99.9,99.9,(DYNFUNgetCommonColumnValue 5)] "float"
          if LOCoffset != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[5].text = LOCoffset as string
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.vOffset = LOCoffset
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Rotation ---------------------------------------------------------------
        if FUNmode == 5 then
        (
          local LOCoffset = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[40] DYNuiResourcesLabels[472] [-360.0,360.0,(DYNFUNgetCommonColumnValue 6)] "float"
          if LOCoffset != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[6].text = LOCoffset as string
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.rotation = LOCoffset
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Chainage Spacing -------------------------------------------------------
        if FUNmode == 6 then
        (
          local LOCexistingInfoArray     = #()
          local LOCexistingPercentArray  = #()

          for i = 1 to DYNplacedMan.dnLv.Items.count do
          (
            DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
            local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
            if LOCitem.selected then
            (
              local LOCobj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
              append LOCexistingInfoArray #(LOCobj.transform.controller.percent, LOCitem, LOCobj)
              append LOCexistingPercentArray LOCobj.transform.controller.percent
            )
          )

          --- Re-order percent values in Array in ascending order, then create reference to lowest and highest values
          if LOCexistingPercentArray.count > 2 then -- (IF TWO OR LESS, THERE IS NO NEED TO DO ANYTHING!)
          (
            --- Sort Percent Array Only
            sort LOCexistingPercentArray
            local LOCpercentExtents = [LOCexistingPercentArray[1],LOCexistingPercentArray[LOCexistingPercentArray.count]]

            --- Use Sorted Percent Array To Create Sorted Version Of Main ListItem Info Array
            local LOCsortedInfoArray = #(); LOCsortedInfoArray.count = LOCexistingInfoArray.count
            for i = 1 to LOCexistingPercentArray.count do
            (
              for ii = 1 to LOCexistingInfoArray.count do
              (
                if LOCexistingInfoArray[ii][1] == LOCexistingPercentArray[i] then
                (
                  LOCsortedInfoArray[i] = #(LOCexistingInfoArray[ii][1],LOCexistingInfoArray[ii][2],LOCexistingInfoArray[ii][3])
                )
              )
            )

            --- Calculate percent values of intermediate objects to define equal percent spacing
            for i = 2 to (LOCsortedInfoArray.count - 1) do
            (
              LOCsortedInfoArray[i][1] = LOCpercentExtents.x + (((LOCpercentExtents.y - LOCpercentExtents.x) / (LOCsortedInfoArray.count - 1)) * (i - 1))
            )

            --- Update Object and ListView With Re-calculated Percent (Chainage) Values
            for i in LOCsortedInfoArray do
            (
              i[2].SubItems.item[3].text = (DYNplacedMan.DYNFUNcalcActualChainage i[1] (curveLength i[3].transform.controller.path i[3].transform.controller.spline)) as string
              DYNFUNmaxBakingControl #(i[3]) true
              i[3].transform.controller.percent = i[1]
              if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(i[3]) false
            )
          )
        )

        --- Change Chainage Looping -------------------------------------------------------
        if FUNmode == 7 then
        (
          local LOCmessage = DYNuiResourcesQueries[49]
          LOCmessage += "\n\n"
          LOCmessage += DYNuiResourcesQueries[50]
          local LOCanswer  = YesNoCancelBox LOCmessage title:DYNplacedMan.BUDYNchainageLoop.text beep:false
          if LOCanswer != #cancel then
          (
            local LOCboolean = if LOCanswer == #yes then true else false
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[7].text = if LOCboolean then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31]
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.aux1_bool = LOCboolean
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Shape Direction Tracking -----------------------------------------------
        if FUNmode == 8 then
        (
          local LOCmessage = DYNuiResourcesQueries[51]
          LOCmessage += "\n\n"
          LOCmessage += DYNuiResourcesQueries[52]
          local LOCanswer  = YesNoCancelBox LOCmessage title:DYNplacedMan.BUDYNpathDir.text beep:false
          if LOCanswer != #cancel then
          (
            local LOCboolean = if LOCanswer == #yes then true else false
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[8].text = if LOCboolean then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31]
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.followPath = LOCboolean
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Shape Longfall Tracking -------------------------------------------------
        if FUNmode == 9 then
        (
          local LOCmessage = DYNuiResourcesQueries[53]
          LOCmessage += "\n\n"
          LOCmessage += DYNuiResourcesQueries[54]
          local LOCanswer  = YesNoCancelBox LOCmessage title:DYNplacedMan.BUDYNpathFall.text beep:false
          if LOCanswer != #cancel then
          (
            local LOCboolean = if LOCanswer == #yes then true else false
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[9].text = if LOCboolean then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31]
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.aux2_bool = LOCboolean
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Surface Normal Tracking ------------------------------------------------
        if FUNmode == 10 then
        (
          local LOCmessage = DYNuiResourcesQueries[55]
          LOCmessage += "\n\n"
          LOCmessage += DYNuiResourcesQueries[56]
          local LOCanswer = YesNoCancelBox LOCmessage title:DYNplacedMan.BUDYNsurfNorms.text beep:false
          if LOCanswer != #cancel then
          (
            local LOCboolean = if LOCanswer == #yes then true else false
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                --- Exclude camera objects
                if LOCitem.imageIndex != 5 then
                (
                  local LOCobj            = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                  LOCitem.SubItems.item[10].text = if LOCboolean then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31]
                  DYNFUNmaxBakingControl #(LOCobj) true
                  LOCobj.transform.controller.followSurface = LOCboolean
                  if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
                )
              )
            )
          )
        )

        --- Apply Offset To Chainage ------------------------------------------------
        if FUNmode == 11 then
        (
          local LOCoffset = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[43] DYNuiResourcesLabels[78] [-99999.9,99999.9,0.0] "float"
          if LOCoffset != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)

                local LOCcurveLength   = curveLength LOCobj.transform.controller.path LOCobj.transform.controller.spline
                local LOCpercentOffset = LOCoffset / LOCcurveLength
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.percent += LOCpercentOffset
                if LOCobj.transform.controller.percent < 0.0 then LOCobj.transform.controller.percent = 0.0
                if LOCobj.transform.controller.percent > 1.0 then LOCobj.transform.controller.percent = 1.0
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
                LOCitem.SubItems.item[3].text = (DYNplacedMan.DYNFUNcalcActualChainage (if isController LOCobj.transform.controller.percent.controller then LOCobj.transform.controller.percent.controller.value else LOCobj.transform.controller.percent) LOCcurveLength) as string
              )
            )
          )
        )

        --- Set Bounding Box ------------------------------------------------
        if FUNmode == 12 then
        (
          local LOCmessage = DYNuiResourcesQueries[57]
          LOCmessage += "\n\n"
          LOCmessage += DYNuiResourcesQueries[58]
          local LOCanswer  = YesNoCancelBox LOCmessage title:DYNplacedMan.BUDYNboundBox.text beep:false
          if LOCanswer != #cancel then
          (
            local LOCboolean = if LOCanswer == #yes then true else false
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                --- Exclude Camera Objects
                if LOCitem.imageIndex != 5 then
                (
                  local LOCobj            = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                  if superClassOf LOCobj != light then LOCobj.boxMode = LOCboolean
                )
              )
            )
          )
        )

        --- Set Shadow Casting ----------------------------------------------
        if FUNmode == 13 then
        (
        )

        --- Apply Random Rotation --------------------------------------------
        if FUNmode == 14 then
        (
          local LOCoffset = DYNFUNdisplayMinMaxSpinners DYNuiResourcesTitlebars[42] DYNuiResourcesLabels[474] DYNuiResourcesLabels[475] [-360.0,360.0,-360] [-360.0,360.0,360]
          if LOCoffset != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              local LOCactualOffset = random LOCoffset[1] LOCoffset[2]
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[6].text = LOCactualOffset as string
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.rotation = LOCactualOffset
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Apply Horizontal Offset Range ---------------------------------------------------------------
        if FUNmode == 15 then
        (
          local LOCoffset = DYNFUNdisplayMinMaxSpinners DYNuiResourcesTitlebars[41]  DYNuiResourcesLabels[476] DYNuiResourcesLabels[477] [-999.0,999.0,(DYNFUNgetCommonColumnValue 4)] [-999.0,999.0,(DYNFUNgetCommonColumnValue 4)]
          if LOCoffset != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              local LOCactualOffset = random LOCoffset[1] LOCoffset[2]
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[4].text = LOCactualOffset as string
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.hOffset = LOCactualOffset
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Apply Vertical Offset Range ---------------------------------------------------------------
        if FUNmode == 16 then
        (
          local LOCoffset = DYNFUNdisplayMinMaxSpinners DYNuiResourcesTitlebars[41] DYNuiResourcesLabels[478] DYNuiResourcesLabels[479] [-999.0,999.0,(DYNFUNgetCommonColumnValue 5)] [-999.0,999.0,(DYNFUNgetCommonColumnValue 5)]
          if LOCoffset != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              local LOCactualOffset = random LOCoffset[1] LOCoffset[2]
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[5].text = LOCactualOffset as string
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.vOffset = LOCactualOffset
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Change Spline ID --------------------------------------------------------
        if FUNmode == 17 then
        (
          --- Get Common Max Number of Splines
          local LOCmaxSplines = #()
          for i = 1 to DYNplacedMan.dnLv.Items.count do
          (
            local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
            if LOCitem.selected then
            (
              local LOCobj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
              if isValidNode LOCobj.transform.controller.path then
              (
                append LOCmaxSplines (numSplines LOCobj.transform.controller.path)
              )
            )
          )
          if LOCmaxSplines.count == 0 then append LOCmaxSplines 1
          sort LOCmaxSplines
          local LOCcommonSpline = (DYNFUNgetCommonColumnValue 11) as integer
          if LOCcommonSpline > LOCmaxSplines[1] then LOCcommonSpline = LOCmaxSplines[1]

          local LOCspline = DYNFUNdisplaySpinner DYNuiResourcesTitlebars[44] DYNuiResourcesLabels[473] [1,(LOCmaxSplines[1]),LOCcommonSpline] "integer"
          if LOCspline != undefined then
          (
            for i = 1 to DYNplacedMan.dnLv.Items.count do
            (
              DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
              local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
              if LOCitem.selected then
              (
                local LOCobj           = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
                LOCitem.SubItems.item[11].text = (LOCspline as integer) as string
                DYNFUNmaxBakingControl #(LOCobj) true
                LOCobj.transform.controller.spline = LOCspline as integer
                if rootNode.DYNrootNodeStore.bakeSwitch == false then DYNFUNmaxBakingControl #(LOCobj) false
              )
            )
          )
        )

        --- Finish Off
        gc()

        --- try/catch required since demand loading of explorer scripts was added
        if try (DYNpositionControl.open) catch (false) do DYNpositionControl.DYNFUNnewControlObj DYNpositionControl.LOCobject
        if try (DYNvehicleParams.open) catch (false)   do DYNvehicleParams.DYNFUNvehicleParams   DYNvehicleParams.LOCobj
      )
      redrawViews()
      setFocus DYNplacedMan.dnLv
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[59]) title:DYNuiResourcesTitlebars[1]
    )
    DYNplacedMan.dnProgress.value = 0
  )

  fn DYNFUNmsgPopupMenu =
  (
    DYNplacedMan.LOCmsgMenu = undefined
    if DYNplacedMan.dnLv.selectedItems.count > 0 then
    (
      local LOCexe = "rcmenu LOCmsgMenu\n"
      LOCexe += "(\n"
      LOCexe += "  local LOCmultiSelect = false\n"
      LOCexe += "\n"
      LOCexe += "  subMenu \"" + DYNuiResourcesSubMenus[11] + "\"\n"
      LOCexe += "  (\n"
      LOCexe += "    subMenu \"" + DYNuiResourcesSubMenus[12] + "\"\n"
      LOCexe += "    (\n"
      LOCexe += "      menuItem  MNDYNanimAdd1 checked:false\n"
      LOCexe += "    )\n"
      LOCexe += "\n"
      LOCexe += "    separator MNDYNseparate9\n"
      LOCexe += "\n"
      LOCexe += "    subMenu \"" + DYNuiResourcesSubMenus[13] + "\"\n"
      LOCexe += "    (\n"
      LOCexe += "      menuItem  MNDYNanimRev0 checked:false\n"
      LOCexe += "      separator MNDYNseparate6\n"
      LOCexe += "      menuItem  MNDYNanimRev1 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimRev2 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimRev3 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimRev4 checked:false\n"
      LOCexe += "    )\n"
      LOCexe += "\n"
      LOCexe += "    subMenu \"" + DYNuiResourcesSubMenus[15] + "\"\n"
      LOCexe += "    (\n"
      LOCexe += "      menuItem  MNDYNanimScl0 checked:false\n"
      LOCexe += "      separator MNDYNseparate7\n"
      LOCexe += "      menuItem  MNDYNanimScl1 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimScl2 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimScl3 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimScl4 checked:false\n"
      LOCexe += "    )\n"
      LOCexe += "\n"
      LOCexe += "    separator MNDYNseparate4\n"
      LOCexe += "\n"
      LOCexe += "    subMenu \"" + DYNuiResourcesSubMenus[14] + "\"\n"
      LOCexe += "    (\n"
      LOCexe += "      menuItem  MNDYNanimRem0 checked:false\n"
      LOCexe += "      separator MNDYNseparate8\n"
      LOCexe += "      menuItem  MNDYNanimRem1 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimRem2 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimRem3 checked:false\n"
      LOCexe += "      menuItem  MNDYNanimRem4 checked:false\n"
      LOCexe += "    )\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  separator MNDYNseparate3\n"
      LOCexe += "  menuItem  MNDYNremove     checked:false\n"
      LOCexe += "  menuItem  MNDYNrename     checked:false\n"
      LOCexe += "  separator MNDYNseparate2\n"
      LOCexe += "\n"
      LOCexe += "  menuItem  MNDYNproperties checked:false\n"
      LOCexe += "\n"
      LOCexe += "  on LOCmsgMenu open do\n"
      LOCexe += "  (\n"
      LOCexe += "    MNDYNanimAdd1.text   = DYNuiResourcesMenus[65]\n"
      LOCexe += "    MNDYNanimRev0.text   = DYNuiResourcesMenus[66]\n"
      LOCexe += "    MNDYNanimRev1.text   = DYNuiResourcesMenus[67]\n"
      LOCexe += "    MNDYNanimRev2.text   = DYNuiResourcesMenus[68]\n"
      LOCexe += "    MNDYNanimRev3.text   = DYNuiResourcesMenus[69]\n"
      LOCexe += "    MNDYNanimRev4.text   = DYNuiResourcesMenus[70]\n"
      LOCexe += "    MNDYNanimScl0.text   = DYNuiResourcesMenus[71]\n"
      LOCexe += "    MNDYNanimScl1.text   = DYNuiResourcesMenus[72]\n"
      LOCexe += "    MNDYNanimScl2.text   = DYNuiResourcesMenus[73]\n"
      LOCexe += "    MNDYNanimScl3.text   = DYNuiResourcesMenus[74]\n"
      LOCexe += "    MNDYNanimScl4.text   = DYNuiResourcesMenus[75]\n"
      LOCexe += "    MNDYNanimRem0.text   = DYNuiResourcesMenus[76]\n"
      LOCexe += "    MNDYNanimRem1.text   = DYNuiResourcesMenus[77]\n"
      LOCexe += "    MNDYNanimRem2.text   = DYNuiResourcesMenus[78]\n"
      LOCexe += "    MNDYNanimRem3.text   = DYNuiResourcesMenus[79]\n"
      LOCexe += "    MNDYNanimRem4.text   = DYNuiResourcesMenus[80]\n"
      LOCexe += "    MNDYNremove.text     = DYNuiResourcesMenus[10]\n"
      LOCexe += "    MNDYNrename.text     = DYNuiResourcesMenus[7]\n"
      LOCexe += "    MNDYNproperties.text = DYNuiResourcesMenus[8]\n"
      LOCexe += "\n"
      LOCexe += "    LOCmultiSelect       = if selection.count > 1 then true else false\n"
      LOCexe += "    MNDYNrename.enabled  = not LOCmultiSelect\n"
      LOCexe += "  )\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNremove     picked do (DYNplacedMan.DYNFUNdeleteSelected())\n"
      LOCexe += "  on MNDYNrename     picked do (DYNplacedMan.dnlv.selectedItems.item[0].beginEdit())\n"
      LOCexe += "  on MNDYNproperties picked do (max properties)\n"
      LOCexe += "\n"
      LOCexe += "  on MNDYNanimRev0    picked do (DYNplacedMan.DYNFUNquickAnimTools 1 0)\n"
      LOCexe += "  on MNDYNanimRev1    picked do (DYNplacedMan.DYNFUNquickAnimTools 1 1)\n"
      LOCexe += "  on MNDYNanimRev2    picked do (DYNplacedMan.DYNFUNquickAnimTools 1 2)\n"
      LOCexe += "  on MNDYNanimRev3    picked do (DYNplacedMan.DYNFUNquickAnimTools 1 3)\n"
      LOCexe += "  on MNDYNanimRev4    picked do (DYNplacedMan.DYNFUNquickAnimTools 1 4)\n"
      LOCexe += "  on MNDYNanimScl0    picked do (DYNplacedMan.DYNFUNquickAnimTools 2 0)\n"
      LOCexe += "  on MNDYNanimScl1    picked do (DYNplacedMan.DYNFUNquickAnimTools 2 1)\n"
      LOCexe += "  on MNDYNanimScl2    picked do (DYNplacedMan.DYNFUNquickAnimTools 2 2)\n"
      LOCexe += "  on MNDYNanimScl3    picked do (DYNplacedMan.DYNFUNquickAnimTools 2 3)\n"
      LOCexe += "  on MNDYNanimScl4    picked do (DYNplacedMan.DYNFUNquickAnimTools 2 4)\n"
      LOCexe += "  on MNDYNanimRem0    picked do (DYNplacedMan.DYNFUNquickAnimTools 3 0)\n"
      LOCexe += "  on MNDYNanimRem1    picked do (DYNplacedMan.DYNFUNquickAnimTools 3 1)\n"
      LOCexe += "  on MNDYNanimRem2    picked do (DYNplacedMan.DYNFUNquickAnimTools 3 2)\n"
      LOCexe += "  on MNDYNanimRem3    picked do (DYNplacedMan.DYNFUNquickAnimTools 3 3)\n"
      LOCexe += "  on MNDYNanimRem4    picked do (DYNplacedMan.DYNFUNquickAnimTools 3 4)\n"
      LOCexe += "  on MNDYNanimAdd1    picked do (DYNplacedMan.DYNFUNquickAnimTools 4 1)\n"
      LOCexe += ")\n"

      DYNplacedMan.LOCmsgMenu = Execute LOCexe

      registerRightClickMenu DYNplacedMan.LOCmsgMenu
    )
  )

  fn DYNFUNselectInVPandUpdateStatusBar =
  (
    callbacks.removescripts id:#DYNplacedMan

    local LOCselArray = #()
    if DYNplacedMan.dnLv.SelectedItems.count > 10 then
    (
      for i = 1 to DYNplacedMan.dnLv.Items.count do
      (
        DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.Items.count * 100.0
        local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
        if LOCitem.selected then
        (
          local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
          if isValidNode LOCcurObj then append LOCselArray LOCcurObj
        )
      )
    )
    else
    (
      for i = 1 to DYNplacedMan.dnLv.SelectedItems.count do
      (
        DYNplacedMan.dnProgress.value = (i as float) / DYNplacedMan.dnLv.SelectedItems.count * 100.0
        local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
        local LOCcurObj = maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)
        if isValidNode LOCcurObj then append LOCselArray LOCcurObj
      )
    )

    local LOCPlacedObjectsCnt = DYNobjHandles[1].count + DYNobjHandles[2].count + DYNobjHandles[3].count + DYNobjHandles[4].count + DYNobjHandles[5].count + DYNobjHandles[6].count
    DYNplacedMan.dnStatus.panels.item[0].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[9]  LOCselArray.count
    DYNplacedMan.dnStatus.panels.item[1].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[34] LOCPlacedObjectsCnt
    DYNplacedMan.dnStatus.panels.item[2].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[35] DYNplacedMan.dnLv.Items.count

    if LOCselArray.count > 0 then (select LOCselArray) else (clearSelection())

    callbacks.addscript #selectedNodesPostDelete "DYNplacedMan.DYNFUNregatherPlacedObjects()" id:#DYNplacedMan
    callbacks.addscript #selectionSetChanged     "DYNplacedMan.DYNFUNObjectsSelected()"       id:#DYNplacedMan
    DYNplacedMan.dnProgress.value = 0
  )


  fn DYNFUNregatherPlacedObjects =
  (
    if DYNplacedMan.open then
    (
      DYNplacedMan.dnLv.Items.clear()
      DYNplacedMan.dnLv.refresh()
      DYNplacedMan.dnStatus.refresh()

      DYNplacedMan.LOCfilterArray1    = #()
      DYNplacedMan.LOCfilterArray2    = #()
      DYNplacedMan.LOCfilterArray3    = #()

      local LOClistItemRange = #()
      DYNplacedMan.dnLv.suspendLayout()
      DYNplacedMan.dnLv.beginUpdate()

      local LOCtotalObjects    = 0; for i = 1 to 6 do LOCtotalObjects += (DynLXGetNodesByAppData #(422, (i as string)) "nodes").count
      local LOCcnt             = 0

      for x = 1 to 6 do
      (
        local LOCnodes = DynLXGetNodesByAppData #(422, (x as string)) "nodes"
        for LOCobject in LOCnodes do
        (
          LOCcnt += 1
          DYNplacedMan.dnProgress.value = (LOCcnt as float) / LOCtotalObjects * 100.0

          if isValidNode LOCobject then
          (
            --- Get Date That Object Was Created
            local LOCobjAppData   = DYNFUNgetObjAppData LOCobject "-"
            local LOCobjCreated   = DYNFUNconvertGUPdate LOCobjAppData[5]
            if (findString LOCobjCreated "undefined") != undefined then LOCobjCreated = "-" -- if created date is invalid

            --- Get Reference To Position Controller
            local LOCcontroller = try (LOCobject.transform.controller) catch ()

            --- If Controller Is Valid, Proceed From Here....
            if classOf LOCcontroller == DynXFCC or classOf LOCcontroller == DynXFCCM3 or classOf LOCcontroller == DynXFCCV3 then
            (
              --- Get Reference To Parent Node Names
              local LOCparentPathName    = if isValidNode LOCcontroller.path    then (LOCcontroller.path.name) else DYNuiResourcesLabels[120]
              local LOCparentSurfaceName = if isValidNode LOCcontroller.surface then (LOCcontroller.surface.name) else DYNuiResourcesLabels[120]

              --- Apply Filter To Available Objects
              local LOCfilterString = ""
              if DYNplacedMan.DDDYNfilter.selection == 1 then LOCfilterString = LOCobject.name                    -- Scene Object Name
              if DYNplacedMan.DDDYNfilter.selection == 2 then LOCfilterString = DYNuiResourcesObjClasses[x]       -- Object Category
              if DYNplacedMan.DDDYNfilter.selection == 3 then LOCfilterString = LOCparentPathName                 -- Parent Shape
              if DYNplacedMan.DDDYNfilter.selection == 4 then LOCfilterString = LOCparentSurfaceName              -- Parent Surface
              local LOCfilterProceed = if DYNplacedMan.LOCfilterSwitch then (matchPattern LOCfilterString pattern:DYNplacedMan.EDDYNfilter.text ignoreCase:true) else true

              if findItem DYNplacedMan.LOCfilterArray1 LOCobject.name       == 0 then append DYNplacedMan.LOCfilterArray1 LOCobject.name
              if findItem DYNplacedMan.LOCfilterArray2 LOCparentPathName    == 0 then append DYNplacedMan.LOCfilterArray2 LOCparentPathName
              if findItem DYNplacedMan.LOCfilterArray3 LOCparentSurfaceName == 0 then append DYNplacedMan.LOCfilterArray3 LOCparentSurfaceName

              --- Only Display Objects Which Match Filter String Created Above

              if isValidNode LOCobject and LOCfilterProceed then
              (
                ---- DOT NET VERSION -----------------------------------------------------------------------
                local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" LOCobject.name
                LOClistItem.imageIndex = if superClassOf LOCobject == light then 25 else x
                LOClistItem.name       = LOCobject.inode.handle as string
                LOClistItem.tag        = "@|" + (LOCobject.inode.handle as string)
                LOClistItem.UseItemStyleForSubItems = false
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add ""
                LOClistItem.SubItems.add LOCobjCreated

                --- Set Values For DN ListSubItems -----------------------------------------------------
                DYNplacedMan.DYNFUNplacedManListSubItemUpdate LOCobject.inode.handle LOCcontroller LOClistItem

                append LOClistItemRange LOClistItem
              )
            )
          )
        )
      )

      DYNplacedMan.dnLv.Items.AddRange LOClistItemRange
      DYNplacedMan.dnLv.endUpdate()
      DYNplacedMan.dnLv.resumeLayout()

      sort DYNplacedMan.LOCfilterArray1
      sort DYNplacedMan.LOCfilterArray2
      sort DYNplacedMan.LOCfilterArray3

      --- Kill Please Wait Message
      DYNplacedMan.dnProgress.value = 0

      --- Select Viewport Objects in ListView (Status Bar (DYNplacedMan.dnStatus) updated within this function)
      DYNplacedMan.DYNFUNobjectsSelected()
      DYNplacedMan.BUDYNspacing.enabled = DYNplacedMan.DYNFUNsetChainageIntervalButtonStatus()

      setFocus DYNplacedMan.dnLv
    )
  )

  fn DYNFUNsetChainageIntervalButtonStatus =
  (
    local LOCenabledStatus    = true
    local LOCbaseParentName = ""
    local LOCcnt = 0

    for i = 1 to DYNplacedMan.dnLv.SelectedItems.count do
    (
      local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
      LOCcnt += 1
      local LOCthisParentName = LOCitem.SubItems.item[1].text
      if LOCbaseParentName == "" then
      (
        LOCbaseParentName = LOCthisParentName
      )
      else
      (
        if LOCthisParentName != LOCbaseParentName then
        (
          LOCenabledStatus = false
        )
      )
    )

    if LOCcnt < 3 then LOCenabledStatus = false

    LOCenabledStatus
  )

  fn DYNFUNselectAll =
  (
    setFocus DYNplacedMan.dnLv
    DYNplacedMan.dnLv.beginUpdate()

    for i = 1 to DYNplacedMan.dnLv.Items.count do
    (
      local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
      LOCitem.selected = true
    )

    DYNplacedMan.dnLv.endUpdate()
  )

  fn DYNFUNselectNone =
  (
    setFocus DYNplacedMan.dnLv
    DYNplacedMan.dnLv.beginUpdate()
    for i = 1 to DYNplacedMan.dnLv.Items.count do
    (
      local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
      LOCitem.selected = false
    )
    DYNplacedMan.dnLv.endUpdate()
  )

  fn DYNFUNselectInvert =
  (
    setFocus DYNplacedMan.dnLv
    DYNplacedMan.dnLv.beginUpdate()
    for i = 1 to DYNplacedMan.dnLv.Items.count do
    (
      local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
      LOCitem.selected = not LOCitem.selected
    )
    DYNplacedMan.dnLv.endUpdate()
  )

  --- Callback related functions
  fn DYNFUNobjectsSelected =
  (
    DYNplacedMan.dnLv.suspendLayout()
    DYNplacedMan.dnLv.beginUpdate()

    local LOCobjects    = getCurrentSelection()
    local LOCplaObjects = #()
    local LOCcnt        = 0
    DYNplacedMan.dnLv.SelectedItems.clear()

    for i in LOCobjects do
    (
      LOCcnt += 1
      DYNplacedMan.dnProgress.value = (LOCcnt as float) / LOCobjects.count * 100.0

      local LOClistItems = DYNplacedMan.dnLv.items.find (i.inode.handle as string) false
      if LOClistItems.count >= 1 then LOClistItems[1].selected = true

      append LOCplaObjects i
    )

    if DYNplacedMan.dnLv.selectedItems.count > 0 then DYNplacedMan.dnLv.selectedItems.item[0].ensureVisible()

    DYNplacedMan.dnLv.endUpdate()
    DYNplacedMan.dnLv.resumeLayout()

    /*

    */

    local LOCPlacedObjectsCnt = DYNobjHandles[1].count + DYNobjHandles[2].count + DYNobjHandles[3].count + DYNobjHandles[4].count + DYNobjHandles[5].count + DYNobjHandles[6].count
    DYNplacedMan.dnStatus.panels.item[0].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[9]  LOCplaObjects.count
    DYNplacedMan.dnStatus.panels.item[1].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[34] LOCPlacedObjectsCnt
    DYNplacedMan.dnStatus.panels.item[2].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[35] DYNplacedMan.dnLv.Items.count

    DYNplacedMan.dnProgress.value = 0
  )

  --- This function is called from DYNpositionControl when a value is changed in that panel, to ensure that THIS panel remains up to date
  fn DYNFUNplacedManListSubItemUpdate FUNobjHandle FUNcontroller FUNdnListItem =
  (
    if DYNplacedMan.open then
    (
      local LOClistItem = if FUNdnListItem != undefined then FUNdnListItem else (DYNFUNfindListViewItemByTag DYNplacedMan.dnLv ("@|" + (FUNobjHandle as string)))

      if LOClistItem != undefined then
      (
        local LOCparentPathName    = if isValidNode FUNcontroller.path    then (FUNcontroller.path.name) else DYNuiResourcesLabels[120]
        local LOCparentSurfaceName = if isValidNode FUNcontroller.surface then (FUNcontroller.surface.name) else DYNuiResourcesLabels[120]

        local LOCsubItem1, LOCsubItem2, LOCsubItem3, LOCsubItem4, LOCsubItem5
        local LOCsubItem6, LOCsubItem7, LOCsubItem8, LOCsubItem9, LOCsubItem10, LOCsubItem11

        LOCsubItem1          = LOClistItem.SubItems.item[1]
        LOCsubItem2          = LOClistItem.SubItems.item[2]
        LOCsubItem3          = LOClistItem.SubItems.item[3]
        LOCsubItem4          = LOClistItem.SubItems.item[4]
        LOCsubItem5          = LOClistItem.SubItems.item[5]
        LOCsubItem6          = LOClistItem.SubItems.item[6]
        LOCsubItem7          = LOClistItem.SubItems.item[7]
        LOCsubItem8          = LOClistItem.SubItems.item[8]
        LOCsubItem9          = LOClistItem.SubItems.item[9]
        LOCsubItem10         = LOClistItem.SubItems.item[10]
        LOCsubItem11         = LOClistItem.SubItems.item[11]

        --- Display Parent Node Names (will be grey if undefined)
        LOCsubItem1.text     = LOCparentPathName -- Parent String

        LOCsubItem2.text = if (superClassOf FUNobj) != camera then LOCparentSurfaceName else "-" -- Camera Objects are not allowed to have parent surfaces

        --- Second Line here will display in Bold Red If These Parameters Are Animated!
        --- Percent (will display in Bold Red if this parameter is animated!)
        if isValidNode FUNcontroller.path then
        (
          LOCsubItem3.text     = (DYNplacedMan.DYNFUNcalcActualChainage (if isController FUNcontroller.percent.controller then FUNcontroller.percent.controller.value else FUNcontroller.percent) (curveLength FUNcontroller.path FUNcontroller.spline)) as string
        )
        else
        (
          LOCsubItem3.text     = "-" -- Chainage (but no parent shape exists, so don't display)
        )
        if (try (FUNcontroller.percent.keys.count)  catch (0))  != 0 then (LOCsubItem3.forecolor = DYNFUNdnColor (color 255 0 0))

        --- Horizontal Offset (will display in Bold Red if this parameter is animated!)
        LOCsubItem4.text     = FUNcontroller.hOffset as string   -- Horizontal Offset
        if (try (FUNcontroller.hOffset.keys.count)  catch (0))  != 0 then (LOCsubItem4.forecolor = DYNFUNdnColor (color 255 0 0))

        --- Vertical Offset (will display in Bold Red if this parameter is animated!)
        LOCsubItem5.text     = FUNcontroller.vOffset as string   -- Vertical Offset
        if (try (FUNcontroller.vOffset.keys.count)  catch (0))  != 0 then (LOCsubItem5.forecolor = DYNFUNdnColor (color 255 0 0))

        --- Rotation (will display in Bold Red if this parameter is animated!)
        LOCsubItem6.text     = FUNcontroller.rotation as string  -- Rotation
        if (try (FUNcontroller.rotation.keys.count) catch (0))  != 0 then (LOCsubItem6.forecolor = DYNFUNdnColor (color 255 0 0))

        --- Boolean Series Properties
        LOCsubItem7.text     = if FUNcontroller.aux1_bool     then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31] -- Chainage Looping
        LOCsubItem8.text     = if FUNcontroller.followPath    then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31] -- Shape Direction Tracking
        LOCsubItem9.text     = if FUNcontroller.aux2_bool     then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31] -- Shape Longfall Tracking

        --- Surface Normal Tracking
        LOCsubItem10.text = if (superClassOf FUNobj) != camera then (if FUNcontroller.followSurface then DYNuiResourcesLabels[22] else DYNuiResourcesButtons[31]) else "-" -- Camera objects cannot use this parameter

        --- Spline Index
        LOCsubItem11.text = FUNcontroller.spline as string
        if (try (FUNcontroller.spline.keys.count)  catch (0))  != 0 then (LOCsubItem11.forecolor = DYNFUNdnColor (color 255 0 0))
      )
    )
  )

  --- Create Rollout Controls -------------------------------------------------------------------------------------------
  label LBDYNfilter          pos:[5,6] width:80
  dropdownlist DDDYNfilter   pos:[90,3] width:160
  button BUDYNfilter1 "..."  pos:[252,3] height:20 width:20
  edittext EDDYNfilter       pos:[271,5] width:160
  button BUDYNfilter2        pos:[434,3] height:20 width:80
  button BUDYNfilter3        pos:[516,3] height:20 width:80

  groupbox GBDYNeditParams   pos:[5,30]   height:460 width:190
  pickbutton PKDYNparentPath pos:[13,50]  height:22 width:157 filter:DYNFUNshapeFilter
  button BUDYNpathSpline     pos:[172,50] height:22 width:15
  pickbutton PKDYNparentSurf pos:[13,75]  height:22 width:157 filter:DYNFUNgeometryFilter
  button BUDYNnoSurf         pos:[172,75] height:22 width:15

  pickbutton PKDYNcloneTo    pos:[13,110] height:22 width:174 filter:DYNFUNshapeFilter

  button BUDYNhorizOffset    pos:[13,145] height:22 width:157
  button BUDYNrandomHoff     pos:[172,145] height:22 width:15
  button BUDYNvertOffset     pos:[13,170] height:22 width:157
  button BUDYNrandomVoff     pos:[172,170] height:22 width:15
  button BUDYNrotation       pos:[13,195] height:22 width:157
  button BUDYNrandomRot      pos:[172,195] height:22 width:15

  button BUDYNspacing        pos:[13,230] height:22 width:174
  button BUDYNoffChain       pos:[13,255] height:22 width:174
  button BUDYNchainageLoop   pos:[13,280] height:22 width:174

  button BUDYNpathDir        pos:[13,315] height:22 width:174
  button BUDYNpathFall       pos:[13,340] height:22 width:174
  button BUDYNsurfNorms      pos:[13,365] height:22 width:174

  button BUDYNboundBox       pos:[13,390] height:22 width:174

  button BUDYNbakeXYZ        pos:[13,425] height:22 width:174

  dotNetControl  dnLv       "System.Windows.Forms.ListView"    height:1000 width:1060 pos:[200,25]
  dotNetControl  dnProgress "System.Windows.Forms.ProgressBar" height:14 width:1000 pos:[0,(DYNdefRLsizePLA.y - 35)]
  dotNetControl  dnStatus   "System.Windows.Forms.StatusBar"   height:20 width:1000 pos:[0,(DYNdefRLsizePLA.y - 19)]

  on DYNplacedMan open do
  (
    DYNFUNresizePlacedMan DYNdefRLsizePLA

    --- Panel Text
    DYNplacedMan.title      = DYNuiRolloutNames[42]

    GBDYNeditParams.text    = DYNuiResourcesGroups[113]

    BUDYNnoSurf.text        = DYNuiResourcesButtons[22]
    BUDYNrandomHoff.text    = DYNuiResourcesButtons[36]
    BUDYNrandomVoff.text    = DYNuiResourcesButtons[36]
    BUDYNrandomRot.text     = DYNuiResourcesButtons[36]
    BUDYNfilter2.text       = DYNuiResourcesButtons[18]
    BUDYNfilter3.text       = DYNuiResourcesButtons[19]
    PKDYNparentPath.text    = DYNuiResourcesButtons[82]
    PKDYNparentSurf.text    = DYNuiResourcesButtons[83]
    BUDYNpathSpline.text    = DYNuiResourcesButtons[84]
    BUDYNhorizOffset.text   = DYNuiResourcesButtons[85]
    BUDYNvertOffset.text    = DYNuiResourcesButtons[86]
    BUDYNrotation.text      = DYNuiResourcesButtons[87]
    BUDYNspacing.text       = DYNuiResourcesButtons[88]
    BUDYNchainageLoop.text  = DYNuiResourcesButtons[89]
    BUDYNpathDir.text       = DYNuiResourcesButtons[90]
    BUDYNpathFall.text      = DYNuiResourcesButtons[91]
    BUDYNsurfNorms.text     = DYNuiResourcesButtons[92]
    BUDYNoffChain.text      = DYNuiResourcesButtons[93]
    BUDYNboundBox.text      = DYNuiResourcesButtons[94]
    BUDYNbakeXYZ.text       = DYNuiResourcesButtons[95]
    PKDYNcloneTo.text       = DYNuiResourcesButtons[96]

    LBDYNfilter.text        = DYNuiResourcesLabels[397]
    EDDYNfilter.text        = "*"
    DDDYNfilter.items       = #(DYNuiResourcesLabels[396], DYNuiResourcesLabels[391], DYNuiResourcesLabels[388], DYNuiResourcesLabels[389])

    --- dotNet ListView Init
    DYNFUNdnListViewStyle dnLv false true
    dnLv.multiSelect        = true
    dnLv.AllowColumnReorder = true
    dnLv.sorting            = DYNdnSortOrderClass.none
    dnLv.smallImageList     = DYNdnSmImageList
    dnlv.labelEdit          = true
    local LOCcol01 = dnLv.Columns.add DYNuiResourcesLvColumns[74]  195; LOCcol01.textAlign = DYNdnHorAlignClass.left
    local LOCcol02 = dnLv.Columns.add DYNuiResourcesLvColumns[75]  140; LOCcol02.textAlign = DYNdnHorAlignClass.center
    local LOCcol03 = dnLv.Columns.add DYNuiResourcesLvColumns[76]  140; LOCcol03.textAlign = DYNdnHorAlignClass.center
    local LOCcol04 = dnLv.Columns.add DYNuiResourcesLvColumns[50]   80; LOCcol04.textAlign = DYNdnHorAlignClass.center
    local LOCcol05 = dnLv.Columns.add DYNuiResourcesLvColumns[4]   100; LOCcol05.textAlign = DYNdnHorAlignClass.center
    local LOCcol06 = dnLv.Columns.add DYNuiResourcesLvColumns[5]    90; LOCcol06.textAlign = DYNdnHorAlignClass.center
    local LOCcol07 = dnLv.Columns.add DYNuiResourcesLvColumns[3]    60; LOCcol07.textAlign = DYNdnHorAlignClass.center
    local LOCcol08 = dnLv.Columns.add DYNuiResourcesLvColumns[77]   90; LOCcol08.textAlign = DYNdnHorAlignClass.center
    local LOCcol09 = dnLv.Columns.add DYNuiResourcesLvColumns[78]   90; LOCcol09.textAlign = DYNdnHorAlignClass.center
    local LOCcol10 = dnLv.Columns.add DYNuiResourcesLvColumns[79]   90; LOCcol10.textAlign = DYNdnHorAlignClass.center
    local LOCcol11 = dnLv.Columns.add DYNuiResourcesLvColumns[80]   90; LOCcol11.textAlign = DYNdnHorAlignClass.center
    local LOCcol12 = dnLv.Columns.add DYNuiResourcesLvColumns[81]   60; LOCcol12.textAlign = DYNdnHorAlignClass.center
    local LOCcol13 = dnLv.Columns.add DYNuiResourcesLvColumns[82]  120; LOCcol13.textAlign = DYNdnHorAlignClass.center

    --- Set Up DN Status Bar
    dnStatus.showPanels    = true
    dnStatus.SizingGrip    = true
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.item[0].width = 200
    dnStatus.panels.item[1].width = 200
    dnStatus.panels.item[2].width = 200
    dnStatus.panels.item[3].width = 100
    dnStatus.panels.item[4].width = 100
    dnStatus.panels.item[5].width = 60
    dnStatus.panels.item[0].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[1].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[2].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[3].alignment = DYNdnHorAlignClass.Left
    dnStatus.panels.item[4].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[5].alignment = DYNdnHorAlignClass.Center
    dnStatus.panels.item[3].autosize = (dotNetClass "System.Windows.Forms.StatusBarPanelAutoSize").spring

    --- Resize Panel Components

    --- Gather Imported Objects
    gc()
    DYNplacedMan.DYNFUNregatherPlacedObjects()

    --- Add DYNplacedMan specific callbacks
    callbacks.removescripts id:#DYNplacedMan
    callbacks.addscript #selectedNodesPostDelete "DYNplacedMan.DYNFUNregatherPlacedObjects()" id:#DYNplacedMan
    callbacks.addscript #selectionSetChanged     "DYNplacedMan.DYNFUNObjectsSelected()"       id:#DYNplacedMan
  )

  on DYNplacedMan close do
  (
    callbacks.removescripts id:#DYNplacedMan
    DYNFUNonDialogClose()
  )

  on DYNplacedMan resized argPt2 do
  (
    DYNFUNresizePlacedMan argPt2
  )

  on DYNplacedMan moved argPt2 do
  (
    DYNplaLUP = argPt2
  )

  on dnLv AfterLabelEdit arg do
  (
    if arg.label != undefined and arg.label != "" then
    (
      local LOCcurObj = maxOps.GetNodeByHandle ((filterString dnLv.items.item[arg.item].tag "|")[2] as integer)
      LOCcurObj.name  = arg.label
    )
  )

  on PKDYNparentPath    picked arg do  DYNFUNeditSelectedObs arg 1
  on PKDYNparentSurf    picked arg do (DYNFUNeditSelectedObs arg 2; APCFUNupdateAllPlacedObjectControllers())
  on BUDYNnoSurf        pressed    do  DYNFUNeditSelectedObs undefined 2
  on BUDYNhorizOffset   pressed    do  DYNFUNeditSelectedObs undefined 3
  on BUDYNvertOffset    pressed    do  DYNFUNeditSelectedObs undefined 4
  on BUDYNrotation      pressed    do  DYNFUNeditSelectedObs undefined 5
  on BUDYNspacing       pressed    do  DYNFUNeditSelectedObs undefined 6
  on BUDYNchainageLoop  pressed    do  DYNFUNeditSelectedObs undefined 7
  on BUDYNpathDir       pressed    do  DYNFUNeditSelectedObs undefined 8
  on BUDYNpathFall      pressed    do  DYNFUNeditSelectedObs undefined 9
  on BUDYNsurfNorms     pressed    do  DYNFUNeditSelectedObs undefined 10
  on BUDYNoffChain      pressed    do  DYNFUNeditSelectedObs undefined 11
  on BUDYNboundBox      pressed    do  DYNFUNeditSelectedObs undefined 12
  on BUDYNrandomRot     pressed    do  DYNFUNeditSelectedObs undefined 14
  on BUDYNrandomHoff    pressed    do  DYNFUNeditSelectedObs undefined 15
  on BUDYNrandomVoff    pressed    do  DYNFUNeditSelectedObs undefined 16
  on BUDYNpathSpline    pressed    do  DYNFUNeditSelectedObs undefined 17
  on PKDYNcloneTo       picked arg do (DYNFUNcloneSelectedObs arg)

  on BUDYNbakeXYZ       pressed    do
  (
    if DYNplacedMan.dnLv.selectedItems.count > 0 then
    (
      local LOCareYouSure = DYNuiResourcesQueries[27]
      LOCareYouSure += "\n\n"
      LOCareYouSure += DYNuiResourcesErrorsWarnings[60]
      LOCareYouSure += "\n\n"
      LOCareYouSure += DYNuiResourcesQueries[33]

      if (queryBox LOCareYouSure title:DYNuiResourcesTitlebars[2]) then
      (
        local LOCobjArray = #()
        if DYNplacedMan.dnLv.SelectedItems.count > 10 then
        (
          for i = 1 to DYNplacedMan.dnLv.Items.count do
          (
            local LOCitem    = DYNplacedMan.dnLv.Items.item[i-1]
            if LOCitem.selected then (append LOCobjArray (maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer)))
          )
        )
        else
        (
          for i = 1 to DYNplacedMan.dnLv.SelectedItems.count do
          (
            local LOCitem    = DYNplacedMan.dnLv.SelectedItems.item[i-1]
            append LOCobjArray (maxOps.GetNodeByHandle ((filterString LOCitem.tag "|")[2] as integer))
          )
        )

        DYNamite.DYNFUNbakeArrayXFCCtoPRS LOCobjArray
      )
    )
  )

  on BUDYNfilter1 pressed do
  (
    local LOCselection = 1
    local LOCarray     = #()

    --- Filter By Object Name
    if DDDYNfilter.selection == 1 then
    (
      LOCarray = #(DYNuiResourcesLabels[392])
      for i in LOCfilterArray1 do (append LOCarray i)
      LOCselection = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[32] DYNuiResourcesLabels[390] LOCarray LOCselection
    )

    --- Filter By Object Category
    if DDDYNfilter.selection == 2 then
    (
      LOCarray = #(DYNuiResourcesLabels[393])
      for i = 1 to 6 do append LOCarray DYNuiResourcesObjClasses[i]
      LOCselection = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[32] DYNuiResourcesLabels[391] LOCarray LOCselection
    )

    --- Filter By Parent Shape
    if DDDYNfilter.selection == 3 then
    (
      LOCarray = #(DYNuiResourcesLabels[394])
      for i in LOCfilterArray2 do (if i != "" then (append LOCarray i))
      LOCselection = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[32] DYNuiResourcesLabels[388] LOCarray LOCselection
    )

    --- Filter By Parent Surface
    if DDDYNfilter.selection == 4 then
    (
      LOCarray = #(DYNuiResourcesLabels[395])
      for i in LOCfilterArray3 do (if i != "" then (append LOCarray i))
      LOCselection = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[32] DYNuiResourcesLabels[389] LOCarray LOCselection
    )

    if LOCselection != 1 then
    (
      EDDYNfilter.text = LOCarray[LOCselection]
    )
  )

  on BUDYNfilter2 pressed do
  (
    LOCfilterSwitch = true
    DYNplacedMan.DYNFUNregatherPlacedObjects()
  )

  on DDDYNfilter selected arg do
  (
  )

  on EDDYNfilter changed arg do
  (
  )

  on BUDYNfilter3 pressed do
  (
    LOCfilterSwitch = false
    DYNplacedMan.DYNFUNregatherPlacedObjects()
  )

  on dnLv ColumnClick arg do
  (
    /* arg.column (to get to index of selected column) */
    if dnLv.sorting == DYNdnSortOrderClass.none       then
    (
      dnLv.sorting = DYNdnSortOrderClass.ascending
    )
    else
    (
      if dnLv.sorting == DYNdnSortOrderClass.ascending  then
      (
        dnLv.sorting = DYNdnSortOrderClass.descending
      )
      else
      (
        if dnLv.sorting == DYNdnSortOrderClass.descending then dnLv.sorting = DYNdnSortOrderClass.ascending
      )
    )
    if dnLv.selectedItems.count > 0 then dnLv.selectedItems.item[0].ensureVisible()
  )

  on dnLv MouseUp arg do
  (
    if arg.button == DYNdnmouseClass.left then
    (
      BUDYNspacing.enabled = DYNFUNsetChainageIntervalButtonStatus()
      DYNFUNselectInVPandUpdateStatusBar()
    )
    if arg.button == DYNdnmouseClass.right then
    (
      DYNFUNmsgPopupMenu()
      if LOCmsgMenu != undefined then popupMenu LOCmsgMenu
    )
  )
)
--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNproperties ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCobjectSwitch
  local LOCselectionArray = #()
  local LOCenableUpdatePropertiesPanel = true
  local LOCupdSelection = true

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---
  fn DYNFUNdestroyDialog =
  (
    destroyDialog DYNproperties
  )

  --- To get an array of object names from the current object category
  fn DYNFUNgetVSPcatObjNames FUNclass =
  (
    --- Initialise Variables
    local LOCobjNameArray               = (DYNFUNgetCivilViewCategorizedNodeArrays "names" true)[FUNclass]
    DYNproperties.MLDYNobjectList.items = #()
    DYNproperties.LOCselectionArray     = #()

    if FUNclass == 8 then
    (
      DYNproperties.BUDYNremSmooth.enabled = true
      DYNproperties.BUDYNflipNorms.enabled = true
    )
    else
    (
      DYNproperties.BUDYNremSmooth.enabled = false
      DYNproperties.BUDYNflipNorms.enabled = false
    )
    LOCobjNameArray
  )

  --- Function to display Object Parameters for Currently selected Object. If more than one object is selected, most of panel is disabled
  fn DYNFUNupdPropertiesPanel =
  (
    if LOCenableUpdatePropertiesPanel == true then
    (
      if DYNproperties.LOCselectionArray.count == 1 then
      (
        local LOCad3 = (getAppData DYNproperties.LOCselectionArray[1] 423) as string
        local LOCad4 = (getAppData DYNproperties.LOCselectionArray[1] 424) as string
        local LOCad5 = (getAppData DYNproperties.LOCselectionArray[1] 425) as string
        local LOCad6 = (getAppData DYNproperties.LOCselectionArray[1] 426) as string
        local LOCad7 = (getAppData DYNproperties.LOCselectionArray[1] 427) as string
        local LOCad8 = (getAppData DYNproperties.LOCselectionArray[1] 428) as string

        if LOCad3 != undefined then (if (substring LOCad3 1 1) == "-" then LOCad3 = substring LOCad3 2 -1)
        if LOCad4 != undefined then DYNproperties.LBDYNlabel04.text = DYNFUNtrimPathName LOCad4 377
        if LOCad5 != undefined then
        (
          if (findstring LOCad5 "$") != undefined then
          (
            if (findItem DYNimportCatsArray DYNproperties.LOCobjectSwitch) == 0 then
            (
              DYNproperties.LBDYNlabel05.text = DYNuiResourcesLabels[41] + " " + (DYNFUNconvertGUPdate LOCad5)
            )
            else
            (
              DYNproperties.LBDYNlabel05.text = DYNuiResourcesLabels[40] + " " + (DYNFUNconvertGUPdate LOCad5)
            )
          )
          else (DYNproperties.LBDYNlabel05.text = "")
        )
        if (findItem DYNimportCatsArray DYNproperties.LOCobjectSwitch) != 0 then
        (
          if LOCad7 != undefined then DYNproperties.LBDYNlabel07.text = DYNuiResourcesLabels[50] + " " + DYNFUNdisplayAppDataInUI LOCad7
          if LOCad8 != undefined then DYNproperties.LBDYNlabel08.text = DYNuiResourcesLabels[51] + " " + DYNFUNdisplayAppDataInUI LOCad8
        )
        else
        (
          if DYNproperties.LOCobjectSwitch != 9 and DYNproperties.LOCobjectSwitch != 10 and DYNproperties.LOCobjectSwitch != 12 and DYNproperties.LOCobjectSwitch != 13 and DYNproperties.LOCobjectSwitch != 14 then
          (
            if DYNproperties.LOCobjectSwitch >= 1 and DYNproperties.LOCobjectSwitch <= 6 then
            (
              local LOCcontroller = DYNproperties.LOCselectionArray[1].transform.controller
              DYNproperties.LBDYNlabel08.text = DYNuiResourcesLabels[46] + " " + (try (LOCcontroller.path.name) catch (DYNuiResourcesButtons[15]))
              DYNproperties.LBDYNlabel07.text = DYNuiResourcesLabels[47] + " " + (try (LOCcontroller.surface.name) catch (DYNuiResourcesButtons[15]))
            )
            else
            (
              DYNproperties.LBDYNlabel07.text = ""
              DYNproperties.LBDYNlabel08.text = ""
            )
          )
          else
          (
            local LOCparAd7 = try (getAppData DYNproperties.LOCselectionArray[1].parent 427) catch (LOCad7)
            local LOCparAd8 = try (getAppData DYNproperties.LOCselectionArray[1].parent 428) catch (LOCad8)
            if LOCparAd7 != undefined then DYNproperties.LBDYNlabel07.text = DYNuiResourcesLabels[50] + " " + LOCparAd7
            if LOCparAd8 != undefined then DYNproperties.LBDYNlabel08.text = DYNuiResourcesLabels[51] + " " + LOCparAd8
          )
        )
        DYNproperties.EDDYNobjectName.text    = LOCselectionArray[1].name
        DYNproperties.EDDYNobjectName.enabled = true
        DYNproperties.CPDYNobjectColor.color  = LOCselectionArray[1].wirecolor
        DYNproperties.CKDYNhide.checked       = LOCselectionArray[1].isHidden
        DYNproperties.CKDYNfreeze.checked     = LOCselectionArray[1].isFrozen
        DYNproperties.CKDYNshadow.checked     = LOCselectionArray[1].castShadows
        DYNproperties.CKDYNboxMode.checked    = LOCselectionArray[1].boxMode

        DYNproperties.CKDYNhide.enabled       = true
        DYNproperties.CKDYNfreeze.enabled     = true
        DYNproperties.BUDYNdeleteAll.enabled  = true

        if DYNproperties.LOCobjectSwitch == 10 then
        (
          DYNproperties.CKDYNshadow.enabled = false
        )
        else
        (
          DYNproperties.CKDYNshadow.enabled = true
        )

        if DYNproperties.LOCobjectSwitch == 5 then
        (
          DYNproperties.CKDYNboxMode.enabled = false
        )
        else
        (
          DYNproperties.CKDYNboxMode.enabled = true
        )

        DYNproperties.BUDYNupdate.enabled = if (findItem DYNimportCatsArray DYNproperties.LOCobjectSwitch) != 0 then true else false

        if LOCselectionArray[1].material != undefined and superClassOf LOCselectionArray[1] == GeometryClass then
        (
          if (classOf LOCselectionArray[1].material) == Multimaterial then
          (
            DYNFUNupdateDrapingCoords LOCselectionArray[1]
            local LOCmatArray = DYNFUNgetMatChannelNames LOCselectionArray[1].material true true DYNINImatIDlimit
            if LOCobjectSwitch == 1 and LOCmatArray.count >= 9 then LOCmatArray.count = 9
            DYNproperties.DDDYNmatChan.items = LOCmatArray
            DYNproperties.DDDYNmatChan.selection = try (LOCad3 as integer) catch (0)
            DYNproperties.DDDYNmatChan.enabled = try (if LOCselectionArray[1].modifiers.count > 0 then false else true) catch (true) -- Cannot change channel if modifiers are present!
          )
          else
          (
            DYNproperties.DDDYNmatChan.items = #()
            DYNproperties.DDDYNmatChan.enabled = false
          )
        )
        else
        (
          DYNproperties.DDDYNmatChan.items = #()
          DYNproperties.DDDYNmatChan.enabled = false
        )
      )
      else
      (
        DYNproperties.LBDYNlabel04.text = ""
        DYNproperties.LBDYNlabel05.text = ""
        DYNproperties.LBDYNlabel07.text = ""
        DYNproperties.LBDYNlabel08.text = ""
        if DYNproperties.LOCselectionArray.count == 0 then
        (
          DYNproperties.EDDYNobjectName.text   = DYNuiResourcesLabels[48]
          DYNproperties.DDDYNmatChan.enabled   = false
          DYNproperties.CKDYNhide.checked      = false
          DYNproperties.CKDYNfreeze.checked    = false
          DYNproperties.CKDYNshadow.checked    = false
          DYNproperties.CKDYNboxMode.checked   = false

          DYNproperties.CKDYNhide.enabled      = false
          DYNproperties.CKDYNfreeze.enabled    = false
          DYNproperties.DDDYNmatChan.items     = #()
          DYNproperties.BUDYNdeleteAll.enabled = false
          DYNproperties.BUDYNupdate.enabled    = false
        )
        else
        (
          DYNproperties.EDDYNobjectName.text   = DYNuiResourcesLabels[49]
          DYNproperties.CKDYNhide.enabled      = true
          DYNproperties.CKDYNfreeze.enabled    = true
          DYNproperties.BUDYNdeleteAll.enabled = true                    -- Allow deletion of multiple objects
          local HideStatus    = 0
          local FreezeStatus  = 0
          local ShadowStatus  = 0
          local BoxModeStatus = 0
          local MatType
          local MatStatus = ((getAppData DYNproperties.LOCselectionArray[1] 423) as integer)
          local LOCdataSource = (getAppData DYNproperties.LOCselectionArray[1] 424)
          local LOCdataStatus = true

          if DYNproperties.LOCobjectSwitch == 10 then
          (
            DYNproperties.CKDYNshadow.enabled = false
          )
          else
          (
            DYNproperties.CKDYNshadow.enabled = true
          )

          if DYNproperties.LOCobjectSwitch == 5 then
          (
            DYNproperties.CKDYNboxMode.enabled = false
          )
          else
          (
            DYNproperties.CKDYNboxMode.enabled = true
          )

          if (findItem DYNimportCatsArray DYNproperties.LOCobjectSwitch) != 0 then
          (
            DYNproperties.BUDYNupdate.enabled = true
          )
          else
          (
            DYNproperties.BUDYNupdate.enabled = false
          )
          if DYNproperties.LOCselectionArray[1].material != undefined then MatType = DYNproperties.LOCselectionArray[1].material.name
          for i = 1 to DYNproperties.LOCselectionArray.count do
          (
            if DYNproperties.LOCselectionArray[i].isHidden    == false and HideStatus    == 0 then HideStatus    = 1
            if DYNproperties.LOCselectionArray[i].isHidden    == true  and HideStatus    == 0 then HideStatus    = 2
            if DYNproperties.LOCselectionArray[i].isHidden    == false and HideStatus    == 2 then HideStatus    = 3
            if DYNproperties.LOCselectionArray[i].isHidden    == true  and HideStatus    == 1 then HideStatus    = 3

            if DYNproperties.LOCselectionArray[i].isFrozen    == false and FreezeStatus  == 0 then FreezeStatus  = 1
            if DYNproperties.LOCselectionArray[i].isFrozen    == true  and FreezeStatus  == 0 then FreezeStatus  = 2
            if DYNproperties.LOCselectionArray[i].isFrozen    == false and FreezeStatus  == 2 then FreezeStatus  = 3
            if DYNproperties.LOCselectionArray[i].isFrozen    == true  and FreezeStatus  == 1 then FreezeStatus  = 3

            if DYNproperties.LOCselectionArray[i].castShadows == false and ShadowStatus  == 0 then ShadowStatus  = 1
            if DYNproperties.LOCselectionArray[i].castShadows == true  and ShadowStatus  == 0 then ShadowStatus  = 2
            if DYNproperties.LOCselectionArray[i].castShadows == false and ShadowStatus  == 2 then ShadowStatus  = 3
            if DYNproperties.LOCselectionArray[i].castShadows == true  and ShadowStatus  == 1 then ShadowStatus  = 3

            if DYNproperties.LOCselectionArray[i].boxMode     == false and BoxModeStatus == 0 then BoxModeStatus = 1
            if DYNproperties.LOCselectionArray[i].boxMode     == true  and BoxModeStatus == 0 then BoxModeStatus = 2
            if DYNproperties.LOCselectionArray[i].boxMode     == false and BoxModeStatus == 2 then BoxModeStatus = 3
            if DYNproperties.LOCselectionArray[i].boxMode     == true  and BoxModeStatus == 1 then BoxModeStatus = 3

            if MatStatus     != ((getAppData DYNproperties.LOCselectionArray[i] 423) as integer) then MatStatus = 0
            if LOCdataSource !=  (getAppData DYNproperties.LOCselectionArray[i] 424)             then LOCdataStatus = false
            if DYNproperties.LOCselectionArray[i].material != undefined then
            (
              if MatType != DYNproperties.LOCselectionArray[i].material.name then MatStatus = 0
            )
            else MatStatus = 0
          )
          if HideStatus    == 3 or HideStatus    == 1 then DYNproperties.CKDYNhide.checked = false
          if HideStatus    == 2 then DYNproperties.CKDYNhide.checked    = true
          if FreezeStatus  == 3 or FreezeStatus  == 1 then DYNproperties.CKDYNfreeze.checked = false
          if FreezeStatus  == 2 then DYNproperties.CKDYNfreeze.checked  = true
          if ShadowStatus  == 3 or ShadowStatus  == 1 then DYNproperties.CKDYNshadow.checked = false
          if ShadowStatus  == 2 then DYNproperties.CKDYNshadow.checked  = true
          if BoxModeStatus == 3 or BoxModeStatus == 1 then DYNproperties.CKDYNboxMode.checked = false
          if BoxModeStatus == 2 then DYNproperties.CKDYNboxMode.checked = true

          if MatStatus < 0 then MatStatus = MatStatus * -1
          if (classOf LOCselectionArray[1].material) == Multimaterial then
          (
            local LOCmatArray = DYNFUNgetMatChannelNames LOCselectionArray[1].material true true DYNINImatIDlimit
            if LOCobjectSwitch == 1 and LOCmatArray.count >= 9 then LOCmatArray.count = 9
            DYNproperties.DDDYNmatChan.items = LOCmatArray
            DYNproperties.DDDYNmatChan.items = LOCmatArray
            DYNproperties.DDDYNmatChan.selection = MatStatus
            DYNproperties.DDDYNmatChan.enabled = true
          )
          else
          (
            DYNproperties.DDDYNmatChan.items = #()
            DYNproperties.DDDYNmatChan.enabled = false
          )
          if superClassOf DYNproperties.LOCselectionArray[1] != GeometryClass then DYNproperties.DDDYNmatChan.enabled = false
          if LOCdataStatus == true then DYNproperties.LBDYNlabel04.text = DYNFUNtrimPathName LOCdataSource 377 else DYNproperties.LBDYNlabel04.text = DYNuiResourcesLabels[52]
        )
        DYNproperties.EDDYNobjectName.enabled = false
        DYNproperties.CPDYNobjectColor.color = (color 197 197 197)
      )
    )
    if DYNproperties.LOCobjectSwitch == 2  then (DYNproperties.DDDYNmatChan.enabled = false; DYNproperties.DDDYNmatChan.items= #())
    if DYNproperties.LOCobjectSwitch == 3  then (DYNproperties.DDDYNmatChan.enabled = false)
    if DYNproperties.LOCobjectSwitch == 4  then (DYNproperties.DDDYNmatChan.enabled = false)
    if DYNproperties.LOCobjectSwitch == 6  then (DYNproperties.DDDYNmatChan.enabled = false)
    if DYNproperties.LOCobjectSwitch == 7  then (DYNproperties.DDDYNmatChan.enabled = false)
    if DYNproperties.LOCobjectSwitch == 9  then (DYNproperties.DDDYNmatChan.enabled = false)
    if DYNproperties.LOCobjectSwitch == 10 then (DYNproperties.DDDYNmatChan.enabled = false)
    if DYNproperties.LOCobjectSwitch == 11 then (DYNproperties.DDDYNmatChan.enabled = false)
    if DYNproperties.LOCobjectSwitch == 12 then (DYNproperties.DDDYNmatChan.enabled = false; DYNproperties.DDDYNmatChan.items= #())
    if DYNproperties.LOCobjectSwitch == 13 then (DYNproperties.DDDYNmatChan.enabled = false; DYNproperties.DDDYNmatChan.items= #())
    if DYNproperties.LOCobjectSwitch == 14 then (DYNproperties.DDDYNmatChan.enabled = false; DYNproperties.DDDYNmatChan.items= #())
    if DYNproperties.LOCobjectSwitch == 15 then (DYNproperties.DDDYNmatChan.enabled = false; DYNproperties.DDDYNmatChan.items= #())
    if DYNproperties.LOCobjectSwitch == 16 then (DYNproperties.DDDYNmatChan.enabled = false; DYNproperties.DDDYNmatChan.items= #())
  )

  --- Function called every time the selection in the MultiList box is changed - makes screen selection to match list selection
  fn DYNFUNlistSelectionToScreen =
  (
    DYNproperties.LOCselectionArray = #()

    for i in DYNproperties.MLDYNobjectList.selection do
    (
      if DYNproperties.MLDYNobjectList.selection[i] == true then
      (
        append DYNproperties.LOCselectionArray (getNodeByName DYNproperties.MLDYNobjectList.items[i])
      )
    )

    callbacks.removescripts id:#DYNproperties02
    select DYNproperties.LOCselectionArray
    callbacks.addscript #selectionsetchanged     "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties02

    DYNproperties.dnStatus.panels.item[0].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[9] DYNproperties.LOCselectionArray.count
  )

  --- Function called every time screen selection is changed
  fn DYNFUNscreenSelectionToList =
  (
    if DYNproperties.LOCupdSelection and DYNproperties.open then
    (
      DYNproperties.LOCselectionArray = #()

      local LOCselObjectNames  = #()
      local LOCdeSelectObjects = #()
      local LOCobjects = getCurrentSelection()

      --- Check that only Dynamite Objects are currently selected
      for i = LOCobjects.count to 1 by -1 do
      (
        local LOCappData01 = getAppData LOCobjects[i] 421
        if LOCappData01 != "Dynamite" then
        (
          append LOCdeSelectObjects LOCobjects[i]
          deleteItem LOCobjects i
        )
      )

      --- Check that only objects from the current object category are selected
      if LOCobjects.count > 0 then DYNproperties.LOCobjectSwitch = (getAppData LOCobjects[1] 422) as integer
      for i = LOCobjects.count to 1 by -1 do
      (
        if ((getAppData LOCobjects[i] 422) as integer) != DYNproperties.LOCobjectSwitch then
        (
          append LOCdeSelectObjects LOCobjects[i]
          deleteItem LOCobjects i
        )
      )

      --- Deselect inappropriate objects from the current selection
      callbacks.removescripts id:#DYNproperties02
      deselect LOCdeSelectObjects
      callbacks.addscript #selectionsetchanged "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties02

      --- Update List of Objects in Panel Category List
      DYNproperties.DDDYNobjectClass.selection = DYNproperties.LOCobjectSwitch
      DYNproperties.MLDYNobjectList.items      = DYNproperties.DYNFUNgetVSPcatObjNames DYNproperties.LOCobjectSwitch

      --- See which objects from this list are currently selected
      for i = 1 to LOCobjects.count do
      (
        append LOCselObjectNames (findItem DYNproperties.MLDYNobjectList.items LOCobjects[i].name)
        append DYNproperties.LOCselectionArray LOCobjects[i]
      )

      DYNproperties.MLDYNobjectList.selection    = LOCselObjectNames
      DYNproperties.dnStatus.panels.item[0].text = DYNFUNformatValueToString DYNuiResourcesStatusMessages[9] DYNproperties.LOCselectionArray.count

      DYNFUNupdPropertiesPanel()
    )
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  multilistBox MLDYNobjectList pos:[7,9] width:150 height:16
  button BUDYNselectAll pos:[7,226] width:72 height:18
  button BUDYNselectNone pos:[85,226] width:72 height:18

  dropDownList DDDYNobjectClass DYNuiResourcesLabels[45] pos:[168,12] width:175

  groupBox GBDYNgroup01 pos:[167,59] width:340 height:136
  editText EDDYNobjectName pos:[175,78] width:297 enabled:false
  colorPicker CPDYNobjectColor pos:[476,77] width:22 height:18
  label LBDYNlabel08 pos:[175,99] width:290 height:26
  label LBDYNlabel07 pos:[175,127] width:290 height:26
  label LBDYNlabel05 pos:[175,155] width:290 height:18

  checkbox CKDYNhide    pos:[175,172] width:58  height:18
  checkbox CKDYNfreeze  pos:[233,172] width:58  height:18
  checkbox CKDYNshadow  pos:[291,172] width:88 height:18 enabled:false
  checkbox CKDYNboxMode pos:[384,172] width:88 height:18 enabled:false
  button BUDYNremSmooth pos:[476,101] iconName:"CivilView/Smooth" width:28 height:28 tooltip:DYNuiResourcesTooltips[2]
  button BUDYNflipNorms pos:[476,131] iconName:"CivilView/Normal" width:28 height:28 tooltip:DYNuiResourcesTooltips[1]
  button BUDYNdeleteAll pos:[476,161] iconName:"CivilView/Reset" width:28 height:28 tooltip:DYNuiResourcesTooltips[3]

  groupBox GBDYNgroup03 pos:[167,200] width:340 height:44
  dropDownList DDDYNmatChan "" pos:[175,217] width:325 height:18

  button BUDYNokok pos:[422,10] width:85 height:18
  button BUDYNhelp pos:[422,32] width:85 height:18

  groupBox GBDYNgroup02 pos:[7,248] width:500 height:40
  label LBDYNlabel04 pos:[14,266] width:437 height:15
  button BUDYNupdate align:#left pos:[451,260] width:50 height:22

  dotNetControl  dnStatus "System.Windows.Forms.StatusBar" height:20 width:501 pos:[7,290]

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNproperties open do
  (
    DYNproperties.title      = DYNuiRolloutNames[21]

    actionMan.executeAction 0 "300"

    DDDYNobjectClass.caption = DYNuiResourcesLabels[45]
    GBDYNgroup01.text        = DYNuiResourcesGroups[6]
    GBDYNgroup02.text        = DYNuiResourcesGroups[7]
    GBDYNgroup03.text        = DYNuiResourcesGroups[8]
    EDDYNobjectName.text     = DYNuiResourcesLabels[14]
    BUDYNokok.text           = DYNuiResourcesButtons[1]
    BUDYNhelp.text           = DYNuiResourcesButtons[5]
    BUDYNselectAll.text      = DYNuiResourcesButtons[16]
    BUDYNselectNone.text     = DYNuiResourcesButtons[17]
    BUDYNdeleteAll.text      = DYNuiResourcesButtons[35]
    BUDYNupdate.text         = DYNuiResourcesButtons[14]
    CKDYNhide.text           = DYNuiResourcesLabels[44]
    CKDYNfreeze.text         = DYNuiResourcesLabels[43]
    CKDYNshadow.text         = DYNuiResourcesLabels[20]
    CKDYNboxMode.text        = DYNuiResourcesLabels[42]
    local LOCoclMessages     = #() ; for i = 1 to DYNcivilViewCategoryCount do (append LOCoclMessages DYNuiResourcesObjClasses[i])
    DDDYNobjectClass.items   = LOCoclMessages
    LOCenableUpdatePropertiesPanel = true

    --- Set Up Status Bar
    dnStatus.showPanels    = true
    dnStatus.SizingGrip    = false
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.add (dotNetObject "System.Windows.Forms.StatusBarPanel")
    dnStatus.panels.item[0].autosize = (dotNetClass "System.Windows.Forms.StatusBarPanelAutoSize").spring
    dnStatus.panels.item[1].autosize = (dotNetClass "System.Windows.Forms.StatusBarPanelAutoSize").spring

    LOCobjectSwitch        = DYNobjectSwitch
    LOCupdSelection        = true

    DYNFUNscreenSelectionToList()

    ---Add Callback Mechanisms for this Panel
    callbacks.removescripts id:#DYNproperties01
    callbacks.removescripts id:#DYNproperties02

    callbacks.addscript #filepostopen            "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties01
    callbacks.addscript #systempostreset         "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties01
    callbacks.addscript #systempostnew           "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties01
    callbacks.addscript #sceneUndo               "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties01
    callbacks.addscript #sceneRedo               "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties01

    callbacks.addscript #selectedNodesPostDelete "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties01
    callbacks.addscript #SceneNodeAdded          "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties01

    callbacks.addscript #nodeHide                "DYNproperties.DYNFUNupdPropertiesPanel()"    id:#DYNproperties01
    callbacks.addscript #nodeUnHide              "DYNproperties.DYNFUNupdPropertiesPanel()"    id:#DYNproperties01
    callbacks.addscript #nodeFreeze              "DYNproperties.DYNFUNupdPropertiesPanel()"    id:#DYNproperties01
    callbacks.addscript #nodeUnFreeze            "DYNproperties.DYNFUNupdPropertiesPanel()"    id:#DYNproperties01
    callbacks.addscript #selectionsetchanged     "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties02
  )

  on DYNproperties close do
  (
    callbacks.removescripts id:#DYNproperties01
    callbacks.removescripts id:#DYNproperties02
    LOCselectionArray  = #()
    DYNFUNonDialogClose()
  )

  on DYNproperties moved argPt2 do
  (
    DYNprpLUP = argPt2
  )

  on DDDYNobjectClass selected arg do
  (
    LOCobjectSwitch = arg
    MLDYNobjectList.items = DYNFUNgetVSPcatObjNames LOCobjectSwitch
    clearselection()
    DYNFUNupdPropertiesPanel()
  )

  on MLDYNobjectList selectionEnd do
  (
    DYNFUNlistSelectionToScreen()
    DYNFUNupdPropertiesPanel()
    redrawViews()
  )

  on MLDYNobjectList doubleClicked arg do
  (
  )

  on EDDYNobjectName entered arg do
  (
    LOCselectionArray[1].name = EDDYNobjectName.text
  )

  on CPDYNobjectColor changed arg do
  (
    for i = 1 to LOCselectionArray.count do
    (
      LOCselectionArray[i].wirecolor = arg
      invalidateTreeTM LOCselectionArray[i]
    )
    redrawViews()
  )

  on BUDYNselectAll pressed do
  (
    local LOClistItems = #()
    disableSceneRedraw()
    for i = 1 to MLDYNobjectList.items.count do append LOClistItems i
    MLDYNobjectList.selection = LOClistItems
    DYNFUNlistSelectionToScreen()
    DYNFUNupdPropertiesPanel()
    enableSceneRedraw()
    redrawViews()
  )

  on BUDYNselectNone pressed do
  (
    MLDYNobjectList.selection = #{}
    clearselection()
    DYNFUNupdPropertiesPanel()
  )

  on BUDYNdeleteAll pressed do
  (
    if Querybox DYNuiResourcesQueries[1] title:DYNuiResourcesTitlebars[3] then
    (

      --- Initialise this section
      local ObjectsToDelete = #()
      DYNFUNremoveCSProllouts()
      DYNFUNloadVSPnodeCallBacks false
      (
        disableSceneRedraw()

        --- Create a list of objects that are currently selected and thus marked for deletion
        for i = 1 to MLDYNobjectList.selection.count do
        (
          if MLDYNobjectList.selection[i] == true then
          (
            append ObjectsToDelete (getNodeByName DYNproperties.MLDYNobjectList.items[i])
          )
        )

        --- Remove current callback
        callbacks.removescripts id:#DYNproperties02

        --- Delete Selected Objects from Scene and Update Main Object Handle Array
        with undo on
        (
        for i in ObjectsToDelete do
        (
          if isValidNode i then
          (
            if isOpenGroupHead i then setGroupOpen i false -- groups must be closed prior to deletion, otherwise group members are not removed
              for ii in i.children do delete ii
            delete i
          )
          )
        )

        --- Reactivate current callback
        callbacks.addscript #selectionsetchanged     "DYNproperties.DYNFUNscreenSelectionToList()" id:#DYNproperties02

        --- Finish Off Routine
        enableSceneRedraw()
        redrawViews()
      )
      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()

      --- Update Properties Panel for current Selection
      MLDYNobjectList.items = DYNFUNgetVSPcatObjNames LOCobjectSwitch
      clearselection()
      DYNFUNupdPropertiesPanel()
    )
  )

on DDDYNmatChan selected arg do
(
  if LOCobjectSwitch == 1 or LOCobjectSwitch == 8 then
  (
    for i = 1 to LOCselectionArray.count do
    (
      DYNFUNchangeMatIDforSubObj LOCselectionArray[i] ((getAppData LOCselectionArray[i] 423) as integer) arg undefined
    )
  )
  DYNFUNlistSelectionToScreen()
  DYNFUNupdPropertiesPanel()
  redrawViews()
)

  on BUDYNflipNorms pressed do
  (
    for i = 1 to LOCselectionArray.count do
    (
      addmodifier LOCselectionArray[i] (normalModifier flip:true)
      invalidateTreeTM LOCselectionArray[i]
    )
    if queryBox DYNuiResourcesQueries[2] title:DYNuiResourcesTitlebars[3] beep:false then
    (
      for i = 1 to LOCselectionArray.count do collapseStack LOCselectionArray[i]
    )
    redrawViews()
  )

  on BUDYNremSmooth pressed do
  (
    for i = 1 to LOCselectionArray.count do
    (
      addmodifier LOCselectionArray[i] (smoothModifier autoSmooth:false)
      invalidateTreeTM LOCselectionArray[i]
    )
    if queryBox DYNuiResourcesQueries[2] title:DYNuiResourcesTitlebars[3] beep:false then
    (
      for i = 1 to LOCselectionArray.count do collapseStack LOCselectionArray[i]
    )
    redrawViews()
  )


  on CKDYNhide changed arg do
  (
    LOCenableUpdatePropertiesPanel = false
    for i = 1 to LOCselectionArray.count do
    (
      LOCselectionArray[i].isHidden = arg
      invalidateTreeTM LOCselectionArray[i]
    )
    LOCenableUpdatePropertiesPanel = true
    redrawViews()
    DYNFUNupdPropertiesPanel()
  )

  on CKDYNfreeze changed arg do
  (
    LOCenableUpdatePropertiesPanel = false
    for i = 1 to LOCselectionArray.count do
    (
      LOCselectionArray[i].isFrozen = arg
      invalidateTreeTM LOCselectionArray[i]
    )
    LOCenableUpdatePropertiesPanel = true
    redrawViews()
    DYNFUNupdPropertiesPanel()
  )

  on CKDYNshadow changed arg do
  (
    for i = 1 to LOCselectionArray.count do
    (
      LOCselectionArray[i].castShadows = arg
      try (LOCselectionArray[i].isGIoccluder = arg) catch ()
    )
    if try (DYNvehicleParams.open) catch (false) then DYNvehicleParams.CKDYNcastShadow.checked = arg
  )

  on CKDYNboxMode changed arg do
  (
    for i = 1 to LOCselectionArray.count do
    (
      LOCselectionArray[i].boxMode = arg
    )
    if try (DYNvehicleParams.open) catch (false) then DYNvehicleParams.CKDYNdisplayBox.checked = arg
  )

  on BUDYNupdate pressed do
  (
    if (findItem DYNimportCatsArray LOCobjectSwitch) != 0 then
    (
      APCFUNupdateImportedObjects LOCselectionArray true DYNtempPath
      APCFUNupdateAllPlacedObjectControllers()
    )
  )

  on BUDYNokok pressed do
  (
    destroyDialog DYNproperties
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13214 -- id_cv_object_properties

)
--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNbuildShape ""
(
  local LOCobj
  local LOCparentObjectCurveLengths   = #()
  local LOCparentObjects              = #()
  local LOCparentObjectNames          = #()
  local LOCparentObjectPercents       = #()
  local LOCparentObjectStartChainages = #()
  local LOCstartMarkers               = #()
  local LOCendMarkers                 = #()
  local LOCstartMarkerControllers     = #()
  local LOCendMarkerControllers       = #()
  local LOCstartPercent               = 0.0
  local LOCendPercent                 = 1.0
  local LOCcurIndex                   = 0

  fn DYNFUNsetSpinnerRanges FUNindex =
  (
    local LOCstationOffset  = DYNbuildShape.LOCparentObjectStartChainages[FUNindex]
    local LOCpercentExtents = DYNbuildShape.LOCparentObjectPercents[FUNindex]
    local LOCcurveLength    = DYNbuildShape.LOCparentObjectCurveLengths[FUNindex]
    local LOCstartStation   = (LOCcurveLength * LOCpercentExtents[1]) + LOCstationOffset
    local LOCendStation     = (LOCcurveLength * LOCpercentExtents[2]) + LOCstationOffset

    if LOCpercentExtents[1] == 1.0 then (LOCpercentExtents[1] = DYNbuildShape.LOCstartPercent = 0.0)
    if LOCpercentExtents[2] == 0.0 then (LOCpercentExtents[2] = DYNbuildShape.LOCendPercent   = 1.0)

    DYNbuildShape.SPDYNstartPos.range = [LOCstationOffset, (LOCendStation - 1), LOCstartStation]
    DYNbuildShape.SPDYNendPos.range   = [(LOCstartStation + 1), (LOCcurveLength + LOCstationOffset), LOCendStation]
  )

  fn DYNFUNsetLockedSpinnerRanges =
  (
    if (not DYNbuildShape.CKDYNlockChain.checked) and DYNbuildShape.LOCparentObjects.count > 1 then
    (
      for i = 2 to DYNbuildShape.LOCparentObjects.count do
      (
        local LOCstPercent = pathToLengthParam DYNbuildShape.LOCparentObjects[i] 1 (nearestPathParam DYNbuildShape.LOCparentObjects[i] 1 (lengthInterp DYNbuildShape.LOCparentObjects[1] 1 DYNbuildShape.LOCparentObjectPercents[1][1] steps:10000) steps:10000) steps:10000
        local LOCenPercent = pathToLengthParam DYNbuildShape.LOCparentObjects[i] 1 (nearestPathParam DYNbuildShape.LOCparentObjects[i] 1 (lengthInterp DYNbuildShape.LOCparentObjects[1] 1 DYNbuildShape.LOCparentObjectPercents[1][2] steps:10000) steps:10000) steps:10000
        DYNbuildShape.LOCparentObjectPercents[i][1] = DYNbuildShape.LOCstartMarkerControllers[i].percent = LOCstPercent
        DYNbuildShape.LOCparentObjectPercents[i][2] = DYNbuildShape.LOCendMarkerControllers[i].percent   = LOCenPercent
      )
    )
  )

  fn DYNFUNsetLockedAxSubItems FUNlocked =
  (
    if FUNlocked then
    (
      for i = 1 to DYNBuildShape.dnStrings.Items.count do
      (
        local LOCitem  = DYNBuildShape.dnStrings.Items.item[i-1]
        local LOCindex = LOCitem.index + 1
        if (LOCindex) != 1 then
        (
          LOCitem.SubItems.item[1].text = ((DYNbuildShape.LOCparentObjectCurveLengths[LOCindex] * DYNbuildShape.LOCparentObjectPercents[LOCindex][1]) + DYNbuildShape.LOCparentObjectStartChainages[LOCindex]) as string
          LOCitem.SubItems.item[2].text = ((DYNbuildShape.LOCparentObjectCurveLengths[LOCindex] * DYNbuildShape.LOCparentObjectPercents[LOCindex][2]) + DYNbuildShape.LOCparentObjectStartChainages[LOCindex]) as string
        )
      )
    )
    else
    (
      for i = 1 to DYNBuildShape.dnStrings.Items.count do
      (
        local LOCitem  = DYNBuildShape.dnStrings.Items.item[i-1]
        local LOCindex = LOCitem.index + 1
        if LOCindex != 1 then
        (
          LOCitem.SubItems.item[1].text = "-"
          LOCitem.SubItems.item[2].text = "-"
        )
      )
    )
  )

  fn DYNFUNaddToShapeList FUNobj =
  (
    --- Determine Actual Parent Shape Start Station from AppData
    local LOCparentObjectStartChainage = 0.0
    local LOCstartStation = getAppData FUNobj 426
    if classOf LOCstartStation == string then LOCstartStation = LOCstartStation as float
    if classOf LOCstartStation == float  then (LOCparentObjectStartChainage = LOCstartStation)

    --- Add To Main Arrays
    local LOCindex = DYNbuildShape.LOCcurIndex = DYNbuildShape.LOCparentObjects.count + 1
    append DYNbuildShape.LOCparentObjectCurveLengths (curvelength FUNobj 1)
    append DYNbuildShape.LOCparentObjects FUNobj
    append DYNbuildShape.LOCparentObjectNames FUNobj.name
    append DYNbuildShape.LOCparentObjectPercents #(DYNbuildShape.LOCstartPercent,DYNbuildShape.LOCendPercent)
    append DYNbuildShape.LOCparentObjectStartChainages LOCparentObjectStartChainage
    append DYNbuildShape.LOCstartMarkers (DYNFUNapplyDYNmarker DYNbuildShape.LOCparentObjects[LOCindex] undefined DYNINIstartMarkerColor (DYNbuildShape.LOCstartPercent * 100) DYNINImarkerSize 1)
    append DYNbuildShape.LOCendMarkers   (DYNFUNapplyDYNmarker DYNbuildShape.LOCparentObjects[LOCindex] undefined DYNINIendMarkerColor   (DYNbuildShape.LOCendPercent * 100)   DYNINImarkerSize 1)

    append DYNbuildShape.LOCstartMarkerControllers DYNbuildShape.LOCstartMarkers[LOCindex].transform.controller
    append DYNbuildShape.LOCendMarkerControllers   DYNbuildShape.LOCendMarkers[LOCindex].transform.controller

    DYNbuildShape.DYNFUNsetSpinnerRanges (if DYNbuildShape.CKDYNlockChain.checked then LOCindex else 1)
    DYNbuildShape.DYNFUNsetLockedSpinnerRanges()

    --- Select Objects in Parent Shape List
    select DYNbuildShape.LOCparentObjects

    --- Update dotNet ListView
    local LOClistItemRange = #()
    local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" DYNbuildShape.LOCparentObjectNames[LOCindex]
    LOClistItem.imageIndex = 7
    LOClistItem.SubItems.add (((DYNbuildShape.LOCparentObjectCurveLengths[LOCindex] * DYNbuildShape.LOCparentObjectPercents[LOCindex][1]) + DYNbuildShape.LOCparentObjectStartChainages[LOCindex]) as string)
    LOClistItem.SubItems.add (((DYNbuildShape.LOCparentObjectCurveLengths[LOCindex] * DYNbuildShape.LOCparentObjectPercents[LOCindex][2]) + DYNbuildShape.LOCparentObjectStartChainages[LOCindex]) as string)
    LOClistItem.SubItems.add ((numSplines DYNbuildShape.LOCparentObjects[LOCindex]) as string)
    append LOClistItemRange LOClistItem
    DYNbuildShape.dnStrings.Items.AddRange LOClistItemRange
    DYNbuildShape.dnStrings.Items.item[LOCindex - 1].selected = true

    DYNFUNsetLockedAxSubItems DYNBuildShape.CKDYNlockChain.checked

    --- Update Panel
    DYNbuildShape.BUDYNremove.enabled = true
    DYNbuildShape.BUDYNokok.enabled   = true
    if DYNbuildShape.LOCstartMarkers[LOCindex] != undefined and DYNbuildShape.LOCendMarkers[LOCindex] != undefined then
    (
      DYNbuildShape.SPDYNstartPos.enabled  = true ; DYNbuildShape.SPDYNendPos.enabled  = true
      DYNbuildShape.BUDYNstartPos.enabled  = true ; DYNbuildShape.BUDYNendPos.enabled  = true
      DYNbuildShape.LBDYNstartPos.enabled  = true ; DYNbuildShape.LBDYNendPos.enabled  = true
      DYNbuildShape.LBDYNshapeName.enabled = true ; DYNbuildShape.LBDYNextents.enabled = true
      DYNbuildShape.EDDYNshapeName.enabled = true ; DYNbuildShape.BUDYNokok.enabled    = true
      DYNbuildShape.CKDYNlockChain.enabled = true
    )
  )

  --- Build Shape Rollout
  dotNetControl  dnStrings "System.Windows.Forms.ListView" pos:[17,28] width:384 height:100 align:#center

  label LBDYNparentList         pos:[17,13]   align:#left

  pickbutton BUDYNselect        pos:[410,28] width:77      filter:DYNFUNshapeFilter
  button BUDYNremove            pos:[493,28] width:77      enabled:false
  checkbox CKDYNlockChain       pos:[410,55] width:180     enabled:false align:#left
  label LBDYNextents            pos:[410,76]  align:#left   enabled:false
  label LBDYNstartPos           pos:[410,95]  align:#left   enabled:false
  label LBDYNendPos             pos:[410,116] align:#left   enabled:false
  spinner SPDYNstartPos scale:1 pos:[488,94]  range:[0,9999999,0] enabled:false fieldwidth:55 type:#worldunits
  spinner SPDYNendPos   scale:1 pos:[488,115] range:[0,9999999,0] enabled:false fieldwidth:55 type:#worldunits
  checkbutton BUDYNstartPos ">" pos:[556,94]  height:16 width:14 enabled:false
  checkbutton BUDYNendPos   ">" pos:[556,115] height:16 width:14 enabled:false

  label LBDYNshapeName          pos:[17,148]  enabled:false width:145 align:#left
  edittext EDDYNshapeName       pos:[164,146] enabled:false width:237

  button BUDYNokok              pos:[410,146] width:77 enabled:false align:#left
  button BUDYNcanc              pos:[493,146] width:77 align:#left

  on DYNbuildShape open do
  (
    DYNbuildShape.title     = DYNuiRolloutNames[55]
    BUDYNselect.text        = DYNuiResourcesButtons[11]
    BUDYNremove.text        = DYNuiResourcesButtons[12]
    CKDYNlockChain.text     = DYNuiResourcesLabels[447]
    LBDYNparentList.text    = DYNuiResourcesLabels[448]
    LBDYNshapeName.text     = DYNuiResourcesLabels[449]
    LBDYNextents.text       = DYNuiResourcesLabels[450]
    LBDYNstartPos.text      = DYNuiResourcesLabels[9]
    LBDYNendPos.text        = DYNuiResourcesLabels[10]
    BUDYNokok.text          = DYNuiResourcesButtons[1]
    BUDYNcanc.text          = DYNuiResourcesButtons[3]
    EDDYNshapeName.text     = uniqueName DYNuiResourcesNodeNames[6]

    --- dotNet ListView Init
    DYNFUNdnListViewStyle dnStrings false true
    dnStrings.multiSelect        = false
    dnStrings.AllowColumnReorder = false
    dnStrings.sorting            = DYNdnSortOrderClass.none
    dnStrings.smallImageList     = DYNdnSmImageList
    local LOCcol1 = dnStrings.Columns.add DYNuiResourcesLvColumns[109] 140; LOCcol1.textAlign = DYNdnHorAlignClass.left
    local LOCcol2 = dnStrings.Columns.add DYNuiResourcesLvColumns[39]   85; LOCcol2.textAlign = DYNdnHorAlignClass.center
    local LOCcol3 = dnStrings.Columns.add DYNuiResourcesLvColumns[40]   85; LOCcol3.textAlign = DYNdnHorAlignClass.center
    local LOCcol4 = dnStrings.Columns.add DYNuiResourcesLvColumns[110]  50; LOCcol4.textAlign = DYNdnHorAlignClass.center
  )

  on DYNbuildShape close do
  (
    for i in LOCstartMarkers do (if isValidNode i then (delete i))
    for i in LOCendMarkers   do (if isValidNode i then (delete i))
    LOCstartMarkers               = #()
    LOCendMarkers                 = #()
    LOCstartMarkerControllers     = #()
    LOCendMarkerControllers       = #()
    LOCparentObjects              = #()
    LOCparentObjectNames          = #()
    LOCparentObjectPercents      = #()
    LOCparentObjectStartChainages = #()
    dnStrings.Items.clear()
  )

  on CKDYNlockChain changed arg do
  (
    DYNFUNsetSpinnerRanges (if arg then LOCcurIndex else 1)
    DYNFUNsetLockedSpinnerRanges()
    DYNFUNsetLockedAxSubItems arg
  )

  on dnStrings ItemSelectionChanged arg do
  (
    if arg.isSelected then
    (
      LOCcurIndex = arg.ItemIndex + 1
      DYNFUNsetSpinnerRanges (if CKDYNlockChain.checked then LOCcurIndex else 1)
    )
  )

  on BUDYNselect picked arg do
  (
    --- Ensure that selected shape is an editable spline
    DYNFUNcheckIsSplineShape arg

    --- Then Proceed With Adding Shape To Swept Object
    if classof arg == splineshape then
    (
      if (findItem LOCparentObjects arg) == 0 then
      (
        DYNFUNaddToShapeList arg
      )
      else messagebox DYNuiResourcesErrorsWarnings[13] title:DYNuiResourcesTitlebars[1]
    )
  )

  on BUDYNremove pressed do
  (
    if dnStrings.selectedItems.count > 0 and LOCcurIndex != 0 then
    (
      if isValidNode LOCparentObjects[LOCcurIndex] then (deselect LOCparentObjects[LOCcurIndex])
      if isValidNode LOCstartMarkers[LOCcurIndex]  then (delete LOCstartMarkers[LOCcurIndex])
      if isValidNode LOCendMarkers[LOCcurIndex]    then (delete LOCendMarkers[LOCcurIndex])

      deleteItem LOCparentObjectCurveLengths LOCcurIndex
      deleteItem LOCparentObjects LOCcurIndex
      deleteItem LOCparentObjectNames LOCcurIndex
      deleteItem LOCparentObjectPercents LOCcurIndex
      deleteItem LOCparentObjectStartChainages LOCcurIndex
      deleteItem LOCstartMarkers LOCcurIndex
      deleteItem LOCendMarkers LOCcurIndex
      deleteItem LOCstartMarkerControllers LOCcurIndex
      deleteItem LOCendMarkerControllers LOCcurIndex
      dnStrings.Items.RemoveAt (LOCcurIndex - 1)
    )

    if LOCparentObjectNames.count == 0 then
    (
      BUDYNokok.enabled      = false
      BUDYNremove.enabled    = false
      SPDYNstartPos.enabled  = false ; SPDYNendPos.enabled  = false
      BUDYNstartPos.enabled  = false ; BUDYNendPos.enabled  = false
      LBDYNstartPos.enabled  = false ; LBDYNendPos.enabled  = false
      LBDYNshapeName.enabled = false ; LBDYNextents.enabled = false
      EDDYNshapeName.enabled = false ; BUDYNokok.enabled    = false
      CKDYNlockChain.enabled = false
      LOCcurIndex = 0
      SPDYNstartPos.range = [0,9999999,0]
      SPDYNendPos.range   = [0,9999999,0]
    )
    else
    (
      LOCcurIndex = LOCparentObjectNames.count
      dnStrings.Items.item[LOCcurIndex - 1].selected = true
    )
    try (select LOCparentObjects) catch ()
  )

  on SPDYNstartPos changed arg do
  (
    local LOCtempIndex = if CKDYNlockChain.checked then LOCcurIndex else 1
    LOCparentObjectPercents[LOCtempIndex][1] = LOCstartMarkerControllers[LOCtempIndex].percent = (arg - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
    DYNFUNsetLockedSpinnerRanges()
  )
  on SPDYNstartPos entered do
  (
    local LOCtempIndex = if CKDYNlockChain.checked then LOCcurIndex else 1
    dnStrings.Items.item[LOCtempIndex - 1].SubItems.Item[1].text = SPDYNstartPos.value as string
    if SPDYNendPos.value <= SPDYNstartPos.value then (SPDYNendPos.value = SPDYNstartPos.value + 1)
    LOCparentObjectPercents[LOCtempIndex][2] = LOCendMarkerControllers[LOCtempIndex].percent = (SPDYNendPos.value - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
    SPDYNendPos.range.x = SPDYNstartPos.value + 1
  )

  on SPDYNendPos changed arg do
  (
    local LOCtempIndex = if CKDYNlockChain.checked then LOCcurIndex else 1
    LOCparentObjectPercents[LOCtempIndex][2] = LOCendMarkerControllers[LOCtempIndex].percent = (arg - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
    DYNFUNsetLockedSpinnerRanges()
  )
  on SPDYNendPos entered do
  (
    local LOCtempIndex = if CKDYNlockChain.checked then LOCcurIndex else 1
    dnStrings.Items.item[LOCtempIndex - 1].SubItems.Item[2].text = SPDYNendPos.value as string
    if SPDYNstartPos.value >= SPDYNendPos.value then (SPDYNstartPos.value = SPDYNendPos.value - 1)
    LOCparentObjectPercents[LOCtempIndex][1] = LOCstartMarkerControllers[LOCtempIndex].percent = (SPDYNstartPos.value - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
    SPDYNstartPos.range.y = SPDYNendPos.value - 1
  )

  on BUDYNstartPos changed arg do
  (
    if arg then
    (
      local LOCtempIndex = if CKDYNlockChain.checked then LOCcurIndex else 1
      local LOCnewCh = DYNFUNpickChainage LOCparentObjects[LOCtempIndex] 1 LOCparentObjectStartChainages[LOCtempIndex]
      SPDYNstartPos.value = LOCnewCh
      LOCparentObjectPercents[LOCtempIndex][1] = LOCstartMarkerControllers[LOCtempIndex].percent = (LOCnewCh - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
      DYNFUNsetLockedSpinnerRanges()
      dnStrings.Items.item[LOCtempIndex - 1].SubItems.Item[1].text = SPDYNstartPos.value as string
      if SPDYNendPos.value <= SPDYNstartPos.value then (SPDYNendPos.value = SPDYNstartPos.value + 1)
      LOCparentObjectPercents[LOCtempIndex][2] = LOCendMarkerControllers[LOCtempIndex].percent = (SPDYNendPos.value - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
      SPDYNendPos.range.x = SPDYNstartPos.value + 1
    )
    BUDYNstartPos.checked = false
  )

  on BUDYNendPos   changed arg do
  (
    if arg then
    (
      local LOCtempIndex = if CKDYNlockChain.checked then LOCcurIndex else 1
      local LOCnewCh = DYNFUNpickChainage LOCparentObjects[LOCtempIndex] 1 LOCparentObjectStartChainages[LOCtempIndex]
      SPDYNendPos.value = LOCnewCh
      LOCparentObjectPercents[LOCtempIndex][2] = LOCendMarkerControllers[LOCtempIndex].percent = (LOCnewCh - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
      DYNFUNsetLockedSpinnerRanges()
      dnStrings.Items.item[LOCtempIndex - 1].SubItems.Item[2].text = SPDYNendPos.value as string
      if SPDYNstartPos.value >= SPDYNendPos.value then (SPDYNstartPos.value = SPDYNendPos.value - 1)
      LOCparentObjectPercents[LOCtempIndex][1] = LOCstartMarkerControllers[LOCtempIndex].percent = (SPDYNstartPos.value - LOCparentObjectStartChainages[LOCtempIndex]) / LOCparentObjectCurveLengths[LOCtempIndex]
      SPDYNstartPos.range.y = SPDYNendPos.value - 1
    )
    BUDYNendPos.checked = false
  )

  on BUDYNokok pressed do
  (
    DYNFUNremoveCSProllouts()

    if (DYNsweptObjects.LOCparentShapes.count == 0) or (DYNsweptObjects.LOCparentShapes.count >= 1) and (LOCparentObjects.count == DYNsweptObjects.LOCnumSplines) then
    (
      local LOCsuccessSwitch = true
      for i = 1 to LOCparentObjects.count do
      (
        if LOCsuccessSwitch then
        (
          local LOCtempShape = DYNFUNdivideSpline LOCparentObjects[i] DYNsweptObjects.SPDYNspacing.value LOCstartMarkerControllers[i].percent LOCendMarkerControllers[i].percent

          if LOCtempShape != undefined then
          (
            if LOCtempShape.numSplines > 1 then (for ii = LOCtempShape.numSplines to 2 by -1 do (deleteSpline LOCtempShape ii))
            if i == 1 then LOCobj = LOCtempShape else addAndWeld LOCobj LOCtempShape 0.01
          )
          else LOCsuccessSwitch = false
        )
      )

      if LOCsuccessSwitch then DYNFUNcheckIsSplineShape LOCobj
      LOCobj.name = EDDYNshapeName.text
      append DYNsweptObjects.LOCbuiltShapes LOCobj
      DYNsweptObjects.DYNFUNaddParentShapeToCurrentArray LOCobj
      destroyDialog DYNbuildShape
    )
    else
    (
      messagebox (DYNuiResourcesErrorsWarnings[74]) title:DYNuiResourcesTitlebars[1]
    )
  )

  on BUDYNcanc pressed do destroyDialog DYNbuildShape
)
--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNsweptObjects ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCelementMenu
  local LOCorigCommandPanelMode
  local LOCobjMod1                                 -- Civil_View_Swept_Object modifier
  local LOCobjMod2                                 -- Civil_View_Divide_Spline modifier
  local LOCobj                                     -- Civil_View_Swept_ObjectParams Only

  local LOCsosStyle          = ""
  local LOCmatIDarray        = #()
  local LOCsosPath           = ""
  local LOCselectedLVitem    = 0
  local LOCparentShapes      = #()
  local LOCbuiltShapes       = #()
  local LOCnumSplines        = 1
  local LOCallowDnSelection  = true

  --- New Variables Added At Version 3.0
  local LOCdefaultSpanCloseCapElem = #(18,22,22,22)

  local LOCdefElemField01    = DYNsosVtileDefault  -- 1: U Map Repeat
  local LOCdefElemField02    = DYNsosUtileDefault  -- 2: V Map Repeat
  local LOCdefElemField03    = 0.0                 -- 3: UV Map Rotation
  local LOCdefElemField04    = 3.0                 -- 4: Horiz Off Start
  local LOCdefElemField05    = 3.0                 -- 5: Horiz Off End
  local LOCdefElemField06    = 1                   -- 6: Smooth Group
  local LOCdefElemField07    = 0.0                 -- 7: Vert Off Start
  local LOCdefElemField08    = 0.0                 -- 8: Vert Off End
  local LOCdefElemField09    = 0                   -- 9: Inherited Mapping
  local LOCdefElemField10    = 22                  -- 10: Material ID

  local LOCsosGlobalArray    = #()                 -- Holds global info about current SOS Object (SOS Option 2000 and 2010)

  local LOCsosElemArray      = #()                 -- Holds Information About Current Element List (SOS Option 2001)
  local LOCsosElemBuffer     = #()

  local LOCxFallLockArray    = #()
  local LOCxFallLockBuffer   = false

  local LOCsosElemArraySize  = 10
  local LOCobjArray          = #()                 -- DYNsweptObjects Only
  local LOCsegmentDesc       = #()
  local LOCmatName           = DYNmatNameSurfaces  -- DYNsweptObjects Only
  local LOCresourceKitMode   = 1

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---

  --- Function to display a right-click menu over style element list
  fn DYNFUNelementMenu =
  (
    DYNsweptObjects.LOCelementMenu = undefined
    rcmenu LOCelementMenu
    (
      --- Local Variables

      --- Local Filter Functions

      --- Menu Items
      menuItem  MNDYNadd        checked:false
      separator MNDYNseparator1
      menuItem  MNDYNcut        checked:false
      menuItem  MNDYNcopy       checked:false
      menuItem  MNDYNpaste      checked:false
      separator MNDYNseparator2
      menuItem  MNDYNremove     checked:false

      on LOCelementMenu open do
      (
        MNDYNadd.text      = DYNuiResourcesMenus[32]
        MNDYNcut.text      = DYNuiResourcesMenus[33]
        MNDYNcopy.text     = DYNuiResourcesMenus[34]
        MNDYNpaste.text    = DYNuiResourcesMenus[35]
        MNDYNremove.text   = DYNuiResourcesMenus[10]

        MNDYNpaste.enabled = if DYNsweptObjects.LOCsosElemBuffer.count == 0 then false else true
      )

      on MNDYNadd picked do
      (
        DYNsweptObjects.DYNFUNaddSOSelement()
        setFocus DYNsweptObjects.dnElements
      )

      on MNDYNcut picked do
      (
        DYNsweptObjects.BUDYNpaste.enabled = true
        DYNsweptObjects.LOCsosElemBuffer.count = DYNsweptObjects.LOCsosElemArraySize; for i = 1 to DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCselectedLVitem].count do DYNsweptObjects.LOCsosElemBuffer[i] = copy DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCselectedLVitem][i]
        DYNsweptObjects.LOCxFallLockBuffer = DYNsweptObjects.LOCxFallLockArray[DYNsweptObjects.LOCselectedLVitem]

        DYNsweptObjects.BUDYNsave.enabled = true
        deleteItem DYNsweptObjects.LOCsosElemArray DYNsweptObjects.LOCselectedLVitem
        deleteItem DYNsweptObjects.LOCxFallLockArray DYNsweptObjects.LOCselectedLVitem

        DYNsweptObjects.DYNFUNreadSOSelementArray DYNsweptObjects.LOCobjMod1 (if (DYNsweptObjects.LOCobjMod1.total == DYNsweptObjects.LOCselectedLVitem) then (DYNsweptObjects.LOCselectedLVitem - 1) else (DYNsweptObjects.LOCselectedLVitem)) DYNsweptObjects "DYNsweptObjects"
        setFocus DYNsweptObjects.dnElements
      )

      on MNDYNcopy picked do
      (
        DYNsweptObjects.BUDYNpaste.enabled     = true
        DYNsweptObjects.LOCsosElemBuffer.count = DYNsweptObjects.LOCsosElemArraySize; for i = 1 to DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCselectedLVitem].count do DYNsweptObjects.LOCsosElemBuffer[i] = copy DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCselectedLVitem][i]
        DYNsweptObjects.LOCxFallLockBuffer     = DYNsweptObjects.LOCxFallLockArray[DYNsweptObjects.LOCselectedLVitem]
        setFocus DYNsweptObjects.dnElements
      )

      on MNDYNpaste picked do
      (
        if DYNsweptObjects.LOCobjMod1.total < 32 then
        (
          if DYNsweptObjects.LOCsosElemBuffer.count > 0 then
          (
            local LOCelement = #(); LOCelement.count = DYNsweptObjects.LOCsosElemArraySize
            if DYNsweptObjects.LOCselectedLVitem != 0 and DYNsweptObjects.LOCsosElemArray.count > 0 then
            (
              insertItem LOCelement         DYNsweptObjects.LOCsosElemArray   DYNsweptObjects.LOCselectedLVitem
              insertItem LOCxFallLockBuffer DYNsweptObjects.LOCxFallLockArray DYNsweptObjects.LOCselectedLVitem

              for i = 1 to DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCselectedLVitem].count do DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCselectedLVitem][i] = copy DYNsweptObjects.LOCsosElemBuffer[i]
              DYNsweptObjects.DYNFUNreadSOSelementArray DYNsweptObjects.LOCobjMod1 DYNsweptObjects.LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
            )
            else
            (
              append DYNsweptObjects.LOCsosElemArray   LOCelement
              append DYNsweptObjects.LOCxFallLockArray DYNsweptObjects.LOCxFallLockBuffer
              for i = 1 to DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCsosElemArray.count].count do DYNsweptObjects.LOCsosElemArray[DYNsweptObjects.LOCsosElemArray.count][i] = copy DYNsweptObjects.LOCsosElemBuffer[i]
              DYNsweptObjects.DYNFUNreadSOSelementArray DYNsweptObjects.LOCobjMod1 DYNsweptObjects.LOCsosElemArray.count DYNsweptObjects "DYNsweptObjects"
            )
            setFocus DYNsweptObjects.dnElements
          )
        )
        else messageBox (DYNuiResourcesErrorsWarnings[75]) title:DYNuiResourcesTitlebars[1]
      )

      on MNDYNremove picked do
      (
        if DYNsweptObjects.LOCobjMod1.total != 0 and DYNsweptObjects.LOCselectedLVitem != 0 then
        (
          DYNsweptObjects.BUDYNsave.enabled = true
          deleteItem DYNsweptObjects.LOCsosElemArray DYNsweptObjects.LOCselectedLVitem
          deleteItem DYNsweptObjects.LOCxFallLockArray DYNsweptObjects.LOCselectedLVitem
          DYNsweptObjects.DYNFUNreadSOSelementArray DYNsweptObjects.LOCobjMod1 (if (DYNsweptObjects.LOCobjMod1.total == DYNsweptObjects.LOCselectedLVitem) then (DYNsweptObjects.LOCselectedLVitem - 1) else (DYNsweptObjects.LOCselectedLVitem)) DYNsweptObjects "DYNsweptObjects"
        )
        setFocus DYNsweptObjects.dnElements
      )
    )
    registerRightClickMenu DYNsweptObjects.LOCelementMenu
  )

  fn DYNFUNaddSOSelement =
  (
    local LOCdefaultElement = #(DYNsweptObjects.LOCdefElemField01, DYNsweptObjects.LOCdefElemField02, DYNsweptObjects.LOCdefElemField03, DYNsweptObjects.LOCdefElemField04, DYNsweptObjects.LOCdefElemField05, (LOCselectedLVitem + 1), DYNsweptObjects.LOCdefElemField07, DYNsweptObjects.LOCdefElemField08, DYNsweptObjects.LOCdefElemField09, DYNsweptObjects.LOCdefElemField10)

    --- Choose Unused Smooth Group
    local LOCsmgBitArray = #{};  LOCsmgBitArray.count = 32
    for i in DYNsweptObjects.LOCsosElemArray do (if i[6] != 0 then LOCsmgBitArray[i[6]] = true)
    for i = 32 to 1 by -1 do if not LOCsmgBitArray[i] then LOCdefaultElement[6] = i

    --- Decide whether to inherit global mapping parameters
    if DYNsweptObjects.CKDYNuseGlobalUV.checked then
    (
      LOCdefaultElement[1] = if DYNsweptObjects.LOCsosGlobalArray[3] < 0 then (DYNsweptObjects.LOCsosGlobalArray[3] * -1) else (DYNsweptObjects.LOCsosGlobalArray[3])
      LOCdefaultElement[2] = DYNsweptObjects.LOCsosGlobalArray[6]
      LOCdefaultElement[3] = DYNsweptObjects.LOCsosGlobalArray[4]
    )

    --- Add Element
    if DYNsweptObjects.LOCobjMod1.total < 32 then
    (
      DYNsweptObjects.BUDYNsave.enabled = true
      if DYNsweptObjects.LOCobjMod1.total != 0 and DYNsweptObjects.LOCselectedLVitem != 0 then
      (
        insertItem LOCdefaultElement DYNsweptObjects.LOCsosElemArray (DYNsweptObjects.LOCselectedLVitem + 1)
        insertItem false DYNsweptObjects.LOCxFallLockArray (DYNsweptObjects.LOCselectedLVitem + 1)
        DYNsweptObjects.DYNFUNreadSOSelementArray DYNsweptObjects.LOCobjMod1 (DYNsweptObjects.LOCselectedLVitem + 1) DYNsweptObjects "DYNsweptObjects"
      )
      else
      (
        append DYNsweptObjects.LOCsosElemArray LOCdefaultElement
        append DYNsweptObjects.LOCxFallLockArray false
        DYNsweptObjects.DYNFUNreadSOSelementArray DYNsweptObjects.LOCobjMod1 DYNsweptObjects.LOCsosElemArray.count DYNsweptObjects "DYNsweptObjects"

        DYNsweptObjects.LOCallowDnSelection = false
        DYNsweptObjects.dnElements.Items.item[DYNsweptObjects.LOCobjMod1.total - 1].selected = true
        DYNsweptObjects.LOCallowDnSelection = true

        DYNFUNnodeCreatedCallback()
      )
      setFocus DYNsweptObjects.dnElements
    )
    else messageBox (DYNuiResourcesErrorsWarnings[75]) title:DYNuiResourcesTitlebars[1]
  )

  fn DYNFUNresizeSOSeditor FUNnewSize =
  (
    local rollout_axOffset = [0,0]
    if FUNnewSize.y < 546 then (FUNnewSize.y = 546; DYNsweptObjects.height = 546)
    if FUNnewSize.x < 661 then (FUNnewSize.x = 661; DYNsweptObjects.width  = 661)
    if FUNnewSize.y > 750 then (FUNnewSize.y = 750; DYNsweptObjects.height = 750)
    if FUNnewSize.x > 750 then (FUNnewSize.x = 750; DYNsweptObjects.width  = 750)
    rollout_axOffset     = [235,356]

    local LOCaxSize = FUNnewSize - rollout_axOffset
    if LOCaxSize.x <  426 then LOCaxSize.x = 426
    if LOCaxSize.y <  162 then LOCaxSize.y = 162
    DYNsweptObjects.dnElements.width  = LOCaxSize.x
    DYNsweptObjects.dnElements.height = LOCaxSize.y

    --- Move Other Items
    DYNsweptObjects.GBDYNgroup01.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 10
    DYNsweptObjects.LBDYNhOffStart.pos.x      = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.SPDYNhOffStart.pos.x      = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 102
    DYNsweptObjects.LBDYNhOffEnd.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.SPDYNhOffEnd.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 102

    DYNsweptObjects.SPDYNvOffStart.pos.x      = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 102
    DYNsweptObjects.LBDYNvOffStart.pos.x      = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.SPDYNvOffEnd.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 102
    DYNsweptObjects.LBDYNvOffEnd.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18

    DYNsweptObjects.SPDYNxFallStart.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 102
    DYNsweptObjects.LBDYNxFallStart.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.SPDYNxFallEnd.pos.x       = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 102
    DYNsweptObjects.LBDYNxFallEnd.pos.x       = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18

    DYNsweptObjects.CBDYNlockHorOff.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 182
    DYNsweptObjects.CBDYNlockVerOff.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 182
    DYNsweptObjects.CBDYNuseXfallStart.pos.x  = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 182
    DYNsweptObjects.CBDYNuseXfallEnd.pos.x    = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 182

    DYNsweptObjects.GBDYNelemMat.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.CKDYNinherited.pos.x      = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 23
    DYNsweptObjects.CKDYNelemMatOn.pos.x      = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 23
    DYNsweptObjects.DDDYNelemMat.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 65
    DYNsweptObjects.CKDYNelemFlip.pos.x       = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 23

    DYNsweptObjects.LBDYNuRepeat.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 23
    DYNsweptObjects.LBDYNvRepeat.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 23
    DYNsweptObjects.LBDYNuvRotation.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 23
    DYNsweptObjects.LBDYNsmoothGroup.pos.x    = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 23
    DYNsweptObjects.SPDYNvRepeat.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 98
    DYNsweptObjects.SPDYNuRepeat.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 98
    DYNsweptObjects.SPDYNuvRotation.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 98
    DYNsweptObjects.SPDYNsmoothGroup.pos.x    = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 64 + 98

    DYNsweptObjects.BUDYNresetVtile.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 177
    DYNsweptObjects.BUDYNresetUtile.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 177
    DYNsweptObjects.BUDYNresetUVrot.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 177
    DYNsweptObjects.BUDYNresetSmooth.pos.x    = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 177

    DYNsweptObjects.GBDYNmapping.pos.x        = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 10
    DYNsweptObjects.GBDYNmapping.height       = FUNnewSize.y - 436
    DYNsweptObjects.LBDYNvRepGlobal.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.LBDYNuRepGlobal.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.LBDYNuvRotGlobal.pos.x    = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18
    DYNsweptObjects.SPDYNvRepGlobal.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 102 + 64
    DYNsweptObjects.SPDYNuRepGlobal.pos.x     = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 102 + 64
    DYNsweptObjects.SPDYNuvRotGlobal.pos.x    = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 102 + 64
    DYNsweptObjects.BUDYNresetVGlobal.pos.x   = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 181
    DYNsweptObjects.BUDYNresetUGlobal.pos.x   = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 181
    DYNsweptObjects.BUDYNresetRotGlobal.pos.x = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 181
    DYNsweptObjects.CKDYNuseGlobalUV.pos.x    = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 18

    DYNsweptObjects.PKDYNimport.pos.x         = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 2
    DYNsweptObjects.BUDYNmaterial.pos.x       = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 147
    DYNsweptObjects.BUDYNreset.pos.x          = LOCaxSize.x + DYNsweptObjects.dnElements.pos.x + 177

    DYNsweptObjects.MLDYNinstParents.pos.y    = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 38
    DYNsweptObjects.PKDYNpickShape.pos.y      = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 9
    DYNsweptObjects.BUDYNpickByName.pos.y     = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 9
    DYNsweptObjects.BUDYNremShape.pos.y       = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 9

    DYNsweptObjects.GBDYNgroup02.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 73
    DYNsweptObjects.RBDYNinterpType.pos.y     = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 91
    DYNsweptObjects.LBDYNspacing.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 128
    DYNsweptObjects.SPDYNspacing.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 127

    DYNsweptObjects.GBDYNgroup03.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 153
    DYNsweptObjects.RBDYNelemSide.pos.y       = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 170
    DYNsweptObjects.CKDYNelemMirror.pos.y     = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 188
    DYNsweptObjects.RBDYNmultiSpline.pos.y    = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 206
    DYNsweptObjects.LBDYNskew.pos.y           = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 242
    DYNsweptObjects.SPDYNskew.pos.y           = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 241

    DYNsweptObjects.BUDYNbuildShape.pos.y     = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 9 ; DYNsweptObjects.BUDYNbuildShape.pos.x = 192 + ((LOCaxSize.x - 175) / 2) - (250 / 2)
    DYNsweptObjects.GBDYNspanning.pos.y       = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 47; DYNsweptObjects.GBDYNspanning.width = LOCaxSize.x - 175
    DYNsweptObjects.CKDYNspanning.pos.y       = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 70
    DYNsweptObjects.DDDYNspanMatID.pos.y      = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 67; DYNsweptObjects.DDDYNspanMatID.width = LOCaxSize.x - 235
    DYNsweptObjects.CKDYNflipSpanning.pos.y   = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 93

    DYNsweptObjects.GBDYNclosing.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 121; DYNsweptObjects.GBDYNclosing.width = LOCaxSize.x - 175
    DYNsweptObjects.CKDYNclosing.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 144
    DYNsweptObjects.DDDYNcloseMatID.pos.y     = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 141; DYNsweptObjects.DDDYNcloseMatID.width = LOCaxSize.x - 235
    DYNsweptObjects.CKDYNflipClosing.pos.y    = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 167

    DYNsweptObjects.GBDYNcapping.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 194; DYNsweptObjects.GBDYNcapping.width = LOCaxSize.x - 175
    DYNsweptObjects.CKDYNcapping.pos.y        = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 217
    DYNsweptObjects.DDDYNcapMatID.pos.y       = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 214; DYNsweptObjects.DDDYNcapMatID.width = LOCaxSize.x - 235
    DYNsweptObjects.CKDYNflipCapping.pos.y    = LOCaxSize.y + DYNsweptObjects.dnElements.pos.y + 240

    DYNsweptObjects.BUDYNokok.pos.y          = FUNnewSize.y - 46
    DYNsweptObjects.BUDYNcanc.pos.y          = FUNnewSize.y - 46
    DYNsweptObjects.BUDYNhelp.pos.y          = FUNnewSize.y - 46

    DYNsweptObjects.BUDYNokok.pos.x          = FUNnewSize.x - 210
    DYNsweptObjects.BUDYNcanc.pos.x          = FUNnewSize.x - 110

    DYNsweptObjects.dnStatus.pos.y           = FUNnewSize.y - 19
    DYNsweptObjects.dnStatus.width           = FUNnewSize.x - 18

    DYNdefRLsizeSOS = FUNnewSize
  )

  fn DYNFUNmodifySOSelemParam FUNparamString FUNselIndex FUNvalue FUNrollout FUNrolloutString =
  (
    execute (FUNrolloutString + ".LOCobjMod1." + FUNParamString + (FUNselIndex as string) + " = " + (FUNvalue as string))
  )

  fn DYNFUNupdateSOSelementArrayItem FUNrollout FUNselIndex FUNnewMatID FUNmatFlipped =
  (
    local LOCsmoothGroup = FUNselIndex
    FUNrollout.BUDYNsave.enabled = true
    FUNrollout.LOCsosElemArray[FUNselIndex][1]  = FUNrollout.SPDYNvRepeat.value
    FUNrollout.LOCsosElemArray[FUNselIndex][2]  = FUNrollout.SPDYNuRepeat.value
    FUNrollout.LOCsosElemArray[FUNselIndex][3]  = FUNrollout.SPDYNuvRotation.value
    FUNrollout.LOCsosElemArray[FUNselIndex][4]  = FUNrollout.SPDYNhOffStart.value
    FUNrollout.LOCsosElemArray[FUNselIndex][5]  = FUNrollout.SPDYNhOffEnd.value
    FUNrollout.LOCsosElemArray[FUNselIndex][6]  = FUNrollout.SPDYNsmoothGroup.value
    FUNrollout.LOCsosElemArray[FUNselIndex][7]  = FUNrollout.SPDYNvOffStart.value
    FUNrollout.LOCsosElemArray[FUNselIndex][8]  = FUNrollout.SPDYNvOffEnd.value
    FUNrollout.LOCsosElemArray[FUNselIndex][9]  = if FUNrollout.CKDYNinherited.checked then 1 else 0
    FUNrollout.LOCsosElemArray[FUNselIndex][10] = if FUNmatFlipped then (FUNnewMatID * -1) else FUNnewMatID

    --- Update Selected ListItem in Active X Control
    local LOCdisplayedMatName = try (FUNrollout.LOCmatIDarray[FUNnewMatID]) catch ("")
    if FUNnewMatID == 0  then LOCdisplayedMatName = DYNuiResourcesLabels[65]
    if FUNrollout.CKDYNinherited.checked then LOCdisplayedMatName = DYNuiResourcesLabels[64]

    if FUNrollout == DYNsweptObjects then
    (
      --- UPdate dotNet Item ---
      FUNrollout.dnElements.Items.item[FUNselIndex - 1].text =  LOCdisplayedMatName
      FUNrollout.dnElements.Items.item[FUNselIndex - 1].subItems.item[1].text = FUNrollout.LOCsosElemArray[FUNselIndex][4] as string
      FUNrollout.dnElements.Items.item[FUNselIndex - 1].subItems.item[2].text = FUNrollout.LOCsosElemArray[FUNselIndex][5] as string
      FUNrollout.dnElements.Items.item[FUNselIndex - 1].subItems.item[3].text = FUNrollout.LOCsosElemArray[FUNselIndex][7] as string
      FUNrollout.dnElements.Items.item[FUNselIndex - 1].subItems.item[4].text = FUNrollout.LOCsosElemArray[FUNselIndex][8] as string
      FUNrollout.dnElements.Items.item[FUNselIndex - 1].subItems.item[5].text = FUNrollout.LOCsosElemArray[FUNselIndex][6] as string

      if FUNrollout.LOCsosElemArray[FUNselIndex][10] == 0 then
      (
        FUNrollout.dnElements.Items.item[FUNselIndex - 1].forecolor = DYNFUNdnColor DYNINIgreyedOutColor
      )
    )

    if FUNrollout == DYNsosParams then
    (
      FUNrollout.LIDYNcurrentElem.selected = "" + (FUNrollout.LIDYNcurrentElem.selection as string) + ": " + LOCdisplayedMatName + " [" + DYNuiResourcesLabels[451] + (FUNrollout.LOCsosElemArray[FUNselIndex][6] as string) + "]"
    )
  )

  fn DYNFUNwriteSOSelementArray FUNcount FUNrollout FUNrolloutString =
  (
    for i = 1 to FUNcount do
    (
      FUNrollout.LOCsosElemArray[i] = #(); FUNrollout.LOCsosElemArray[i].count = FUNrollout.LOCsosElemArraySize

      FUNrollout.LOCsosElemArray[i][1]  = execute     (FUNrolloutString + ".LOCobjMod1.pvre" + (i as string))                     -- 1:  U Map Repeat
      FUNrollout.LOCsosElemArray[i][2]  = execute     (FUNrolloutString + ".LOCobjMod1.pure" + (i as string))                     -- 2:  V Map Repeat
      FUNrollout.LOCsosElemArray[i][3]  = execute     (FUNrolloutString + ".LOCobjMod1.prot" + (i as string))                     -- 3:  UV Map Rotation
      FUNrollout.LOCsosElemArray[i][4]  = execute     (FUNrolloutString + ".LOCobjMod1.phos" + (i as string))                     -- 4:  Horiz Off Start
      FUNrollout.LOCsosElemArray[i][5]  = execute     (FUNrolloutString + ".LOCobjMod1.phoe" + (i as string))                     -- 5:  Horiz Off End
      FUNrollout.LOCsosElemArray[i][6]  = execute     (FUNrolloutString + ".LOCobjMod1.psmg" + (i as string))                     -- 6:  Inherited Smoothing
      FUNrollout.LOCsosElemArray[i][7]  = execute     (FUNrolloutString + ".LOCobjMod1.pvos" + (i as string))                     -- 7:  Vert Off Start
      FUNrollout.LOCsosElemArray[i][8]  = execute     (FUNrolloutString + ".LOCobjMod1.pvoe" + (i as string))                     -- 8:  Vert Off End
      FUNrollout.LOCsosElemArray[i][9]  = if (execute (FUNrolloutString + ".LOCobjMod1.pinm" + (i as string))) then 1 else 0      -- 9:  Inherited Mapping
      FUNrollout.LOCsosElemArray[i][10] = execute     (FUNrolloutString + ".LOCobjMod1.pmid" + (i as string))                     -- 10: Material ID
    )
  )

  fn DYNFUNupdateSOSglobalPanelCtrls FUNmod1 FUNmod2 FUNrollout =
  (
    --- Side
    FUNrollout.RBDYNelemSide.state   = 1
    if FUNmod1.side < 0 then FUNrollout.RBDYNelemSide.state = 2
    if FUNmod1.side > 0 then FUNrollout.RBDYNelemSide.state = 3

    --- Direction
    FUNrollout.CKDYNelemMirror.checked  = FUNmod1.mirror
    FUNrollout.RBDYNmultiSpline.state = if FUNmod1.splineIndex == 0 then 2 else 1

    --- Interp Type
    local LOCinterpType = FUNmod1.type

    /* Disable Segment Option Type If Spanning Mode Selected And Spline Count > 1 */
    if FUNmod1.splineIndex == 0 then
    (
      LOCinterpType = 3 -- Force Interp Type to "Precomputed"
      FUNmod1.normalize = FUNmod2.normalize = true -- normalize should always be on for IntyerpType 3 (according to above notes from Stefan)
    )
    else
    (
      FUNmod1.normalize = FUNmod2.normalize = if FUNmod1.type == 0 then false else true -- normalize should off for "specify by sement count" method, otherwise on
    )

    if LOCinterpType == 0 then (FUNrollout.RBDYNinterpType.state = 1; FUNrollout.RBDYNinterpType.enabled = true)
    if LOCinterpType == 1 then (FUNrollout.RBDYNinterpType.state = 2; FUNrollout.RBDYNinterpType.enabled = true)
    if LOCinterpType == 3 then (FUNrollout.RBDYNinterpType.state = 1; FUNrollout.RBDYNinterpType.enabled = false) -- Interp Type 3 only for spanned geom - only segment count can be specified
    FUNrollout.LBDYNspacing.text = FUNrollout.LOCsegmentDesc[FUNrollout.RBDYNinterpType.state]

    --- Other Params
    FUNrollout.CKDYNuseGlobalUV.checked = if FUNrollout.LOCsosGlobalArray[3] < 0 then true else false
    FUNrollout.SPDYNuRepGlobal.value    = FUNmod1.spanurep      --  (U_Repeat_Spanning_Surface) : float ----- LOCmod.closingVrep   --  (U_Repeat_Closing_Surface) : float
    FUNrollout.SPDYNvRepGlobal.value    = FUNmod1.spanvrep      --  (V_Repeat_Spanning_Surface) : float ----- LOCmod.closingUrep   --  (V_Repeat_Closing_Surface) : float
    FUNrollout.SPDYNuvRotGlobal.value   = FUNmod1.spanRot       --
    FUNrollout.SPDYNspacing.value       = FUNmod1.spacing
    FUNrollout.SPDYNskew.value          = FUNmod1.capRot

    --- Close/Span/Cap Mat IDs
    if FUNmod1.spanMatID    != 0 then FUNrollout.LOCdefaultSpanCloseCapElem[1] = FUNmod1.spanMatID
    if FUNmod1.closingMatID != 0 then FUNrollout.LOCdefaultSpanCloseCapElem[2] = FUNmod1.closingMatID
    if FUNmod1.capMatID     != 0 then FUNrollout.LOCdefaultSpanCloseCapElem[3] = FUNmod1.capMatID
  )

  fn DYNFUNreadSOSglobalArray FUNmod1 FUNmod2 FUNsosGlobalArray FUNrollout =
  (
    --- Ensure that single spline parent shapes only ever have separated spline geometry
    if FUNrollout.LOCnumSplines == 1 then (FUNsosGlobalArray[5] = -1)

    --- Civil_View_Swept_Object Modifier
    FUNmod1.side         = FUNsosGlobalArray[1]  -- Side
    FUNmod1.mirror       = FUNsosGlobalArray[2]  -- Mirror
    FUNmod1.spanvrep     = if FUNsosGlobalArray[3] < 0 then (FUNsosGlobalArray[3] * -1) else (FUNsosGlobalArray[3])-- Global LengthRepeat Parameter (negative value if global mapping override on)
    FUNmod1.closingVrep  = if FUNsosGlobalArray[3] < 0 then (FUNsosGlobalArray[3] * -1) else (FUNsosGlobalArray[3])-- U_Repeat_Closing_Surface Parameter (negative value if global mapping override on)
    FUNmod1.spanRot      = FUNsosGlobalArray[4]  -- Map Rotation
    FUNmod1.closingRot   = FUNsosGlobalArray[4]  -- Map Rotation
    FUNmod1.splineIndex  = FUNsosGlobalArray[5]  -- MultiSpline Mode
    FUNmod1.spanurep     = FUNsosGlobalArray[6]  -- Global WidthTiling
    FUNmod1.closingUrep  = FUNsosGlobalArray[6]  -- (V_Repeat_Closing_Surface) : float
    FUNmod1.spanMatID    = FUNsosGlobalArray[7]  -- Spanning Surface MatID
    FUNmod1.closingMatID = FUNsosGlobalArray[8]  -- Closing Surface MatID
    FUNmod1.capMatID     = FUNsosGlobalArray[9]  -- Capping Surface MatID
    FUNmod1.spacing      = if FUNsosGlobalArray[10] < 0 then (FUNsosGlobalArray[10] * -1) else (FUNsosGlobalArray[10])-- Spacing Parameter (negative value if segment by length)
    FUNmod1.type         = if FUNsosGlobalArray[10] < 0 then 1 else 0
    FUNmod1.normalize    = if FUNsosGlobalArray[5] == 0 then true else (if FUNmod1.type == 0 then false else true) -- (negative value if normalised is true)
    FUNmod1.capRot       = FUNsosGlobalArray[11]  -- Skew Parameter

    --- Civil_View_Divide_Spline Modifier
    FUNmod2.divisions    = FUNmod1.spacing
    FUNmod2.normalize    = FUNmod1.normalize

    DYNsweptObjects.DYNFUNupdateSOSglobalPanelCtrls FUNmod1 FUNmod2 FUNrollout
  )

  fn DYNFUNreadSOSelementArray FUNmod FUNselIndex FUNrollout FUNrolloutString =
  (
    FUNmod.total = FUNrollout.LOCsosElemArray.count
    for i = 1 to FUNrollout.LOCsosElemArray.count do
    (
      if i == 1 then FUNrollout.LOCsosElemArray[i][9] = 0 -- First Item On Profile MUST NOT USE inherited Mapping. Won't cause crash, but ensures logical consistency in UI
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pvre" i FUNrollout.LOCsosElemArray[i][1] FUNrollout FUNrolloutString                               -- 1: U Map Repeat
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pure" i FUNrollout.LOCsosElemArray[i][2] FUNrollout FUNrolloutString                               -- 2: V Map Repeat
      DYNsweptObjects.DYNFUNmodifySOSelemParam "prot" i FUNrollout.LOCsosElemArray[i][3] FUNrollout FUNrolloutString                               -- 2: UV Map Rotation
      DYNsweptObjects.DYNFUNmodifySOSelemParam "phos" i FUNrollout.LOCsosElemArray[i][4] FUNrollout FUNrolloutString                               -- 4: Horiz Off Start
      DYNsweptObjects.DYNFUNmodifySOSelemParam "phoe" i FUNrollout.LOCsosElemArray[i][5] FUNrollout FUNrolloutString                               -- 5: Horiz Off End
      DYNsweptObjects.DYNFUNmodifySOSelemParam "psmg" i FUNrollout.LOCsosElemArray[i][6] FUNrollout FUNrolloutString                               -- 6: Smoothing Group
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pvos" i FUNrollout.LOCsosElemArray[i][7] FUNrollout FUNrolloutString                               -- 7: Vert Off Start
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" i FUNrollout.LOCsosElemArray[i][8] FUNrollout FUNrolloutString                               -- 8: Vert Off End
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pinm" i (if FUNrollout.LOCsosElemArray[i][9] == 1 then true else false) FUNrollout FUNrolloutString-- 9: Inherited Mapping
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pmid" i FUNrollout.LOCsosElemArray[i][10] FUNrollout FUNrolloutString                              -- 10: Material ID
    )

    if FUNrollout.open then
    (
      if FUNrollout.LOCsosElemArray.count == 0 then
      (
        FUNrollout.BUDYNcopy.enabled = false
        FUNrollout.BUDYNup.enabled   = false
        FUNrollout.BUDYNdown.enabled = false
        FUNrollout.BUDYNrem.enabled  = false
        if FUNrollout == DYNsweptObjects then FUNrollout.BUDYNcut.enabled = false
      )
      else
      (
        FUNrollout.BUDYNcopy.enabled = true
        FUNrollout.BUDYNcopy.enabled = true
        FUNrollout.BUDYNup.enabled   = true
        FUNrollout.BUDYNdown.enabled = true
        FUNrollout.BUDYNrem.enabled  = true
        if FUNrollout == DYNsweptObjects then FUNrollout.BUDYNcut.enabled = true
      )

      DYNsweptObjects.DYNFUNbuildSOSelementList FUNselIndex FUNrollout FUNrolloutString -- Update Panel
      DYNsweptObjects.DYNFUNupdateSOSelementList FUNselIndex FUNrollout FUNrolloutString -- Update Panel
    )
  )

  fn DYNFUNsosElemsFromShape FUNshape FUNdefStyleElement =
  (
    local LOCshapeDetailArray = #()
    local LOCoutArray = #()

    --- Ensure Object Is SplineShape
    DYNFUNcheckIsSplineShape FUNshape

    --- Gather Knot Points Into Jagged Array
    if classOf FUNshape == splineShape then
    (
      for i = 1 to (numSplines FUNshape) do
      (
        for ii = 1 to (numKnots FUNshape i) do
        (
          local LOCmatID = if ii == 1 then 0 else (getMaterialID FUNshape i (ii - 1))
          in coordsys world (append LOCshapeDetailArray #((getKnotPoint FUNshape i ii), LOCmatID))
        )
      )

      --- Convert To Relative Coords in SOS Array
      if LOCshapeDetailArray.count >= 2 then
      (
        for i = 2 to LOCshapeDetailArray.count do
        (
          local LOChOffvOff = LOCshapeDetailArray[i][1] - LOCshapeDetailArray[i - 1][1]
          append LOCoutArray #(FUNdefStyleElement[1], FUNdefStyleElement[2], FUNdefStyleElement[3], LOChOffvOff.x, LOChOffvOff.x, (i - 1), LOChOffvOff.y, LOChOffvOff.y, FUNdefStyleElement[9], LOCshapeDetailArray[i][2])
        )
      )

      --- If MatID for all elements is the same, use inherited mapping for all elements
      local LOCuseInheritedMatID = true
      local LOCfirstMatID = LOCoutArray[1][10]
      for i in LOCoutArray do if i[10] != LOCfirstMatID then LOCuseInheritedMatID = false
      if LOCuseInheritedMatID then (for i = 1 to LOCoutArray.count do (if i != 1 then LOCoutArray[i][9] = 1))

      --- If MatID for all elements was 1, set all matIDs to default Material ID
      if LOCfirstMatID == 1 and LOCuseInheritedMatID then LOCoutArray[1][10] = FUNdefStyleElement[10]
    )

    LOCoutArray -- return value
  )

  fn DYNFUNsosInterpSettings FUNmod1 FUNmod2 FUNrollout =
  (
    /* NOTE: INTERPOLATION OVERVIEW
        Interp Type 0 = ABSOLUTE (Specify number of segments per spline[Traditional Civil_View_Swept_Object method] NORMALIZE SHOULD BE OFF)
        Interp Type 1 = SIMPLE   (Specify spacing by segment length [suitable for independent geom for shapes with multiple splines] NORMALIZE SHOULD BE ON)
        Interp Type 2 = ADAPTIVE (based on the distance along a path and a tangency limit [not used in this implementation, and unlikely to ever be used])
        Interp Type 3 = PRECOMPUTED (uses existing knots on spline only. Only used for spanned geometry where more than one spline exists. NORMALIZE SHOULD BE ON)

      THRESHOLD AND MAX DISTANCE PARAMETERS ONLY HAVE AN EFFECT WHEN INTERP TYPE IS 3 (or 2). IF INTERP TYPE IS 3:
        Threshold - The threshold parameter specifies the number of sample points that will be used to find the point nearest to the knot point on the path.
                    This represents the number of sample points around the approximate location of the knot point. If the value is less than 5 it will use
                    a default number of sample points (the default number is defined by the potential sweet-spot which is determined in the routine itself).

        Max Dist  - The maximum distance is used as a percentage value for this interpolation process. In order for the process to determine the area (to
                    interpolate with sample points) around the approximate location of a knot point it needs to start sampling points before the approximate
                    distance and after the approximate distance of the knot point. This percentage defines what distance percentage (as a percentage of the
                    entire path) is used. For example; a path of 200 units has an approximate distance of a knot point at 180 units distance along the path
                    (200 divided by 180 is 0.900). A maximum distance percentage value of 10 yields the following process; 200 divided by 10 is 20. One
                    twentieth is 0.05. The area that will be examined for the nearest point is then defined as an area between 0.900 minus 0.05 (0.85) and
                    0.900 plus 0.05 (0.95). The area between the distance on the path (0.85 to 0.95) is then divided into the number of sample points defined
                    by the threshold value.

        Normalize - The normalize flag (checkbox/bool) controls the normalization that is applied by the interpolation process. When this is ON the
                    interpolation will be based on a normalized path (PARAM_NORMALIZED). When this is OFF the interpolation will not take normalization
                    into account (PARAM_SIMPLE). Note that this will only affect the internal (and thereby hidden) interpolation process of a specified area
                    around the approximate distance of a knot point on a path. It is recommended to have this set to ON for this particular interpolation
                    process.
    */

    local LOCinterpType = FUNmod1.type

    /* Disable Segment Option Type If Spanning Mode Selected And Spline Count > 1 */
    if FUNmod1.splineIndex == 0 then
    (
      LOCinterpType = 3 -- Force Interp Type to "Precomputed"
      FUNmod1.normalize = FUNmod2.normalize = true -- normalize should always be on for IntyerpType 3 (according to above notes from Stefan)
    )
    else
    (
      FUNmod1.normalize = FUNmod2.normalize = if FUNmod1.type == 0 then false else true -- normalize should off for "specify by sement count" method, otherwise on
    )

    /* SET PANEL VALUES */
    if LOCinterpType == 0 then (FUNrollout.RBDYNinterpType.state = 1; FUNrollout.RBDYNinterpType.enabled = true)
    if LOCinterpType == 1 then (FUNrollout.RBDYNinterpType.state = 2; FUNrollout.RBDYNinterpType.enabled = true)
    if LOCinterpType == 3 then (FUNrollout.RBDYNinterpType.state = 1; FUNrollout.RBDYNinterpType.enabled = false) -- Interp Type 3 only for spanned geom - only segment count can be specified
    FUNrollout.LBDYNspacing.text         = FUNrollout.LOCsegmentDesc[FUNrollout.RBDYNinterpType.state]

    FUNrollout.RBDYNmultiSpline.enabled = if FUNrollout.LOCnumSplines == 1 then false else true

    /* SET DYNSOSPARAMS SPECIFC PANEL VALUES */
    if FUNrollout == DYNsosParams then
    (
      FUNrollout.LBDYNthreshold.enabled    = if LOCinterpType == 3 then true else false
      FUNrollout.SPDYNthreshold.enabled    = if LOCinterpType == 3 then true else false
      FUNrollout.LBDYNmaxDist.enabled      = if LOCinterpType == 3 then true else false
      FUNrollout.SPDYNmaxDist.enabled      = if LOCinterpType == 3 then true else false
      FUNrollout.SPDYNthreshold.value      = FUNmod1.threshold     --  : float
      FUNrollout.SPDYNmaxDist.value        = FUNmod1.maxdist       --  (Maximum_Distance) : float
      FUNrollout.DYNFUNsosStats FUNrollout.LOCobj
    )
  )

  fn DYNFUNbuildSOSelementList FUNselIndex FUNrollout FUNrolloutString =
  (
    --- Build and Display Full List of Current Elements In Style
    local LOCelemNameArray = #()       ; LOCelemNameArray.count        = FUNrollout.LOCobjMod1.total

    for i = 1 to LOCelemNameArray.count do
    (
      local LOCtempmatID         = FUNrollout.LOCsosElemArray[i][10] -- Material ID (could be negative if flipped surface)
      local LOCtempSmoothGroup   = FUNrollout.LOCsosElemArray[i][6] as string -- Material ID (could be negative if flipped surface)
      local LOCdisplayedMatName  = try (FUNrollout.LOCmatIDarray[if LOCtempmatID < 0 then (LOCtempmatID * -1) else (LOCtempmatID)]) catch ("")
      if LOCtempmatID == 0  then LOCdisplayedMatName = DYNuiResourcesLabels[65]
      local LOCtempInherit       = if FUNrollout.LOCsosElemArray[i][9] == 1 then true else false -- Independent Mapping?
      if LOCtempInherit then LOCdisplayedMatName = DYNuiResourcesLabels[64]
      LOCelemNameArray[i]        = if FUNrollout == DYNsosParams then ("" + (i as string) + ": " + LOCdisplayedMatName + " " + DYNuiResourcesLabels[451] + LOCtempSmoothGroup + "]") else (LOCdisplayedMatName)
    )

    DYNsweptObjects.DYNFUNcloseSpanSettings FUNrollout

    --- If DYNsosParams rollout is current
    if FUNrollout == DYNsosParams then
    (
      DYNsosParams.LIDYNcurrentElem.items       = LOCelemNameArray
      DYNsosParams.LIDYNcurrentElem.enabled     = if FUNrollout.LOCsosElemArray.count > 0 then true else false
    )

    --- If DYNsweptObjects rollout is current
    if FUNrollout == DYNsweptObjects then
    (
      --- Populate dotnet Control ----
      FUNrollout.dnElements.Items.clear()
      local LOClistItemRange = #()
      for i = 1 to FUNrollout.LOCsosElemArray.count do
      (
        local LOClistItem      = dotNetObject "System.Windows.Forms.ListViewItem" LOCelemNameArray[i]
        LOClistItem.imageIndex = 9
        LOClistItem.SubItems.add (FUNrollout.LOCsosElemArray[i][4] as string) -- Horizontal Offset Start
        LOClistItem.SubItems.add (FUNrollout.LOCsosElemArray[i][5] as string) -- Horizontal Offset End
        LOClistItem.SubItems.add (FUNrollout.LOCsosElemArray[i][7] as string) -- Vertical Offset Start
        LOClistItem.SubItems.add (FUNrollout.LOCsosElemArray[i][8] as string) -- Vertical Offset End
        LOClistItem.SubItems.add (FUNrollout.LOCsosElemArray[i][6] as string) -- Smooth Group

        if FUNrollout.LOCsosElemArray[i][10] == 0 then
        (
          LOClistItem.forecolor = DYNFUNdnColor DYNINIgreyedOutColor
        )
        append LOClistItemRange LOClistItem
      )
      FUNrollout.dnElements.Items.AddRange LOClistItemRange --when done, we populate the ListView

      FUNrollout.LOCselectedLVitem   = FUNselIndex
    )
  )

  fn DYNFUNupdateSOSelementList FUNselIndex FUNrollout FUNrolloutString =
  (
    local LOCelemIndepStatusArray = #(); LOCelemIndepStatusArray.count = FUNrollout.LOCobjMod1.total
    for i = 1 to LOCelemIndepStatusArray.count do
    (
      local LOCtempInherit       = if FUNrollout.LOCsosElemArray[i][9] == 1 then true else false -- Independent Mapping?
      LOCelemIndepStatusArray[i] = LOCtempInherit
    )

    if FUNrollout == DYNsosParams then
    (
      DYNsosParams.LIDYNcurrentElem.selection   = FUNselIndex
      if (DYNsosParams.dntabctrl.selectedTab.TabIndex + 1) == 2 then FUNrollout.LOCobjMod1.highlight = FUNselIndex -- only if second tab is activated
    )
    else
    (
      FUNrollout.LOCobjMod1.highlight = FUNselIndex
    )

    --- Display Parameters For Selected Element
    if FUNselIndex > 0 then
    (
      if FUNrollout == DYNsweptObjects then
      (
        FUNrollout.LOCallowDnSelection = false
        FUNrollout.dnElements.Items.item[FUNselIndex - 1].selected = true
        FUNrollout.dnElements.Items.Item[FUNselIndex - 1].ensureVisible()
        FUNrollout.LOCallowDnSelection = true
      )

      local LOCvRepParam     = FUNrollout.LOCsosElemArray[FUNselIndex][1]
      local LOCuRepParam     = FUNrollout.LOCsosElemArray[FUNselIndex][2]
      local LOCuvRotation    = FUNrollout.LOCsosElemArray[FUNselIndex][3]
      local LOChOffStParam   = FUNrollout.LOCsosElemArray[FUNselIndex][4]
      local LOChOffEnParam   = FUNrollout.LOCsosElemArray[FUNselIndex][5]
      local LOCsmoothParam   = FUNrollout.LOCsosElemArray[FUNselIndex][6]
      local LOCvOffStParam   = FUNrollout.LOCsosElemArray[FUNselIndex][7]
      local LOCvOffEnParam   = FUNrollout.LOCsosElemArray[FUNselIndex][8]
      local LOCindMapParam   = if FUNrollout.LOCsosElemArray[FUNselIndex][9] == 1 then true else false
      local LOCmatIDparam    = FUNrollout.LOCsosElemArray[FUNselIndex][10]

      if FUNrollout == DYNsweptObjects then FUNrollout.GBDYNgroup01.text = DYNuiResourcesGroups[9] + " " + (FUNselIndex as string)

      FUNrollout.CBDYNlockHorOff.enabled    = true  ; FUNrollout.CBDYNlockVerOff.enabled    = true ;
      FUNrollout.CBDYNuseXfallStart.enabled = true  ; FUNrollout.CBDYNuseXfallEnd.enabled   = true
      FUNrollout.SPDYNhOffStart.enabled     = true  ; FUNrollout.LBDYNhOffStart.enabled     = true ; FUNrollout.SPDYNhOffStart.value     = LOChOffStParam
      FUNrollout.SPDYNhOffEnd.enabled       = true  ; FUNrollout.LBDYNhOffEnd.enabled       = true ; FUNrollout.SPDYNhOffEnd.value       = LOChOffEnParam
      FUNrollout.SPDYNvOffStart.enabled     = true  ; FUNrollout.LBDYNvOffStart.enabled     = true ; FUNrollout.SPDYNvOffStart.value     = LOCvOffStParam
      FUNrollout.SPDYNvOffEnd.enabled       = true  ; FUNrollout.LBDYNvOffEnd.enabled       = true ; FUNrollout.SPDYNvOffEnd.value       = LOCvOffEnParam
      FUNrollout.SPDYNsmoothGroup.enabled   = true  ; FUNrollout.LBDYNsmoothGroup.enabled   = true ; FUNrollout.SPDYNsmoothGroup.value   = LOCsmoothParam
      FUNrollout.BUDYNresetSmooth.enabled   = true

      FUNrollout.SPDYNxFallStart.enabled    = true  ; FUNrollout.LBDYNxFallStart.enabled    = true
      FUNrollout.SPDYNxFallEnd.enabled      = true  ; FUNrollout.LBDYNxFallEnd.enabled      = true
      FUNrollout.SPDYNxFallStart.value      = if LOChOffStParam != 0.0 then (LOCvOffStParam / LOChOffStParam) else 0.0
      FUNrollout.SPDYNxFallEnd.value        = if LOChOffEnParam != 0.0 then (LOCvOffEnParam / LOChOffEnParam) else FUNrollout.SPDYNxFallStart.value

      FUNrollout.CBDYNuseXfallStart.checked = FUNrollout.LOCxFallLockArray[FUNselIndex]
      FUNrollout.CBDYNuseXfallEnd.checked   = FUNrollout.LOCxFallLockArray[FUNselIndex]

      FUNrollout.CKDYNelemMatOn.checked     = if LOCmatIDparam == 0 then false else true
      FUNrollout.CKDYNelemFlip.checked      = if LOCmatIDparam < 0 then true else false

      FUNrollout.SPDYNvRepeat.value         = if FUNrollout.CKDYNuseGlobalUV.checked then (if FUNrollout.LOCsosGlobalArray[3] < 0 then (FUNrollout.LOCsosGlobalArray[3] * -1) else (FUNrollout.LOCsosGlobalArray[3])) else LOCvRepParam
      FUNrollout.SPDYNuRepeat.value         = if FUNrollout.CKDYNuseGlobalUV.checked then FUNrollout.LOCsosGlobalArray[6] else LOCuRepParam
      FUNrollout.SPDYNuvRotation.value      = if FUNrollout.CKDYNuseGlobalUV.checked then FUNrollout.LOCsosGlobalArray[4] else LOCuvRotation

      DYNsweptObjects.DYNFUNvariableOffsets ((LOChOffStParam == LOChOffEnParam) and (LOCvOffStParam == LOCvOffEnParam)) FUNselIndex FUNrollout FUNrolloutString

      --- Set Up Element Mapping Controls depending on whether inherited mapping for this element is enabled and whether element surface is activated
      FUNrollout.DDDYNelemMat.selection   = if LOCmatIDparam < 0 then (LOCmatIDparam * -1) else LOCmatIDparam
      if LOCmatIDparam != 0 then FUNrollout.LOCdefaultSpanCloseCapElem[4] = LOCmatIDparam
      if FUNselIndex == 1 then /* First Element In Style Should Never Have Independent Mapping Enabled, So Force It Off Now */
      (
        FUNrollout.CKDYNinherited.checked   = false
        FUNrollout.CKDYNinherited.enabled   = false
        DYNsweptObjects.DYNFUNmodifySOSelemParam "pinm" FUNselIndex FUNrollout.CKDYNinherited.checked FUNrollout FUNrolloutString
        FUNrollout.DDDYNelemMat.enabled     = if LOCmatIDparam == 0 then false else true
        FUNrollout.CKDYNelemMatOn.enabled   = true
      )
      else
      (
        FUNrollout.CKDYNinherited.checked   = LOCindMapParam
        FUNrollout.CKDYNinherited.enabled   = true
        FUNrollout.DDDYNelemMat.enabled     = if LOCindMapParam then false else (if LOCmatIDparam == 0 then false else true)
        FUNrollout.CKDYNelemMatOn.enabled   = if LOCindMapParam then FUNrollout.DDDYNelemMat.enabled else true

        /* If An Inherited Map is Being Used, Display Values from Donor Element!! */
        if LOCindMapParam then
        (
          --- Find Donor Element
          local LOCdonorSurface = FUNselIndex
          local LOCproceedSwitch = true
          for i = (FUNselIndex - 1) to 1 by -1 do (if LOCproceedSwitch then (if not LOCelemIndepStatusArray[i] then (LOCdonorSurface = i; LOCproceedSwitch = false)))

          --- Display Material Info From Donor Element
          local LOCtmpmatIDparam              = FUNrollout.LOCsosElemArray[LOCdonorSurface][10]
          FUNrollout.SPDYNvRepeat.value       = FUNrollout.LOCsosElemArray[LOCdonorSurface][1]
          FUNrollout.SPDYNuRepeat.value       = FUNrollout.LOCsosElemArray[LOCdonorSurface][2]
          FUNrollout.SPDYNuvRotation.value    = FUNrollout.LOCsosElemArray[LOCdonorSurface][3]
          FUNrollout.CKDYNelemMatOn.checked   = if LOCtmpmatIDparam == 0 then false else true
          FUNrollout.CKDYNelemFlip.checked    = if LOCtmpmatIDparam  < 0 then true else false
          FUNrollout.DDDYNelemMat.selection   = if LOCtmpmatIDparam  < 0 then (LOCtmpmatIDparam * -1) else LOCtmpmatIDparam
        )

      )
      FUNrollout.CKDYNelemFlip.enabled      = FUNrollout.DDDYNelemMat.enabled

      FUNrollout.SPDYNvRepeat.enabled       = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.SPDYNuRepeat.enabled       = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.SPDYNuvRotation.enabled    = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.LBDYNuRepeat.enabled       = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.LBDYNvRepeat.enabled       = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.LBDYNuvRotation.enabled    = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.BUDYNresetVtile.enabled    = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.BUDYNresetUtile.enabled    = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled
      FUNrollout.BUDYNresetUVrot.enabled    = if FUNrollout.CKDYNuseGlobalUV.checked then false else FUNrollout.DDDYNelemMat.enabled

      --- Highlighting Type (Only outline highlighting if matID = 0)
      FUNrollout.LOCobjMod1.highlightType    = if FUNrollout.DDDYNelemMat.selection == 0 then 1 else 3
    )
    else
    (
      if FUNrollout == DYNsweptObjects then FUNrollout.GBDYNgroup01.text = DYNuiResourcesGroups[9]
      FUNrollout.CBDYNlockHorOff.enabled    = false ; FUNrollout.CBDYNlockVerOff.enabled    = false;
      FUNrollout.CBDYNuseXfallStart.enabled = false ; FUNrollout.CBDYNuseXfallEnd.enabled   = false
      FUNrollout.SPDYNhOffStart.enabled     = false ; FUNrollout.LBDYNhOffStart.enabled     = false; FUNrollout.SPDYNhOffStart.value     = 0
      FUNrollout.SPDYNhOffEnd.enabled       = false ; FUNrollout.LBDYNhOffEnd.enabled       = false; FUNrollout.SPDYNhOffEnd.value       = 0
      FUNrollout.SPDYNvOffStart.enabled     = false ; FUNrollout.LBDYNvOffStart.enabled     = false; FUNrollout.SPDYNvOffStart.value     = 0
      FUNrollout.SPDYNvOffEnd.enabled       = false ; FUNrollout.LBDYNvOffEnd.enabled       = false; FUNrollout.SPDYNvOffEnd.value       = 0
      FUNrollout.SPDYNxFallStart.enabled    = false ; FUNrollout.LBDYNxFallStart.enabled    = false; FUNrollout.SPDYNxFallStart.value    = 0
      FUNrollout.SPDYNxFallEnd.enabled      = false ; FUNrollout.LBDYNxFallEnd.enabled      = false; FUNrollout.SPDYNxFallEnd.value      = 0
      FUNrollout.DDDYNelemMat.enabled       = false ; FUNrollout.DDDYNelemMat.selection     = 0
      FUNrollout.CKDYNelemMatOn.enabled     = false ; FUNrollout.CKDYNelemMatOn.checked     = false
      FUNrollout.BUDYNresetVtile.enabled    = false ; FUNrollout.BUDYNresetUtile.enabled    = false; FUNrollout.BUDYNresetUVrot.enabled  = false
      FUNrollout.SPDYNvRepeat.enabled       = false ; FUNrollout.LBDYNuRepeat.enabled       = false; FUNrollout.SPDYNvRepeat.value       = DYNsosVtileDefault
      FUNrollout.SPDYNuRepeat.enabled       = false ; FUNrollout.LBDYNvRepeat.enabled       = false; FUNrollout.SPDYNuRepeat.value       = DYNsosUtileDefault
      FUNrollout.SPDYNuvRotation.enabled    = false ; FUNrollout.LBDYNuvRotation.enabled    = false; FUNrollout.SPDYNuvRotation.value    = 0.0
      FUNrollout.SPDYNsmoothGroup.enabled   = false ; FUNrollout.LBDYNsmoothGroup.enabled   = false; FUNrollout.SPDYNsmoothGroup.value   = 0
      FUNrollout.CKDYNinherited.enabled     = false
      FUNrollout.CKDYNelemFlip.enabled      = false
      FUNrollout.BUDYNresetSmooth.enabled   = false
    )
  )

  fn DYNFUNvariableOffsets FUNswitch FUNcurrentElem FUNrollout FUNrolloutString =
  (
    FUNrollout.BUDYNsave.enabled          = true
    FUNrollout.CBDYNlockHorOff.checked    = FUNswitch
    FUNrollout.CBDYNlockVerOff.checked    = FUNswitch

    --- Depending on whether start/end locked
    if FUNswitch then
    (
      FUNrollout.LBDYNhOffEnd.enabled     = false
      FUNrollout.LBDYNvOffEnd.enabled     = false
      FUNrollout.LBDYNxfallEnd.enabled    = false
      FUNrollout.SPDYNhOffEnd.enabled     = false
      FUNrollout.SPDYNvOffEnd.enabled     = false
      FUNrollout.SPDYNxfallEnd.enabled    = false

      FUNrollout.CBDYNuseXfallEnd.checked = FUNrollout.CBDYNuseXfallStart.checked

      --- This section must be excluded if called from DYNFUNupdateElementList
      if FUNcurrentElem != 0 then
      (
        FUNrollout.SPDYNHOffend.value     = FUNrollout.SPDYNhOffStart.value
        FUNrollout.SPDYNVOffend.value     = FUNrollout.SPDYNvOffStart.value
        FUNrollout.SPDYNXfallend.value    = FUNrollout.SPDYNxfallStart.value
        DYNsweptObjects.DYNFUNmodifySOSelemParam "phoe" FUNcurrentElem FUNrollout.SPDYNhOffstart.value FUNrollout FUNrolloutString
        DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" FUNcurrentElem FUNrollout.SPDYNvOffstart.value FUNrollout FUNrolloutString
        if FUNrollout == DYNsweptObjects then
        (
          FUNrollout.dnElements.Items.item[FUNcurrentElem - 1].SubItems.item[2].text = FUNrollout.SPDYNhOffEnd.value as string
          FUNrollout.dnElements.Items.item[FUNcurrentElem - 1].SubItems.item[4].text = FUNrollout.SPDYNvOffEnd.value as string
        )
      )
    )
    else
    (
      FUNrollout.LBDYNhOffEnd.enabled     = true
      FUNrollout.SPDYNhOffEnd.enabled     = true
      FUNrollout.LBDYNvOffEnd.enabled     = true
      FUNrollout.SPDYNvOffEnd.enabled     = true
      FUNrollout.LBDYNxfallEnd.enabled    = true
      FUNrollout.SPDYNxfallEnd.enabled    = true
    )
  )

  fn DYNFUNcloseSpanSettings FUNrollout =
  (
    local LOCspanningAllowed = true
    local LOCclosingAllowed  = true
    local LOCcappingAllowed  = true

    --- Define Rules (Ignore if object doesn't exist - all variables already set to false anyway)
    /* If number of splines = 1 Spanning Surface Cannot Be Created */
    if FUNrollout.LOCnumSplines <= 1 then (LOCspanningAllowed = false)

    /* If a specific spline in a multi-spline shape is specifically selected, spanning surfaces cannot be created */
    if FUNrollout.LOCobjMod1.splineIndex != 0 then (LOCspanningAllowed = false)

    /* If one sided object is being created, spanning, closing and capping surface cannot be created */
    if FUNrollout.LOCobjMod1.side != 0 then (LOCspanningAllowed = LOCclosingAllowed = LOCcappingAllowed = false)

    /* If one element exists in profile and it is a gap element, closing surface cannot be created */
    if FUNrollout.LOCobjMod1.total == 1 and FUNrollout.LOCsosElemArray[1][10] == 0 then (LOCclosingAllowed = false)

    /* If no elements exists in profile, closing surface cannot be created */
    if FUNrollout.LOCobjMod1.total == 0 then (LOCclosingAllowed = false)

    /* If ANY Gap Elements Exist in profile, CAPPING surface cannot be created */
    for i in FUNrollout.LOCsosElemArray do (if i[10] == 0 and i[9] == 0 then (LOCcappingAllowed = false))

    /* If a Closing Surface is not activated, a capping surface cannot be created */
    if (not LOCclosingAllowed or FUNrollout.LOCobjMod1.closingMatID == 0) then (LOCcappingAllowed = false)

    /* If Spanning Surface is not activated for multispline shapes, a capping surface cannot be created */
    if (not LOCspanningAllowed or FUNrollout.LOCobjMod1.spanMatID == 0) and (FUNrollout.LOCobjMod1.splineIndex == 0) then (LOCcappingAllowed = false)

    --- Enable Panel Spanning Parameters ---------------------
    if not LOCspanningAllowed then
    (
      FUNrollout.CKDYNflipSpanning.enabled = false; FUNrollout.CKDYNflipSpanning.checked = false
      FUNrollout.DDDYNspanMatID.enabled    = false; FUNrollout.DDDYNspanMatID.selection  = 0
      FUNrollout.CKDYNspanning.enabled     = false; FUNrollout.CKDYNspanning.checked     = false
      FUNrollout.LOCsosGlobalArray[7]      = 0    ; FUNrollout.LOCobjMod1.spanMatID = 0
    )
    else
    (
      FUNrollout.CKDYNflipSpanning.enabled = true ; FUNrollout.CKDYNflipSpanning.checked = if FUNrollout.LOCsosGlobalArray[7] < 0 then true else false
      FUNrollout.DDDYNspanMatID.enabled    = true ; FUNrollout.DDDYNspanMatID.selection  = if FUNrollout.LOCsosGlobalArray[7] < 0 then (FUNrollout.LOCsosGlobalArray[7] * -1) else FUNrollout.LOCsosGlobalArray[7]
      FUNrollout.CKDYNspanning.enabled     = true ; FUNrollout.CKDYNspanning.checked     = if FUNrollout.LOCsosGlobalArray[7] != 0 then true else false
    )

    --- Enable Panel Closing Parameters ----------------------
    if not LOCclosingAllowed then
    (
      FUNrollout.CKDYNflipClosing.enabled  = false; FUNrollout.CKDYNflipClosing.checked  = false
      FUNrollout.DDDYNcloseMatID.enabled   = false; FUNrollout.DDDYNcloseMatID.selection = 0
      FUNrollout.CKDYNclosing.enabled      = false; FUNrollout.CKDYNclosing.checked      = false
      FUNrollout.LOCsosGlobalArray[8]      = 0    ; FUNrollout.LOCobjMod1.closingMatID    = 0
    )
    else
    (
      FUNrollout.CKDYNflipClosing.enabled  = true ; FUNrollout.CKDYNflipClosing.checked  = if FUNrollout.LOCsosGlobalArray[8] < 0 then true else false
      FUNrollout.DDDYNcloseMatID.enabled   = true ; FUNrollout.DDDYNcloseMatID.selection = if FUNrollout.LOCsosGlobalArray[8] < 0 then (FUNrollout.LOCsosGlobalArray[8] * -1) else FUNrollout.LOCsosGlobalArray[8]
      FUNrollout.CKDYNclosing.enabled      = true ; FUNrollout.CKDYNclosing.checked      = if FUNrollout.LOCsosGlobalArray[8] != 0 then true else false
    )

    --- Enable Panel Capping Parameters ----------------------
    if not LOCcappingAllowed then
    (
      FUNrollout.CKDYNflipCapping.enabled  = false; FUNrollout.CKDYNflipCapping.checked  = false
      FUNrollout.DDDYNcapMatID.enabled     = false; FUNrollout.DDDYNcapMatID.selection   = 0
      FUNrollout.CKDYNcapping.enabled      = false; FUNrollout.CKDYNcapping.checked      = false
      FUNrollout.LOCsosGlobalArray[9]      = 0    ; FUNrollout.LOCobjMod1.capMatID = 0
    )
    else
    (
      FUNrollout.CKDYNflipCapping.enabled  = true ; FUNrollout.CKDYNflipCapping.checked  = if FUNrollout.LOCsosGlobalArray[9] < 0 then true else false
      FUNrollout.DDDYNcapMatID.enabled     = true ; FUNrollout.DDDYNcapMatID.selection   = if FUNrollout.LOCsosGlobalArray[9] < 0 then (FUNrollout.LOCsosGlobalArray[9] * -1) else FUNrollout.LOCsosGlobalArray[9]
      FUNrollout.CKDYNcapping.enabled      = true ; FUNrollout.CKDYNcapping.checked      = if FUNrollout.LOCsosGlobalArray[9] != 0 then true else false
    )

    --- If Surface Is Definitely -OFF-, then disable material selection control
    if not FUNrollout.CKDYNspanning.checked then FUNrollout.DDDYNspanMatID.enabled  = false
    if not FUNrollout.CKDYNclosing.checked  then FUNrollout.DDDYNcloseMatID.enabled = false
    if not FUNrollout.CKDYNcapping.checked  then FUNrollout.DDDYNcapMatID.enabled   = false

    --- Enable SAVE button
    if FUNrollout.LOCobjMod1.total > 0 then FUNrollout.BUDYNsave.enabled = true

    --- Show Num Verts/Faces in ROllout
    if FUNrollout == DYNsosParams then FUNrollout.DYNFUNsosStats FUNrollout.LOCobj
  )

  fn DYNFUNopenSOSfile FUNfile FUNmode =
  (
    DYNsweptObjects.LOCresourceKitMode = FUNmode
    if FUNfile != undefined then
    (
      if doesFileExist FUNfile then
      (
        local LOCproceedSwitch = DYNFUNsosPreFlight FUNfile
        if not LOCproceedSwitch then (messagebox (DYNuiResourcesErrorsWarnings[76]) title:DYNuiResourcesTitlebars[1])
        if LOCproceedSwitch == true then
        (
          DYNsweptObjects.LOCsosStyle   = FUNfile
          DYNsweptObjects.title = DYNuiRolloutNames[56] + " [" + (FileNameFromPath DYNsweptObjects.LOCsosStyle) + "]"
          DYNsweptObjects.LOCsosPath    = DYNsweptObjects.LOCsosStyle
          DYNsweptObjects.LOCsosGlobalArray = (DYNFUNparsePARAMfile DYNsweptObjects.LOCsosStyle "2000")[1]
          append DYNsweptObjects.LOCsosGlobalArray (DYNFUNparsePARAMfile DYNsweptObjects.LOCsosStyle "2010")[1][1]
          DYNsweptObjects.DYNFUNreadSOSglobalArray DYNsweptObjects.LOCobjMod1 DYNsweptObjects.LOCobjMod2 DYNsweptObjects.LOCsosGlobalArray DYNsweptObjects
          DYNsweptObjects.LOCsosElemArray   = DYNFUNparsePARAMfile DYNsweptObjects.LOCsosStyle "2001"
          DYNsweptObjects.LOCxFallLockArray.count = DYNsweptObjects.LOCsosElemArray.count; for i = 1 to DYNsweptObjects.LOCxFallLockArray.count do DYNsweptObjects.LOCxFallLockArray[i] = false
          DYNsweptObjects.DYNFUNreadSOSelementArray DYNsweptObjects.LOCobjMod1 DYNsweptObjects.LOCsosElemArray.count DYNsweptObjects "DYNsweptObjects"

          for i in DYNsweptObjects.LOCobjArray do
          (
            if isValidNode i then
            (
              setAppData i 424 DYNsweptObjects.LOCsosStyle
              setAppData i 426 (if DYNsweptObjects.LOCsosGlobalArray[3] < 0.0 then "1" else "0")
            )
          )

          DYNsweptObjects.BUDYNsave.enabled  = false
        )
      )
    )
  )

  fn DYNFUNsaveSOSfile FUNglobalArray FUNelemArray FUNrollout =
  (
    local LOCstream
    --- Get User To Specify Name Of File To Save and Display Name in Rollout Title Bar
    local LOCtempFile = DYNFUNgetSaveFileName "SOS" FUNrollout.LOCsosPath FUNrollout.LOCresourceKitMode false
    FUNrollout.LOCresourceKitMode = DYNfileSelectorKitMode

    if LOCtempFile != undefined then
    (
      --- Display File Name In Panel
      if FUNrollout == DYNsweptObjects then (FUNrollout.title = DYNuiRolloutNames[56] + " [" + (FileNameFromPath LOCtempFile) + "]")
      if FUNrollout == DYNsosParams    then (FUNrollout.LBDYNfile.text = FileNameFromPath LOCtempFile)

      --- Create Output File Stream
      LOCstream = try (createFile LOCtempFile) catch ()

      --- Check That Output Stream Was Created
      if LOCstream != undefined then
      (
        --- Write SOS Style 2000 Option and 2010 Option (Skew)
        format "2000,%,%,%,%,%,%,%,%,%,%\n" FUNglobalArray[1] (if FUNglobalArray[2] then -1 else 1) FUNglobalArray[3] FUNglobalArray[4] FUNglobalArray[5] FUNglobalArray[6] FUNglobalArray[7] FUNglobalArray[8] FUNglobalArray[9] (FUNglobalArray[10] as integer) to:LOCstream
        format "2010,%\n" FUNglobalArray[11] to:LOCstream

        --- Add SOS Style 2001 Options
        for i in FUNelemArray do
        (
          format "2001,%,%,%,%,%,%,%,%,%,%\n" i[1] i[2] i[3] i[4] i[5] i[6] i[7] i[8] i[9] i[10] to:LOCstream
        )

        --- Close FileStream
        close LOCstream

        --- Update Panel and DVSP Global Variables
        if FUNrollout == DYNsweptObjects then (for i in FUNrollout.LOCobjArray do (if isValidNode i then (setAppData i 424 LOCtempFile)))
        if FUNrollout == DYNsosParams    then
        (
          if isValidNode FUNrollout.LOCobj then
          (
            setAppData FUNrollout.LOCobj 424 LOCtempFile

            --- Update AppData for objects containing instances of this modifier
            local LOCinstances = DYNFUNnodesWithInstancesOfModifier FUNrollout.LOCobjMod1
            for i = 1 to LOCinstances.count do (setAppData LOCinstances[i] 424 LOCtempFile)
          )
        )

        --- Update Panel
        FUNrollout.BUDYNsave.enabled = false
        FUNrollout.LOCsosStyle       = LOCtempFile
        FUNrollout.LOCsosPath        = LOCtempFile
      )
      else (messagebox DYNuiResourcesErrorsWarnings[16] title:DYNuiResourcesTitlebars[1])
    )
    LOCstream -- return value
  )

  fn DYNFUNsaveSOSasMXinputFile FUNglobalArray FUNelemArray FUNrefStringLabel FUNrefStringModel FUNxFallSwitch FUNinitialChar =
  (
    /* if FUNxFallSwitch is true, apply crossFall otherwise use vertical offset */
    local LOCstream
    --- Get User To Specify Name Of File To Save and Display Name in Rollout Title Bar
    local LOCdefOutPath = if maxFilePath == "" then ((getDir #export) + "\\*.inp") else (maxFilePath + "*.inp")

    local LOCtempFile = getSaveFileName caption:(DYNuiResourcesTitlebars35) filename:LOCdefOutPath types:DYNuiResourcesFileTypes[10]

    if FUNrefStringModel == undefined or FUNrefStringModel == "" then FUNrefStringModel = DYNuiResourcesNodeNames[7]
    if FUNrefStringLabel == undefined or FUNrefStringLabel == "" then FUNrefStringLabel = DYNuiResourcesNodeNames[8]
    if FUNinitialChar    == undefined or FUNinitialChar    == "" then FUNinitialChar    = DYNuiResourcesNodeNames[9]

    if LOCtempFile != undefined then
    (
      --- Create Output File Stream
      LOCstream = try (createFile LOCtempFile) catch ()

      --- Check That Output Stream Was Created
      if LOCstream != undefined then
      (
        --- Write MAJOR OPTION to Input File
        format "DESIGN,%,%\n" FUNrefStringModel FUNrefStringModel to:LOCstream

        --- Write MINOR OPTIONS to Input File
        local LOCcnt = 100

        if FUNxFallSwitch then
        (
          for i in FUNelemArray do
          (
            local LOCsubString = if LOCcnt == 100 then FUNrefStringLabel else (FUNinitialChar + ((LOCcnt - 1) as string))
            /*
              i[4] = Horiz Off Start
              i[5] = Horiz Off End
              i[7] = Vert Off Start
              i[8] = Vert Off End
            */
            --- Calculate Crossfall Value
            local LOCstartXfall = if i[7] != 0.0 and i[4] != 0.0 then (i[7] / i[4]) else 0.0; if LOCstartXfall == 0.0 then (LOCstartXfall = if i[7] == 0.0 then 0.0 else 1.0)
            local LOCendXfall   = if i[8] != 0.0 and i[5] != 0.0 then (i[8] / i[5]) else 0.0; if LOCendXfall   == 0.0 then (LOCendXfall   = if i[8] == 0.0 then 0.0 else 1.0)

            if i[7] == i[8] then    --- IF VERTICAL OFFSET IS CONSTANT ---------------
            (
              if i[4] == i[5] then  --- IF HORIZ OFFSET IS CONSTANT ------------------
              (
                if i[4] != 0.0 then
                (
                  format "100,%,%,%,%,7=%\n"    FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) LOCstartXfall i[4] to:LOCstream -- Add String: Constant H / Constant C
                )
                else
                (
                  format "110,%,%,%,%,7=%\n"    FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[7] i[4]      to:LOCstream -- Add String: Constant H / Constant V
                )
              )
              else                  --- IF HORIZ OFFSET IS NOT CONSTANT --------------
              (
                -- this could be a problem if one horiz offset is zero
                format "101,%,%,%,%,7=%,10=%\n" FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) LOCstartXfall i[4] i[5] to:LOCstream -- Add String: Linear H / Constant C
              )
            )
            else                    --- IF VERTICAL OFFSET IS NOT CONSTANT -----------
            (
              if i[4] == i[5] then  --- IF HORIZ OFFSET IS CONSTANT ------------------
              (
                format "100,%,%,%,7=%\n"        FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[4] to:LOCstream -- Add String: Constant H / Constant C
              )
              else                  --- IF HORIZ OFFSET IS NOT CONSTANT --------------
              (
                format "101,%,%,%,7=%,10=%\n"   FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[4] i[5] to:LOCstream -- Add String: Linear H / Constant C
              )
              if i[4] == 0.0 and i[5] == 0.0 then
              (
                format "121,%,%,%,7=%,10=%\n"     FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[7] i[8]      to:LOCstream -- Amend Levels: Linear Vertical Offset
              )
              else
              (
                -- this could be a problem if one horiz offset is zero
                format "131,%,%,%,7=%,10=%\n"     FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) LOCstartXfall LOCendXfall to:LOCstream -- amend levels: linear crossfall
              )
            )
            LOCcnt += 1
          )
        )
        else
        (
          for i in FUNelemArray do
          (
            local LOCsubString = if LOCcnt == 100 then FUNrefStringLabel else (FUNinitialChar + ((LOCcnt - 1) as string))
            /*
              i[4] = Horiz Off Start
              i[5] = Horiz Off End
              i[7] = Vert Off Start
              i[8] = Vert Off End
            */
            if i[7] == i[8] then    --- IF VERTICAL OFFSET IS CONSTANT ---------------
            (
              if i[4] == i[5] then  --- IF HORIZ OFFSET IS CONSTANT ------------------
              (
                format "110,%,%,%,%,7=%\n"      FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[7] i[4]      to:LOCstream -- Add String: Constant H / Constant V
              )
              else                  --- IF HORIZ OFFSET IS NOT CONSTANT --------------
              (
                format "111,%,%,%,%,7=%,10=%\n" FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[7] i[4] i[5] to:LOCstream -- Add String: Linear H / Constant V
              )
            )
            else                    --- IF VERTICAL OFFSET IS NOT CONSTANT -----------
            (
              if i[4] == i[5] then  --- IF HORIZ OFFSET IS CONSTANT ------------------
              (
                format "110,%,%,%,7=%\n"        FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[4]           to:LOCstream -- Add String: Constant H / Constant V

              )
              else                  --- IF HORIZ OFFSET IS NOT CONSTANT --------------
              (
                format "111,%,%,%,7=%,10=%\n"   FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[4] i[5]      to:LOCstream -- Add String: Linear H / Constant V
              )
              format "121,%,%,%,7=%,10=%\n"     FUNrefStringLabel LOCsubString (FUNinitialChar + (LOCcnt as string)) i[7] i[8]      to:LOCstream -- Amend Levels: Linear Vertical Offset
            )
            LOCcnt += 1
          )
        )

        --- MINOR OPTION 999
        format "%" "999" to:LOCstream

        --- Close FileStream
        close LOCstream
      )
      else (messagebox (DYNuiResourcesErrorsWarnings[77]) title:DYNuiResourcesTitlebars[1])
    )
    LOCstream -- return value
  )

  fn DYNFUNmodifySweptObject FUNobjMod FUNsosGlobalArray FUNsosElemArray FUNrollout FUNrolloutString =
  (
    /* If FUNrollout is undefined, this function will only set up the default values for a new modifier */
    --- Apply Default Values (just in case value from style cannot be read)
    FUNobjMod.total        = FUNsosElemArray.count            -- (Total_Profile_Parameters_to_use) : integer
    FUNobjMod.mapping      = true                             -- (Enable_UV_Mapping) : boolean
    FUNobjMod.mirror       = FUNsosGlobalArray[2]             -- (Mirror_Profile) : boolean
    FUNobjMod.side         = FUNsosGlobalArray[1]             -- : integer
    FUNobjMod.splineIndex  = FUNsosGlobalArray[5]             -- (Spline_Index) : integer

    --- Interp Params Default Values (just in case value from style cannot be read)
    FUNobjMod.threshold    = 5                                -- : float (but always use integer because for Interp Type 3 this represents number of sample points)
    FUNobjMod.maxDist      = 1.0                              -- (Maximum_Distance) : float
    FUNobjMod.spacing      = if FUNsosGlobalArray[10] < 0 then (FUNsosGlobalArray[10] * -1) else (FUNsosGlobalArray[10])-- integer: (negative value if segment by length)
    FUNobjMod.type         = if FUNsosGlobalArray[10] < 0 then 1 else 0 -- (Interpolation_Type) : integer
    FUNobjMod.normalize    = if FUNsosGlobalArray[5] == 0 then true else (if FUNobjMod.type == 0 then false else true)  -- boolean: (negative value if normalised flag is true)

    --- Spanning Surface Default Values (just in case value from style cannot be read)
    FUNobjMod.spanMatID    = FUNsosGlobalArray[7]             -- (Material_ID_Spanning_Surface) : integer
    FUNobjMod.spanVrep     = if FUNsosGlobalArray[3] < 0 then (FUNsosGlobalArray[3] * -1) else (FUNsosGlobalArray[3])   -- (U_Repeat_Spanning_Surface) : float
    FUNobjMod.spanUrep     = FUNsosGlobalArray[6]             -- (V_Repeat_Spanning_Surface) : float
    FUNobjMod.spanMap      = false                            -- (Span_Mapping) : boolean
    FUNobjMod.spanSmg      = 30                               -- (Smoothing_Group_Spanning_Surface) : integer
    FUNobjMod.spanRot      = 0.0                              -- (UV_Rotation) : float
    FUNobjMod.spanOfx      = 0.0                              -- (UV_Offset_X) : float
    FUNobjMod.spanOfy      = 0.0                              -- (UV_Offset_Y) : float
    FUNobjMod.spanFlx      = false                            -- (UV_Flip_X) : boolean
    FUNobjMod.spanFly      = false                            -- (UV_Flip_Y) : boolean

    --- Closing Surface Default Values (just in case value from style cannot be read)
    FUNobjMod.closingMatID = FUNsosGlobalArray[8]             -- (Material_ID_Closing_Surface) : integer
    FUNobjMod.closingVrep  = if FUNsosGlobalArray[3] < 0 then (FUNsosGlobalArray[3] * -1) else (FUNsosGlobalArray[3])-- (U_Repeat_Closing_Surface) : float
    FUNobjMod.closingUrep  = FUNsosGlobalArray[6]             -- (V_Repeat_Closing_Surface) : float
    FUNobjMod.closingSmg   = 31                               -- (Smoothing_Group_Closing_Surface) : integer
    FUNobjMod.closingRot   = 0.0                              -- (UV_Rotation) : float
    FUNobjMod.closingOfx   = 0.0                              -- (UV_Offset_X) : float
    FUNobjMod.closingOfy   = 0.0                              -- (UV_Offset_Y) : float
    FUNobjMod.closingFlx   = false                            -- (UV_Flip_X) : boolean
    FUNobjMod.closingFly   = false                            -- (UV_Flip_Y) : boolean

    --- Capping Surface Default Values (just in case value from style cannot be read)
    FUNobjMod.capmatid     = FUNsosGlobalArray[9]             -- (Capping_Material_ID) : integer
    FUNobjMod.capUrep      = 1.0                              -- (U_Repeat_Capping_Surface) : float
    FUNobjMod.capVrep      = 1.0                              -- (V_Repeat_Capping_Surface) : float
    FUNobjMod.capSmg       = 0                                -- (Smoothing_Group_Cap) : integer
    FUNobjMod.capRot       = FUNsosGlobalArray[11]            -- (Skew Parameter) : float
    FUNobjMod.capOfx       = 0.0                              -- (UV_Offset_X) : float
    FUNobjMod.capOfy       = 0.0                              -- (UV_Offset_Y) : float
    FUNobjMod.capFlx       = false                            -- (UV_Flip_X) : boolean
    FUNobjMod.capFly       = false                            -- (UV_Flip_Y) : boolean

    --- Build Profile Elements
    if FUNrollout != undefined then
    (
      DYNsweptObjects.DYNFUNreadSOSelementArray FUNobjMod FUNsosElemArray.count FUNrollout FUNrolloutString
    )

    FUNobjMod -- return value
  )

  fn DYNFUNaddParentShapeToCurrentArray FUNnewShape =
  (
    undo off
    (
      local LOCproceedSwitch = true

      --- Check that shape is an editable spline - convert if necessary
      DYNFUNcheckIsSplineShape FUNnewShape

      --- If this is the first shape to be selected, set the number of splines into a local variable
      if DYNsweptObjects.LOCparentShapes.count == 0 then
      (
        DYNsweptObjects.LOCnumSplines = FUNnewShape.numSplines
      )

      --- If this parent shape contains a Civil_View_Swept_Object modifier already, it indicates that this shape is one created for previous
      --- creation of a swept object. It only got through the shape selection filter because no elements exist on the profile which means that it shows
      --- up as a shape instead of a geometric object. Prevent this shape from being used.
      if (CVGetMod FUNnewShape Civil_View_Swept_Object) != undefined then
      (
        LOCproceedSwitch = false
        messageBox (DYNuiResourcesErrorsWarnings[78]) title:DYNuiResourcesTitlebars[1]
      )

      --- If this is not the first shape to be selected, check that the number of splines is the same as others already in the array
      if LOCproceedSwitch then
      (
        if DYNsweptObjects.LOCparentShapes.count > 0 then
        (
          if DYNsweptObjects.LOCnumSplines != FUNnewShape.numSplines then
          (
            LOCproceedSwitch = false
            messageBox (DYNFUNformatValueToString DYNuiResourcesErrorsWarnings[79] FUNnewShape.name) title:DYNuiResourcesTitlebars[1]
          )
        )
      )

      --- Set Up Geometry Defaults Depending On Number Of Splines In Parent Shape
      if LOCproceedSwitch then
      (
        if DYNsweptObjects.LOCparentShapes.count == 0 then
        (
          --- If this is the first parent shape to be selected, and number of spline is greater than one, ask if wish to switch to spanning spline geometry mode
          if FUNnewShape.numSplines > 1 and DYNsweptObjects.LOCsosGlobalArray[5] == -1 then
          (
            local LOCmessage = DYNuiResourcesQueries[29]
            LOCmessage += "\n\n"
            LOCmessage += DYNuiResourcesErrorsWarnings[45]
            LOCmessage += "\n\n"
            LOCmessage += DYNuiResourcesErrorsWarnings[46]
            if (querybox LOCmessage title:DYNuiResourcesTitlebars[3]) then
            (
              DYNsweptObjects.LOCsosGlobalArray[5] = 0
              DYNsweptObjects.LOCobjMod1.splineIndex = 0
            )
            else
            (
              DYNsweptObjects.LOCsosGlobalArray[5] = -1
              DYNsweptObjects.LOCobjMod1.splineIndex = -1
            )
          )

          --- If this is the first parent shape to be selected, and number of splines is one, FORCE separated Spline Geometry mode.
          if DYNsweptObjects.LOCnumSplines == 1 then
          (
            DYNsweptObjects.LOCsosGlobalArray[5] = -1
            DYNsweptObjects.LOCobjMod1.splineIndex = -1
          )

          DYNsweptObjects.DYNFUNcloseSpanSettings DYNsweptObjects
          DYNsweptObjects.DYNFUNsosInterpSettings LOCobjMod1 LOCobjMod2 DYNsweptObjects
        )
      )

      --- If above checks were OK, add shape to list then apply instanced modifier to all shapes in list
      if LOCproceedSwitch then
      (
        --- Update Array In Main Rollout
        append DYNsweptObjects.LOCparentShapes FUNnewShape

        --- Update Panel Shapes List
        local LOCshapeDisplayNames = #()
        for i in DYNsweptObjects.LOCparentShapes do (append LOCshapeDisplayNames (i.name + " (" + DYNuiResourcesLabels[452] + (FUNnewShape.numSplines as string) + ")"))
        DYNsweptObjects.MLDYNinstParents.items     = LOCshapeDisplayNames
        DYNsweptObjects.MLDYNinstParents.selection = LOCshapeDisplayNames.count
        DYNsweptObjects.BUDYNremShape.enabled = true

        --- Build Array Of Swept Objects from current list of parent shapes
        DYNFUNloadVSPnodeCallBacks false
        (
          for i in DYNsweptObjects.LOCobjArray do (if isValidNode i then delete i; i = undefined)
          DYNsweptObjects.LOCobjArray = #()
          DYNsweptObjects.LOCobjArray = DYNsweptObjects.DYNFUNcreateSweptObjects DYNsweptObjects.LOCparentShapes DYNsweptObjects.LOCsosStyle DYNsweptObjects.LOCobjMod1 DYNsweptObjects.LOCobjMod2 DYNsweptObjects.LOCmatName (if DYNsweptObjects.LOCsosGlobalArray[3] < 0.0 then true else false)
          setCommandPanelTaskMode mode:#modify
          DYNsweptObjects.dnStatus.text    = DYNuiResourcesStatusMessages[11]

          DYNsweptObjects.DYNFUNreadSOSglobalArray DYNsweptObjects.LOCobjMod1 DYNsweptObjects.LOCobjMod2 DYNsweptObjects.LOCsosGlobalArray DYNsweptObjects
        )
        DYNFUNloadVSPnodeCallBacks true
        DYNFUNnodeCreatedCallback()
        max views redraw
        if DYNsweptObjects.LOCobjArray.count > 0 then (select DYNsweptObjects.LOCobjArray[1])
      )
    )
    LOCobjArray -- return value
  )

  ----------------------------------------------------------------------------------------------------------------------------------------
  fn DYNFUNcreateSweptObjects FUNparentShapeArray FUNparamFile FUNobjMod1 FUNobjMod2 FUNmatName FUNmappingOverride =
  (
    local LOCnewArray = #()

    if FUNparentShapeArray.count > 0 then
    (
      clearUndoBuffer()
      undo off
      (
        local LOCsuccessSwitch = true

        --- Check that specified parent is a shape and that no sos modifier already exists, then check that style is valid
        for i in FUNparentShapeArray do
        (
          DYNFUNcheckIsSplineShape i
          if (ClassOf i.baseObject) != splineshape or (classOf FUNparamFile) != string or (CVGetMod i Civil_View_Swept_Object) != undefined then (LOCsuccessSwitch = false)
        )

        --- If Shapes are Valid, add Instanced Modifier to All of Them
        if LOCsuccessSwitch then
        (
          for i in FUNparentShapeArray do
          (
            --- Define Material ----------------
            local LOCmaterial
            if FUNmatName == DYNmatNameRails then
            (
              LOCmaterial = if sceneMaterials[DYNmatNameRails]    != undefined then sceneMaterials[DYNmatNameRails] else (DYNFUNmakeCivilViewRails (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\"))
            )
            else
            (
              LOCmaterial = if scenematerials[DYNmatNameSurfaces] != undefined then scenematerials[DYNmatNameSurfaces] else (DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))
            )

            --- Create a referenced clone of the parent shape for each spline in the object (Remember that the "New Parent Shape" routine in DYNsosParams doesn't use this section, so if it changes update that too....)
            local LOCnamePart       = getAppData i 427 ; if LOCnamePart == undefined then LOCnamePart = i.name
            local LOCnewNode        = DYNFUNmakeReferenceWithoutMatPropogation i LOCmaterial
            LOCnewNode.name         = uniqueName (DYNuiResourcesNodeNames[10])
            LOCnewNode.backFaceCull = false
            LOCnewNode.wireColor    = color 85 225 150

            --- Apply Base Xform Modifier to New Shape
            /*
            This modifier forms no purpose except to act as a barrier to prevent the conversion of this parent shape from
            a reference of the host shape to an instance of the host shape. Without this modifier being added, Civil_View_Divide_Spline is applied to the
            host shape. Problem can be demonstrated using this script:

                -- create two circles, with the second circle (r) being a reference
                -- of the first circle (q)
                q = circle pos:[0,0,0] radius:10
                r = reference q
                r.pos = [30,0,0]

                -- now add dummy modifier to reference
                addModifier r (xform())

                -- now create an extrude modifier
                s = extrude amount:10

                -- add the modifier to circle r (because this is a reference,
                -- the modifier is *not* applied to circle q)
                addModifier r s

                -- now this is where things start getting weird...
                -- remove the modifier from circle r, then add it again
                deleteModifier r s
                addModifier r s

                -- The result is that on the second application of the modifier to circle r, the modifier is
                -- also applied to circle q, which should not happen as r is a reference of q, not an instance.
                -- Why is the behaviour different (and incorrect) on the second attempt?

                -- Response on max forum on 13-07-2006 from Dave Stewart:
                -- I seem to recall I had the same problem as this a couple of years ago. I got round it in the end by adding an
                -- intermediate modifier (an XForm, for example) at the base of the reference's stack which I NEVER removed.
                -- This way, the object maintained it's relationship as a reference, and in the track view, you could clearly
                -- see the "Modified Object" node of the tree with the modifiers below.
            */
            addmodifier LOCnewNode (xform())

            --- Apply standard SOS Modifiers to New Shape
            if FUNobjMod1.splineIndex == 0 then addmodifier LOCnewNode FUNobjMod2
            addmodifier LOCnewNode FUNobjMod1

            --- Apply AppData to new SOS Object
            DYNFUNgenObjAppData LOCnewNode 9 (FUNobjMod1.spanMatID as string) (if ((getfiles FUNparamFile).count > 0) then FUNparamFile else "") (DYNFUNgetLocalTime()) (if FUNmappingOverride then "1" else "0") (FUNobjMod1.capMatID as string) (FUNobjMod1.closingMatID as string)

            --- Add to Main Civil View Object Handle Arrays
            if isValidNode LOCnewNode then
            (
              append DYNobjHandles[9] LOCnewNode.inode.handle
              append LOCnewArray LOCnewNode
            )
            /* New sos will have been automatically added to DYNobjHandles[17] when shape was first created, but it is now also in DYNobjHandles[9]. Delete it from DYNobjHandles[17] */
            local LOCfind = findItem DYNobjHandles[17] LOCnewNode.inode.handle; if LOCfind > 0 then deleteItem DYNobjHandles[17] LOCfind
          )
        )
      )
    )

    LOCnewArray -- return value
  )

  fn DYNFUNdisplayMatList FUNmatName =
  (
    if FUNmatName == DYNmatNameSurfaces then DYNsweptObjects.LOCmatIDarray = DYNFUNgetMatChannelNames (if sceneMaterials[DYNmatNameSurfaces] != undefined then sceneMaterials[DYNmatNameSurfaces] else (DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\"))) true true DYNINImatIDlimit
    if FUNmatName == DYNmatNameRails    then DYNsweptObjects.LOCmatIDarray = DYNFUNgetMatChannelNames (if sceneMaterials[DYNmatNameRails]    != undefined then sceneMaterials[DYNmatNameRails] else (DYNFUNmakeCivilViewRails (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\"))) true true DYNINImatIDlimit
    DYNsweptObjects.DDDYNelemMat.items     = DYNsweptObjects.LOCmatIDarray
    DYNsweptObjects.DDDYNspanMatID.items   = DYNsweptObjects.LOCmatIDarray
    DYNsweptObjects.DDDYNcloseMatID.items  = DYNsweptObjects.LOCmatIDarray
    DYNsweptObjects.DDDYNcapMatID.items    = DYNsweptObjects.LOCmatIDarray
  )

  ---SECTION 3 - DEFINE PANEL LAYOUT---
  button BUDYNnew               pos:[18,8]  iconName:"CivilView/NewFile" width:28 height:28 tooltip:DYNuiResourcesTooltips[4]
  button BUDYNfile              pos:[48,8]  iconName:"CivilView/Open" width:28 height:28 tooltip:DYNuiResourcesTooltips[5]
  button BUDYNsave              pos:[78,8]  iconName:"Common/Save" width:28 height:28 tooltip:DYNuiResourcesTooltips[6]
  button BUDYNadd               pos:[113,8] iconName:"CivilView/NewElement" width:28 height:28 tooltip:DYNuiResourcesTooltips[7]
  button BUDYNrem               pos:[143,8] iconName:"CivilView/Delete" width:28 height:28 tooltip:DYNuiResourcesTooltips[8]
  button BUDYNup                pos:[178,8] iconName:"CivilView/ElemUp" width:28 height:28 tooltip:DYNuiResourcesTooltips[9]
  button BUDYNdown              pos:[208,8] iconName:"CivilView/ElemDown" width:28 height:28 tooltip:DYNuiResourcesTooltips[10]
  button BUDYNcut               pos:[243,8] iconName:"Common/Cut" width:28 height:28 tooltip:DYNuiResourcesTooltips[11]
  button BUDYNcopy              pos:[273,8] iconName:"Common/Copy" width:28 height:28 tooltip:DYNuiResourcesTooltips[12]
  button BUDYNpaste             pos:[303,8] iconName:"Common/Paste" width:28 height:28 tooltip:DYNuiResourcesTooltips[13]

  button BUDYNmaterial          pos:[589,8] iconName:"CivilView/MaterialA" width:28 height:28 tooltip:DYNuiResourcesTooltips[16]
  button BUDYNreset             pos:[619,8] iconName:"CivilView/Reset" width:28 height:28 tooltip:DYNuiResourcesTooltips[14]

  pickbutton PKDYNimport        pos:[444,8] width:143 height:28 filter:DYNFUNshapeFilter tooltip:DYNuiResourcesTooltips[17]

  dotNetControl  dnElements "System.Windows.Forms.ListView" height:162 width:426 pos:[16,40]
  dotNetControl  dnStatus   "System.Windows.Forms.StatusBar" height:20 width:630 pos:[17,500]

  ---Element Editor Group
  groupBox GBDYNgroup01         pos:[452,40] width:195 height:339
  label LBDYNhOffStart          pos:[460,62]  align:#left
  spinner SPDYNhOffStart        pos:[554,60]  range:[-9999,9999,0]   scale:0.1  fieldwidth:54 type:#worldunits
  label LBDYNhOffEnd            pos:[460,83]  align:#left
  spinner SPDYNhOffEnd          pos:[554,81]  range:[-9999,9999,0]   scale:0.1  fieldwidth:54 type:#worldunits

  spinner SPDYNvOffStart        pos:[554,107] range:[-9999,9999,0]   scale:0.1  fieldwidth:54 type:#worldunits
  label LBDYNvOffStart          pos:[460,109] align:#left
  spinner SPDYNvOffEnd          pos:[554,128] range:[-9999,9999,0]   scale:0.1  fieldwidth:54 type:#worldunits
  label LBDYNvOffEnd            pos:[460,130] align:#left

  spinner SPDYNxFallStart       pos:[554,154] range:[-10.0,10.0,0] scale:0.025 fieldwidth:54 type:#float
  label LBDYNxFallStart         pos:[460,156] align:#left
  spinner SPDYNxFallEnd         pos:[554,175] range:[-10.0,10.0,0] scale:0.025 fieldwidth:54 type:#float
  label LBDYNxFallEnd           pos:[460,177] align:#left

  checkbutton CBDYNlockHorOff   pos:[624,70]  align:#left  iconName:"Common/Lock" iconSize:[16,16] width:16 height:18 highlightColor:DYNINIhighlightColor checked:true
  checkbutton CBDYNlockVerOff   pos:[624,117] align:#left  iconName:"Common/Lock" iconSize:[16,16] width:16 height:18 highlightColor:DYNINIhighlightColor checked:true
  checkbutton CBDYNuseXfallStart pos:[624,153] align:#left iconName:"Common/Lock" iconSize:[16,16] width:16 height:18 highlightColor:DYNINIhighlightColor
  checkbutton CBDYNuseXfallEnd  pos:[624,174] align:#left  iconName:"Common/Lock" iconSize:[16,16] width:16 height:18 highlightColor:DYNINIhighlightColor

  groupBox GBDYNelemMat         pos:[460,198] align:#left width:179 height:173
  checkbox CKDYNinherited       pos:[465,217] align:#left width:169
  checkbox CKDYNelemMatOn       pos:[465,241] align:#left
  dropdownlist DDDYNelemMat     pos:[507,238] align:#left width:125
  checkbox CKDYNelemFlip        pos:[465,265] align:#left width:169

  label LBDYNuRepeat            pos:[465,290] align:#left
  label LBDYNvRepeat            pos:[465,310] align:#left
  label LBDYNuvRotation         pos:[465,330] align:#left
  label LBDYNsmoothGroup        pos:[465,350] align:#left
  spinner SPDYNvRepeat          pos:[554,288] range:[0.01,99999,10] scale:0.1  fieldwidth:50 type:#worldunits
  spinner SPDYNuRepeat          pos:[554,308] range:[0.01,99999,0]  scale:0.01 fieldwidth:50 type:#worldunits
  spinner SPDYNuvRotation       pos:[554,328] range:[-360,360,0]    scale:1.0  fieldwidth:50 type:#float
  spinner SPDYNsmoothGroup      pos:[554,348] range:[0,32,0]                   fieldwidth:50 type:#integer

  button BUDYNresetVtile        pos:[619,288] align:#left width:14 height:16
  button BUDYNresetUtile        pos:[619,308] align:#left width:14 height:16
  button BUDYNresetUVrot        pos:[619,328] align:#left width:14 height:16
  button BUDYNresetSmooth       pos:[619,348] align:#left width:14 height:16

  ---Host Params Group
  multilistBox MLDYNinstParents pos:[17,240] width:168 height:2
  pickButton PKDYNpickShape     pos:[17,211] width:125 height:22 filter:DYNFUNshapeFilter
  button BUDYNpickByName        pos:[143,211] width:22  height:22 iconName:"CivilView/SelectName"
  button BUDYNremShape          pos:[166,211] width:18  height:22

  button BUDYNbuildShape        pos:[192,211] width:251 height:34

  groupBox GBDYNgroup02         pos:[17,275] width:167 height:76
  radiobuttons RBDYNinterpType  pos:[25,293]  align:#left width:153 columns:1 labels:#(DYNuiResourcesLabels[73] , DYNuiResourcesLabels[74])
  label LBDYNspacing            pos:[25,330]  align:#left
  spinner SPDYNspacing          pos:[120,329] range:[2,9999,25] fieldwidth:45 type:#integer scale:1

  groupBox GBDYNgroup03         pos:[17,355] width:167 height:110
  radiobuttons RBDYNelemSide    pos:[25,372]  align:#left width:153 columns:3 labels:#(DYNuiResourcesLabels[16], DYNuiResourcesLabels[17], DYNuiResourcesLabels[18])
  checkbox CKDYNelemMirror      pos:[25,390] width:151
  radiobuttons RBDYNmultiSpline pos:[25,408]  align:#left width:153 columns:1 labels:#(DYNuiResourcesLabels[69], DYNuiResourcesLabels[70])
  label LBDYNskew               pos:[25,444]  align:#left
  spinner SPDYNskew             scale:1 pos:[120,443] range:[-60.0,60.0,0.0] fieldwidth:45 type:#float

  ---Swept Object Parameters Group
  groupBox GBDYNspanning        pos:[192,249] width:251 height:69
  checkbox CKDYNspanning        pos:[200,272] align:#left checked:true
  dropdownlist DDDYNspanMatID   pos:[247,269] width:191 items:#()
  checkbox CKDYNflipSpanning    pos:[200,295] align:#left checked:false

  groupBox GBDYNclosing         pos:[192,323] width:251 height:69
  checkbox CKDYNclosing         pos:[200,346] align:#left checked:true
  dropdownlist DDDYNcloseMatID  pos:[247,343] width:191 items:#()
  checkbox CKDYNflipClosing     pos:[200,369] align:#left checked:false

  groupbox GBDYNcapping         pos:[192,396] width:251 height:69
  checkbox CKDYNcapping         pos:[200,419] align:#left checked:true
  dropdownlist DDDYNcapMatID    pos:[247,416] width:191 items:#()
  checkbox CKDYNflipCapping     pos:[200,442] align:#left checked:false

  groupbox GBDYNmapping         pos:[452,383] width:195 height:110
  label LBDYNvRepGlobal         pos:[460,405] align:#left width:75
  label LBDYNuRepGlobal         pos:[460,425] align:#left width:75
  label LBDYNuvRotGlobal        pos:[460,445] align:#left width:75
  spinner SPDYNvRepGlobal       pos:[554,403] fieldWidth:54 type:#worldunits scale:0.1  range:[0,99999,1.0]
  spinner SPDYNuRepGlobal       pos:[554,423] fieldWidth:54 type:#worldunits scale:0.01 range:[0,99999,1.0]
  spinner SPDYNuvRotGlobal      pos:[554,443] fieldWidth:54 type:#float scale:1.0  range:[-360,360,0.0]
  button BUDYNresetVGlobal      pos:[624,403] align:#left width:14 height:16
  button BUDYNresetUGlobal      pos:[624,423] align:#left width:14 height:16
  button BUDYNresetRotGlobal    pos:[624,443] align:#left width:14 height:16
  checkbox CKDYNuseGlobalUV     pos:[460,467] align:#left width:157

  button BUDYNhelp              pos:[17,472] width:97 align:#left
  button BUDYNokok              pos:[182,472] width:97 align:#left
  button BUDYNcanc              pos:[348,472] width:97 align:#left

  ---SECTION 4 - DEFINE PANEL ACTIONS---
  on DYNsweptObjects open do
  (
    DYNsweptObjects.title     = DYNuiRolloutNames[56]

    GBDYNspanning.text        = DYNuiResourcesGroups[11]
    GBDYNclosing.text         = DYNuiResourcesGroups[10]
    GBDYNcapping.text         = DYNuiResourcesGroups[12]
    GBDYNmapping.text         = DYNuiResourcesGroups[13]
    GBDYNgroup01.text         = DYNuiResourcesGroups[17]
    GBDYNgroup02.text         = DYNuiResourcesGroups[128]
    GBDYNgroup03.text         = DYNuiResourcesGroups[129]
    GBDYNelemMat.text         = DYNuiResourcesGroups[16]


    CKDYNelemMatOn.text       = DYNuiResourcesLabels[22]
    CKDYNinherited.text       = DYNuiResourcesLabels[68]
    CKDYNelemFlip.text        = DYNuiResourcesLabels[62]
    LBDYNsmoothGroup.text     = DYNuiResourcesLabels[63]
    CKDYNuseGlobalUV.text     = DYNuiResourcesLabels[67]
    CKDYNelemMirror.text      = DYNuiResourcesLabels[66]
    LOCsegmentDesc            = #(DYNuiResourcesLabels[71], DYNuiResourcesLabels[72])
    LBDYNspacing.text         = LOCsegmentDesc[1]
    CKDYNclosing.text         = DYNuiResourcesLabels[22]
    CKDYNcapping.text         = DYNuiResourcesLabels[22]
    CKDYNspanning.text        = DYNuiResourcesLabels[22]
    CKDYNflipSpanning.text    = DYNuiResourcesLabels[76]
    CKDYNflipClosing.text     = DYNuiResourcesLabels[75]
    CKDYNflipCapping.text     = DYNuiResourcesLabels[77]
    LBDYNhOffStart.text       = DYNuiResourcesLabels[3]
    LBDYNhOffEnd.text         = DYNuiResourcesLabels[4]
    LBDYNvOffStart.text       = DYNuiResourcesLabels[5]
    LBDYNvOffEnd.text         = DYNuiResourcesLabels[6]
    LBDYNxFallStart.text      = DYNuiResourcesLabels[7]
    LBDYNxFallEnd.text        = DYNuiResourcesLabels[8]
    LBDYNuRepGlobal.text      = DYNuiResourcesLabels[59]
    LBDYNvRepGlobal.text      = DYNuiResourcesLabels[58]
    LBDYNuvRotGlobal.text     = DYNuiResourcesLabels[60]
    LBDYNuRepeat.text         = DYNuiResourcesLabels[58]
    LBDYNvRepeat.text         = DYNuiResourcesLabels[59]
    LBDYNuvRotation.text      = DYNuiResourcesLabels[60]
    LBDYNskew.text            = DYNuiResourcesLabels[61]

    BUDYNresetVtile.text      = DYNuiResourcesButtons[36]
    BUDYNresetUtile.text      = DYNuiResourcesButtons[36]
    BUDYNresetUVrot.text      = DYNuiResourcesButtons[36]
    BUDYNresetSmooth.text     = DYNuiResourcesButtons[36]
    BUDYNresetUGlobal.text    = DYNuiResourcesButtons[36]
    BUDYNresetVGlobal.text    = DYNuiResourcesButtons[36]
    BUDYNresetRotGlobal.text  = DYNuiResourcesButtons[36]
    PKDYNimport.text          = DYNuiResourcesButtons[105]
    BUDYNbuildShape.text      = DYNuiResourcesButtons[38]
    BUDYNremShape.text        = DYNuiResourcesButtons[22]
    PKDYNpickShape.text       = DYNuiResourcesButtons[39]
    BUDYNokok.text            = DYNuiResourcesButtons[1]
    BUDYNcanc.text            = DYNuiResourcesButtons[7]
    BUDYNhelp.text            = DYNuiResourcesButtons[5]

    dnStatus.text             = DYNuiResourcesStatusMessages[15]

    DYNFUNresizeSOSeditor DYNdefRLsizeSOS
    LOCorigCommandPanelMode   = getCommandPanelTaskMode()

    --- Initialise Global Array Values - must be before modifier is created and must be in "On Open" because array is initialised "On Close"
    LOCsosGlobalArray         = #(0,false,DYNsosVtileDefault,0.0,-1,DYNsosUtileDefault,18,22,22,25,0.0)

    --- CREATE REFERENCE TO NEW MODIFIERS
    LOCobjMod1                = (Civil_View_Swept_Object ui:On total:LOCsosElemArray.count)
    LOCobjMod2                = (Civil_View_Divide_Spline ui:On)

    DYNFUNmodifySweptObject LOCobjMod1 LOCsosGlobalArray LOCsosElemArray DYNsweptObjects "DYNsweptObjects"
    DYNFUNmodifyDivider LOCobjMod2 LOCobjMod1.spacing LOCobjMod1.normalize

    --- Create Reference To Material Definition
    DYNFUNdisplayMatList LOCmatName
    DDDYNspanMatID.selection  = 18
    DDDYNcloseMatID.selection = 22
    DDDYNcapMatID.selection   = 22

    SPDYNuRepGlobal.value     = LOCsosGlobalArray[6]
    SPDYNvRepGlobal.value     = if LOCsosGlobalArray[3] < 0 then (LOCsosGlobalArray[3] * -1) else (LOCsosGlobalArray[3])
    SPDYNuvRotGlobal.value    = LOCsosGlobalArray[4]
    SPDYNskew.value           = 0.0
    SPDYNvRepeat.value        = DYNsosVtileDefault
    SPDYNuRepeat.value        = DYNsosUtileDefault
    BUDYNsave.enabled         = false
    BUDYNup.enabled           = false
    BUDYNdown.enabled         = false
    BUDYNrem.enabled          = false
    BUDYNcut.enabled          = false
    BUDYNcopy.enabled         = false
    BUDYNpaste.enabled        = false
    RBDYNelemSide.state       = DYNFUNsideSettings LOCsosGlobalArray
    CKDYNelemMirror.checked   = LOCsosGlobalArray[2]
    RBDYNmultiSpline.state    = if LOCsosGlobalArray[5] == 0 then 2 else 1

    DYNsweptObjects.DYNFUNcloseSpanSettings DYNsweptObjects

    --- dotNet ListView Init
    DYNFUNdnListViewStyle dnElements false true
    dnElements.multiSelect        = false
    dnElements.AllowColumnReorder = false
    dnElements.sorting            = DYNdnSortOrderClass.none
    dnElements.smallImageList     = DYNdnSmImageList
    local LOCcol1 = dnElements.Columns.add DYNuiResourcesLvColumns[24] 146; LOCcol1.textAlign = DYNdnHorAlignClass.center
    local LOCcol2 = dnElements.Columns.add DYNuiResourcesLvColumns[25]  54; LOCcol2.textAlign = DYNdnHorAlignClass.center
    local LOCcol3 = dnElements.Columns.add DYNuiResourcesLvColumns[26]  50; LOCcol3.textAlign = DYNdnHorAlignClass.center
    local LOCcol4 = dnElements.Columns.add DYNuiResourcesLvColumns[27]  54; LOCcol4.textAlign = DYNdnHorAlignClass.center
    local LOCcol5 = dnElements.Columns.add DYNuiResourcesLvColumns[28]  50; LOCcol5.textAlign = DYNdnHorAlignClass.center
    local LOCcol6 = dnElements.Columns.add DYNuiResourcesLvColumns[29]  48; LOCcol6.textAlign = DYNdnHorAlignClass.center

    --- Set up defualt Path for POS files
    LOCsosPath                     = DYNlocalSosPath

    DYNsweptObjects.DYNFUNbuildSOSelementList  LOCobjMod1.total DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNupdateSOSelementList LOCobjMod1.total DYNsweptObjects "DYNsweptObjects"

    --- Check to see if any shapes are selected when entering this panel
    if selection.count == 1 then
    (
      if DYNFUNshapeFilter selection[1] then
      (
        if queryBox (DYNuiResourcesQueries[43] + "\n\n" + DYNuiResourcesQueries[44]) title:DYNuiResourcesTitlebars[3] then (DYNFUNaddParentShapeToCurrentArray selection[1]) else clearSelection()
      )
      else clearSelection()
    )
    else clearSelection()
  )

  on DYNsweptObjects close do
  (
    if DYNbuildShape.open then destroyDialog DYNbuildShape

    --- Remove Highlighting
    if LOCobjMod1 != undefined then
    (
      setCommandPanelTaskMode mode:LOCorigCommandPanelMode
      LOCobjMod1.highlight = 0
    )

    --- Check to see if style has been saved
    if DYNsweptObjects.BUDYNsave.enabled == true then
    (
      setFocus DYNsweptObjects.BUDYNcanc
      local LOCstate
      LOCstate = queryBox DYNuiResourcesQueries[3] title:DYNuiResourcesTitlebars[2] beep:false
      if LOCstate then (DYNFUNsaveSOSfile LOCsosGlobalArray LOCsosElemArray DYNsweptObjects)
    )

    --- If a Swept Object has been created but contains no element geometry, delete it now
    local LOCnullSOSexists = false
    for i in LOCobjArray do
    (
     if isValidNode i then
     (
       if classOf i == splineShape then
       (
         delete i
         LOCnullSOSexists = true
       )
     )
    )

    --- Check To See If Any MultiSpline Shapes Were Built In This Session - If So, Delete Them (They Are No Longer Required)
    if LOCnullSOSexists then
    (
      for i in LOCbuiltShapes do
      (
        if isValidNode i then delete i
      )

    )
    LOCbuiltShapes = #()

    --- Do remaining close down operations
    LOCobj            = undefined
    LOCobjArray       = #()
    LOCobjMod1        = undefined
    LOCsosGlobalArray = #()
    LOCsosElemBuffer  = #()
    LOCsosElemArray   = #()
    LOCxFallLockArray = #()
    LOCmatIDarray     = #()
    dnElements.Items.clear()
    enableSceneRedraw()
    DYNFUNonDialogClose()

    DYNFUNnodeCreatedCallback() -- will check arrays for invalid node handles, then update Explorer Tree
  )

  on DYNsweptObjects resized argPt2 do
  (
    DYNFUNresizeSOSeditor argPt2
  )

  on DYNsweptObjects moved argPt2 do
  (
    DYNsosLUP = argPt2
  )

  on PKDYNpickShape picked arg do
  (
    if (findItem LOCparentShapes arg) == 0 then
    (
      DYNFUNaddParentShapeToCurrentArray arg
    )
    else messagebox DYNuiResourcesErrorsWarnings[13] title:DYNuiResourcesTitlebars[1]
  )

  on BUDYNpickByName pressed do
  (
    local LOCparentArray = selectByName title:(DYNuiResourcesTitlebars[29]) showHidden:false single:false filter:DYNFUNshapeFilter
    if LOCparentArray != undefined then
    (
      for i in LOCparentArray do
      (
        if (findItem LOCparentShapes i) == 0 then
        (
          DYNFUNaddParentShapeToCurrentArray i
        )
        else messagebox (i.name + "\n\n" + DYNuiResourcesErrorsWarnings[13]) title:DYNuiResourcesTitlebars[1]
      )
    )
  )

  on BUDYNremShape pressed do
  (
    if MLDYNinstParents.selection != 0 then
    (
      --- Update Panel SHape List
      local LOClistSelected = #()
      for i = 1 to MLDYNinstParents.selection.count do (if MLDYNinstParents.selection[i] == true then (append LOClistSelected i))
      for i = LOClistSelected.count to 1 by -1 do deleteItem LOCparentShapes LOClistSelected[i]

      --- Update Parent Shape List
      local LOCshapeDisplayNames = #()
      if LOCparentShapes.count > 0 then
      (
        for i in LOCparentShapes do (if isValidNode i then (append LOCshapeDisplayNames (i.name + "(" + DYNuiResourcesLabels[452] + (i.numSplines as string) + ")")))
        MLDYNinstParents.items     = LOCshapeDisplayNames
        MLDYNinstParents.selection = LOCshapeDisplayNames.count
      )
      else
      (
        MLDYNinstParents.items     = #()
        MLDYNinstParents.selection = #{}
        BUDYNremShape.enabled      = false
      )

      if LOCparentShapes.count > 0 then
      (
        for i = LOCparentShapes.count to 1 by -1 do (if isDeleted LOCparentShapes[i] then deleteItem LOCparentShapes i)
      )

      --- Build Array Of Swept Objects from current list of parent shapes
      DYNFUNloadVSPnodeCallBacks false
      (
        for i in LOCobjArray do (if isValidNode i then delete i; i = undefined)
        LOCobjArray = #()
        LOCobjArray = DYNFUNcreateSweptObjects LOCparentShapes LOCsosStyle LOCobjMod1 LOCobjMod2 LOCmatName (if LOCsosGlobalArray[3] < 0.0 then true else false)
        setCommandPanelTaskMode mode:#modify
        dnStatus.text    = DYNuiResourcesStatusMessages[11]
      )
      DYNFUNloadVSPnodeCallBacks true
      DYNFUNnodeCreatedCallback()
      max views redraw
      select LOCobjArray
    )
  )

  on BUDYNbuildShape pressed do
  (
    createDialog DYNbuildShape width:587 height:185 pos:((getDialogPos DYNsweptObjects) + [100,100])
  )

  ---- SOS STYLE OPEN/Save/NEW CONTROLS -----------------------------------------------------------------------------------------------------------------------------
  on BUDYNnew pressed do
  (
    local LOCsaveSwitch = #no
    if BUDYNsave.enabled == true then
    (
      LOCsaveSwitch = YesNoCancelBox DYNuiResourcesQueries[3] title:DYNuiResourcesTitlebars[3] beep:false
    )
    if LOCsaveSwitch == #yes then DYNFUNsaveSOSfile LOCsosGlobalArray LOCsosElemArray DYNsweptObjects
    if LOCsaveSwitch == #no or LOCsaveSwitch == #yes then
    (
      LOCsosGlobalArray = #(0,false,DYNsosVtileDefault,0.0,-1,DYNsosUtileDefault,18,22,22,25,0.0)
      DYNFUNreadSOSglobalArray LOCobjMod1 LOCobjMod2 LOCsosGlobalArray DYNsweptObjects

      LOCsosElemArray   = #()
      LOCxFallLockArray = #()

      DYNFUNreadSOSelementArray LOCobjMod1 LOCsosElemArray.count DYNsweptObjects "DYNsweptObjects"

      LOCsosStyle = ""
      for i in LOCobjArray do (if isValidNode i then (setAppData i 424 LOCsosStyle))

      BUDYNsave.enabled  = false
      DYNsweptObjects.title = DYNuiRolloutNames[56]
    )
    gc()
  )

  --- SOS Style Params
  on BUDYNsave pressed do (DYNFUNsaveSOSfile LOCsosGlobalArray LOCsosElemArray DYNsweptObjects)
  on BUDYNfile pressed do
  (
    local LOCsaveSwitch = #no
    local LOCtempFile = LOCsosStyle
    if BUDYNsave.enabled == true then (LOCsaveSwitch = YesNoCancelBox DYNuiResourcesQueries[3] title:DYNuiResourcesTitlebars[3] beep:false)
    if LOCsaveSwitch == #yes then DYNFUNsaveSOSfile LOCsosGlobalArray LOCsosElemArray DYNsweptObjects
    if LOCsaveSwitch == #no or LOCsaveSwitch == #yes then
    (
      LOCtempFile = DYNFUNgetOpenFileName "SOS" LOCsosPath LOCresourceKitMode false
      DYNFUNopenSOSfile LOCtempFile DYNfileSelectorKitMode
    )
    gc()
  )

  on BUDYNadd pressed do (DYNFUNaddSOSelement())

  on BUDYNrem pressed do
  (
    if LOCobjMod1.total != 0 and LOCselectedLVitem != 0 then
    (
      BUDYNsave.enabled = true
      deleteItem LOCsosElemArray LOCselectedLVitem
      deleteItem LOCxFallLockArray LOCselectedLVitem
      DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 (if (LOCobjMod1.total == LOCselectedLVitem) then (LOCselectedLVitem - 1) else (LOCselectedLVitem)) DYNsweptObjects "DYNsweptObjects"
    )
    setFocus dnElements
  )

  on BUDYNup pressed do
  (
    if LOCselectedLVitem != 0 then
    (
      if LOCselectedLVitem != 1 then
      (
        local LOCitemToMove1 = LOCsosElemArray[LOCselectedLVitem]
        deleteItem LOCsosElemArray LOCselectedLVitem
        insertItem LOCitemToMove1 LOCsosElemArray (LOCselectedLVitem - 1)

        local LOCitemToMove2 = LOCxFallLockArray[LOCselectedLVitem]
        deleteItem LOCxFallLockArray LOCselectedLVitem
        insertItem LOCitemToMove2 LOCxFallLockArray (LOCselectedLVitem - 1)

        DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 (LOCselectedLVitem - 1) DYNsweptObjects "DYNsweptObjects"
        setFocus dnElements
      )
    )
  )

  on BUDYNdown pressed do
  (
    if LOCselectedLVitem != 0 then
    (
      if LOCselectedLVitem != LOCsosElemArray.count then
      (
        local LOCitemToMove1 = LOCsosElemArray[LOCselectedLVitem]
        deleteItem LOCsosElemArray LOCselectedLVitem
        insertItem LOCitemToMove1 LOCsosElemArray (LOCselectedLVitem + 1)

        local LOCitemToMove2 = LOCxFallLockArray[LOCselectedLVitem]
        deleteItem LOCxFallLockArray LOCselectedLVitem
        insertItem LOCitemToMove2 LOCxFallLockArray (LOCselectedLVitem + 1)

        DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 (LOCselectedLVitem + 1) DYNsweptObjects "DYNsweptObjects"
        setFocus dnElements
      )
    )
  )

  on BUDYNcut pressed do
  (
    if LOCselectedLVitem != 0 then
    (
      BUDYNpaste.enabled = true
      LOCsosElemBuffer.count = LOCsosElemArraySize; for i = 1 to LOCsosElemArray[LOCselectedLVitem].count do LOCsosElemBuffer[i] = copy LOCsosElemArray[LOCselectedLVitem][i]
      LOCxFallLockBuffer = LOCxFallLockArray[LOCselectedLVitem]

      BUDYNsave.enabled = true
      deleteItem LOCsosElemArray LOCselectedLVitem
      deleteItem LOCxFallLockArray LOCselectedLVitem

      DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 (if (LOCobjMod1.total == LOCselectedLVitem) then (LOCselectedLVitem - 1) else (LOCselectedLVitem)) DYNsweptObjects "DYNsweptObjects"
      setFocus dnElements
    )
  )

  on BUDYNcopy pressed do
  (
    if LOCselectedLVitem != 0 then
    (
      BUDYNpaste.enabled = true
      LOCsosElemBuffer.count = LOCsosElemArraySize; for i = 1 to LOCsosElemArray[LOCselectedLVitem].count do LOCsosElemBuffer[i] = copy LOCsosElemArray[LOCselectedLVitem][i]
      LOCxFallLockBuffer = LOCxFallLockArray[LOCselectedLVitem]
      setFocus dnElements
    )
  )

  on BUDYNpaste pressed do
  (
    if LOCobjMod1.total < 32 then
    (
      if LOCsosElemBuffer.count > 0 then
      (
        local LOCelement = #(); LOCelement.count = LOCsosElemArraySize
        if LOCselectedLVitem != 0 and LOCsosElemArray.count > 0 then
        (
          insertItem LOCelement         LOCsosElemArray   LOCselectedLVitem
          insertItem LOCxFallLockBuffer LOCxFallLockArray LOCselectedLVitem

          for i = 1 to LOCsosElemArray[LOCselectedLVitem].count do LOCsosElemArray[LOCselectedLVitem][i] = copy LOCsosElemBuffer[i]
          DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
        )
        else
        (
          append LOCsosElemArray   LOCelement
          append LOCxFallLockArray LOCxFallLockBuffer
          for i = 1 to LOCsosElemArray[LOCsosElemArray.count].count do LOCsosElemArray[LOCsosElemArray.count][i] = copy LOCsosElemBuffer[i]
          DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 LOCsosElemArray.count DYNsweptObjects "DYNsweptObjects"
        )
        setFocus dnElements
      )
    )
    else messageBox (DYNuiResourcesErrorsWarnings[75]) title:DYNuiResourcesTitlebars[1]
  )

  on PKDYNimport picked arg do
  (
    local LOCelems = DYNsweptObjects.DYNFUNsosElemsFromShape arg #(LOCdefElemField01, LOCdefElemField02, LOCdefElemField03, LOCdefElemField04, LOCdefElemField05, LOCdefElemField06, LOCdefElemField07, LOCdefElemField08, LOCdefElemField09, LOCdefElemField10)
    if LOCelems.count > 33 then
    (
      messagebox (DYNuiResourcesErrorsWarnings[80]) title:DYNuiResourcesTitlebars[1]
    )
    else
    (
      if LOCelems.count > 0 then
      (
        BUDYNsave.enabled = true
        LOCsosElemArray = LOCelems
        LOCxFallLockArray.count = LOCsosElemArray.count; for i = 1 to LOCxFallLockArray.count do LOCxFallLockArray[i] = false
        DYNFUNreadSOSelementArray LOCobjMod1 LOCsosElemArray.count DYNsweptObjects "DYNsweptObjects"
      )
    )
  )

  on dnElements ItemSelectionChanged arg do
  (
    if arg.isSelected and LOCallowDnSelection then
    (
      LOCselectedLVitem             = arg.ItemIndex + 1
      LOCdefaultSpanCloseCapElem[4] = if LOCsosElemArray[LOCselectedLVitem][10] != 0 then LOCsosElemArray[LOCselectedLVitem][10] else 22
      DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
    )
  )

  on dnElements MouseUp arg do
  (
    if LOCselectedLVitem != 0 then
    (
      if arg.button == DYNdnmouseClass.right then
      (
        DYNFUNelementMenu()
        if LOCelementMenu != undefined then popupMenu LOCelementMenu
      )
    )
  )

  --- ByElement Params
  on SPDYNhOffEnd       entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNhOffEnd       changed arg do
  (
    DYNsweptObjects.DYNFUNmodifySOSelemParam "phoe" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"
    /* Update Vertical Offset Depending On Current CrossFall Setting */
    if CBDYNuseXfallEnd.checked then
    (
      if arg >= 0.0 then SPDYNvOffEnd.value = SPDYNxFallEnd.value * arg
      if arg  < 0.0 then SPDYNvOffEnd.value = SPDYNxFallEnd.value * arg * -1
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" LOCselectedLVitem SPDYNvOffEnd.value DYNsweptObjects "DYNsweptObjects"
    )
    else
    (
      if arg > 0.0 then SPDYNxFallEnd.value = (SPDYNvOffEnd.value / arg)
      if arg < 0.0 then SPDYNxFallEnd.value = (SPDYNvOffEnd.value / arg) * -1
    )
  )

  on SPDYNhOffStart     entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNhOffStart     changed arg do
  (
    DYNsweptObjects.DYNFUNmodifySOSelemParam "phos" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"
    /* Update Vertical Offset Depending On Current CrossFall Setting */
    if CBDYNuseXfallStart.checked then
    (
      if arg >= 0.0 then SPDYNvOffStart.value = SPDYNxFallStart.value * arg
      if arg  < 0.0 then SPDYNvOffStart.value = SPDYNxFallStart.value * arg * -1
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pvos" LOCselectedLVitem SPDYNvOffStart.value DYNsweptObjects "DYNsweptObjects"
    )
    else
    (
      if arg > 0.0 then SPDYNxFallStart.value = (SPDYNvOffEnd.value / arg)
      if arg < 0.0 then SPDYNxFallStart.value = (SPDYNvOffEnd.value / arg) * -1
    )
    /* Update End Offsets if Start/End Lock is active */
    if CBDYNlockHorOff.checked then
    (
      DYNsweptObjects.DYNFUNmodifySOSelemParam "phoe" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"
      SPDYNhOffEnd.value = arg
      if CBDYNuseXfallEnd.checked then
      (
        /* Update End Vertical Offset Depending On Current CrossFall Setting */
        if arg >= 0.0 then SPDYNvOffEnd.value = SPDYNxFallEnd.value * arg
        if arg  < 0.0 then SPDYNvOffEnd.value = SPDYNxFallEnd.value * arg * -1
        DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" LOCselectedLVitem SPDYNvOffEnd.value DYNsweptObjects "DYNsweptObjects"
      )
      else
      (
        if SPDYNhOffEnd.value > 0.0 then SPDYNxFallEnd.value = (SPDYNvOffEnd.value / SPDYNhOffEnd.value)
        if SPDYNhOffEnd.value < 0.0 then SPDYNxFallEnd.value = (SPDYNvOffEnd.value / SPDYNhOffEnd.value) * -1
      )
    )
  )

  on SPDYNvOffEnd       entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNvOffEnd       changed arg do
  (
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"

    if CBDYNuseXfallEnd.checked and SPDYNxFallEnd.value != 0.0 then
    (
      /* Update H.Offset Display Controls */
      SPDYNhOffEnd.value = arg / SPDYNxFallEnd.value
      DYNsweptObjects.DYNFUNmodifySOSelemParam "phoe" LOCselectedLVitem SPDYNhOffEnd.value DYNsweptObjects "DYNsweptObjects"
    )
    else
    (
      /* Update CrossFall Display Controls */
      if SPDYNhOffEnd.value > 0.0 then SPDYNxFallEnd.value = (arg / SPDYNhOffEnd.value)
      if SPDYNhOffEnd.value < 0.0 then SPDYNxFallEnd.value = (arg / SPDYNhOffEnd.value) * -1
    )
  )
  on SPDYNvOffStart     entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNvOffStart     changed arg do
  (
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pvos" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"
    if CBDYNuseXfallStart.checked and SPDYNxFallStart.value != 0.0 then
    (
      /* Update H.Offset Display Controls */
      SPDYNhOffStart.value = arg / SPDYNxFallStart.value
      DYNsweptObjects.DYNFUNmodifySOSelemParam "phos" LOCselectedLVitem SPDYNhOffStart.value DYNsweptObjects "DYNsweptObjects"
    )
    else
    (
      /* Update CrossFall Display Controls */
      if SPDYNhOffStart.value > 0.0 then SPDYNxFallStart.value = (arg / SPDYNhOffStart.value)
      if SPDYNhOffStart.value < 0.0 then SPDYNxFallStart.value = (arg / SPDYNhOffStart.value) * -1
    )

    /* Update End Offsets if Start/End Lock is active */
    if CBDYNlockVerOff.checked then
    (
      SPDYNvOffEnd.value   = arg
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"
      if CBDYNuseXfallEnd.checked and SPDYNxFallEnd.value != 0.0 then
      (
        /* Update H.Offset Display Controls */
        SPDYNhOffEnd.value = arg / SPDYNxFallEnd.value
        DYNsweptObjects.DYNFUNmodifySOSelemParam "phoe" LOCselectedLVitem SPDYNhOffEnd.value DYNsweptObjects "DYNsweptObjects"
      )
      else
      (
        /* Update CrossFall Display Controls */
        SPDYNxFallEnd.value  = SPDYNxFallStart.value
      )
    )
  )

  on SPDYNxFallStart    entered     do
  (
    DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  )
  on SPDYNxFallStart    changed arg do
  (
    SPDYNvOffStart.value = if SPDYNhOffStart.value > 0.0 then (arg * SPDYNhOffStart.value) else (arg * SPDYNhOffStart.value * -1)
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pvos" LOCselectedLVitem SPDYNvOffStart.value DYNsweptObjects "DYNsweptObjects"
    if CBDYNlockVerOff.checked == true then
    (
      SPDYNvOffEnd.value = SPDYNvOffStart.value
      DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" LOCselectedLVitem SPDYNvOffEnd.value DYNsweptObjects "DYNsweptObjects"
      SPDYNxFallEnd.value = arg
    )
  )

  on SPDYNxFallEnd      entered     do
  (
    DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  )
  on SPDYNxFallEnd      changed arg do
  (
    SPDYNvOffEnd.value = if SPDYNhOffEnd.value > 0.0 then arg * SPDYNhOffEnd.value else arg * SPDYNhOffEnd.value * -1
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pvoe" LOCselectedLVitem SPDYNvOffEnd.value DYNsweptObjects "DYNsweptObjects"
  )

  on SPDYNsmoothGroup   entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNsmoothGroup   changed arg do DYNsweptObjects.DYNFUNmodifySOSelemParam "psmg" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"

  on SPDYNvRepeat       entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNvRepeat       changed arg do DYNsweptObjects.DYNFUNmodifySOSelemParam "pvre" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"

  on SPDYNuRepeat       entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNuRepeat       changed arg do DYNsweptObjects.DYNFUNmodifySOSelemParam "pure" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"

  on SPDYNuvRotation    entered     do DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  on SPDYNuvRotation    changed arg do DYNsweptObjects.DYNFUNmodifySOSelemParam "prot" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"

  on BUDYNresetVtile pressed do
  (
    SPDYNvRepeat.value = LOCdefElemField01
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pvre" LOCselectedLVitem SPDYNvRepeat.value DYNsweptObjects "DYNsweptObjects"
    DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  )

  on BUDYNresetUtile pressed do
  (
    SPDYNuRepeat.value = LOCdefElemField02
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pure" LOCselectedLVitem SPDYNuRepeat.value DYNsweptObjects "DYNsweptObjects"
    DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  )

  on BUDYNresetUVrot pressed do
  (
    SPDYNuvRotation.value = LOCdefElemField03
    DYNsweptObjects.DYNFUNmodifySOSelemParam "prot" LOCselectedLVitem SPDYNuvRotation.value DYNsweptObjects "DYNsweptObjects"
    DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  )

  on BUDYNresetSmooth pressed do
  (
    --- Choose Unused Smooth Group
    local LOCnewSmoothGroup = 0
    local LOCsmgBitArray = #{};  LOCsmgBitArray.count = 32
    for i in LOCsosElemArray do (if i[6] != 0 then LOCsmgBitArray[i[6]] = true)
    for i = 32 to 1 by -1 do if not LOCsmgBitArray[i] then LOCnewSmoothGroup = i


    --- Set New Smooth Group
    SPDYNsmoothGroup.value = LOCnewSmoothGroup
    DYNsweptObjects.DYNFUNmodifySOSelemParam "psmg" LOCselectedLVitem LOCnewSmoothGroup DYNsweptObjects "DYNsweptObjects"
    DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  )

  on DDDYNelemMat      selected arg do
  (
    LOCdefaultSpanCloseCapElem[4] = if CKDYNelemFlip.checked then (arg * -1) else arg
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pmid" LOCselectedLVitem LOCdefaultSpanCloseCapElem[4] DYNsweptObjects "DYNsweptObjects"
    DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection CKDYNelemFlip.checked
  )

  on CKDYNelemMatOn    changed arg do
  (
    local LOCdefaultMatID = if DDDYNelemMat.selection == 0 then LOCdefaultSpanCloseCapElem[4] else DDDYNelemMat.selection
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pmid" LOCselectedLVitem (if arg then LOCdefaultMatID else 0) DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem (if arg then LOCdefaultMatID else 0) false
    DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
  )

  on CKDYNelemFlip     changed arg do
  (
    LOCdefaultSpanCloseCapElem[4] = if arg then (DDDYNelemMat.selection * -1) else DDDYNelemMat.selection
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pmid" LOCselectedLVitem (if arg then (DDDYNelemMat.selection * -1) else DDDYNelemMat.selection) DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNupdateSOSelementArrayItem DYNsweptObjects LOCselectedLVitem DDDYNelemMat.selection arg
  )

  on CKDYNinherited  changed arg do
  (
    DYNsweptObjects.DYNFUNmodifySOSelemParam "pinm" LOCselectedLVitem arg DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNwriteSOSelementArray LOCobjMod1.total DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
  )

  on CBDYNlockHorOff   changed arg do
  (
    DYNsweptObjects.DYNFUNvariableOffsets arg LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNwriteSOSelementArray LOCobjMod1.total DYNsweptObjects "DYNsweptObjects"
  )

  on CBDYNlockVerOff   changed arg do
  (
    DYNsweptObjects.DYNFUNvariableOffsets arg LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
    DYNsweptObjects.DYNFUNwriteSOSelementArray LOCobjMod1.total DYNsweptObjects "DYNsweptObjects"
  )

  on CBDYNuseXfallStart changed arg do
  (
    if CBDYNlockVerOff.checked then CBDYNuseXfallEnd.checked = arg
    LOCxFallLockArray[LOCselectedLVitem] = arg
  )

  on CBDYNuseXfallEnd changed arg do
  (
    if CBDYNlockVerOff.checked then CBDYNuseXfallStart.checked = arg
    LOCxFallLockArray[LOCselectedLVitem] = arg
  )

  --- Span/Close/Cap Params
  on DDDYNspanMatID    selected arg do (LOCobjMod1.spanMatID    = if CKDYNflipSpanning.checked then (arg * -1) else (arg); if LOCobjMod1.spanMatID != 0 then LOCdefaultSpanCloseCapElem[1] = LOCobjMod1.spanMatID; LOCsosGlobalArray[7] = LOCobjMod1.spanMatID; if LOCselectedLVitem != 0 then BUDYNsave.enabled = true)
  on CKDYNflipSpanning changed  arg do (LOCobjMod1.spanMatID    = if arg then (DDDYNspanMatID.selection * -1) else (DDDYNspanMatID.selection); if LOCobjMod1.spanMatID != 0 then LOCdefaultSpanCloseCapElem[1] = LOCobjMod1.spanMatID; LOCsosGlobalArray[7] = LOCobjMod1.spanMatID; if LOCselectedLVitem != 0 then BUDYNsave.enabled = true)
  on CKDYNspanning     changed  arg do (LOCsosGlobalArray[7]   = LOCobjMod1.spanMatID = if arg then LOCdefaultSpanCloseCapElem[1] else 0; DYNsweptObjects.DYNFUNcloseSpanSettings DYNsweptObjects)

  on DDDYNcloseMatID   selected arg do (LOCobjMod1.closingMatID = if CKDYNflipClosing.checked then (arg * -1) else (arg); if LOCobjMod1.closingMatID != 0 then LOCdefaultSpanCloseCapElem[2] = LOCobjMod1.closingMatID; LOCsosGlobalArray[8] = LOCobjMod1.closingMatID; if LOCselectedLVitem != 0 then BUDYNsave.enabled = true)
  on CKDYNflipClosing  changed  arg do (LOCobjMod1.closingMatID = if arg then (DDDYNcloseMatID.selection * -1) else (DDDYNcloseMatID.selection); if LOCobjMod1.closingMatID != 0 then LOCdefaultSpanCloseCapElem[2] = LOCobjMod1.closingMatID; LOCsosGlobalArray[8] = LOCobjMod1.closingMatID; if LOCselectedLVitem != 0 then BUDYNsave.enabled = true)
  on CKDYNclosing      changed  arg do (LOCsosGlobalArray[8]   = LOCobjMod1.closingMatID = if arg then LOCdefaultSpanCloseCapElem[2] else 0; DYNsweptObjects.DYNFUNcloseSpanSettings DYNsweptObjects)

  on DDDYNcapMatID     selected arg do (LOCobjMod1.capMatID     = if CKDYNflipCapping.checked then (arg * -1) else (arg); if LOCobjMod1.capMatID != 0 then LOCdefaultSpanCloseCapElem[3] = LOCobjMod1.capmatid; LOCsosGlobalArray[9] = LOCobjMod1.capmatid; if LOCselectedLVitem != 0 then BUDYNsave.enabled = true)
  on CKDYNflipCapping  changed  arg do (LOCobjMod1.capMatID     = if arg then (DDDYNcapMatID.selection * -1) else (DDDYNcapMatID.selection); if LOCobjMod1.capMatid != 0 then LOCdefaultSpanCloseCapElem[3] = LOCobjMod1.capmatid; LOCsosGlobalArray[9] = LOCobjMod1.capmatid; if LOCselectedLVitem != 0 then BUDYNsave.enabled = true)
  on CKDYNcapping      changed  arg do (LOCsosGlobalArray[9]   = LOCobjMod1.capMatID = if arg then LOCdefaultSpanCloseCapElem[3] else 0; DYNsweptObjects.DYNFUNcloseSpanSettings DYNsweptObjects)

  on CKDYNuseGlobalUV   changed arg do
  (
    LOCsosGlobalArray[3] = -LOCsosGlobalArray[3]
    if arg then
    (
      for i = 1 to LOCsosElemArray.count do
      (
        LOCsosElemArray[i][1] = (if LOCsosGlobalArray[3] < 0 then (LOCsosGlobalArray[3] * -1) else (LOCsosGlobalArray[3]))
        LOCsosElemArray[i][2] = LOCsosGlobalArray[6]
        LOCsosElemArray[i][3] = LOCsosGlobalArray[4]
      )
    )
    DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"

    --- Update AppData
    for i in LOCobjArray do setAppData i 426 (if arg then "1" else "0")
  )

  on SPDYNvRepGlobal   entered      do (if LOCselectedLVitem != 0 then BUDYNsave.enabled = true; if CKDYNuseGlobalUV.checked then DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects")
  on SPDYNvRepGlobal   changed  arg do
  (
    LOCobjMod1.spanVrep = LOCobjMod1.closingVrep = arg
    LOCsosGlobalArray[3] = if CKDYNuseGlobalUV.checked then -arg else arg
    if CKDYNuseGlobalUV.checked then (for i = 1 to LOCsosElemArray.count do (LOCsosElemArray[i][1] = arg; DYNFUNmodifySOSelemParam "pvre" i arg DYNsweptObjects "DYNsweptObjects"))
  )

  on SPDYNuRepGlobal   entered      do (if LOCselectedLVitem != 0 then BUDYNsave.enabled = true; if CKDYNuseGlobalUV.checked then DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects")
  on SPDYNuRepGlobal   changed  arg do
  (
    LOCobjMod1.spanUrep = LOCobjMod1.closingUrep = arg
    LOCsosGlobalArray[6] = arg
    if CKDYNuseGlobalUV.checked then (for i = 1 to LOCsosElemArray.count do (LOCsosElemArray[i][2] = arg; DYNFUNmodifySOSelemParam "pure" i arg DYNsweptObjects "DYNsweptObjects"))
  )

  on SPDYNuvRotGlobal  entered      do (if LOCselectedLVitem != 0 then BUDYNsave.enabled = true; if CKDYNuseGlobalUV.checked then DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects")
  on SPDYNuvRotGlobal  changed  arg do
  (
    LOCobjMod1.spanRot  = LOCobjMod1.closingRot  = LOCsosGlobalArray[4] = arg
    if CKDYNuseGlobalUV.checked then (for i = 1 to LOCsosElemArray.count do (LOCsosElemArray[i][3] = arg; DYNFUNmodifySOSelemParam "prot" i arg DYNsweptObjects "DYNsweptObjects"))
  )

  on BUDYNresetVGlobal pressed do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled = true
    LOCsosGlobalArray[3] = if CKDYNuseGlobalUV.checked then -DYNsosVtileDefault else DYNsosVtileDefault
    SPDYNvRepGlobal.value = LOCobjMod1.spanVrep = LOCobjMod1.closingVrep = DYNsosVtileDefault
    if CKDYNuseGlobalUV.checked then (for i = 1 to LOCsosElemArray.count do (LOCsosElemArray[i][1] = DYNsosVtileDefault; DYNFUNmodifySOSelemParam "pvre" i DYNsosVtileDefault DYNsweptObjects "DYNsweptObjects"))
    if CKDYNuseGlobalUV.checked then DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
  )
  on BUDYNresetUGlobal pressed do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled = true
    SPDYNuRepGlobal.value = LOCobjMod1.spanUrep = LOCobjMod1.closingUrep = LOCsosGlobalArray[6] = DYNsosUtileDefault
    if CKDYNuseGlobalUV.checked then (for i = 1 to LOCsosElemArray.count do (LOCsosElemArray[i][2] = DYNsosUtileDefault; DYNFUNmodifySOSelemParam "pure" i DYNsosUtileDefault DYNsweptObjects "DYNsweptObjects"))
    if CKDYNuseGlobalUV.checked then DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
  )
  on BUDYNresetRotGlobal pressed do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled = true
    SPDYNuvRotGlobal.value = LOCobjMod1.spanRot  = LOCobjMod1.closingRot  = LOCsosGlobalArray[4] = 0.0
    if CKDYNuseGlobalUV.checked then (for i = 1 to LOCsosElemArray.count do (LOCsosElemArray[i][3] = 0.0; DYNFUNmodifySOSelemParam "prot" i 0.0 DYNsweptObjects "DYNsweptObjects"))
    if CKDYNuseGlobalUV.checked then DYNsweptObjects.DYNFUNupdateSOSelementList LOCselectedLVitem DYNsweptObjects "DYNsweptObjects"
  )

  on CKDYNelemMirror   changed  arg do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled     = true
    LOCobjMod1.mirror     = arg
    LOCsosGlobalArray[2]  = arg
  )

  on RBDYNelemSide changed arg do
  (
    if arg == 1 then LOCobjMod1.side = 0
    if arg == 2 then LOCobjMod1.side = -1
    if arg == 3 then LOCobjMod1.side = 1
    LOCsosGlobalArray[1]    = LOCobjMod1.side
    DYNsweptObjects.DYNFUNcloseSpanSettings DYNsweptObjects
  )

  on SPDYNspacing changed arg do
  (
    LOCobjMod1.spacing       = arg
    LOCobjMod2.divisions     = arg
  )
  on SPDYNspacing entered do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled = true
    LOCsosGlobalArray[10] = if LOCobjMod1.type == 0 then SPDYNspacing.value else -SPDYNspacing.value
  )

  on SPDYNskew changed arg do
  (
    LOCobjMod1.CapRot = arg
  )
  on SPDYNskew entered do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled = true
    LOCsosGlobalArray[11] = SPDYNskew.value
  )

  on RBDYNmultiSpline changed arg do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled = true
    LOCobjMod1.splineIndex = arg - 2
    LOCsosGlobalArray[5]   = arg - 2
    DYNsweptObjects.DYNFUNcloseSpanSettings DYNsweptObjects
    DYNsweptObjects.DYNFUNsosInterpSettings LOCobjMod1 LOCobjMod2 DYNsweptObjects

    for i in LOCobjArray do
    (
      if LOCobjMod1.splineIndex == 0 then (addModifier i LOCobjMod2) else (if (CVGetMod i Civil_View_Divide_Spline) != undefined then deleteModifier i (CVGetMod i Civil_View_Divide_Spline))
    )
  )

  on RBDYNinterpType changed arg do
  (
    if LOCselectedLVitem != 0 then BUDYNsave.enabled = true
    LOCobjMod1.type          = arg - 1
    LOCobjMod1.spacing       = SPDYNspacing.value
    LOCobjMod2.divisions     = SPDYNspacing.value
    LOCsosGlobalArray[10]    = if LOCobjMod1.type == 0 then SPDYNspacing.value else -SPDYNspacing.value
    DYNsweptObjects.DYNFUNsosInterpSettings LOCobjMod1 LOCobjMod2 DYNsweptObjects
  )

  on BUDYNmaterial pressed do
  (
    local LOCchoices   = #(DYNmatNameSurfaces, DYNmatNameRails)
    local arg = DYNFUNdisplayDropDown DYNuiResourcesTitlebars[36] DYNuiResourcesLabels[453] LOCchoices (findItem LOCchoices LOCmatName)
    LOCmatName = LOCchoices[arg]

    --- DIsplay Channel Names For New Material Selection
    DYNFUNdisplayMatList LOCmatName

    --- Assign New Material Selection
    if LOCobjArray.count > 0 then
    (
      if arg == 1 then (LOCobjArray.material = if sceneMaterials[DYNmatNameSurfaces] != undefined then sceneMaterials[DYNmatNameSurfaces] else (DYNFUNmakeCivilViewSurfaces (DYNglobalMapsPath + DYNfolderNameSurfaceMaps + "\\")))
      if arg == 2 then (LOCobjArray.material = if sceneMaterials[DYNmatNameRails]    != undefined then sceneMaterials[DYNmatNameRails] else (DYNFUNmakeCivilViewRails (DYNcountryPath + DYNfolderNameMatLibs + "\\" + DYNfolderNameRailMaps + "\\")))
    )
  )

  --- Non Common Controls
  on BUDYNokok pressed do
  (
    --- Check to see if style has been saved
    if BUDYNsave.enabled == true then
    (
      local LOCstate
      LOCstate = yesNoCancelBox DYNuiResourcesQueries[3] title:DYNuiResourcesTitlebars[3] beep:false
      if LOCstate == #yes then (DYNFUNsaveSOSfile LOCsosGlobalArray LOCsosElemArray DYNsweptObjects; BUDYNsave.enabled = false; destroyDialog DYNsweptObjects)
      if LOCstate == #no  then (BUDYNsave.enabled = false; destroyDialog DYNsweptObjects)
    )
    else
    (
      if querybox DYNuiResourcesQueries[6] title:DYNuiResourcesTitlebars[2] then destroyDialog DYNsweptObjects
    )
  )

  on BUDYNcanc pressed do
  (
    --- Check to see if style has been saved
    if BUDYNsave.enabled == true then
    (
      local LOCstate
      LOCstate = yesNoCancelBox DYNuiResourcesQueries[3] title:DYNuiResourcesTitlebars[3] beep:false
      if LOCstate == #yes then (DYNFUNsaveSOSfile LOCsosGlobalArray LOCsosElemArray DYNsweptObjects; BUDYNsave.enabled = false; destroyDialog DYNsweptObjects)
      if LOCstate == #no  then (BUDYNsave.enabled = false; destroyDialog DYNsweptObjects)
    )
    else
    (
      if querybox DYNuiResourcesQueries[6] title:DYNuiResourcesTitlebars[2] then destroyDialog DYNsweptObjects
    )
  )

  on BUDYNhelp pressed do DYNFUNopenHelp 13215 -- id_cv_swept_object_style_editor

  on BUDYNreset pressed do
  (
    if doesFileExist LOCsosStyle then
    (
      if (queryBox (DYNuiResourcesQueries[8]) beep:false) then
      (
        local LOCproceedSwitch = DYNFUNsosPreFlight LOCsosStyle
        if LOCproceedSwitch == true then
        (
          BUDYNsave.enabled  = false
          LOCsosPath         = LOCsosStyle
          LOCsosGlobalArray  = (DYNFUNparsePARAMfile LOCsosStyle "2000")[1]
          append LOCsosGlobalArray (DYNFUNparsePARAMfile LOCsosStyle "2010")[1][1]
          LOCsosElemArray    = DYNFUNparsePARAMfile LOCsosStyle "2001"
          LOCxFallLockArray.count = LOCsosElemArray.count; for i = 1 to LOCxFallLockArray.count do LOCxFallLockArray[i] = false
          DYNsweptObjects.DYNFUNreadSOSelementArray LOCobjMod1 LOCsosElemArray.count DYNsweptObjects "DYNsweptObjects"
         )
        else
        (
          messagebox (DYNuiResourcesErrorsWarnings[76]) title:DYNuiResourcesTitlebars[1]
        )
      )
    )
  )
)
--
--  Copyright 2011 Autodesk, Inc. All rights reserved.
--
rollout DYNgrailObjects ""
(
  ---SECTION 1 - SET UP LOCAL VARIABLES---
  local LOCelementMenu
  local LOCrosPath
  local LOCrosStyle           = ""
  local LOCrosStyleContents   = #()
  local LOCrosStyleBuffer     = #()
  local LOCselectedLVitem     = 0
  local LOCobjHandles         = #()
  local LOCelemBuffer         = #()
  local LOCmatIDarray         = #()
  local LOCholdAllowMultRails = false
  local LOCresourceKitMode    = 1
  local LOCallowDnSelection   = true

  ---SECTION 2 - DEFINE LOCAL FUNCTIONS---

  --- Function to display a right-click menu over style element list
  fn DYNFUNelementMenu =
  (
    DYNgrailObjects.LOCelementMenu = undefined
    rcmenu LOCelementMenu
    (
      --- Local Variables

      --- Local Filter Functions

      --- Menu Items
      menuItem  MNDYNadd        checked:false
      separator MNDYNseparator1
      menuItem  MNDYNcut        checked:false
      menuItem  MNDYNcopy       checked:false
      menuItem  MNDYNpaste      checked:false
      separator MNDYNseparator2
      menuItem  MNDYNremove     checked:false

      on LOCelementMenu open do
      (
        MNDYNadd.text     = DYNuiResourcesMenus[32]
        MNDYNcut.text     = DYNuiResourcesMenus[33]
        MNDYNcopy.text    = DYNuiResourcesMenus[34]
        MNDYNpaste.text   = DYNuiResourcesMenus[35]
        MNDYNremove.text  = DYNuiResourcesMenus[10]

        MNDYNpaste.enabled = if DYNgrailObjects.LOCelemBuffer.count == 0 then false else true
      )

      on MNDYNadd picked do
      (
        DYNgrailObjects.DYNFUNaddElementToROSstyle()
        setFocus DYNgrailObjects.dnElements
      )

      on MNDYNcut picked do
      (
        local LOCselectedIndex = DYNgrailObjects.dnElements.selectedItems.item[0].index + 1
        DYNgrailObjects.BUDYNpaste.enabled  = true
        DYNgrailObjects.LOCelemBuffer.count = 40

        for i = 1 to DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex].count do
        (
          if classOf DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex][i] != BooleanClass then
          (
            DYNgrailObjects.LOCelemBuffer[i] = copy DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex][i]
          )
          else
          (
            DYNgrailObjects.LOCelemBuffer[i] = if DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex][i] then true else false
          )
        )
        DYNgrailObjects.DYNFUNdeleteElementFromROSstyle()
        setFocus DYNgrailObjects.dnElements
      )

      on MNDYNcopy picked do
      (
        local LOCselectedIndex = DYNgrailObjects.dnElements.selectedItems.item[0].index + 1
        DYNgrailObjects.BUDYNpaste.enabled = true
        DYNgrailObjects.LOCelemBuffer.count = 40

        for i = 1 to DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex].count do
        (
          if classOf DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex][i] != BooleanClass then
          (
            DYNgrailObjects.LOCelemBuffer[i] = copy DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex][i]
          )
          else
          (
            DYNgrailObjects.LOCelemBuffer[i] = if DYNgrailObjects.LOCrosStyleContents[LOCselectedIndex][i] then true else false
          )
        )
        setFocus DYNgrailObjects.dnElements
      )

      on MNDYNpaste picked do
      (
        DYNgrailObjects.BUDYNsave.enabled  = true
        DYNgrailObjects.BUDYNup.enabled    = true
        DYNgrailObjects.BUDYNdown.enabled  = true
        DYNgrailObjects.BUDYNrem.enabled   = true
        DYNgrailObjects.BUDYNcut.enabled   = true
        DYNgrailObjects.BUDYNcopy.enabled  = true

        if DYNgrailObjects.dnElements.Items.count != 0 and DYNgrailObjects.LOCselectedLVitem != 0 then
        (
          insertItem #("","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","") DYNgrailObjects.LOCrosStyleContents DYNgrailObjects.LOCselectedLVitem
          for i = 1 to DYNgrailObjects.LOCrosStyleContents[DYNgrailObjects.LOCselectedLVitem].count do
          (
            if classOf DYNgrailObjects.LOCelemBuffer[i] != BooleanClass then
            (
              DYNgrailObjects.LOCrosStyleContents[DYNgrailObjects.LOCselectedLVitem][i] = copy DYNgrailObjects.LOCelemBuffer[i]
            )
            else
            (
              DYNgrailObjects.LOCrosStyleContents[DYNgrailObjects.LOCselectedLVitem][i] = if DYNgrailObjects.LOCelemBuffer[i] then true else false
            )
          )
          DYNgrailObjects.DYNFUNupdateElementList DYNgrailObjects.LOCselectedLVitem
        )
        else
        (
          append DYNgrailObjects.LOCrosStyleContents #("","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","","")
          for i = 1 to DYNgrailObjects.LOCrosStyleContents[DYNgrailObjects.LOCrosStyleContents.count].count do
          (
            if classOf DYNgrailObjects.LOCelemBuffer[i] != BooleanClass then
            (
              DYNgrailObjects.LOCrosStyleContents[DYNgrailObjects.LOCrosStyleContents.count][i] = copy DYNgrailObjects.LOCelemBuffer[i]
            )
            else
            (
              DYNgrailObjects.LOCrosStyleContents[DYNgrailObjects.LOCrosStyleContents.count][i] = if DYNgrailObjects.LOCelemBuffer[i] then true else false
            )
          )
          DYNgrailObjects.DYNFUNupdateElementList DYNgrailObjects.LOCrosStyleContents.count
        )
        setFocus DYNgrailObjects.dnElements
      )

      on MNDYNremove picked do
      (
        DYNgrailObjects.DYNFUNdeleteElementFromROSstyle()
        setFocus DYNgrailObjects.dnElements
      )
    )
    registerRightClickMenu DYNgrailObjects.LOCelementMenu
  )


  fn DYNFUNresizeROSeditor FUNnewSize =
  (
    local rollout_lvOffset = [0,0]
    if FUNnewSize.y < 386 then (FUNnewSize.y = 386; DYNGRailObjects.height = 386)
    if FUNnewSize.x < 695 then (FUNnewSize.x = 695; DYNGRailObjects.width  = 695)
    if FUNnewSize.y > 700 then (FUNnewSize.y = 700; DYNGRailObjects.height = 700)
    if FUNnewSize.x > 820 then (FUNnewSize.x = 820; DYNGRailObjects.width  = 820)
    rollout_lvOffset     = [205,208]

    local LOClvSize = FUNnewSize - rollout_lvOffset
    if LOClvSize.x <  490 then LOClvSize.x = 490
    if LOClvSize.y <  178 then LOClvSize.y = 178
    DYNGRailObjects.dnElements.width  = LOClvSize.x
    DYNGRailObjects.dnElements.height = LOClvSize.y

    --- Move Other Items 218
    DYNGRailObjects.GBDYNparent.pos.y       = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 5

    DYNGRailObjects.EDDYNobjectName.pos.y   = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 22
    DYNGRailObjects.PKDYNselect.pos.y       = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 44

    DYNGRailObjects.GBDYNglobal.pos.y       = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 5
    DYNGRailObjects.GBDYNglobal.width       = LOClvSize.x - 131
    DYNGRailObjects.CKDYNlockWidth.pos.y    = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 39
    DYNGRailObjects.LBDYNgWidthL.pos.y      = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 30
    DYNGRailObjects.SPDYNgWidthL.pos.y      = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 28
    DYNGRailObjects.LBDYNgWidthR.pos.y      = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 51
    DYNGRailObjects.SPDYNgWidthR.pos.y      = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 49

    DYNGRailObjects.LBDYNgOffsetX.pos.y     = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 30
    DYNGRailObjects.SPDYNgOffsetX.pos.y     = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 28
    DYNGRailObjects.LBDYNgOffsetZ.pos.y     = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 51
    DYNGRailObjects.SPDYNgOffsetZ.pos.y     = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 49

    DYNGRailObjects.LBDYNgHeight.pos.y      = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 72
    DYNGRailObjects.SPDYNgHeight.pos.y      = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 70

    DYNGRailObjects.CKDYNinstancing.pos.y   = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 73
    DYNGRailObjects.BUDYNmirror.pos.y       = LOClvSize.y + DYNGRailObjects.dnElements.pos.y + 28

    --- RIGHT PANEL GLOBALS
    DYNGRailObjects.CBDYNmult.pos.x         = LOClvSize.x + DYNGRailObjects.dnElements.pos.x + 121
    DYNGRailObjects.BUDYNreset.pos.x        = LOClvSize.x + DYNGRailObjects.dnElements.pos.x + 156
    DYNGRailObjects.GBDYNtab.pos.x          = LOClvSize.x + DYNGRailObjects.dnElements.pos.x + 9
    DYNGRailObjects.GBDYNtab.height         = FUNnewSize.y - 131
    DYNGRailObjects.dnTabCtrl.pos.x         = LOClvSize.x + DYNGRailObjects.dnElements.pos.x + 9
    DYNGRailObjects.LBtabDescription.pos.x  = LOClvSize.x + DYNGRailObjects.dnElements.pos.x + 14

    ---  Tabbed Panel Parameters
    DYNGRailObjects.DYNFUNchangeGrailUItab (DYNGRailObjects.dnTabCtrl.selectedTab.TabIndex + 1)

    --- Panel Footer
    DYNGRailObjects.BUDYNokok.pos.y          = FUNnewSize.y - 66
    DYNGRailObjects.BUDYNapply.pos.y         = FUNnewSize.y - 66
    DYNGRailObjects.BUDYNcanc.pos.y          = FUNnewSize.y - 66
    DYNGRailObjects.BUDYNhelp.pos.y          = FUNnewSize.y - 66

    DYNGRailObjects.BUDYNokok.pos.x          = FUNnewSize.x - 272
    DYNGRailObjects.BUDYNapply.pos.x         = FUNnewSize.x - 183
    DYNGRailObjects.BUDYNcanc.pos.x          = FUNnewSize.x - 95

    DYNGRailObjects.dnProgress.pos.y         = FUNnewSize.y - 38
    DYNGRailObjects.dnProgress.width         = FUNnewSize.x - 21
    DYNGRailObjects.dnStatus.pos.y           = FUNnewSize.y - 20
    DYNGRailObjects.dnStatus.width           = FUNnewSize.x - 11

    DYNdefRLsizeROS = FUNnewSize
  )

  fn DYNFUNchangeGrailUItab FUNtab =
  (
    local LOCoffset1, LOCoffset2, LOCoffset3, LOCoffset4
    LOCoffset1 = LOCoffset2 = LOCoffset3 = LOCoffset4 = 0
    if FUNtab == 1 then (LOCoffset1 = DYNGRailObjects.dnElements.width + DYNGRailObjects.dnElements.pos.x + 4; LOCoffset2 = LOCoffset3 = LOCoffset4 = -2000; DYNGRailObjects.LBtabDescription.text = DYNuiResourcesGroups[123])
    if FUNtab == 2 then (LOCoffset2 = DYNGRailObjects.dnElements.width + DYNGRailObjects.dnElements.pos.x + 4; LOCoffset1 = LOCoffset3 = LOCoffset4 = -2000; DYNGRailObjects.LBtabDescription.text = DYNuiResourcesGroups[124])
    if FUNtab == 3 then (LOCoffset3 = DYNGRailObjects.dnElements.width + DYNGRailObjects.dnElements.pos.x + 4; LOCoffset1 = LOCoffset2 = LOCoffset4 = -2000; DYNGRailObjects.LBtabDescription.text = DYNuiResourcesGroups[125])

    --- Post Params
    DYNGRailObjects.CKDYNposton.pos.x       = LOCoffset1 + 13
    DYNGRailObjects.LBDYNpostType.pos.x     = LOCoffset1 + 13
    DYNGRailObjects.DDDYNpostType.pos.x     = LOCoffset1 + 13
    DYNGRailObjects.CBDYNpostFlip.pos.x     = LOCoffset1 + 96
    DYNGRailObjects.CBDYNpostCapT.pos.x     = LOCoffset1 + 13
    DYNGRailObjects.CBDYNpostCapB.pos.x     = LOCoffset1 + 96
    DYNGRailObjects.LBDYNpostMat.pos.x      = LOCoffset1 + 13
    DYNGRailObjects.DDDYNpostMat.pos.x      = LOCoffset1 + 13
    DYNGRailObjects.LBDYNpostWidth.pos.x    = LOCoffset1 + 13
    DYNGRailObjects.SPDYNpostWidth.pos.x    = LOCoffset1 + 159
    DYNGRailObjects.SPDYNpostDepth.pos.x    = LOCoffset1 + 159
    DYNGRailObjects.LBDYNspacing.pos.x      = LOCoffset1 + 13
    DYNGRailObjects.SPDYNspacing.pos.x      = LOCoffset1 + 159
    DYNGRailObjects.LBDYNgroundDepth.pos.x  = LOCoffset1 + 13
    DYNGRailObjects.SPDYNgroundDepth.pos.x  = LOCoffset1 + 159

    --- Brace Params
    DYNGRailObjects.CKDYNbraceOn.pos.x      = LOCoffset2 + 13
    DYNGRailObjects.LBDYNbraceType.pos.x    = LOCoffset2 + 13
    DYNGRailObjects.DDDYNbraceType.pos.x    = LOCoffset2 + 13
    DYNGRailObjects.LBDYNbraceMat.pos.x     = LOCoffset2 + 13
    DYNGRailObjects.DDDYNbraceMat.pos.x     = LOCoffset2 + 13
    DYNGRailObjects.LBDYNbraceDepth.pos.x   = LOCoffset2 + 13
    DYNGRailObjects.SPDYNbraceDepth.pos.x   = LOCoffset2 + 159
    DYNGRailObjects.LBDYNbraceHeight.pos.x  = LOCoffset2 + 13
    DYNGRailObjects.SPDYNbraceHeight.pos.x  = LOCoffset2 + 159
    DYNGRailObjects.LBDYNbraceGap.pos.x     = LOCoffset2 + 13
    DYNGRailObjects.SPDYNbraceGap.pos.x     = LOCoffset2 + 159

    --- Rail Params
    DYNGRailObjects.CKDYNrailLeftOn.pos.x   = LOCoffset3 + 13
    DYNGRailObjects.CKDYNrailRightOn.pos.x  = LOCoffset3 + 92
    DYNGRailObjects.LBDYNrailType.pos.x     = LOCoffset3 + 13
    DYNGRailObjects.DDDYNrailType.pos.x     = LOCoffset3 + 13
    DYNGRailObjects.LBDYNrailMat.pos.x      = LOCoffset3 + 13
    DYNGRailObjects.DDDYNrailMat.pos.x      = LOCoffset3 + 13
    DYNGRailObjects.LBDYNrailVertical.pos.x = LOCoffset3 + 13
    DYNGRailObjects.SPDYNrailVertical.pos.x = LOCoffset3 + 159
    DYNGRailObjects.LBDYNrailWidth.pos.x    = LOCoffset3 + 13
    DYNGRailObjects.SPDYNrailWidth.pos.x    = LOCoffset3 + 159
    DYNGRailObjects.LBDYNrailHeight.pos.x   = LOCoffset3 + 13
    DYNGRailObjects.SPDYNrailHeight.pos.x   = LOCoffset3 + 159
    DYNGRailObjects.LBDYNgUVrepeat.pos.x    = LOCoffset3 + 13
    DYNGRailObjects.SPDYNgUVrepeat.pos.x    = LOCoffset3 + 159
  )

  fn DYNFUNenableControls FUNswitch =
  (
    DYNGRailObjects.dnTabCtrl.enabled         = FUNswitch
    DYNGRailObjects.CBDYNmult.enabled         = FUNswitch

    --- General Params
    DYNGRailObjects.EDDYNobjectName.enabled   = FUNswitch
    DYNGRailObjects.PKDYNselect.enabled       = FUNswitch
    DYNGRailObjects.GBDYNglobal.enabled       = FUNswitch
    DYNGRailObjects.CKDYNlockWidth.enabled    = FUNswitch
    DYNGRailObjects.LBDYNgWidthL.enabled      = FUNswitch
    DYNGRailObjects.SPDYNgWidthL.enabled      = FUNswitch
    DYNGRailObjects.LBDYNgWidthR.enabled      = FUNswitch
    DYNGRailObjects.SPDYNgWidthR.enabled      = FUNswitch
    DYNGRailObjects.LBDYNgOffsetX.enabled     = FUNswitch
    DYNGRailObjects.SPDYNgOffsetX.enabled     = FUNswitch
    DYNGRailObjects.LBDYNgOffsetZ.enabled     = FUNswitch
    DYNGRailObjects.SPDYNgOffsetZ.enabled     = FUNswitch
    DYNGRailObjects.LBDYNgHeight.enabled      = FUNswitch
    DYNGRailObjects.SPDYNgHeight.enabled      = FUNswitch
    DYNGRailObjects.CKDYNinstancing.enabled   = FUNswitch
    DYNGRailObjects.BUDYNmirror.enabled       = FUNswitch

    --- Post Params
    DYNGRailObjects.CKDYNposton.enabled       = FUNswitch
    DYNGRailObjects.LBDYNpostType.enabled     = FUNswitch
    DYNGRailObjects.DDDYNpostType.enabled     = FUNswitch
    DYNGRailObjects.CBDYNpostFlip.enabled     = FUNswitch
    DYNGRailObjects.CBDYNpostCapT.enabled     = FUNswitch
    DYNGRailObjects.CBDYNpostCapB.enabled     = FUNswitch
    DYNGRailObjects.LBDYNpostMat.enabled      = FUNswitch
    DYNGRailObjects.DDDYNpostMat.enabled      = FUNswitch
    DYNGRailObjects.LBDYNpostWidth.enabled    = FUNswitch
    DYNGRailObjects.SPDYNpostWidth.enabled    = FUNswitch
    DYNGRailObjects.SPDYNpostDepth.enabled    = FUNswitch
    DYNGRailObjects.LBDYNspacing.enabled      = FUNswitch
    DYNGRailObjects.SPDYNspacing.enabled      = FUNswitch
    DYNGRailObjects.LBDYNgroundDepth.enabled  = FUNswitch
    DYNGRailObjects.SPDYNgroundDepth.enabled  = FUNswitch

    --- Brace Params
    DYNGRailObjects.CKDYNbraceOn.enabled      = FUNswitch
    DYNGRailObjects.LBDYNbraceType.enabled    = FUNswitch
    DYNGRailObjects.DDDYNbraceType.enabled    = FUNswitch
    DYNGRailObjects.LBDYNbraceMat.enabled     = FUNswitch
    DYNGRailObjects.DDDYNbraceMat.enabled     = FUNswitch
    DYNGRailObjects.LBDYNbraceDepth.enabled   = FUNswitch
    DYNGRailObjects.SPDYNbraceDepth.enabled   = FUNswitch
    DYNGRailObjects.LBDYNbraceHeight.enabled  = FUNswitch
    DYNGRailObjects.SPDYNbraceHeight.enabled  = FUNswitch
    DYNGRailObjects.LBDYNbraceGap.enabled     = FUNswitch
    DYNGRailObjects.SPDYNbraceGap.enabled     = FUNswitch

    --- Rail Params
    DYNGRailObjects.CKDYNrailLeftOn.enabled   = FUNswitch
    DYNGRailObjects.CKDYNrailRightOn.enabled  = FUNswitch
    DYNGRailObjects.LBDYNrailType.enabled     = FUNswitch
    DYNGRailObjects.DDDYNrailType.enabled     = FUNswitch
    DYNGRailObjects.LBDYNrailMat.enabled      = FUNswitch
    DYNGRailObjects.DDDYNrailMat.enabled      = FUNswitch
    DYNGRailObjects.LBDYNrailVertical.enabled = FUNswitch
    DYNGRailObjects.SPDYNrailVertical.enabled = FUNswitch
    DYNGRailObjects.LBDYNrailWidth.enabled    = FUNswitch
    DYNGRailObjects.SPDYNrailWidth.enabled    = FUNswitch
    DYNGRailObjects.LBDYNrailHeight.enabled   = FUNswitch
    DYNGRailObjects.SPDYNrailHeight.enabled   = FUNswitch
    DYNGRailObjects.LBDYNgUVrepeat.enabled    = FUNswitch
    DYNGRailObjects.SPDYNgUVrepeat.enabled    = FUNswitch
  )

  fn DYNFUNaddElementToROSstyle =
  (
    local LOCdefaultElement = \
    #(\
      0.6,    0.4, 0.4,    "", false,  0.0, 0.0,   "",    "", DYNuiResourcesNodeNames[6], \ -- Opyion 5000
      true, false,   0, false,   3.0,  0.1, 0.1, 0.25, false,        1 , \ -- Opyion 5001
      true,    "",   1,    "",  0.01,  0.2, 0.1,   "",    "",        1 , \ -- Option 5002
      true,  true,   4,    "",  0.25, 0.05, 0.1,   "",   1.0,        2   \ -- Option 5003
    )

    DYNgRailObjects.BUDYNsave.enabled  = true
    DYNgRailObjects.BUDYNup.enabled    = true
    DYNgRailObjects.BUDYNdown.enabled  = true
    DYNgRailObjects.BUDYNrem.enabled   = true
    DYNgRailObjects.BUDYNcut.enabled   = true
    DYNgRailObjects.BUDYNcopy.enabled  = true

    if DYNgRailObjects.dnElements.Items.count != 0 and DYNgRailObjects.LOCselectedLVitem != 0 then
    (
      insertItem LOCdefaultElement DYNgRailObjects.LOCrosStyleContents (DYNgRailObjects.LOCselectedLVitem + 1)
      DYNgRailObjects.DYNFUNupdateElementList (DYNgRailObjects.LOCselectedLVitem + 1)
    )
    else
    (
      append DYNgRailObjects.LOCrosStyleContents LOCdefaultElement
      DYNgRailObjects.DYNFUNupdateElementList DYNgRailObjects.LOCrosStyleContents.count
    )
  )

  fn DYNFUNdeleteElementFromROSstyle =
  (
    if DYNgRailObjects.LOCselectedLVitem != 0 then
    (
      DYNgRailObjects.BUDYNsave.enabled = true
      deleteItem DYNgRailObjects.LOCrosStyleContents (DYNgRailObjects.dnElements.selectedItems.item[0].index + 1)
      if DYNgRailObjects.LOCselectedLVitem > DYNgRailObjects.LOCrosStyleContents.count then DYNgRailObjects.LOCselectedLVitem = DYNgRailObjects.LOCrosStyleContents.count
      DYNgRailObjects.DYNFUNupdateElementList DYNgRailObjects.LOCselectedLVitem
      if DYNgRailObjects.LOCrosStyleContents.count == 0 then
      (
        DYNgRailObjects.BUDYNsave.enabled  = false
        DYNgRailObjects.BUDYNup.enabled    = false
        DYNgRailObjects.BUDYNdown.enabled  = false
        DYNgRailObjects.BUDYNrem.enabled   = false
        DYNgRailObjects.BUDYNcut.enabled   = false
        DYNgRailObjects.BUDYNcopy.enabled  = false
      )
    )
  )

  fn DYNFUNdisplayROSelement FUNnewSelectedLVitem FUNdnLv =
  (
    if LOCrosStyleContents.count != 0 then
    (
      DYNgRailObjects.LOCselectedLVitem = FUNnewSelectedLVitem
      FUNdnLv.Items.item[(FUNnewSelectedLVitem - 1)].selected = true
      FUNdnLv.Items.item[(FUNnewSelectedLVitem - 1)].ensureVisible()

      --- Enable Rollout Controls
      DYNgRailObjects.DYNFUNenableControls true

      --- General Params
      DYNgRailObjects.GBDYNglobal.text        = DYNuiResourcesGroups[3] + " (" + DYNuiResourcesGroups[116] + " " + (FUNnewSelectedLVitem as string) + ")"
      DYNgRailObjects.EDDYNobjectName.text    = DYNgRailObjects.LOCrosStyleContents[FUNnewSelectedLVitem][10]
      DYNGRailObjects.CKDYNlockWidth.checked  = DYNgRailObjects.LOCrosStyleContents[FUNnewSelectedLVitem][2] == DYNgRailObjects.LOCrosStyleContents[FUNnewSelectedLVitem][3]
      DYNGRailObjects.SPDYNgWidthL.value      = DYNgRailObjects.LOCrosStyleContents[FUNnewSelectedLVitem][2]
      DYNGRailObjects.SPDYNgWidthR.value      = DYNgRailObjects.LOCrosStyleContents[FUNnewSelectedLVitem][3]
      DYNGRailObjects.SPDYNgOffsetX.value     = DYNgRailObjects.LOCrosStyleContents[FUNnewSelectedLVitem][7]
      DYNGRailObjects.SPDYNgOffsetZ.value     = DYNgRailO